/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.HZPinyin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BizPartnerUserEditPagePlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BizPartnerUserEditPagePlugin.class);
    public static final String ENTITY_BIZPARTNERUSER = "bos_bizpartneruser";
    public static final String PROP_BIZPARTNER = "bizpartner";
    public static final String PROP_ID = "id";
    public static final String PROP_ISADMIN = "isadmin";
    public static final String PROP_PHONE = "phone";
    public static final String PROP_EMAIL = "email";
    public static final String PROP_USER_NAME = "username";
    public static final String PROP_USER_FULL_NAME = "userfullname";
    private static final String NUMBER = "number";
    private static final String ID = "id";
    private static final String NAME = "name";
    private Map<String, String> userTypeNumberToId;
    public static final String OP_SAVE = "save";
    public static final String OPERATE_SAVE = "kd.bos.entity.operate.Save";
    public static final String PGCACHE_BIZ_PARTNER_ISADMIN = "bizPartnerId_isAdmin";
    public static final String USER = "user";
    public static final String USER_TYPE = "usertype";
    public static final String TYPE = "type";
    private static final String ENTRY_USER_TYPE = "bos_usertype";
    private static final String USER_TYPE_ID_ADMIN = "7";
    private static final String USER_TYPE_VALIDATE_PASS = "user_type_validate_pass";
    private static final String KEY_OPERATE_OPTION_OR_CACHE = "isAdmin";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";

    public void registerListener(EventObject e) {
        BasedataEdit orgEdit;
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnsave"});
        BasedataEdit bizPartnerEdit = (BasedataEdit)this.getControl(PROP_BIZPARTNER);
        if (bizPartnerEdit != null) {
            bizPartnerEdit.addBeforeF7SelectListener(evt -> {
                DynamicObject userObj = (DynamicObject)this.getModel().getValue(USER);
                if (UserUtils.checkUserTypeCategory((DynamicObject)userObj, (String)"1")) {
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    List filters = showParameter.getListFilterParameter().getQFilters();
                    QFilter internalFilter = new QFilter("internal_company", "!=", (Object)0L);
                    filters.add(internalFilter);
                }
            });
        }
        if ((orgEdit = (BasedataEdit)this.getControl("org")) != null) {
            Long userId = RequestContext.get().getCurrUserId();
            orgEdit.addBeforeF7SelectListener(evt -> {
                HasPermOrgResult result = PermissionServiceHelper.getAdminChargeOrg((Long)userId, (String)"01");
                if (!result.hasAllOrgPerm()) {
                    List orgIds = result.getHasPermOrgs();
                    if (CollectionUtils.isEmpty((Collection)orgIds)) {
                        return;
                    }
                    ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgIds));
                }
            });
        }
    }

    private void initUserTypeMulCombo() {
        QFilter categoryFilter = new QFilter("category", "=", (Object)"2");
        QFilter visibleFilter = new QFilter("isvisible", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection typeList = QueryServiceHelper.query((String)ENTRY_USER_TYPE, (String)"id,name,enable", (QFilter[])new QFilter[]{categoryFilter, visibleFilter}, (String)NUMBER);
        if (typeList == null || typeList.isEmpty()) {
            return;
        }
        ComboEdit userTypeField = (ComboEdit)this.getControl(TYPE);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(typeList.size());
        for (DynamicObject obj : typeList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(obj.getString("id"));
            comboItem.setCaption(new LocaleString(obj.getString(NAME)));
            comboItem.setItemVisible(obj.getBoolean("enable"));
            propertyItems.add(comboItem);
        }
        userTypeField.setComboItems(propertyItems);
        this.getModel().setValue(TYPE, (Object)3);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String bizPartner = pageCache.get("bizPartner");
        if (StringUtils.isEmpty((CharSequence)bizPartner)) {
            return;
        }
        Long bizPartnerId = Long.valueOf(bizPartner);
        this.getModel().setValue(PROP_BIZPARTNER, (Object)bizPartnerId);
        this.setBizPartnerBySupplier();
    }

    public void afterBindData(EventObject e) {
        if (this.getPageCache().get("first") == null) {
            this.setTypeComboEdit();
            DynamicObject user = (DynamicObject)this.getModel().getValue(USER);
            if (user != null) {
                this.getModel().setValue(PROP_PHONE, user.get(PROP_PHONE));
                this.getModel().setValue(PROP_USER_NAME, user.get(NAME));
                this.getModel().setValue(PROP_EMAIL, user.get(PROP_EMAIL));
                this.getModel().setValue(PROP_USER_FULL_NAME, user.get(PROP_USER_NAME));
                this.getModel().setValue(TYPE, this.getModel().getValue("userType"));
            }
            this.getPageCache().put("first", "isFirst");
        }
        this.getModel().setDataChanged(false);
        boolean isAdmin = (Boolean)this.getModel().getValue(PROP_ISADMIN);
        if (isAdmin) {
            this.getPageCache().put(KEY_OPERATE_OPTION_OR_CACHE, "1");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject user = (DynamicObject)this.getModel().getValue(USER);
        if (null != user) {
            if (!this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{PROP_USER_FULL_NAME, PROP_USER_NAME});
            }
            this.getUserByPhoneOrEmail(e, user);
            return;
        }
        String name = this.getModel().getValue(PROP_USER_NAME).toString();
        if (StringUtils.isNotEmpty((CharSequence)name) && PROP_USER_NAME.equals(e.getProperty().getName())) {
            try {
                String fullPinyin = HZPinyin.getFullSpell((String)name, (String)"");
                String userFullName = UserOperationUtils.getUserNameByFullPinyin((long)0L, (String)fullPinyin, null);
                this.getModel().setValue(PROP_USER_FULL_NAME, (Object)userFullName);
            }
            catch (UnsupportedEncodingException ex) {
                logger.error("\u751f\u6210\u7528\u6237\u540d\u5931\u8d25\u3002", (Throwable)ex);
            }
            return;
        }
        this.setValue(e);
    }

    private void setValue(PropertyChangedArgs e) {
        DynamicObject newUser = this.getUserByPhoneOrEmail(e, null);
        if (newUser == null) {
            return;
        }
        this.getModel().setValue(USER, newUser.getPkValue());
        this.getModel().setValue(PROP_EMAIL, newUser.get(PROP_EMAIL));
        this.getModel().setValue(PROP_PHONE, newUser.get(PROP_PHONE));
        this.getModel().setValue(PROP_USER_NAME, newUser.get(NAME));
        this.getModel().setValue(PROP_USER_FULL_NAME, newUser.get(PROP_USER_NAME));
    }

    private DynamicObject getUserByPhoneOrEmail(PropertyChangedArgs e, DynamicObject user) {
        boolean isClearPhoneOrEmail;
        boolean sameEmailValue;
        String propertyName = e.getProperty().getName();
        if (!PROP_PHONE.equals(propertyName) && !PROP_EMAIL.equals(propertyName)) {
            return null;
        }
        Object phone = this.getModel().getValue(PROP_PHONE);
        Object email = this.getModel().getValue(PROP_EMAIL);
        if (StringUtils.isBlank((CharSequence)phone.toString()) && StringUtils.isBlank((CharSequence)email.toString())) {
            return null;
        }
        boolean samePhoneValue = user != null && PROP_PHONE.equals(propertyName) && phone.toString().equals(user.getString(PROP_PHONE));
        boolean bl = sameEmailValue = user != null && PROP_EMAIL.equals(propertyName) && email.toString().equals(user.getString(PROP_EMAIL));
        if (samePhoneValue || sameEmailValue) {
            return null;
        }
        boolean bl2 = isClearPhoneOrEmail = StringUtils.isEmpty((CharSequence)phone.toString()) && PROP_PHONE.equals(propertyName) || StringUtils.isEmpty((CharSequence)email.toString()) && PROP_EMAIL.equals(propertyName);
        if (isClearPhoneOrEmail) {
            return null;
        }
        QFilter filter = null;
        if (StringUtils.isNotEmpty((CharSequence)phone.toString()) && PROP_PHONE.equals(propertyName)) {
            filter = new QFilter(PROP_PHONE, "=", phone);
        } else if (StringUtils.isNotEmpty((CharSequence)email.toString()) && PROP_EMAIL.equals(propertyName)) {
            filter = new QFilter(PROP_EMAIL, "=", email);
        }
        QFilter enableQfilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_user", (String)"usertype,usertypes,email,phone,username,enable", (QFilter[])new QFilter[]{filter, enableQfilter});
        DynamicObject userObj = null;
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            List userTypes = UserUtils.getUserTypeByCategory((String)"2");
            userTypes.add(Long.valueOf("1"));
            block0: for (DynamicObject obj : dynamicObjects) {
                String[] userTypeIds;
                String userType = obj.getString(USER_TYPE);
                if (StringUtils.isBlank((CharSequence)userType)) {
                    userObj = obj;
                    break;
                }
                for (String userTypeId : userTypeIds = userType.split(",")) {
                    if (StringUtils.isBlank((CharSequence)userTypeId) || !userTypes.contains(Long.parseLong(userTypeId.trim()))) continue;
                    userObj = obj;
                    continue block0;
                }
            }
        }
        if (userObj == null) {
            this.getView().getPageCache().put(USER_TYPE_VALIDATE_PASS, Boolean.TRUE.toString());
            return null;
        }
        userObj = this.verifyUserInfo(userObj, phone.toString(), email.toString(), propertyName);
        return userObj;
    }

    private DynamicObject verifyUserInfo(DynamicObject user, String phone, String email, String propertyName) {
        String userType = user.getString(USER_TYPE);
        if (USER_TYPE_ID_ADMIN.equals(userType)) {
            this.clearUserValue(propertyName);
            if (StringUtils.isNotEmpty((CharSequence)phone)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u4e0d\u53ef\u6dfb\u52a0\u4e3a\u5546\u52a1\u4f19\u4f34\u7528\u6237\u3002", (String)"BizPartnerUserEditPagePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
            } else if (StringUtils.isNotEmpty((CharSequence)email)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u90ae\u7bb1\u5c5e\u4e8e\u7ba1\u7406\u5458\u90ae\u7bb1\u3002", (String)"BizPartnerUserEditPagePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
            }
            this.getView().getPageCache().put(USER_TYPE_VALIDATE_PASS, Boolean.FALSE.toString());
            return null;
        }
        this.getView().getPageCache().put(USER_TYPE_VALIDATE_PASS, Boolean.TRUE.toString());
        return user;
    }

    private void clearUserValue(String propertyName) {
        this.getModel().setValue(USER, null);
        if (PROP_PHONE.equals(propertyName)) {
            this.getModel().setValue(PROP_PHONE, null);
        } else {
            this.getModel().setValue(PROP_EMAIL, null);
        }
    }

    private void setTypeComboEdit() {
        this.initUserTypeMulCombo();
    }

    private void setBizPartnerBySupplier() {
        this.getModel().setValue(USER_TYPE, (Object)3);
        this.getModel().setValue(USER, null);
    }

    public void afterDoOperation(AfterDoOperationEventArgs adoe) {
        BillList billList;
        IFormView parentView;
        super.afterDoOperation(adoe);
        String objId = adoe.getOperateKey();
        if (objId.equals(OP_SAVE) && (parentView = this.getView().getParentView()) != null && (billList = (BillList)parentView.getControl("billlistap")) != null) {
            billList.refresh();
        }
    }

    private void setNotAdmin(Object bizPartnerUserId) {
        String bizPartnerIdIsAdmin = this.getPageCache().get(PGCACHE_BIZ_PARTNER_ISADMIN);
        if (StringUtils.isBlank((CharSequence)bizPartnerIdIsAdmin)) {
            return;
        }
        String[] arrStr = bizPartnerIdIsAdmin.split("_");
        Long bizPartnerIdId = Long.parseLong(arrStr[0]);
        if (!Boolean.parseBoolean(arrStr[1])) {
            return;
        }
        QFilter filter = new QFilter(PROP_BIZPARTNER, "=", (Object)bizPartnerIdId);
        filter.and("id", "<>", (Object)Long.parseLong(bizPartnerUserId.toString()));
        filter.and(PROP_ISADMIN, "=", (Object)Boolean.TRUE);
        ORM orm = ORM.create();
        DynamicObjectCollection doc = orm.query(ENTITY_BIZPARTNERUSER, filter.toArray());
        if (CollectionUtils.isEmpty((Collection)doc)) {
            return;
        }
        for (DynamicObject dynamicObject : doc) {
            dynamicObject.set(PROP_ISADMIN, (Object)Boolean.FALSE);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs bdoe) {
        FormOperate operate = (FormOperate)bdoe.getSource();
        OperateOption operateOption = operate.getOption();
        if (operateOption != null && operateOption.removeVariable("bizPartnerUserSaveConfirmed")) {
            return;
        }
        super.beforeDoOperation(bdoe);
        String userTypeValidatePass = this.getView().getPageCache().get(USER_TYPE_VALIDATE_PASS);
        if (!StringUtils.isEmpty((CharSequence)userTypeValidatePass) && !Boolean.parseBoolean(userTypeValidatePass)) {
            this.getView().getPageCache().put(USER_TYPE_VALIDATE_PASS, "");
            bdoe.setCancel(true);
            return;
        }
        String source = bdoe.getSource().getClass().getName();
        if (OPERATE_SAVE.equals(source)) {
            Object pkValue;
            boolean setOtherNotAdmin;
            Boolean isAdmin = (Boolean)this.getModel().getValue(PROP_ISADMIN);
            DynamicObject bizPartner = (DynamicObject)this.getModel().getValue(PROP_BIZPARTNER);
            if (bizPartner == null) {
                return;
            }
            Long bizPartnerId = (Long)bizPartner.get("id");
            if (Boolean.TRUE.equals(isAdmin) && (setOtherNotAdmin = Long.parseLong((pkValue = this.getModel().getDataEntity().getPkValue()).toString()) == 0L ? QueryServiceHelper.exists((String)ENTITY_BIZPARTNERUSER, (QFilter[])new QFilter[]{new QFilter(PROP_BIZPARTNER, "=", (Object)bizPartnerId), new QFilter(PROP_ISADMIN, "=", (Object)Boolean.TRUE)}) : QueryServiceHelper.exists((String)ENTITY_BIZPARTNERUSER, (QFilter[])new QFilter[]{new QFilter(PROP_BIZPARTNER, "=", (Object)bizPartnerId), new QFilter("id", "<>", (Object)Long.parseLong(pkValue.toString())), new QFilter(PROP_ISADMIN, "=", (Object)Boolean.TRUE)}))) {
                this.getPageCache().put(PGCACHE_BIZ_PARTNER_ISADMIN, bizPartnerId + "_" + isAdmin);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u5546\u52a1\u4f19\u4f34\u5df2\u5b58\u5728\u7ba1\u7406\u5458\uff0c\u662f\u5426\u8981\u66ff\u6362\u3002", (String)"BizPartnerUserEditPagePlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("setNotAdminConfirm", (IFormPlugin)this));
                bdoe.setCancel(true);
                return;
            }
            String isAdminCache = this.getPageCache().get(KEY_OPERATE_OPTION_OR_CACHE);
            if (kd.bos.util.StringUtils.isNotEmpty((String)isAdminCache)) {
                operate.getOption().setVariableValue(KEY_OPERATE_OPTION_OR_CACHE, "1");
            } else {
                operate.getOption().setVariableValue(KEY_OPERATE_OPTION_OR_CACHE, "0");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("setNotAdminConfirm") && mbce.getResult() == MessageBoxResult.Yes) {
            OperateOption option = OperateOption.create();
            option.setVariableValue(KEY_OPERATE_OPTION_OR_CACHE, "1");
            option.setVariableValue("bizPartnerUserSaveConfirmed", "1");
            OperationResult executeOperate = this.getView().invokeOperation(OP_SAVE, option);
            List successPkIds = executeOperate.getSuccessPkIds();
            if (successPkIds != null && !successPkIds.isEmpty()) {
                this.setNotAdmin(successPkIds.get(0));
                this.getModel().setDataChanged(false);
                BillList billList = (BillList)this.getView().getParentView().getControl("billlistap");
                if (billList != null) {
                    billList.refresh();
                }
                this.getView().close();
            } else {
                String errorMessage;
                try {
                    errorMessage = ((OperateErrorInfo)((ValidateResult)executeOperate.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage();
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6821\u9a8c\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
                    errorMessage = executeOperate.getMessage();
                }
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    List allErrorInfo = executeOperate.getAllErrorInfo();
                    if (!CollectionUtils.isEmpty((Collection)allErrorInfo)) {
                        errorMessage = ((OperateErrorInfo)allErrorInfo.get(0)).getMessage();
                    }
                    if (StringUtils.isBlank((CharSequence)errorMessage)) {
                        errorMessage = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BizPartnerUserEditPagePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    }
                }
                this.getView().showErrorNotification(errorMessage);
            }
        }
        this.getPageCache().remove(PGCACHE_BIZ_PARTNER_ISADMIN);
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        if (this.userTypeNumberToId == null) {
            Map userTypes = BusinessDataServiceHelper.loadFromCache((String)ENTRY_USER_TYPE, (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            if (userTypes.isEmpty()) {
                return;
            }
            this.userTypeNumberToId = new HashMap<String, String>(userTypes.size());
            for (Map.Entry entry : userTypes.entrySet()) {
                DynamicObject userType = (DynamicObject)entry.getValue();
                this.userTypeNumberToId.put(userType.getString(NUMBER), entry.getKey().toString());
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Object userType = this.getModel().getValue(TYPE);
        if (ObjectUtils.isEmpty((Object)userType) || this.userTypeNumberToId == null || this.userTypeNumberToId.isEmpty()) {
            return;
        }
        String[] types = userType.toString().split(",");
        StringJoiner validateType = new StringJoiner(",");
        for (String type : types) {
            if (StringUtils.isEmpty((CharSequence)type)) continue;
            String typeId = this.userTypeNumberToId.get(type);
            if (typeId == null) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u201c\u7c7b\u578b\u201d \u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u8be2\u4eba\u5458\u7c7b\u578b\u5217\u8868\uff0c\u586b\u5199\u6b63\u786e\u7684\u7f16\u7801\u3002", (String)"BizPartnerUserEditPagePlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            validateType.add(typeId);
        }
        this.getModel().setValue(TYPE, (Object)validateType.toString());
    }
}

