/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeBuildTreeNodeEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class BizPartnerUserListPlugin
extends AbstractTreeListPlugin {
    private static Log logger = LogFactory.getLog(BizPartnerUserListPlugin.class);
    public static final String BTN_NEW = "tblnew";
    public static final String BTN_DEL = "tbldel";
    public static final String PNL_TREEBTNLIST = "flexpanel_treebtn";
    private static final String BTN_NEWGROUP = "btnnew";
    private static final String BTN_EDITGROUP = "btnedit";
    private static final String BTN_DELGROUP = "btndel";
    private static final String BIZ_PARTNER_FILEDNAME = "bizpartner.id";
    private static final String KEY_IS_ADMIN = "isadmin";
    private static final String KEY_ENABLE = "enable";
    private static final String YES = "1";
    private static final String PARTNER_ENTITY = "bos_bizpartneruser";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";

    public void initialize() {
        TreeListModel treeModel;
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEWGROUP, BTN_EDITGROUP, BTN_DELGROUP});
        ITreeListView treeListView = this.getTreeListView();
        if (treeListView != null && (treeModel = (TreeListModel)treeListView.getTreeModel()) != null) {
            List treeFilter = treeModel.getTreeFilter();
            treeFilter.add(new QFilter(KEY_ENABLE, "=", (Object)YES));
            treeModel.setTreeFilter(treeFilter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAdminChargeOrg((Long)userId, (String)"01");
        if (!result.hasAllOrgPerm()) {
            List orgIds = result.getHasPermOrgs();
            if (CollectionUtils.isEmpty((Collection)orgIds)) {
                return;
            }
            QFilter orgQFilter = new QFilter("org", "in", (Object)orgIds);
            List extraUserId = PermissionServiceHelper.getAdminExtraUser((Long)userId);
            QFilter userQFilter = null;
            if (!CollectionUtils.isEmpty((Collection)extraUserId)) {
                userQFilter = new QFilter("user", "in", (Object)extraUserId);
            }
            if (userQFilter != null) {
                orgQFilter.or(userQFilter);
            }
            e.getQFilters().add(orgQFilter);
        }
    }

    public void beforeBuildTreeNode(BeforeBuildTreeNodeEvent e) {
        super.beforeBuildTreeNode(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (BTN_NEW.equals(evt.getItemKey())) {
            try {
                TreeView tv = (TreeView)this.getControl("treeview");
                if (null == tv) {
                    return;
                }
                String focusNodeId = tv.getTreeState().getFocusNodeId();
                if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(focusNodeId)) {
                    evt.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5546\u52a1\u4f19\u4f34\u3002", (String)"BizPartnerUserListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        } else if (BTN_DEL.equals(evt.getItemKey())) {
            this.deleteValidate(evt);
        }
    }

    private void deleteValidate(BeforeItemClickEvent evt) {
        try {
            TreeView tv = (TreeView)this.getControl("treeview");
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            QFilter adminFilter = new QFilter(KEY_IS_ADMIN, "=", (Object)Boolean.TRUE);
            QFilter bizpartnerFilter = new QFilter("bizpartner", "=", (Object)focusNodeId);
            QFilter[] qfilters = new QFilter[]{adminFilter, bizpartnerFilter};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)PARTNER_ENTITY, (String)"", (QFilter[])qfilters);
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] values = selectedRows.getPrimaryKeyValues();
            Object pkValue = dynamicObject.getPkValue();
            for (Object object : values) {
                if (!pkValue.equals(object)) continue;
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u80fd\u5220\u9664\u3002", (String)"BizPartnerUserListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
                break;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        this.getPageCache().remove("bizPartner");
        for (Map customFiter : customFiterList) {
            List bizPartnerIds;
            List fieldNames = (List)customFiter.get("FieldName");
            if (CollectionUtils.isEmpty((Collection)fieldNames) || !BIZ_PARTNER_FILEDNAME.equals(fieldNames.get(0)) || CollectionUtils.isEmpty((Collection)(bizPartnerIds = (List)customFiter.get("Value")))) continue;
            this.getPageCache().put("bizPartner", String.valueOf(bizPartnerIds.get(0)));
            break;
        }
        super.filterContainerSearchClick(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("user.name".equals(args.getFieldName())) {
            HashMap<String, Boolean> customParams = args.getCustomParams();
            if (customParams == null) {
                customParams = new HashMap<String, Boolean>();
                args.setCustomParams(customParams);
            }
            customParams.put("isOnlyShowExternalUser", Boolean.TRUE);
            customParams.put("externalUserType", (Boolean)((Object)"all"));
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datum = e.getQueryValues();
        ArrayList<Long> bizUserIds = new ArrayList<Long>(datum.length);
        for (DynamicObject data : datum) {
            long id = data.getLong("id");
            bizUserIds.add(id);
        }
        String selectProperties = "user,usertype";
        QFilter qFilter = new QFilter("id", "in", bizUserIds);
        Map bizUserMap = BusinessDataServiceHelper.loadFromCache((String)PARTNER_ENTITY, (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Map)bizUserMap)) {
            return;
        }
        Map<String, String> userTypeIdToNumber = this.getUserTypeIdToNumber();
        HashMap<Long, Long> bizAndUser = new HashMap<Long, Long>(bizUserMap.size());
        HashMap<Long, String> bizAndUserType = new HashMap<Long, String>(bizUserMap.size());
        for (Map.Entry entry : bizUserMap.entrySet()) {
            DynamicObject bizUser = (DynamicObject)entry.getValue();
            DynamicObject user = bizUser.getDynamicObject("user");
            if (user == null) continue;
            bizAndUser.put(bizUser.getLong("id"), user.getLong("id"));
            String userTypeNumbers = this.changeTypeIdToNumber(userTypeIdToNumber, bizUser.getString("usertype"));
            bizAndUserType.put(bizUser.getLong("id"), userTypeNumbers);
        }
        String bizSelectProperties = "name,username,phone,email";
        QFilter idFilter = new QFilter("id", "in", bizAndUser.values());
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)bizSelectProperties, (QFilter[])new QFilter[]{idFilter});
        this.fillExportFields(datum, bizAndUser, bizAndUserType, userMap);
    }

    private Map<String, String> getUserTypeIdToNumber() {
        Map userTypes = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", (String)"number", (QFilter[])new QFilter[]{new QFilter(KEY_ENABLE, "=", (Object)YES)});
        if (userTypes.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> userTypeIdToNumber = new HashMap<String, String>(userTypes.size());
        for (Map.Entry entry : userTypes.entrySet()) {
            DynamicObject userType = (DynamicObject)entry.getValue();
            userTypeIdToNumber.put(entry.getKey().toString(), userType.getString("number"));
        }
        return userTypeIdToNumber;
    }

    private String changeTypeIdToNumber(Map<String, String> userTypeIdToNumber, String userTypeIds) {
        if (StringUtils.isEmpty((Object)userTypeIds) || userTypeIdToNumber.isEmpty()) {
            return null;
        }
        String[] typeIds = userTypeIds.split(",");
        StringJoiner userTypeNumbers = new StringJoiner(",");
        for (String typeId : typeIds) {
            String typeNumber;
            if (StringUtils.isEmpty((Object)typeId) || StringUtils.isEmpty((Object)(typeNumber = userTypeIdToNumber.getOrDefault(typeId, "")))) continue;
            userTypeNumbers.add(typeNumber);
        }
        return userTypeNumbers.toString();
    }

    private void fillExportFields(DynamicObject[] datum, Map<Long, Long> bizAndUser, Map<Long, String> bizAndUserType, Map<Object, DynamicObject> userMap) {
        if (CollectionUtils.isEmpty(userMap)) {
            return;
        }
        for (DynamicObject data : datum) {
            DynamicObject user;
            long bizUserId = data.getLong("id");
            String userType = bizAndUserType.get(bizUserId);
            long userId = bizAndUser.get(bizUserId);
            if (data.containsProperty("type")) {
                data.set("type", (Object)userType);
            }
            if ((user = userMap.get(userId)) == null) continue;
            String phone = user.getString("phone");
            String email = user.getString("email");
            String username = user.getString("name");
            String userFullName = user.getString("username");
            if (data.containsProperty("phone")) {
                data.set("phone", (Object)phone);
            }
            if (data.containsProperty("email")) {
                data.set("email", (Object)email);
            }
            if (data.containsProperty("username")) {
                data.set("username", (Object)username);
            }
            if (!data.containsProperty("userfullname")) continue;
            data.set("userfullname", (Object)userFullName);
        }
    }
}

