/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.model.BizRoleUser;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.PermBusiRoleLogHelper;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogCommonRole;
import kd.bos.permission.log.model.LogNewDataRuleWrapper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class BizRoleAssignUserPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(BizRoleAssignUserPlugin.class);
    public static final String ENTITYNAME = "perm_userbizrole";
    public static final String TOOLBARMAIN = "maintoolbar";
    public static final String SAVE = "save";
    public static final String PREVIOUS = "previous";
    public static final String NEXT = "next";
    public static final String ICON_FIRST = "icon_first";
    public static final String ICON_PREVIOUS = "icon_prev";
    public static final String ICON_NEXT = "icon_next";
    public static final String ICON_LAST = "icon_last";
    public static final String BIZROLE = "bizrole";
    public static final String USER_ENTRY = "user_entry";
    public static final String USERTOOLBAR = "usertoolbar";
    public static final String USER = "user";
    public static final String USERTYPE = "usertype";
    public static final String USERF7 = "userf7";
    public static final String CALLBCKID_FIRST = "callBackId_doFirst";
    public static final String CALLBCKID_PREVIOUS = "callBackId_doPrevious";
    public static final String CALLBCKID_NEXT = "callBackId_doNext";
    public static final String CALLBCKID_LAST = "callBackId_doLast";
    public static final String CALLBCKID_CLOSE = "callBackId_close";
    public static final String CALLBCKID_BIZROLENUM = "callbckid_bizrolenum";
    public static final String BIZOBJID = "perm_userbizrole";
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String PERM_BIZROLE_ENTITY = "perm_busirole";
    private static final String OPERKEY_DONOTHING_BIZROLEASSIGNUSER = "donothing_bizroleassignuser";
    private static final String BUSIROLE_PAGE_KEY_CHANGE_USERS = "busirole_page_key_change_users";
    private static final String ENDTIMECONST = "2999-12-31 23:59:59";
    private static final String PROPERTY_CHANGED_ERROR = "propertyChangedError";

    public void initialize() {
        super.initialize();
        this.initinitUserTypeMulCombo();
        this.addItemClickListeners(new String[]{TOOLBARMAIN});
        this.addClickListeners(new String[]{ICON_FIRST, ICON_PREVIOUS, ICON_NEXT, ICON_LAST});
        this.addListener();
        if (!PermCommonUtil.isEnableValidateTime()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{STARTTIME, ENDTIME});
        }
        this.getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (ICON_PREVIOUS.equals(key)) {
            this.ifDataChanged(CALLBCKID_PREVIOUS);
        } else if (ICON_NEXT.equals(key)) {
            this.ifDataChanged(CALLBCKID_NEXT);
        } else if (ICON_FIRST.equals(key)) {
            this.ifDataChanged(CALLBCKID_FIRST);
        } else if (ICON_LAST.equals(key)) {
            this.ifDataChanged(CALLBCKID_LAST);
        }
    }

    private void addListener() {
        Toolbar mainToolbar = (Toolbar)this.getControl(USERTOOLBAR);
        mainToolbar.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if ("adduser".equals(itemKey)) {
                    BizRoleAssignUserPlugin.this.getModel().setValue(BizRoleAssignUserPlugin.USERF7, null);
                    MulBasedataEdit userF7 = (MulBasedataEdit)BizRoleAssignUserPlugin.this.getView().getControl(BizRoleAssignUserPlugin.USERF7);
                    QFilter userF7QFilter = BizRoleAssignUserPlugin.this.getUserF7QFilter();
                    userF7.setQFilter(userF7QFilter);
                    userF7.click();
                }
            }
        });
        MulBasedataEdit userF7 = (MulBasedataEdit)this.getView().getControl(USERF7);
        userF7.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                if (PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()))) {
                    evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                }
                evt.getFormShowParameter().setCustomParam("externalUserType", (Object)"all");
                ArrayList<Long> userList = new ArrayList<Long>(10);
                userList.add(Long.parseLong(RequestContext.get().getUserId()));
                int rowCount = BizRoleAssignUserPlugin.this.getModel().getEntryRowCount(BizRoleAssignUserPlugin.USER_ENTRY);
                DynamicObjectCollection entryEntity = BizRoleAssignUserPlugin.this.getModel().getEntryEntity(BizRoleAssignUserPlugin.USER_ENTRY);
                for (int i = 0; i < rowCount; ++i) {
                    DynamicObject user = ((DynamicObject)entryEntity.get(i)).getDynamicObject(BizRoleAssignUserPlugin.USER);
                    if (null == user) continue;
                    Long userId = user.getLong("id");
                    userList.add(userId);
                }
                evt.getCustomQFilters().add(new QFilter("id", "not in", userList));
                ArrayList<QFilter> qList = new ArrayList<QFilter>(10);
                String userQFilterCache = BizRoleAssignUserPlugin.this.getPageCache().get("CustomQFilter_UserIds");
                if (StringUtils.isNotEmpty((String)userQFilterCache)) {
                    QFilter userQFilter = QFilter.fromSerializedString((String)userQFilterCache);
                    qList.add(userQFilter);
                    ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
                    return;
                }
                String customUserIds = BizRoleAssignUserPlugin.this.getPageCache().get("CustomFilter_UserIds");
                if (StringUtils.isNotEmpty((String)customUserIds)) {
                    List strUserIdList = (List)SerializationUtils.fromJsonString((String)customUserIds, List.class);
                    ArrayList<Long> userIdList = new ArrayList<Long>(2000);
                    for (Object strUserId : strUserIdList) {
                        userIdList.add(Long.parseLong(strUserId.toString()));
                    }
                    qList.add(new QFilter("id", "in", userIdList));
                    ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList billList = (BillList)this.getView().getParentView().getControl("billlistap");
        if (billList == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
        Long bizRoleId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        this.getModel().setValue(BIZROLE, (Object)bizRoleId);
        String isFromList = (String)this.getView().getFormShowParameter().getCustomParam("FromList");
        if (StringUtils.isEmpty((String)isFromList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{NEXT, PREVIOUS});
        }
        this.loadBizRoleUserType(bizRoleId);
        this.loadAssignedUser(bizRoleId);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            long currUserId = RequestContext.get().getCurrUserId();
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
            boolean showForSpecial = "true".equals(this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser"));
            if (adminUser) {
                EntryGrid userEg = (EntryGrid)this.getControl(USER_ENTRY);
                int[] selectRows = userEg.getSelectRows();
                String opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"BizRoleAssignUserPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                int[][] rows = new PermissionServiceImpl().checkAdminChargeUsersAndHint(this.getModel(), this.getView(), USER_ENTRY, null, USER, selectRows, currUserId, opName);
                if (rows[1] != null) {
                    if (selectRows.length == 1) {
                        args.setCancel(true);
                        return;
                    }
                    userEg.clearEntryState();
                    if (rows[0] == null) {
                        args.setCancel(true);
                        return;
                    }
                    userEg.selectRows(rows[0], rows[0][0]);
                }
            }
            if (adminUser || showForSpecial) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(USER_ENTRY);
                Set<Long> delUserIdSet = entryEntity.stream().map(x -> x.getLong("user_id")).collect(Collectors.toSet());
                this.setDelUserList(delUserIdSet);
            }
        }
    }

    private QFilter getUserF7QFilter() {
        QFilter staffFilter = new QFilter("id", "!=", (Object)1L);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter forbiddenFilter = new QFilter("isforbidden", "=", (Object)"0");
        QFilter excludeRobotFilter = new QFilter(USERTYPE, "!=", (Object)"6");
        staffFilter = staffFilter.and(enableFilter).and(forbiddenFilter).and(excludeRobotFilter);
        return staffFilter;
    }

    private void loadBizRoleUserType(Long bizRoleId) {
        try {
            DynamicObject bizrole = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole", (String)USERTYPE);
            this.getModel().setValue(USERTYPE, bizrole.get(USERTYPE));
        }
        catch (Exception e) {
            logger.warn("\u67e5\u8be2ID\u4e3a" + bizRoleId + "\u4e1a\u52a1\u89d2\u8272\u5931\u8d25", (Throwable)e);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u89d2\u8272\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"BizRoleAssignUserPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void loadAssignedUser(Long bizRoleId) {
        this.getModel().deleteEntryData(USER_ENTRY);
        final boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        StringBuilder sql = new StringBuilder("select fid, fbizroleid, fuserid");
        if (enableValidateTime) {
            sql.append(",fstarttime,fendtime ");
        }
        sql.append(" from t_perm_userbizrole where fbizroleid = ? ");
        Object[] params = new Object[]{bizRoleId};
        DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                int size = 64;
                ArrayList<Object[]> userIdList = new ArrayList<Object[]>(size);
                Long userId = null;
                Date startTime = null;
                Date endTime = null;
                while (rs.next()) {
                    userId = rs.getLong("fuserid");
                    if (enableValidateTime) {
                        String startTimeStr = rs.getString("fstarttime");
                        String endTimeStr = rs.getString("fendtime");
                        startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate((String)startTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                        endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate((String)endTimeStr.substring(0, 19), (String)"yyyy-MM-dd HH:mm:ss");
                        userIdList.add(new Object[]{userId, startTime, endTime});
                        continue;
                    }
                    userIdList.add(new Object[]{userId});
                }
                BizRoleAssignUserPlugin.this.getModel().deleteEntryData(BizRoleAssignUserPlugin.USER_ENTRY);
                BizRoleAssignUserPlugin.this.fillUserList(userIdList);
                return null;
            }
        });
        this.getModel().setDataChanged(false);
    }

    private void initinitUserTypeMulCombo() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{enableFilter};
        DynamicObjectCollection typeList = QueryServiceHelper.query((String)"bos_usertype", (String)"id,name", (QFilter[])filters, (String)"ispreset desc,number");
        if (typeList == null || typeList.size() == 0) {
            return;
        }
        ComboEdit userTypeField = (ComboEdit)this.getControl(USERTYPE);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(typeList.size());
        for (DynamicObject obj : typeList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setId(obj.getString("id"));
            comboItem.setValue(obj.getString("id"));
            comboItem.setCaption(new LocaleString(obj.getString("name")));
            propertyItems.add(comboItem);
        }
        userTypeField.setComboItems(propertyItems);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "save": {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("name", SAVE);
                param.put("duration", 0);
                param.put("async", Boolean.TRUE);
                proxy.addAction("addClientCallBack", param);
                break;
            }
            case "previous": {
                this.ifDataChanged(CALLBCKID_PREVIOUS);
                break;
            }
            case "next": {
                this.ifDataChanged(CALLBCKID_NEXT);
                break;
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (SAVE.equals(e.getName())) {
            if (this.getPageCache().get(PROPERTY_CHANGED_ERROR) == null) {
                this.saveInfo();
                this.getModel().setDataChanged(false);
            } else {
                this.getPageCache().remove(PROPERTY_CHANGED_ERROR);
            }
        }
    }

    private void busiRoleAssignUser2PermLog(String op, String opbtn, Long opItemId, String opItemNumber, String opItemName, String diffContent) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"busi_role_assignuser");
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.BizRoleAssignUserPlugin.busiRoleAssignUser2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("BizRoleAssignUserPlugin.busiRoleAssignUser2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private void doNext() {
        DynamicObject curBizRole;
        Object currPkValue;
        String strCurrPkValue;
        IFormView fv = this.getView();
        BillList billList = (BillList)fv.getParentView().getControl("billlistap");
        AbstractGrid.GridState state = billList.getEntryState();
        int currentPageIndex = state.getCurrentPageIndex();
        ListSelectedRowCollection listAllRow = billList.getCurrentListAllRowCollection();
        Object[] pkValues = listAllRow.toArray();
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkValues != null && pkValues.length > 0) {
            for (int i = 0; i < pkValues.length; ++i) {
                pkList.add(pkValues[i].toString());
            }
        }
        if (StringUtils.isNotEmpty((String)(strCurrPkValue = (currPkValue = (curBizRole = (DynamicObject)this.getModel().getValue(BIZROLE)).get("id")).toString())) && pkList != null && pkList.size() > 0) {
            int index = pkList.indexOf(strCurrPkValue);
            if (index == pkList.size() - 1) {
                String nextPk1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5df2\u662f\u7b2c%s\u9875\u672b\u5f20", (String)"BizRoleAssignUserPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), currentPageIndex);
                fv.showMessage(nextPk1);
                return;
            }
            Object nextPk = pkList.get(index + 1);
            String strNextPk = nextPk.toString();
            if (StringUtils.isNotEmpty((String)strNextPk)) {
                this.showForm(strNextPk);
            }
        }
    }

    private void doPrevious() {
        DynamicObject curBizRole;
        Object currPkValue;
        String strCurrPkValue;
        IFormView fv = this.getView();
        BillList billList = (BillList)fv.getParentView().getControl("billlistap");
        AbstractGrid.GridState state = billList.getEntryState();
        int currentPageIndex = state.getCurrentPageIndex();
        ListSelectedRowCollection listAllRow = billList.getCurrentListAllRowCollection();
        Object[] pkValues = listAllRow.toArray();
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkValues != null && pkValues.length > 0) {
            for (int i = 0; i < pkValues.length; ++i) {
                pkList.add(pkValues[i].toString());
            }
        }
        if (StringUtils.isNotEmpty((String)(strCurrPkValue = (currPkValue = (curBizRole = (DynamicObject)this.getModel().getValue(BIZROLE)).get("id")).toString())) && pkList != null && pkList.size() > 0) {
            int index = pkList.indexOf(strCurrPkValue);
            if (index == 0) {
                String previousPk1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5df2\u662f\u7b2c%s\u9875\u9996\u5f20", (String)"BizRoleAssignUserPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), currentPageIndex);
                fv.showMessage(previousPk1);
                return;
            }
            Object previousPk = pkList.get(index - 1);
            String strPreviousPk = previousPk.toString();
            if (StringUtils.isNotEmpty((String)strPreviousPk)) {
                this.showForm(strPreviousPk);
            }
        }
    }

    public void showForm(String bizRoleId) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String pageId = this.getView().getPageId();
        CharSequence[] pageIdSplit = pageId.split("-");
        String oldBizRoleId = pageIdSplit[0];
        pageIdSplit[0] = bizRoleId;
        String newPageId = String.join((CharSequence)"-", pageIdSplit);
        IFormView newFv = this.getView().getView(newPageId);
        if (newFv != null) {
            PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
        } else {
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            param.setCustomParam("id", (Object)Long.valueOf(bizRoleId));
            param.setPageId(newPageId);
            StringBuilder sbErrorInfo = new StringBuilder();
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                MutexHelper.release((String)PERM_BIZROLE_ENTITY, (String)OPERKEY_DONOTHING_BIZROLEASSIGNUSER, (String)oldBizRoleId);
            }
            if (MutexHelper.require((String)PERM_BIZROLE_ENTITY, (Object)bizRoleId, (String)OPERKEY_DONOTHING_BIZROLEASSIGNUSER, (StringBuilder)sbErrorInfo)) {
                this.getView().setStatus(OperationStatus.EDIT);
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
            }
            this.getView().showForm(param);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String name = e.getProperty().getName();
        if (newValue instanceof DynamicObjectCollection) {
            DynamicObjectCollection doc = (DynamicObjectCollection)newValue;
            if (doc == null || doc.size() == 0) {
                return;
            }
            if (USERF7.equals(name)) {
                ArrayList<Object[]> userList = new ArrayList<Object[]>(10);
                for (int i = 0; i < doc.size(); ++i) {
                    DynamicObject user = (DynamicObject)doc.get(i);
                    long userId = user.getLong("fbasedataid_id");
                    userList.add(new Object[]{userId});
                }
                this.fillUserList(userList);
                this.setAddUserList(userList.stream().map(x -> Long.parseLong(String.valueOf(x[0]))).collect(Collectors.toSet()));
                this.getModel().setDataChanged(true);
            }
            return;
        }
        if (STARTTIME.equals(name) || ENDTIME.equals(name)) {
            int[][] rows;
            if (this.getPageCache().get("pgCache_skipSetDate") != null) {
                this.getPageCache().remove("pgCache_skipSetDate");
                return;
            }
            this.getPageCache().remove(PROPERTY_CHANGED_ERROR);
            long currUserId = RequestContext.get().getCurrUserId();
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
            boolean setCancel = false;
            if (adminUser && !"true".equals(this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser")) && (rows = new PermissionServiceImpl().checkAdminChargeUsersAndHint(this.getModel(), this.getView(), USER_ENTRY, null, USER, new int[]{rowIndex}, currUserId, ResManager.loadKDString((String)"\u8bbe\u7f6e\u6709\u6548\u671f", (String)"BizRoleAssignUserPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0])))[1] != null) {
                setCancel = true;
            }
            if (!setCancel && this.dateValidate(rowIndex, name, newValue)) {
                DynamicObject user = (DynamicObject)this.getModel().getValue(USER, rowIndex);
                HashSet<Long> idSet = new HashSet<Long>(1);
                idSet.add(user.getLong("id"));
                this.setAddUserList(idSet);
            } else {
                this.getPageCache().put(PROPERTY_CHANGED_ERROR, Boolean.TRUE.toString());
                this.getPageCache().put("pgCache_skipSetDate", "true");
                this.getModel().setValue(name, oldValue, rowIndex);
            }
        }
    }

    private boolean dateValidate(int rowIndex, String property, Object newValue) {
        if (STARTTIME.equals(property)) {
            Date newStartTime = (Date)newValue;
            Date endTime = (Date)this.getModel().getValue(ENDTIME, rowIndex);
            if (null == newStartTime || endTime == null) {
                return true;
            }
            if (newStartTime.compareTo(endTime) >= 0) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c\u751f\u6548\u65f6\u95f4\u201d\u9700\u5c0f\u4e8e\u201c\u5931\u6548\u65f6\u95f4\u201d\u3002", (String)"BizRoleAssignUserPlugin_19", (String)SYSTEM_TYPE, (Object[])new Object[0]), rowIndex + 1);
                this.getView().showErrorNotification(error);
                return false;
            }
        } else {
            Date newEndTime = (Date)newValue;
            if (null == newEndTime) {
                return true;
            }
            if (newEndTime.before(new Date())) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c\u5931\u6548\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BizRoleAssignUserPlugin_18", (String)SYSTEM_TYPE, (Object[])new Object[0]), rowIndex + 1);
                this.getView().showErrorNotification(error);
                return false;
            }
            Date startTime = (Date)this.getModel().getValue(STARTTIME, rowIndex);
            if (startTime == null) {
                return true;
            }
            if (newEndTime.compareTo(startTime) <= 0) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c\u5931\u6548\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u751f\u6548\u65f6\u95f4\u201d\u3002", (String)"BizRoleAssignUserPlugin_20", (String)SYSTEM_TYPE, (Object[])new Object[0]), rowIndex + 1);
                this.getView().showErrorNotification(error);
                return false;
            }
        }
        return true;
    }

    private void fillUserList(List<Object[]> userList) {
        List<Long> chargeUserList;
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        if (PermCommonUtil.isEnableJustShowAdminCharged() && (chargeUserList = this.getAdminChargeUser()) != null) {
            userList.removeIf(k -> !chargeUserList.contains(k[0]));
        }
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{USER, STARTTIME, ENDTIME});
        Date endTimeDefault = DateUtil.toDate((String)ENDTIMECONST, (String)"yyyy-MM-dd HH:mm:ss");
        for (Object[] objects : userList) {
            if (objects.length > 1 && enableValidateTime) {
                vs.addRow(new Object[]{objects[0], objects[1], null == objects[2] ? endTimeDefault : objects[2]});
                continue;
            }
            vs.addRow(new Object[]{objects[0], null, endTimeDefault});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(USER_ENTRY, vs);
        this.getModel().endInit();
        this.getView().updateView(USER_ENTRY);
    }

    private List<Long> getAdminChargeUser() {
        UserScopeResult adminChargeUser;
        List chargeUserList = null;
        long currUserId = RequestContext.get().getCurrUserId();
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
        if (adminUser && !(adminChargeUser = PermissionServiceHelper.getAdminChargeUser((Long)currUserId, (boolean)false)).isAllUser()) {
            chargeUserList = adminChargeUser.getUserIDs();
        }
        return chargeUserList;
    }

    private void setDelUserList(Set<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        String changeUsers = this.getPageCache().get(BUSIROLE_PAGE_KEY_CHANGE_USERS);
        if (StringUtils.isEmpty((String)changeUsers)) {
            String userIdsStr = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.getPageCache().put(BUSIROLE_PAGE_KEY_CHANGE_USERS, userIdsStr);
        } else {
            Set changeUserIdSet = Arrays.asList(changeUsers.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
            changeUserIdSet.addAll(userIds);
            String userIdsStr = changeUserIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.getPageCache().put(BUSIROLE_PAGE_KEY_CHANGE_USERS, userIdsStr);
        }
    }

    private void setAddUserList(Set<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        String changeUsers = this.getPageCache().get(BUSIROLE_PAGE_KEY_CHANGE_USERS);
        if (StringUtils.isEmpty((String)changeUsers)) {
            String userIdsStr = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.getPageCache().put(BUSIROLE_PAGE_KEY_CHANGE_USERS, userIdsStr);
        } else {
            Set changeUserIdSet = Arrays.asList(changeUsers.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
            changeUserIdSet.addAll(userIds);
            String userIdsStr = changeUserIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.getPageCache().put(BUSIROLE_PAGE_KEY_CHANGE_USERS, userIdsStr);
        }
    }

    private List<Long> getChangeUserIdList() {
        String changeUserIdSet = this.getPageCache().get(BUSIROLE_PAGE_KEY_CHANGE_USERS);
        if (StringUtils.isEmpty((String)changeUserIdSet)) {
            return new ArrayList<Long>(1);
        }
        Set changeUserSet = Arrays.asList(changeUserIdSet.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
        return new ArrayList<Long>(changeUserSet);
    }

    private void clearChangeUserIdList() {
        this.getPageCache().remove(BUSIROLE_PAGE_KEY_CHANGE_USERS);
    }

    private void saveInfo() {
        try {
            String appId = StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId()) ? "0XWTKVOQW+ML" : this.getView().getFormShowParameter().getAppId();
            boolean checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)PERM_BIZROLE_ENTITY, (String)"80513208000000ac");
            if (!checkPermission) {
                this.getView().showErrorNotification(ConstantsHelper.getDesc_NoPerm((String)PERM_BIZROLE_ENTITY, (String)"80513208000000ac"));
                return;
            }
            DynamicObject bizRole = (DynamicObject)this.getModel().getValue(BIZROLE);
            Long bizRoleId = bizRole.getLong("id");
            String bizRoleNum = bizRole.getString("number");
            boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
            List allRobotIds = PermCommonUtil.getRobotIds();
            DynamicObjectCollection userEntry = this.getModel().getEntryEntity(USER_ENTRY);
            int userSize = userEntry.size();
            List<Long> changeUserIdList = this.getChangeUserIdList();
            ArrayList<Long> userListForLic = new ArrayList<Long>(userSize);
            ArrayList<BizRoleUser> changeList = new ArrayList<BizRoleUser>(userSize);
            BizRoleUser bru = null;
            Date startTime = null;
            Date endTime = null;
            for (int i = 0; i < userSize; ++i) {
                long userId;
                DynamicObject userInfo = (DynamicObject)userEntry.get(i);
                DynamicObject user = (DynamicObject)userInfo.get(USER);
                if (null == user || !changeUserIdList.contains(userId = user.getLong("id"))) continue;
                if (allRobotIds.contains(userId)) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("robotUser", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u901a\u8fc7\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u8fdb\u884c\u6388\u6743\uff0c\u662f\u5426\u5220\u9664\uff1f", (String)"BizRoleAssignUserPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                    return;
                }
                if (enableValidateTime) {
                    startTime = userInfo.getDate(STARTTIME);
                    endTime = userInfo.getDate(ENDTIME);
                }
                bru = new BizRoleUser(null, bizRoleId, Long.valueOf(userId), startTime, endTime);
                changeList.add(bru);
                if (!user.getBoolean("enable")) continue;
                userListForLic.add(user.getLong("id"));
            }
            Set pre = PermBusiRoleHelper.getBizRoleUserSet((Long)bizRoleId);
            this.save2DB(bizRoleId, changeUserIdList, changeList);
            Set after = PermBusiRoleHelper.getBizRoleUserSet((Long)bizRoleId);
            LinkedList preList = new LinkedList(pre);
            LinkedList afterList = new LinkedList(after);
            List delList = ListUtil.removeAll(preList, afterList);
            List addList = ListUtil.removeAll(afterList, preList);
            this.busiAfterSave(bizRoleId, bizRoleNum, userListForLic, delList, addList, changeUserIdList);
        }
        catch (Exception e) {
            logger.warn("BizRoleAssignUserPlugin.saveInfo error", (Throwable)e);
            this.showFailTips(e);
        }
    }

    private void busiAfterSave(Long bizRoleId, String bizRoleNum, List<Long> userListForLic, List<BizRoleUser> delList, List<BizRoleUser> addList, List<Long> changeUserIdList) throws Exception {
        Map appEntity;
        HashSet<Long> changedUserIdSet;
        String formNum = "perm_bizroleassignuser";
        String curLogAppId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u4e1a\u52a1\u89d2\u8272\u5206\u914d\u7528\u6237", "BizRoleAssignUserPlugin_21", SYSTEM_TYPE);
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u4e1a\u52a1\u89d2\u8272\uff1a%1$s\uff0c\u5206\u914d\u7528\u6237\u6210\u529f\u3002", "BizRoleAssignUserPlugin_22", SYSTEM_TYPE);
        String[] opDescParam = new String[]{bizRoleNum};
        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\uff1a%1$s\uff0c\u5206\u914d\u7528\u6237\u6210\u529f\u3002", (String)"BizRoleAssignUserPlugin_22", (String)SYSTEM_TYPE, (Object[])new Object[0]), bizRoleNum);
        PermCommonUtil.addLog((String)"", null, (String)formNum, (String)bizRoleNum, (String)"1", (String)SAVE, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
        if (PermCommonUtil.isEnableAuthorityChangeNotice() && !CollectionUtils.isEmpty(changedUserIdSet = new HashSet<Long>(changeUserIdList))) {
            try {
                ArrayList<Long> userIds = new ArrayList<Long>(changedUserIdSet);
                FormConfigFactory.cancelShowFormRights(userIds);
                String langStr = RequestContext.get().getLang().toString();
                List commonRoleList = PermBusiRoleLogHelper.getCommonRoleList((Long)bizRoleId, (String)langStr);
                if (!CollectionUtils.isEmpty((Collection)commonRoleList)) {
                    HashSet newDRAppEntityAllSet = new HashSet(1);
                    List collect = commonRoleList.stream().filter(LogCommonRole2 -> "1".equals(LogCommonRole2.getEnable())).collect(Collectors.toList());
                    for (LogCommonRole logCommonRole : collect) {
                        LogNewDataRuleWrapper newDataRule = PermRoleLogHelper.getNewDataRule((String)logCommonRole.getRoleId(), (String)langStr);
                        Set newDRAppEntitySet = newDataRule.getNewDRAppEntitySet();
                        newDRAppEntityAllSet.addAll(newDRAppEntitySet);
                    }
                    if (!CollectionUtils.isEmpty(newDRAppEntityAllSet)) {
                        List newDRAppEntityList = newDRAppEntityAllSet.stream().map(x -> {
                            String[] split = x.split("\\|", 2);
                            HashMap<String, String> map = new HashMap<String, String>(2);
                            map.put(split[0], split[1]);
                            return map;
                        }).collect(Collectors.toList());
                        FormConfigFactory.cancelShowFormDataRights(userIds, newDRAppEntityList);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            }
        }
        if (!CollectionUtils.isEmpty((Map)(appEntity = PermCommonUtil.getAppEntityByBizRole((Long)bizRoleId))) && !CollectionUtils.isEmpty(userListForLic)) {
            LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(userListForLic, (Map)appEntity);
        }
        PermissionServiceHelper.clearAllCache();
        if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty(delList) && CollectionUtils.isEmpty(addList))) {
            DynamicObject bizRole = (DynamicObject)this.getModel().getValue(BIZROLE);
            String bizRoleName = bizRole.getString("name");
            String bizRoleNumber = bizRole.getString("number");
            String opbtn = ConstantsHelper.getSave();
            HashMap<String, Object> logMap = new HashMap<String, Object>(2);
            logMap.put("del", delList);
            logMap.put("add", addList);
            logMap.put("langStr", RequestContext.get().getLang().name());
            this.busiRoleAssignUser2PermLog(SAVE, opbtn, bizRoleId, bizRoleNumber, bizRoleName, StrUtil.compress((String)new ObjectMapper().writeValueAsString(logMap)));
        }
        this.clearChangeUserIdList();
        this.showSuccessTips();
    }

    private void showSuccessTips() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BizRoleAssignUserPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
    }

    private void showFailTips(Exception e) {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BizRoleAssignUserPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage());
    }

    private void save2DB(Long bizRoleId, List<Long> changeUserIdList, List<BizRoleUser> changeList) {
        try (TXHandle txHandle = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(changeUserIdList)) {
                    DeleteServiceHelper.delete((String)"perm_userbizrole", (QFilter[])new QFilter[]{new QFilter(BIZROLE, "=", (Object)bizRoleId), new QFilter(USER, "in", new HashSet<Long>(changeUserIdList))});
                }
                if (!CollectionUtils.isEmpty(changeList)) {
                    PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"busi_role_assignuser", (boolean)false);
                    String fromtypedesc = null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc();
                    long currUserId = RequestContext.get().getCurrUserId();
                    Date curTime = new Date();
                    int size = changeList.size();
                    long[] newFids = DB.genLongIds((String)"t_perm_userbizrole", (int)size);
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
                    for (int i = 0; i < size; ++i) {
                        BizRoleUser bur = changeList.get(i);
                        bur.setFid(Long.valueOf(newFids[i]));
                        paramList.add(new Object[]{newFids[i], bur.getFuserid(), bur.getFbizroleid(), bur.getFstarttime(), bur.getFendtime(), fromtypedesc, currUserId, curTime, currUserId, curTime});
                    }
                    String sql = "insert into t_perm_userbizrole (fid, fuserid, fbizroleid, fstarttime, fendtime, ffromtypedesc, fcreaterfield, fcreatedatefield, fmodifierfield, fmodifydatefield) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    int m = SqlUtil.getBatchCount((Integer)999, (int)size);
                    List mainListAvg = ListUtil.averageAssign(paramList, (int)m);
                    int i = 0;
                    while (i < mainListAvg.size()) {
                        int finalI = i++;
                        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, (List)((List)mainListAvg.get(finalI)));
                    }
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.warn("BizRoleAssignUserPlugin.save2DB error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    public boolean ifDataChanged(String callBackId) {
        String info = "";
        if (callBackId.equals(CALLBCKID_PREVIOUS)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u4e0a\u4e00\u4e2a\u4e1a\u52a1\u89d2\u8272\uff1f", (String)"BizRoleAssignUserPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_NEXT)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u4e0b\u4e00\u4e2a\u4e1a\u52a1\u89d2\u8272\uff1f", (String)"BizRoleAssignUserPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_FIRST)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u7b2c\u4e00\u4e2a\u4e1a\u52a1\u89d2\u8272\uff1f", (String)"BizRoleAssignUserPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_LAST)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u6700\u540e\u4e00\u4e2a\u4e1a\u52a1\u89d2\u8272\uff1f", (String)"BizRoleAssignUserPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_CLOSE)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"BizRoleAssignUserPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_BIZROLENUM)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u5207\u6362\u89d2\u8272\uff1f", (String)"BizRoleAssignUserPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        boolean ifDataChanged = this.getModel().getDataChanged();
        if (ifDataChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            this.getView().showConfirm(info, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        if (callBackId.equals(CALLBCKID_PREVIOUS)) {
            this.doPrevious();
        } else if (callBackId.equals(CALLBCKID_NEXT)) {
            this.doNext();
        } else if (callBackId.equals(CALLBCKID_FIRST)) {
            this.doFirst();
        } else if (callBackId.equals(CALLBCKID_LAST)) {
            this.doLast();
        }
        return false;
    }

    private void doLast() {
        DynamicObject curBizRole;
        Object currPkValue;
        String strCurrPkValue;
        IFormView fv = this.getView();
        BillList billList = (BillList)fv.getParentView().getControl("billlistap");
        AbstractGrid.GridState state = billList.getEntryState();
        int currentPageIndex = state.getCurrentPageIndex();
        ListSelectedRowCollection listAllRow = billList.getCurrentListAllRowCollection();
        Object[] pkValues = listAllRow.toArray();
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkValues != null && pkValues.length > 0) {
            for (int i = 0; i < pkValues.length; ++i) {
                pkList.add(pkValues[i].toString());
            }
        }
        if (StringUtils.isNotEmpty((String)(strCurrPkValue = (currPkValue = (curBizRole = (DynamicObject)this.getModel().getValue(BIZROLE)).get("id")).toString())) && pkList != null && pkList.size() > 0) {
            int index = pkList.indexOf(strCurrPkValue);
            if (index == pkList.size() - 1) {
                String nextPk1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5df2\u662f\u7b2c%s\u9875\u672b\u5f20", (String)"BizRoleAssignUserPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), currentPageIndex);
                fv.showMessage(nextPk1);
                return;
            }
            Object lastPk = pkList.get(pkList.size() - 1);
            String strLastPk = lastPk.toString();
            if (StringUtils.isNotEmpty((String)strLastPk)) {
                this.showForm(strLastPk);
            }
        }
    }

    private void doFirst() {
        DynamicObject curBizRole;
        Object currPkValue;
        String strCurrPkValue;
        IFormView fv = this.getView();
        BillList billList = (BillList)fv.getParentView().getControl("billlistap");
        AbstractGrid.GridState state = billList.getEntryState();
        int currentPageIndex = state.getCurrentPageIndex();
        ListSelectedRowCollection listAllRow = billList.getCurrentListAllRowCollection();
        Object[] pkValues = listAllRow.toArray();
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkValues != null && pkValues.length > 0) {
            for (int i = 0; i < pkValues.length; ++i) {
                pkList.add(pkValues[i].toString());
            }
        }
        if (StringUtils.isNotEmpty((String)(strCurrPkValue = (currPkValue = (curBizRole = (DynamicObject)this.getModel().getValue(BIZROLE)).get("id")).toString())) && pkList != null && pkList.size() > 0) {
            int index = pkList.indexOf(strCurrPkValue);
            if (index == 0) {
                String previousPk1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5df2\u662f\u7b2c%s\u9875\u9996\u5f20", (String)"BizRoleAssignUserPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), currentPageIndex);
                fv.showMessage(previousPk1);
                return;
            }
            Object firstPk = pkList.get(0);
            String strFirstPk = firstPk.toString();
            if (StringUtils.isNotEmpty((String)strFirstPk)) {
                this.showForm(strFirstPk);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.ifDataChanged(CALLBCKID_CLOSE)) {
            e.setCancel(true);
        }
        String bizroleId = this.getView().getPageId().split("-")[0];
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            MutexHelper.release((String)PERM_BIZROLE_ENTITY, (String)OPERKEY_DONOTHING_BIZROLEASSIGNUSER, (String)bizroleId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (callBackId.equals(CALLBCKID_CLOSE)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                PermFormCommonUtil.closeClientForm(this.getView());
            }
        } else if (callBackId.equals(CALLBCKID_PREVIOUS)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.doPrevious();
            }
        } else if (callBackId.equals(CALLBCKID_NEXT)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.doNext();
            }
        } else if (callBackId.equals(CALLBCKID_FIRST)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.doFirst();
            }
        } else if (callBackId.equals(CALLBCKID_LAST)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.doLast();
            }
        } else if (callBackId.equals("robotUser") && evt.getResult() == MessageBoxResult.Yes) {
            this.delRobotUser();
        }
    }

    private void delRobotUser() {
        List allRobotIds = PermCommonUtil.getRobotIds();
        DynamicObjectCollection userEntry = this.getModel().getEntryEntity(USER_ENTRY);
        int size = userEntry.size();
        ArrayList<Integer> robotRow = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            long userId;
            DynamicObject userInfo = (DynamicObject)userEntry.get(i);
            DynamicObject user = (DynamicObject)userInfo.get(USER);
            if (null == user || !allRobotIds.contains(userId = user.getLong("id"))) continue;
            robotRow.add(i);
        }
        int delCount = robotRow.size();
        int[] delInt = new int[delCount];
        for (int i = delCount - 1; i >= 0; --i) {
            delInt[i] = (Integer)robotRow.get(i);
        }
        this.getModel().deleteEntryRows(USER_ENTRY, delInt);
        Set<Long> delUserIdSet = userEntry.stream().map(x -> x.getLong("user_id")).collect(Collectors.toSet());
        this.setDelUserList(delUserIdSet);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u673a\u5668\u4eba\u7528\u6237\uff0c\u8bf7\u786e\u8ba4\u540e\u4fdd\u5b58\u3002", (String)"BizRoleAssignUserPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String showFormSpecial = (String)e.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)e.getFormShowParameter().getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5168\u529f\u80fd\u7528\u6237\uff0c\u4e5f\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd", (String)"BizRoleAssignUserPlugin_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
    }
}

