/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.BizRoleUg;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class BusiRoleAssignUsrGrpPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(BusiRoleAssignUsrGrpPlugin.class);
    public static final String BIZROLE = "bizrole";
    private static String MAINENTITY = "perm_usrgrpbusirole";
    private static final String PERM_BIZROLE_ENTITY = "perm_busirole";
    private static final String OPERKEY_DONOTHING_BIZROLEASSIGNUSRGRP = "donothing_bizroleassignusrgrp";
    private static final String USRGRP_ENTRY = "usrgrp_entry";
    private static final String USRGRP = "usrgrp";
    public static final String USERTYPE = "usertype";
    public static final String SAVE = "save";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String CLOSECALLBACK_RETURNDATA = "closeCallBack_returnData";
    public static final String TOOLBARMAIN = "maintoolbar";
    private static final String BUSIROLE_PAGE_KEY_CHANGE_UGS = "busirole_page_key_change_ugs";
    private static final String OP_DELETEENTRY = "deleteentry";
    public static final String CALLBCKID_FIRST = "callBackId_doFirst";
    public static final String CALLBCKID_PREVIOUS = "callBackId_doPrevious";
    public static final String CALLBCKID_NEXT = "callBackId_doNext";
    public static final String CALLBCKID_LAST = "callBackId_doLast";
    public static final String ICON_FIRST = "icon_first";
    public static final String ICON_PREVIOUS = "icon_prev";
    public static final String ICON_NEXT = "icon_next";
    public static final String ICON_LAST = "icon_last";
    private static final String OPERKEY_DONOTHING_BIZROLEASSIGNUSER = "donothing_bizroleassignuser";

    public void initialize() {
        super.initialize();
        this.initinitUserTypeMulCombo();
        this.addItemClickListeners(new String[]{TOOLBARMAIN, "usrgrptoolbar"});
        this.addClickListeners(new String[]{ICON_FIRST, ICON_PREVIOUS, ICON_NEXT, ICON_LAST});
    }

    private void initinitUserTypeMulCombo() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{enableFilter};
        DynamicObjectCollection typeList = QueryServiceHelper.query((String)"bos_usertype", (String)"id,name", (QFilter[])filters, (String)"ispreset desc,number");
        if (typeList == null || typeList.size() == 0) {
            return;
        }
        ComboEdit userTypeField = (ComboEdit)this.getControl(USERTYPE);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(typeList.size());
        for (DynamicObject obj : typeList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setId(obj.getString("id"));
            comboItem.setValue(obj.getString("id"));
            comboItem.setCaption(new LocaleString(obj.getString("name")));
            propertyItems.add(comboItem);
        }
        userTypeField.setComboItems(propertyItems);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (ICON_PREVIOUS.equals(key)) {
            this.ifDataChanged(CALLBCKID_PREVIOUS);
        } else if (ICON_NEXT.equals(key)) {
            this.ifDataChanged(CALLBCKID_NEXT);
        } else if (ICON_FIRST.equals(key)) {
            this.ifDataChanged(CALLBCKID_FIRST);
        } else if (ICON_LAST.equals(key)) {
            this.ifDataChanged(CALLBCKID_LAST);
        }
    }

    public boolean ifDataChanged(String callBackId) {
        String info = "";
        if (callBackId.equals(CALLBCKID_PREVIOUS)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u4e0a\u4e00\u4e2a\u4e1a\u52a1\u89d2\u8272\uff1f", (String)"BusiRoleAssignUsrGrpPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_NEXT)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u4e0b\u4e00\u4e2a\u4e1a\u52a1\u89d2\u8272\uff1f", (String)"BusiRoleAssignUsrGrpPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_FIRST)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u7b2c\u4e00\u4e2a\u4e1a\u52a1\u89d2\u8272\uff1f", (String)"BusiRoleAssignUsrGrpPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_LAST)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u6700\u540e\u4e00\u4e2a\u4e1a\u52a1\u89d2\u8272\uff1f", (String)"BusiRoleAssignUsrGrpPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        boolean ifDataChanged = this.getModel().getDataChanged();
        if (ifDataChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            this.getView().showConfirm(info, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        if (callBackId.equals(CALLBCKID_PREVIOUS)) {
            this.doPrevious();
        } else if (callBackId.equals(CALLBCKID_NEXT)) {
            this.doNext();
        } else if (callBackId.equals(CALLBCKID_FIRST)) {
            this.doFirst();
        } else if (callBackId.equals(CALLBCKID_LAST)) {
            this.doLast();
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList billList = (BillList)this.getView().getParentView().getControl("billlistap");
        if (billList == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
        Long bizRoleId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        this.getModel().setValue(BIZROLE, (Object)bizRoleId);
        String sql = "select fusrgrpid from t_perm_usrgrpbizrole where fbizroleid = ?";
        List usrGrpIds = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{bizRoleId}, resultSet -> {
            LinkedList<Long> usrGrpIdList = new LinkedList<Long>();
            while (resultSet.next()) {
                usrGrpIdList.add(resultSet.getLong("fusrgrpid"));
            }
            return usrGrpIdList;
        });
        if (!usrGrpIds.isEmpty()) {
            TableValueSetter vs = new TableValueSetter(new String[]{USRGRP});
            for (Long usrGrpId : usrGrpIds) {
                vs.addRow(new Object[]{usrGrpId});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(USRGRP_ENTRY, vs);
        }
        this.loadBizRoleUserType(bizRoleId);
    }

    private void loadBizRoleUserType(Long bizRoleId) {
        try {
            DynamicObject bizrole = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole", (String)USERTYPE);
            this.getModel().setValue(USERTYPE, bizrole.get(USERTYPE));
        }
        catch (Exception e) {
            logger.warn("\u67e5\u8be2ID\u4e3a" + bizRoleId + "\u4e1a\u52a1\u89d2\u8272\u5931\u8d25", (Throwable)e);
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u89d2\u8272\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"BusiRoleAssignUsrGrpPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String bizroleId = this.getView().getPageId().split("-")[0];
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            MutexHelper.release((String)PERM_BIZROLE_ENTITY, (String)OPERKEY_DONOTHING_BIZROLEASSIGNUSRGRP, (String)bizroleId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals(SAVE)) {
            this.save();
        } else if ("addusrgrp".equals(itemKey)) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_usrgrp", (boolean)true, (int)0);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_RETURNDATA));
            List qFilters = lsp.getListFilterParameter().getQFilters();
            EntryGrid eg = (EntryGrid)this.getView().getControl(USRGRP_ENTRY);
            EntryData ed = eg.getEntryData();
            DynamicObject[] grps = ed.getDataEntitys();
            ArrayList<Object> usrGrpList = new ArrayList<Object>(8);
            for (DynamicObject grp : grps) {
                usrGrpList.add(grp.get("usrgrp_id"));
            }
            qFilters.add(new QFilter("id", "not in", usrGrpList));
            lsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
            lsp.setFormId("bos_usrgrptreelistf7");
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void save() {
        String appId = StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId()) ? "0XWTKVOQW+ML" : this.getView().getFormShowParameter().getAppId();
        boolean checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)PERM_BIZROLE_ENTITY, (String)"80513208000000ac");
        if (!checkPermission) {
            this.getView().showErrorNotification(ConstantsHelper.getDesc_NoPerm((String)PERM_BIZROLE_ENTITY, (String)"80513208000000ac"));
            return;
        }
        IFormView view = this.getView();
        try {
            DynamicObject bizRole = (DynamicObject)this.getModel().getValue(BIZROLE);
            Long bizRoleId = bizRole.getLong("id");
            String bizRoleNum = bizRole.getString("number");
            Set<Long> mayChangedUgSet = this.getMayChangedUgSet();
            if (CollectionUtils.isEmpty(mayChangedUgSet)) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BusiRoleAssignUsrGrpPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            Set pre = PermBusiRoleHelper.getBizRoleUgSet((Long)bizRoleId, null);
            this.save2DB(bizRoleId, mayChangedUgSet);
            Set after = PermBusiRoleHelper.getBizRoleUgSet((Long)bizRoleId, null);
            LinkedList preList = new LinkedList(pre);
            LinkedList afterList = new LinkedList(after);
            List delList = ListUtil.removeAll(preList, afterList);
            List addList = ListUtil.removeAll(afterList, preList);
            if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty((Collection)delList) && CollectionUtils.isEmpty((Collection)addList))) {
                String bizRoleName = bizRole.getString("name");
                String bizRoleNumber = bizRole.getString("number");
                String opbtn = ConstantsHelper.getSave();
                HashMap<String, Object> logMap = new HashMap<String, Object>(2);
                logMap.put("del", delList);
                logMap.put("add", addList);
                logMap.put("langStr", RequestContext.get().getLang().name());
                this.busiRoleAssignUg2PermLog(SAVE, opbtn, bizRoleId, bizRoleNumber, bizRoleName, StrUtil.compress((String)new ObjectMapper().writeValueAsString(logMap)));
            }
            BusiRoleAssignUsrGrpPlugin.addUserLicGroup(bizRole, addList);
            this.clearChangeUgSet();
            PermissionServiceHelper.clearAllCache();
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BusiRoleAssignUsrGrpPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            String formNum = "perm_bizroleassignusrgrp";
            String curLogAppId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u4e1a\u52a1\u89d2\u8272\u5206\u914d\u7528\u6237\u7ec4", "BizRoleAssignUserPlugin_23", SYSTEM_TYPE);
            MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u4e1a\u52a1\u89d2\u8272\uff1a%1$s\uff0c\u5206\u914d\u7528\u6237\u7ec4\u6210\u529f\u3002", "BizRoleAssignUserPlugin_24", SYSTEM_TYPE);
            String[] opDescParam = new String[]{bizRoleNum};
            String oldOpDescription = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\uff1a%1$s\uff0c\u5206\u914d\u7528\u6237\u7ec4\u6210\u529f\u3002", (String)"BizRoleAssignUserPlugin_24", (String)SYSTEM_TYPE, (Object[])new Object[0]), bizRoleNum);
            PermCommonUtil.addLog((String)"", null, (String)formNum, (String)bizRoleNum, (String)"1", (String)SAVE, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
        }
        catch (Exception e) {
            logger.warn("BusiRoleAssignUsrGrpPlugin error.", (Throwable)e);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"BusiRoleAssignUsrGrpPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static void addUserLicGroup(DynamicObject bizRole, List<BizRoleUg> addList) {
        List userIdsByGroupIds;
        Set addUsrGrpIdSet;
        Map appEntityMap = PermCommonUtil.getAppEntityByBizRole((Long)((Long)bizRole.getPkValue()));
        if (!(null == addList || addList.isEmpty() || null == appEntityMap || appEntityMap.isEmpty() || null == (addUsrGrpIdSet = addList.stream().map(BizRoleUg::getUsrGrpId).collect(Collectors.toSet())) || addUsrGrpIdSet.isEmpty() || null == (userIdsByGroupIds = UserGroupHelper.getUserIdsByGroupIds(addUsrGrpIdSet)) || userIdsByGroupIds.isEmpty())) {
            LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj((List)userIdsByGroupIds, (Map)appEntityMap);
        }
    }

    private void busiRoleAssignUg2PermLog(String op, String opbtn, Long opItemId, String opItemNumber, String opItemName, String diffContent) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"busi_role_assignug");
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.BizRoleAssignUserPlugin.busiRoleAssignUser2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("BusiRoleAssignUsrGrpPlugin.busiRoleAssignUg2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private void save2DB(Long bizRoleId, Set<Long> mayChangedUgSet) throws Exception {
        try (TXHandle h = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(mayChangedUgSet)) {
                    Set mayChangedUgStrSet = mayChangedUgSet.stream().map(String::valueOf).collect(Collectors.toSet());
                    String mayChangedUgStr = String.join((CharSequence)",", mayChangedUgStrSet);
                    DB.execute((DBRoute)DBRoute.basedata, (String)("delete from t_perm_usrgrpbizrole where fbizroleid=? and fusrgrpid in (" + mayChangedUgStr + ")"), (Object[])new Object[]{bizRoleId});
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl(USRGRP_ENTRY);
                EntryData entryData = entryGrid.getEntryData();
                DynamicObject[] dataEntitys = entryData.getDataEntitys();
                LinkedList<DynamicObject> saveList = new LinkedList<DynamicObject>();
                for (DynamicObject dataEntity : dataEntitys) {
                    DynamicObject dynamicObject = dataEntity.getDynamicObject(USRGRP);
                    long usrGrpId = (Long)dynamicObject.getPkValue();
                    if (!mayChangedUgSet.contains(usrGrpId)) continue;
                    DynamicObject usrGrpBizRoleObj = BusinessDataServiceHelper.newDynamicObject((String)MAINENTITY);
                    usrGrpBizRoleObj.set("usergroup", (Object)usrGrpId);
                    usrGrpBizRoleObj.set(BIZROLE, (Object)bizRoleId);
                    usrGrpBizRoleObj.set("createrfield", (Object)RequestContext.get().getCurrUserId());
                    usrGrpBizRoleObj.set("createdatefield", (Object)new Date());
                    saveList.add(usrGrpBizRoleObj);
                }
                if (!saveList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                logger.warn("BusiRoleAssignUsrGrpPlugin.save2DB error...", (Throwable)e);
                h.markRollback();
                throw new Exception(e);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLOSECALLBACK_RETURNDATA.equals(actionId)) {
            Object returnData = e.getReturnData();
            if (!(returnData instanceof ListSelectedRowCollection)) {
                return;
            }
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            if (!lsrc.isEmpty()) {
                HashSet<Long> ugIdSet = new HashSet<Long>(lsrc.size());
                TableValueSetter vs = new TableValueSetter(new String[]{USRGRP});
                for (ListSelectedRow listSelectedRow : lsrc) {
                    Object pkValue = listSelectedRow.getPrimaryKeyValue();
                    vs.addRow(new Object[]{pkValue});
                    ugIdSet.add((Long)pkValue);
                }
                this.signMayChangedUgSet(ugIdSet);
                ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(USRGRP_ENTRY, vs);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof FormOperate && (opKey = ((FormOperate)e.getSource()).getOperateKey()).equals(OP_DELETEENTRY)) {
            Set<Long> seltedUgIds = this.getSeltedUgIds();
            ((FormOperate)e.getSource()).getOption().setVariableValue("seltedUgIds", SerializationUtils.toJsonString(seltedUgIds));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String seltedUgIds;
        Object source;
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (opKey.equals(OP_DELETEENTRY) && (source = e.getSource()) instanceof FormOperate && StringUtils.isNotEmpty((String)(seltedUgIds = ((FormOperate)source).getOption().getVariableValue("seltedUgIds")))) {
            List ugIdList = (List)SerializationUtils.fromJsonString((String)seltedUgIds, List.class);
            this.signMayChangedUgSet(new HashSet<Long>(ugIdList));
        }
    }

    private Set<Long> getSeltedUgIds() {
        EntryGrid sourceEntity = (EntryGrid)this.getControl(USRGRP_ENTRY);
        int[] selectRows = sourceEntity.getSelectRows();
        if (null == selectRows || selectRows.length < 1) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> resultSet = new HashSet<Long>(selectRows.length);
        DynamicObject[] dataEntitys = sourceEntity.getEntryData().getDataEntitys();
        if (null != dataEntitys && dataEntitys.length > 0) {
            for (int idx : selectRows) {
                resultSet.add(dataEntitys[idx].getLong("usrgrp_id"));
            }
        }
        return resultSet;
    }

    private void signMayChangedUgSet(Set<Long> ugIdSet) {
        if (CollectionUtils.isEmpty(ugIdSet)) {
            return;
        }
        String changedStr = this.getPageCache().get(BUSIROLE_PAGE_KEY_CHANGE_UGS);
        if (StringUtils.isEmpty((String)changedStr)) {
            String ugIdSetStr = ugIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.getPageCache().put(BUSIROLE_PAGE_KEY_CHANGE_UGS, ugIdSetStr);
        } else {
            Set changedSet = Arrays.asList(changedStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
            changedSet.addAll(ugIdSet);
            String afterChangedSetStr = changedSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.getPageCache().put(BUSIROLE_PAGE_KEY_CHANGE_UGS, afterChangedSetStr);
        }
    }

    private Set<Long> getMayChangedUgSet() {
        String changedSetStr = this.getPageCache().get(BUSIROLE_PAGE_KEY_CHANGE_UGS);
        if (StringUtils.isEmpty((String)changedSetStr)) {
            return new HashSet<Long>(1);
        }
        return Arrays.asList(changedSetStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
    }

    private void clearChangeUgSet() {
        this.getPageCache().remove(BUSIROLE_PAGE_KEY_CHANGE_UGS);
    }

    private void doNext() {
        DynamicObject curBizRole;
        Object currPkValue;
        String strCurrPkValue;
        IFormView fv = this.getView();
        BillList billList = (BillList)fv.getParentView().getControl("billlistap");
        AbstractGrid.GridState state = billList.getEntryState();
        int currentPageIndex = state.getCurrentPageIndex();
        ListSelectedRowCollection listAllRow = billList.getCurrentListAllRowCollection();
        Object[] pkValues = listAllRow.toArray();
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkValues != null && pkValues.length > 0) {
            for (int i = 0; i < pkValues.length; ++i) {
                pkList.add(pkValues[i].toString());
            }
        }
        if (StringUtils.isNotEmpty((String)(strCurrPkValue = (currPkValue = (curBizRole = (DynamicObject)this.getModel().getValue(BIZROLE)).get("id")).toString())) && pkList != null && pkList.size() > 0) {
            int index = pkList.indexOf(strCurrPkValue);
            if (index == pkList.size() - 1) {
                String nextPk1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5df2\u662f\u7b2c%s\u9875\u672b\u5f20", (String)"BusiRoleAssignUsrGrpPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), currentPageIndex);
                fv.showMessage(nextPk1);
                return;
            }
            Object nextPk = pkList.get(index + 1);
            String strNextPk = nextPk.toString();
            if (StringUtils.isNotEmpty((String)strNextPk)) {
                this.showForm(strNextPk);
            }
        }
    }

    private void doPrevious() {
        DynamicObject curBizRole;
        Object currPkValue;
        String strCurrPkValue;
        IFormView fv = this.getView();
        BillList billList = (BillList)fv.getParentView().getControl("billlistap");
        AbstractGrid.GridState state = billList.getEntryState();
        int currentPageIndex = state.getCurrentPageIndex();
        ListSelectedRowCollection listAllRow = billList.getCurrentListAllRowCollection();
        Object[] pkValues = listAllRow.toArray();
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkValues != null && pkValues.length > 0) {
            for (int i = 0; i < pkValues.length; ++i) {
                pkList.add(pkValues[i].toString());
            }
        }
        if (StringUtils.isNotEmpty((String)(strCurrPkValue = (currPkValue = (curBizRole = (DynamicObject)this.getModel().getValue(BIZROLE)).get("id")).toString())) && pkList != null && pkList.size() > 0) {
            int index = pkList.indexOf(strCurrPkValue);
            if (index == 0) {
                String previousPk1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5df2\u662f\u7b2c%s\u9875\u9996\u5f20", (String)"BusiRoleAssignUsrGrpPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), currentPageIndex);
                fv.showMessage(previousPk1);
                return;
            }
            Object previousPk = pkList.get(index - 1);
            String strPreviousPk = previousPk.toString();
            if (StringUtils.isNotEmpty((String)strPreviousPk)) {
                this.showForm(strPreviousPk);
            }
        }
    }

    private void doLast() {
        DynamicObject curBizRole;
        Object currPkValue;
        String strCurrPkValue;
        IFormView fv = this.getView();
        BillList billList = (BillList)fv.getParentView().getControl("billlistap");
        AbstractGrid.GridState state = billList.getEntryState();
        int currentPageIndex = state.getCurrentPageIndex();
        ListSelectedRowCollection listAllRow = billList.getCurrentListAllRowCollection();
        Object[] pkValues = listAllRow.toArray();
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkValues != null && pkValues.length > 0) {
            for (int i = 0; i < pkValues.length; ++i) {
                pkList.add(pkValues[i].toString());
            }
        }
        if (StringUtils.isNotEmpty((String)(strCurrPkValue = (currPkValue = (curBizRole = (DynamicObject)this.getModel().getValue(BIZROLE)).get("id")).toString())) && pkList != null && pkList.size() > 0) {
            int index = pkList.indexOf(strCurrPkValue);
            if (index == pkList.size() - 1) {
                String nextPk1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5df2\u662f\u7b2c%s\u9875\u672b\u5f20", (String)"BusiRoleAssignUsrGrpPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), currentPageIndex);
                fv.showMessage(nextPk1);
                return;
            }
            Object lastPk = pkList.get(pkList.size() - 1);
            String strLastPk = lastPk.toString();
            if (StringUtils.isNotEmpty((String)strLastPk)) {
                this.showForm(strLastPk);
            }
        }
    }

    private void doFirst() {
        DynamicObject curBizRole;
        Object currPkValue;
        String strCurrPkValue;
        IFormView fv = this.getView();
        BillList billList = (BillList)fv.getParentView().getControl("billlistap");
        AbstractGrid.GridState state = billList.getEntryState();
        int currentPageIndex = state.getCurrentPageIndex();
        ListSelectedRowCollection listAllRow = billList.getCurrentListAllRowCollection();
        Object[] pkValues = listAllRow.toArray();
        ArrayList<String> pkList = new ArrayList<String>();
        if (pkValues != null && pkValues.length > 0) {
            for (int i = 0; i < pkValues.length; ++i) {
                pkList.add(pkValues[i].toString());
            }
        }
        if (StringUtils.isNotEmpty((String)(strCurrPkValue = (currPkValue = (curBizRole = (DynamicObject)this.getModel().getValue(BIZROLE)).get("id")).toString())) && pkList != null && pkList.size() > 0) {
            int index = pkList.indexOf(strCurrPkValue);
            if (index == 0) {
                String previousPk1 = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u5df2\u662f\u7b2c%s\u9875\u9996\u5f20", (String)"BusiRoleAssignUsrGrpPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), currentPageIndex);
                fv.showMessage(previousPk1);
                return;
            }
            Object firstPk = pkList.get(0);
            String strFirstPk = firstPk.toString();
            if (StringUtils.isNotEmpty((String)strFirstPk)) {
                this.showForm(strFirstPk);
            }
        }
    }

    public void showForm(String bizRoleId) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String pageId = this.getView().getPageId();
        CharSequence[] pageIdSplit = pageId.split("-");
        String oldBizRoleId = pageIdSplit[0];
        pageIdSplit[0] = bizRoleId;
        String newPageId = String.join((CharSequence)"-", pageIdSplit);
        IFormView newFv = this.getView().getView(newPageId);
        if (newFv != null) {
            PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
        } else {
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            param.setCustomParam("id", (Object)Long.valueOf(bizRoleId));
            param.setPageId(newPageId);
            StringBuilder sbErrorInfo = new StringBuilder();
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                MutexHelper.release((String)PERM_BIZROLE_ENTITY, (String)OPERKEY_DONOTHING_BIZROLEASSIGNUSER, (String)oldBizRoleId);
            }
            if (MutexHelper.require((String)PERM_BIZROLE_ENTITY, (Object)bizRoleId, (String)OPERKEY_DONOTHING_BIZROLEASSIGNUSER, (StringBuilder)sbErrorInfo)) {
                this.getView().setStatus(OperationStatus.EDIT);
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
            }
            this.getView().showForm(param);
        }
    }
}

