/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.App;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.busirole.BusiRoleBcFuncPerm;
import kd.bos.permission.model.perm.busirole.BusiRoleComRole;
import kd.bos.permission.model.perm.busirole.BusiRoleDimObj;
import kd.bos.permission.model.perm.busirole.BusiRoleDisFuncPerm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class BusiRoleListPlugin
extends AbstractListPlugin
implements RowClickEventListener,
TreeNodeClickListener {
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final Log logger = LogFactory.getLog(BusiRoleListPlugin.class);
    public static final String BIZROLEASSIGNUSER = "perm_bizroleassignuser";
    public static final String BIZROLEASSIGNUSRGRP = "perm_bizroleassignusrgrp";
    public static final String FSP_BIZROLE_EDIT_FORMNUM = "formShowParm_BizRoleEditFormNum";
    public static final String BTN_NEW = "tblnew";
    public static final String BTN_ASSIGNUSER = "tblassignuser";
    public static final String BTN_ASSIGNUSRGRP = "tblassignusrgrp";
    public static final String CLOSECALLBACK_EDIT = "closeEditForm";
    public static final String BILLLIST = "billlistap";
    public static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private String curCtrlType = "";
    private String curCtrlTypeEntNum = "";
    public static final String PROP_DIM_ENTITYNUM = "dimentitynum";
    public static final String CUSTOMPARAM_SELBUSIROLEGROUP = "selBusiRoleGroup";
    public static final String TREEVIEW_BUSIROLEGROUP = "treeview";

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] perm_ctrltypes;
        Set value;
        DynamicObject[] datas = e.getQueryValues();
        if (null == datas || Objects.equals(0, datas.length)) {
            return;
        }
        Set bizRoleIdSet = Arrays.stream(datas).map(x -> x.getString("id")).collect(Collectors.toSet());
        if (null == bizRoleIdSet || bizRoleIdSet.isEmpty()) {
            return;
        }
        Map bcFuncPermSetMap = PermBusiRoleHelper.getBcFuncPermSetMap(bizRoleIdSet, (String)"id");
        Map disFuncPermSetMap = PermBusiRoleHelper.getDisFuncPermSetMap(bizRoleIdSet, (String)"id");
        HashSet<String> appIdSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        HashSet<String> permItemIdSet = new HashSet<String>(8);
        for (Map.Entry bcFuncPermSet : bcFuncPermSetMap.entrySet()) {
            value = (Set)bcFuncPermSet.getValue();
            if (null == value || value.isEmpty()) continue;
            for (BusiRoleBcFuncPerm funcPerm : value) {
                appIdSet.add(funcPerm.getAppId());
                entNumSet.add(funcPerm.getEntityNumber());
                permItemIdSet.add(funcPerm.getPermItemId());
            }
        }
        for (Map.Entry disFuncPermSet : disFuncPermSetMap.entrySet()) {
            value = (Set)disFuncPermSet.getValue();
            if (null == value || value.isEmpty()) continue;
            for (BusiRoleBcFuncPerm funcPerm : value) {
                appIdSet.add(funcPerm.getAppId());
                entNumSet.add(funcPerm.getEntityNumber());
                permItemIdSet.add(funcPerm.getPermItemId());
            }
        }
        Map cloudDynMap = AppHelper.getCloudMap(new ArrayList(appIdSet));
        Map appDynMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", appIdSet)});
        Map entDynMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", entNumSet)});
        Map permitemDynMap = BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", permItemIdSet)});
        Map comRoleSetMap = PermBusiRoleHelper.getComRoleSetMap(bizRoleIdSet, (String)"id");
        Map<Object, DynamicObject> comRoleDynMap = BusiRoleListPlugin.getComRoleDynMap(comRoleSetMap);
        Map dimObjSetMap = PermBusiRoleHelper.getDimObjSetMap(bizRoleIdSet, (String)"id");
        Map<String, Map<String, Set<Dim>>> dimTypeDimIdDimMap = BusiRoleListPlugin.getDimTypeDimIdDimMap(dimObjSetMap);
        HashMap<String, DynamicObject> permctrltypeMap = new HashMap<String, DynamicObject>(8);
        for (DynamicObject dyn : perm_ctrltypes = BusinessDataServiceHelper.load((String)"perm_ctrltype", (String)"id,number,name, bizobjectid_id", null, null)) {
            permctrltypeMap.put(dyn.getString("bizobjectid_id"), dyn);
        }
        for (DynamicObject data : datas) {
            Set bcFuncPermSet;
            Set dimObjSet;
            String roleId = data.getString("id");
            if (StringUtils.isEmpty((String)roleId)) continue;
            String usertype = data.getString("usertype");
            String userTypeNameStr = PermCommonUtil.getUserTypeNameStrByIdStr((String)usertype);
            data.set("usertype", (Object)userTypeNameStr);
            Set comRoleSet = (Set)comRoleSetMap.get(roleId);
            if (null != comRoleSet && !CollectionUtils.isEmpty((Collection)comRoleSet) && data.containsProperty("role_entry")) {
                DynamicObjectCollection entry_assign_comrole = data.getDynamicObjectCollection("role_entry");
                DynamicObjectType dt = entry_assign_comrole.getDynamicObjectType();
                entry_assign_comrole.clear();
                List comRoleList = comRoleSet.stream().sorted(Comparator.comparing(BusiRoleComRole::getComRoleNumber)).collect(Collectors.toList());
                for (Object one : comRoleList) {
                    String comRoleId;
                    DynamicObject dyn = new DynamicObject(dt);
                    if (dyn.containsProperty("id")) {
                        dyn.set("id", (Object)one.getEntryId());
                    }
                    if (StringUtils.isNotEmpty((String)(comRoleId = one.getComRoleId())) && null != comRoleDynMap.get(comRoleId)) {
                        dyn.set("role_visible", (Object)comRoleDynMap.get(comRoleId));
                    }
                    entry_assign_comrole.add((Object)dyn);
                }
            }
            if (null != (dimObjSet = (Set)dimObjSetMap.get(roleId)) && !CollectionUtils.isEmpty((Collection)dimObjSet) && data.containsProperty("org_entry")) {
                Object one;
                DynamicObjectCollection entry_org_entry = data.getDynamicObjectCollection("org_entry");
                DynamicObjectType dt = entry_org_entry.getDynamicObjectType();
                entry_org_entry.clear();
                List dimObjList = dimObjSet.stream().sorted(Comparator.comparing(BusiRoleDimObj::getDimTypeSmall).thenComparing(BusiRoleDimObj::getDimId)).collect(Collectors.toList());
                one = dimObjList.iterator();
                while (one.hasNext()) {
                    Set<Dim> dimSet;
                    BusiRoleDimObj one2 = (BusiRoleDimObj)one.next();
                    DynamicObject dyn = new DynamicObject(dt);
                    if (dyn.containsProperty("id")) {
                        dyn.set("id", (Object)one2.getEntryId());
                    }
                    String dimTypeSmall = one2.getDimTypeSmall();
                    if (dyn.containsProperty("import_permctrltype") && StringUtils.isNotEmpty((String)dimTypeSmall) && null != permctrltypeMap.get(dimTypeSmall)) {
                        dyn.set("import_permctrltype", permctrltypeMap.get(dimTypeSmall));
                    }
                    Long dimId = one2.getDimId();
                    Map<String, Set<Dim>> dimTypeDimIdDim = dimTypeDimIdDimMap.get(dimTypeSmall);
                    if (StringUtils.isNotEmpty((String)dimTypeSmall) && null != dimId && dimId > 0L && null != dimTypeDimIdDim && !dimTypeDimIdDim.isEmpty() && null != (dimSet = dimTypeDimIdDim.get(String.valueOf(dimId))) && !dimSet.isEmpty()) {
                        Dim dim = (Dim)dimSet.stream().findFirst().get();
                        if (dyn.containsProperty("import_dimnum") && dyn.containsProperty("import_dimname") && null != dim) {
                            dyn.set("import_dimnum", (Object)dim.getDimNumber());
                            dyn.set("import_dimname", (Object)dim.getDimName());
                        }
                    }
                    dyn.set("isincludesuborg_visible", (Object)one2.getIncludeSub());
                    entry_org_entry.add((Object)dyn);
                }
            }
            if (null != (bcFuncPermSet = (Set)bcFuncPermSetMap.get(roleId)) && !CollectionUtils.isEmpty((Collection)bcFuncPermSet) && data.containsProperty("bizroleperm")) {
                DynamicObjectCollection import_entry_bizroleperm = data.getDynamicObjectCollection("bizroleperm");
                DynamicObjectType dt = import_entry_bizroleperm.getDynamicObjectType();
                import_entry_bizroleperm.clear();
                List bcFuncPermList = bcFuncPermSet.stream().sorted(Comparator.comparing(App::getAppId).thenComparing(Entity::getEntityNumber).thenComparing(PermItem::getPermItemId)).collect(Collectors.toList());
                for (BusiRoleBcFuncPerm one : bcFuncPermList) {
                    DynamicObject app;
                    DynamicObject dyn = new DynamicObject(dt);
                    if (dyn.containsProperty("id")) {
                        dyn.set("id", (Object)one.getEntryId());
                    }
                    String appId = one.getAppId();
                    DynamicObject cloud = (DynamicObject)cloudDynMap.get(appId);
                    if (dyn.containsProperty("import_cloud") && null != cloud) {
                        dyn.set("import_cloud", (Object)cloud.getDynamicObject("bizcloud"));
                    }
                    if (null == (app = (DynamicObject)appDynMap.get(appId))) continue;
                    dyn.set("bizapp", (Object)app);
                    DynamicObject ent = (DynamicObject)entDynMap.get(one.getEntityNumber());
                    if (null == ent) continue;
                    dyn.set("entitytype", (Object)ent);
                    DynamicObject permItem = (DynamicObject)permitemDynMap.get(one.getPermItemId());
                    if (null == permItem) continue;
                    dyn.set("permitem", (Object)permItem);
                    import_entry_bizroleperm.add((Object)dyn);
                }
            }
            Set disFuncPermSet = (Set)disFuncPermSetMap.get(roleId);
            if (null == bcFuncPermSet || CollectionUtils.isEmpty((Collection)disFuncPermSet) || !data.containsProperty("bizroledisperm")) continue;
            DynamicObjectCollection import_entry_bizroledisperm = data.getDynamicObjectCollection("bizroledisperm");
            DynamicObjectType dt = import_entry_bizroledisperm.getDynamicObjectType();
            import_entry_bizroledisperm.clear();
            List disFuncPermList = disFuncPermSet.stream().sorted(Comparator.comparing(App::getAppId).thenComparing(Entity::getEntityNumber).thenComparing(PermItem::getPermItemId)).collect(Collectors.toList());
            for (BusiRoleDisFuncPerm one : disFuncPermList) {
                DynamicObject app;
                DynamicObject dyn = new DynamicObject(dt);
                if (dyn.containsProperty("id")) {
                    dyn.set("id", (Object)one.getEntryId());
                }
                String appId = one.getAppId();
                DynamicObject cloud = (DynamicObject)cloudDynMap.get(appId);
                if (dyn.containsProperty("import_cloud_dis") && null != cloud) {
                    dyn.set("import_cloud_dis", (Object)cloud.getDynamicObject("bizcloud"));
                }
                if (null == (app = (DynamicObject)appDynMap.get(appId))) continue;
                dyn.set("bizappforbid", (Object)app);
                DynamicObject ent = (DynamicObject)entDynMap.get(one.getEntityNumber());
                if (null == ent) continue;
                dyn.set("entitytypeforbid", (Object)ent);
                DynamicObject permItem = (DynamicObject)permitemDynMap.get(one.getPermItemId());
                if (null == permItem) continue;
                dyn.set("permitemforbid", (Object)permItem);
                import_entry_bizroledisperm.add((Object)dyn);
            }
        }
    }

    private static Map<Object, DynamicObject> getComRoleDynMap(Map<String, Set<BusiRoleComRole>> comRoleSetMap) {
        HashSet<String> comRoleIdSet = new HashSet<String>(8);
        for (Map.Entry<String, Set<BusiRoleComRole>> comRoleSet : comRoleSetMap.entrySet()) {
            Set<BusiRoleComRole> value = comRoleSet.getValue();
            if (null == value || value.isEmpty()) continue;
            for (BusiRoleComRole one : value) {
                comRoleIdSet.add(one.getComRoleId());
            }
        }
        Map comRoleDynMap = BusinessDataServiceHelper.loadFromCache((String)"perm_role", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", comRoleIdSet)});
        return comRoleDynMap;
    }

    private static Map<String, Map<String, Set<Dim>>> getDimTypeDimIdDimMap(Map<String, Set<BusiRoleDimObj>> dimObjSetMap) {
        HashMap<String, Map<String, Set<Dim>>> dimTypeDimIdDimMap = new HashMap<String, Map<String, Set<Dim>>>(8);
        HashMap<String, Set> dimTypeSmallDimIdSetMap = new HashMap<String, Set>(8);
        for (Map.Entry<String, Set<BusiRoleDimObj>> entry : dimObjSetMap.entrySet()) {
            Set<BusiRoleDimObj> value = entry.getValue();
            if (null == value || value.isEmpty()) continue;
            for (BusiRoleDimObj one : value) {
                String dimTypeSmall = one.getDimTypeSmall();
                Long dimId = one.getDimId();
                dimTypeSmallDimIdSetMap.computeIfAbsent(dimTypeSmall, k -> new HashSet(8)).add(StringUtils.getStringValue((Object)dimId));
            }
        }
        if (null != dimTypeSmallDimIdSetMap && !dimTypeSmallDimIdSetMap.isEmpty()) {
            for (Map.Entry<String, Set<Object>> entry : dimTypeSmallDimIdSetMap.entrySet()) {
                String dimTypeSmall = entry.getKey();
                Set<Object> dimIdSet = entry.getValue();
                if (StringUtils.isEmpty((String)dimTypeSmall) || CollectionUtils.isEmpty(dimIdSet)) continue;
                Map dimIdDimSetMap = IsoDimHelper.getDimSetMap(dimIdSet, (String)"id", (String)dimTypeSmall);
                dimTypeDimIdDimMap.put(dimTypeSmall, dimIdDimSetMap);
            }
        }
        return dimTypeDimIdDimMap;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        Map customParams = e.getParameter().getCustomParams();
        Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.putAll(originalCustParams);
        String customBizRoleEditFormNum = this.getBizRoleEditFormNum();
        if (StringUtils.isNotEmpty((String)customBizRoleEditFormNum)) {
            e.getParameter().setFormId(customBizRoleEditFormNum);
        }
        String pkValue = String.valueOf(this.getFocusRowPkId());
        String pageId = this.getView().getPageId() + "_perm_busirole_" + pkValue;
        IFormView iFormView = this.getView().getView(pageId);
        if (iFormView == null) {
            this.recordOpenedChildPage(pageId);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        String showFormSpecial = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)fsp.getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        ListShowParameter lsp = (ListShowParameter)fsp;
        if (!lsp.isLookUp()) {
            PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
        }
    }

    public void initialize() {
        TreeView tv;
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow", "iscontainlower"});
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        boolean lookUp = lsp.isLookUp();
        if (!lookUp) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        }
        if ((tv = (TreeView)this.getControl(TREEVIEW_BUSIROLEGROUP)) != null) {
            tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        this.curCtrlType = this.getCtrlType();
        this.curCtrlTypeEntNum = this.getCtrlTypeEntityNum();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String source = e.getSource().toString();
        if (source.contains("switchbizrole")) {
            return;
        }
        String childPageSetJson = this.getPageCache().get("childPageSet");
        if (StringUtils.isNotEmpty((String)childPageSetJson)) {
            Set childPageSet = (Set)JSON.parseObject((String)childPageSetJson, Set.class);
            for (String childPageId : childPageSet) {
                IFormView view = this.getView().getView(childPageId);
                if (view == null) continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u672a\u5173\u95ed\u7684\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u7f16\u8f91\u72b6\u6001\u9875\u7b7e\uff0c\u8bf7\u5148\u5173\u95ed\u540e\u518d\u9000\u51fa\uff0c\u7f16\u8f91\u72b6\u6001\u7684\u9875\u7b7e\u53ef\u80fd\u6709\uff1a\u201c\u5206\u914d\u7528\u6237\u201d\u3001\u201c\u5206\u914d\u7528\u6237\u7ec4\u201d\u7b49\u3002", (String)"BusiRoleListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    private void showBizRoleAssignUser(String formId, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        BillList billList = (BillList)this.getControl(BILLLIST);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"BusiRoleListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        Long bizroleId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        param.put("id", bizroleId);
        param.put("FromList", "true");
        this.showForm(formId, param, new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_EDIT), afterDoOperationEventArgs);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getActionId().equals(CLOSECALLBACK_EDIT)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            billList.refresh();
        }
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (params == null) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        IFormView fv = null;
        String bizRoleId = params.get("id").toString();
        String newPageId = bizRoleId + "-" + formId + "-" + this.getView().getPageId();
        fsp.setPageId(newPageId);
        fv = this.getView().getView(newPageId);
        if (fv == null) {
            StringBuilder sbErrorInfo = new StringBuilder();
            String opkey = formId.equals(BIZROLEASSIGNUSER) ? "donothing_bizroleassignuser" : "donothing_bizroleassignusrgrp";
            boolean require = MutexHelper.require((String)"perm_busirole", (Object)bizRoleId, (String)opkey, (StringBuilder)sbErrorInfo);
            IPageCache pageCache = this.getPageCache();
            String type = "BUSIROLE_MUTEXT_TYPE|" + pageCache.getPageId();
            HashMap<String, String> busiRoleMutexTypeMap = CacheMrg.getCache((String)type);
            if (CollectionUtils.isEmpty((Map)busiRoleMutexTypeMap)) {
                busiRoleMutexTypeMap = new HashMap<String, String>(8);
            }
            busiRoleMutexTypeMap.put(opkey, "perm_busirole|" + bizRoleId);
            CacheMrg.putCache((String)type, busiRoleMutexTypeMap);
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (!operationResult.isSuccess()) {
                operationResult.setSuccess(true);
                List allErrorInfos = operationResult.getAllErrorInfo();
                if (!CollectionUtils.isEmpty((Collection)allErrorInfos)) {
                    allErrorInfos.removeIf(allErrorInfo -> "datamutex".equals(allErrorInfo.getErrorCode()));
                }
            }
            if (!require) {
                this.getView().showMessage(sbErrorInfo.toString());
                fsp.setStatus(OperationStatus.VIEW);
            } else {
                fsp.setStatus(OperationStatus.EDIT);
            }
            this.recordOpenedChildPage(newPageId);
        }
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId(formId);
        if (BIZROLEASSIGNUSRGRP.equals(formId)) {
            fsp.setCaption(ResManager.loadKDString((String)"\u5206\u914d\u7528\u6237\u7ec4", (String)"BusiRoleListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        fsp.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        fsp.getCustomParams().putAll(params);
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(fsp);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        IPageCache pageCache = this.getPageCache();
        String type = "BUSIROLE_MUTEXT_TYPE|" + pageCache.getPageId();
        Map busiRoleMutexTypeMap = CacheMrg.getCache((String)type);
        if (CollectionUtils.isEmpty((Map)busiRoleMutexTypeMap)) {
            CacheMrg.clearCache((String)type);
            return;
        }
        for (Map.Entry entry : busiRoleMutexTypeMap.entrySet()) {
            String mutex_oper_key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] split = value.split("\\|");
            String mutex_entity_key = split[0];
            String mutex_obj_id = split[1];
            MutexHelper.release((String)mutex_entity_key, (String)mutex_oper_key, (String)mutex_obj_id);
        }
        CacheMrg.clearCache((String)type);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter resultFilter = null;
        String curUserType = RequestContext.get().getUserType();
        ArrayList<String> userTypeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)curUserType)) {
            String[] userTypes = curUserType.split(",");
            for (String string : userTypes) {
                if (StringUtils.isEmpty((String)string) || "7".equals(string)) continue;
                String string2 = string.trim();
                userTypeList.add(string2);
            }
        }
        if (userTypeList != null && !userTypeList.isEmpty()) {
            QFilter userTypeFilter = null;
            for (String string : userTypeList) {
                if (userTypeFilter == null) {
                    userTypeFilter = new QFilter("usertype", "like", (Object)("%," + string + ",%")).or(new QFilter("usertype", "=", (Object)string)).or(new QFilter("usertype", "like", (Object)("%," + string))).or(new QFilter("usertype", "like", (Object)(string + ",%")));
                    continue;
                }
                userTypeFilter = userTypeFilter.or(new QFilter("usertype", "like", (Object)("%," + string + ",%"))).or(new QFilter("usertype", "=", (Object)string)).or(new QFilter("usertype", "like", (Object)("%," + string))).or(new QFilter("usertype", "like", (Object)(string + ",%")));
            }
            resultFilter = userTypeFilter;
        }
        e.getQFilters().add(resultFilter);
    }

    private String getCtrlType() {
        String ctrlType = this.getPageCache().get("FormShowParam_dimension");
        if (StringUtils.isNotEmpty((String)ctrlType)) {
            return ctrlType;
        }
        ctrlType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension");
        if (StringUtils.isEmpty((String)ctrlType)) {
            ctrlType = "DIM_ORG";
        } else {
            DynamicObject curCtryTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"number", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "=", (Object)ctrlType)});
            if (curCtryTypeObj != null) {
                ctrlType = curCtryTypeObj.getString("number");
            }
        }
        this.getPageCache().put("FormShowParam_dimension", ctrlType);
        return ctrlType;
    }

    private String getCtrlTypeEntityNum() {
        String ctrlTypeEntNum = this.getPageCache().get("FormShowParam_CtrlType_EntityNum");
        if (StringUtils.isNotEmpty((String)ctrlTypeEntNum)) {
            return ctrlTypeEntNum;
        }
        ctrlTypeEntNum = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_CtrlType_EntityNum");
        if (StringUtils.isNotEmpty((String)ctrlTypeEntNum)) {
            this.getPageCache().put("FormShowParam_CtrlType_EntityNum", ctrlTypeEntNum);
            return ctrlTypeEntNum;
        }
        DynamicObject curCtrlTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"bizobjectid.id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.curCtrlType)});
        ctrlTypeEntNum = curCtrlTypeObj.getString("bizobjectid.id");
        this.getPageCache().put("FormShowParam_CtrlType_EntityNum", ctrlTypeEntNum);
        return ctrlTypeEntNum;
    }

    private String getBizRoleEditFormNum() {
        String bizRoleEditFormNum = (String)this.getView().getFormShowParameter().getCustomParam(FSP_BIZROLE_EDIT_FORMNUM);
        if (StringUtils.isNotEmpty((String)bizRoleEditFormNum)) {
            return bizRoleEditFormNum;
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate formOperate = (FormOperate)args.getSource();
            String operationKey = formOperate.getOperateKey();
            if (Objects.equals("donothing_roleassignuserlist", operationKey) || Objects.equals("donothing_roleassignusrgrplist", operationKey)) {
                String formId = "donothing_roleassignuserlist".equals(operationKey) ? "perm_busiroleuser_layout" : "perm_busiroleusrgrp_layout";
                String newPageId = formId + "-" + this.getView().getPageId();
                IFormView fv = this.getView().getView(newPageId);
                if (fv != null) {
                    PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                    args.setCancel(true);
                }
                return;
            }
            if ("delete".equals(operationKey)) {
                Object[] selectedIdArr = args.getListSelectedData().getPrimaryKeyValues();
                if (null == selectedIdArr || 0 == selectedIdArr.length) {
                    return;
                }
                OperateOption option = formOperate.getOption();
                if (PermCommonUtil.isEnablePermLog()) {
                    option.setVariableValue("ENTSAVE_PERMLOG", "1");
                    option.setVariableValue("permlog_op", "delete");
                    option.setVariableValue("permlog_opbtn", ConstantsHelper.getDel());
                    option.setVariableValue("permlog_interfacemethod", "kd.bos.permission.formplugin.BusiRoleListPlugin.beforeDoOperation");
                    option.setVariableValue("permlog_busitype", "busirole_role_del");
                    option.setVariableValue("permlog_formnum", "perm_busirole");
                }
            } else if ("donothing_bizroleassignuser".equals(operationKey) || "donothing_bizroleassignusrgrp".equals(operationKey)) {
                IFormView fv = null;
                Object[] selectedIdArr = args.getListSelectedData().getPrimaryKeyValues();
                if (null == selectedIdArr || selectedIdArr.length != 1) {
                    return;
                }
                String formId = "donothing_bizroleassignuser".equals(operationKey) ? BIZROLEASSIGNUSER : BIZROLEASSIGNUSRGRP;
                Long bizRoleId = (Long)selectedIdArr[0];
                String newPageId = bizRoleId + "-" + formId + "-" + this.getView().getPageId();
                fv = this.getView().getView(newPageId);
                if (fv != null) {
                    PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                    args.setCancel(true);
                }
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tv = (TreeView)this.getControl(TREEVIEW_BUSIROLEGROUP);
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        if (StringUtils.isNotEmpty((String)focusNodeId)) {
            if (ROOTNODEID.equals(focusNodeId)) {
                this.getView().getPageCache().remove(CUSTOMPARAM_SELBUSIROLEGROUP);
            } else {
                this.getView().getPageCache().put(CUSTOMPARAM_SELBUSIROLEGROUP, focusNodeId);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (Objects.equals("donothing_roleassignuserlist", operateKey) || Objects.equals("donothing_roleassignusrgrplist", operateKey)) {
            ListShowParameter lsp = new ListShowParameter();
            String formId = "donothing_roleassignuserlist".equals(operateKey) ? "perm_busiroleuser_layout" : "perm_busiroleusrgrp_layout";
            lsp.setBillFormId(formId);
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.setPageId(formId + "-" + this.getView().getPageId());
            this.getView().showForm((FormShowParameter)lsp);
            return;
        }
        if ("donothing_bizroleassignuser".equals(operateKey)) {
            this.showBizRoleAssignUser(BIZROLEASSIGNUSER, afterDoOperationEventArgs);
        } else if ("donothing_bizroleassignusrgrp".equals(operateKey)) {
            this.showBizRoleAssignUser(BIZROLEASSIGNUSRGRP, afterDoOperationEventArgs);
        }
    }

    private void recordOpenedChildPage(String childPageId) {
        String childPageSetJson = this.getPageCache().get("childPageSet");
        HashSet<String> childPageSet = StringUtils.isNotEmpty((String)childPageSetJson) ? (HashSet<String>)JSON.parseObject((String)childPageSetJson, HashSet.class) : new HashSet<String>(8);
        childPageSet.add(childPageId);
        this.getPageCache().put("childPageSet", JSON.toJSONString(childPageSet));
    }
}

