/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.oprule.AbstractOperationRuleFromPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.OprLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class OperationRuleDirectorEditPlugin
extends AbstractOperationRuleFromPlugin {
    private Log logger = LogFactory.getLog(OperationRuleDirectorEditPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (isSuperUser) {
            return;
        }
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (isAdminUser) {
            return;
        }
        String formId = e.getFormShowParameter().getParentFormId();
        if (formId == null || !formId.equals("perm_operationruleassign") && !formId.equals("ide_formdesigner")) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u8bbf\u95ee\u5f53\u524d\u9875\u9762\u3002", (String)"OperationRuleDirectorEditPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        MulBasedataEdit userRef = (MulBasedataEdit)this.getView().getControl("userref");
        userRef.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                ArrayList<QFilter> qList = new ArrayList<QFilter>();
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                qList.add(enableFilter);
                ((ListShowParameter)evt.getFormShowParameter()).setListFilterParameter(new ListFilterParameter(qList, null));
            }
        });
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && (key = (btn = (Button)source).getKey()).equals("btnok")) {
            this.saveDirectorInfo();
            this.getView().close();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (key.equals("btnnew")) {
            MulBasedataEdit userRef = (MulBasedataEdit)this.getView().getControl("userref");
            Set<Long> rowIdSet = PermFormCommonUtil.getAllLongIdSet(this.getModel(), "entryentity", "name");
            this.getModel().setValue("userref", (Object)rowIdSet.toArray());
            userRef.click();
        }
    }

    private boolean validate() {
        DynamicObjectCollection newDoc = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < newDoc.size(); ++i) {
            DynamicObject newDObj = (DynamicObject)newDoc.get(i);
            Object director = newDObj.get("name");
            DynamicObjectCollection dept = newDObj.getDynamicObjectCollection("dept");
            if (director == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u7ba1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OperationRuleDirectorEditPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return false;
            }
            if (dept != null && dept.size() != 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u8d1f\u8d23\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OperationRuleDirectorEditPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return false;
        }
        return true;
    }

    private void saveDirectorInfo() {
        String langStr;
        if (!this.validate()) {
            return;
        }
        String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
        Map oprObjMap = OprLogHelper.getOpr((String)opRuleObjId, (String)(langStr = RequestContext.get().getLang().name()));
        if (CollectionUtils.isEmpty((Map)oprObjMap)) {
            return;
        }
        String opRuleId = (String)oprObjMap.get("foperationruleid");
        String appId = (String)oprObjMap.get("fbizappid");
        String entityNum = (String)oprObjMap.get("fentitytypeid");
        String opRuleName = (String)oprObjMap.get("oprrulename");
        PermLogBusiType permLogBusiType = null;
        String preData = "";
        boolean enablePermLog = PermCommonUtil.isEnablePermLog();
        if (enablePermLog) {
            permLogBusiType = PermLogService.getPermLogBusiType((String)"opr_director");
        }
        if (enablePermLog) {
            preData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)false, (PermLogBusiType)permLogBusiType, (String)appId, (String)entityNum, null);
        }
        try {
            StringBuilder sb = new StringBuilder("id").append(", ").append("operationruleobj").append(", ").append("director").append(", ").append("org");
            String selectedFields = sb.toString();
            DynamicObject[] oldDoc = BusinessDataServiceHelper.load((String)"perm_director", (String)selectedFields, (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)opRuleObjId)});
            DynamicObjectCollection newDoc = this.getModel().getEntryEntity("entryentity");
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)"perm_director");
            ArrayList<String> forDeleteIds = new ArrayList<String>();
            for (DynamicObject oldDObj : oldDoc) {
                String oldId = oldDObj.getString("id");
                forDeleteIds.add(oldId);
            }
            boolean hasDel = false;
            if (forDeleteIds != null && forDeleteIds.size() != 0) {
                DeleteServiceHelper.delete((IDataEntityType)met, (Object[])forDeleteIds.toArray());
                hasDel = true;
            }
            boolean needSave = false;
            ArrayList<DynamicObject> listForSaveObj = new ArrayList<DynamicObject>();
            for (int i = 0; i < newDoc.size(); ++i) {
                DynamicObject newDObj = (DynamicObject)newDoc.get(i);
                DynamicObjectCollection deptDoc = newDObj.getDynamicObjectCollection("dept");
                for (int j = 0; j < deptDoc.size(); ++j) {
                    DynamicObject forSaveObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_director");
                    forSaveObj.set("operationruleobj", (Object)opRuleObjId);
                    forSaveObj.set("director", newDObj.getDynamicObject("name").get("id"));
                    forSaveObj.set("org", ((DynamicObject)deptDoc.get(j)).get("fbasedataid_id"));
                    listForSaveObj.add(forSaveObj);
                    needSave = true;
                }
            }
            SaveServiceHelper.save((DynamicObject[])listForSaveObj.toArray(new DynamicObject[0]));
            if (hasDel || needSave) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OperationRuleDirectorEditPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                CacheMrg.clearCache((String)CacheMrg.getType4OperationRuleObj());
                CacheMrg.clearCache((String)CacheMrg.getType4OperationRule());
            } else {
                this.getView().close();
            }
        }
        catch (Exception e) {
            this.logger.warn("\u7279\u6b8a\u6570\u636e\u6743\u9650-\u6307\u5b9a\u4e3b\u7ba1 \u4fdd\u5b58\u51fa\u9519\uff1a" + e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u51fa\u9519\uff1a", (String)"OperationRuleDirectorEditPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]) + e.getMessage());
        }
        if (enablePermLog) {
            String afterData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)true, (PermLogBusiType)permLogBusiType, (String)appId, (String)entityNum, (String)preData);
            String opbtn = ConstantsHelper.getSave();
            this.oprEvent2PermLog("btnok", opbtn, appId, opRuleId, opRuleName, preData, afterData, permLogBusiType);
        }
    }

    private void oprEvent2PermLog(String op, String opbtn, String selectAppId, String opItemId, String opItemName, String preData, String afterData, PermLogBusiType permLogBusiType) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.OperationRuleDirectorEditPlugin.oprEvent2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            map.put("op_desc", kd.bos.permission.log.helper.ConstantsHelper.getOprAffectUserDesc((String)selectAppId, (PermLogBusiType)permLogBusiType));
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            this.logger.warn("OperationRuleDirectorEditPlugin.oprEvent2PermLog error, opItemId:{}, opItemName:{}", new Object[]{opItemId, opItemName, e});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("userref")) {
            DynamicObjectCollection doc = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            this.fillDirector(doc);
        }
    }

    private void fillDirector(DynamicObjectCollection pNewData) {
        int j;
        for (int i = 0; i < pNewData.size(); ++i) {
            long mainOrgId;
            DynamicObject dObj = (DynamicObject)pNewData.get(i);
            DynamicObject director = dObj.getDynamicObject("FBasedataId");
            Long newDirectorId = director.getLong("id");
            boolean ifFound = false;
            DynamicObjectCollection curList = this.getModel().getEntryEntity("entryentity");
            for (j = 0; j < curList.size(); ++j) {
                Long curRowId;
                DynamicObject curRow = (DynamicObject)curList.get(j);
                DynamicObject curDirector = curRow.getDynamicObject("name");
                if (curDirector == null || !newDirectorId.equals(curRowId = Long.valueOf(curDirector.getLong("id")))) continue;
                ifFound = true;
                break;
            }
            if (ifFound) continue;
            int newRowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("name", (Object)newDirectorId, newRowIndex);
            String[] arrPosition = this.queryPosition(newDirectorId);
            if (arrPosition == null || arrPosition.length != 2) continue;
            this.getModel().setValue("position", (Object)arrPosition, newRowIndex);
            ArrayList<Long> inChargeOrgIds = UserServiceHelper.getInchargeOrgs((long)newDirectorId, (boolean)false);
            if ((inChargeOrgIds == null || inChargeOrgIds.size() == 0) && (mainOrgId = UserServiceHelper.getUserMainOrgId((long)newDirectorId)) != 0L) {
                inChargeOrgIds = new ArrayList<Long>();
                inChargeOrgIds.add(mainOrgId);
            }
            if (inChargeOrgIds == null || inChargeOrgIds.size() <= 0) continue;
            this.getModel().setValue("dept", (Object)inChargeOrgIds.toArray(), newRowIndex);
        }
        DynamicObjectCollection curList = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < curList.size(); ++i) {
            DynamicObject curRow = (DynamicObject)curList.get(i);
            DynamicObject curDirector = curRow.getDynamicObject("name");
            if (curDirector == null) continue;
            Long curRowId = curDirector.getLong("id");
            boolean ifFound = false;
            for (j = 0; j < pNewData.size(); ++j) {
                DynamicObject newDObj = (DynamicObject)pNewData.get(j);
                DynamicObject newDirector = newDObj.getDynamicObject("FBasedataId");
                Long newDirectorId = newDirector.getLong("id");
                if (!newDirectorId.equals(curRowId)) continue;
                ifFound = true;
                break;
            }
            if (ifFound) continue;
            this.getModel().deleteEntryRow("entryentity", i);
        }
    }

    private String[] queryPosition(Long userId) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"bos_user", (String)"id, entryentity.position posName", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)}, (String)"entryentity.ispartjob asc");
        if (doc != null && doc.size() > 0) {
            DynamicObject dObj = (DynamicObject)doc.get(0);
            String posName = dObj.getString("posName");
            String positionName = dObj.getString("posName");
            return new String[]{posName, positionName};
        }
        return new String[0];
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadDirectorInfo();
    }

    private void loadDirectorInfo() {
        String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"perm_director", null, (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)opRuleObjId)}, null);
        HashMap<Long, List> userOrgsMap = new HashMap<Long, List>();
        for (DynamicObject dObj : doc) {
            Long userId = dObj.getLong("director.id");
            Long orgId = dObj.getLong("org.id");
            userOrgsMap.computeIfAbsent(userId, k -> new ArrayList()).add(orgId);
        }
        for (Map.Entry entry : userOrgsMap.entrySet()) {
            int curRowIndex = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setEntryCurrentRowIndex("entryentity", curRowIndex);
            Long userId = (Long)entry.getKey();
            String[] posInfo = this.queryPosition(userId);
            if (posInfo != null && posInfo.length == 2) {
                this.getModel().setValue("position", (Object)posInfo[0], curRowIndex);
            }
            this.getModel().setValue("name", (Object)userId, curRowIndex);
            this.getModel().setValue("dept", (Object)((List)userOrgsMap.get(userId)).toArray(), curRowIndex);
        }
    }
}

