/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.AllFuncPermTreeUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.OprLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class OperationRuleEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(OperationRuleEditPlugin.class);
    private static final String PROP_OPERATION_KEY = "operation_key";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String PERM_OPERATIONRULEASSIGN_ENTITY = "perm_operationruleassign";
    private static final String ENABLE = "objenabled";
    private static final String RULE_ID = "operationrule";
    private static final String PROP_ENTITYTYPEID = "fentitytypeid";

    public void initialize() {
        super.initialize();
        this.addListener();
    }

    private String getOperationRuleId() {
        String operationRuleId = (String)this.getView().getFormShowParameter().getCustomParam("paramOperationRuleId");
        return operationRuleId;
    }

    private String getBizObject() {
        String bizObjectId = (String)this.getView().getFormShowParameter().getCustomParam("paramBizObjectId");
        return bizObjectId;
    }

    private String getNodeType() {
        String nodeType = (String)this.getView().getFormShowParameter().getCustomParam("nodeType");
        return nodeType;
    }

    private String getEntityNumFromNodeId(String pNodeId) {
        String entityNum = AllFuncPermTreeUtil.getEntityNumFromNodeId(pNodeId);
        entityNum = FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId();
        return entityNum;
    }

    private String getAppIdFromNodeId(String pNodeId) {
        String appId = pNodeId.substring(pNodeId.indexOf(64) + 1, pNodeId.indexOf(35));
        return appId;
    }

    private boolean getIsPublic() {
        String ispublic = (String)this.getView().getFormShowParameter().getCustomParam("paramIspulic");
        return "1".equals(ispublic) || "true".equals(ispublic);
    }

    private String getPreset() {
        String isPreset = (String)this.getView().getFormShowParameter().getCustomParam("paramIspreset");
        if (StringUtils.isEmpty((String)isPreset)) {
            isPreset = "false";
        }
        return isPreset;
    }

    private DynamicObject getOperationRuleData() {
        String operationRuleId = this.getOperationRuleId();
        if (StringUtils.isEmpty((String)operationRuleId)) {
            return null;
        }
        DynamicObject operationRule = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_operationrule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)operationRuleId)});
        return operationRule;
    }

    private void initializeFilterCondition() {
        DynamicObject operationRule = this.getOperationRuleData();
        if (operationRule == null) {
            return;
        }
        String ruleJson = operationRule.getString("rule");
        ruleJson = PermCommonUtil.replaceBackSlach((String)ruleJson);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJson, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl("rule");
        filterGrid.SetValue(filterCondition);
        this.getView().updateView("rule");
    }

    private void initializeData() {
        String strIsPreset = this.getPreset();
        boolean isPublic = this.getIsPublic();
        String bizObjectId = this.getBizObject();
        String nodeType = this.getNodeType();
        boolean isPreset = strIsPreset.equals("true");
        if (isPublic) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizobject"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizapp"});
            this.getModel().setValue("ispublic", (Object)isPublic);
        }
        if (isPreset) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizobject"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizapp"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_delete"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_saveandnew"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_applyorg"});
            PermFormCommonUtil.setFilterGridAddBtnVisible(this.getView(), "rule", false);
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"operation"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"rule"});
            this.getModel().setValue("ispreset", (Object)isPreset);
        }
        if ("#entity".equals(nodeType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_applyorg"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_applyorg"});
        }
        if (isPublic && "#entity".equals(nodeType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_delete"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_saveandnew"});
            PermFormCommonUtil.setFilterGridAddBtnVisible(this.getView(), "rule", false);
            this.getView().setEnable(Boolean.FALSE, new String[]{"name"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"operation"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"rule"});
        }
        String entityNum = null;
        String appId = null;
        if (bizObjectId != null && bizObjectId.endsWith("#entity")) {
            entityNum = this.getEntityNumFromNodeId(bizObjectId);
            appId = this.getAppIdFromNodeId(bizObjectId);
        }
        this.getModel().setValue("bizobject", entityNum);
        this.getModel().setValue("bizapp", appId);
        DynamicObject operationRule = this.getOperationRuleData();
        if (operationRule == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_delete"});
            return;
        }
        String operationRuleId = this.getOperationRuleId();
        ILocaleString operationRuleName = operationRule.getLocaleString("name");
        String operationType = operationRule.getString("operation_type");
        String operationKey = operationRule.getString(PROP_OPERATION_KEY);
        Map operationInfoMap = OperationHelper.getOperationTypeInfoMap((String)entityNum);
        Map operationKeyMap = OperationHelper.getOperationInfoMap((String)entityNum);
        String operationName = (String)operationInfoMap.get(operationType);
        if (StringUtils.isNotEmpty((String)operationKey) && operationKeyMap != null) {
            operationName = (String)operationKeyMap.get(operationKey);
        }
        IDataModel iDataModel = this.getModel();
        iDataModel.setValue("operationrule_id", (Object)operationRuleId);
        iDataModel.setValue("name", (Object)operationRuleName);
        iDataModel.setValue("operation_type", (Object)operationType);
        iDataModel.setValue("operation", (Object)operationName);
        iDataModel.setValue(PROP_OPERATION_KEY, (Object)operationKey);
    }

    private void addListener() {
        TextEdit operation = (TextEdit)this.getControl("operation");
        operation.addButtonClickListener(new ClickListener(){

            public void click(EventObject evt) {
                OperationRuleEditPlugin.this.showChoiceOperationPage();
            }
        });
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                String langStr = RequestContext.get().getLang().name();
                String preData = "";
                String busiFrom = "";
                String preOprId = (String)OperationRuleEditPlugin.this.getModel().getValue("operationrule_id");
                PermLogBusiType permLogBusiType = null;
                boolean saveOk = false;
                boolean enablePermLog = PermCommonUtil.isEnablePermLog();
                if (enablePermLog) {
                    permLogBusiType = StringUtils.isEmpty((String)preOprId) ? PermLogService.getPermLogBusiType((String)"opr_add_save") : PermLogService.getPermLogBusiType((String)"opr_modify_save");
                }
                switch (itemKey) {
                    case "btn_saveandnew": {
                        if (enablePermLog) {
                            preData = OprLogHelper.oprEventImage((String)preOprId, (String)langStr, (boolean)false, (PermLogBusiType)permLogBusiType, null, null, null);
                        }
                        saveOk = OperationRuleEditPlugin.this.save();
                        if (enablePermLog && saveOk) {
                            String afterOpRuleId = (String)OperationRuleEditPlugin.this.getModel().getValue("operationrule_id");
                            String opRuleName = ((ILocaleString)OperationRuleEditPlugin.this.getModel().getValue("name")).getLocaleValue();
                            String afterData = OprLogHelper.oprEventImage((String)afterOpRuleId, (String)langStr, (boolean)true, (PermLogBusiType)permLogBusiType, null, null, (String)preData);
                            String opbtn = ConstantsHelper.getSaveAndAdd();
                            OperationRuleEditPlugin.this.oprEvent2PermLog(itemKey, opbtn, afterOpRuleId, opRuleName, preData, afterData, permLogBusiType);
                        }
                        if (!saveOk) break;
                        OperationRuleEditPlugin.this.addNew();
                        break;
                    }
                    case "btn_save": {
                        if (enablePermLog) {
                            preData = OprLogHelper.oprEventImage((String)preOprId, (String)langStr, (boolean)false, (PermLogBusiType)permLogBusiType, null, null, null);
                        }
                        saveOk = OperationRuleEditPlugin.this.save();
                        if (!enablePermLog || !saveOk) break;
                        String afterOpRuleId = (String)OperationRuleEditPlugin.this.getModel().getValue("operationrule_id");
                        String opRuleName = ((ILocaleString)OperationRuleEditPlugin.this.getModel().getValue("name")).getLocaleValue();
                        String afterData = OprLogHelper.oprEventImage((String)afterOpRuleId, (String)langStr, (boolean)true, (PermLogBusiType)permLogBusiType, null, null, (String)preData);
                        String opbtn = ConstantsHelper.getSave();
                        OperationRuleEditPlugin.this.oprEvent2PermLog(itemKey, opbtn, afterOpRuleId, opRuleName, preData, afterData, permLogBusiType);
                        break;
                    }
                    case "btn_delete": {
                        OperationRuleEditPlugin.this.ifDel();
                        break;
                    }
                    case "btn_applyorg": {
                        OperationRuleEditPlugin.this.showApplyOrg();
                        break;
                    }
                }
            }
        });
    }

    private void oprEvent2PermLog(String op, String opbtn, String opItemId, String opItemName, String preData, String afterData, PermLogBusiType permLogBusiType) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.OperationRuleEditPlugin.oprEvent2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            String bizAppId = "";
            DynamicObject entityType = (DynamicObject)this.getModel().getValue("bizobject");
            DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
            if (entityType != null) {
                bizAppId = bizApp.getString("id");
            }
            map.put("op_desc", kd.bos.permission.log.helper.ConstantsHelper.getOprAffectUserDesc((String)bizAppId, (PermLogBusiType)permLogBusiType));
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("OperationRuleEditPlugin.oprEvent2PermLog error, opItemId:{}, opItemName:{}", new Object[]{opItemId, opItemName, e});
        }
    }

    private void showApplyOrg() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("paramIsEnable");
        if (customParam == null || !((Boolean)customParam).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u5f53\u524d\u53c2\u6570\u3002", (String)"OperationRuleEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        String operationRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("paramOpRuleObjId");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("perm_opruleobjorg_edit");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "perm_opruleobjorg_edit"));
        fsp.setCustomParam("CustParam_OperationRuleObjId", (Object)operationRuleObjId);
        this.getView().showForm(fsp);
    }

    private void ifDel() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("del", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"OperationRuleEditPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && e.getCallBackId().equals("del")) {
            this.delete();
        }
    }

    private boolean delete() {
        if (!this.validateForDel()) {
            return false;
        }
        String opRuleId = (String)this.getModel().getValue("operationrule_id");
        String langStr = RequestContext.get().getLang().name();
        String preData = "";
        PermLogBusiType oprDelBusiType = null;
        boolean enablePermLog = PermCommonUtil.isEnablePermLog();
        if (enablePermLog) {
            oprDelBusiType = PermLogService.getPermLogBusiType((String)"opr_del");
        }
        if (enablePermLog) {
            preData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)false, (PermLogBusiType)oprDelBusiType, null, null, null);
        }
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"perm_operationruleobj", (QFilter[])new QFilter[]{new QFilter(RULE_ID, "=", (Object)opRuleId)});
                DeleteServiceHelper.delete((String)"perm_operationrule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)opRuleId)});
                CacheMrg.clearCache((String)CacheMrg.getType4OperationRule());
                CacheMrg.clearCache((String)CacheMrg.getType4OperationRuleObj());
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        this.getView().close();
        if (enablePermLog) {
            String opRuleName = ((ILocaleString)this.getModel().getValue("name")).getLocaleValue();
            String afterData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)true, (PermLogBusiType)oprDelBusiType, null, null, (String)preData);
            String opbtn = ConstantsHelper.getDel();
            this.oprEvent2PermLog("btn_delete", opbtn, opRuleId, opRuleName, preData, afterData, oprDelBusiType);
        }
        return true;
    }

    private boolean save() {
        if (!this.validateForSave()) {
            return false;
        }
        String opRuleId = (String)this.getModel().getValue("operationrule_id");
        ILocaleString opRuleName = (ILocaleString)this.getModel().getValue("name");
        String opType = (String)this.getModel().getValue("operation_type");
        String operationKey = (String)this.getModel().getValue(PROP_OPERATION_KEY);
        Boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        DynamicObject entityType = (DynamicObject)this.getModel().getValue("bizobject");
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
        String isPublic = this.getIsPublic() ? "1" : "0";
        String entityTypeNumber = null;
        String bizAppId = null;
        if (entityType != null) {
            entityTypeNumber = entityType.getString("number");
            bizAppId = bizApp.getString("id");
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("rule");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        String filterConditionJson = SerializationUtils.toJsonString((Object)filterCondition);
        DynamicObject dynamicObject = null;
        if (StringUtils.isNotEmpty((String)entityTypeNumber)) {
            PermCommonUtil.validateFilterCondition((String)entityTypeNumber, (FilterCondition)filterCondition);
        } else {
            PermCommonUtil.validateFilterCondition((String)"bos_billorgtpl", (FilterCondition)filterCondition);
        }
        if (StringUtils.isEmpty((String)opRuleId)) {
            String ruleId = this.getOperationRuleId();
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"perm_operationrule");
            if (ruleId != null && ruleId.length() != 0) {
                dynamicObject.set("id", (Object)ruleId);
            }
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)opRuleId, (String)"perm_operationrule");
        }
        dynamicObject.set("name", (Object)opRuleName);
        dynamicObject.set("operation_type", (Object)opType);
        dynamicObject.set(PROP_OPERATION_KEY, (Object)operationKey);
        dynamicObject.set("rule", (Object)filterConditionJson);
        dynamicObject.set("enabled", (Object)Boolean.TRUE);
        dynamicObject.set("entitytype", (Object)entityTypeNumber);
        dynamicObject.set("bizapp", (Object)bizAppId);
        dynamicObject.set("ispublic", (Object)isPublic);
        dynamicObject.set("ispreset", (Object)isPreset);
        SaveServiceHelper.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new Object[]{dynamicObject});
        opRuleId = dynamicObject.getString("id");
        this.getModel().setValue("operationrule_id", (Object)opRuleId);
        CacheMrg.clearCache((String)CacheMrg.getType4OperationRule());
        CacheMrg.clearCache((String)CacheMrg.getType4OperationRuleObj());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OperationRuleEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
        String curLogAppId = AppHelper.getCurAppId((String)"perm_operationrule", (String)this.getView().getFormShowParameter().getAppId());
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "OperationRuleEditPlugin_12", SYSTEM_TYPE);
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u7279\u6b8a\u6570\u636e\u6743\u9650\u89c4\u5219\uff1a%1$s\uff0c\u4fdd\u5b58\u6210\u529f", "OperationRuleEditPlugin_13", SYSTEM_TYPE);
        String name = opRuleName.getLocaleValue();
        String[] opDescParam = new String[]{name};
        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u6570\u636e\u6743\u9650\u89c4\u5219\uff1a%1$s\uff0c\u4fdd\u5b58\u6210\u529f", (String)"OperationRuleEditPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), name);
        String opNameZh_CN = new MultiLangEnumBridge("\u4fdd\u5b58", "OperationRuleEditPlugin_12", SYSTEM_TYPE).getDescription();
        PermCommonUtil.addLog((String)"", (String)opNameZh_CN, (String)"perm_operationrule", (String)opRuleId, (String)"1", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
        boolean hasDeletePerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)PERM_OPERATIONRULEASSIGN_ENTITY, (String)"4715e1f1000000ac");
        if (hasDeletePerm) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_delete"});
        }
        return true;
    }

    private void addNew() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String ruleId = ORM.create().genStringId("perm_operationrule");
        String newPageId = ruleId + "-op-" + this.getView().getParentView().getPageId();
        param.getOpenStyle().setShowType(ShowType.InCurrentForm);
        param.setCustomParam("paramOperationRuleId", (Object)ruleId);
        param.setPageId(newPageId);
        param.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(param);
    }

    public void afterCreateNewData(EventObject e) {
        this.setFilterColumn();
        this.initializeData();
    }

    private void setFilterColumn() {
        String bizObjectId = this.getBizObject();
        if (StringUtils.isEmpty((String)bizObjectId)) {
            bizObjectId = PermFormCommonUtil.getOperationRuleEntity();
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl("rule");
        if (bizObjectId != null && bizObjectId.contains("#")) {
            bizObjectId = this.getEntityNumFromNodeId(bizObjectId);
        }
        bizObjectId = FormMetadataCache.getFormConfig((String)bizObjectId).getEntityTypeId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)bizObjectId);
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
        getFilterFieldsParameter.setNeedMulBasedataField(true);
        List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
        filterGrid.setEntityNumber(entityType.getName());
        PermCommonUtil.removeExtraColumn((List)filterColumns, (MainEntityType)entityType);
        filterGrid.setFilterColumns(filterColumns);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initializeFilterCondition();
        this.validatePerm();
    }

    private void validatePerm() {
        boolean isEdit = OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
        boolean hasNewPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)PERM_OPERATIONRULEASSIGN_ENTITY, (String)"47156aff000000ac");
        boolean hasModifyPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)PERM_OPERATIONRULEASSIGN_ENTITY, (String)"4715a0df000000ac");
        boolean hasDeletePerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)PERM_OPERATIONRULEASSIGN_ENTITY, (String)"4715e1f1000000ac");
        if (isEdit && !hasModifyPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_saveandnew"});
        }
        if (!isEdit && !hasNewPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_saveandnew"});
        }
        if (!hasDeletePerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_delete"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (!"perm_choiceoperationpage".equals(actionId)) {
            return;
        }
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String result = (String)returnData.get("returnDataResult");
        if ("returnDataCancel".equals(result)) {
            return;
        }
        Map operationInfo = (Map)returnData.get("returnDataSelectedOperationInfo");
        String operationKey = (String)operationInfo.get("infoOperationKey");
        String operationType = (String)operationInfo.get("infoOperationType");
        String operationName = (String)operationInfo.get("infoOperationName");
        IDataModel iDataModel = this.getModel();
        iDataModel.setValue("operation", (Object)operationName);
        iDataModel.setValue("operation_type", (Object)operationType);
        iDataModel.setValue(PROP_OPERATION_KEY, (Object)operationKey);
    }

    private void showChoiceOperationPage() {
        boolean isPublic = this.getIsPublic();
        String nodeType = this.getNodeType();
        if (isPublic && !AllFuncPermTreeUtil.NODESUFFIX_FIRST.equals(nodeType)) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", "perm_choiceoperationpage");
        FormShowParameter fsp = FormShowParameter.createFormShowParameter(param);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "perm_choiceoperationpage"));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("paramBizObjectId", (Object)this.getBizObject());
        this.getView().showForm(fsp);
    }

    private boolean validateForDel() {
        String opRuleId = (String)this.getModel().getValue("operationrule_id");
        boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        if (StringUtils.isEmpty((String)opRuleId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u65b0\u5efa\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"OperationRuleEditPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (isPreset) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"OperationRuleEditPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        boolean isPublic = (Boolean)this.getModel().getValue("ispublic");
        if (isPublic) {
            StringBuilder sql = new StringBuilder().append("select  fentitytypeid from t_perm_operationruleobj where fobjenabled = '1' and foperationruleid = '").append(opRuleId).append('\'');
            List entities = (List)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws Exception {
                    ArrayList<String> result = new ArrayList<String>(8);
                    while (rs.next()) {
                        String fentitytypeid = rs.getString(OperationRuleEditPlugin.PROP_ENTITYTYPEID);
                        result.add(fentitytypeid);
                    }
                    return result;
                }
            });
            List<String> existEntities = this.getExistEntities(entities);
            if (null == existEntities || existEntities.isEmpty()) {
                return true;
            }
            int count = existEntities.size();
            if (count > 3) {
                List<String> idArray = existEntities.subList(0, 3);
                String entityTypeAndName = this.getEntityTypeAndName(idArray);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u6570\u636e\u88ab\u201c%1$s\u201d\u7b49%2$s\u4e2a\u8868\u5355\u5f15\u7528\u3002", (String)"OperationRuleEditPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[]{entityTypeAndName, count}));
                return false;
            }
            String entityTypeAndName = this.getEntityTypeAndName(existEntities);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u6570\u636e\u88ab\u8868\u5355\u201c%s\u201d\u5f15\u7528\u3002", (String)"OperationRuleEditPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[]{entityTypeAndName}));
            return false;
        }
        boolean enabled = false;
        QFilter qFilter = new QFilter(RULE_ID, "=", (Object)opRuleId);
        DynamicObject operationRuleData = BusinessDataServiceHelper.loadSingle((String)"perm_operationruleobj", (String)ENABLE, (QFilter[])new QFilter[]{qFilter});
        if (operationRuleData != null) {
            enabled = (Boolean)operationRuleData.get(ENABLE);
        }
        if (enabled) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c\u542f\u7528\u201d\u72b6\u6001\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"OperationRuleEditPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String getEntityTypeAndName(List<String> entityTypeIds) {
        if (CollectionUtils.isEmpty(entityTypeIds)) {
            return "";
        }
        StringBuilder entityInfo = new StringBuilder();
        int size = entityTypeIds.size();
        boolean isFirstTime = true;
        for (int j = 0; j < size; ++j) {
            String entityTypeId = entityTypeIds.get(j);
            String localEntityName = "";
            try {
                localEntityName = EntityMetadataCache.getDataEntityType((String)entityTypeId).getDisplayName().getLocaleValue();
            }
            catch (Exception e) {
                logger.warn(e.getLocalizedMessage(), (Throwable)e);
                continue;
            }
            if (!isFirstTime) {
                entityInfo.append('\uff0c');
            } else {
                isFirstTime = false;
            }
            entityInfo.append(localEntityName).append('\uff08').append(entityTypeId).append('\uff09');
        }
        return entityInfo.toString();
    }

    private List<String> getExistEntities(List<String> entityNums) {
        if (CollectionUtils.isEmpty(entityNums)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fnumber from t_meta_entitydesign where fnumber in ").append(this.arrayToSql(entityNums));
        List existEntities = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> result = new ArrayList<String>(8);
                while (rs.next()) {
                    String entityNum = rs.getString("fnumber");
                    result.add(entityNum);
                }
                return result;
            }
        });
        if (entityNums.size() > existEntities.size()) {
            if (!CollectionUtils.isEmpty((Collection)existEntities)) {
                entityNums.removeAll(existEntities);
            }
            if (!entityNums.isEmpty()) {
                StringBuilder operationDelSql = new StringBuilder();
                operationDelSql.append("DELETE FROM t_perm_operationruleobj WHERE fentitytypeid in ").append(this.arrayToSql(entityNums));
                DB.execute((DBRoute)DBRoute.permission, (String)operationDelSql.toString());
            }
            return existEntities;
        }
        return existEntities;
    }

    private String arrayToSql(List<String> array) {
        if (CollectionUtils.isEmpty(array)) {
            return null;
        }
        StringBuilder sqlArray = new StringBuilder();
        boolean isFiest = true;
        for (String entityNum : array) {
            if (isFiest) {
                sqlArray.append("( ").append('\'').append(entityNum).append('\'');
                isFiest = false;
                continue;
            }
            sqlArray.append(',').append('\'').append(entityNum).append('\'');
        }
        sqlArray.append(" )");
        return sqlArray.toString();
    }

    private boolean validateForSave() {
        String operationRuleId = (String)this.getModel().getValue("operationrule_id");
        boolean ifNewOpRule = StringUtils.isEmpty((String)operationRuleId);
        ILocaleString operationRuleName = (ILocaleString)this.getModel().getValue("name");
        String operationRuleOperationType = (String)this.getModel().getValue("operation_type");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("rule");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        List simpleFilterRows = filterCondition == null ? null : filterCondition.getFilterRow();
        String errorMsg = null;
        if (operationRuleName == null || operationRuleName.isEmpty()) {
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u540d\u79f0\u201d\u3002", (String)"OperationRuleEditPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (StringUtils.isEmpty((String)operationRuleOperationType)) {
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u201c\u64cd\u4f5c\u201d\u3002", (String)"OperationRuleEditPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (simpleFilterRows == null || simpleFilterRows.isEmpty()) {
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"OperationRuleEditPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else {
            Set existsNames;
            int size = operationRuleName.values().size();
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT fname FROM t_perm_operationrule_l WHERE fname IN (");
            Object[] param = ifNewOpRule ? new Object[size] : new Object[size + 1];
            int i = 0;
            for (String name : operationRuleName.values()) {
                sql.append('?');
                if (i != size - 1) {
                    sql.append(',');
                }
                param[i] = name;
                ++i;
            }
            sql.append(") ");
            if (!ifNewOpRule) {
                sql.append(" and fid != ? ");
                param[size] = operationRuleId;
            }
            if (!CollectionUtils.isEmpty((Collection)(existsNames = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])param, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

                public Set<String> handle(ResultSet rs) throws Exception {
                    HashSet<String> resultList = new HashSet<String>(16);
                    while (rs.next()) {
                        String name = rs.getString(1);
                        resultList.add(name);
                    }
                    return resultList;
                }
            })))) {
                errorMsg = ResManager.loadKDString((String)"\u540d\u79f0\u201c%s\u201d\u5df2\u5b58\u5728\u3002", (String)"OperationRuleEditPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[]{existsNames.toString().replaceAll("\\[", "").replaceAll("\\]", "")});
            }
        }
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        OperationStatus status;
        String operationRuleId = this.getOperationRuleId();
        if (operationRuleId != null && OperationStatus.EDIT.equals((Object)(status = this.getView().getFormShowParameter().getStatus()))) {
            MutexHelper.release((String)"perm_operationrule", (String)"modify", (String)operationRuleId);
        }
    }
}

