/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.oprule.AbstractOperationRuleFromPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.OprLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class OperationRuleExcRoleEditPlugin
extends AbstractOperationRuleFromPlugin {
    private Log logger = LogFactory.getLog(OperationRuleExcRoleEditPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (isSuperUser) {
            return;
        }
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (isAdminUser) {
            return;
        }
        String formId = e.getFormShowParameter().getParentFormId();
        if (formId == null || !formId.equals("perm_operationruleassign") && !formId.equals("ide_formdesigner")) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u8bbf\u95ee\u5f53\u524d\u9875\u9762\u3002", (String)"OperationRuleExcRoleEditPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && (key = (btn = (Button)source).getKey()).equals("btnok")) {
            String langStr = RequestContext.get().getLang().name();
            String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
            Map oprObjMap = OprLogHelper.getOpr((String)opRuleObjId, (String)langStr);
            if (CollectionUtils.isEmpty((Map)oprObjMap)) {
                return;
            }
            String opRuleId = (String)oprObjMap.get("foperationruleid");
            String appId = (String)oprObjMap.get("fbizappid");
            String entityNum = (String)oprObjMap.get("fentitytypeid");
            String opRuleName = (String)oprObjMap.get("oprrulename");
            PermLogBusiType permLogBusiType = null;
            String preData = "";
            boolean enablePermLog = PermCommonUtil.isEnablePermLog();
            if (enablePermLog) {
                permLogBusiType = PermLogService.getPermLogBusiType((String)"opr_exrole");
            }
            if (enablePermLog) {
                preData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)false, (PermLogBusiType)permLogBusiType, (String)appId, (String)entityNum, null);
            }
            this.saveExcRoleInfo();
            if (enablePermLog) {
                String afterData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)true, (PermLogBusiType)permLogBusiType, (String)appId, (String)entityNum, (String)preData);
                String opbtn = ConstantsHelper.getSave();
                this.oprEvent2PermLog("btnok", opbtn, appId, opRuleId, opRuleName, preData, afterData, permLogBusiType);
            }
            this.getView().close();
        }
    }

    private void oprEvent2PermLog(String op, String opbtn, String selectAppId, String opItemId, String opItemName, String preData, String afterData, PermLogBusiType permLogBusiType) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.OperationRuleExcRoleEditPlugin.oprEvent2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            map.put("op_desc", kd.bos.permission.log.helper.ConstantsHelper.getOprAffectUserDesc((String)selectAppId, (PermLogBusiType)permLogBusiType));
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            this.logger.warn("OperationRuleExcRoleEditPlugin.oprEvent2PermLog error, opItemId:{}, opItemName:{}", new Object[]{opItemId, opItemName, e});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("btnnew")) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_role", (boolean)true);
            Set<String> rowIdSet = PermFormCommonUtil.getAllListIdSet(this.getModel(), "entryentity", "role");
            lsp.setSelectedRows(rowIdSet.toArray());
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnnew"));
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    private void saveExcRoleInfo() {
        try {
            String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)"perm_exceptrole");
            try (TXHandle h = TX.required();){
                try {
                    DeleteServiceHelper.delete((String)"perm_exceptrole", (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)opRuleObjId)});
                }
                catch (Exception e) {
                    this.logger.warn("\u5220\u9664\u4f8b\u5916\u89d2\u8272\u5931\u8d25 e = ", (Throwable)e);
                    h.markRollback();
                }
            }
            DynamicObjectCollection newDoc = this.getModel().getEntryEntity("entryentity");
            if (!CollectionUtils.isEmpty((Collection)newDoc)) {
                ArrayList<DynamicObject> listForInsertObj = new ArrayList<DynamicObject>(newDoc.size());
                for (int i = 0; i < newDoc.size(); ++i) {
                    DynamicObject forSaveObj = new DynamicObject((DynamicObjectType)met, null);
                    forSaveObj.set("operationruleobj", (Object)opRuleObjId);
                    forSaveObj.set("role", ((DynamicObject)newDoc.get(i)).getDynamicObject("role").getPkValue());
                    listForInsertObj.add(forSaveObj);
                }
                try (TXHandle h = TX.required();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])listForInsertObj.toArray(new DynamicObject[0]));
                        this.updateId2Model(listForInsertObj);
                        CacheMrg.clearCache((String)CacheMrg.getType4OperationRuleObj());
                        CacheMrg.clearCache((String)CacheMrg.getType4OperationRule());
                    }
                    catch (Exception e) {
                        this.logger.warn("\u4fdd\u5b58\u4f8b\u5916\u89d2\u8272\u5931\u8d25 e = ", (Throwable)e);
                        h.markRollback();
                    }
                }
            }
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4f8b\u5916\u901a\u7528\u89d2\u8272\u8bbe\u7f6e\u6210\u529f\u3002", (String)"OperationRuleExcRoleEditPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.getView().sendFormAction(this.getView().getParentView());
        }
        catch (Exception e) {
            this.logger.warn("\u7279\u6b8a\u6570\u636e\u6743\u9650-\u4f8b\u5916\u89d2\u8272 \u4fdd\u5b58\u51fa\u9519\uff1a", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u51fa\u9519\uff1a", (String)"OperationRuleExcRoleEditPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]) + e.getMessage());
        }
    }

    private void updateId2Model(ArrayList<DynamicObject> listForInsertObj) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        block0: for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            for (DynamicObject savedObj : listForInsertObj) {
                String rowExcUserId;
                String savedId = savedObj.getString("id");
                String savedExcUserId = savedObj.getString("role");
                boolean equal = savedExcUserId.equals(rowExcUserId = row.getDynamicObject("role").getString("id"));
                if (!equal) continue;
                this.getModel().setValue("infoid", (Object)savedId, i);
                continue block0;
            }
        }
    }

    private void updateIdToModel(ArrayList<DynamicObject> listSavedObj) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        block0: for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            String rowId = row.getString("infoid");
            if (StringUtils.isNotEmpty((String)rowId) && !"0".equals(rowId)) continue;
            for (DynamicObject savedObj : listSavedObj) {
                String rowExcUserId;
                String savedId = savedObj.getString("id");
                String savedExcUserId = savedObj.getString("role");
                boolean equal = savedExcUserId.equals(rowExcUserId = row.getDynamicObject("role").getString("id"));
                if (!equal) continue;
                this.getModel().setValue("infoid", (Object)savedId, i);
                continue block0;
            }
        }
        this.getView().updateView("entryentity");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("btnnew".equals(actionId) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            ArrayList<String> allNewRoleIds = new ArrayList<String>();
            for (ListSelectedRow lsr : lsrc) {
                String pkStr = (String)lsr.getPrimaryKeyValue();
                allNewRoleIds.add(pkStr);
            }
            this.fillList(allNewRoleIds);
        }
    }

    private void fillList(List<String> allNewRoleIds) {
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"role"});
        for (String newRoleId : allNewRoleIds) {
            vs.addRow(new Object[]{newRoleId});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadExcRoleInfo();
    }

    private void loadExcRoleInfo() {
        String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"perm_exceptrole", null, (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)opRuleObjId)}, null);
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"infoid", "role"});
        for (DynamicObject dObj : doc) {
            vs.addRow(new Object[]{dObj.get("id"), dObj.getString("role.id")});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }
}

