/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.oprule.AbstractOperationRuleFromPlugin;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.OprLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class OperationRuleExcUserEditPlugin
extends AbstractOperationRuleFromPlugin {
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private Log logger = LogFactory.getLog(OperationRuleExcUserEditPlugin.class);
    private static final String CHANGE_USER = "CHANGE_USER";
    private static final String CHANGE_USERGROUP = "CHANGE_USERGROUP";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit userEdit = (MulBasedataEdit)this.getControl("userref");
        if (userEdit != null) {
            userEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    evt.getFormShowParameter().setCustomParam("externalUserType", (Object)"all");
                    evt.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                }
            });
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnnew", "btndel", "btnok", "btncancel", "btnnew_usrgrp", "btndel_usrgrp"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap_usrgrp"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (isSuperUser) {
            return;
        }
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (isAdminUser) {
            return;
        }
        String formId = e.getFormShowParameter().getParentFormId();
        if (formId == null || !formId.equals("perm_operationruleassign") && !formId.equals("ide_formdesigner")) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u8bbf\u95ee\u5f53\u524d\u9875\u9762\u3002", (String)"OperationRuleExcUserEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && (key = (btn = (Button)source).getKey()).equals("btnok")) {
            try {
                String changeUserGroup;
                String langStr = RequestContext.get().getLang().name();
                String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
                Map oprObjMap = OprLogHelper.getOpr((String)opRuleObjId, (String)langStr);
                if (CollectionUtils.isEmpty((Map)oprObjMap)) {
                    return;
                }
                String opRuleId = (String)oprObjMap.get("foperationruleid");
                String appId = (String)oprObjMap.get("fbizappid");
                String entityNum = (String)oprObjMap.get("fentitytypeid");
                String opRuleName = (String)oprObjMap.get("oprrulename");
                String changeUser = this.getPageCache().get(CHANGE_USER);
                boolean enablePermLog = PermCommonUtil.isEnablePermLog();
                if (StringUtils.isNotEmpty((String)changeUser) && changeUser.equals("1")) {
                    PermLogBusiType exusrPermLogBusiType = null;
                    String exusrPreData = "";
                    if (enablePermLog) {
                        exusrPermLogBusiType = PermLogService.getPermLogBusiType((String)"opr_exusr");
                        exusrPreData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)false, (PermLogBusiType)exusrPermLogBusiType, (String)appId, (String)entityNum, null);
                    }
                    this.saveExcUserInfo();
                    if (enablePermLog) {
                        String exusrAfterData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)true, (PermLogBusiType)exusrPermLogBusiType, (String)appId, (String)entityNum, (String)exusrPreData);
                        String opbtn = ConstantsHelper.getSave();
                        this.oprEvent2PermLog("btnok", opbtn, appId, opRuleId, opRuleName, exusrPreData, exusrAfterData, exusrPermLogBusiType);
                    }
                }
                if (StringUtils.isNotEmpty((String)(changeUserGroup = this.getPageCache().get(CHANGE_USERGROUP))) && changeUserGroup.equals("1")) {
                    PermLogBusiType exusrgrpPermLogBusiType = null;
                    String exusrgrpPreData = "";
                    if (enablePermLog) {
                        exusrgrpPermLogBusiType = PermLogService.getPermLogBusiType((String)"opr_exusrgrp");
                        exusrgrpPreData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)false, (PermLogBusiType)exusrgrpPermLogBusiType, (String)appId, (String)entityNum, null);
                    }
                    this.saveExcUserGroupInfo();
                    if (enablePermLog) {
                        String exusrgrpAfterData = OprLogHelper.oprEventImage((String)opRuleId, (String)langStr, (boolean)true, (PermLogBusiType)exusrgrpPermLogBusiType, (String)appId, (String)entityNum, (String)exusrgrpPreData);
                        String opbtn = ConstantsHelper.getSave();
                        this.oprEvent2PermLog("btnok", opbtn, appId, opRuleId, opRuleName, exusrgrpPreData, exusrgrpAfterData, exusrgrpPermLogBusiType);
                    }
                }
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4f8b\u5916\u7528\u6237\u8bbe\u7f6e\u6210\u529f\u3002", (String)"OperationRuleExcUserEditPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
            catch (Exception e) {
                this.logger.warn("\u4fdd\u5b58\u4f8b\u5916\u7528\u6237\u548c\u7528\u6237\u7ec4\u65f6\u51fa\u73b0\u5f02\u5e38");
            }
        }
    }

    private void oprEvent2PermLog(String op, String opbtn, String selectAppId, String opItemId, String opItemName, String preData, String afterData, PermLogBusiType permLogBusiType) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.OperationRuleExcUserEditPlugin.oprEvent2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            map.put("op_desc", kd.bos.permission.log.helper.ConstantsHelper.getOprAffectUserDesc((String)selectAppId, (PermLogBusiType)permLogBusiType));
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            this.logger.warn("OperationRuleExcUserEditPlugin.oprEvent2PermLog error, opItemId:{}, opItemName:{}", new Object[]{opItemId, opItemName, e});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        IClientViewProxy proxy;
        int[] rowIndexs;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("btnnew")) {
            MulBasedataEdit userRef = (MulBasedataEdit)this.getView().getControl("userref");
            Set<String> rowIdSet = PermFormCommonUtil.getAllListIdSet(this.getModel(), "entryentity", "name");
            this.getModel().setValue("userref", (Object)rowIdSet.stream().map(Long::valueOf).distinct().toArray());
            userRef.click();
        } else if (itemKey.equals("btnnew_usrgrp")) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_usrgrp", (boolean)true);
            lsp.getListFilterParameter().getQFilters().add(new QFilter("usergrouptypeid", "=", (Object)PermHelperConst.NORMAL_USERGROUPTYPE_ID));
            Set<String> rowIdSet = PermFormCommonUtil.getAllListIdSet(this.getModel(), "entryentity_usrgrp", "usergroup");
            lsp.setSelectedRows(rowIdSet.toArray());
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnnew_usrgrp"));
            this.getView().showForm((FormShowParameter)lsp);
        } else if (itemKey.equals("btndel")) {
            IClientViewProxy proxy2 = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            int[] rowIndexs2 = proxy2.getEntryState("entryentity").getSelectedRows();
            if (rowIndexs2.length > 0) {
                this.getModel().beginInit();
                this.getModel().deleteEntryRows("entryentity", rowIndexs2);
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                this.getPageCache().put(CHANGE_USER, "1");
            }
        } else if (itemKey.equals("btndel_usrgrp") && (rowIndexs = (proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity_usrgrp").getSelectedRows()).length > 0) {
            this.getModel().deleteEntryRows("entryentity_usrgrp", rowIndexs);
            this.getPageCache().put(CHANGE_USERGROUP, "1");
        }
    }

    private void saveExcUserGroupInfo() {
        try {
            StringBuilder sb = new StringBuilder("id").append(", ").append("operationruleobj").append(", ").append("usergroup");
            String selectedFields = sb.toString();
            String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
            DynamicObject[] oldDoc = BusinessDataServiceHelper.load((String)"perm_exceptusrgrp", (String)selectedFields, (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)opRuleObjId)});
            DynamicObjectCollection newDoc = this.getModel().getEntryEntity("entryentity_usrgrp");
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)"perm_exceptusrgrp");
            ArrayList<String> forDeleteIds = new ArrayList<String>();
            for (DynamicObject oldDObj : oldDoc) {
                String oldId = oldDObj.getString("id");
                boolean found = false;
                for (DynamicObject newDObj : newDoc) {
                    String newId = newDObj.getString("infoid_usrgrp");
                    if (StringUtils.isEmpty((String)newId) || !oldId.equals(newId)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                forDeleteIds.add(oldId);
            }
            if (!CollectionUtils.isEmpty(forDeleteIds)) {
                try (TXHandle h = TX.required();){
                    try {
                        DeleteServiceHelper.delete((IDataEntityType)met, (Object[])forDeleteIds.toArray());
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            }
            ArrayList<DynamicObject> listForInsertObj = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> listForUpdateObj = new ArrayList<DynamicObject>();
            for (int i = 0; i < newDoc.size(); ++i) {
                DynamicObject newDObj = (DynamicObject)newDoc.get(i);
                String newId = newDObj.getString("infoid_usrgrp");
                DynamicObject forSaveObj = null;
                if (oldDoc.length == 0) {
                    forSaveObj = new DynamicObject((DynamicObjectType)met, null);
                } else {
                    for (DynamicObject oldDObj : oldDoc) {
                        String oldId = oldDObj.getString("id");
                        if (StringUtils.isEmpty((String)newId)) {
                            forSaveObj = new DynamicObject((DynamicObjectType)met, null);
                            break;
                        }
                        if (!newId.equals(oldId)) {
                            forSaveObj = null;
                            continue;
                        }
                        if (!newId.equals(oldId)) continue;
                        forSaveObj = oldDObj;
                        break;
                    }
                }
                if (forSaveObj == null) continue;
                forSaveObj.set("operationruleobj", (Object)opRuleObjId);
                forSaveObj.set("usergroup", newDObj.getDynamicObject("usergroup").getPkValue());
                String curId = forSaveObj.getString("id");
                if (StringUtils.isEmpty((String)curId) || "0".equals(curId)) {
                    listForInsertObj.add(forSaveObj);
                    continue;
                }
                listForUpdateObj.add(forSaveObj);
            }
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])listForInsertObj.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])listForUpdateObj.toArray(new DynamicObject[0]));
                    this.updateIdToUserGroupModel(listForInsertObj);
                    CacheMrg.clearCache((String)CacheMrg.getType4OperationRuleObj());
                    CacheMrg.clearCache((String)CacheMrg.getType4OperationRule());
                }
                catch (Exception e) {
                    this.logger.warn("\u4f8b\u5916\u7528\u6237\u7ec4 \u4fdd\u5b58\u51fa\u9519\uff1a", (Throwable)e);
                    h.markRollback();
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("\u7279\u6b8a\u6570\u636e\u6743\u9650-\u4f8b\u5916\u7528\u6237\u7ec4 \u4fdd\u5b58\u51fa\u9519\uff1a", (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u51fa\u9519\uff1a", (String)"OperationRuleExcUserEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage());
        }
    }

    private void saveExcUserInfo() {
        try {
            StringBuilder sb = new StringBuilder("id").append(", ").append("operationruleobj").append(", ").append("user");
            String selectedFields = sb.toString();
            String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
            DynamicObject[] oldDoc = BusinessDataServiceHelper.load((String)"perm_exceptuser", (String)selectedFields, (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)opRuleObjId)});
            DynamicObjectCollection newDoc = this.getModel().getEntryEntity("entryentity");
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)"perm_exceptuser");
            ArrayList<String> forDeleteIds = new ArrayList<String>();
            for (DynamicObject oldDObj : oldDoc) {
                String oldId = oldDObj.getString("id");
                boolean found = false;
                for (DynamicObject newDObj : newDoc) {
                    String newId = newDObj.getString("infoid");
                    if (StringUtils.isEmpty((String)newId) || !oldId.equals(newId)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                forDeleteIds.add(oldId);
            }
            if (forDeleteIds != null && forDeleteIds.size() != 0) {
                try (TXHandle h = TX.required();){
                    try {
                        DeleteServiceHelper.delete((IDataEntityType)met, (Object[])forDeleteIds.toArray());
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            }
            ArrayList<DynamicObject> listForInsertObj = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> listForUpdateObj = new ArrayList<DynamicObject>();
            for (int i = 0; i < newDoc.size(); ++i) {
                DynamicObject newDObj = (DynamicObject)newDoc.get(i);
                String newId = newDObj.getString("infoid");
                DynamicObject forSaveObj = null;
                if (oldDoc.length == 0) {
                    forSaveObj = new DynamicObject((DynamicObjectType)met, null);
                } else {
                    for (DynamicObject oldDObj : oldDoc) {
                        String oldId = oldDObj.getString("id");
                        if (StringUtils.isEmpty((String)newId)) {
                            forSaveObj = new DynamicObject((DynamicObjectType)met, null);
                            break;
                        }
                        if (!newId.equals(oldId)) {
                            forSaveObj = null;
                            continue;
                        }
                        if (!newId.equals(oldId)) continue;
                        forSaveObj = oldDObj;
                        break;
                    }
                }
                if (forSaveObj == null) continue;
                forSaveObj.set("operationruleobj", (Object)opRuleObjId);
                forSaveObj.set("user", newDObj.get("name"));
                String curId = forSaveObj.getString("id");
                if (StringUtils.isEmpty((String)curId)) {
                    listForInsertObj.add(forSaveObj);
                    continue;
                }
                listForUpdateObj.add(forSaveObj);
            }
            try (TXHandle h = TX.required();){
                try {
                    SaveServiceHelper.save((DynamicObject[])listForInsertObj.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])listForUpdateObj.toArray(new DynamicObject[0]));
                    this.updateIdToModel(listForInsertObj);
                    CacheMrg.clearCache((String)CacheMrg.getType4OperationRuleObj());
                    CacheMrg.clearCache((String)CacheMrg.getType4OperationRule());
                }
                catch (Exception e) {
                    this.logger.warn("\u4f8b\u5916\u7528\u6237 \u4fdd\u5b58\u51fa\u9519\uff1a" + e.getMessage());
                    h.markRollback();
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("\u7279\u6b8a\u6570\u636e\u6743\u9650-\u4f8b\u5916\u7528\u6237 \u4fdd\u5b58\u51fa\u9519\uff1a" + e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u51fa\u9519\uff1a", (String)"OperationRuleExcUserEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage());
        }
    }

    private void updateIdToModel(ArrayList<DynamicObject> listSavedObj) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        block0: for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            String rowId = row.getString("infoid");
            if (StringUtils.isNotEmpty((String)rowId) && !"0".equals(rowId)) continue;
            for (DynamicObject savedObj : listSavedObj) {
                Long rowExcUserId;
                String savedId = savedObj.getString("id");
                Long savedDirectorId = savedObj.getDynamicObject("user").getLong("id");
                boolean equal = savedDirectorId.equals(rowExcUserId = Long.valueOf(row.getDynamicObject("name").getLong("id")));
                if (!equal) continue;
                this.getModel().setValue("infoid", (Object)savedId, i);
                continue block0;
            }
        }
        this.getView().updateView("entryentity");
    }

    private void updateIdToUserGroupModel(ArrayList<DynamicObject> listSavedObj) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity_usrgrp");
        block0: for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            String rowId = row.getString("infoid_usrgrp");
            if (StringUtils.isNotEmpty((String)rowId) && !"0".equals(rowId)) continue;
            for (DynamicObject savedObj : listSavedObj) {
                Long rowExcUserGroupId;
                String savedId = savedObj.getString("id");
                Long savedUserGroupId = savedObj.getLong("usergroup");
                boolean equal = savedUserGroupId.equals(rowExcUserGroupId = Long.valueOf(row.getDynamicObject("usergroup").getLong("id")));
                if (!equal) continue;
                this.getModel().setValue("infoid_usrgrp", (Object)savedId, i);
                continue block0;
            }
        }
        this.getView().updateView("entryentity_usrgrp");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (propName.equals("userref")) {
            DynamicObjectCollection doc = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            this.fillList(doc);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("btnnew_usrgrp".equals(actionId) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)returnData;
            ArrayList<String> allNewIds = new ArrayList<String>();
            for (ListSelectedRow lsr : lsrc) {
                Long pkStr = (Long)lsr.getPrimaryKeyValue();
                allNewIds.add(String.valueOf(pkStr));
            }
            this.fillList(allNewIds);
        }
    }

    private void fillList(List<String> allNewIds) {
        if (CollectionUtils.isEmpty(allNewIds)) {
            return;
        }
        this.getModel().deleteEntryData("entryentity_usrgrp");
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"usergroup"});
        for (String newUserId : allNewIds) {
            vs.addRow(new Object[]{newUserId});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity_usrgrp", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity_usrgrp");
        this.getPageCache().put(CHANGE_USERGROUP, "1");
    }

    private void fillList(DynamicObjectCollection pNewData) {
        if (CollectionUtils.isEmpty((Collection)pNewData)) {
            return;
        }
        Set userIdSet = pNewData.stream().filter(dObj -> null != dObj.getDynamicObject("FBasedataId")).map(dObj -> dObj.getDynamicObject("FBasedataId").getLong("id")).collect(Collectors.toSet());
        Map userPositionMap = UserHelper.getUPIFullJobMapByIds(userIdSet, (String)RequestContext.get().getLang().name());
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"name", "position", "dept"});
        for (DynamicObject dObj2 : pNewData) {
            DynamicObject user = dObj2.getDynamicObject("FBasedataId");
            Long newUserId = user.getLong("id");
            User uu = (User)userPositionMap.get(newUserId);
            if (null == uu) {
                vs.addRow(new Object[]{newUserId, "", ""});
                continue;
            }
            vs.addRow(new Object[]{newUserId, uu.getPosition(), uu.getDpId()});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.getPageCache().put(CHANGE_USER, "1");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadExcUserInfo();
        this.loadExcUserGroupInfo();
    }

    private void loadExcUserInfo() {
        String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"perm_exceptuser", null, (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)opRuleObjId)}, null);
        if (CollectionUtils.isEmpty((Collection)doc)) {
            return;
        }
        Set userIdSet = doc.stream().map(x -> x.getLong("user.id")).collect(Collectors.toSet());
        Map userPositionMap = UserHelper.getUPIFullJobMapByIds(userIdSet, (String)RequestContext.get().getLang().name());
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"position", "dept", "infoid", "name"});
        for (DynamicObject dObj : doc) {
            Long userId = dObj.getLong("user.id");
            User user = (User)userPositionMap.get(userId);
            Object infoId = dObj.get("id");
            if (null != user) {
                vs.addRow(new Object[]{user.getPosition(), user.getDpId(), infoId, userId});
                continue;
            }
            vs.addRow(new Object[]{"", "", infoId, userId});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void loadExcUserGroupInfo() {
        String opRuleObjId = (String)this.getView().getFormShowParameter().getCustomParam("CustParam_OperationRuleObjId");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"perm_exceptusrgrp", (String)"id,usergroup,operationruleobj", (QFilter[])new QFilter[]{new QFilter("operationruleobj", "=", (Object)opRuleObjId)}, null);
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"infoid_usrgrp", "usergroup"});
        for (DynamicObject dObj : doc) {
            vs.addRow(new Object[]{dObj.get("id"), dObj.getLong("usergroup")});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity_usrgrp", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity_usrgrp");
    }
}

