/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.model.permbase.PermItem;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class RoleBatchAssignPermPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(RoleBatchAssignPermPlugin.class);
    private static final String OPER_KEY_DONOTHING_BATCHASSIGNPERM = "modify";
    private static final String ALLFUNCPERM_BILLLIST = "allfuncpermbilllist";
    private static final String ROLEFUNCPERM_BILLLIST = "rolefuncpermbilllist";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String BARITEM_SAVE = "bar_save";
    private static final String BTN_ADD = "btn_add";
    private static final String BTN_REMOVE = "btn_remove";
    public static final String CALLBCKID_CLOSE = "callBackId_close";
    public static final String CALLBCKID_ROLENUM = "callbckid_rolenum";
    private static final String PGCACHEKEY_ROLEAPPPEND = "roleAppend_%s";
    private static final String PGCACHEKEY_ROLEREMOVE = "roleRemove_%s";
    private static final String PGCACHEKEY_ROLECUR = "roleCur_%s";
    private static final String FORM_PERM_ROLEBATCHASSIGNOBJ = "perm_rolebatchassignobj";
    private static final String PGCACHEKEY_PLAINPERMITEMLIST = "PGCACHEKEY_PLAINPERMITEMLIST";

    private ListColumn createListColumn(String[] arr) {
        ListColumn listColumn = new ListColumn();
        String flag = arr[1];
        LocaleString caption = new LocaleString(arr[0]);
        listColumn.setCaption(caption);
        listColumn.setFieldName(flag);
        listColumn.setKey(flag);
        listColumn.setListFieldKey(flag);
        listColumn.setColumnFilter(true);
        listColumn.setBlankFieldCanOrderAndFilter(true);
        listColumn.setColumnOrder(true);
        return listColumn;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        columns.add(this.createListColumn(new String[]{ResManager.loadKDString((String)"\u4e91", (String)"RoleBatchAssignPermPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), "cloudname"}));
        columns.add(this.createListColumn(new String[]{ResManager.loadKDString((String)"\u5e94\u7528", (String)"RoleBatchAssignPermPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), "appname"}));
        columns.add(this.createListColumn(new String[]{ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"RoleBatchAssignPermPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), "entname"}));
        columns.add(this.createListColumn(new String[]{ResManager.loadKDString((String)"\u6743\u9650\u9879", (String)"RoleBatchAssignPermPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), "permitemname"}));
    }

    public void afterCreateNewData(EventObject e) {
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam("roleId");
        if (StringUtils.isNotEmpty((String)roleId)) {
            String status;
            this.getModel().setValue("role_number", (Object)roleId);
            Map roleMap = PermRoleHelper.getRoleMap(Collections.singletonList(roleId), (String)RequestContext.get().getLang().name());
            Map map = (Map)roleMap.get(roleId);
            Boolean fissystem = (Boolean)map.get("fissystem");
            IFormView view = this.getView();
            if (Boolean.TRUE.equals(fissystem)) {
                view.setEnable(Boolean.valueOf(false), new String[]{BARITEM_SAVE, BTN_ADD, BTN_REMOVE});
                view.showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u89d2\u8272\u4e0d\u53ef\u4fee\u6539\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u8ffd\u52a0\u6388\u6743\u3002", (String)"RoleBatchAssignPermPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
            }
            if (StringUtils.isNotEmpty((String)(status = (String)this.getView().getFormShowParameter().getCustomParam("status")))) {
                StringBuilder sbErrorInfo = new StringBuilder();
                MutexHelper.require((IFormView)view, (String)"perm_role", (Object)roleId, (String)OPER_KEY_DONOTHING_BATCHASSIGNPERM, (boolean)true, (StringBuilder)sbErrorInfo);
                this.getView().setStatus("edit".equalsIgnoreCase(status) ? OperationStatus.EDIT : OperationStatus.VIEW);
            }
            if (!this.adminCanModifyRoleCheck()) {
                view.setEnable(Boolean.valueOf(false), new String[]{BTN_ADD, BTN_REMOVE});
                view.setVisible(Boolean.valueOf(false), new String[]{BARITEM_SAVE});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("role_number".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (newValue == null) {
                return;
            }
            String newRoleId = (String)newValue.getPkValue();
            String pageId = this.getView().getPageId();
            String[] pageIdSplit = pageId.split("-batchAssignPerm-");
            String oldRoleId = pageIdSplit[0];
            if (oldRoleId.equals(newRoleId)) {
                return;
            }
            this.getPageCache().put("pageCache_newRoleId", newRoleId);
            if (!this.ifDataChanged(CALLBCKID_ROLENUM)) {
                this.changeRole();
            }
        }
    }

    public void initialize() {
        super.initialize();
        BillList allFuncPermBillList = (BillList)this.getControl(ALLFUNCPERM_BILLLIST);
        allFuncPermBillList.addCreateListColumnsListener(this::beforeCreateListColumns);
        allFuncPermBillList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        allFuncPermBillList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent args) {
                RoleBatchAssignPermPlugin.this.setFilterWithPgCache(args, RoleBatchAssignPermPlugin.ALLFUNCPERM_BILLLIST);
            }
        });
        BillList roleFuncPermBillList = (BillList)this.getControl(ROLEFUNCPERM_BILLLIST);
        roleFuncPermBillList.addCreateListColumnsListener(this::beforeCreateListColumns);
        roleFuncPermBillList.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        roleFuncPermBillList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent args) {
                RoleBatchAssignPermPlugin.this.setFilterWithPgCache(args, RoleBatchAssignPermPlugin.ROLEFUNCPERM_BILLLIST);
            }
        });
    }

    private void setFilterWithPgCache(SetFilterEvent args, String keyFlag) {
        String key = keyFlag + "@@" + "filter";
        List qFilters = args.getQFilters();
        if (CollectionUtils.isEmpty((Collection)qFilters)) {
            this.getPageCache().put(key, "");
        } else {
            ArrayList<String> qfilterStrs = new ArrayList<String>(qFilters.size());
            for (QFilter qfilter : qFilters) {
                List nests = qfilter.getNests(true);
                if (!CollectionUtils.isEmpty((Collection)nests)) {
                    for (QFilter.QFilterNest nest : nests) {
                        qfilterStrs.add(nest.getFilter().toSerializedString());
                    }
                    qfilter.clearNests();
                }
                String str = qfilter.toSerializedString();
                qfilterStrs.add(str);
            }
            String qfilterStr = SerializationUtils.toJsonString(qfilterStrs);
            this.getPageCache().put(key, qfilterStr);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarMain = (Toolbar)this.getControl("toolbarap");
        toolbarMain.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if (itemKey.equals(RoleBatchAssignPermPlugin.BARITEM_SAVE)) {
                    if (!RoleBatchAssignPermPlugin.this.adminCanModifyRoleCheck()) {
                        return;
                    }
                    RoleBatchAssignPermPlugin.this.save();
                }
            }
        });
        BasedataEdit roleF7 = (BasedataEdit)this.getControl("role_number");
        roleF7.addBeforeF7SelectListener(evt -> evt.getFormShowParameter().setCustomParams(this.getView().getFormShowParameter().getCustomParams()));
        Button btnAdd = (Button)this.getControl(BTN_ADD);
        final IFormView view = this.getView();
        btnAdd.addClickListener(new ClickListener(){

            public void beforeClick(BeforeClickEvent evt) {
                BillList allFuncPermBillList = (BillList)RoleBatchAssignPermPlugin.this.getControl(RoleBatchAssignPermPlugin.ALLFUNCPERM_BILLLIST);
                ListSelectedRowCollection selectedRows = allFuncPermBillList.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u81f3\u5c11\u4e00\u884c\u529f\u80fd\u6743\u9650\u8868\u7684\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RoleBatchAssignPermPlugin_5", (String)RoleBatchAssignPermPlugin.SYSTEM_TYPE, (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }

            public void click(EventObject evt) {
                BillList allFuncPermBillList = (BillList)RoleBatchAssignPermPlugin.this.getControl(RoleBatchAssignPermPlugin.ALLFUNCPERM_BILLLIST);
                ListSelectedRowCollection selectedRows = allFuncPermBillList.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    return;
                }
                List<PermItem> appendPermItemList = new ArrayList(selectedRows.size());
                for (ListSelectedRow selectedRow : selectedRows) {
                    String primaryKeyValue = (String)selectedRow.getPrimaryKeyValue();
                    String[] split = primaryKeyValue.split("\\|@@\\|", 12);
                    PermItem permItem = new PermItem();
                    permItem.setCloudId(split[0]);
                    permItem.setCloudNumber(split[1]);
                    permItem.setCloudName(split[2]);
                    permItem.setAppId(split[3]);
                    permItem.setAppNumber(split[4]);
                    permItem.setAppName(split[5]);
                    permItem.setEntityId(split[6]);
                    permItem.setEntityNumber(split[7]);
                    permItem.setEntityName(split[8]);
                    permItem.setPermItemId(split[9]);
                    permItem.setPermItemNumber(split[10]);
                    permItem.setPermItemName(split[11]);
                    appendPermItemList.add(permItem);
                }
                int wantSize = appendPermItemList.size();
                IPageCache pageCache = RoleBatchAssignPermPlugin.this.getPageCache();
                String pageId = pageCache.getPageId();
                String roleCurStr = pageCache.get(String.format(RoleBatchAssignPermPlugin.PGCACHEKEY_ROLECUR, pageId));
                if (StringUtils.isNotEmpty((String)roleCurStr)) {
                    List plainPermItemList = SerializationUtils.fromJsonStringToList((String)roleCurStr, PermItem.class);
                    appendPermItemList = ListUtil.removeAll(appendPermItemList, (List)plainPermItemList);
                }
                if (CollectionUtils.isEmpty(appendPermItemList)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672c\u6b21\u6dfb\u52a0\u7684\u529f\u80fd\u6743\u9650\u5747\u5df2\u6388\u6743\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"RoleBatchAssignPermPlugin_6", (String)RoleBatchAssignPermPlugin.SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                pageCache.put(String.format(RoleBatchAssignPermPlugin.PGCACHEKEY_ROLEAPPPEND, pageId), SerializationUtils.toJsonString(appendPermItemList));
                BillList roleFuncPermBillList = (BillList)RoleBatchAssignPermPlugin.this.getControl(RoleBatchAssignPermPlugin.ROLEFUNCPERM_BILLLIST);
                roleFuncPermBillList.refresh();
                allFuncPermBillList.clearSelection();
                int realSize = appendPermItemList.size();
                if (wantSize >= realSize) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"RoleBatchAssignPermPlugin_7", (String)RoleBatchAssignPermPlugin.SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
        });
        Button btnRemove = (Button)this.getControl(BTN_REMOVE);
        btnRemove.addClickListener(new ClickListener(){

            public void beforeClick(BeforeClickEvent evt) {
                BillList roleFuncPermBillList = (BillList)RoleBatchAssignPermPlugin.this.getControl(RoleBatchAssignPermPlugin.ROLEFUNCPERM_BILLLIST);
                ListSelectedRowCollection selectedRows = roleFuncPermBillList.getSelectedRows();
                if (selectedRows == null || selectedRows.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u81f3\u5c11\u4e00\u884c\u6279\u91cf\u6388\u6743\u8868\u7684\u6570\u636e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RoleBatchAssignPermPlugin_8", (String)RoleBatchAssignPermPlugin.SYSTEM_TYPE, (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }

            public void click(EventObject evt) {
                BillList roleFuncPermBillList = (BillList)RoleBatchAssignPermPlugin.this.getControl(RoleBatchAssignPermPlugin.ROLEFUNCPERM_BILLLIST);
                ListSelectedRowCollection selectedRows = roleFuncPermBillList.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    return;
                }
                ArrayList<PermItem> appendPermItemList = new ArrayList<PermItem>(selectedRows.size());
                for (ListSelectedRow selectedRow : selectedRows) {
                    String primaryKeyValue = (String)selectedRow.getPrimaryKeyValue();
                    String[] split = primaryKeyValue.split("\\|@@\\|", 12);
                    PermItem permItem = new PermItem();
                    permItem.setCloudId(split[0]);
                    permItem.setCloudNumber(split[1]);
                    permItem.setCloudName(split[2]);
                    permItem.setAppId(split[3]);
                    permItem.setAppNumber(split[4]);
                    permItem.setAppName(split[5]);
                    permItem.setEntityId(split[6]);
                    permItem.setEntityNumber(split[7]);
                    permItem.setEntityName(split[8]);
                    permItem.setPermItemId(split[9]);
                    permItem.setPermItemNumber(split[10]);
                    permItem.setPermItemName(split[11]);
                    appendPermItemList.add(permItem);
                }
                IPageCache pageCache = RoleBatchAssignPermPlugin.this.getPageCache();
                String pageId = pageCache.getPageId();
                pageCache.put(String.format(RoleBatchAssignPermPlugin.PGCACHEKEY_ROLEREMOVE, pageId), SerializationUtils.toJsonString(appendPermItemList));
                roleFuncPermBillList.refresh();
                roleFuncPermBillList.clearSelection();
                view.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"RoleBatchAssignPermPlugin_7", (String)RoleBatchAssignPermPlugin.SYSTEM_TYPE, (Object[])new Object[0]));
            }
        });
    }

    private boolean adminCanModifyRoleCheck() {
        DynamicObject role = (DynamicObject)this.getModel().getValue("role_number");
        if (null == role) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RoleBatchAssignPermPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        String roleId = (String)role.getPkValue();
        Map canModifyMap = AdminGroupService.canModifyRole((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(roleId));
        for (Map.Entry entry : canModifyMap.entrySet()) {
            Boolean canModify = (Boolean)entry.getValue();
            if (Boolean.TRUE.equals(canModify)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u4fee\u6539\u8be5\u901a\u7528\u89d2\u8272\u3002", (String)"RoleBatchAssignPermPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(5000));
            return false;
        }
        return true;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.ifDataChanged(CALLBCKID_CLOSE)) {
            e.setCancel(true);
        } else {
            this.release();
            this.clearPageCache();
        }
    }

    private boolean ifDataChanged(String callBackId) {
        String info = "";
        if (callBackId.equals(CALLBCKID_CLOSE)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"RoleBatchAssignPermPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        } else if (callBackId.equals(CALLBCKID_ROLENUM)) {
            info = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u5207\u6362\u89d2\u8272\uff1f", (String)"RoleBatchAssignPermPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        }
        String roleId = this.getView().getPageId().split("-")[0];
        Map<String, Object> diffMap = this.getDiffMap(roleId);
        boolean dataChanged = (Boolean)diffMap.get("dataChanged");
        if (dataChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
            this.getView().showConfirm(info, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        return false;
    }

    private Map<String, Object> getDiffMap(String roleId) {
        IPageCache pageCache = this.getPageCache();
        String pageId = pageCache.getPageId();
        List DBList = PermRoleHelper.getRolePlainPermItemList((String)roleId, (String)pageId);
        HashSet curSet = null;
        String roleCurStr = pageCache.get(String.format(PGCACHEKEY_ROLECUR, pageId));
        if (StringUtils.isEmpty((String)roleCurStr)) {
            curSet = new HashSet(1);
        } else {
            List curList = SerializationUtils.fromJsonStringToList((String)roleCurStr, PermItem.class);
            curSet = new HashSet(curList);
        }
        ArrayList delList = new ArrayList(1);
        List addList = ListUtil.removeAll(new LinkedList(curSet), (List)DBList);
        boolean dataChanged = false;
        if (!CollectionUtils.isEmpty(delList) || !CollectionUtils.isEmpty((Collection)addList)) {
            dataChanged = true;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("del", delList);
        map.put("add", addList);
        map.put("dataChanged", dataChanged);
        return map;
    }

    private void changeRole() {
        String pageId = this.getView().getPageId();
        String[] pageIdSplit = pageId.split("-batchAssignPerm-");
        String oldRoleId = pageIdSplit[0];
        String newRoleId = this.getPageCache().get("pageCache_newRoleId");
        String newPageId = newRoleId + "-batchAssignPerm-" + pageIdSplit[1];
        IFormView newFv = this.getView().getViewNoPlugin(newPageId);
        if (newFv != null) {
            this.getModel().setValue("role_number", (Object)oldRoleId);
            this.getModel().setDataChanged(false);
            this.getView().close();
            newFv.activate();
            this.getView().sendFormAction(newFv);
        } else {
            FormShowParameter param = this.getView().getFormShowParameter();
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            param.setPageId(newPageId);
            StringBuilder sbErrorInfo = new StringBuilder();
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                MutexHelper.release((String)"perm_role", (String)OPER_KEY_DONOTHING_BATCHASSIGNPERM, (String)oldRoleId);
            }
            if (MutexHelper.require((String)"perm_role", (Object)newRoleId, (String)OPER_KEY_DONOTHING_BATCHASSIGNPERM, (boolean)true, (StringBuilder)sbErrorInfo)) {
                this.getView().setStatus(OperationStatus.EDIT);
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
            }
            param.setCustomParam("roleId", (Object)newRoleId);
            this.getView().showForm(param);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (callBackId.equals(CALLBCKID_CLOSE)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.release();
            }
        } else if (callBackId.equals(CALLBCKID_ROLENUM)) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.changeRole();
            } else {
                String pageId = this.getView().getPageId();
                String[] pageIdSplit = pageId.split("-batchAssignPerm-");
                String oldRoleId = pageIdSplit[0];
                this.getPageCache().remove("pageCache_newRoleId");
                this.getModel().setValue("role_number", (Object)oldRoleId);
            }
        }
    }

    private void release() {
        String roleId = this.getView().getPageId().split("-")[0];
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            MutexHelper.release((String)"perm_role", (String)OPER_KEY_DONOTHING_BATCHASSIGNPERM, (String)roleId);
        }
        PermFormCommonUtil.closeClientForm(this.getView());
    }

    private void save() {
        IFormView view = this.getView();
        try {
            DynamicObject role = (DynamicObject)this.getModel().getValue("role_number");
            String roleId = (String)role.getPkValue();
            Map<String, Object> diffMap = this.getDiffMap(roleId);
            boolean dataChanged = (Boolean)diffMap.get("dataChanged");
            if (!dataChanged) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RoleBatchAssignPermPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            String rpId = "";
            boolean genNewRolepermId = false;
            HashSet<String> rolepermIdSet = new HashSet<String>(8);
            try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.basedata, (String)"select fid from t_perm_roleperm where froleid = ?", (Object[])new Object[]{roleId});){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    rolepermIdSet.add(row.getString("fid"));
                }
            }
            if (CollectionUtils.isEmpty(rolepermIdSet) || rolepermIdSet.size() > 1) {
                rpId = DB.genStringId((String)"t_perm_roleperm");
                genNewRolepermId = true;
            } else {
                rpId = (String)new ArrayList(rolepermIdSet).get(0);
            }
            HashSet<String> rolepermDetailIdSet = null;
            List delList = (List)diffMap.get("del");
            List addList = (List)diffMap.get("add");
            if (!CollectionUtils.isEmpty((Collection)delList)) {
                rolepermDetailIdSet = new HashSet<String>(delList.size());
                for (PermItem permItem : delList) {
                    rolepermDetailIdSet.add(permItem.getRolepermDetailId());
                }
            }
            HashMap<String, List> appEntity = new HashMap<String, List>(16);
            ArrayList<Object[]> rpdParamList = null;
            if (!CollectionUtils.isEmpty((Collection)addList)) {
                int size = addList.size();
                String[] newRpdFentryIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)size);
                rpdParamList = new ArrayList<Object[]>(size);
                for (int i = 0; i < size; ++i) {
                    PermItem permItem = (PermItem)addList.get(i);
                    String appId = permItem.getAppId();
                    String entityNum = permItem.getEntityNumber();
                    rpdParamList.add(new Object[]{rpId, newRpdFentryIds[i], 0, " ", permItem.getPermItemId(), " ", entityNum, appId, roleId});
                    appEntity.computeIfAbsent(appId, k -> new ArrayList()).add(entityNum);
                }
            }
            this.save2DB(roleId, genNewRolepermId, rolepermDetailIdSet, rpId, rpdParamList);
            List userIDs = PermCommonUtil.getUserByRole((String)roleId);
            if (!CollectionUtils.isEmpty((Collection)userIDs) && appEntity != null && appEntity.size() > 0) {
                LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj((List)userIDs, appEntity);
            }
            List influencedUser = PermCommonUtil.getInfluencedUserByRole(Collections.singletonList(roleId));
            PermCommonUtil.cancelShowForm((List)influencedUser, null, (boolean)false);
            IPageCache pageCache = this.getPageCache();
            RoleBatchAssignPermPlugin.clearAppendRemovePageCache(pageCache);
            PermissionServiceHelper.clearAllCache();
            if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty(diffMap) || CollectionUtils.isEmpty((Collection)delList) && CollectionUtils.isEmpty((Collection)addList))) {
                String roleNumber = role.getString("number");
                String roleName = role.getString("name");
                String opbtn = ConstantsHelper.getSave();
                diffMap.put("langStr", RequestContext.get().getLang().name());
                this.roleBatchAssignPerm2PermLog(BARITEM_SAVE, opbtn, roleId, roleNumber, roleName, StrUtil.compress((String)new ObjectMapper().writeValueAsString(diffMap)));
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RoleBatchAssignPermPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
        }
        catch (Exception e) {
            logger.warn("RoleBatchAssignPermPlugin.save error", (Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u901a\u7528\u89d2\u8272\u6279\u91cf\u6388\u6743\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"RoleBatchAssignPermPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void roleBatchAssignPerm2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String diffContent) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"common_role_batchassignperm");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.RoleBatchAssignPermPlugin.roleBatchAssignPerm2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            map.put("oper_id", RequestContext.get().getCurrUserId());
            map.put("oper_org_id", RequestContext.get().getOrgId());
            map.put("client_type", RequestContext.get().getClient());
            map.put("client_ip", RequestContext.get().getLoginIP());
            map.put("client_name", RequestContext.get().getClient());
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("RoleBatchAssignPermPlugin.roleBatchAssignPerm2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private void save2DB(String roleId, boolean genNewRolepermId, Set<String> rolepermDetailIdSet, String rpId, List<Object[]> rpdParamList) throws Exception {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (!CollectionUtils.isEmpty(rolepermDetailIdSet)) {
                    String rolepermDetailIdStr = String.join((CharSequence)"','", rolepermDetailIdSet);
                    StringBuilder delSb = new StringBuilder();
                    delSb.append("delete from t_perm_rolepermdetial where fentryid in( '").append(rolepermDetailIdStr).append("')");
                    DB.execute((DBRoute)DBRoute.basedata, (String)delSb.toString());
                }
                if (genNewRolepermId) {
                    DB.execute((DBRoute)DBRoute.basedata, (String)"delete from t_perm_roleperm where froleid = ?", (Object[])new Object[]{roleId});
                    StringBuilder insertPermRoleSql = new StringBuilder();
                    insertPermRoleSql.append("insert into t_perm_roleperm (fid, froleid, fcreatetime, fcreatorid, fmodifytime, fmodifierid, fstatus, fenable, fnumber, fmasterid)");
                    insertPermRoleSql.append(" values(?, ?, null, 0, null, 0, ' ', '0', ' ', ' ')");
                    DB.execute((DBRoute)DBRoute.basedata, (String)insertPermRoleSql.toString(), (Object[])new Object[]{rpId, roleId});
                    DB.execute((DBRoute)DBRoute.basedata, (String)"update t_perm_rolepermdetial set fid = ? where froleid = ?", (Object[])new Object[]{rpId, roleId});
                }
                if (!CollectionUtils.isEmpty(rpdParamList)) {
                    String rpdInsertSql = "insert into t_perm_rolepermdetial(fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid) values (?,?,?,?,?,?,?,?,?)";
                    int m = SqlUtil.getBatchCount((Integer)PermHelperConst.SQL_INSERT_BATCH_NUM_5000, (int)rpdParamList.size());
                    List mainListAvg = ListUtil.averageAssign(rpdParamList, (int)m);
                    int i = 0;
                    while (i < mainListAvg.size()) {
                        int finalI = i++;
                        DB.executeBatch((DBRoute)DBRoute.basedata, (String)rpdInsertSql, (List)((List)mainListAvg.get(finalI)));
                    }
                }
            }
            catch (Exception e) {
                logger.warn("\u901a\u7528\u89d2\u8272\u6279\u91cf\u6388\u6743\u914d\u7f6e\u4fdd\u5b58\u5165\u5e93\u5931\u8d25", (Throwable)e);
                txHandle.markRollback();
                throw new Exception(e);
            }
        }
    }

    private void clearPageCache() {
        IPageCache pageCache = this.getPageCache();
        String pageId = pageCache.getPageId();
        pageCache.batchRemove(Arrays.asList(String.format(PGCACHEKEY_ROLEAPPPEND, pageId), String.format(PGCACHEKEY_ROLEREMOVE, pageId), String.format(PGCACHEKEY_ROLECUR, pageId)));
    }

    protected static void clearAppendRemovePageCache(IPageCache pageCache) {
        String pageId = pageCache.getPageId();
        pageCache.batchRemove(Arrays.asList(String.format(PGCACHEKEY_ROLEAPPPEND, pageId), String.format(PGCACHEKEY_ROLEREMOVE, pageId)));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        DynamicObject role;
        DynamicObject dimType;
        String roleId = (String)this.getView().getFormShowParameter().getCustomParam("roleId");
        String dimension = "DIM_ORG";
        if (StringUtils.isNotEmpty((String)roleId) && (dimType = (role = BusinessDataServiceHelper.loadSingle((Object)roleId, (String)"perm_role")).getDynamicObject("dimtypeid")) != null) {
            dimension = dimType.getString("number");
        }
        BillList source = (BillList)args.getSource();
        String key = source.getKey();
        IPageCache pageCache = this.getPageCache();
        String showFormSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            pageCache.put("FormShowParam_ShowForSpecialUser", "true");
        }
        if (ALLFUNCPERM_BILLLIST.equals(key)) {
            args.setListDataProvider((IListDataProvider)new AllPermDataProvider(pageCache, dimension));
        } else if (ROLEFUNCPERM_BILLLIST.equals(key)) {
            args.setListDataProvider((IListDataProvider)new RolePermDataProvider(roleId, pageCache, dimension));
        }
    }

    private static List<PermItem> filterPlainPermItermList(List<PermItem> plainPermItemList, IPageCache pageCache, String keyFlag) {
        QFilter[] filters = RoleBatchAssignPermPlugin.getQfilter(pageCache, keyFlag);
        if (null == filters || filters.length == 0) {
            return plainPermItemList;
        }
        plainPermItemList = plainPermItemList.stream().filter(x -> {
            boolean finalMatch = true;
            boolean oneMatch = true;
            for (QFilter filter : filters) {
                String property = filter.getProperty();
                String cp = filter.getCP();
                Object value = filter.getValue();
                if ("cloudname".equals(property)) {
                    oneMatch = RoleBatchAssignPermPlugin.matchV(x.getCloudName(), cp, value);
                }
                if ("appname".equals(property)) {
                    oneMatch = RoleBatchAssignPermPlugin.matchV(x.getAppName(), cp, value);
                }
                if ("entname".equals(property)) {
                    oneMatch = RoleBatchAssignPermPlugin.matchV(x.getEntityName(), cp, value);
                }
                if ("permitemname".equals(property)) {
                    oneMatch = RoleBatchAssignPermPlugin.matchV(x.getPermItemName(), cp, value);
                }
                if ("permitemnumber".equals(property)) {
                    oneMatch = RoleBatchAssignPermPlugin.matchV(x.getPermItemNumber(), cp, value);
                }
                if (finalMatch && oneMatch) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return plainPermItemList;
    }

    private static boolean matchV(String fieldV, String cp, Object value) {
        if ("ftlike".equals(cp)) {
            return fieldV.contains((CharSequence)value);
        }
        if ("like".equals(cp)) {
            value = String.valueOf(value).replace("%", "");
            return fieldV.contains((CharSequence)value);
        }
        if ("not like".equals(cp)) {
            return !fieldV.contains(((String)value).substring(1, ((String)value).length() - 1));
        }
        if ("like".equals(cp)) {
            int startStrLen;
            String valueStr = String.valueOf(value);
            int likeIndex = valueStr.indexOf("%");
            if (0 == likeIndex) {
                int endStrLen;
                String endStr = valueStr.substring(1, valueStr.length());
                int fieldVLen = fieldV.length();
                if (fieldVLen < (endStrLen = endStr.length())) {
                    return false;
                }
                String fieldVEndStr = fieldV.substring(fieldVLen - endStrLen, fieldVLen);
                return fieldVEndStr.equals(endStr);
            }
            String startStr = ((String)value).substring(0, valueStr.length() - 1);
            int fieldVLen = fieldV.length();
            if (fieldVLen < (startStrLen = startStr.length())) {
                return false;
            }
            String fieldVStartStr = fieldV.substring(0, startStrLen);
            return fieldVStartStr.equals(startStr);
        }
        if ("=".equals(cp) && value instanceof QEmptyValue) {
            return StringUtils.isEmpty((String)fieldV);
        }
        if ("is not null".equals(cp)) {
            return StringUtils.isNotEmpty((String)fieldV);
        }
        if ("=".equals(cp)) {
            return fieldV.equals(value);
        }
        if ("!=".equals(cp)) {
            return !fieldV.equals(value);
        }
        return false;
    }

    private static DynamicObjectCollection wrapResultDoc(int start, int limit, String orderByExpr, List<PermItem> plainPermItemList) {
        List<PermItem> finalPermItemList = RoleBatchAssignPermPlugin.sortAndSub(start, limit, orderByExpr, plainPermItemList);
        MainEntityType itemType = EntityMetadataCache.getDataEntityType((String)FORM_PERM_ROLEBATCHASSIGNOBJ);
        DataEntityPropertyCollection props = itemType.getProperties();
        DynamicObjectCollection resultDoc = new DynamicObjectCollection((DynamicObjectType)itemType, null);
        DynamicObject dyn = null;
        for (PermItem item : finalPermItemList) {
            dyn = new DynamicObject((DynamicObjectType)itemType);
            for (IDataEntityProperty property : props) {
                if (property == null) continue;
                String propertyName = property.getName();
                if (property instanceof BasedataProp) continue;
                if ("id".equals(propertyName)) {
                    property.setValue((Object)dyn, (Object)(item.getCloudId() + "|" + "@@" + "|" + item.getCloudNumber() + "|" + "@@" + "|" + item.getCloudName() + "|" + "@@" + "|" + item.getAppId() + "|" + "@@" + "|" + item.getAppNumber() + "|" + "@@" + "|" + item.getAppName() + "|" + "@@" + "|" + item.getEntityId() + "|" + "@@" + "|" + item.getEntityNumber() + "|" + "@@" + "|" + item.getEntityName() + "|" + "@@" + "|" + item.getPermItemId() + "|" + "@@" + "|" + item.getPermItemNumber() + "|" + "@@" + "|" + item.getPermItemName()));
                    continue;
                }
                if ("cloud_id".equals(propertyName)) {
                    property.setValue((Object)dyn, (Object)item.getCloudId());
                    continue;
                }
                if ("cloudname".equals(propertyName)) {
                    String cloudName = item.getCloudName();
                    property.setValue((Object)dyn, (Object)cloudName);
                    continue;
                }
                if ("app_id".equals(propertyName)) {
                    property.setValue((Object)dyn, (Object)item.getAppId());
                    continue;
                }
                if ("appname".equals(propertyName)) {
                    String appName = item.getAppName();
                    property.setValue((Object)dyn, (Object)appName);
                    continue;
                }
                if ("entity_id".equals(propertyName)) {
                    property.setValue((Object)dyn, (Object)item.getEntityNumber());
                    continue;
                }
                if ("entname".equals(propertyName)) {
                    String entName = item.getEntityName();
                    property.setValue((Object)dyn, (Object)entName);
                    continue;
                }
                if ("permitem_id".equals(propertyName)) {
                    property.setValue((Object)dyn, (Object)item.getPermItemId());
                    continue;
                }
                if ("permitemname".equals(propertyName)) {
                    String permItemName = item.getPermItemName();
                    property.setValue((Object)dyn, (Object)permItemName);
                    continue;
                }
                if (!"permitemnumber".equals(propertyName)) continue;
                String permItemNumber = item.getPermItemNumber();
                property.setValue((Object)dyn, (Object)permItemNumber);
            }
            resultDoc.add((Object)dyn);
        }
        BusinessDataServiceHelper.loadRefence((Object[])resultDoc.toArray(), (IDataEntityType)itemType);
        return resultDoc;
    }

    private static List<PermItem> sortAndSub(int start, int limit, String orderByExpr, List<PermItem> plainPermItemList) {
        if (StringUtils.isEmpty((String)orderByExpr)) {
            return plainPermItemList.stream().sorted(Comparator.comparing(x -> x.getCloudId() + x.getAppId() + x.getEntityId() + x.getPermItemId())).skip(start).limit(limit).collect(Collectors.toList());
        }
        String[] split = orderByExpr.split(",");
        return plainPermItemList.stream().sorted((o1, o2) -> {
            String o2PermItemNumber;
            String o1PermItemNumber;
            String o2PermItemName;
            String o1PermItemName;
            String o2EntityName;
            String o1EntityName;
            String o2AppName;
            String o1AppName;
            String o2CloudName;
            String orderStr = split[0];
            String[] split_ = orderStr.split(" ");
            String orderField = split_[0];
            String orderType = split_[1];
            String o1Id = o1.getCloudId() + "|" + o1.getAppId() + "|" + o1.getEntityId() + "|" + o1.getPermItemId();
            String o2Id = o2.getCloudId() + "|" + o2.getAppId() + "|" + o2.getEntityId() + "|" + o2.getPermItemId();
            String o1CloudName = o1.getCloudName();
            if (StringUtils.isEmpty((String)o1CloudName)) {
                logger.warn("sortAndSub null,o1CloudName:{}, o1Id:{}, o2Id:{}", new Object[]{o1CloudName, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o2CloudName = o2.getCloudName()))) {
                logger.warn("sortAndSub null,o2CloudName:{}, o1Id:{}, o2Id:{}", new Object[]{o2CloudName, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o1AppName = o1.getAppName()))) {
                logger.warn("sortAndSub null,o1AppName:{}, o1Id:{}, o2Id:{}", new Object[]{o1AppName, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o2AppName = o2.getAppName()))) {
                logger.warn("sortAndSub null,o2AppName:{}, o1Id:{}, o2Id:{}", new Object[]{o2AppName, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o1EntityName = o1.getEntityName()))) {
                logger.warn("sortAndSub null,o1EntityName:{}, o1Id:{}, o2Id:{}", new Object[]{o1EntityName, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o2EntityName = o2.getEntityName()))) {
                logger.warn("sortAndSub null,o2EntityName:{}, o1Id:{}, o2Id:{}", new Object[]{o2EntityName, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o1PermItemName = o1.getPermItemName()))) {
                logger.warn("sortAndSub null,o1PermItemName:{}, o1Id:{}, o2Id:{}", new Object[]{o1PermItemName, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o2PermItemName = o2.getPermItemName()))) {
                logger.warn("sortAndSub null,o2PermItemName:{}, o1Id:{}, o2Id:{}", new Object[]{o2PermItemName, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o1PermItemNumber = o1.getPermItemNumber()))) {
                logger.warn("sortAndSub null,o1PermItemNumber:{}, o1Id:{}, o2Id:{}", new Object[]{o1PermItemNumber, o1Id, o2Id});
            }
            if (StringUtils.isEmpty((String)(o2PermItemNumber = o2.getPermItemNumber()))) {
                logger.warn("sortAndSub null,o2PermItemNumber:{}, o1Id:{}, o2Id:{}", new Object[]{o2PermItemNumber, o1Id, o2Id});
            }
            if ("desc".equals(orderType)) {
                if ("cloudname".equals(orderField)) {
                    return o1CloudName.compareTo(o2CloudName);
                }
                if ("appname".equals(orderField)) {
                    return o1AppName.compareTo(o2AppName);
                }
                if ("entname".equals(orderField)) {
                    return o1EntityName.compareTo(o2EntityName);
                }
                if ("permitemname".equals(orderField)) {
                    return o1PermItemName.compareTo(o2PermItemName);
                }
                if ("permitemnumber".equals(orderField)) {
                    return o1PermItemNumber.compareTo(o2PermItemNumber);
                }
                return o1Id.compareTo(o2Id);
            }
            if ("cloudname".equals(orderField)) {
                return o2CloudName.compareTo(o1CloudName);
            }
            if ("appname".equals(orderField)) {
                return o2AppName.compareTo(o1AppName);
            }
            if ("entname".equals(orderField)) {
                return o2EntityName.compareTo(o1EntityName);
            }
            if ("permitemname".equals(orderField)) {
                return o2PermItemName.compareTo(o1PermItemName);
            }
            if ("permitemnumber".equals(orderField)) {
                return o2PermItemNumber.compareTo(o1PermItemNumber);
            }
            return o1Id.compareTo(o2Id);
        }).skip(start).limit(limit).collect(Collectors.toList());
    }

    private static QFilter[] getQfilter(IPageCache pageCache, String keyFlag) {
        String key = keyFlag + "@@" + "filter";
        String filterJson = pageCache.get(key);
        QFilter[] filter = null;
        if (StringUtils.isNotEmpty((String)filterJson)) {
            List list = (List)SerializationUtils.fromJsonString((String)filterJson, List.class);
            filter = new QFilter[list.size()];
            int i = 0;
            for (String qfilterStr : list) {
                filter[i++] = QFilter.fromSerializedString((String)qfilterStr);
            }
        }
        return filter;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String showFormSpecial = (String)e.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)e.getFormShowParameter().getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"0XWTKVOQW+ML", (String)"perm_role", (String)"4715a0df000000ac")) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u6279\u91cf\u8ffd\u52a0\u6388\u6743\u3002", (String)"RoleBatchAssignPermPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
    }

    static class AllPermDataProvider
    extends ListDataProvider {
        private IPageCache pageCache;
        private String dimension;

        public AllPermDataProvider(IPageCache pageCache, String dimension) {
            this.pageCache = pageCache;
            this.dimension = dimension;
        }

        public int getMaxCount() {
            return Integer.parseInt(this.pageCache.get("PERM_MAXCOUNT"));
        }

        public DynamicObjectCollection getData(int start, int limit) {
            List plainPermItemList = null;
            String plainPermItemListStr = this.pageCache.getBigObject(RoleBatchAssignPermPlugin.PGCACHEKEY_PLAINPERMITEMLIST);
            String showForSpecial = this.pageCache.get("FormShowParam_ShowForSpecialUser");
            if (StringUtils.isEmpty((String)plainPermItemListStr)) {
                HashMap<String, String> paraMap = new HashMap<String, String>(8);
                paraMap.put("dimension", this.dimension);
                paraMap.put("dimDiffHide", "0");
                if ("true".equals(showForSpecial)) {
                    paraMap.put("FormShowParam_ShowForSpecialUser", "true");
                }
                plainPermItemList = PermItemHelper.getPlainPermItemList(paraMap);
                this.pageCache.putBigObject(RoleBatchAssignPermPlugin.PGCACHEKEY_PLAINPERMITEMLIST, StrUtil.compress((String)SerializationUtils.toJsonString((Object)plainPermItemList)));
            } else {
                try {
                    plainPermItemList = (List)new ObjectMapper().readValue(StrUtil.uncompress((String)plainPermItemListStr), (TypeReference)new TypeReference<List<PermItem>>(){});
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (CollectionUtils.isEmpty((Collection)plainPermItemList)) {
                return new DynamicObjectCollection(new DynamicObjectType(), null);
            }
            if (CollectionUtils.isEmpty((Collection)(plainPermItemList = RoleBatchAssignPermPlugin.filterPlainPermItermList(plainPermItemList, this.pageCache, RoleBatchAssignPermPlugin.ALLFUNCPERM_BILLLIST)))) {
                return new DynamicObjectCollection(new DynamicObjectType(), null);
            }
            String orderByExpr = this.getOrderByExpr();
            DynamicObjectCollection resultDoc = RoleBatchAssignPermPlugin.wrapResultDoc(start, limit, orderByExpr, plainPermItemList);
            QueryResult queryResult = this.getQueryResult();
            int dataCount = plainPermItemList.size();
            queryResult.setDataCount(dataCount);
            queryResult.setCollection(resultDoc);
            this.pageCache.put("PERM_MAXCOUNT", String.valueOf(dataCount));
            return resultDoc;
        }

        public IPageCache getPageCache() {
            return this.pageCache;
        }

        public void setPageCache(IPageCache pageCache) {
            this.pageCache = pageCache;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }
    }

    static class RolePermDataProvider
    extends ListDataProvider {
        private String roleId;
        private IPageCache pageCache;
        private String dimension;

        public RolePermDataProvider(String roleId, IPageCache pageCache, String dimension) {
            this.roleId = roleId;
            this.pageCache = pageCache;
            this.dimension = dimension;
        }

        public int getMaxCount() {
            return Integer.parseInt(this.pageCache.get("PERM_MAXCOUNT"));
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String roleRemoveStr;
            List plainPermItemList = null;
            String pageId = this.pageCache.getPageId();
            String roleCurStr = this.pageCache.get(String.format(RoleBatchAssignPermPlugin.PGCACHEKEY_ROLECUR, pageId));
            plainPermItemList = StringUtils.isEmpty((String)roleCurStr) ? new ArrayList(10) : SerializationUtils.fromJsonStringToList((String)roleCurStr, PermItem.class);
            String roleAppendStr = this.pageCache.get(String.format(RoleBatchAssignPermPlugin.PGCACHEKEY_ROLEAPPPEND, pageId));
            if (StringUtils.isNotEmpty((String)roleAppendStr)) {
                List roleAppendList = SerializationUtils.fromJsonStringToList((String)roleAppendStr, PermItem.class);
                plainPermItemList.addAll(roleAppendList);
                this.pageCache.put(String.format(RoleBatchAssignPermPlugin.PGCACHEKEY_ROLECUR, pageId), SerializationUtils.toJsonString(plainPermItemList));
            }
            if (StringUtils.isNotEmpty((String)(roleRemoveStr = this.pageCache.get(String.format(RoleBatchAssignPermPlugin.PGCACHEKEY_ROLEREMOVE, pageId))))) {
                List roleRemoveList = SerializationUtils.fromJsonStringToList((String)roleRemoveStr, PermItem.class);
                plainPermItemList = ListUtil.removeAll(plainPermItemList, (List)roleRemoveList);
                this.pageCache.put(String.format(RoleBatchAssignPermPlugin.PGCACHEKEY_ROLECUR, pageId), SerializationUtils.toJsonString(plainPermItemList));
            }
            plainPermItemList = RoleBatchAssignPermPlugin.filterPlainPermItermList(plainPermItemList, this.pageCache, RoleBatchAssignPermPlugin.ROLEFUNCPERM_BILLLIST);
            String orderByExpr = this.getOrderByExpr();
            DynamicObjectCollection resultDoc = RoleBatchAssignPermPlugin.wrapResultDoc(start, limit, orderByExpr, plainPermItemList);
            RoleBatchAssignPermPlugin.clearAppendRemovePageCache(this.pageCache);
            QueryResult queryResult = this.getQueryResult();
            int dataCount = plainPermItemList.size();
            queryResult.setDataCount(dataCount);
            queryResult.setCollection(resultDoc);
            this.pageCache.put("PERM_MAXCOUNT", String.valueOf(dataCount));
            return resultDoc;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public IPageCache getPageCache() {
            return this.pageCache;
        }

        public void setPageCache(IPageCache pageCache) {
            this.pageCache = pageCache;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }
    }
}

