/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ParentBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class RoleGroupEditPlugin
extends AbstractFormPlugin {
    public static final String FIELD_PARENT = "parent";
    public static final String FIELD_LONGNUMBER = "longnumber";
    public static final String ENTITY_ROLEGROUP = "perm_rolegroup";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentPageId = formShowParameter.getParentPageId();
        IFormView parentFormView = SessionManager.getCurrent().getViewNoPlugin(parentPageId);
        if (parentFormView != null) {
            TreeView tv = (TreeView)parentFormView.getControl("treeview");
            if (tv == null) {
                return;
            }
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            this.getModel().setValue(FIELD_PARENT, (Object)focusNodeId);
        }
    }

    public void afterBindData(EventObject e) {
        String curLongNum = (String)this.getModel().getValue(FIELD_LONGNUMBER);
        if (StringUtils.isNotEmpty((String)curLongNum)) {
            ParentBasedataEdit parentEdit = (ParentBasedataEdit)this.getControl(FIELD_PARENT);
            parentEdit.setQFilter(new QFilter(FIELD_LONGNUMBER, "not like", (Object)(curLongNum + "%")));
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (operateKey.equals("save")) {
            String parentLongNum;
            String curLongNum = (String)this.getModel().getValue(FIELD_LONGNUMBER);
            DynamicObject parent = (DynamicObject)this.getModel().getValue(FIELD_PARENT);
            if (parent != null && (parentLongNum = parent.getString(FIELD_LONGNUMBER)).contains(curLongNum)) {
                args.cancel = true;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u7ea7\u89d2\u8272\u5206\u7ec4\u4e0d\u80fd\u662f\u5f53\u524d\u5206\u7ec4\u7684\u4e0b\u7ea7\u3002", (String)"RoleGroupEditPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List pkIds;
        super.afterDoOperation(e);
        String objectId = e.getOperateKey();
        if (objectId.equals("save") && (pkIds = e.getOperationResult().getSuccessPkIds()) != null && pkIds.size() > 0) {
            String pkId = (String)pkIds.get(0);
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)ENTITY_ROLEGROUP, (String)"parent,number,longnumber");
            DynamicObject parentObj = dObj.getDynamicObject(FIELD_PARENT);
            String number = dObj.getString("number");
            if (parentObj != null) {
                String parentId = parentObj.getString("id");
                if (StringUtils.isNotEmpty((String)parentId)) {
                    DynamicObject qParentObj = QueryServiceHelper.queryOne((String)ENTITY_ROLEGROUP, (String)FIELD_LONGNUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentId)});
                    String parentLongNum = qParentObj.getString(FIELD_LONGNUMBER);
                    String newLongNum = parentLongNum + "." + number;
                    dObj.set(FIELD_LONGNUMBER, (Object)newLongNum);
                    try (TXHandle h = TX.required();){
                        try {
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
                        }
                        catch (Exception ex) {
                            h.markRollback();
                        }
                    }
                }
            } else {
                dObj.set(FIELD_LONGNUMBER, (Object)number);
                try (TXHandle h = TX.required();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
                    }
                    catch (Exception ex) {
                        h.markRollback();
                    }
                }
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String parentShowFormSpecial;
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String parentPageId = formShowParameter.getParentPageId();
        IFormView parentFormView = SessionManager.getCurrent().getViewNoPlugin(parentPageId);
        if (null != parentFormView && "true".equals(parentShowFormSpecial = (String)parentFormView.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser"))) {
            return;
        }
        String showFormSpecial = (String)formShowParameter.getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)e.getFormShowParameter().getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5168\u529f\u80fd\u7528\u6237\uff0c\u4e5f\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd", (String)"RoleGroupEditPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
    }
}

