/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.util.StringUtils;

public class SuperUserCardPlugin
extends AbstractBillPlugIn
implements ClickListener,
SearchEnterListener {
    public static final String SUPER_CARD_SEARCH_FILTER = "superCardSearchFilter";
    private static final String PROP_ENTRYENTITY = "entryentity";
    private static final String PERM_SUPERUSER_ENTITY = "perm_superuser";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String FORM_SUPERUSERCARD = "perm_superusercard";
    private static final Log logger = LogFactory.getLog(SuperUserCardPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"del_superuser", "btn_new", "usercard_add"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search s = (Search)this.getControl("searchap");
        s.addEnterListener((SearchEnterListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("deleteentry")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u201c\u5168\u529f\u80fd\u7528\u6237\u201d\u5220\u9664\u6210\u529f\u3002", (String)"SuperUserCardPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            CacheMrg.clearAllCache();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.loadSuperUserCard(null);
    }

    private void loadSuperUserCard(QFilter[] filters) {
        IDataModel model = this.getModel();
        model.deleteEntryData(PROP_ENTRYENTITY);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)PERM_SUPERUSER_ENTITY, (String)"user", (QFilter[])filters);
        ArrayList<String> ids = new ArrayList<String>(8);
        if (null == dynamicObjects || 0 == dynamicObjects.length) {
            this.getPageCache().put("ids", SerializationUtils.toJsonString(ids));
            return;
        }
        List collect = Arrays.stream(dynamicObjects).sorted(Comparator.comparing(x -> StringUtils.isEmpty((String)x.getString("user.simplepinyin")) ? " " : x.getString("user.simplepinyin"))).collect(Collectors.toList());
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[]{"useravatarfield", "userfield", "userfnumber"});
        for (DynamicObject superUser : collect) {
            DynamicObject user = superUser.getDynamicObject("user");
            if (null == user) continue;
            ids.add(superUser.getString("id"));
            vs.addRow(new Object[]{user.get("picturefield"), user.get("name"), user.get("number")});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(PROP_ENTRYENTITY, vs);
        this.getModel().endInit();
        this.getView().updateView(PROP_ENTRYENTITY);
        this.getPageCache().putBigObject("ids", SerializationUtils.toJsonString(ids));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        long curUserId = RequestContext.get().getCurrUserId();
        if ("btn_new".equalsIgnoreCase(key) || "usercard_add".equalsIgnoreCase(key)) {
            boolean hasPermission = PermissionServiceHelper.checkPermission((Long)curUserId, (String)"0XWTKVOQW+ML", (String)FORM_SUPERUSERCARD, (String)"47156aff000000ac");
            boolean isSuperAdminUser = PermissionServiceHelper.isAdminUser((long)curUserId, (String)"10");
            if (isSuperAdminUser || hasPermission) {
                this.showCardAdd(null);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"SuperUserCardPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("del_superuser".equalsIgnoreCase(key)) {
            boolean canUse;
            long curUserId = RequestContext.get().getCurrUserId();
            boolean isVirtualType = PermissionServiceHelper.isAdminUser((long)curUserId, (String)"10");
            boolean canDelSuperUser = PermissionServiceHelper.checkPermission((Long)curUserId, (String)"0XWTKVOQW+ML", (String)FORM_SUPERUSERCARD, (String)"4715e1f1000000ac");
            boolean bl = canUse = isVirtualType && canDelSuperUser;
            if (!canUse) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"SuperUserCardPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
                evt.setCancel(true);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        int i = e.getRowIndexs()[0];
        List ids = (List)SerializationUtils.fromJsonString((String)this.getPageCache().getBigObject("ids"), ArrayList.class);
        Object id = ids.remove(i);
        DynamicObject user = BusinessDataServiceHelper.loadSingle(id, (String)PERM_SUPERUSER_ENTITY).getDynamicObject("user");
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)PERM_SUPERUSER_ENTITY), (Object[])new Object[]{id});
        if (user != null) {
            Object toDeleteId = user.getPkValue();
            String strToDeleteId = toDeleteId.toString();
            Long tempToDelId = Long.parseLong(strToDeleteId);
            CacheMrg.clearAllCache();
            String formNum = PERM_SUPERUSER_ENTITY;
            String curLogAppId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String name = user.getString("name");
            String uNum = user.getString("number");
            MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u5220\u9664\u5168\u529f\u80fd\u7528\u6237", "SuperUserCardPlugin_2", SYSTEM_TYPE);
            MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5168\u529f\u80fd\u7528\u6237\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u3002", "SuperUserCardPlugin_6", SYSTEM_TYPE);
            String[] opDescParam = new String[]{name};
            String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5168\u529f\u80fd\u7528\u6237\uff1a%1$s\uff0c\u5220\u9664\u6210\u529f\u3002", (String)"SuperUserCardPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), name);
            PermCommonUtil.addLog(null, null, (String)formNum, (String)uNum, (String)"1", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
            if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                try {
                    ArrayList<Long> userIds = new ArrayList<Long>(10);
                    userIds.add(tempToDelId);
                    FormConfigFactory.cancelShowFormRights(userIds);
                }
                catch (Exception exception) {
                    logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Object)e);
                }
            }
        }
        this.getPageCache().putBigObject("ids", SerializationUtils.toJsonString((Object)ids));
    }

    private void showCardAdd(Object pkValue) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId(PERM_SUPERUSER_ENTITY);
        if (pkValue != null) {
            param.setStatus(OperationStatus.EDIT);
            param.setPkId(pkValue);
        }
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addNew"));
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals("addNew")) {
            if (e.getReturnData() != null) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u201c\u5168\u529f\u80fd\u7528\u6237\u201d\u6dfb\u52a0\u6210\u529f\u3002", (String)"SuperUserCardPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            QFilter[] filters = null;
            String searchFilter = this.getPageCache().get(SUPER_CARD_SEARCH_FILTER);
            if (StringUtils.isNotEmpty((String)searchFilter)) {
                QFilter filter = QFilter.fromSerializedString((String)searchFilter);
                filters = new QFilter[]{filter};
            }
            this.loadSuperUserCard(filters);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
        this.getModel().getDataEntity().getDataEntityState().setRemovedItems(Boolean.FALSE);
    }

    public void search(SearchEnterEvent event) {
        QFilter[] filters = null;
        String searchText = event.getText();
        List fieldNames = event.getFieldNames();
        QFilter f = null;
        if (StringUtils.isNotEmpty((String)searchText)) {
            int i;
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bos_user");
            DataEntityPropertyCollection properties = mainType.getProperties();
            IDataEntityProperty trueNameDEP = (IDataEntityProperty)properties.get((Object)"name");
            IDataEntityProperty phoneDEP = (IDataEntityProperty)properties.get((Object)"phone");
            IDataEntityProperty emailDEP = (IDataEntityProperty)properties.get((Object)"email");
            IDataEntityProperty numberDEP = (IDataEntityProperty)properties.get((Object)"number");
            String localeName = RequestContext.get().getLang().name();
            boolean trueNameDesensitize = PrivacyCenterServiceHelper.isDesensitizeField((IDataEntityProperty)trueNameDEP, (String)localeName, (String)"LIST", null);
            boolean phoneDesensitize = PrivacyCenterServiceHelper.isDesensitizeField((IDataEntityProperty)phoneDEP, (String)localeName, (String)"LIST", null);
            boolean emailDesensitize = PrivacyCenterServiceHelper.isDesensitizeField((IDataEntityProperty)emailDEP, (String)localeName, (String)"LIST", null);
            boolean numberDesensitize = PrivacyCenterServiceHelper.isDesensitizeField((IDataEntityProperty)numberDEP, (String)localeName, (String)"LIST", null);
            boolean trueNameEncrypt = PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)trueNameDEP);
            boolean phoneEncrypt = PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)phoneDEP);
            boolean emailEncrypt = PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)emailDEP);
            boolean numberEncrypt = PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)numberDEP);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            for (i = 0; i < fieldNames.size(); ++i) {
                String property = (String)fieldNames.get(i);
                if (Objects.equals("user.name", property) && (trueNameDesensitize || trueNameEncrypt) || Objects.equals("user.phone", property) && (phoneDesensitize || phoneEncrypt) || Objects.equals("user.email", property) && (emailDesensitize || emailEncrypt) || Objects.equals("user.number", property) && (numberDesensitize || numberEncrypt)) continue;
                qFilterList.add(new QFilter(property, "like", (Object)("%" + searchText + "%")));
            }
            for (i = 0; i < qFilterList.size(); ++i) {
                if (i == 0) {
                    f = (QFilter)qFilterList.get(i);
                    continue;
                }
                f.or((QFilter)qFilterList.get(i));
            }
            filters = new QFilter[]{f};
        }
        if (f != null) {
            this.getPageCache().put(SUPER_CARD_SEARCH_FILTER, f.toSerializedString());
        } else {
            this.getPageCache().put(SUPER_CARD_SEARCH_FILTER, null);
        }
        this.loadSuperUserCard(filters);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String mes = PermCommonUtil.validateOpenSuperUserPage();
        if (!StringUtils.isEmpty((String)mes)) {
            e.setCancel(true);
            e.setCancelMessage(mes);
        }
    }
}

