/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class SuperUserPlugin
extends AbstractFormPlugin {
    public static final String BTN_SAVE = "btnsave";
    private static final String PERM_SUPERUSER_ENTITY = "perm_superuser";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final Log logger = LogFactory.getLog(SuperUserPlugin.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)PERM_SUPERUSER_ENTITY, (String)"user", null);
        ArrayList<Object> ids = new ArrayList<Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject userObj = dynamicObject.getDynamicObject("user");
            if (userObj == null) continue;
            ids.add(userObj.getPkValue());
        }
        BasedataEdit baseDataF7 = (BasedataEdit)this.getControl("user");
        QFilter qFilter = UserUtils.getUserTypesLikeFilter((List)Lists.newArrayList((Object[])new Long[]{1L})).and("id", "not in", ids).and("enable", "=", (Object)"1").and("isforbidden", "=", (Object)"0");
        baseDataF7.setQFilter(qFilter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnsave": {
                IFormView parentView = this.getView().getParentView();
                IDataModel parentModel = parentView.getModel();
                DynamicObject user = (DynamicObject)this.getModel().getValue("user");
                if (user == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7528\u6237\u4fe1\u606f\u3002", (String)"SuperUserPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                boolean exists = QueryServiceHelper.exists((String)PERM_SUPERUSER_ENTITY, (QFilter[])new QFilter[]{new QFilter("user", "=", user.getPkValue())});
                if (exists) {
                    this.getView().showTipNotification("\u201c" + user.getString("name") + "\u201d" + ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u3002", (String)"SuperUserPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)PERM_SUPERUSER_ENTITY);
                DynamicObject dynamicObject = this.getModel().getDataEntity();
                BusinessDataServiceHelper.save((IDataEntityType)type, (Object[])new DynamicObject[]{dynamicObject});
                this.getView().returnDataToParent(user.getPkValue());
                String pkValue = (String)this.getModel().getDataEntity().getPkValue();
                if (null != user) {
                    String formNum = PERM_SUPERUSER_ENTITY;
                    String curLogAppId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
                    String name = user.getString("name");
                    String uNum = user.getString("number");
                    if (StringUtils.isNotEmpty((String)pkValue)) {
                        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u6dfb\u52a0\u5168\u529f\u80fd\u7528\u6237", "SuperUserPlugin_2", SYSTEM_TYPE);
                        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5168\u529f\u80fd\u7528\u6237\uff1a%1$s\uff0c\u6dfb\u52a0\u6210\u529f\u3002", "SuperUserPlugin_3", SYSTEM_TYPE);
                        String[] opDescParam = new String[]{name};
                        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5168\u529f\u80fd\u7528\u6237\uff1a%1$s\uff0c\u6dfb\u52a0\u6210\u529f\u3002", (String)"SuperUserPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), name);
                        PermCommonUtil.addLog(null, null, (String)formNum, (String)uNum, (String)"1", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
                    } else {
                        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u6dfb\u52a0\u5168\u529f\u80fd\u7528\u6237", "SuperUserPlugin_2", SYSTEM_TYPE);
                        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5168\u529f\u80fd\u7528\u6237\uff1a%1$s\uff0c\u6dfb\u52a0\u5931\u8d25\u3002", "SuperUserPlugin_4", SYSTEM_TYPE);
                        String[] opDescParam = new String[]{name};
                        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5168\u529f\u80fd\u7528\u6237\uff1a%1$s\uff0c\u6dfb\u52a0\u5931\u8d25\u3002", (String)"SuperUserPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), name);
                        PermCommonUtil.addLog(null, null, (String)formNum, (String)uNum, (String)"1", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
                    }
                }
                Long userId = (Long)user.getPkValue();
                CacheMrg.clearAllCache();
                if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                    try {
                        ArrayList<Long> userIds = new ArrayList<Long>(10);
                        userIds.add(userId);
                        FormConfigFactory.cancelShowFormRights(userIds);
                    }
                    catch (Exception e) {
                        logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
                    }
                }
                parentModel.setValue("pkvalue", (Object)pkValue);
                this.getView().close();
                break;
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String mes = PermCommonUtil.validateOpenSuperUserPage();
        if (!StringUtils.isEmpty((String)mes)) {
            e.setCancel(true);
            e.setCancelMessage(mes);
        }
    }
}

