/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.impl.SessionComServiceImpl;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.preOpenPermFormCheck;
import kd.bos.permission.model.UserParam;
import kd.bos.permission.util.PhoneI18nValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class UserAdminTagEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
preOpenPermFormCheck {
    private static Log logger = LogFactory.getLog(UserAdminTagEditPlugin.class);
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static Map<String, String> adminTags = new HashMap<String, String>(3);
    private static Set<Long> virtualAdminIDs = new HashSet<Long>(4);
    private static final String OPERATE_SAVE = "save";
    private static final String ENTITY_USERADMINTAGS = "perm_useradmintags";
    private static final String PROP_ADMINTAG = "admintag";
    private static final String PROP_USER = "user";
    private static final String PROP_PHONE = "phone";
    private static final String PROP_EMAIL = "email";
    private static final String PROP_TRANSFEROR = "transferor";
    private static final String PROP_TRANSFERTIME = "transfertime";
    private static final String ENTITY_ADMIN = "perm_admin";
    private static final String CONFIRMCALLBACK_ISCONTINUE = "confirmCallBack_isContinue";
    private static final String ENTITY_ADMINSCHEME = "perm_adminscheme";
    private static final String PROP_ISALLOWBIZOPERATE = "isallowbizoperate";
    private static final String PERM_USERADMINGROUP = "perm_useradmingroup";
    private static final String BTN_SAVE = "btnsave";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit userField = (BasedataEdit)this.getControl(PROP_USER);
        if (userField != null) {
            userField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{BTN_SAVE});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        String propName = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        if (PROP_USER.equals(propName) && newValue != oldValue) {
            DynamicObject user = (DynamicObject)dataModel.getValue(PROP_USER);
            if (user == null) {
                return;
            }
            dataModel.setValue(PROP_PHONE, (Object)user.getString(PROP_PHONE));
            dataModel.setValue(PROP_EMAIL, (Object)user.getString(PROP_EMAIL));
            String number = (String)dataModel.getValue("number");
            String userNumber = user.getString("number");
            if (adminTags.containsKey(userNumber) && userNumber.equals(number)) {
                view.setEnable(Boolean.valueOf(true), new String[]{PROP_PHONE, PROP_EMAIL});
            } else {
                view.setEnable(Boolean.valueOf(false), new String[]{PROP_PHONE, PROP_EMAIL});
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String number = (String)this.getModel().getValue("number");
        ArrayList<String> adminTagList = new ArrayList<String>(6);
        String adminTag = adminTags.get(number);
        adminTagList.add(adminTag);
        adminTagList.add(adminTag + ' ');
        QFilter filter = new QFilter(PROP_ADMINTAG, "in", adminTagList);
        DynamicObject adminUser = BusinessDataServiceHelper.loadSingle((String)ENTITY_USERADMINTAGS, (String)PROP_USER, (QFilter[])new QFilter[]{filter});
        if (adminUser == null) {
            return;
        }
        DynamicObject user = adminUser.getDynamicObject(PROP_USER);
        if (user == null) {
            return;
        }
        Object pkValue = user.getPkValue();
        DynamicObject userNoCache = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bos_user", (String)"phone,email");
        String phone = null == userNoCache ? "" : userNoCache.getString(PROP_PHONE);
        String email = null == userNoCache ? "" : userNoCache.getString(PROP_EMAIL);
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().setValue(PROP_USER, pkValue);
        this.getModel().setValue(PROP_PHONE, (Object)phone);
        this.getModel().setValue(PROP_EMAIL, (Object)email);
        this.getModel().setDataChanged(dataChanged);
        this.getPageCache().put("oriphone", phone);
        this.getPageCache().put("oriemail", email);
        this.getPageCache().put("oriuserid", String.valueOf(pkValue));
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && (key = (btn = (Button)source).getKey()).equals(BTN_SAVE) && this.saveUserAdminTagValidate()) {
            this.saveUserAdminTag();
        }
    }

    private boolean saveUserAdminTagValidate() {
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        try {
            DynamicObject user = (DynamicObject)dataModel.getValue(PROP_USER);
            if (user == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237", (String)"UserAdminTagEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            String propPhone = (String)dataModel.getValue(PROP_PHONE);
            String propEmail = (String)dataModel.getValue(PROP_EMAIL);
            Object pkValue = user.getPkValue();
            this.checkPhoneEmail(pkValue, propPhone, propEmail);
            String number = (String)dataModel.getValue("number");
            ArrayList<String> adminTagList = new ArrayList<String>(6);
            String adminTag = adminTags.get(number);
            adminTagList.add(adminTag);
            adminTagList.add(adminTag + ' ');
            boolean exists = QueryServiceHelper.exists((String)ENTITY_USERADMINTAGS, (QFilter[])new QFilter[]{new QFilter(PROP_USER, "=", pkValue).and(PROP_ADMINTAG, "not in", adminTagList)});
            if (exists) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5df2\u7ecf\u662f\u865a\u62df\u7ba1\u7406\u5458\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"UserAdminTagEditPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            DynamicObject curEnableScheme = null;
            try {
                String oriuserid = this.getPageCache().get("oriuserid");
                curEnableScheme = this.checkAdminSchemeAndType(oriuserid, String.valueOf(pkValue));
            }
            catch (Exception e) {
                view.showErrorNotification(e.getMessage());
                return false;
            }
            if (!PermCommonUtil.hasEnableOldAdmin()) {
                Long schemeId = curEnableScheme.getLong("id");
                exists = QueryServiceHelper.exists((String)PERM_USERADMINGROUP, (QFilter[])new QFilter[]{new QFilter(PROP_USER, "=", pkValue), new QFilter("usergroup.adminscheme", "=", (Object)schemeId), new QFilter("usergroup.level", "!=", (Object)1L)});
            } else {
                exists = QueryServiceHelper.exists((String)ENTITY_ADMIN, (QFilter[])new QFilter[]{new QFilter(PROP_USER, "=", pkValue).and("type", "=", (Object)"20")});
            }
            if (exists) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5df2\u7ecf\u662f\u5b50\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4fdd\u5b58\u5931\u8d25", (String)"UserAdminTagEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (!this.isAllowAdminBizOperate()) {
                view.showConfirm(ResManager.loadKDString((String)"\u865a\u62df\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u505a\u4e1a\u52a1\uff0c\u8be5\u7528\u6237\u4f1a\u6e05\u7a7a\u6240\u6709\u4e1a\u52a1\u6743\u9650\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"UserAdminTagEditPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_ISCONTINUE, (IFormPlugin)this));
                return false;
            }
        }
        catch (Exception exc) {
            String[] split;
            logger.warn("\u4fdd\u5b58\u7528\u6237\u7ba1\u7406\u5458\u6620\u5c04\u5173\u7cfb, \u6821\u9a8c\u5931\u8d25", (Throwable)exc);
            String message = exc.getMessage();
            if (StringUtils.isNotEmpty((String)message) && message.contains("Exception:") && (split = message.split("Exception:")).length > 1) {
                view.showErrorNotification(split[1]);
                return false;
            }
            view.showErrorNotification(message);
            return false;
        }
        return true;
    }

    private DynamicObject checkAdminSchemeAndType(String oriUserId, String curUserId) throws Exception {
        String number;
        Long schemeId;
        DynamicObject adminGroup;
        DynamicObject curEnableScheme = AdminSchemeHelper.getCurEnableScheme();
        if (null == curEnableScheme) {
            throw new Exception(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u542f\u7528\u7684\u201c\u6743\u9650\u63a7\u5236\u7b56\u7565\u201d\u3002", (String)"UserAdminTagEditPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (!PermissionServiceHelper.hasEnableOldAdmin() && !Objects.equals(oriUserId, curUserId) && null == (adminGroup = BusinessDataServiceHelper.loadSingle((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("adminscheme", "=", (Object)(schemeId = Long.valueOf(curEnableScheme.getLong("id")))), new QFilter("admintype", "=", (Object)Long.parseLong(adminTags.get(number = (String)this.getModel().getValue("number")))), new QFilter("level", "=", (Object)1)}))) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u65e0\u6743\u8f6c\u8ba9\u3002\u6743\u9650\u63a7\u5236\u7b56\u7565\uff1a%s\uff0c\u6ca1\u6709\u5305\u542b\u6240\u9009\u865a\u62df\u7ba1\u7406\u5458\u7c7b\u578b\u3002", (String)"UserAdminTagEditPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), curEnableScheme.getString("name")));
        }
        return curEnableScheme;
    }

    private void saveUserAdminTag() {
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        String number = (String)dataModel.getValue("number");
        DynamicObject user = (DynamicObject)dataModel.getValue(PROP_USER);
        Object pkValue = user.getPkValue();
        String selectedField = "admintag, user, transferor, transfertime";
        ArrayList<String> adminTagList = new ArrayList<String>(6);
        String adminTag = adminTags.get(number);
        adminTagList.add(adminTag);
        adminTagList.add(adminTag + ' ');
        QFilter filter = new QFilter(PROP_ADMINTAG, "in", adminTagList);
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject userAdminTag;
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_USERADMINTAGS, (String)selectedField, (QFilter[])new QFilter[]{filter}, (String)"id");
                if (dynamicObjects.length == 1) {
                    userAdminTag = dynamicObjects[0];
                } else if (dynamicObjects.length == 0) {
                    userAdminTag = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_USERADMINTAGS);
                    userAdminTag.set(PROP_ADMINTAG, (Object)adminTags.get(number));
                } else {
                    userAdminTag = dynamicObjects[0];
                    ArrayList<Long> delIds = new ArrayList<Long>(dynamicObjects.length - 1);
                    for (int i = 1; i < dynamicObjects.length; ++i) {
                        delIds.add(dynamicObjects[i].getLong("id"));
                    }
                    DeleteServiceHelper.delete((String)ENTITY_USERADMINTAGS, (QFilter[])new QFilter[]{new QFilter("id", "in", delIds)});
                }
                String sourceUserID = userAdminTag.getString("user_id");
                userAdminTag.set(PROP_USER, pkValue);
                userAdminTag.set(PROP_TRANSFEROR, (Object)RequestContext.get().getCurrUserId());
                userAdminTag.set(PROP_TRANSFERTIME, (Object)TimeServiceHelper.now());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userAdminTag});
                String newUserId = user.getString("id");
                if (virtualAdminIDs.contains(Long.valueOf(sourceUserID)) && !sourceUserID.equals(newUserId)) {
                    String sql = "UPDATE T_SEC_USER SET FENABLE = '0' WHERE FID = " + sourceUserID;
                    DB.execute((DBRoute)DBRoute.base, (String)sql);
                }
                DynamicObject adminObj = BusinessDataServiceHelper.loadSingle((String)ENTITY_ADMIN, (String)PROP_USER, (QFilter[])new QFilter[]{new QFilter("admintype", "=", (Object)Long.valueOf(adminTags.get(number))), new QFilter("type", "=", (Object)"10")});
                adminObj.set(PROP_USER, pkValue);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adminObj});
                if (!PermissionServiceHelper.hasEnableOldAdmin() && !sourceUserID.equals(newUserId)) {
                    long userId = -1L;
                    DynamicObject curEnableScheme = this.checkAdminSchemeAndType(sourceUserID, newUserId);
                    Long schemeId = curEnableScheme.getLong("id");
                    DynamicObject adminGroup = BusinessDataServiceHelper.loadSingle((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("adminscheme", "=", (Object)schemeId), new QFilter("admintype", "=", (Object)Long.parseLong(adminTags.get(number))), new QFilter("level", "=", (Object)1)});
                    Long adminGroupId = adminGroup.getLong("id");
                    if (StringUtils.isNotEmpty((String)sourceUserID)) {
                        userId = Long.parseLong(sourceUserID);
                    }
                    if (!virtualAdminIDs.contains(userId)) {
                        DeleteServiceHelper.delete((String)PERM_USERADMINGROUP, (QFilter[])new QFilter[]{new QFilter(PROP_USER, "=", (Object)userId), new QFilter("usergroup", "=", (Object)adminGroupId)});
                    }
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)PERM_USERADMINGROUP);
                    DynamicObject userAdminGroup = new DynamicObject((DynamicObjectType)dataEntityType);
                    userAdminGroup.set(PROP_USER, pkValue);
                    userAdminGroup.set("usergroup", (Object)adminGroupId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userAdminGroup});
                }
                if (!sourceUserID.equals(newUserId)) {
                    String date = DateUtils.getDate();
                    String logOutDesc = ConstantsHelper.getAdminTransferLogOutDesc((String)date);
                    SessionComServiceImpl service = new SessionComServiceImpl();
                    service.removeSessionByUserId((List)Lists.newArrayList((Object[])new String[]{sourceUserID}), logOutDesc, false);
                }
                OperationServiceHelper.executeOperate((String)OPERATE_SAVE, (String)"perm_admintype", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, null);
            }
            catch (Exception exc) {
                tx.markRollback();
                logger.warn("\u4fdd\u5b58\u7528\u6237\u7ba1\u7406\u5458\u6620\u5c04\u5173\u7cfb\u5931\u8d25", (Throwable)exc);
                view.showErrorNotification(exc.getMessage());
                if (tx != null) {
                    if (var11_11 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
        }
        PermissionServiceHelper.clearAllCache();
        dataModel.setDataChanged(false);
        view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserAdminTagEditPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
        BillList billList = (BillList)view.getParentView().getControl("billlistap");
        billList.refresh();
        view.sendFormAction(view.getParentView());
        view.close();
    }

    private void checkPhoneEmail(Object pkValue, String propPhone, String propEmail) throws Exception {
        QFilter emailFilter;
        QFilter[] filters;
        DynamicObject dyn;
        PhoneI18nValidator phoneNewValidator;
        String err;
        if (StringUtils.isEmpty((String)propPhone) && StringUtils.isEmpty((String)propEmail)) {
            throw new Exception(ResManager.loadKDString((String)"\u201c\u624b\u673a\u201d\u548c\u201c\u90ae\u7bb1\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u9879\u3002", (String)"UserAdminTagEditPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)propPhone) && StringUtils.isNotEmpty((String)(err = (phoneNewValidator = new PhoneI18nValidator(propPhone, true)).getErrorMsg()))) {
            throw new Exception(err);
        }
        QFilter userNotEqualsFilter = new QFilter("id", "!=", pkValue);
        if (StringUtils.isNotEmpty((String)propEmail) && null != (dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id", (QFilter[])(filters = new QFilter[]{userNotEqualsFilter, emailFilter = new QFilter(PROP_EMAIL, "=", (Object)propEmail)})))) {
            throw new Exception(ResManager.loadKDString((String)"\u201c\u90ae\u7bb1\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"UserAdminTagEditPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (!virtualAdminIDs.contains(pkValue)) {
            return;
        }
        String oriphone = this.getPageCache().get("oriphone");
        String oriemail = this.getPageCache().get("oriemail");
        HashMap<String, String> phoneDataMap = new HashMap<String, String>(2);
        HashMap<String, String> emailDataMap = new HashMap<String, String>(2);
        if (!propPhone.equals(oriphone)) {
            phoneDataMap.put(PROP_PHONE, propPhone);
        }
        if (!propEmail.equals(oriemail)) {
            emailDataMap.put(PROP_EMAIL, propEmail);
        }
        if (CollectionUtils.isEmpty(phoneDataMap) && CollectionUtils.isEmpty(emailDataMap)) {
            return;
        }
        try {
            if (!CollectionUtils.isEmpty(phoneDataMap)) {
                DB.execute((DBRoute)DBRoute.basedata, (String)"update t_sec_user set fphone = ? where fid = ?", (Object[])new Object[]{propPhone, pkValue});
            }
            if (!CollectionUtils.isEmpty(emailDataMap)) {
                UserParam user = new UserParam();
                ArrayList<UserParam> paramList = new ArrayList<UserParam>();
                user.setId(((Long)pkValue).longValue());
                user.setDataMap(emailDataMap);
                paramList.add(user);
                UserServiceHelper.update(paramList);
                if (!user.isSuccess()) {
                    throw new Exception(user.getMsg());
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if (PROP_USER.equals(propName)) {
            String sql = "";
            sql = !PermissionServiceHelper.hasEnableOldAdmin() ? "SELECT DISTINCT a.fuserid FROM t_perm_useradmingroup a INNER JOIN t_perm_admingroup p ON a.fadmingroupid  = p.fid INNER JOIN t_perm_adminscheme pa ON pa.fid = p.fadminscheme WHERE pa.fenable = '1' UNION SELECT FUSERID FROM T_PERM_USERADMINTAG" : "SELECT FUSERID FROM T_PERM_ADMIN UNION SELECT FUSERID FROM T_PERM_USERADMINTAG ";
            List adminUserIDs = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

                public List<Long> handle(ResultSet rs) throws SQLException {
                    ArrayList<Long> users = new ArrayList<Long>(rs.getRow());
                    try {
                        while (rs.next()) {
                            Long userID = rs.getLong("FUSERID");
                            users.add(userID);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return users;
                }
            });
            QFilter userFilter = new QFilter("id", "not in", (Object)adminUserIDs).and("usertype", "=", (Object)"1");
            evt.getCustomQFilters().add(userFilter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        if (CONFIRMCALLBACK_ISCONTINUE.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxResult)) {
            this.saveUserAdminTag();
        }
    }

    public boolean isAllowAdminBizOperate() {
        boolean result = false;
        DynamicObject enableScheme = BusinessDataServiceHelper.loadSingle((String)ENTITY_ADMINSCHEME, (String)PROP_ISALLOWBIZOPERATE, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (enableScheme != null) {
            result = enableScheme.getBoolean(PROP_ISALLOWBIZOPERATE);
        }
        return result;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.preOpenPermForm(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermCommonUtil.isCosmicUser((Long)userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662fcosmic\uff0c\u4e0d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd", (String)"UserAdminTagEditPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
    }

    static {
        adminTags.put("administrator", "1");
        adminTags.put("auditor", "2");
        adminTags.put("security", "3");
        virtualAdminIDs.add(1L);
        virtualAdminIDs.add(2L);
        virtualAdminIDs.add(3L);
        virtualAdminIDs.add(10L);
    }
}

