/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.BizRoleService;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.model.BizRoleUg;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class UsrGrpAssignBizRolePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(UsrGrpAssignBizRolePlugin.class);
    public static final String TOOLBARMAIN = "maintoolbar";
    public static final String BIZROLETOOLBAR = "bizroletoolbar";
    public static final String BIZROLE_ENTRY = "bizrole_entry";
    public static final String ADD_BIZROLE = "add_bizrole";
    public static final String BIZROLE = "bizrole";
    private static final String CLSCALLBCKID_ADDBIZROLE = "CloseCallBackId_addBizRole";
    public static final String BARITEM_SAVE = "baritem_save";
    private static final String UG_PAGE_KEY_CHANGE_BUSIROLES = "ug_page_key_change_busiroles";
    private static final String OP_DELETEENTRY = "deleteentry";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IFormView currentView = this.getView();
        this.addItemClickListeners(new String[]{TOOLBARMAIN});
        Toolbar bizroletoolbar = (Toolbar)this.getControl(BIZROLETOOLBAR);
        bizroletoolbar.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if (UsrGrpAssignBizRolePlugin.ADD_BIZROLE.equals(itemKey)) {
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_busirole", (boolean)true);
                    lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)UsrGrpAssignBizRolePlugin.this, UsrGrpAssignBizRolePlugin.CLSCALLBCKID_ADDBIZROLE));
                    UsrGrpAssignBizRolePlugin.this.remainBizRoleId(lsp);
                    currentView.showForm((FormShowParameter)lsp);
                }
            }
        });
        BasedataEdit bde = (BasedataEdit)this.getControl(BIZROLE);
        bde.addBeforeF7SelectListener(e1 -> {
            ListShowParameter lsp = (ListShowParameter)e1.getFormShowParameter();
            this.remainBizRoleId(lsp);
        });
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long usrGrpId = (Long)fsp.getCustomParam("usrgrpid");
        this.getModel().setValue("usrgrp", (Object)usrGrpId);
        DynamicObjectCollection bizroleObjs = QueryServiceHelper.query((String)"perm_usrgrpbusirole", (String)BIZROLE, (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)usrGrpId)});
        ArrayList<Long> bizRoleList = new ArrayList<Long>(bizroleObjs.size());
        for (DynamicObject bizroleObj : bizroleObjs) {
            bizRoleList.add(bizroleObj.getLong(BIZROLE));
        }
        this.fillBizRoleList(bizRoleList);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BARITEM_SAVE.equals(itemKey)) {
            this.save();
        }
    }

    private void save() {
        IFormView view = this.getView();
        try {
            DynamicObject usrGrp = (DynamicObject)this.getModel().getValue("usrgrp");
            Long usrGrpId = (Long)usrGrp.getPkValue();
            Set<Long> mayChangedBusiRoleIdSet = this.getMayChangedBusiRoleSet();
            if (CollectionUtils.isEmpty(mayChangedBusiRoleIdSet)) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UsrGrpAssignBizRolePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            Set pre = PermBusiRoleHelper.getBizRoleUgSet(null, (Long)usrGrpId);
            this.save2DB(usrGrpId, mayChangedBusiRoleIdSet);
            Set after = PermBusiRoleHelper.getBizRoleUgSet(null, (Long)usrGrpId);
            LinkedList preList = new LinkedList(pre);
            LinkedList afterList = new LinkedList(after);
            List delList = ListUtil.removeAll(preList, afterList);
            List addList = ListUtil.removeAll(afterList, preList);
            String uGName = usrGrp.getString("name");
            String uGNumber = usrGrp.getString("number");
            if (!(!PermCommonUtil.isEnablePermLog() || CollectionUtils.isEmpty((Collection)delList) && CollectionUtils.isEmpty((Collection)addList))) {
                String opbtn = ConstantsHelper.getSave();
                HashMap<String, Object> logMap = new HashMap<String, Object>(2);
                logMap.put("del", delList);
                logMap.put("add", addList);
                logMap.put("langStr", RequestContext.get().getLang().name());
                this.ugAssignBusiRole2PermLog(BARITEM_SAVE, opbtn, usrGrpId, uGNumber, uGName, StrUtil.compress((String)new ObjectMapper().writeValueAsString(logMap)));
            }
            this.addUserLicGroup(usrGrpId, addList);
            this.clearChangeBusiRoleSet();
            PermissionServiceHelper.clearAllCache();
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UsrGrpAssignBizRolePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            String appId = AppHelper.getCurAppId((String)"perm_usrgrpassignbizrole", (String)this.getView().getFormShowParameter().getAppId());
            MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u7528\u6237\u7ec4\u5206\u914d\u4e1a\u52a1\u89d2\u8272", "UsrGrpAssignBizRolePlugin_2", SYSTEM_TYPE);
            MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u7528\u6237\u7ec4\uff1a%1$s (id = %2$s, number = %3$s) \u5206\u914d\u4e1a\u52a1\u89d2\u8272\u6210\u529f", "UsrGrpAssignBizRolePlugin_3", SYSTEM_TYPE);
            String[] opDescParam = new String[]{uGName, String.valueOf(usrGrpId), uGNumber};
            String oldOpDescription = String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\uff1a%1$s (id = %2$s, number = %3$s) \u5206\u914d\u4e1a\u52a1\u89d2\u8272\u6210\u529f", (String)"UsrGrpAssignBizRolePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), uGName, usrGrpId, uGNumber);
            String opNameZh_CN = new MultiLangEnumBridge("\u7528\u6237\u7ec4\u5206\u914d\u4e1a\u52a1\u89d2\u8272", "UsrGrpAssignBizRolePlugin_2", SYSTEM_TYPE).getDescription();
            PermCommonUtil.addLog((String)"", (String)opNameZh_CN, (String)"perm_usrgrpassignbizrole", (String)uGNumber, (String)"1", (String)BARITEM_SAVE, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)appId);
        }
        catch (Exception e) {
            logger.warn("UsrGrpAssignBizRolePlugin error.", (Throwable)e);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"UsrGrpAssignBizRolePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void addUserLicGroup(Long usrGrpId, List<BizRoleUg> addList) {
        if (null == usrGrpId || Objects.equals(0L, usrGrpId) || null == addList || addList.isEmpty()) {
            return;
        }
        HashSet lisenceUserIds = new HashSet(16);
        lisenceUserIds.addAll(UserGroupService.getUsersIdByUsrGrpId((Long)usrGrpId));
        if (null == lisenceUserIds || lisenceUserIds.isEmpty()) {
            return;
        }
        HashSet commonRoleIds = new HashSet(16);
        HashMap allowAppEntityMap = new HashMap(16);
        for (BizRoleUg one : addList) {
            Long bizRoleId;
            if (null == one || null == (bizRoleId = one.getBusiRoleId()) || Objects.equals(0L, bizRoleId)) continue;
            DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole");
            DynamicObjectCollection bizRoleCommRoleDoc = bizRoleObj.getDynamicObjectCollection("bizrolecomrole");
            bizRoleCommRoleDoc.stream().forEach(bizRoleCommRole -> commonRoleIds.add(bizRoleCommRole.getDynamicObject("role").getString("id")));
            List bizRolePermList = BizRoleService.getBizRolePermByBizRoleId((Long)bizRoleId);
            bizRolePermList.stream().forEach(bizRolePerm -> {
                List entityTypeIdlist = allowAppEntityMap.computeIfAbsent(bizRolePerm.getBizappid(), k -> new ArrayList(16));
                if (!entityTypeIdlist.contains(bizRolePerm.getEntitytypeid())) {
                    entityTypeIdlist.add(bizRolePerm.getEntitytypeid());
                }
            });
        }
        ArrayList commonRoleIdList = new ArrayList();
        commonRoleIdList.addAll(commonRoleIds);
        if (!commonRoleIdList.isEmpty()) {
            StringBuilder roleFunSB = new StringBuilder("select distinct rpd.fbizappid,rpd.fentitytypeid ");
            roleFunSB.append(" from t_perm_rolepermdetial rpd ");
            String commonRoleIdStr = "'" + String.join((CharSequence)"','", commonRoleIdList) + "'";
            roleFunSB.append(" where rpd.froleid in(").append(commonRoleIdStr).append(")");
            DB.query((DBRoute)DBRoute.permission, (String)roleFunSB.toString(), rs -> {
                while (rs.next()) {
                    String appid = rs.getString("fbizappid");
                    String entityTypeID = rs.getString("fentitytypeid");
                    List entityTypeIdlist = allowAppEntityMap.computeIfAbsent(appid, k -> new ArrayList(16));
                    if (entityTypeIdlist.contains(entityTypeID)) continue;
                    entityTypeIdlist.add(entityTypeID);
                }
                return null;
            });
        }
        if (null == allowAppEntityMap || allowAppEntityMap.isEmpty()) {
            return;
        }
        LicenseServiceHelper.addUsersLicGroupByBizAppAndBizObj(new ArrayList(lisenceUserIds), allowAppEntityMap);
    }

    private void ugAssignBusiRole2PermLog(String op, String opbtn, Long opItemId, String opItemNumber, String opItemName, String diffContent) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"usergroup_assignbusirole");
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.BizRoleAssignUserPlugin.busiRoleAssignUser2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("diff_content", diffContent);
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("UsrGrpAssignBizRolePlugin.ugAssignBusiRole2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject usrGrp = (DynamicObject)this.getModel().getValue("usrgrp");
        if (usrGrp == null) {
            return;
        }
        Long usrGrpId = usrGrp.getLong("id");
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            MutexHelper.release((String)"bos_usrgrp", (String)"assignbizrole", (String)String.valueOf(usrGrpId));
        }
    }

    private void save2DB(Long usrGrpId, Set<Long> mayChangedBusiRoleIdSet) throws Exception {
        try (TXHandle h = TX.required();){
            try {
                if (!CollectionUtils.isEmpty(mayChangedBusiRoleIdSet)) {
                    Set mayChangedBusiRoleIdSetStr = mayChangedBusiRoleIdSet.stream().map(String::valueOf).collect(Collectors.toSet());
                    String mayChangedBusiRoleIdStr = String.join((CharSequence)",", mayChangedBusiRoleIdSetStr);
                    DB.execute((DBRoute)DBRoute.basedata, (String)("delete from t_perm_usrgrpbizrole where fusrgrpid=? and fbizroleid in (" + mayChangedBusiRoleIdStr + ")"), (Object[])new Object[]{usrGrpId});
                }
                EntryGrid bizRoles = (EntryGrid)this.getControl(BIZROLE_ENTRY);
                DynamicObject[] dataEntitys = bizRoles.getEntryData().getDataEntitys();
                LinkedList<DynamicObject> saveList = new LinkedList<DynamicObject>();
                for (int i = 0; i < dataEntitys.length; ++i) {
                    Long bizRoleId = (Long)dataEntitys[i].get("bizrole_id");
                    if (!mayChangedBusiRoleIdSet.contains(bizRoleId)) continue;
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"perm_usrgrpbusirole");
                    dynamicObject.set("usergroup", (Object)usrGrpId);
                    dynamicObject.set(BIZROLE, (Object)bizRoleId);
                    dynamicObject.set("createrfield", (Object)RequestContext.get().getCurrUserId());
                    dynamicObject.set("createdatefield", (Object)new Date());
                    saveList.add(dynamicObject);
                }
                if (!CollectionUtils.isEmpty(saveList)) {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                logger.warn("UsrGrpAssignBizRolePlugin.save2DB error...", (Throwable)e);
                h.markRollback();
                throw new Exception(e);
            }
        }
    }

    private void remainBizRoleId(ListShowParameter lsp) {
        ArrayList<Long> bizRoleList = new ArrayList<Long>(50);
        int rowCount = this.getModel().getEntryRowCount(BIZROLE_ENTRY);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject bizRoleObj = (DynamicObject)this.getModel().getValue(BIZROLE, i);
            if (bizRoleObj == null) continue;
            Long bizRoleId = bizRoleObj.getLong("id");
            bizRoleList.add(bizRoleId);
        }
        QFilter bizrolef7QFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        lsp.getListFilterParameter().getQFilters().add(bizrolef7QFilter);
        lsp.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", bizRoleList));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLSCALLBCKID_ADDBIZROLE.equals(actionId) && e.getReturnData() instanceof ListSelectedRowCollection) {
            ArrayList<Long> selectedRowIds = new ArrayList<Long>(10);
            ListSelectedRowCollection selectRows = (ListSelectedRowCollection)e.getReturnData();
            if (!CollectionUtils.isEmpty((Collection)selectRows)) {
                HashSet<Long> busiRoleIdSet = new HashSet<Long>(selectRows.size());
                for (ListSelectedRow row : selectRows) {
                    Long bizRoleID = (Long)row.getPrimaryKeyValue();
                    selectedRowIds.add(bizRoleID);
                    busiRoleIdSet.add(bizRoleID);
                }
                this.signMayChangedBusiRoleSet(busiRoleIdSet);
                this.fillBizRoleList(selectedRowIds);
            }
        }
    }

    private void fillBizRoleList(List<Long> bizRoleList) {
        if (bizRoleList == null || bizRoleList.isEmpty()) {
            return;
        }
        for (int i = 0; i < bizRoleList.size(); ++i) {
            int newEntryRow = this.getModel().createNewEntryRow(BIZROLE_ENTRY);
            this.getModel().setEntryCurrentRowIndex(BIZROLE_ENTRY, newEntryRow);
            this.getModel().setValue(BIZROLE, (Object)bizRoleList.get(i), newEntryRow);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof FormOperate && (opKey = ((FormOperate)e.getSource()).getOperateKey()).equals(OP_DELETEENTRY)) {
            Set<Long> seltedBusiRoleIds = this.getSeltedBusiRoleIds();
            ((FormOperate)e.getSource()).getOption().setVariableValue("seltedBusiRoleIds", SerializationUtils.toJsonString(seltedBusiRoleIds));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String seltedBusiRoleIds;
        Object source;
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (opKey.equals(OP_DELETEENTRY) && (source = e.getSource()) instanceof FormOperate && StringUtils.isNotEmpty((String)(seltedBusiRoleIds = ((FormOperate)source).getOption().getVariableValue("seltedBusiRoleIds")))) {
            List seltedBusiRoleIdList = (List)SerializationUtils.fromJsonString((String)seltedBusiRoleIds, List.class);
            this.signMayChangedBusiRoleSet(new HashSet<Long>(seltedBusiRoleIdList));
        }
    }

    private Set<Long> getSeltedBusiRoleIds() {
        EntryGrid sourceEntity = (EntryGrid)this.getControl(BIZROLE_ENTRY);
        int[] selectRows = sourceEntity.getSelectRows();
        if (null == selectRows || selectRows.length < 1) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> resultSet = new HashSet<Long>(selectRows.length);
        DynamicObject[] dataEntitys = sourceEntity.getEntryData().getDataEntitys();
        if (null != dataEntitys && dataEntitys.length > 0) {
            for (int idx : selectRows) {
                resultSet.add(dataEntitys[idx].getLong("bizrole_id"));
            }
        }
        return resultSet;
    }

    private void signMayChangedBusiRoleSet(Set<Long> idSet) {
        if (CollectionUtils.isEmpty(idSet)) {
            return;
        }
        String changedStr = this.getPageCache().get(UG_PAGE_KEY_CHANGE_BUSIROLES);
        if (StringUtils.isEmpty((String)changedStr)) {
            String idSetStr = idSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.getPageCache().put(UG_PAGE_KEY_CHANGE_BUSIROLES, idSetStr);
        } else {
            Set changedSet = Arrays.asList(changedStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
            changedSet.addAll(idSet);
            String afterChangedSetStr = changedSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            this.getPageCache().put(UG_PAGE_KEY_CHANGE_BUSIROLES, afterChangedSetStr);
        }
    }

    private Set<Long> getMayChangedBusiRoleSet() {
        String changedSetStr = this.getPageCache().get(UG_PAGE_KEY_CHANGE_BUSIROLES);
        if (StringUtils.isEmpty((String)changedSetStr)) {
            return new HashSet<Long>(1);
        }
        return Arrays.asList(changedSetStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
    }

    private void clearChangeBusiRoleSet() {
        this.getPageCache().remove(UG_PAGE_KEY_CHANGE_BUSIROLES);
    }
}

