/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.AssignModEnum;
import kd.bos.permission.enums.GrpUsrFromTypeEnum;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.UserGroupAssignUserReq;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class UsrGrpAssignUserPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(UsrGrpAssignUserPlugin.class);
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        UserScopeResult adminChargeUser;
        long currUserId;
        this.getModel().deleteEntryData("entryentity");
        String usrGrpId = (String)this.getView().getFormShowParameter().getCustomParam("usrgrpid");
        if (usrGrpId.equals(ID_ROOTNODE) || StringUtils.isEmpty((String)usrGrpId)) {
            return;
        }
        Set userIds = UserGroupService.getUsersIdByUsrGrpId((Long)Long.valueOf(usrGrpId), null);
        if (PermCommonUtil.isEnableJustShowAdminCharged() && AdminUserCache.isAdminUser((String)((currUserId = RequestContext.get().getCurrUserId()) + "")) && !(adminChargeUser = new PermissionServiceImpl().getAdminChargeUser(Long.valueOf(currUserId), false)).isAllUser()) {
            List chargeUserList = adminChargeUser.getUserIDs();
            userIds.removeIf(k -> !chargeUserList.contains(k));
        }
        Map userPositionMap = UserHelper.getUPIFullJobMapByIds((Set)userIds, (String)RequestContext.get().getLang().name());
        IDataModel dataModel = this.getModel();
        dataModel.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("user", new Object[0]);
        vs.addField("department", new Object[0]);
        vs.addField("job", new Object[0]);
        for (Long userId : userIds) {
            User userPositionInfo = (User)userPositionMap.get(userId);
            if (null == userPositionInfo) {
                vs.addRow(new Object[]{userId, null, null});
                continue;
            }
            vs.addRow(new Object[]{userId, userPositionInfo.getDpId(), userPositionInfo.getPosition()});
        }
        ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("entryentity", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IFormView currentView = this.getView();
        Toolbar tb = (Toolbar)this.getControl("usertoolbar");
        tb.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if ("user_add".equals(itemKey)) {
                    String showFormSpecial;
                    HashSet<Long> userSet = new HashSet(8);
                    DynamicObjectCollection userRows = UsrGrpAssignUserPlugin.this.getModel().getEntryEntity("entryentity");
                    if (null != userRows && !userRows.isEmpty()) {
                        userSet = userRows.parallelStream().map(x -> x.getDynamicObject("user").getLong("id")).collect(Collectors.toSet());
                    }
                    boolean isOrgBaseAdmin = Boolean.TRUE;
                    IFormView parentView = UsrGrpAssignUserPlugin.this.getView().getParentView();
                    if (parentView != null && StringUtils.isNotEmpty((String)(showFormSpecial = (String)parentView.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser"))) && "true".equals(showFormSpecial)) {
                        isOrgBaseAdmin = Boolean.FALSE;
                    }
                    ListShowParameter lsp = PermFormCommonUtil.getUserF7ListShowParameter(UsrGrpAssignUserPlugin.this.getPageCache(), userSet, isOrgBaseAdmin, null);
                    lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)UsrGrpAssignUserPlugin.this, "userAdd"));
                    currentView.showForm((FormShowParameter)lsp);
                }
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.isNotEmpty((String)actionId) && actionId.equals("userAdd") && (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            IDataModel dataModel = this.getModel();
            dataModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("user", new Object[0]);
            vs.addField("department", new Object[0]);
            vs.addField("job", new Object[0]);
            Set collect = returnData.parallelStream().map(x -> (Long)x.getPrimaryKeyValue()).collect(Collectors.toSet());
            Map userPositionMap = UserHelper.getUPIFullJobMapByIds(collect, (String)RequestContext.get().getLang().name());
            for (Long userId : collect) {
                User userPositionInfo = (User)userPositionMap.get(userId);
                if (null == userPositionInfo) {
                    vs.addRow(new Object[]{userId, null, null});
                    continue;
                }
                vs.addRow(new Object[]{userId, userPositionInfo.getDpId(), userPositionInfo.getPosition()});
            }
            ((AbstractFormDataModel)dataModel).batchCreateNewEntryRow("entryentity", vs);
            dataModel.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && (key = (btn = (Button)source).getKey()).equals("btnok")) {
            this.save();
            this.getView().close();
        }
    }

    public void save() {
        List adminChargeUserIds;
        UserScopeResult adminChargeUser;
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection userRows = dataModel.getEntryEntity("entryentity");
        Set userSet = userRows.parallelStream().map(x -> x.getDynamicObject("user").getLong("id")).collect(Collectors.toSet());
        String usrGrpId = (String)view.getFormShowParameter().getCustomParam("usrgrpid");
        Long usrGrpIdLong = Long.valueOf(usrGrpId);
        String usrGrpNumber = (String)view.getFormShowParameter().getCustomParam("usrgrpnumber");
        String usrGrpName = (String)view.getFormShowParameter().getCustomParam("usrgrpname");
        String formIdentity = (String)view.getFormShowParameter().getCustomParam("formIdentity");
        String busiType = (String)view.getFormShowParameter().getCustomParam("permLogBusiType");
        Set preUserIds = UserGroupService.getUsersIdByUsrGrpId((Long)usrGrpIdLong, null);
        long currUserId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isAdminUser((long)currUserId) && !(adminChargeUser = PermissionServiceHelper.getAdminChargeUser((Long)currUserId, (boolean)true)).isAllUser() && !(adminChargeUserIds = adminChargeUser.getUserIDs()).isEmpty()) {
            preUserIds = Sets.intersection((Set)preUserIds, new HashSet(adminChargeUserIds));
        }
        try {
            List addUList;
            HashMap cancelGAndUMap = new HashMap(8);
            HashMap increGAndUMap = new HashMap(8);
            List removeUList = ListUtil.removeAll(new LinkedList(preUserIds), new LinkedList(userSet));
            if (!CollectionUtils.isEmpty((Collection)removeUList)) {
                cancelGAndUMap.put(usrGrpIdLong, new HashSet(removeUList));
            }
            if (!CollectionUtils.isEmpty((Collection)(addUList = ListUtil.removeAll(new LinkedList(userSet), new LinkedList(preUserIds))))) {
                increGAndUMap.put(usrGrpIdLong, new HashSet(addUList));
            }
            if (!CollectionUtils.isEmpty(cancelGAndUMap) || !CollectionUtils.isEmpty(increGAndUMap)) {
                GrpUsrFromTypeEnum grpUsrFromTypeEnum = GrpUsrFromTypeEnum.HAND_ADD;
                String reason = "UsrGrpAssignUserPlugin.save, " + grpUsrFromTypeEnum.getDesc();
                PermLogReq permLogReq = this.getPermLogReq(usrGrpId, usrGrpNumber, usrGrpName, formIdentity, busiType);
                ArrayList<UserGroupAssignUserReq> reqList = new ArrayList<UserGroupAssignUserReq>(2);
                reqList.add(new UserGroupAssignUserReq(cancelGAndUMap, AssignModEnum.ASSIGNMODE_CANCEL, grpUsrFromTypeEnum, reason));
                reqList.add(new UserGroupAssignUserReq(increGAndUMap, AssignModEnum.ASSIGNMODE_INCREMENT, grpUsrFromTypeEnum, reason));
                UserGroupService.userGroupsAssignUserWithPermLog(reqList, (PermLogReq)permLogReq);
            }
            view.getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"UsrGrpAssignUserPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            view.sendFormAction(view.getParentView());
        }
        catch (Exception e) {
            logger.warn("kd.bos.permission.formplugin.UsrGrpAssignUserPlugin.save error", (Throwable)e);
            view.showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"UsrGrpAssignUserPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    private PermLogReq getPermLogReq(String usrGrpId, String usrGrpNumber, String usrGrpName, String formIdentity, String busiType) {
        PermLogReq permLogReq = new PermLogReq();
        boolean enablePermLog = PermCommonUtil.isEnablePermLog();
        if (!enablePermLog) {
            permLogReq.setSignPermLog(Boolean.FALSE);
            return permLogReq;
        }
        permLogReq.setSignPermLog(Boolean.TRUE);
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)busiType);
        permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
        permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
        String appId = AppHelper.getCurAppId((String)formIdentity, (String)this.getView().getFormShowParameter().getAppId());
        permLogReq.setAppId(appId);
        permLogReq.setFormIdentity(formIdentity);
        permLogReq.setOp("btnok");
        permLogReq.setOpbtn(ConstantsHelper.getSureDesc());
        permLogReq.setInterfaceMethod("kd.bos.permission.formplugin.UsrGrpAssignUserPlugin.save");
        permLogReq.setOpItemId(usrGrpId);
        permLogReq.setOpItemNumber(usrGrpNumber);
        permLogReq.setOpItemName(usrGrpName);
        permLogReq.setOperTime(TimeServiceHelper.now());
        permLogReq.setClientType(RequestContext.get().getClient());
        permLogReq.setClientIp(RequestContext.get().getLoginIP());
        return permLogReq;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate && "deleteentry".equals(operateKey = (operate = (FormOperate)source).getOperateKey())) {
            long currUserId = RequestContext.get().getCurrUserId();
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
            if (!adminUser || "true".equals(this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser"))) {
                return;
            }
            EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryEntity.getSelectRows();
            String opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"UsrGrpAssignUserPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            int[][] rows = new PermissionServiceImpl().checkAdminChargeUsersAndHint(this.getModel(), this.getView(), "entryentity", null, "user", selectRows, currUserId, opName);
            if (rows[1] != null) {
                if (selectRows.length != 1) {
                    entryEntity.clearEntryState();
                    if (rows[0] != null) {
                        entryEntity.selectRows(rows[0], rows[0][0]);
                    } else {
                        args.setCancel(true);
                    }
                } else {
                    args.setCancel(true);
                }
            }
        }
    }
}

