/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.oprule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.oprule.AbstractOperationRuleFromPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;

public abstract class AbstractOperationRuleAssignFromPlugin
extends AbstractOperationRuleFromPlugin {
    private Map<String, Integer> publicRuleEntities = null;

    public void registerListener(EventObject e) {
        EntryGrid operationRuleList = (EntryGrid)this.getControl("operationruleobj_list");
        operationRuleList.addHyperClickListener(evt -> {
            int rowIndex = evt.getRowIndex();
            String fieldName = evt.getFieldName();
            if (fieldName.equals("name")) {
                if (rowIndex < 0) {
                    return;
                }
                String operationRuleId = (String)this.getModel().getValue("operationrule_id", rowIndex);
                String operationRuleObjId = (String)this.getModel().getValue("operationruleobj_id", rowIndex);
                Boolean isEnable = (Boolean)this.getModel().getValue("enable", rowIndex);
                Boolean ispublic = (Boolean)this.getModel().getValue("ispublic", rowIndex);
                Boolean ispreset = (Boolean)this.getModel().getValue("ispreset", rowIndex);
                String focusNodeId = this.getPageCache().get("pageCache_FocusNodeId");
                this.showOperationRuleEditPage(operationRuleId, focusNodeId, ispublic.toString(), ispreset.toString(), operationRuleObjId, isEnable, false);
            } else if (fieldName.equals("director")) {
                this.showSpecifyDirector(rowIndex);
            } else if (fieldName.equals("exceptuser")) {
                this.showExceptUser(rowIndex);
            } else if (fieldName.equals("exceptrole")) {
                this.showExceptRole(rowIndex);
            } else if ("entities".equals(fieldName)) {
                this.showBatchEditPage(rowIndex);
            }
        });
    }

    protected void loadOpRuleObjData(Map<String, Map<String, Object>> ruleObjMap, Set<String> ruleIdSet, Set<String> ruleObjIdSet, boolean isPublicNode) {
        this.getModel().deleteEntryData("operationruleobj_list");
        if (CollectionUtils.isEmpty(ruleObjMap)) {
            return;
        }
        Map<String, Boolean> myDeptMap = this.getRuleIdInfoMap(ruleIdSet);
        Map<String, Integer> directorMap = this.getDirectorMap(ruleObjIdSet);
        Map<String, Integer> exceptUserMap = this.getExceptUserMap(ruleObjIdSet);
        Map<String, Integer> oprexusrGrpMap = this.getExceptUserGroupMap(ruleObjIdSet);
        Map<String, Integer> oprexRoleMap = this.getExceptRoleMap(ruleObjIdSet);
        this.getModel().beginInit();
        int index = 0;
        int[] rows = this.getModel().batchCreateNewEntryRow("operationruleobj_list", ruleObjMap.size());
        for (Map.Entry<String, Map<String, Object>> entry : ruleObjMap.entrySet()) {
            int row = rows[index++];
            Map<String, Object> rowMap = entry.getValue();
            String ruleObjId = (String)rowMap.get("operationruleobj_id");
            this.getModel().setValue("operationruleobj_id", (Object)ruleObjId, row);
            String operationRuleId = (String)rowMap.get("operationrule_id");
            this.getModel().setValue("operationrule_id", (Object)operationRuleId, row);
            this.getModel().setValue("operation_key", rowMap.get("operation_key"), row);
            this.getModel().setValue("ispublic", rowMap.get("ispublic"), row);
            this.getModel().setValue("ispreset", rowMap.get("ispreset"), row);
            this.getModel().setValue("enable", rowMap.get("enable"), row);
            if (myDeptMap.getOrDefault(operationRuleId, false).booleanValue()) {
                this.getModel().setValue("director", (Object)this.getLinkLabel(directorMap.get(ruleObjId)), row);
            } else {
                this.getModel().setValue("director", (Object)"", row);
            }
            this.getModel().setValue("exceptuser", (Object)this.getUserLinkLabel(exceptUserMap.get(ruleObjId), oprexusrGrpMap.get(ruleObjId)), row);
            this.getModel().setValue("exceptrole", (Object)this.getLinkLabel(oprexRoleMap.get(ruleObjId)), row);
            this.setOtherEntryColumn(row, rowMap, isPublicNode);
        }
        this.getModel().endInit();
        this.getView().updateView("operationruleobj_list");
    }

    protected void setOtherEntryColumn(int row, Map<String, Object> rowMap, boolean isPublicNode) {
    }

    protected List<DynamicObject> saveOperationRuleObj(String opRuleId, String opObjId, Map<String, List<String>> entityAppMap, Boolean enable) {
        QFilter filter;
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(entityAppMap.size());
        if (entityAppMap.isEmpty()) {
            return objList;
        }
        HashSet<String> allAppIds = new HashSet<String>(entityAppMap.size());
        DynamicObject[] entityObjectArr = BusinessDataServiceHelper.load((Object[])entityAppMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_objecttype"));
        HashMap<Object, DynamicObject> entityObjectMap = new HashMap<Object, DynamicObject>(8);
        if (null != entityObjectArr && entityObjectArr.length > 0) {
            for (DynamicObject dyn : entityObjectArr) {
                entityObjectMap.put(dyn.get("number"), dyn);
            }
        }
        HashMap<String, List<String>> tempEntityAppMap = new HashMap<String, List<String>>(entityAppMap.size());
        int count = this.copyEntityAppMap(entityAppMap, tempEntityAppMap, allAppIds, entityObjectMap);
        Set entityNumbers = tempEntityAppMap.keySet();
        boolean batchSave = StringUtils.isEmpty((String)opObjId);
        if (batchSave) {
            filter = new QFilter("operationrule", "=", (Object)opRuleId);
            filter = filter.and(new QFilter("entitytype", "in", entityNumbers));
        } else {
            filter = new QFilter("id", "=", (Object)opObjId);
        }
        QFilter[] filters = new QFilter[]{filter};
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)"perm_operationruleobj", (QFilter[])filters);
        for (Map.Entry entry : objMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            obj.set("objenabled", (Object)enable);
            objList.add(obj);
            String entity = obj.getString("entitytype_id");
            List appIds = (List)tempEntityAppMap.get(entity);
            if (appIds == null) {
                tempEntityAppMap.remove(entity);
                continue;
            }
            appIds.remove(obj.getString("bizapp_id"));
            if (!appIds.isEmpty()) continue;
            tempEntityAppMap.remove(entity);
        }
        if (enable.booleanValue()) {
            this.addNewOperationRuleObj(objList, opRuleId, count, tempEntityAppMap, entityObjectMap, allAppIds);
        }
        this.saveOperationRuleObj(opObjId, objList);
        return objList;
    }

    private void addNewOperationRuleObj(List<DynamicObject> objList, String opRuleId, int count, Map<String, List<String>> tempEntityAppMap, Map<Object, DynamicObject> entityObjectMap, Set<String> allAppIds) {
        if (tempEntityAppMap.isEmpty()) {
            return;
        }
        int index = 0;
        ORM orm = ORM.create();
        String[] ids = orm.genStringIds("perm_operationruleobj", count);
        DynamicObject ruleObj = BusinessDataServiceHelper.loadSingleFromCache((Object)opRuleId, (String)"perm_operationrule");
        DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)"perm_operationruleobj").getDynamicObjectType();
        Map appObjMap = null;
        for (Map.Entry<String, List<String>> entry : tempEntityAppMap.entrySet()) {
            List<String> appIds = entry.getValue();
            if (CollectionUtils.isEmpty(appIds)) continue;
            String entity = entry.getKey();
            DynamicObject entityTypeObj = entityObjectMap.get(entity);
            for (String appId : appIds) {
                String id = ids.length > index ? ids[index++] : orm.genStringId("perm_operationruleobj");
                DynamicObject opObj = new DynamicObject(dynamicObjectType, (Object)id);
                objList.add(opObj);
                opObj.set("id", (Object)id);
                opObj.set("operationrule", (Object)ruleObj);
                opObj.set("entitytype", (Object)entityTypeObj);
                opObj.set("objenabled", (Object)Boolean.TRUE);
                if (appObjMap == null) {
                    appObjMap = BusinessDataServiceHelper.loadFromCache((Object[])allAppIds.toArray(), (String)"bos_devportal_bizapp");
                }
                opObj.set("bizapp", appObjMap.get(appId));
            }
        }
    }

    private int copyEntityAppMap(Map<String, List<String>> entityAppMap, Map<String, List<String>> tempEntityAppMap, Set<String> allAppIds, Map<Object, DynamicObject> entityObjectMap) {
        int count = 0;
        for (Map.Entry<String, List<String>> entry : entityAppMap.entrySet()) {
            List<String> appIds = entry.getValue();
            appIds = appIds == null ? new ArrayList<String>() : new ArrayList<String>(appIds);
            if (appIds.isEmpty()) {
                DynamicObject entityObj = entityObjectMap.get(entry.getKey());
                String appId = "";
                if (entityObj != null) {
                    appId = entityObj.getString("bizappid_id");
                }
                appIds.add(appId);
            }
            allAppIds.addAll(appIds);
            count += appIds.size();
            tempEntityAppMap.put(entry.getKey(), appIds);
        }
        return count;
    }

    private void saveOperationRuleObj(String opObjId, List<DynamicObject> objList) {
        if (objList.isEmpty()) {
            objList.clear();
            return;
        }
        OperateOption operateOption = this.getOperateOption();
        operateOption.setVariableValue("appnumber", this.getView().getFormShowParameter().getAppId());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"perm_operationruleobj", (DynamicObject[])objList.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        if (operationResult == null) {
            objList.clear();
            return;
        }
        HashMap<Object, String> billNos = new HashMap<Object, String>(objList.size());
        Iterator<DynamicObject> iterator = objList.iterator();
        while (iterator.hasNext()) {
            DynamicObject obj = iterator.next();
            Object pkValue = obj.getPkValue();
            billNos.put(pkValue, obj.getString("entitytype_id"));
            if (operationResult.getSuccessPkIds().contains(pkValue)) continue;
            iterator.remove();
        }
        operationResult.setBillNos(billNos);
        if (opObjId == null || !operationResult.getAllErrorOrValidateInfo().isEmpty()) {
            operationResult.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractOperationRuleAssignFromPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.getView().showOperationResult(operationResult, ConstantsHelper.getSave());
        }
    }

    private OperateOption getOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(Boolean.TRUE));
        operateOption.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(Boolean.TRUE));
        return operateOption;
    }

    protected void showOperationRuleEditPage(String operationRuleId, String focusNodeId, String isPublic, String isPreset, String operationRuleObjId, Boolean isEnable, boolean isAdd) {
        DynamicObject dyn;
        if (focusNodeId == null || focusNodeId.trim().length() == 0) {
            return;
        }
        if (!isAdd && null == (dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)operationRuleId, (String)"perm_operationrule", (String)"id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AdminGroupTreeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("formId", "perm_operationrule_edit");
        FormShowParameter fsp = FormShowParameter.createFormShowParameter(param);
        String newPageId = operationRuleId + "-op-" + this.getView().getPageId();
        fsp.setPageId(newPageId);
        IFormView fv = this.getView().getView(newPageId);
        if (fv != null) {
            PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
            return;
        }
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "perm_operationrule_edit|" + focusNodeId));
        OpenStyle openStyle = fsp.getOpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        openStyle.setTargetKey("tabap");
        fsp.setCustomParam("paramOperationRuleId", (Object)operationRuleId);
        if (isAdd) {
            fsp.setStatus(OperationStatus.ADDNEW);
        } else {
            StringBuilder sbErrorInfo = new StringBuilder();
            boolean require = MutexHelper.require((String)"perm_operationrule", (Object)operationRuleId, (String)"modify", (StringBuilder)sbErrorInfo);
            if (!require) {
                this.getView().showMessage(sbErrorInfo.toString());
                fsp.setStatus(OperationStatus.VIEW);
            } else {
                fsp.setStatus(OperationStatus.EDIT);
            }
        }
        String nodeType = focusNodeId.substring(focusNodeId.lastIndexOf(35));
        fsp.setCustomParam("nodeType", (Object)nodeType);
        if (focusNodeId.endsWith("#entity")) {
            fsp.setCustomParam("paramBizObjectId", (Object)focusNodeId);
        }
        if (StringUtils.isNotEmpty((String)isPublic)) {
            fsp.setCustomParam("paramIspulic", (Object)isPublic);
            if ("1".equals(isPublic)) {
                fsp.setCustomParam("paramBizObjectId", null);
            }
        }
        if (StringUtils.isNotEmpty((String)isPreset)) {
            fsp.setCustomParam("paramIspreset", (Object)isPreset);
            if ("true".equals(isPreset)) {
                fsp.setStatus(OperationStatus.VIEW);
            }
        }
        if (isEnable != null) {
            fsp.setCustomParam("paramIsEnable", (Object)isEnable);
        }
        if (StringUtils.isNotEmpty((String)operationRuleObjId)) {
            fsp.setCustomParam("paramOpRuleObjId", (Object)operationRuleObjId);
        }
        this.getView().showForm(fsp);
    }

    private void showBatchEditPage(int pRowIndex) {
        this.showModalForm(pRowIndex, "perm_opruleassign_batch", false);
    }

    protected void showSpecifyDirector(int pRowIndex) {
        if (pRowIndex == -1) {
            return;
        }
        boolean isShowable = this.checkDirectorShowable(pRowIndex);
        if (!isShowable) {
            return;
        }
        this.showModalForm(pRowIndex, "perm_director_edit", true);
    }

    private void showModalForm(int rowIndex, String formId, boolean enableValidate) {
        if (rowIndex == -1) {
            return;
        }
        if (enableValidate && !this.enableValidate(rowIndex)) {
            return;
        }
        String operationRuleId = (String)this.getModel().getValue("operationrule_id", rowIndex);
        String operationRuleObjId = (String)this.getModel().getValue("operationruleobj_id", rowIndex);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        fsp.setCustomParam("operationrule_id", (Object)operationRuleId);
        fsp.setCustomParam("CustParam_OperationRuleObjId", (Object)operationRuleObjId);
        fsp.setCustomParam("rowIndex", (Object)rowIndex);
        this.getView().showForm(fsp);
    }

    private boolean enableValidate(int rowIndex) {
        Boolean isEnable = (Boolean)this.getModel().getValue("enable", rowIndex);
        if (!isEnable.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u5f53\u524d\u53c2\u6570\u3002", (String)"AbstractOperationRuleAssignFromPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void showExceptUser(int pRowIndex) {
        if (pRowIndex == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u89c4\u5219\u3002", (String)"AbstractOperationRuleAssignFromPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        this.showModalForm(pRowIndex, "perm_exceptuser_edit", true);
    }

    private boolean checkDirectorShowable(int pFocusRow) {
        String operationRuleId = (String)this.getModel().getValue("operationrule_id", pFocusRow);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"perm_operationrule", (String)"id, rule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)operationRuleId)}, null);
        if (doc != null && doc.size() >= 1) {
            DynamicObject dObj = (DynamicObject)doc.get(0);
            String rule = dObj.getString("rule");
            if (!this.ifMyDept(rule = PermCommonUtil.replaceBackSlach((String)rule))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53c2\u6570\u672a\u914d\u7f6e\u201c\u6211\u7684\u90e8\u95e8\u201d\u7b49\u76f8\u5173\u6761\u4ef6\uff0c\u4e0d\u80fd\u914d\u7f6e\u6307\u5b9a\u4e3b\u7ba1\u3002", (String)"AbstractOperationRuleAssignFromPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void showExceptRole(int pRowIndex) {
        this.showModalForm(pRowIndex, "perm_exceptrole_edit", true);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        Object returnDataObj = event.getReturnData();
        if (!(returnDataObj instanceof Map)) {
            return;
        }
        Map returnData = (Map)returnDataObj;
        String operationRuleId = (String)returnData.get("operationrule_id");
        HashSet<String> ruleIdSet = new HashSet<String>(1);
        ruleIdSet.add(operationRuleId);
        String ruleObjId = (String)returnData.get("CustParam_OperationRuleObjId");
        HashSet<String> ruleObjIdSet = new HashSet<String>(1);
        ruleObjIdSet.add(ruleObjId);
        int rowIndex = (Integer)returnData.get("rowIndex");
        switch (actionId = event.getActionId()) {
            case "perm_director_edit": {
                Map<String, Boolean> myDeptMap = this.getRuleIdInfoMap(ruleIdSet);
                if (myDeptMap.getOrDefault(operationRuleId, Boolean.FALSE).booleanValue()) {
                    Map<String, Integer> directorMap = this.getDirectorMap(ruleObjIdSet);
                    this.getModel().setValue("director", (Object)this.getLinkLabel(directorMap.get(ruleObjId)), rowIndex);
                    break;
                }
                this.getModel().setValue("director", (Object)"", rowIndex);
                break;
            }
            case "perm_exceptuser_edit": {
                Map<String, Integer> exceptUserMap = this.getExceptUserMap(ruleObjIdSet);
                Map<String, Integer> oprexusrGrpMap = this.getExceptUserGroupMap(ruleObjIdSet);
                this.getModel().setValue("exceptuser", (Object)this.getUserLinkLabel(exceptUserMap.get(ruleObjId), oprexusrGrpMap.get(ruleObjId)), rowIndex);
                break;
            }
            case "perm_exceptrole_edit": {
                Map<String, Integer> oprexRoleMap = this.getExceptRoleMap(ruleObjIdSet);
                this.getModel().setValue("exceptrole", (Object)this.getLinkLabel(oprexRoleMap.get(ruleObjId)), rowIndex);
                break;
            }
            case "perm_opruleassign_batch": {
                String ruleId = (String)returnData.get("operationrule_id");
                this.getModel().setValue("entities", (Object)this.getLinkLabel(this.getPublicRuleEntities(ruleId, true).get(ruleId)), rowIndex);
                break;
            }
        }
    }

    protected boolean ifMyDept(String rule) {
        return rule.contains("\"compareType\":\"106\"") || rule.contains("\"compareType\":\"109\"") || rule.contains("\"compareType\":106") || rule.contains("\"compareType\":109");
    }

    private Map<String, Boolean> getRuleIdInfoMap(Set<String> ruleIdSet) {
        if (ruleIdSet.isEmpty()) {
            return new HashMap<String, Boolean>(0);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ruleIdSet)};
        Map ruleObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_operationrule", (String)"id,rule", (QFilter[])filters);
        HashMap<String, Boolean> myDeptMap = new HashMap<String, Boolean>(ruleObjMap.size());
        ruleObjMap.entrySet().forEach(entry -> {
            String rule = ((DynamicObject)entry.getValue()).getString("rule");
            if (StringUtils.isNotEmpty((String)rule) && this.ifMyDept(rule = PermCommonUtil.replaceBackSlach((String)rule))) {
                myDeptMap.put(entry.getKey().toString(), Boolean.TRUE);
            }
        });
        return myDeptMap;
    }

    private Map<String, Integer> getDirectorMap(Set<String> ruleObjIdSet) {
        return this.getEveryObjIdNumMap("t_perm_director", "fdirectorid", ruleObjIdSet);
    }

    private Map<String, Integer> getExceptUserMap(Set<String> ruleObjIdSet) {
        return this.getEveryObjIdNumMap("t_perm_exceptuser", "*", ruleObjIdSet);
    }

    private Map<String, Integer> getExceptUserGroupMap(Set<String> ruleObjIdSet) {
        return this.getEveryObjIdNumMap("t_perm_oprexusrgrp", "*", ruleObjIdSet);
    }

    private Map<String, Integer> getExceptRoleMap(Set<String> ruleObjIdSet) {
        return this.getEveryObjIdNumMap("t_perm_oprexrole", "*", ruleObjIdSet);
    }

    protected Map<String, Integer> getPublicRuleEntities(String ruleId, boolean isPublic) {
        if (this.publicRuleEntities != null) {
            return this.publicRuleEntities;
        }
        if (!isPublic) {
            this.publicRuleEntities = new HashMap<String, Integer>(0);
        } else {
            String sql = "select ro.foperationruleid groupFieldName,count(ro.foperationruleid) num from t_perm_operationruleobj ro inner join t_perm_operationrule r on ro.foperationruleid = r.fid where r.fispublic = '1' and ro.fobjenabled = '1'";
            if (ruleId != null) {
                sql = sql + String.format(" and r.fid = '%s' ", ruleId);
            }
            sql = sql + " group by ro.foperationruleid";
            this.publicRuleEntities = this.getEveryObjIdNumMap(sql);
        }
        return this.publicRuleEntities;
    }

    private Map<String, Integer> getEveryObjIdNumMap(String tableName, String countName, Set<String> ruleObjIdSet) {
        if (ruleObjIdSet.isEmpty()) {
            return new HashMap<String, Integer>(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select count(").append(countName).append(") num ").append(", foperationruleobjid groupFieldName");
        sb.append(" from ").append(tableName);
        sb.append(" where 1=1 ");
        String ruleObjIdStrSet = String.join((CharSequence)"','", ruleObjIdSet);
        sb.append(" and foperationruleobjid in('").append(ruleObjIdStrSet).append("')");
        sb.append(" group by foperationruleobjid ");
        return this.getEveryObjIdNumMap(sb.toString());
    }

    private Map<String, Integer> getEveryObjIdNumMap(String sql) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        try (DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.basedata, (String)sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String foperationruleobjid = row.getString("groupFieldName");
                Integer num = row.getInteger("num");
                map.put(foperationruleobjid, num);
            }
        }
        return map;
    }

    protected String getLinkLabel(Integer count) {
        if (count == null || count <= 0) {
            return ResManager.loadKDString((String)"\u672a\u6dfb\u52a0", (String)"AbstractOperationRuleAssignFromPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0\uff08%1$s\uff09", (String)"AbstractOperationRuleAssignFromPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]), count);
    }

    protected String getUserLinkLabel(Integer userCount, Integer userGroupCount) {
        boolean isUserGroupEmpty;
        boolean isUserEmpty = userCount == null || userCount <= 0;
        boolean bl = isUserGroupEmpty = userGroupCount == null || userGroupCount <= 0;
        if (isUserEmpty) {
            if (isUserGroupEmpty) {
                return this.getLinkLabel(null);
            }
            return String.format(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\uff08%1$s\uff09", (String)"AbstractOperationRuleAssignFromPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]), userGroupCount);
        }
        if (isUserGroupEmpty) {
            return String.format(ResManager.loadKDString((String)"\u7528\u6237\uff08%1$s\uff09", (String)"AbstractOperationRuleAssignFromPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]), userCount);
        }
        return String.format(ResManager.loadKDString((String)"\u7528\u6237\uff08%1$s\uff09\u3001\u7528\u6237\u7ec4\uff08%2$s\uff09", (String)"AbstractOperationRuleAssignFromPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]), userCount, userGroupCount);
    }
}

