/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.oprule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.formplugin.oprule.AbstractOperationRuleAssignFromPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OperationRuleBatchAssignPlugin
extends AbstractOperationRuleAssignFromPlugin {
    private static final String BAR_ADD = "bar_add";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit entityObjectF7 = (BasedataEdit)this.getControl("entitytypes");
        entityObjectF7.addBeforeF7SelectListener(evt -> this.beforeEntityObjectF7Select((ListShowParameter)evt.getFormShowParameter()));
        entityObjectF7.addAfterF7SelectListener(evt -> this.saveOperationRuleObj(evt.getListSelectedRowCollection()));
    }

    public void itemClick(ItemClickEvent evt) {
        if (BAR_ADD.equals(evt.getItemKey())) {
            BasedataEdit entityObjectF7 = (BasedataEdit)this.getControl("entitytypes");
            entityObjectF7.click();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.loadOpRuleData();
    }

    private void loadOpRuleData() {
        String operationRuleId = (String)this.getView().getFormShowParameter().getCustomParam("operationrule_id");
        if (StringUtils.isEmpty((Object)operationRuleId)) {
            return;
        }
        DynamicObject ruleObj = BusinessDataServiceHelper.loadSingleFromCache((Object)operationRuleId, (String)"perm_operationrule");
        if (ruleObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u6216\u5173\u95ed\u9875\u9762\u3002", (String)"OperationRuleBatchAssignPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        ((Label)this.getControl("rulename")).setText(ruleObj.getString("name"));
        this.loadOpRuleObjData(operationRuleId);
    }

    private void loadOpRuleObjData(String operationRuleId) {
        this.getModel().deleteEntryData("operationruleobj_list");
        QFilter ruleFilter = new QFilter("operationrule", "=", (Object)operationRuleId);
        QFilter enableFilter = new QFilter("objenabled", "=", (Object)Boolean.TRUE);
        List adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)RequestContext.get().getCurrUserId());
        QFilter appFilter = new QFilter("bizapp", "in", (Object)adminChargeApps);
        QFilter[] filters = new QFilter[]{ruleFilter, enableFilter, appFilter};
        Map ruleObjMap = BusinessDataServiceHelper.loadFromCache((String)"perm_operationruleobj", (QFilter[])filters);
        TreeMap<String, Map<String, Object>> orderObjMap = new TreeMap<String, Map<String, Object>>();
        HashSet<String> ruleObjIdSet = new HashSet<String>(ruleObjMap.size());
        this.orderOpRuleData(operationRuleId, ruleObjMap, orderObjMap, ruleObjIdSet);
        if (ruleObjIdSet.isEmpty()) {
            return;
        }
        HashSet<String> ruleIdSet = new HashSet<String>(1);
        ruleIdSet.add(operationRuleId);
        this.loadOpRuleObjData(orderObjMap, ruleIdSet, ruleObjIdSet, true);
    }

    private void orderOpRuleData(String operationRuleId, Map<Object, DynamicObject> objMap, TreeMap<String, Map<String, Object>> orderObjMap, Set<String> ruleObjIdSet) {
        for (Map.Entry<Object, DynamicObject> entry : objMap.entrySet()) {
            String entity;
            String ruleObjId = entry.getKey().toString();
            DynamicObject ruleEntityObj = entry.getValue();
            DynamicObject entityObj = ruleEntityObj.getDynamicObject("entitytype");
            if (entityObj == null) {
                logger.error(ruleObjId + "\uff1a\u4e1a\u52a1\u5bf9\u8c61\uff08bos_objecttype\uff09\u4e0d\u5b58\u5728\u3002");
                continue;
            }
            String cloud = entity = entityObj.getString("name");
            String app = entity;
            DynamicObject appObj = ruleEntityObj.getDynamicObject("bizapp");
            DynamicObject cloudObj = null;
            if (appObj != null) {
                app = appObj.getString("name");
                cloudObj = appObj.getDynamicObject("bizcloud");
                if (cloudObj != null) {
                    cloud = cloudObj.getString("name");
                }
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("operationruleobj_id", ruleObjId);
            dataMap.put("operationrule_id", operationRuleId);
            dataMap.put("entitytype", entityObj);
            dataMap.put("bizapp", appObj);
            dataMap.put("bizcloud", cloudObj);
            dataMap.put("enable", Boolean.TRUE);
            ruleObjIdSet.add(ruleObjId);
            orderObjMap.put(this.getOrderKey(cloud, app, entity, ruleObjId), dataMap);
        }
    }

    @Override
    protected void setOtherEntryColumn(int row, Map<String, Object> rowMap, boolean isPublicNode) {
        this.getModel().setValue("entitytype", rowMap.get("entitytype"), row);
        this.getModel().setValue("bizapp", rowMap.get("bizapp"), row);
        this.getModel().setValue("bizcloud", rowMap.get("bizcloud"), row);
    }

    private void beforeEntityObjectF7Select(ListShowParameter listShowParameter) {
        listShowParameter.getListSelectedRowCollection().clear();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        List adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)RequestContext.get().getCurrUserId());
        qFilters.add(new QFilter("bizappid", "in", (Object)adminChargeApps));
        int rowCount = this.getModel().getEntryRowCount("operationruleobj_list");
        ArrayList<Object> selectedIds = new ArrayList<Object>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entityObject = (DynamicObject)this.getModel().getValue("entitytype", i);
            if (entityObject == null) continue;
            selectedIds.add(entityObject.getPkValue());
        }
        if (!selectedIds.isEmpty()) {
            qFilters.add(new QFilter("id", "not in", selectedIds));
        }
    }

    private void saveOperationRuleObj(ListSelectedRowCollection selectedRows) {
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            return;
        }
        HashMap<String, List<String>> entityAppMap = new HashMap<String, List<String>>(selectedRows.size());
        selectedRows.forEach(row -> {
            List cfr_ignored_0 = entityAppMap.put(row.getPrimaryKeyValue().toString(), null);
        });
        String operationRuleId = (String)this.getView().getFormShowParameter().getCustomParam("operationrule_id");
        this.saveOperationRuleObj(operationRuleId, null, entityAppMap, Boolean.TRUE);
        this.loadOpRuleObjData(operationRuleId);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexes = e.getRowIndexs();
        HashMap<String, List<String>> entityAppMap = new HashMap<String, List<String>>(rowIndexes.length);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("operationruleobj_list");
        for (int row : rowIndexes) {
            DynamicObject entryObj = (DynamicObject)entryEntity.get(row);
            List appIds = entityAppMap.computeIfAbsent(entryObj.getString("entitytype_id"), v -> new ArrayList(entryEntity.size()));
            appIds.add(entryObj.getString("bizapp_id"));
        }
        String operationRuleId = (String)this.getView().getFormShowParameter().getCustomParam("operationrule_id");
        this.saveOperationRuleObj(operationRuleId, null, entityAppMap, Boolean.FALSE);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String operationRuleId = (String)this.getView().getFormShowParameter().getCustomParam("operationrule_id");
        this.loadOpRuleObjData(operationRuleId);
    }
}

