/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.oprule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.MulComboProp;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OperationRuleMatcher {
    private static final Log log = LogFactory.getLog(OperationRuleMatcher.class);
    private Set<String> entityNumbers;
    private String operation;
    private Set<String> fields;
    private IPageCache pageCache;
    private Map<String, Result> resultMap;
    private Map<String, String> publicRuleOperationMap;
    private Map<String, IDataEntityProperty> publicRuleFieldMap = null;
    private static final int BATCH_LIMIT = 20;
    private static final String CACHE_MATCHED_TEMPLATES = "matchedTemplates";

    public OperationRuleMatcher(Set<String> entityNumbers, String operation, Set<String> fields) {
        this(entityNumbers, operation, fields, null);
    }

    public OperationRuleMatcher(Set<String> entityNumbers, String operation, Set<String> fields, IPageCache pageCache) {
        this.entityNumbers = entityNumbers;
        this.operation = operation;
        this.fields = fields;
        this.pageCache = pageCache;
        this.resultMap = new HashMap<String, Result>(entityNumbers.size());
    }

    public Map<String, Result> match() {
        Map<String, String> matchEntityMap;
        Map<String, List<String>> entityHierarchyMap;
        if (CollectionUtils.isEmpty(this.entityNumbers)) {
            return this.resultMap;
        }
        log.info("\u5f00\u59cb\u6279\u91cf\u6267\u884c\u4e1a\u52a1\u5bf9\u8c61\u5339\u914d\u7279\u6b8a\u6570\u636e\u6743\u9650\u89c4\u5219\uff1a" + this.entityNumbers.size());
        if (this.entityNumbers.size() > 20) {
            entityHierarchyMap = this.getEntityHierarchy();
            matchEntityMap = this.getMatchedTemplates();
        } else {
            entityHierarchyMap = new HashMap<String, List<String>>(0);
            matchEntityMap = new HashMap<String, String>(0);
        }
        ArrayList<String> compareEntityNumbers = new ArrayList<String>(this.entityNumbers);
        Map entityObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])compareEntityNumbers.toArray(), (String)"bos_objecttype");
        for (Map.Entry entry : entityObjectMap.entrySet()) {
            DynamicObject entityObj = (DynamicObject)entry.getValue();
            Result result = new Result(entityObj);
            this.resultMap.put(result.getEntityNumber(), result);
            if (this.isTemplateMatched(result.getEntityNumber(), entityHierarchyMap, matchEntityMap)) continue;
            this.isEntityMatched(result.getEntityNumber(), result);
        }
        if (compareEntityNumbers.size() > entityObjectMap.size()) {
            compareEntityNumbers.removeAll(entityObjectMap.keySet());
            for (String entityNumber : compareEntityNumbers) {
                Result result = new Result(null);
                this.resultMap.put(entityNumber, result);
                result.setEntityNumber(entityNumber);
                result.fail(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"OperationRuleMatcher_6", (String)"bos-permission-formplugin", (Object[])new Object[0]), entityNumber));
            }
        }
        log.info("\u5b8c\u6210\u6279\u91cf\u6267\u884c\u4e1a\u52a1\u5bf9\u8c61\u5339\u914d\u7279\u6b8a\u6570\u636e\u6743\u9650\u89c4\u5219\uff1a" + this.resultMap.size());
        return this.resultMap;
    }

    private Map<String, List<String>> getEntityHierarchy() {
        StringJoiner sqlParams = new StringJoiner(",");
        this.entityNumbers.forEach(entityNumber -> sqlParams.add("'" + entityNumber + "'"));
        HashMap<String, List<String>> entityHierarchyMap = new HashMap<String, List<String>>(sqlParams.length());
        DB.query((DBRoute)DBRoute.meta, (String)String.format("select fnumber,finheritpath from t_meta_entitydesign where fnumber in (%s)", sqlParams), null, rs -> {
            while (rs.next()) {
                String inheritPath = rs.getString("finheritpath");
                if (inheritPath == null) continue;
                String[] splitPathArr = inheritPath.split(",");
                ArrayList<String> paths = new ArrayList<String>();
                for (String path : splitPathArr) {
                    if (!StringUtils.isNotBlank((CharSequence)path)) continue;
                    paths.add(path);
                }
                if (paths.isEmpty()) continue;
                entityHierarchyMap.put(rs.getString("fnumber"), paths);
            }
            return "";
        });
        return entityHierarchyMap;
    }

    private Map<String, String> getMatchedTemplates() {
        String cacheMatchEntities;
        StringJoiner cacheKey = new StringJoiner("@@");
        cacheKey.add(CACHE_MATCHED_TEMPLATES);
        cacheKey.add(this.operation);
        cacheKey.add(this.fields.toString());
        String string = cacheMatchEntities = this.pageCache == null ? null : this.pageCache.get(cacheKey.toString());
        if (cacheMatchEntities != null) {
            return (Map)SerializationUtils.fromJsonString((String)cacheMatchEntities, List.class);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"perm_opruleassign_batch");
        List templateItems = ((MulComboProp)dataEntityType.getProperty("template")).getComboItems();
        HashMap<String, String> matchEntityMap = new HashMap<String, String>(templateItems.size());
        for (ValueMapItem item : templateItems) {
            String[] entityInfo = item.getValue().split("@@");
            if (entityInfo.length != 2) continue;
            String entityNumber = entityInfo[0];
            if (!PermFormCommonUtil.getOperationRuleEntity().equals(entityNumber) && !this.isEntityMatched(entityNumber, null)) continue;
            matchEntityMap.put(entityInfo[1], entityNumber);
        }
        if (this.pageCache != null) {
            this.pageCache.put(cacheKey.toString(), SerializationUtils.toJsonString(matchEntityMap));
        }
        return matchEntityMap;
    }

    private boolean isEntityMatched(String entity, Result result) {
        if (!this.isOperationMatched(entity, result)) {
            return false;
        }
        return this.isPropertyMatched(entity, result);
    }

    private boolean isOperationMatched(String entity, Result result) {
        if (StringUtils.isBlank((CharSequence)this.operation)) {
            return true;
        }
        Map<String, String> operation = this.getOperation(entity);
        if (operation == null) {
            if (result != null) {
                result.fail(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e1a\u52a1\u5bf9\u8c61\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OperationRuleMatcher_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), result.getEntityObject().getString("name")));
            }
        } else {
            if (operation.containsKey(this.operation)) {
                return true;
            }
            if (result != null) {
                String operationName = this.getPublicRuleOperationMap().get(this.operation);
                if (operationName == null) {
                    result.fail(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5b58\u5728\u201c%2$s\u201d\u64cd\u4f5c\u3002", (String)"OperationRuleMatcher_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), result.getEntityObject().getString("name"), this.operation));
                } else {
                    result.fail(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5b58\u5728\u201c%2$s\uff08%3$s\uff09\u201d\u64cd\u4f5c\u3002", (String)"OperationRuleMatcher_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), result.getEntityObject().getString("name"), operationName, this.operation));
                }
            }
        }
        return false;
    }

    private boolean isPropertyMatched(String entity, Result result) {
        if (CollectionUtils.isEmpty(this.fields)) {
            return true;
        }
        Map<String, IDataEntityProperty> fieldMap = this.getAllFields(entity);
        if (fieldMap == null) {
            if (result != null) {
                result.fail(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e1a\u52a1\u5bf9\u8c61\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"OperationRuleMatcher_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), result.getEntityObject().getString("name")));
            }
            return false;
        }
        for (String filterProp : this.fields) {
            if (fieldMap.get(filterProp) != null) continue;
            if (result != null) {
                IDataEntityProperty property = this.getPublicRuleFieldMap().get(filterProp);
                if (property == null) {
                    result.fail(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5b58\u5728\u201c%2$s\u201d\u5c5e\u6027\u3002", (String)"OperationRuleMatcher_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), result.getEntityObject().getString("name"), filterProp));
                } else {
                    result.fail(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5b58\u5728\u201c%2$s\uff08%3$s\uff09\u201d\u5c5e\u6027\u3002", (String)"OperationRuleMatcher_5", (String)"bos-permission-formplugin", (Object[])new Object[0]), result.getEntityObject().getString("name"), property.getDisplayName(), filterProp));
                }
            }
            return false;
        }
        return true;
    }

    private boolean isTemplateMatched(String entityNumber, Map<String, List<String>> entityHierarchyMap, Map<String, String> matchEntityMap) {
        List<String> paths = entityHierarchyMap.get(entityNumber);
        if (CollectionUtils.isEmpty(paths)) {
            return false;
        }
        for (String path : paths) {
            if (!matchEntityMap.containsKey(path)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> getPublicRuleOperationMap() {
        if (this.publicRuleOperationMap == null) {
            this.publicRuleOperationMap = this.getOperation(PermFormCommonUtil.getOperationRuleEntity());
            if (this.publicRuleOperationMap == null) {
                this.publicRuleOperationMap = new HashMap<String, String>(0);
            }
        }
        return this.publicRuleOperationMap;
    }

    private Map<String, IDataEntityProperty> getPublicRuleFieldMap() {
        if (this.publicRuleFieldMap == null) {
            this.publicRuleFieldMap = this.getAllFields(PermFormCommonUtil.getOperationRuleEntity());
            if (this.publicRuleFieldMap == null) {
                this.publicRuleFieldMap = new LinkedHashMap<String, IDataEntityProperty>(0);
            }
        }
        return this.publicRuleFieldMap;
    }

    private Map<String, String> getOperation(String entity) {
        try {
            return OperationHelper.getOperationInfoMap((String)entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, IDataEntityProperty> getAllFields(String entity) {
        try {
            return EntityMetadataCache.getDataEntityType((String)entity).getAllFields();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class Result {
        private boolean success = true;
        private String entityNumber;
        private DynamicObject entityObject;
        private String message;

        public Result(DynamicObject entityObject) {
            this.entityObject = entityObject;
            if (entityObject != null) {
                this.entityNumber = entityObject.getPkValue().toString();
            }
        }

        public void fail(String message) {
            this.success = false;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public DynamicObject getEntityObject() {
            return this.entityObject;
        }

        public void setEntityObject(DynamicObject entityObject) {
            this.entityObject = entityObject;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return "Result{success=" + this.success + ", entityNumber='" + this.entityNumber + '\'' + ", message='" + this.message + '\'' + '}';
        }
    }
}

