/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.oprule;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.oprule.OperationRuleObjSaveValidator;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.OprLogHelper;
import kd.bos.permission.log.model.LogOprEvent;
import kd.bos.permission.log.model.LogOprInfo;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;

public class OperationRuleObjSavePlugin
extends AbstractOperationServicePlugIn {
    protected static final Log logger = LogFactory.getLog(OperationRuleObjSavePlugin.class);

    private Map<String, String> getOptionVariables() {
        Map variables = this.getOption().getVariables();
        variables = null == variables ? new HashMap(8) : variables;
        return variables;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OperationRuleObjSaveValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        CacheMrg.clearCache((String)CacheMrg.getType4OperationRule());
        CacheMrg.clearCache((String)CacheMrg.getType4OperationRuleObj());
        this.permHandle(e.getDataEntities());
    }

    private void permHandle(DynamicObject[] dataEntities) {
        int count = dataEntities.length;
        if (count == 0) {
            return;
        }
        HashMap enableLogMap = new HashMap(count);
        HashMap disableLogMap = new HashMap(count);
        ArrayList<Map<String, String>> appEntityList = new ArrayList<Map<String, String>>(count);
        HashMap<String, LogOprInfo> ruleLogInfoMap = new HashMap<String, LogOprInfo>(count);
        for (DynamicObject obj : dataEntities) {
            DynamicObject ruleObj = obj.getDynamicObject("operationrule");
            DynamicObject entityObj = obj.getDynamicObject("entitytype");
            if (ruleObj == null || entityObj == null) continue;
            LogOprInfo logOprInfo = new LogOprInfo();
            boolean enable = obj.getBoolean("objenabled");
            LogOprInfo ruleInfo = this.getRuleInfo(enable, ruleObj, ruleLogInfoMap);
            logOprInfo.setOperationRuleId(ruleInfo.getOperationRuleId());
            logOprInfo.setName(ruleInfo.getName());
            logOprInfo.setPublicYesOrNo(ruleInfo.getPublicYesOrNo());
            logOprInfo.setPresetYesOrNo(ruleInfo.getPresetYesOrNo());
            logOprInfo.setRuleText(ruleInfo.getRuleText());
            logOprInfo.setOperationKey(ruleInfo.getOperationKey());
            logOprInfo.setOperation(ruleInfo.getOperation());
            String id = obj.getString("id");
            HashMap oprLogMap = enable ? enableLogMap : disableLogMap;
            HashMap<String, Object> logInfoMap = new HashMap<String, Object>(4);
            oprLogMap.put(id, logInfoMap);
            logInfoMap.put("esloginfo", logOprInfo);
            logOprInfo.setOperationRuleObjId(id);
            logOprInfo.setEntityId(entityObj.getPkValue().toString());
            logOprInfo.setEntityName(entityObj.getString("name"));
            DynamicObject appObj = obj.getDynamicObject("bizapp");
            if (appObj != null) {
                logOprInfo.setAppId(appObj.getPkValue().toString());
                logOprInfo.setAppName(appObj.getString("name"));
            }
            if (enable) {
                logOprInfo.setObjenabled("0");
                logInfoMap.put("pre_data", this.getChangeData(logOprInfo));
                logOprInfo.setObjenabled("1");
            } else {
                logOprInfo.setObjenabled("1");
                logInfoMap.put("pre_data", this.getChangeData(logOprInfo));
                logOprInfo.setObjenabled("0");
            }
            logInfoMap.put("after_data", this.getChangeData(logOprInfo));
            HashMap<String, String> appEntityMap = new HashMap<String, String>(1);
            appEntityMap.put(logOprInfo.getAppId(), logOprInfo.getEntityId());
            appEntityList.add(appEntityMap);
        }
        String opFormNum = "perm_operationruleassign";
        Map<String, String> variables = this.getOptionVariables();
        String currbizappnum = variables.get("currbizappid");
        String opAppId = AppHelper.getCurAppId((String)opFormNum, (String)currbizappnum);
        OprLogHelper.add((PermLogBusiType)PermLogService.getPermLogBusiType((String)"opr_enable"), enableLogMap, (String)opFormNum, (String)opAppId);
        OprLogHelper.add((PermLogBusiType)PermLogService.getPermLogBusiType((String)"opr_disable"), disableLogMap, (String)opFormNum, (String)opAppId);
        PermFormCommonUtil.cancelShowFormDataRights(appEntityList);
    }

    private LogOprInfo getRuleInfo(boolean enable, DynamicObject ruleObj, Map<String, LogOprInfo> ruleLogInfoMap) {
        String ruleId = ruleObj.getString("id");
        LogOprInfo ruleInfo = ruleLogInfoMap.get(ruleId);
        if (ruleInfo == null) {
            ruleInfo = new LogOprInfo();
            ruleLogInfoMap.put(ruleId, ruleInfo);
            ruleInfo.setOperationRuleId(ruleId);
            ruleInfo.setName(ruleObj.getString("name"));
            ruleInfo.setPublicYesOrNo(ruleObj.getBoolean("ispublic") ? "1" : "0");
            ruleInfo.setPresetYesOrNo(ruleObj.getBoolean("ispreset") ? "1" : "0");
            ruleInfo.setRuleText(PermCommonUtil.replaceBackSlach((String)ruleObj.getString("rule")));
            if (enable) {
                ruleInfo.setOperationKey("enable");
                ruleInfo.setOperation(ConstantsHelper.getEnable());
            } else {
                ruleInfo.setOperationKey("disable");
                ruleInfo.setOperation(ConstantsHelper.getDisable());
            }
        }
        return ruleInfo;
    }

    private String getChangeData(LogOprInfo logOprInfo) {
        try {
            LogOprEvent logEvent = new LogOprEvent(logOprInfo, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            String data = new ObjectMapper().writeValueAsString((Object)logEvent);
            return data;
        }
        catch (JsonProcessingException e) {
            logger.warn("\u89e3\u6790\u7279\u6b8a\u6570\u636e\u6743\u9650\u64cd\u4f5c\u524d\u6570\u636e\u5931\u8d25\uff1a" + logOprInfo.getName(), (Throwable)e);
            return null;
        }
    }
}

