/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.oprule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.formplugin.oprule.OperationRuleMatcher;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.servicehelper.QueryServiceHelper;

public class OperationRuleObjSaveValidator
extends AbstractValidator {
    public void validate() {
        int count = this.dataEntities.length;
        HashMap<String, Map<String, Object>> enableRuleMap = new HashMap<String, Map<String, Object>>(count);
        HashSet<String> allEntities = new HashSet<String>(count);
        HashSet<String> allOperations = new HashSet<String>(count);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject ruleEntityObj = dataEntity.getDataEntity();
            DynamicObject entityObj = ruleEntityObj.getDynamicObject("entitytype");
            if (entityObj == null) continue;
            String entity = entityObj.getPkValue().toString();
            dataEntity.setBillNo(entity);
            DynamicObject ruleObj = ruleEntityObj.getDynamicObject("operationrule");
            if (ruleObj == null || !ruleEntityObj.getBoolean("objenabled")) continue;
            String ruleId = ruleObj.getPkValue().toString();
            HashMap<String, Object> ruleInfoMap = (HashMap<String, Object>)enableRuleMap.get(ruleId);
            if (ruleInfoMap == null) {
                ruleInfoMap = new HashMap<String, Object>(4);
                enableRuleMap.put(ruleId, ruleInfoMap);
                String operation = ruleObj.getString("operation_key");
                allOperations.add(operation);
                ruleInfoMap.put("operation_key", operation);
                ruleInfoMap.put("rule_field", PermFormCommonUtil.parseFilterGrid(ruleObj.getString("rule")));
            }
            Map entities = (Map)ruleInfoMap.computeIfAbsent("entitytype", v -> new HashMap(this.dataEntities.length));
            entities.put(entity, dataEntity);
            allEntities.add(entity);
        }
        this.enableRuleValidate(enableRuleMap);
        this.duplicateValidate(allEntities, allOperations);
    }

    private void enableRuleValidate(Map<String, Map<String, Object>> enableRuleMap) {
        if (enableRuleMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : enableRuleMap.entrySet()) {
            Map<String, Object> ruleInfoMap = entry.getValue();
            String operation = (String)ruleInfoMap.get("operation_key");
            Map entities = (Map)ruleInfoMap.get("entitytype");
            OperationRuleMatcher matcher = new OperationRuleMatcher(entities.keySet(), operation, (Set)ruleInfoMap.get("rule_field"));
            Map<String, OperationRuleMatcher.Result> matchMap = matcher.match();
            for (Map.Entry<String, OperationRuleMatcher.Result> matchEntry : matchMap.entrySet()) {
                OperationRuleMatcher.Result result = matchEntry.getValue();
                if (result.isSuccess()) continue;
                this.addErrorMessage((ExtendedDataEntity)entities.get(matchEntry.getKey()), result.getMessage());
            }
        }
    }

    private void duplicateValidate(Set<String> allEntities, Set<String> allOperations) {
        HashMap<String, Map<String, Object>> entityOperationPkMap = new HashMap<String, Map<String, Object>>(this.dataEntities.length);
        this.loadExistsRule(allEntities, allOperations, entityOperationPkMap);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject ruleObj;
            DynamicObject entityObj;
            DynamicObject ruleEntityObj = dataEntity.getDataEntity();
            if (!ruleEntityObj.getBoolean("objenabled") || (entityObj = ruleEntityObj.getDynamicObject("entitytype")) == null || (ruleObj = ruleEntityObj.getDynamicObject("operationrule")) == null) continue;
            String app = "";
            DynamicObject appObj = ruleEntityObj.getDynamicObject("bizapp");
            if (appObj != null) {
                app = appObj.getPkValue().toString();
            }
            String entity = entityObj.getPkValue().toString();
            String entityMatchKey = this.getEntityMatchKey(app, entity);
            String operation = ruleObj.getString("operation_key");
            Object currentPk = ruleEntityObj.getPkValue();
            HashMap<String, Object> opPkMap = (HashMap<String, Object>)entityOperationPkMap.get(entityMatchKey);
            if (opPkMap == null) {
                opPkMap = new HashMap<String, Object>(allOperations.size());
                opPkMap.put(operation, currentPk);
                entityOperationPkMap.put(entityMatchKey, opPkMap);
                continue;
            }
            Object pk = opPkMap.get(operation);
            if (pk == null) {
                opPkMap.put(operation, currentPk);
                continue;
            }
            if (Objects.equals(currentPk, pk)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u7ecf\u542f\u7528\u4e86\u540c\u79cd\u201c\u64cd\u4f5c\u4ee3\u7801(%2$s)\u201d\u7684\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"OperationRuleObjSaveValidator_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), entityObj.getString("name"), operation));
        }
    }

    private void loadExistsRule(Set<String> allEntities, Set<String> allOperations, Map<String, Map<String, Object>> entityOperationPkMap) {
        if (allEntities.isEmpty() || allOperations.isEmpty()) {
            return;
        }
        String selectFields = "id,bizapp,entitytype,operationrule.operation_key operation_key";
        QFilter opFilter = new QFilter("operationrule.operation_key", "in", allOperations);
        QFilter entityFilter = new QFilter("entitytype", "in", allEntities);
        QFilter enableFilter = new QFilter("objenabled", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{opFilter, entityFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OperationRuleObjSavePlugin.OperationRuleObjValidator.duplicateValidate", (String)"perm_operationruleobj", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                String app = row.getString("bizapp");
                String entity = row.getString("entitytype");
                Map opPkMap = entityOperationPkMap.computeIfAbsent(this.getEntityMatchKey(app, entity), v -> new HashMap(allOperations.size()));
                opPkMap.put(row.getString("operation_key"), row.get("id"));
            }
        }
    }

    private String getEntityMatchKey(String app, String entity) {
        return app + "@@" + entity;
    }
}

