/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class AddAuthScopePlugin
extends AbstractFormPlugin {
    private Map<String, String> ctrlTypeInfos = new HashMap<String, String>(16);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List existData = (List)e.getFormShowParameter().getCustomParam("showFormCustomParam_existCtrlTypes");
        if (existData != null) {
            existData = existData.stream().map(x -> x.split("\\|")[0]).collect(Collectors.toList());
            existData.add("bos_objecttype");
            boolean exists = QueryServiceHelper.exists((String)"perm_ctrltype", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and(new QFilter("status", "=", (Object)"C")).and(new QFilter("bizobjectid", "not in", existData).and(new QFilter("systreefilter", "in", (Object)Sets.newHashSet((Object[])new String[]{"1"}))))});
            if (!exists) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u201c\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d\u5df2\u7ecf\u5168\u90e8\u6dfb\u52a0\u3002", (String)"AddAuthScopePlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void initialize() {
        super.initialize();
        String ctrlTypeInfoStr = this.getPageCache().get("ctrlTypeInfos");
        if (StringUtils.isNotEmpty((String)ctrlTypeInfoStr)) {
            this.ctrlTypeInfos = (Map)SerializationUtils.fromJsonString((String)ctrlTypeInfoStr, Map.class);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Object> existData = (ArrayList)this.getView().getFormShowParameter().getCustomParam("showFormCustomParam_existCtrlTypes");
        if (existData == null) {
            existData = new ArrayList(10);
        }
        existData = existData.stream().map(x -> x.split("\\|")[0]).collect(Collectors.toList());
        existData.add("bos_objecttype");
        ArrayList ctrlTypeRangeList = (ArrayList)this.getView().getFormShowParameter().getCustomParam("showFormCustomParam_ctrlTypeRange");
        if (null == ctrlTypeRangeList || ctrlTypeRangeList.isEmpty()) {
            ctrlTypeRangeList = new ArrayList(10);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("ctrltype");
        comboEdit.setMustInput(true);
        PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq((Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, new HashSet<Object>(existData), new HashSet(ctrlTypeRangeList));
        List permCtrlTypeList = IsoDimHelper.getPermCtrlTypeList((PermCtrlTypeReq)permCtrlTypeReq);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (PermCtrlType permCtrlType : permCtrlTypeList) {
            String name = permCtrlType.getName();
            String entityNum = permCtrlType.getBizobjectid();
            comboItems.add(new ComboItem(new LocaleString(name), entityNum));
            this.ctrlTypeInfos.put(entityNum, name);
        }
        comboEdit.setComboItems(comboItems);
        this.getPageCache().put("ctrlTypeInfos", SerializationUtils.toJsonString(this.ctrlTypeInfos));
        this.getView().setVisible(Boolean.FALSE, new String[]{"returndata"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        String type;
        super.beforeClick(evt);
        Button source = (Button)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key) && StringUtils.isNotEmpty((String)(type = (String)this.getModel().getValue("ctrltype")))) {
            String name = this.ctrlTypeInfos.get(type);
            this.getModel().setValue("returndata", (Object)(type + "|" + name));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String value = (String)this.getModel().getValue("returndata");
        if (StringUtils.isNotEmpty((String)value)) {
            this.getView().returnDataToParent((Object)value);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        String propName = e.getProperty().getName();
        if ("ctrltype".equals(propName) && newValue != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnok"});
        }
    }
}

