/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.IBillPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.preOpenPermFormCheck;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class AdminGroupEditPlugin
extends AbstractFormPlugin
implements IBillPlugin,
preOpenPermFormCheck {
    private static final Log logger = LogFactory.getLog(AdminGroupEditPlugin.class);

    public void initialize() {
        super.initialize();
    }

    @Override
    public void preOpenPermForm(PreOpenFormEventArgs e) {
        boolean exist = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)"SELECT count(0) FROM t_perm_admindomain", (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                boolean exist = false;
                while (rs.next()) {
                    long count = rs.getLong(1);
                    exist = count > 0L;
                }
                return exist;
            }
        });
        if (exist) {
            FormShowParameter formShowParameter = e.getFormShowParameter();
            formShowParameter.getCustomParams().put("show_domain", "true");
            formShowParameter.getFormConfig().setHeight(new LocaleString("345"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setDefaultValue();
        this.setDomain();
    }

    private void setDomain() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String showDomain = (String)formShowParameter.getCustomParams().get("show_domain");
        if (StringUtils.isEmpty((String)showDomain)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isdomain", "domain"});
        } else {
            OperationStatus status = formShowParameter.getStatus();
            DynamicObject parentGroup = (DynamicObject)this.getModel().getValue("parent");
            if (parentGroup != null) {
                Long parentLevel;
                boolean parentIsDomain = parentGroup.getBoolean("isdomain");
                if (parentIsDomain) {
                    Long domainId = parentGroup.getLong("domain.id");
                    this.getModel().setValue("isdomain", (Object)parentIsDomain);
                    this.getModel().setValue("domain", (Object)domainId);
                }
                if ((parentLevel = Long.valueOf(parentGroup.getLong("level"))) != 1L) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"isdomain", "domain"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"domain"});
                }
            }
            if (OperationStatus.EDIT.equals((Object)status)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"isdomain", "domain"});
            }
        }
    }

    private void setDefaultValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        Long originAdminScheme = (Long)model.getValue("adminscheme");
        Integer originAdminType = (Integer)model.getValue("admintype");
        Long originParent = (Long)model.getValue("parent");
        if (originAdminScheme == null) {
            Long adminScheme = Long.parseLong((String)formShowParameter.getCustomParam("adminScheme"));
            model.setValue("adminscheme", (Object)adminScheme);
        }
        if (originAdminType == null) {
            Long adminType = Long.parseLong((String)formShowParameter.getCustomParam("adminType"));
            model.setValue("admintype", (Object)adminType);
        }
        if (originParent == null) {
            Long parent = Long.parseLong((String)formShowParameter.getCustomParam("focusNodeToBeParent"));
            model.setValue("parent", (Object)parent);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String opKey = null;
        if (e.getSource() instanceof FormOperate) {
            FormOperate formOperate = (FormOperate)e.getSource();
            switch (opKey = formOperate.getOperateKey()) {
                case "save": {
                    Long grpId = (Long)this.getModel().getDataEntity().getPkValue();
                    OperateOption option = formOperate.getOption();
                    option.setVariableValue("PERM_ENABLE_ENTITY_OPERSERVICE", "1");
                    option.setVariableValue("ENTSAVE_PERMLOG", "1");
                    option.setVariableValue("permlog_op", "save");
                    option.setVariableValue("permlog_opbtn", ConstantsHelper.getSave());
                    option.setVariableValue("permlog_interfacemethod", "AdminGroupEditPlugin.beforeDoOperation");
                    option.setVariableValue("permlog_busitype", null == grpId || Objects.equals(0L, grpId) ? "admingroup_add" : "admingroup_modify");
                    option.setVariableValue("permlog_formnum", this.getModel().getDataEntityType().getName());
                    option.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        IFormView parentView = this.getView().getParentView();
        if ("save".equals(operateKey)) {
            if (e.getOperationResult().isSuccess()) {
                List successPkIds = e.getOperationResult().getSuccessPkIds();
                if (parentView != null && !CollectionUtils.isEmpty((Collection)successPkIds)) {
                    DynamicObject updateGroup = BusinessDataServiceHelper.loadSingle(successPkIds.get(0), (String)"perm_admingroup", (String)"id,parent,level");
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdminGroupEditPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    TreeView treeview = (TreeView)parentView.getControl("treeview");
                    try {
                        AdminGroupService.initAdminGroupTree((TreeView)treeview, (IPageCache)parentView.getPageCache());
                    }
                    catch (Exception ex) {
                        parentView.showErrorNotification(ex.getMessage());
                        logger.warn("[AdminGroupEditPlugin]\u91cd\u65b0\u52a0\u8f7d\u7ba1\u7406\u5458\u7ec4\u6811\u5f02\u5e38\uff1a", (Object)e);
                        return;
                    }
                    long level = updateGroup.getLong("level");
                    Long id = updateGroup.getLong("id");
                    Long parentId = updateGroup.getLong("parent.id");
                    TreeNode node = new TreeNode();
                    node.setId(id + "_" + level);
                    if (level == 1L) {
                        node.setParentid("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
                        treeview.focusNode(node);
                        treeview.treeNodeClick("8609760E-EF83-4775-A9FF-CCDEC7C0B689", node.getId());
                    } else {
                        node.setParentid(parentId + "_" + (level - 1L));
                        treeview.focusNode(node);
                        treeview.treeNodeClick(parentId + "_" + (level - 1L), node.getId());
                    }
                    this.getView().sendFormAction(parentView);
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                }
            } else {
                parentView.showErrorNotification(e.getOperationResult().getMessage());
            }
        }
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        this.setDomain();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.preOpenPermForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object id = this.getModel().getValue("id");
        if (id != null) {
            String adminGroupId = String.valueOf(id);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.EDIT.equals((Object)status)) {
                MutexHelper.release((String)"perm_admingroup", (String)"modify", (String)adminGroupId);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("isdomain".equals(propName)) {
            boolean isDomain = (Boolean)e.getChangeSet()[0].getNewValue();
            if (isDomain) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"domain"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"domain"});
                this.getModel().setValue("domain", null);
            }
        }
    }
}

