/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.model.permbase.App;
import kd.bos.permission.cache.model.permbase.Cloud;
import kd.bos.permission.cache.model.permbase.Entity;
import kd.bos.permission.cache.model.permbase.PermItem;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.bean.AdminGroupOrgSearchBean;
import kd.bos.permission.formplugin.bean.AdminGroupSysSearchBean;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.AdmGrpApp;
import kd.bos.permission.model.perm.admingroup.AdmGrpBizUnit;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrg;
import kd.bos.permission.model.perm.admingroup.AdmGrpOrgAddUser;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.admingroup.AdmGrpOrgAddUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.StringUtils;

public class AdminGroupPermPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
TreeNodeCheckListener,
BeforeF7SelectListener,
TabSelectListener {
    private static final Log logger = LogFactory.getLog(AdminGroupPermPlugin.class);
    private Map<String, String> sysNodeNameMap;
    private Map<String, String> sysNodeNameNumMap;
    private Map<String, String> appNodeNameMap;
    private Map<String, String> bizUnitNodeMap;
    private Map<String, String> adminOrgNodeMap;
    private Map<String, String> allOrgNameMap;
    private Map<String, String> orgPatternTypeMap;
    private Map<String, String> appIdNameMap;
    private Map<String, String> appIdNumberMap;
    private Map<String, String> entityNumNameMap;
    private Map<String, String> permItemIdNameMap;
    private Map<String, String> permItemIdNumberMap;
    private Map<String, String> appCloudInfoMap;
    private static final int SYS = 1;
    private static final int BIZ = 2;
    private static final int ADMIN = 3;
    private static final int APP = 4;
    private static final String KEY_GROUP = "key_group";
    private static final String KEY_ORG = "key_org";
    private static final String KEY_BIZAPP = "key_bizapp";
    private static final String KEY_ENTITY = "key_entity";
    private static final String KEY_PERMITEM = "key_permitem";

    public void initialize() {
        super.initialize();
        String sysNodeNameMapStr = this.getPageCache().get("sysNodeNameMap");
        String sysNodeNameNumMapStr = this.getPageCache().get("sysNodeNameNumMap");
        this.sysNodeNameMap = StringUtils.isNotEmpty((String)sysNodeNameMapStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)sysNodeNameMapStr, Map.class) : new HashMap<String, String>(16);
        this.sysNodeNameNumMap = StringUtils.isNotEmpty((String)sysNodeNameNumMapStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)sysNodeNameNumMapStr, Map.class) : new HashMap<String, String>(16);
        String appNodeNameMapStr = this.getPageCache().get("appNodeNameMap");
        this.appNodeNameMap = StringUtils.isNotEmpty((String)appNodeNameMapStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)appNodeNameMapStr, Map.class) : new HashMap<String, String>(16);
        String bizUnitNodeMapStr = this.getPageCache().get("bizUnitNodeMap");
        this.bizUnitNodeMap = StringUtils.isNotEmpty((String)bizUnitNodeMapStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)bizUnitNodeMapStr, Map.class) : new HashMap<String, String>(16);
        String adminOrgNodeMapStr = this.getPageCache().get("adminOrgNodeMap");
        this.adminOrgNodeMap = StringUtils.isNotEmpty((String)adminOrgNodeMapStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)adminOrgNodeMapStr, Map.class) : new HashMap<String, String>(16);
        String allOrgNameMapStr = this.getPageCache().getBigObject("allOrgNameMap");
        if (StringUtils.isNotEmpty((String)allOrgNameMapStr)) {
            this.allOrgNameMap = (Map)SerializationUtils.fromJsonString((String)allOrgNameMapStr, Map.class);
        } else {
            this.allOrgNameMap = OrgHelper.getAllOrgNameMap();
            this.getPageCache().putBigObject("allOrgNameMap", SerializationUtils.toJsonString(this.allOrgNameMap));
        }
        String orgPatternTypeMapStr = this.getPageCache().getBigObject("orgPatternTypeMap");
        if (StringUtils.isNotEmpty((String)orgPatternTypeMapStr)) {
            this.orgPatternTypeMap = (Map)SerializationUtils.fromJsonString((String)orgPatternTypeMapStr, Map.class);
        } else {
            this.orgPatternTypeMap = OrgHelper.getOrgPatternTypeMap();
            this.getPageCache().putBigObject("orgPatternTypeMap", SerializationUtils.toJsonString(this.orgPatternTypeMap));
        }
        String appIdNameMapStr = this.getPageCache().getBigObject("appIdNameMap");
        if (StringUtils.isNotEmpty((String)appIdNameMapStr)) {
            this.appIdNameMap = (Map)SerializationUtils.fromJsonString((String)appIdNameMapStr, Map.class);
        } else {
            this.appIdNameMap = AppHelper.getAllAppIdNameMap();
            this.getPageCache().putBigObject("appIdNameMap", SerializationUtils.toJsonString(this.appIdNameMap));
        }
        String appIdNumberMapStr = this.getPageCache().getBigObject("appIdNumberMap");
        if (StringUtils.isNotEmpty((String)appIdNumberMapStr)) {
            this.appIdNumberMap = (Map)SerializationUtils.fromJsonString((String)appIdNumberMapStr, Map.class);
        } else {
            this.appIdNumberMap = AppHelper.getAllAppIdNumberMap();
            this.getPageCache().putBigObject("appIdNumberMap", SerializationUtils.toJsonString(this.appIdNumberMap));
        }
        String entityNumNameMapStr = this.getPageCache().getBigObject("entityNumNameMap");
        if (StringUtils.isNotEmpty((String)entityNumNameMapStr)) {
            this.entityNumNameMap = (Map)SerializationUtils.fromJsonString((String)entityNumNameMapStr, Map.class);
        } else {
            this.entityNumNameMap = PermCommonUtil.getAllEntNumAndNameMap();
            this.getPageCache().putBigObject("entityNumNameMap", SerializationUtils.toJsonString(this.entityNumNameMap));
        }
        String permItemIdNameMapStr = this.getPageCache().getBigObject("permItemIdNameMap");
        if (StringUtils.isNotEmpty((String)permItemIdNameMapStr)) {
            this.permItemIdNameMap = (Map)SerializationUtils.fromJsonString((String)permItemIdNameMapStr, Map.class);
        } else {
            this.permItemIdNameMap = PermItemHelper.getAllPermItemIdNameMap();
            this.getPageCache().putBigObject("permItemIdNameMap", SerializationUtils.toJsonString(this.permItemIdNameMap));
        }
        String permItemIdNumberMapStr = this.getPageCache().getBigObject("permItemIdNumberMap");
        if (StringUtils.isNotEmpty((String)permItemIdNumberMapStr)) {
            this.permItemIdNumberMap = (Map)SerializationUtils.fromJsonString((String)permItemIdNumberMapStr, Map.class);
        } else {
            this.permItemIdNumberMap = PermItemHelper.getAllPermItemIdNumberMap();
            this.getPageCache().putBigObject("permItemIdNumberMap", SerializationUtils.toJsonString(this.permItemIdNumberMap));
        }
        String appCloudInfoMapStr = this.getPageCache().getBigObject("appCloudInfoMap");
        if (StringUtils.isNotEmpty((String)appCloudInfoMapStr)) {
            this.appCloudInfoMap = (Map)SerializationUtils.fromJsonString((String)appCloudInfoMapStr, Map.class);
        } else {
            this.appCloudInfoMap = AppHelper.getAppCloudInfo(null);
            this.getPageCache().putBigObject("appCloudInfoMap", SerializationUtils.toJsonString(this.appCloudInfoMap));
        }
        this.addListener();
    }

    private void addListener() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String adminGroupStr = (String)customParams.get("adminGroupId");
        String adminGroupParentStr = (String)customParams.get("adminGroupParentId");
        String levelStr = (String)customParams.get("level");
        long adminGroupId = Long.parseLong(adminGroupStr);
        long level = Long.parseLong(levelStr);
        long adminGroupParentId = 0L;
        if (level != 1L) {
            adminGroupParentId = Long.parseLong(adminGroupParentStr);
        }
        Search sysLeftSearch = (Search)this.getControl("sysleftsearch");
        sysLeftSearch.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            TreeView tv = (TreeView)this.getControl("systree");
            tv.deleteAllNodes();
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                LinkedHashSet<String> selectData = new LinkedHashSet<String>(16);
                Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("sysLeftSource"), Map.class);
                for (Map.Entry entry : dataSource.entrySet()) {
                    AdminGroupSysSearchBean bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)((String)entry.getValue()), AdminGroupSysSearchBean.class);
                    if (!bean.getEntityName().contains(searchText)) continue;
                    for (String permItem : bean.getPermItems()) {
                        selectData.add((String)entry.getKey() + '|' + permItem);
                    }
                }
                TreeNode rootNode = this.getSelectPermRootNode(tv, selectData, this.getSysRootNodeText(), true);
                pageCache.putBigObject("sysTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
            } else {
                this.getPageCache().remove("sysTreeLeftRoot");
                this.initSysLeftTree(adminGroupId, level);
            }
        });
        Search sysRightSearch = (Search)this.getControl("sysrightsearch");
        sysRightSearch.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            TreeView tv = (TreeView)this.getControl("selectedsystree");
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                LinkedHashSet<String> selectData = new LinkedHashSet<String>(16);
                String sysRightSource = pageCache.get("sysRightSource");
                if (StringUtils.isEmpty((String)sysRightSource)) {
                    return;
                }
                Map dataSource = (Map)SerializationUtils.fromJsonString((String)sysRightSource, Map.class);
                if (CollectionUtils.isEmpty((Map)dataSource)) {
                    return;
                }
                boolean showNum = "true".equals(this.getPageCache().get("shownum"));
                for (Map.Entry entry : dataSource.entrySet()) {
                    String value = (String)entry.getValue();
                    if (StringUtils.isEmpty((String)value)) continue;
                    AdminGroupSysSearchBean bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)value, AdminGroupSysSearchBean.class);
                    String entityName = bean.getEntityName();
                    if (null == bean || StringUtils.isEmpty((String)entityName)) continue;
                    String appEntity = bean.getAppEntity();
                    String entityNum = appEntity.substring(appEntity.lastIndexOf(124) + 1);
                    entityName = showNum ? entityName + "(" + entityNum + ")" : entityName;
                    if (!entityName.contains(searchText)) continue;
                    for (String permItem : bean.getPermItems()) {
                        selectData.add((String)entry.getKey() + '|' + permItem);
                    }
                }
                tv.deleteAllNodes();
                this.getSelectPermRootNode(tv, selectData, this.getSelectSysRootNodeText(), true);
            } else {
                this.rebuildSysRightTree(true, new HashSet<String>(16));
            }
        });
        Search bizLeftSearch = (Search)this.getControl("bizleftsearch");
        long finalAdminGroupParentId = adminGroupParentId;
        bizLeftSearch.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                TreeView tv = (TreeView)this.getControl("orgtree");
                int i = 0;
                HashSet<String> selectData = new HashSet<String>(1000);
                ArrayList<AdminGroupOrgSearchBean> selectSource = new ArrayList<AdminGroupOrgSearchBean>(1000);
                List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get("bizLeftSource"), AdminGroupOrgSearchBean.class);
                for (AdminGroupOrgSearchBean bean : dataSource) {
                    if (!bean.getOrgName().contains(searchText) && !bean.getNumber().contains(searchText)) continue;
                    if (++i > 1000) {
                        this.getView().showTipNotification(this.getSearchTips());
                        return;
                    }
                    selectData.add(bean.getDetail());
                    selectSource.add(bean);
                }
                ArrayList<String> dataList = new ArrayList<String>(selectData);
                this.orgDataSort(dataList);
                pageCache.put("orgtree_search", "true");
                tv.deleteAllNodes();
                this.buildOrgTreeForSearch("orgTreeLeftRoot", tv, this.getBizUnitRootNodeText(), dataList, true);
                pageCache.put("bizLeftSource_search", SerializationUtils.toJsonString(selectSource));
            } else {
                pageCache.remove("orgtree_search");
                pageCache.remove("bizLeftSource_search");
                if (StringUtils.isNotEmpty((String)pageCache.get("15_super"))) {
                    this.initUnitTreeSuper("15");
                } else {
                    this.initUnitTreeNormal("15", finalAdminGroupParentId, level);
                }
            }
        });
        Search bizRightSearch = (Search)this.getControl("bizrightsearch");
        bizRightSearch.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                TreeView tv = (TreeView)this.getControl("selectedorgtree");
                int i = 0;
                HashSet<String> selectData = new HashSet<String>(1000);
                ArrayList<AdminGroupOrgSearchBean> selectSource = new ArrayList<AdminGroupOrgSearchBean>(1000);
                String bizRightSourceStr = pageCache.get("bizRightSource");
                if (StringUtils.isEmpty((String)bizRightSourceStr)) {
                    return;
                }
                List dataSource = SerializationUtils.fromJsonStringToList((String)bizRightSourceStr, AdminGroupOrgSearchBean.class);
                for (AdminGroupOrgSearchBean bean : dataSource) {
                    if (!bean.getOrgName().contains(searchText) && !bean.getNumber().contains(searchText)) continue;
                    if (++i > 1000) {
                        this.getView().showTipNotification(this.getSearchTips());
                        return;
                    }
                    selectData.add(bean.getDetail());
                    selectSource.add(bean);
                }
                ArrayList<String> dataList = new ArrayList<String>(selectData);
                this.orgDataSort(dataList);
                pageCache.put("selectedorgtree_search", "true");
                tv.deleteAllNodes();
                this.buildOrgTreeForSearch("orgTreeRightRoot", tv, this.getSelBizUnitRootText(), dataList, true);
                pageCache.put("bizRightSource_search", SerializationUtils.toJsonString(selectSource));
            } else {
                pageCache.remove("selectedorgtree_search");
                pageCache.remove("bizRightSource_search");
                this.buildSelectedOrgTree(adminGroupId, "15", level);
            }
        });
        Search adminLeftSearch = (Search)this.getControl("adminleftsearch");
        adminLeftSearch.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                TreeView tv = (TreeView)this.getControl("adminorgtree");
                int i = 0;
                HashSet<String> selectData = new HashSet<String>(1000);
                ArrayList<AdminGroupOrgSearchBean> selectSource = new ArrayList<AdminGroupOrgSearchBean>(1000);
                List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get("adminLeftSource"), AdminGroupOrgSearchBean.class);
                for (AdminGroupOrgSearchBean bean : dataSource) {
                    if (!bean.getOrgName().contains(searchText) && !bean.getNumber().contains(searchText)) continue;
                    if (++i > 1000) {
                        this.getView().showTipNotification(this.getSearchTips());
                        return;
                    }
                    selectData.add(bean.getDetail());
                    selectSource.add(bean);
                }
                ArrayList<String> dataList = new ArrayList<String>(selectData);
                this.orgDataSort(dataList);
                pageCache.put("adminorgtree_search", "true");
                tv.deleteAllNodes();
                this.buildOrgTreeForSearch("AdminOrgTreeLeftRoot", tv, this.getAdminOrgRootNodeText(), dataList, false);
                pageCache.put("adminLeftSource_search", SerializationUtils.toJsonString(selectSource));
            } else {
                pageCache.remove("adminorgtree_search");
                pageCache.remove("adminLeftSource_search");
                if (StringUtils.isNotEmpty((String)pageCache.get("01_super"))) {
                    this.initUnitTreeSuper("01");
                } else {
                    this.initUnitTreeNormal("01", finalAdminGroupParentId, level);
                }
            }
        });
        Search adminRightSearch = (Search)this.getControl("adminrightsearch");
        adminRightSearch.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                TreeView tv = (TreeView)this.getControl("selectedadminorgtree");
                int i = 0;
                HashSet<String> selectData = new HashSet<String>(1000);
                ArrayList<AdminGroupOrgSearchBean> selectSource = new ArrayList<AdminGroupOrgSearchBean>(1000);
                String adminRightSourceStr = pageCache.get("adminRightSource");
                if (StringUtils.isEmpty((String)adminRightSourceStr)) {
                    return;
                }
                List dataSource = SerializationUtils.fromJsonStringToList((String)adminRightSourceStr, AdminGroupOrgSearchBean.class);
                for (AdminGroupOrgSearchBean bean : dataSource) {
                    if (!bean.getOrgName().contains(searchText) && !bean.getNumber().contains(searchText)) continue;
                    if (++i > 1000) {
                        this.getView().showTipNotification(this.getSearchTips());
                        return;
                    }
                    selectData.add(bean.getDetail());
                    selectSource.add(bean);
                }
                ArrayList<String> dataList = new ArrayList<String>(selectData);
                this.orgDataSort(dataList);
                pageCache.put("selectedadminorgtree_search", "true");
                tv.deleteAllNodes();
                this.buildOrgTreeForSearch("AdminOrgTreeRightRoot", tv, this.getSelAdminOrgRootNodeText(), dataList, false);
                pageCache.put("adminRightSource_search", SerializationUtils.toJsonString(selectSource));
            } else {
                pageCache.remove("selectedadminorgtree_search");
                pageCache.remove("adminRightSource_search");
                this.buildSelectedOrgTree(adminGroupId, "01", level);
            }
        });
        Search appLeftSearch = (Search)this.getControl("appleftsearch");
        appLeftSearch.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            TreeView tv = (TreeView)this.getControl("apptree");
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                HashSet<String> selectData = new HashSet<String>(16);
                Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("appLeftSource"), Map.class);
                if (CollectionUtils.isEmpty((Map)dataSource)) {
                    return;
                }
                for (Map.Entry entry : dataSource.entrySet()) {
                    if (!((String)entry.getValue()).contains(searchText)) continue;
                    selectData.add((String)entry.getKey());
                }
                tv.deleteAllNodes();
                this.getAppTreeRootNodeForSearch(tv, selectData, this.getAppRootNodeText());
            } else {
                this.initAppTree(finalAdminGroupParentId, level);
            }
        });
        Search appRightSearch = (Search)this.getControl("apprightsearch");
        appRightSearch.addEnterListener(see -> {
            IPageCache pageCache = this.getView().getPageCache();
            TreeView tv = (TreeView)this.getControl("selectedapptree");
            String searchText = see.getText();
            if (StringUtils.isNotEmpty((String)searchText)) {
                HashSet<String> selectData = new HashSet<String>(16);
                Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("appRightSource"), Map.class);
                if (CollectionUtils.isEmpty((Map)dataSource)) {
                    return;
                }
                for (Map.Entry entry : dataSource.entrySet()) {
                    if (null == entry.getValue() || !((String)entry.getValue()).contains(searchText)) continue;
                    selectData.add((String)entry.getKey());
                }
                tv.deleteAllNodes();
                this.getAppTreeRootNodeForSearch(tv, selectData, this.getSelectAppRootNodeText());
            } else {
                this.rebuildAppRightTree(true, new HashSet<String>(16));
            }
        });
        TreeView bizUnitTree = (TreeView)this.getControl("orgtree");
        bizUnitTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        bizUnitTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView adminOrgTree = (TreeView)this.getControl("adminorgtree");
        adminOrgTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        adminOrgTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView selBizUnitTree = (TreeView)this.getControl("selectedorgtree");
        selBizUnitTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        selBizUnitTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView selAdminOrgTree = (TreeView)this.getControl("selectedadminorgtree");
        selAdminOrgTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        selAdminOrgTree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Tab mainTab = (Tab)this.getControl("tabap");
        mainTab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit additionUser = (BasedataEdit)this.getControl("admin_exception_user");
        additionUser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btn_addorg", "btn_deleteorg", "btn_addadminorg", "btn_deleteadminorg", "btn_addapp", "btn_delapp", "btn_addsys", "btn_delsys"});
        this.addItemClickListeners(new String[]{"tbmain", "toolbarap"});
    }

    private TreeNode buildOrgTreeForSearch(String rootCache, TreeView tv, String rootNodeName, List<String> orgData, boolean isBizTree) {
        TreeNode root = new TreeNode("", "-1", rootNodeName, false);
        root.setIsOpened(true);
        tv.addNode(root);
        if (!CollectionUtils.isEmpty(orgData)) {
            root.setChildren(new ArrayList(10));
            HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(orgData.size());
            for (String data : orgData) {
                String[] infos = data.split("_split_");
                String id = infos[0];
                String orgName = infos[1];
                String longNumber = infos[2];
                String parentLongNumber = infos[2];
                TreeNode node = new TreeNode("-1", id, orgName);
                node.setIsOpened(true);
                if (isBizTree && Boolean.parseBoolean(infos[3])) {
                    node.setIcon("kdfont kdfont-faren");
                }
                if (!longNumber.contains(" ")) {
                    root.addChild(node);
                } else {
                    TreeNode parentNode;
                    while ((parentNode = (TreeNode)nodeMap.get(parentLongNumber = parentLongNumber.substring(0, parentLongNumber.lastIndexOf(" ")))) == null && parentLongNumber.contains(" ")) {
                    }
                    if (parentNode != null) {
                        node.setParentid(parentNode.getId());
                        parentNode.addChild(node);
                    } else {
                        root.addChild(node);
                    }
                }
                nodeMap.put(longNumber, node);
            }
        }
        this.getPageCache().put(rootCache, SerializationUtils.toJsonString((Object)root));
        return root;
    }

    private TreeNode getAppTreeRootNodeForSearch(TreeView tv, Set<String> selectData, String rootNodeText) {
        TreeNode rootNode = new TreeNode("", "-1", rootNodeText, true);
        rootNode.setIsOpened(true);
        HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(16);
        if (!CollectionUtils.isEmpty(selectData)) {
            for (String data : selectData) {
                String[] dataInfo = data.split("\\|");
                String cloudId = dataInfo[0];
                String appId = dataInfo[1];
                TreeNode treeNode = (TreeNode)cloudNodes.get(cloudId);
                if (treeNode == null) {
                    treeNode = new TreeNode("-1", "cloud#" + cloudId, this.appNodeNameMap.get(cloudId), true);
                    treeNode.setIsOpened(true);
                    cloudNodes.put(cloudId, treeNode);
                    rootNode.addChild(treeNode);
                }
                TreeNode children = new TreeNode(treeNode.getId(), "app#" + appId + "|" + cloudId, this.appNodeNameMap.get(appId), false);
                treeNode.addChild(children);
            }
        }
        tv.addNode(rootNode);
        return rootNode;
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String adminGroupStr = (String)customParams.get("adminGroupId");
        String adminGroupParentIdStr = (String)customParams.get("adminGroupParentId");
        String levelStr = (String)customParams.get("level");
        Long adminGroupId = Long.parseLong(adminGroupStr);
        Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)RequestContext.get().getCurrUserId(), (boolean)true, null);
        if (CollectionUtils.isEmpty((Collection)canSavePermAdmGroupIdSet) || !canSavePermAdmGroupIdSet.contains(adminGroupStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u8bbf\u95ee\u8be5\u7ba1\u7406\u5458\u7ec4\u5206\u7ec4\u6388\u6743\u4fe1\u606f\u3002", (String)"AdminGroupPermPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("usergroup", (Object)adminGroupId);
        Long level = Long.parseLong(levelStr);
        if (level == 1L) {
            adminGroupParentIdStr = "0";
        }
        this.getPageCache().put("current_group_info", adminGroupStr + '_' + adminGroupParentIdStr + '_' + level);
        this.initSysLeftTree(adminGroupId, level);
        this.initSysRightTree(adminGroupId, level);
    }

    private void loadExtraUser(Long adminGroupId) {
        HashSet<String> currentExtraUser = new HashSet<String>(16);
        DynamicObject[] extraUsers = BusinessDataServiceHelper.load((String)"perm_admingroupadduser", (String)"user", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)adminGroupId)});
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("admin_exception_user", new Object[0]);
        for (DynamicObject extraUser : extraUsers) {
            long userId = extraUser.getLong("user.id");
            vs.addRow(new Object[]{userId});
            currentExtraUser.add(String.valueOf(userId));
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.getPageCache().put("Origin_ExtraUser", SerializationUtils.toJsonString(currentExtraUser));
        this.getPageCache().put("Current_ExtraUser", SerializationUtils.toJsonString(currentExtraUser));
    }

    private void buildSelectedAppTree(Long adminGroupId, Long level) {
        TreeView tv = (TreeView)this.getControl("selectedapptree");
        tv.deleteAllNodes();
        TreeNode rootNode = new TreeNode();
        rootNode.setId("-1");
        rootNode.setParentid("");
        rootNode.setText(this.getSelectAppRootNodeText());
        rootNode.setIsOpened(true);
        Set appRanges = null;
        HashMap<String, String> dataSource = new HashMap<String, String>(16);
        if (level >= 2L) {
            String appRangeStr = this.getPageCache().get("Current_AppData");
            if (StringUtils.isNotEmpty((String)appRangeStr)) {
                appRanges = (Set)SerializationUtils.fromJsonString((String)appRangeStr, LinkedHashSet.class);
            } else {
                appRanges = this.loadAssignedAppRange(adminGroupId);
                this.getPageCache().put("Current_AppData", SerializationUtils.toJsonString((Object)appRanges));
                this.getPageCache().put("Origin_AppData", SerializationUtils.toJsonString((Object)appRanges));
            }
            if (CollectionUtils.isEmpty((Collection)appRanges)) {
                rootNode.setText(this.getCommonRootText());
            } else {
                boolean isShowNum = Boolean.parseBoolean(this.getPageCache().get("appshownum"));
                String cloudId = null;
                String cloudName = null;
                String appId = null;
                String appName = null;
                HashSet<String> appIdSet = new HashSet<String>(8);
                for (String appRange : appRanges) {
                    String[] appInfo = appRange.split("\\|");
                    appId = appInfo[1];
                    appIdSet.add(appId);
                }
                Map cloudMap = CloudHelper.getCloudMap(appIdSet);
                Map allAppIdNameMap = AppHelper.getAllAppIdNameMap(null);
                Map allCloudIdNameMap = CloudHelper.getAllCloudIdNameMap();
                HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(16);
                for (String appRange : appRanges) {
                    TreeNode treeNode;
                    String cloudNumber;
                    String[] appInfo = appRange.split("\\|");
                    cloudId = appInfo[0];
                    cloudName = (String)allCloudIdNameMap.get(cloudId);
                    appId = appInfo[1];
                    Cloud cloud = (Cloud)cloudMap.get(appId);
                    String string = cloudNumber = null == cloud ? "cannotFindCloudByAppId_" + appId : cloud.getCloudNumber();
                    if ((StringUtils.isEmpty((String)cloudId) || Objects.equals("null", cloudId)) && null != cloud) {
                        cloudId = cloud.getCloudId();
                    }
                    if ((StringUtils.isEmpty((String)cloudName) || Objects.equals("null", cloudName)) && null != cloud) {
                        cloudName = cloudNumber;
                    }
                    appName = (String)allAppIdNameMap.get(appId);
                    if (isShowNum) {
                        appName = appName + "(" + this.appIdNumberMap.get(appId) + ")";
                        if (StringUtils.isEmpty((String)cloudName)) continue;
                        if (!cloudName.contains("(") && !cloudName.contains(")")) {
                            cloudName = cloudName + "(" + (null != cloud ? cloudNumber : cloudId) + ")";
                        }
                    }
                    if ((treeNode = (TreeNode)cloudNodes.get(cloudId)) == null) {
                        treeNode = new TreeNode("-1", "cloud#" + cloudId, cloudName, true);
                        cloudNodes.put(cloudId, treeNode);
                        rootNode.addChild(treeNode);
                    }
                    TreeNode children = new TreeNode(treeNode.getId(), "app#" + appId + "|" + cloudId, appName, false);
                    treeNode.addChild(children);
                    dataSource.put(cloudId + '|' + appId, appName);
                }
            }
        } else {
            rootNode.setText(this.getVirtualRightRootText());
        }
        tv.addNode(rootNode);
        this.getPageCache().put("appRightSource", SerializationUtils.toJsonString(dataSource));
    }

    private void initAppTree(Long adminGroupId, Long level) {
        TreeView tv = (TreeView)this.getControl("apptree");
        tv.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", "-1", this.getAppRootNodeText(), true);
        rootNode.setIsOpened(true);
        Set<String> appRanges = null;
        Long currentGroupId = adminGroupId;
        while (level > 2L) {
            DynamicObject adminGroup = BusinessDataServiceHelper.loadSingle((String)"perm_admingroup", (String)"id, parent ,level", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentGroupId)});
            appRanges = this.queryAssignableAppRange("apptree", currentGroupId, false);
            if (!CollectionUtils.isEmpty(appRanges)) break;
            currentGroupId = adminGroup.getLong("parent.id");
            Long l = level;
            Long l2 = level = Long.valueOf(level - 1L);
        }
        if (level <= 2L && CollectionUtils.isEmpty(appRanges)) {
            appRanges = this.queryAssignableAppRange("apptree", currentGroupId, true);
        }
        String cloudId = null;
        String cloudName = null;
        String appId = null;
        String appName = null;
        HashSet<String> disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
        if (disabledCloudIds == null) {
            disabledCloudIds = new HashSet<String>(10);
        }
        disabledCloudIds.add("2HGKCE94QELW");
        boolean cloudSetNotEmpty = !disabledCloudIds.isEmpty();
        HashSet<String> disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        if (disabledAppIds == null) {
            disabledAppIds = new HashSet<String>(10);
        }
        disabledAppIds.add("2HGKTA7HH43C");
        boolean appSetNotEmpty = !disabledAppIds.isEmpty();
        HashMap<String, String> dataSource = new HashMap<String, String>(appRanges.size());
        HashMap<String, TreeNode> cloudNodes = new HashMap<String, TreeNode>(16);
        HashSet<String> appIdSet = new HashSet<String>(8);
        for (String appRange : appRanges) {
            String[] appInfo = appRange.split("\\|");
            appId = appInfo[2];
            appIdSet.add(appId);
        }
        Map cloudMap = CloudHelper.getCloudMap(appIdSet);
        Map allAppIdNameMap = AppHelper.getAllAppIdNameMap(null);
        Map allCloudIdNameMap = CloudHelper.getAllCloudIdNameMap();
        for (String appRange : appRanges) {
            String[] appInfo = appRange.split("\\|");
            cloudId = appInfo[0];
            cloudName = StringUtils.isEmpty((String)appInfo[1]) ? cloudId : appInfo[1];
            appId = appInfo[2];
            Cloud cloud = (Cloud)cloudMap.get(appId);
            String cloudNumFromBean = "";
            String cloudNameFromBean = "";
            String cloudIdFromBean = "";
            if (cloud != null) {
                cloudNumFromBean = cloud.getCloudNumber();
                cloudIdFromBean = cloud.getCloudId();
                cloudNameFromBean = (String)allCloudIdNameMap.get(cloudIdFromBean);
            }
            if (StringUtils.isEmpty((String)cloudId) || Objects.equals("null", cloudId)) {
                cloudId = cloudIdFromBean;
            }
            if (StringUtils.isEmpty((String)cloudName) || Objects.equals("null", cloudName)) {
                if (StringUtils.isNotEmpty((String)cloudNameFromBean)) {
                    cloudName = cloudNameFromBean;
                }
                if (StringUtils.isEmpty((String)cloudName) || Objects.equals("null", cloudName)) {
                    cloudName = StringUtils.isEmpty((String)cloudNumFromBean) ? cloudIdFromBean : cloudNumFromBean;
                }
            }
            this.appNodeNameMap.put(cloudId, cloudName);
            String string = appName = StringUtils.isEmpty((String)appInfo[3]) ? appId : appInfo[3];
            if (StringUtils.isEmpty((String)appName)) {
                appName = this.appIdNameMap.get(appId);
            }
            if (StringUtils.isEmpty((String)appName)) {
                appName = (String)allAppIdNameMap.get(appId);
            }
            this.appNodeNameMap.put(appId, appName);
            if (cloudSetNotEmpty && disabledCloudIds.contains(cloudId) || appSetNotEmpty && disabledAppIds.contains(appId)) continue;
            TreeNode treeNode = (TreeNode)cloudNodes.get(cloudId);
            if (treeNode == null) {
                treeNode = new TreeNode("-1", "cloud#" + cloudId, cloudName, true);
                cloudNodes.put(cloudId, treeNode);
                rootNode.addChild(treeNode);
            }
            TreeNode children = new TreeNode(treeNode.getId(), "app#" + appId + "|" + cloudId, appName, false);
            treeNode.addChild(children);
            dataSource.put(cloudId + '|' + appId, appName);
        }
        tv.addNode(rootNode);
        this.getPageCache().put("appLeftSource", SerializationUtils.toJsonString(dataSource));
        this.getPageCache().put("appNodeNameMap", SerializationUtils.toJsonString(this.appNodeNameMap));
    }

    private void buildSelectedOrgTree(Long adminGroupId, String orgViewType, long level) {
        List<String> orgData;
        String treeNodeRootCache;
        String originOrgDataCacheKey;
        String currentOrgDataCacheKey;
        String rootNodeText;
        String selTreeKey;
        boolean isBizTree = false;
        if (orgViewType.equals("15")) {
            selTreeKey = "selectedorgtree";
            rootNodeText = this.getSelBizUnitRootText();
            currentOrgDataCacheKey = adminGroupId + "_current_BizDatas";
            originOrgDataCacheKey = adminGroupId + "_BizDatas";
            treeNodeRootCache = "orgTreeRightRoot";
            isBizTree = true;
        } else {
            selTreeKey = "selectedadminorgtree";
            rootNodeText = this.getSelAdminOrgRootNodeText();
            currentOrgDataCacheKey = adminGroupId + "_current_AdminOrgDatas";
            originOrgDataCacheKey = adminGroupId + "_AdminOrgDatas";
            treeNodeRootCache = "AdminOrgTreeRightRoot";
        }
        TreeView tree = (TreeView)this.getControl(selTreeKey);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        if (level == 1L) {
            root.setText(this.getVirtualRightRootText());
            tree.addNode(root);
            this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)root));
            return;
        }
        root.setText(rootNodeText);
        String orgDataStr = this.getPageCache().get(currentOrgDataCacheKey);
        if (StringUtils.isNotEmpty((String)orgDataStr)) {
            orgData = SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class);
        } else {
            orgData = this.queryOrgLongNumberByAdminGroupId(adminGroupId, orgViewType, false);
            this.getPageCache().put(originOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
            this.getPageCache().put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
        }
        int size = orgData.size();
        int i = 0;
        String lastLongNumber = "_";
        String firstOrgNodeId = null;
        for (String data : orgData) {
            String[] orgDataArr = data.split("_split_");
            if (orgDataArr.length < 5) {
                ++i;
                continue;
            }
            String orgId = orgDataArr[0];
            String orgName = orgDataArr[1];
            String orgLongNumber = orgDataArr[2];
            if (null == orgId || orgLongNumber.startsWith(lastLongNumber + " ") || orgLongNumber.equals(lastLongNumber)) {
                ++i;
                continue;
            }
            TreeNode newNode = new TreeNode();
            newNode.setParentid("-1");
            newNode.setId(orgId);
            if (isBizTree && Boolean.parseBoolean(orgDataArr[3])) {
                newNode.setIcon("kdfont kdfont-faren");
            }
            newNode.setText(orgName);
            if (firstOrgNodeId == null) {
                firstOrgNodeId = orgId;
            }
            if (i + 1 < size) {
                String nextOrgData = orgData.get(i + 1);
                String[] orgDataArrNext = nextOrgData.split("_split_");
                if (orgDataArrNext.length < 5) continue;
                String nextLongNumber = orgDataArrNext[2];
                if (nextLongNumber.startsWith(orgLongNumber + " ")) {
                    newNode.addChildren(new ArrayList(10));
                }
            }
            lastLongNumber = orgLongNumber;
            root.addChild(newNode);
            ++i;
        }
        if (size == 0) {
            root.setText(this.getCommonRootText());
        }
        tree.addNode(root);
        this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)root));
        if (StringUtils.isNotEmpty(firstOrgNodeId)) {
            tree.queryTreeNodeChildren("-1", firstOrgNodeId);
            tree.expand(firstOrgNodeId);
        }
    }

    private String getSelectAppRootNodeText() {
        return ResManager.loadKDString((String)"\u5df2\u9009\u5e94\u7528", (String)"AdminGroupPermPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getAppRootNodeText() {
        return ResManager.loadKDString((String)"\u5f85\u9009\u5e94\u7528", (String)"AdminGroupPermPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getSelAdminOrgRootNodeText() {
        return ResManager.loadKDString((String)"\u5df2\u9009\u884c\u653f\u7ec4\u7ec7", (String)"AdminGroupPermPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getSelBizUnitRootText() {
        return ResManager.loadKDString((String)"\u5df2\u9009\u4e1a\u52a1\u5355\u5143", (String)"AdminGroupPermPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getCommonRootText() {
        return ResManager.loadKDString((String)"\u540c\u4e0a\u7ea7\u7ba1\u7406\u5458\u8303\u56f4", (String)"AdminGroupPermPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getVirtualRightRootText() {
        return ResManager.loadKDString((String)"\u9876\u7ea7\u7ba1\u7406\u5458\u8303\u56f4\u4e0e\u5de6\u4fa7\u4e00\u81f4", (String)"AdminGroupPermPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getSelectSysRootNodeText() {
        return ResManager.loadKDString((String)"\u5df2\u5206\u914d\u6743\u9650", (String)"AdminGroupPermPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getSysRootNodeText() {
        return ResManager.loadKDString((String)"\u53ef\u5206\u914d\u6743\u9650", (String)"AdminGroupPermPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getBizUnitRootNodeText() {
        return ResManager.loadKDString((String)"\u5f85\u9009\u4e1a\u52a1\u5355\u5143", (String)"AdminGroupPermPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getAdminOrgRootNodeText() {
        return ResManager.loadKDString((String)"\u5f85\u9009\u884c\u653f\u7ec4\u7ec7", (String)"AdminGroupPermPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getSearchTips() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5927\u4e8e1000\u6761\uff0c\u8bf7\u5b8c\u5584\u641c\u7d22\u5173\u952e\u5b57\u3002", (String)"AdminGroupPermPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private void initUnitTree(String viewType, Long adminGroupParentId, Long level) {
        if (level <= 2L) {
            this.initUnitTreeSuper(viewType);
        } else {
            this.initUnitTreeNormal(viewType, adminGroupParentId, level - 1L);
        }
    }

    private void initUnitTreeNormal(String viewType, Long adminGroupParentId, Long level) {
        String currentOrgDataCacheKey = "15".equals(viewType) ? adminGroupParentId + "_current_BizDatas" : adminGroupParentId + "_current_AdminOrgDatas";
        List<String> orgData = null;
        Long currentGroupId = adminGroupParentId;
        while (level > 1L && CollectionUtils.isEmpty(orgData = this.queryOrgLongNumberByAdminGroupId(currentGroupId, viewType, true))) {
            DynamicObject adminGroup = BusinessDataServiceHelper.loadSingle((String)"perm_admingroup", (String)"id, parent ,level", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentGroupId)});
            currentGroupId = adminGroup.getLong("parent.id");
            level = adminGroup.getLong("level") - 1L;
        }
        if (level == 1L && CollectionUtils.isEmpty(orgData)) {
            this.initUnitTreeSuper(viewType);
        } else {
            this.getPageCache().put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
            this.loadUnitTree(viewType, orgData);
        }
    }

    private void loadUnitTree(String viewType, List<String> orgData) {
        String rootNodeCacheKey;
        String errorMsg;
        String rootNodeText;
        String treeViewKey;
        boolean isBizTree = false;
        if ("15".equals(viewType)) {
            treeViewKey = "orgtree";
            rootNodeText = this.getBizUnitRootNodeText();
            errorMsg = ResManager.loadKDString((String)"\u90e8\u5206\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermPlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rootNodeCacheKey = "orgTreeLeftRoot";
            isBizTree = true;
        } else {
            treeViewKey = "adminorgtree";
            rootNodeText = this.getAdminOrgRootNodeText();
            errorMsg = ResManager.loadKDString((String)"\u90e8\u5206\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rootNodeCacheKey = "AdminOrgTreeLeftRoot";
        }
        TreeView tv = (TreeView)this.getControl(treeViewKey);
        tv.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId("-1");
        root.setText(rootNodeText);
        root.setIsOpened(true);
        int size = orgData.size();
        int i = 0;
        String lastLongNumber = "";
        String longNumber = "";
        for (String data : orgData) {
            String[] orgDataArr = data.split("_split_");
            if (orgDataArr.length < 5) {
                ++i;
                continue;
            }
            longNumber = orgDataArr[2];
            if (StringUtils.isEmpty((String)longNumber)) {
                ++i;
                continue;
            }
            if (longNumber.equals(lastLongNumber) || longNumber.startsWith(lastLongNumber + " ")) {
                ++i;
                continue;
            }
            lastLongNumber = longNumber;
            TreeNode childNode = new TreeNode();
            childNode.setText(orgDataArr[1]);
            childNode.setParentid("-1");
            childNode.setId(orgDataArr[0]);
            if (isBizTree && Boolean.parseBoolean(orgDataArr[3])) {
                childNode.setIcon("kdfont kdfont-faren");
            }
            if (i + 1 < size) {
                String[] orgDataArrNext = orgData.get(i + 1).split("_split_");
                if (orgDataArrNext.length < 5) continue;
                String nextLongNumber = orgDataArrNext[2];
                if (StringUtils.isEmpty((String)nextLongNumber)) {
                    this.getView().showTipNotification(errorMsg, Integer.valueOf(2000));
                    return;
                }
                if (nextLongNumber.startsWith(longNumber + " ")) {
                    childNode.setChildren(new ArrayList(10));
                }
            }
            root.addChild(childNode);
            ++i;
        }
        this.getPageCache().put(rootNodeCacheKey, SerializationUtils.toJsonString((Object)root));
        tv.addNode(root);
        String firstNodeId = null;
        List childNodes = root.getChildren();
        if (!CollectionUtils.isEmpty((Collection)childNodes)) {
            firstNodeId = ((TreeNode)childNodes.get(0)).getId();
        }
        if (StringUtils.isNotEmpty(firstNodeId)) {
            tv.queryTreeNodeChildren("-1", firstNodeId);
            tv.expand(firstNodeId);
        }
    }

    private void initUnitTreeSuper(String viewType) {
        String currentOrgDataCacheKey = "15".equals(viewType) ? "0_current_BizDatas" : "0_current_AdminOrgDatas";
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewId(Long.parseLong(viewType));
        param.setIncludeDisable(false);
        param.setIncludeFreeze(false);
        TreeNode firstOrgNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (firstOrgNode == null) {
            if ("15".equals(viewType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u5355\u5143\u6839\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e1a\u52a1\u5355\u5143\u89c6\u56fe\u662f\u5426\u6b63\u786e\u3002", (String)"AdminGroupPermPlugin_14", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6839\u8282\u70b9\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u4fee\u590d\u6570\u636e\u3002", (String)"AdminGroupPermPlugin_15", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        List<String> orgData = this.queryOrgLongNumberByAdminGroupId(0L, viewType, true);
        this.getPageCache().put(viewType + "_super", "true");
        this.getPageCache().put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
        this.loadUnitTree(viewType, orgData);
    }

    private void initSysRightTree(Long adminGroupId, Long level) {
        TreeView sysTvRight = (TreeView)this.getControl("selectedsystree");
        sysTvRight.deleteAllNodes();
        TreeNode rootNode = null;
        IPageCache pageCache = this.getPageCache();
        boolean isShowNum = Boolean.parseBoolean(this.getPageCache().get("shownum"));
        String rootNodeStr = pageCache.get("sysTreeRightRoot");
        if (StringUtils.isNotEmpty((String)rootNodeStr) && !isShowNum) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            sysTvRight.addNode(rootNode);
            return;
        }
        HashMap<String, String> dataSource = null;
        String sysRightSourceStr = pageCache.get("sysRightSource");
        if (StringUtils.isNotEmpty((String)sysRightSourceStr)) {
            dataSource = (HashMap<String, String>)SerializationUtils.fromJsonString((String)sysRightSourceStr, Map.class);
        }
        if (null != dataSource && !dataSource.isEmpty()) {
            TreeView tv = (TreeView)this.getControl("selectedsystree");
            LinkedHashSet<String> rightTreeData = new LinkedHashSet<String>(16);
            for (Map.Entry entry : dataSource.entrySet()) {
                AdminGroupSysSearchBean bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)((String)entry.getValue()), AdminGroupSysSearchBean.class);
                for (String permItem : bean.getPermItems()) {
                    rightTreeData.add((String)entry.getKey() + '|' + permItem);
                }
            }
            tv.deleteAllNodes();
            this.getSelectPermRootNode(tv, rightTreeData, this.getSelectSysRootNodeText(), false);
            return;
        }
        if (level <= 1L) {
            rootNode = this.getVirtualRightRootNode();
        } else {
            String entityNum = "";
            String lastAppEnt = "";
            String lastEntityNum = "";
            ArrayList<String> entityPermItems = new ArrayList<String>(10);
            LinkedHashSet<String> groupPerm = new LinkedHashSet<String>(16);
            dataSource = new HashMap<String, String>(100);
            LinkedHashSet<String> adminGroupPerm = new LinkedHashSet<String>(100);
            try (DataSet permDS = AdminGroupPermPlugin.getPermDS(adminGroupId);
                 DataSet appDS = AdminGroupPermPlugin.getAppDS();
                 DataSet permDS2 = permDS.leftJoin(appDS).on("app_id", "app_id").select(new String[]{"app_id", "entity_num", "fpermitemid"}, new String[]{"app_num", "app_seq", "cloudId"}).finish().orderBy(new String[]{"app_seq", "app_num", "entity_num"});
                 DataSet beforeFinalDS = DB.queryDataSet((String)"initSysRightTree.beforeFinalDS", (DBRoute)DBRoute.meta, (String)"SELECT fseq cloudSeq, fid cloudId FROM  t_meta_bizcloud ");
                 DataSet permDS3 = permDS2.leftJoin(beforeFinalDS).on("cloudId", "cloudId").select(new String[]{"app_id", "entity_num", "fpermitemid", "app_num", "app_seq"}, new String[]{"cloudSeq"}).finish().orderBy(new String[]{"cloudSeq", "app_seq", "app_num", "entity_num", "fpermitemid"});){
                while (permDS3.hasNext()) {
                    Row row = permDS3.next();
                    String appId = row.getString("app_id");
                    if (StringUtils.isEmpty((String)appId)) continue;
                    adminGroupPerm.add(appId + "|" + row.getString("entity_num") + "|" + row.getString("fpermitemid"));
                }
            }
            if (adminGroupPerm.size() > 0) {
                Set entNumColle = adminGroupPerm.stream().map(perm -> {
                    String[] info = perm.split("\\|");
                    return info[1];
                }).collect(Collectors.toSet());
                Map entityNameMap = FormHelper.getEntityNameMap(new ArrayList(entNumColle), (String)RequestContext.get().getLang().name());
                for (String perm2 : adminGroupPerm) {
                    String[] info = perm2.split("\\|");
                    String appId = info[0];
                    entityNum = info[1];
                    String permitemId = info[2];
                    if (!lastAppEnt.equals(appId + "|" + entityNum)) {
                        if (!CollectionUtils.isEmpty(entityPermItems)) {
                            String entityName = this.sysNodeNameMap.get(lastEntityNum);
                            if (StringUtils.isEmpty((String)entityName)) {
                                entityName = lastEntityNum;
                            }
                            AdminGroupSysSearchBean bean = new AdminGroupSysSearchBean(lastAppEnt, entityName, entityPermItems);
                            dataSource.putIfAbsent(lastAppEnt, SerializationUtils.toJsonString((Object)bean));
                            entityPermItems.clear();
                        }
                        lastAppEnt = appId + "|" + entityNum;
                        lastEntityNum = entityNum;
                    }
                    entityPermItems.add(permitemId);
                    String permKey = appId + "|" + entityNum + "|" + permitemId;
                    groupPerm.add(permKey);
                }
                if (!CollectionUtils.isEmpty(entityPermItems)) {
                    AdminGroupSysSearchBean bean = new AdminGroupSysSearchBean(lastAppEnt, null == this.sysNodeNameMap.get(entityNum) ? (String)entityNameMap.get(entityNum) : this.sysNodeNameMap.get(entityNum), entityPermItems);
                    dataSource.putIfAbsent(lastAppEnt, SerializationUtils.toJsonString((Object)bean));
                }
                rootNode = this.getSelectPermRootNode(sysTvRight, groupPerm, this.getSelectSysRootNodeText(), false);
            } else {
                rootNode = this.getCommonRightRootNode();
            }
            this.getPageCache().put("sysRightSource", SerializationUtils.toJsonString(dataSource));
            this.getPageCache().put("Current_SysData", SerializationUtils.toJsonString(groupPerm));
            this.getPageCache().put("Origin_SysData", SerializationUtils.toJsonString(groupPerm));
        }
        rootNode.setIsOpened(true);
        List childrenNodes = rootNode.getChildren();
        if (childrenNodes != null && !childrenNodes.isEmpty()) {
            for (TreeNode tn : childrenNodes) {
                if (tn == null) continue;
                tn.setIsOpened(true);
            }
        }
        sysTvRight.addNode(rootNode);
        this.getView().getPageCache().put("sysTreeRightRoot", SerializationUtils.toJsonString((Object)rootNode));
    }

    private static DataSet getAppDS() {
        String appSql = " SELECT fid app_id, fnumber app_num, fseq app_seq, fbizcloudid cloudId FROM t_meta_bizapp ";
        return DB.queryDataSet((String)"initSysRightTree.queryAppInfo", (DBRoute)DBRoute.meta, (String)appSql, null);
    }

    private static DataSet getPermDS(Long adminGroupId) {
        String permSql = " SELECT fappid app_id, fentitynum entity_num, fpermitemid FROM t_perm_admingroupfunperm WHERE fusergroupid = ? ";
        return DB.queryDataSet((String)"initSysRightTree.querySeletedPerm", (DBRoute)DBRoute.permission, (String)permSql, (Object[])new Object[]{adminGroupId});
    }

    private TreeNode getCommonRightRootNode() {
        return new TreeNode("", "-1", this.getCommonRootText(), false);
    }

    private TreeNode getVirtualRightRootNode() {
        return new TreeNode("", "-1", this.getVirtualRightRootText(), false);
    }

    private void initSysLeftTree(Long adminGroupId, Long level) {
        TreeView tv = (TreeView)this.getControl("systree");
        boolean showNum = "true".equals(this.getPageCache().get("shownum"));
        tv.deleteAllNodes();
        IPageCache pageCache = this.getPageCache();
        String rootNodeStr = pageCache.get("sysTreeLeftRoot");
        if (StringUtils.isNotEmpty((String)rootNodeStr) && !showNum) {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            tv.addNode(rootNode);
            return;
        }
        String langStr = RequestContext.get().getLang().name();
        DynamicObject adminGroup = (DynamicObject)this.getModel().getValue("usergroup");
        long adminScheme = adminGroup.getLong("adminscheme.id");
        long adminType = adminGroup.getLong("admintype.id");
        long domainId = adminGroup.getLong("domain.id");
        if (level <= 2L) {
            this.initSysLeftTreeSuper(tv, adminScheme, adminType, langStr, domainId);
        } else {
            this.initSysLeftTreeNormal(tv, adminScheme, adminType, langStr, adminGroupId);
        }
    }

    private void initSysLeftTreeNormal(TreeView tv, long adminScheme, long adminType, String langStr, Long adminGroupId) {
        AdminGroupSysSearchBean adminGroupSysSearchBean;
        DynamicObject adminGroup;
        long parent;
        long level = 3L;
        long domainId = 0L;
        Set<String> adminGroupPerm = null;
        while (level > 2L && (adminGroupPerm = this.getAdminGroupPermByParent(parent = (adminGroup = QueryServiceHelper.queryOne((String)"perm_admingroup", (String)"id, parent, level, domain_id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)adminGroupId)})).getLong("parent"))).size() <= 0) {
            level = adminGroup.getLong("level") - 1L;
            adminGroupId = adminGroup.getLong("parent");
            domainId = adminGroup.getLong("domain_id");
        }
        if (level <= 2L) {
            this.initSysLeftTreeSuper(tv, adminScheme, adminType, langStr, domainId);
            return;
        }
        boolean showNum = "true".equals(this.getPageCache().get("shownum"));
        LinkedHashMap<String, String> dataSource = new LinkedHashMap<String, String>(adminGroupPerm.size());
        String entityName = "";
        String lastAppEnt = "";
        String lastEntityName = "";
        ArrayList<String> entityPermItems = new ArrayList<String>(10);
        LinkedHashSet<String> groupPerm = new LinkedHashSet<String>(16);
        Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
        boolean cloudSetNotEmpty = null != disabledCloudIds && !disabledCloudIds.isEmpty();
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        boolean appSetNotEmpty = null != disabledAppIds && !disabledAppIds.isEmpty();
        HashMap formShowOnTreeStatusMap = new HashMap(8);
        HashMap<String, String> formShowOnTreeStatusParaMap = new HashMap<String, String>(8);
        formShowOnTreeStatusParaMap.put("dimension", "DIM_ORG");
        formShowOnTreeStatusParaMap.put("dimDiffHide", "1");
        PermCommonUtil.getFormShowOnTreeStatusMap(formShowOnTreeStatusParaMap, formShowOnTreeStatusMap);
        Set appIdSet = adminGroupPerm.stream().map(x -> x.split("\\|")[0]).collect(Collectors.toSet());
        Map cloudAppIdMap = AppHelper.getCloudAppIdMap(appIdSet);
        Map allUserAppEntMap = AppHelper.getAllUserAppEntMap();
        HashSet allUserAppIdSet = new HashSet(PermCommonUtil.getAllUserAppIds());
        for (String perm : adminGroupPerm) {
            String permitemName;
            String permitemId;
            String permItemNum;
            Set allUserAppEntSet;
            String entityNum;
            String appName;
            String[] info = perm.split("\\|");
            String appId = info[0];
            if (appSetNotEmpty && disabledAppIds.contains(appId)) continue;
            String cloudId = (String)cloudAppIdMap.get(appId);
            if (cloudSetNotEmpty && disabledCloudIds.contains(cloudId)) continue;
            String appNum = this.appIdNumberMap.get(appId);
            if (StringUtils.isEmpty((String)appNum)) {
                appNum = appId + "(NotFound)";
            }
            if (StringUtils.isEmpty((String)(appName = this.appIdNameMap.get(appId)))) {
                appName = appId + "(NotFound)";
            }
            if ("false".equals(formShowOnTreeStatusMap.get(entityNum = info[1])) || allUserAppIdSet.contains(appId) && (null == (allUserAppEntSet = (Set)allUserAppEntMap.get(appId)) || allUserAppEntSet.isEmpty() || !allUserAppEntSet.contains(entityNum))) continue;
            entityName = this.entityNumNameMap.get(entityNum);
            if (StringUtils.isEmpty((String)entityName)) {
                entityName = entityNum + "(NotFound)";
            }
            if (StringUtils.isEmpty((String)(permItemNum = this.permItemIdNumberMap.get(permitemId = info[2])))) {
                permItemNum = permitemId + "(NotFound)";
            }
            if (StringUtils.isEmpty((String)(permitemName = this.permItemIdNameMap.get(permitemId)))) {
                permitemName = permitemId + "(NotFound)";
            }
            if (!lastAppEnt.equals(appId + "|" + entityNum)) {
                if (!CollectionUtils.isEmpty(entityPermItems)) {
                    adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, lastEntityName, entityPermItems);
                    dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
                    entityPermItems.clear();
                }
                lastAppEnt = appId + "|" + entityNum;
                lastEntityName = entityName;
            }
            entityPermItems.add(permitemId);
            if (showNum) {
                appName = appName + "(" + appNum + ")";
                entityName = entityName + "(" + entityNum + ")";
                permitemName = permitemName + "(" + permItemNum + ")";
                this.sysNodeNameNumMap.putIfAbsent(appId, appName);
                this.sysNodeNameNumMap.putIfAbsent(entityNum, entityName);
                this.sysNodeNameNumMap.putIfAbsent(permitemId, permitemName);
            } else {
                this.sysNodeNameMap.putIfAbsent(appId, appName);
                this.sysNodeNameMap.putIfAbsent(entityNum, entityName);
                this.sysNodeNameMap.putIfAbsent(permitemId, permitemName);
            }
            String permKey = appId + "|" + entityNum + "|" + permitemId;
            groupPerm.add(permKey);
        }
        if (!CollectionUtils.isEmpty(entityPermItems)) {
            adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, entityName, entityPermItems);
            dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
        }
        this.getPageCache().put("sysLeftSource", SerializationUtils.toJsonString(dataSource));
        this.getPageCache().put("sysNodeNameMap", SerializationUtils.toJsonString(this.sysNodeNameMap));
        this.getPageCache().put("sysNodeNameNumMap", SerializationUtils.toJsonString(this.sysNodeNameNumMap));
        TreeNode rootNode = this.getSelectPermRootNode(tv, groupPerm, this.getSysRootNodeText(), false);
        this.getPageCache().putBigObject("sysTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
    }

    /*
     * Exception decompiling
     */
    private Set<String> getAdminGroupPermByParent(long parent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TreeNode getSelectPermRootNode(TreeView tv, Set<String> adminGroupPerm, String rootName, boolean searchMode) {
        TreeNode rootNode = new TreeNode("", "-1", rootName, true);
        rootNode.setIsOpened(true);
        tv.addNode(rootNode);
        boolean showNum = "true".equals(this.getPageCache().get("shownum"));
        String firstCloud = "";
        HashSet<String> cloudIds = new HashSet<String>(16);
        HashSet<String> appIds = new HashSet<String>(16);
        HashSet<String> entityIds = new HashSet<String>(16);
        TreeNode cloudNode = null;
        TreeNode appNode = null;
        TreeNode entityNode = null;
        Map allAppIdNameMap = AppHelper.getAllAppIdNameMap();
        Map allAppIdNumberMap = AppHelper.getAllAppIdNumberMap();
        int size = adminGroupPerm.size();
        Set<PermItem> permItemSet = AdminGroupPermPlugin.getPermItemSet(adminGroupPerm, size);
        List permItemList = permItemSet.stream().sorted(Comparator.comparing(Cloud::getCloudSeq, Comparator.nullsLast(Integer::compareTo)).thenComparing(App::getAppSeq, Comparator.nullsLast(Integer::compareTo)).thenComparing(App::getAppNumber, Comparator.nullsLast(String::compareTo)).thenComparing(Entity::getEntityNumber, Comparator.nullsLast(String::compareTo))).collect(Collectors.toList());
        LinkedHashMap<String, PermItem> perItemMap = new LinkedHashMap<String, PermItem>(8);
        for (PermItem permItem : permItemList) {
            perItemMap.put(permItem.getAppId() + "|" + permItem.getEntityNumber(), permItem);
        }
        Map allCloudIdNameMap = CloudHelper.getAllCloudIdNameMap();
        for (Map.Entry perItem : perItemMap.entrySet()) {
            String key = (String)perItem.getKey();
            for (String perm : adminGroupPerm) {
                String permitemName;
                String[] cloudInfo;
                String cloudId;
                String[] ids = perm.split("\\|");
                String appId = ids[0];
                String entityId = ids[1];
                if (!Objects.equals(key, appId + "|" + entityId)) continue;
                String cloudInfoStr = this.appCloudInfoMap.get(appId);
                if (cloudInfoStr == null) {
                    cloudId = "unknown";
                    cloudInfo = new String[]{cloudId, cloudId, ResManager.loadKDString((String)"\u5f02\u5e38\u6570\u636e\u8bf7\u52ff\u5206\u914d", (String)"AdminGroupPermPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0])};
                } else {
                    cloudInfo = cloudInfoStr.split("\\|");
                    cloudId = cloudInfo[0];
                }
                if (cloudIds.contains(cloudId)) {
                    cloudNode = rootNode.getTreeNode("cloud#" + cloudId, 100);
                } else {
                    cloudIds.add(cloudId);
                    String cloudNumber = cloudInfo[1];
                    String cloudName = (String)allCloudIdNameMap.get(cloudId);
                    if (StringUtils.isEmpty((String)cloudName) || Objects.equals("null", cloudName)) {
                        cloudName = StringUtils.isEmpty((String)cloudNumber) ? cloudId : cloudNumber;
                    } else if (showNum) {
                        cloudName = StringUtils.isEmpty((String)cloudNumber) ? cloudName + '(' + cloudId + ')' : cloudName + '(' + cloudNumber + ')';
                    }
                    cloudNode = new TreeNode("-1", "cloud#" + cloudId, cloudName, true);
                    if (StringUtils.isEmpty((String)firstCloud)) {
                        firstCloud = cloudId;
                        cloudNode.setIsOpened(true);
                    }
                    if (searchMode) {
                        cloudNode.setIsOpened(true);
                    }
                    cloudNode.setIsOpened(true);
                    rootNode.addChild(cloudNode);
                }
                String appName = (String)allAppIdNameMap.get(appId);
                String appNum = (String)allAppIdNumberMap.get(appId);
                if (StringUtils.isEmpty((String)appName)) {
                    appName = appId + "(NotFound)";
                } else if (showNum) {
                    appName = appName + "(" + appNum + ")";
                }
                String entName = this.entityNumNameMap.get(entityId);
                String sysNodeNameNum_EntName = this.sysNodeNameNumMap.get(entityId);
                sysNodeNameNum_EntName = StringUtils.isEmpty((String)sysNodeNameNum_EntName) ? entName : sysNodeNameNum_EntName;
                String sysNodeNameEntName = this.sysNodeNameMap.get(entityId);
                String string = sysNodeNameEntName = StringUtils.isEmpty((String)sysNodeNameEntName) ? entName : sysNodeNameEntName;
                String entityName = showNum ? (StringUtils.isEmpty((String)sysNodeNameNum_EntName) ? entityId + "(NotFound)" : sysNodeNameNum_EntName) : (StringUtils.isEmpty((String)sysNodeNameEntName) ? entityId + "(NotFound)" : sysNodeNameEntName);
                String permitemId = ids[2];
                String string2 = showNum ? (StringUtils.isEmpty((String)this.sysNodeNameNumMap.get(permitemId)) ? permitemId + "(NotFound)" : this.sysNodeNameNumMap.get(permitemId)) : (permitemName = StringUtils.isEmpty((String)this.sysNodeNameMap.get(permitemId)) ? permitemId + "(NotFound)" : this.sysNodeNameMap.get(permitemId));
                if (appIds.contains(appId)) {
                    appNode = cloudNode.getTreeNode("app#" + appId, 100);
                } else {
                    appIds.add(appId);
                    appNode = new TreeNode("cloud#83bfebc800000bac", "app#" + appId, appName, true);
                    if (searchMode) {
                        appNode.setIsOpened(true);
                    }
                    cloudNode.addChild(appNode);
                }
                if (entityIds.contains(entityId + "@" + appId)) {
                    entityNode = appNode.getTreeNode("entity#" + entityId + "@" + appId, 100);
                } else {
                    entityIds.add(entityId + "@" + appId);
                    entityNode = new TreeNode("app#" + appId, "entity#" + entityId + "@" + appId, entityName, true);
                    appNode.addChild(entityNode);
                }
                TreeNode permItemNode = new TreeNode("entity#" + entityId + "@" + appId, "permitem#" + permitemId + "@" + entityId + "|" + appId, permitemName);
                entityNode.addChild(permItemNode);
            }
        }
        return rootNode;
    }

    private static Set<PermItem> getPermItemSet(Set<String> adminGroupPerm, int size) {
        HashSet<String> appIdSet = new HashSet<String>(size);
        HashSet<String> entNumSet = new HashSet<String>(size);
        for (String perm : adminGroupPerm) {
            String[] ids = perm.split("\\|");
            String appId = ids[0];
            appIdSet.add(appId);
            String entityId = ids[1];
            entNumSet.add(entityId);
        }
        Map cloudMap = CloudHelper.getCloudMap(appIdSet);
        Map appMap = AppHelper.getAppMap(appIdSet);
        Map entityInfoMap = FormHelper.getEntityInfoMap(entNumSet);
        HashSet<PermItem> permItemSet = new HashSet<PermItem>(size);
        PermItem permItem = null;
        for (String perm : adminGroupPerm) {
            String[] ids = perm.split("\\|");
            String appId = ids[0];
            String entityId = ids[1];
            permItem = new PermItem();
            Cloud cloud = (Cloud)cloudMap.get(appId);
            if (null != cloud) {
                permItem.setCloudId(cloud.getCloudId());
                permItem.setCloudNumber(cloud.getCloudNumber());
                permItem.setCloudSeq(cloud.getCloudSeq());
                permItem.setCloudName(cloud.getCloudName());
            }
            App app = (App)appMap.get(appId);
            permItem.setAppId(appId);
            if (null != app) {
                permItem.setAppNumber(app.getAppNumber());
                permItem.setAppSeq(app.getAppSeq());
                permItem.setAppName(app.getAppName());
            }
            permItem.setEntityNumber(entityId);
            kd.bos.permission.model.perm.Entity entity = (kd.bos.permission.model.perm.Entity)entityInfoMap.get(entityId);
            if (null != entity) {
                permItem.setEntityName(entity.getEntityName());
            }
            permItemSet.add(permItem);
        }
        return permItemSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSysLeftTreeSuper(TreeView tv, long adminScheme, long adminType, String langStr, long domainId) {
        String selectEntryIdSql = " SELECT fentryid From t_perm_adminschemeentry where fid = ? AND fadmintype = ? ";
        Long entryId = (Long)DB.query((DBRoute)DBRoute.permission, (String)selectEntryIdSql, (Object[])new Object[]{adminScheme, adminType}, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long entryId = null;
                while (rs.next() && (entryId = Long.valueOf(rs.getLong("fentryid"))) == null) {
                }
                return entryId;
            }
        });
        boolean showNum = "true".equals(this.getPageCache().get("shownum"));
        TreeNode rootNode = new TreeNode("", "-1", this.getSysRootNodeText(), true);
        rootNode.setIsOpened(true);
        tv.addNode(rootNode);
        DataSet hasPermEntityDS = null;
        DataSet appDS = null;
        DataSet publishAppIdDSEntNum = null;
        DataSet appIdEntNum2 = null;
        DataSet hasPermEntityAppDS = null;
        DataSet entityDS = null;
        DataSet hasPermEntityEntityDS = null;
        DataSet funcPermDS = null;
        DataSet beforeFinalDS = null;
        DataSet finalDS = null;
        try {
            AdminGroupSysSearchBean adminGroupSysSearchBean;
            block80: {
                boolean superAdminStrategy = PermCommonUtil.isSuperAdminStrategy();
                if (superAdminStrategy) {
                    try (DataSet appIdEntNum = DB.queryDataSet((String)"AdminGroupPermPlugin.initSysLeftTreeSuper.bizunitrelform", (DBRoute)DBRoute.meta, (String)("select a.fbizappid app_id, b.fnumber entity_num " + " from t_meta_bizunitrelform a " + " inner JOIN t_meta_entitydesign b on a.fformid = b.fid " + " inner join t_meta_bizapp c on c.fid =a.fbizappid " + " where c.fbizcloudid in('83bfebc800000bac', '0QLCSO6KKZC9') ")).distinct();
                         DataSet publishAppIdDSEntNumOri = DB.queryDataSet((String)"AdminGroupPermPlugin.initSysLeftTreeSuper.bizobjapp", (DBRoute)DBRoute.permission, (String)"SELECT fbizappid app_id, fbizobjid entity_num FROM t_perm_bizobjapp ");
                         DataSet someAppDs = DB.queryDataSet((String)"AdminGroupPermPlugin.initSysLeftTreeSuper.someAppDs", (DBRoute)DBRoute.meta, (String)"SELECT fid appId FROM t_meta_bizapp where fbizcloudid in('83bfebc800000bac', '0QLCSO6KKZC9') ");
                         DataSet functionPerm = DB.queryDataSet((String)"AdminGroupPermPlugin.initSysLeftTreeSuper.functionPerm", (DBRoute)DBRoute.permission, (String)"SELECT fentitytypeid entity_num, fpermitemid permitem FROM t_perm_functionperm ");){
                        publishAppIdDSEntNum = publishAppIdDSEntNumOri.join(someAppDs).on("app_id", "appId").select(new String[]{"app_id", "entity_num"}).finish().distinct();
                        appIdEntNum2 = appIdEntNum.union(publishAppIdDSEntNum);
                        String appIdSqlStr = AdminSchemeHelper.queryAllSysAppSqlStr((boolean)false, (boolean)true, (boolean)true);
                        StringBuilder sbSelectAppSql = new StringBuilder(" SELECT app.fid app_id, app.fnumber app_num, ").append("case when l.fname is null or l.fname = '' or l.fname = ' ' ").append("then l2.fname ").append("else l.fname ").append("end app_name, ").append("al.fname app_runtimename, app.fseq app_seq, app.fbizcloudid cloudId ").append("FROM t_meta_bizapp app ").append(" LEFT JOIN t_meta_bizapp_l l ON (app.fid = l.fid and l.flocaleid = '").append(langStr).append("') ").append(" LEFT JOIN t_meta_bizapp_l l2 ON (app.fid = l2.fid and l2.flocaleid = 'zh_CN') ").append(" LEFT JOIN t_meta_appruntime_l al ON (app.fnumber = al.fappid and al.flocaleid = '").append(langStr).append("') ").append(" WHERE app.fdeploystatus = '2' AND app.fbizcloudid in('83bfebc800000bac', '0QLCSO6KKZC9')  ");
                        if (StringUtils.isNotEmpty((String)appIdSqlStr)) {
                            sbSelectAppSql.append(" and app.fid in(").append(appIdSqlStr).append(") ");
                        }
                        appDS = DB.queryDataSet((String)"AdminGroupPermPlugin.initSysLeftTreeSuper.appDS", (DBRoute)DBRoute.meta, (String)sbSelectAppSql.toString());
                        hasPermEntityAppDS = appIdEntNum2.join(appDS).on("app_id", "app_id").select(new String[]{"app_id", "entity_num"}, new String[]{"app_num", "app_name", "app_runtimename", "app_seq", "cloudId"}).finish();
                        hasPermEntityAppDS = hasPermEntityAppDS.join(functionPerm).on("entity_num", "entity_num").select(new String[]{"app_id", "entity_num", "app_num", "app_name", "app_runtimename", "app_seq", "cloudId"}, new String[]{"permitem"}).finish();
                        break block80;
                    }
                }
                String selectHasPermEntitySql = " SELECT fbizappid app_id, fentitynum entity_num, fpermitemid permitem FROM t_perm_adminschemedetail WHERE fentryid = ? ";
                hasPermEntityDS = DB.queryDataSet((String)"hasPermEntityDS", (DBRoute)DBRoute.permission, (String)selectHasPermEntitySql, (Object[])new Object[]{entryId});
                String selectAppSql = " SELECT app.fid app_id, app.fnumber app_num, l.fname app_name, al.fname app_runtimename, app.fseq app_seq,  app.fbizcloudid cloudId  FROM t_meta_bizapp app  LEFT JOIN t_meta_bizapp_l l ON (app.fid = l.fid and l.flocaleid = '" + langStr + "')  LEFT JOIN t_meta_appruntime_l al ON (app.fnumber = al.fappid and al.flocaleid = '" + langStr + "')  WHERE app.fdeploystatus = '2' ";
                appDS = DB.queryDataSet((String)"appDS", (DBRoute)DBRoute.meta, (String)selectAppSql);
                hasPermEntityAppDS = hasPermEntityDS.join(appDS).on("app_id", "app_id").select(new String[]{"app_id", "entity_num", "permitem"}, new String[]{"app_num", "app_name", "app_runtimename", "app_seq", "cloudId"}).finish();
            }
            String selectEntitySql = " SELECT e.fid entity_id, e.fnumber entity_num, el.fname entity_name FROM t_meta_entitydesign e  LEFT JOIN t_meta_entitydesign_l el ON (e.fid = el.fid and el.flocaleid = '" + langStr + "')  WHERE e.fistemplate = '0' AND e.ftype = '0' ";
            entityDS = DB.queryDataSet((String)"entityDS", (DBRoute)DBRoute.meta, (String)selectEntitySql);
            hasPermEntityEntityDS = hasPermEntityAppDS.join(entityDS).on("entity_num", "entity_num").select(new String[]{"app_id", "app_num", "app_name", "app_runtimename", "entity_num", "permitem", "app_seq", "cloudId"}, new String[]{"entity_id", "entity_name"}).finish();
            String selectFuncPermSql = "SELECT DISTINCT pi.fid permiteml_id, pi.fnumber permitem_num,  case when pil.fname is null or pil.fname = '' or pil.fname = ' ' then pi.fname else pil.fname end permiteml_name  FROM  t_perm_permitem pi  LEFT JOIN t_perm_permitem_l pil ON (pi.fid = pil.fid AND pil.flocaleid = '" + langStr + "') ";
            funcPermDS = DB.queryDataSet((String)"funcPermDS", (DBRoute)DBRoute.permission, (String)selectFuncPermSql);
            finalDS = hasPermEntityEntityDS.join(funcPermDS).on("permitem", "permiteml_id").select(new String[]{"app_id", "app_num", "app_name", "app_runtimename", "entity_id", "entity_num", "entity_name", "app_seq", "cloudId"}, new String[]{"permiteml_id", "permiteml_name", "permitem_num"}).finish().orderBy(new String[]{"app_seq", "app_num", "entity_num"});
            if (domainId != 0L) {
                String domainPermSql = " SELECT fappid app_id, fentitynum entity_num, fpermitemid permitem FROM t_perm_admindomainrange WHERE fid = ? ";
                hasPermEntityDS = DB.queryDataSet((String)"hasPermEntityDS", (DBRoute)DBRoute.permission, (String)domainPermSql, (Object[])new Object[]{domainId});
                String selectAppSql = " SELECT app.fid app_id, app.fnumber app_num, l.fname app_name, al.fname app_runtimename, app.fseq app_seq,  app.fbizcloudid cloudId FROM t_meta_bizapp app  LEFT JOIN t_meta_bizapp_l l ON (app.fid = l.fid and l.flocaleid = '" + langStr + "')  LEFT JOIN t_meta_appruntime_l al ON (app.fnumber = al.fappid and al.flocaleid = '" + langStr + "')  WHERE app.fdeploystatus = '2' ";
                appDS = DB.queryDataSet((String)"appDS", (DBRoute)DBRoute.meta, (String)selectAppSql);
                hasPermEntityAppDS = hasPermEntityDS.leftJoin(appDS).on("app_id", "app_id").select(new String[]{"app_id", "entity_num", "permitem"}, new String[]{"app_num", "app_name", "app_runtimename", "app_seq", "cloudId"}).finish();
                entityDS = DB.queryDataSet((String)"entityDS", (DBRoute)DBRoute.meta, (String)selectEntitySql);
                hasPermEntityEntityDS = hasPermEntityAppDS.leftJoin(entityDS).on("entity_num", "entity_num").select(new String[]{"app_id", "app_num", "app_name", "app_runtimename", "entity_num", "permitem", "app_seq", "cloudId"}, new String[]{"entity_id", "entity_name"}).finish();
                funcPermDS = DB.queryDataSet((String)"funcPermDS", (DBRoute)DBRoute.permission, (String)selectFuncPermSql);
                finalDS = finalDS.union(hasPermEntityEntityDS.join(funcPermDS).on("permitem", "permiteml_id").select(new String[]{"app_id", "app_num", "app_name", "app_runtimename", "entity_id", "entity_num", "entity_name", "app_seq", "cloudId"}, new String[]{"permiteml_id", "permiteml_name", "permitem_num"}).finish()).orderBy(new String[]{"app_seq", "app_num", "entity_num"});
            }
            HashMap<String, String> dataSource = new HashMap<String, String>(16);
            String entityName = "";
            String lastAppEnt = "";
            String lastEntityName = "";
            ArrayList<String> entityPermItems = new ArrayList<String>(10);
            Map extAppAndOriAppRel = AppHelper.getExtAppAndOrgnlAppRelPrivate(null);
            HashSet<String> cloudIds = new HashSet<String>(16);
            HashSet<String> appIds = new HashSet<String>(16);
            HashSet<String> entityIds = new HashSet<String>(16);
            TreeNode cloudNode = null;
            TreeNode appNode = null;
            TreeNode entityNode = null;
            HashSet<String> nodeKeySet = new HashSet<String>(1000);
            String firstCloud = "";
            Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            boolean cloudSetNotEmpty = null != disabledCloudIds && !disabledCloudIds.isEmpty();
            Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
            boolean appSetNotEmpty = null != disabledAppIds && !disabledAppIds.isEmpty();
            HashMap formShowOnTreeStatusMap = new HashMap(8);
            HashMap<String, String> formShowOnTreeStatusParaMap = new HashMap<String, String>(8);
            formShowOnTreeStatusParaMap.put("dimension", "DIM_ORG");
            formShowOnTreeStatusParaMap.put("dimDiffHide", "1");
            PermCommonUtil.getFormShowOnTreeStatusMap(formShowOnTreeStatusParaMap, formShowOnTreeStatusMap);
            Map allUserAppEntMap = AppHelper.getAllUserAppEntMap();
            HashSet allUserAppIdSet = new HashSet(PermCommonUtil.getAllUserAppIds());
            beforeFinalDS = DB.queryDataSet((String)"beforeFinalDS", (DBRoute)DBRoute.meta, (String)"SELECT fseq cloudSeq, fid cloudId FROM  t_meta_bizcloud ");
            finalDS = finalDS.join(beforeFinalDS).on("cloudId", "cloudId").select(new String[]{"app_id", "app_num", "app_name", "app_runtimename", "entity_id", "entity_num", "entity_name", "app_seq", "permiteml_id", "permiteml_name", "permitem_num"}, new String[]{"cloudSeq"}).finish().orderBy(new String[]{"cloudSeq", "app_seq", "app_num", "entity_num", "permiteml_id"});
            Map allCloudIdNameMap = CloudHelper.getAllCloudIdNameMap();
            while (finalDS.hasNext()) {
                String[] cloudInfo;
                String cloudId;
                String nodeKey;
                Set allUserAppEntSet;
                Row row = finalDS.next();
                String appId = row.getString("app_id");
                appId = (String)extAppAndOriAppRel.get(appId);
                String appNum = row.getString("app_num");
                String appName = row.getString("app_runtimename");
                if (appId == null) {
                    appId = row.getString("app_id");
                }
                if (appSetNotEmpty && disabledAppIds.contains(appId)) continue;
                if (StringUtils.isEmpty((String)appNum)) {
                    appNum = appId;
                    appName = appId + "(NotFound)";
                } else if (StringUtils.isEmpty((String)appName) && StringUtils.isEmpty((String)(appName = row.getString("app_name")))) {
                    appName = appNum;
                }
                String entityId = row.getString("entity_id");
                String entityNum = row.getString("entity_num");
                if ("false".equals(formShowOnTreeStatusMap.get(entityNum)) || allUserAppIdSet.contains(appId) && (null == (allUserAppEntSet = (Set)allUserAppEntMap.get(appId)) || allUserAppEntSet.isEmpty() || !allUserAppEntSet.contains(entityNum))) continue;
                if (StringUtils.isEmpty((String)entityId)) {
                    entityId = entityNum;
                    entityName = entityNum + "(NotFound)";
                } else {
                    entityName = this.entityNumNameMap.get(entityNum);
                    if (StringUtils.isEmpty((String)entityName)) {
                        entityName = StringUtils.isEmpty((String)row.getString("entity_name")) ? entityNum : row.getString("entity_name");
                    }
                }
                String permitemId = row.getString("permiteml_id");
                String permitemName = row.getString("permiteml_name");
                String permItemNum = row.getString("permitem_num");
                if (StringUtils.isEmpty((String)permitemName)) {
                    permitemName = permitemId;
                }
                if (StringUtils.isEmpty((String)permItemNum)) {
                    permItemNum = permitemId + "(NotFound)";
                }
                if (nodeKeySet.contains(nodeKey = appId + "_" + entityId + "_" + permitemId)) continue;
                nodeKeySet.add(nodeKey);
                String cloudInfoStr = this.appCloudInfoMap.get(appId);
                if (cloudInfoStr == null) {
                    cloudId = "unknown";
                    cloudInfo = new String[]{cloudId, cloudId, ResManager.loadKDString((String)"\u5f02\u5e38\u6570\u636e\u8bf7\u52ff\u5206\u914d", (String)"AdminGroupPermPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0])};
                } else {
                    cloudInfo = cloudInfoStr.split("\\|");
                    cloudId = cloudInfo[0];
                }
                if (cloudSetNotEmpty && disabledCloudIds.contains(cloudId)) continue;
                if (cloudIds.contains(cloudId)) {
                    cloudNode = rootNode.getTreeNode("cloud#" + cloudId, 100);
                } else {
                    cloudIds.add(cloudId);
                    String cloudNumber = cloudInfo[1];
                    String cloudName = (String)allCloudIdNameMap.get(cloudId);
                    if (StringUtils.isEmpty((String)cloudName) || Objects.equals("null", cloudName)) {
                        cloudName = StringUtils.isEmpty((String)cloudNumber) ? cloudId : cloudNumber;
                    } else if (showNum) {
                        cloudName = StringUtils.isEmpty((String)cloudNumber) ? cloudName + '(' + cloudId + ')' : cloudName + '(' + cloudNumber + ')';
                    }
                    cloudNode = new TreeNode("-1", "cloud#" + cloudId, cloudName, true);
                    if (StringUtils.isEmpty((String)firstCloud)) {
                        firstCloud = cloudId;
                    }
                    cloudNode.setIsOpened(true);
                    rootNode.addChild(cloudNode);
                }
                if (showNum) {
                    appName = appName + "(" + appNum + ")";
                    entityName = entityName + "(" + entityNum + ")";
                    permitemName = permitemName + "(" + permItemNum + ")";
                    this.sysNodeNameNumMap.putIfAbsent(appId, appName);
                    this.sysNodeNameNumMap.putIfAbsent(entityNum, entityName);
                    this.sysNodeNameNumMap.putIfAbsent(permitemId, permitemName);
                } else {
                    this.sysNodeNameMap.putIfAbsent(appId, appName);
                    this.sysNodeNameMap.putIfAbsent(entityNum, entityName);
                    this.sysNodeNameMap.putIfAbsent(permitemId, permitemName);
                }
                if (!lastAppEnt.equals(appId + "|" + entityNum)) {
                    if (!CollectionUtils.isEmpty(entityPermItems)) {
                        adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, lastEntityName, entityPermItems);
                        dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
                        entityPermItems.clear();
                    }
                    lastAppEnt = appId + "|" + entityNum;
                    lastEntityName = entityName;
                }
                entityPermItems.add(permitemId);
                if (appIds.contains(appId)) {
                    appNode = cloudNode.getTreeNode("app#" + appId, 100);
                } else {
                    appIds.add(appId);
                    appNode = new TreeNode("cloud#83bfebc800000bac", "app#" + appId, appName, true);
                    cloudNode.addChild(appNode);
                }
                if (entityIds.contains(entityId + "@" + appId)) {
                    entityNode = appNode.getTreeNode("entity#" + entityNum + "@" + appId, 100);
                } else {
                    entityIds.add(entityId + "@" + appId);
                    entityNode = new TreeNode("app#" + appId, "entity#" + entityNum + "@" + appId, entityName, true);
                    appNode.addChild(entityNode);
                }
                TreeNode permItemNode = new TreeNode("entity#" + entityNum + "@" + appId, "permitem#" + permitemId + "@" + entityNum + "|" + appId, permitemName);
                entityNode.addChild(permItemNode);
            }
            if (!CollectionUtils.isEmpty(entityPermItems)) {
                adminGroupSysSearchBean = new AdminGroupSysSearchBean(lastAppEnt, entityName, entityPermItems);
                dataSource.put(lastAppEnt, SerializationUtils.toJsonString((Object)adminGroupSysSearchBean));
            }
            this.getPageCache().put("sysLeftSource", SerializationUtils.toJsonString(dataSource));
            this.getPageCache().put("sysNodeNameMap", SerializationUtils.toJsonString(this.sysNodeNameMap));
            this.getPageCache().put("sysNodeNameNumMap", SerializationUtils.toJsonString(this.sysNodeNameNumMap));
            this.getPageCache().putBigObject("sysTreeLeftRoot", SerializationUtils.toJsonString((Object)rootNode));
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{hasPermEntityDS, appIdEntNum2, publishAppIdDSEntNum, appDS, hasPermEntityAppDS, entityDS, hasPermEntityEntityDS, funcPermDS, beforeFinalDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{hasPermEntityDS, appIdEntNum2, publishAppIdDSEntNum, appDS, hasPermEntityAppDS, entityDS, hasPermEntityEntityDS, funcPermDS, beforeFinalDS, finalDS});
    }

    private String getSysCloudName() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"SYS")});
        return load[0].getString("name");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String showFormSpecial = (String)e.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)e.getFormShowParameter().getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (PermFormCommonUtil.isSingleOrg()) {
            IFormView view = this.getView();
            view.setVisible(Boolean.FALSE, new String[]{"tabpage_bizunit"});
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
    }

    public void click(EventObject evt) {
        String ctrlKey;
        DynamicObject adminGroup = (DynamicObject)this.getModel().getValue("usergroup");
        Long adminGroupId = adminGroup.getLong("id");
        Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)RequestContext.get().getCurrUserId(), (boolean)false, null);
        if (CollectionUtils.isEmpty((Collection)canSavePermAdmGroupIdSet) || !canSavePermAdmGroupIdSet.contains(String.valueOf(adminGroupId))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u8bbf\u95ee\u8be5\u7ba1\u7406\u5458\u7ec4\u5206\u7ec4\u6388\u6743\u4fe1\u606f\u3002", (String)"AdminGroupPermPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        Long level = adminGroup.getLong("level");
        Control c = (Control)evt.getSource();
        switch (ctrlKey = c.getKey()) {
            case "btn_addorg": {
                this.addOrg(adminGroupId, level, "15");
                break;
            }
            case "btn_deleteorg": {
                this.removeSelOrg(adminGroupId, level, "15");
                break;
            }
            case "btn_addadminorg": {
                this.addOrg(adminGroupId, level, "01");
                break;
            }
            case "btn_deleteadminorg": {
                this.removeSelOrg(adminGroupId, level, "01");
                break;
            }
            case "btn_addapp": {
                this.addApp();
                break;
            }
            case "btn_delapp": {
                this.removeSelApp();
                break;
            }
            case "btn_addsys": {
                this.addSys();
                break;
            }
            case "btn_delsys": {
                this.removeSys();
            }
        }
    }

    private void removeSelApp() {
        TreeView tv = (TreeView)this.getControl("selectedapptree");
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u9009\u5e94\u7528\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermPlugin_17", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            IPageCache pageCache = this.getPageCache();
            this.getPageCache().put("dataChanged", "true");
            pageCache.put("app_change", "true");
            HashSet<String> removeIds = new HashSet<String>(16);
            for (String nodeId : checkedNodeIds) {
                if (!nodeId.startsWith("app#")) continue;
                int app = nodeId.lastIndexOf(35);
                int cloud = nodeId.lastIndexOf(124);
                String appSub = nodeId.substring(app + 1, cloud);
                String cloudSub = nodeId.substring(cloud + 1);
                removeIds.add(cloudSub + "|" + appSub);
            }
            this.updateAddCache(removeIds, false, "app_add_ids");
            this.updateDelCache(removeIds, true, "app_del_ids");
            this.rebuildAppRightTree(false, removeIds);
        }
    }

    private void addApp() {
        TreeView tv = (TreeView)this.getControl("apptree");
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f85\u9009\u5e94\u7528\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermPlugin_18", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        IPageCache pageCache = this.getPageCache();
        this.getPageCache().put("dataChanged", "true");
        pageCache.put("app_change", "true");
        LinkedHashSet<String> addIds = new LinkedHashSet<String>(16);
        for (String nodeId : checkedNodeIds) {
            if (!nodeId.startsWith("app#")) continue;
            int app = nodeId.lastIndexOf(35);
            int cloud = nodeId.lastIndexOf(124);
            String appSub = nodeId.substring(app + 1, cloud);
            String cloudSub = nodeId.substring(cloud + 1);
            addIds.add(cloudSub + "|" + appSub);
        }
        this.updateAddCache(addIds, true, "app_add_ids");
        this.updateDelCache(addIds, false, "app_del_ids");
        this.rebuildAppRightTree(true, addIds);
        tv.uncheckNodes(checkedNodeIds);
    }

    private void rebuildAppRightTree(boolean isAdd, Set<String> apps) {
        IPageCache pageCache = this.getPageCache();
        String appDataStr = pageCache.get("Current_AppData");
        Set appData = new LinkedHashSet<String>(16);
        if (StringUtils.isNotEmpty((String)appDataStr)) {
            appData = (Set)SerializationUtils.fromJsonString((String)appDataStr, LinkedHashSet.class);
        }
        if (isAdd) {
            appData.addAll(apps);
        } else {
            appData.removeAll(apps);
        }
        pageCache.put("Current_AppData", SerializationUtils.toJsonString(appData));
        TreeView tv = (TreeView)this.getControl("selectedapptree");
        tv.deleteAllNodes();
        if (appData.size() == 0) {
            TreeNode commonRightRootNode = this.getCommonRightRootNode();
            tv.addNode(commonRightRootNode);
        } else {
            DynamicObject adminGroup = (DynamicObject)this.getModel().getValue("usergroup");
            Long adminGroupId = adminGroup.getLong("id");
            Long level = adminGroup.getLong("level");
            this.buildSelectedAppTree(adminGroupId, level);
        }
    }

    private void removeSelOrg(Long adminGroupId, Long level, String viewType) {
        String noticeMsg = null;
        String rightNodeIdCacheKey = null;
        String toDelIdCacheKey = null;
        String toAddIdCacheKey = null;
        String modelChangeKey = null;
        if (viewType.equals("15")) {
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u9009\u4e1a\u52a1\u5355\u5143\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermPlugin_19", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rightNodeIdCacheKey = "orgTreeRightNodeIds";
            toDelIdCacheKey = "biz_del_ids";
            toAddIdCacheKey = "biz_add_ids";
            modelChangeKey = "biz_change";
        } else {
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u9009\u884c\u653f\u7ec4\u7ec7\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermPlugin_20", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rightNodeIdCacheKey = "AdminOrgTreeRightNodeIds";
            toDelIdCacheKey = "admin_del_ids";
            toAddIdCacheKey = "admin_add_ids";
            modelChangeKey = "admin_change";
        }
        String rightNodeIds = this.getPageCache().get(rightNodeIdCacheKey);
        if (StringUtils.isEmpty((String)rightNodeIds)) {
            this.getView().showTipNotification(noticeMsg);
            return;
        }
        Set rightNodeIdSets = (Set)SerializationUtils.fromJsonString((String)rightNodeIds, Set.class);
        if (rightNodeIdSets.size() == 0) {
            this.getView().showTipNotification(noticeMsg);
            return;
        }
        this.getPageCache().put("dataChanged", "true");
        this.getPageCache().put(modelChangeKey, "true");
        this.updateAddCache(rightNodeIdSets, false, toAddIdCacheKey);
        this.updateDelCache(rightNodeIdSets, true, toDelIdCacheKey);
        this.deleteEntryByList(adminGroupId, rightNodeIdSets, viewType);
        this.buildSelectedOrgTree(adminGroupId, viewType, level);
        this.getPageCache().remove(rightNodeIdCacheKey);
    }

    private void deleteEntryByList(Long adminGroupId, Set<String> toDeleteIds, String viewType) {
        String orgSourceKey;
        IPageCache pageCache = this.getPageCache();
        String currentOrgDataCacheKey = null;
        if ("15".equals(viewType)) {
            currentOrgDataCacheKey = adminGroupId + "_current_BizDatas";
            orgSourceKey = "bizRightSource";
        } else {
            currentOrgDataCacheKey = adminGroupId + "_current_AdminOrgDatas";
            orgSourceKey = "adminRightSource";
        }
        List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get(orgSourceKey), AdminGroupOrgSearchBean.class);
        String orgDataStr = this.getPageCache().get(currentOrgDataCacheKey);
        List<String> orgData = StringUtils.isNotEmpty((String)orgDataStr) ? SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class) : this.queryOrgLongNumberByAdminGroupId(adminGroupId, viewType, false);
        Iterator<String> it = orgData.iterator();
        while (it.hasNext()) {
            String data = it.next();
            String orgId = data.split("_split_")[0];
            if (StringUtils.isEmpty((String)orgId) || !toDeleteIds.contains(orgId)) continue;
            it.remove();
        }
        dataSource.removeIf(bean -> toDeleteIds.contains(bean.getId()));
        pageCache.put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
        pageCache.put(orgSourceKey, SerializationUtils.toJsonString((Object)dataSource));
    }

    private void addOrg(Long adminGroupId, Long level, String viewType) {
        String treeViewKey = null;
        String noticeMsg = null;
        String rootTreeNodeCacheKey = null;
        String leftNodeIdCacheKey = null;
        String rightNodeIdCacheKey = null;
        String toDelIdCacheKey = null;
        String toAddIdCacheKey = null;
        String modelChangeKey = null;
        if (viewType.equals("15")) {
            treeViewKey = "orgtree";
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f85\u9009\u4e1a\u52a1\u5355\u5143\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermPlugin_22", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rootTreeNodeCacheKey = "orgTreeLeftRoot";
            leftNodeIdCacheKey = "orgTreeLeftNodeIds";
            rightNodeIdCacheKey = "orgTreeRightNodeIds";
            toDelIdCacheKey = "biz_del_ids";
            toAddIdCacheKey = "biz_add_ids";
            modelChangeKey = "biz_change";
        } else {
            treeViewKey = "adminorgtree";
            noticeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f85\u9009\u884c\u653f\u7ec4\u7ec7\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermPlugin_23", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            rootTreeNodeCacheKey = "AdminOrgTreeLeftRoot";
            leftNodeIdCacheKey = "AdminOrgTreeLeftNodeIds";
            rightNodeIdCacheKey = "AdminOrgTreeRightNodeIds";
            toDelIdCacheKey = "admin_del_ids";
            toAddIdCacheKey = "admin_add_ids";
            modelChangeKey = "admin_change";
        }
        String leftNodeIdCacheJson = this.getPageCache().get(leftNodeIdCacheKey);
        if (StringUtils.isEmpty((String)leftNodeIdCacheJson)) {
            this.getView().showTipNotification(noticeMsg, Integer.valueOf(2000));
            return;
        }
        Set leftNodeIds = (Set)SerializationUtils.fromJsonString((String)leftNodeIdCacheJson, Set.class);
        if (leftNodeIds.size() == 0) {
            this.getView().showTipNotification(noticeMsg, Integer.valueOf(2000));
            return;
        }
        this.getPageCache().put("dataChanged", "true");
        this.getPageCache().put(modelChangeKey, "true");
        this.updateAddCache(leftNodeIds, true, toAddIdCacheKey);
        this.updateDelCache(leftNodeIds, false, toDelIdCacheKey);
        this.getPageCache().remove(leftNodeIdCacheKey);
        this.getPageCache().remove(rightNodeIdCacheKey);
        this.adjustEntry(adminGroupId, leftNodeIds, true, viewType);
        this.buildSelectedOrgTree(adminGroupId, viewType, level);
        TreeView tree = (TreeView)this.getControl(treeViewKey);
        List checkedNodeIdList = tree.getTreeState().getCheckedNodeIds();
        tree.uncheckNodes(checkedNodeIdList);
        TreeNode rootTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(rootTreeNodeCacheKey), TreeNode.class);
        rootTreeNode.setCheckable(false);
        List children = rootTreeNode.getChildren();
        this.uncheckChildNodes(children);
        this.getPageCache().put(rootTreeNodeCacheKey, SerializationUtils.toJsonString((Object)rootTreeNode));
    }

    private void adjustEntry(Long adminGroupId, Set<String> nodeIds, boolean isAdd, String viewType) {
        String orgSourceKey;
        Map<String, String> orgNodeMap;
        String currentOrgDataCacheKey;
        IPageCache pageCache = this.getPageCache();
        String langName = RequestContext.get().getLang().name();
        if ("15".equals(viewType)) {
            currentOrgDataCacheKey = adminGroupId + "_current_BizDatas";
            orgNodeMap = this.bizUnitNodeMap;
            orgSourceKey = "bizRightSource";
        } else {
            currentOrgDataCacheKey = adminGroupId + "_current_AdminOrgDatas";
            orgNodeMap = this.adminOrgNodeMap;
            orgSourceKey = "adminRightSource";
        }
        String orgDataStr = pageCache.get(currentOrgDataCacheKey);
        List<String> orgData = StringUtils.isNotEmpty((String)orgDataStr) ? SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class) : this.queryOrgLongNumberByAdminGroupId(adminGroupId, viewType, false);
        List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get(orgSourceKey), AdminGroupOrgSearchBean.class);
        if (isAdd) {
            HashSet<String> orgDataSet = new HashSet<String>(orgData);
            for (String nodeId : nodeIds) {
                String[] details;
                String info = orgNodeMap.get(nodeId);
                boolean success = orgDataSet.add(info);
                if (!success || (details = info.split("_split_")).length != 5) continue;
                dataSource.add(new AdminGroupOrgSearchBean(details[0], details[1], details[2], Boolean.parseBoolean(details[3]), info, details[4]));
            }
            orgData = new ArrayList<String>(orgDataSet);
            orgData.sort(new Comparator<String>(){

                @Override
                public int compare(String org1, String org2) {
                    String[] orgFromArr = org1.split("_split_");
                    String[] orgToArr = org2.split("_split_");
                    if (orgFromArr.length < 5 || orgToArr.length < 5) {
                        return 0;
                    }
                    String longNumber1 = orgFromArr[2];
                    String longNumber2 = orgToArr[2];
                    return longNumber1.compareTo(longNumber2);
                }
            });
        }
        pageCache.put(currentOrgDataCacheKey, SerializationUtils.toJsonString(orgData));
        pageCache.put(orgSourceKey, SerializationUtils.toJsonString((Object)dataSource));
    }

    private void removeSys() {
        TreeView tv = (TreeView)this.getControl("selectedsystree");
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5df2\u5206\u914d\u6743\u9650\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermPlugin_24", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else {
            IPageCache pageCache = this.getPageCache();
            this.getPageCache().put("dataChanged", "true");
            pageCache.put("sys_change", "true");
            Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("sysRightSource"), Map.class);
            HashMap<String, List> entityPermItems = new HashMap<String, List>(16);
            HashSet<String> removeIds = new HashSet<String>(16);
            for (String string : checkedNodeIds) {
                if (!string.startsWith("permitem#")) continue;
                int permItem = string.lastIndexOf(35);
                int entity = string.lastIndexOf(64);
                int app = string.lastIndexOf(124);
                String permItemSub = string.substring(permItem + 1, entity);
                String entitySub = string.substring(entity + 1, app);
                String appSub = string.substring(app + 1);
                removeIds.add(appSub + "|" + entitySub + "|" + permItemSub);
                entityPermItems.computeIfAbsent(appSub + "|" + entitySub, k -> new ArrayList(10)).add(permItemSub);
            }
            for (Map.Entry entry : entityPermItems.entrySet()) {
                String appEntity = (String)entry.getKey();
                List permItems = (List)entry.getValue();
                String source = (String)dataSource.get(appEntity);
                AdminGroupSysSearchBean bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)source, AdminGroupSysSearchBean.class);
                if (bean.getPermItems().size() == permItems.size()) {
                    dataSource.remove(appEntity);
                    continue;
                }
                bean.getPermItems().removeAll(permItems);
                dataSource.put(appEntity, SerializationUtils.toJsonString((Object)bean));
            }
            this.getPageCache().put("sysRightSource", SerializationUtils.toJsonString((Object)dataSource));
            this.updateAddCache(removeIds, false, "sys_add_ids");
            this.updateDelCache(removeIds, true, "sys_del_ids");
            this.rebuildSysRightTree(false, removeIds);
        }
    }

    private void addSys() {
        TreeView tv = (TreeView)this.getControl("systree");
        List checkedNodeIds = tv.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u53ef\u5206\u914d\u6743\u9650\u201d\u8282\u70b9\u3002", (String)"AdminGroupPermPlugin_25", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        IPageCache pageCache = this.getPageCache();
        this.getPageCache().put("dataChanged", "true");
        pageCache.put("sys_change", "true");
        Map dataSource = (Map)SerializationUtils.fromJsonString((String)pageCache.get("sysRightSource"), Map.class);
        LinkedHashMap<String, List> entityPermItems = new LinkedHashMap<String, List>(16);
        LinkedHashSet<String> addIds = new LinkedHashSet<String>(16);
        for (String string : checkedNodeIds) {
            if (!string.startsWith("permitem#")) continue;
            int permItem = string.lastIndexOf(35);
            int entity = string.lastIndexOf(64);
            int app = string.lastIndexOf(124);
            String permItemSub = string.substring(permItem + 1, entity);
            String entitySub = string.substring(entity + 1, app);
            String appSub = string.substring(app + 1);
            addIds.add(appSub + "|" + entitySub + "|" + permItemSub);
            entityPermItems.computeIfAbsent(appSub + "|" + entitySub, k -> new ArrayList(10)).add(permItemSub);
        }
        for (Map.Entry entry : entityPermItems.entrySet()) {
            AdminGroupSysSearchBean bean;
            String appEntity = (String)entry.getKey();
            String entityNum = appEntity.substring(appEntity.lastIndexOf(124) + 1);
            List permItems = (List)entry.getValue();
            String source = (String)dataSource.get(appEntity);
            if (StringUtils.isEmpty((String)source)) {
                bean = new AdminGroupSysSearchBean(appEntity, this.sysNodeNameMap.get(entityNum), permItems);
                dataSource.put(appEntity, SerializationUtils.toJsonString((Object)bean));
                continue;
            }
            bean = (AdminGroupSysSearchBean)SerializationUtils.fromJsonString((String)source, AdminGroupSysSearchBean.class);
            bean.getPermItems().addAll(permItems);
            dataSource.put(appEntity, SerializationUtils.toJsonString((Object)bean));
        }
        this.getPageCache().put("sysRightSource", SerializationUtils.toJsonString((Object)dataSource));
        this.updateAddCache(addIds, true, "sys_add_ids");
        this.updateDelCache(addIds, false, "sys_del_ids");
        this.rebuildSysRightTree(true, addIds);
        tv.uncheckNodes(checkedNodeIds);
    }

    private void rebuildSysRightTree(boolean isAdd, Set<String> perms) {
        IPageCache pageCache = this.getPageCache();
        String adminGroupPermStr = pageCache.get("Current_SysData");
        Set<String> adminGroupPerm = new LinkedHashSet<String>(16);
        if (StringUtils.isNotEmpty((String)adminGroupPermStr)) {
            adminGroupPerm = (Set)SerializationUtils.fromJsonString((String)adminGroupPermStr, LinkedHashSet.class);
        }
        if (isAdd) {
            adminGroupPerm.addAll(perms);
        } else {
            adminGroupPerm.removeAll(perms);
        }
        pageCache.put("Current_SysData", SerializationUtils.toJsonString(adminGroupPerm));
        TreeView tv = (TreeView)this.getControl("selectedsystree");
        tv.deleteAllNodes();
        if (adminGroupPerm.size() == 0) {
            TreeNode commonRightRootNode = this.getCommonRightRootNode();
            tv.addNode(commonRightRootNode);
        } else {
            this.getSelectPermRootNode(tv, adminGroupPerm, this.getSelectSysRootNodeText(), false);
        }
    }

    private boolean updateDelCache(Set<String> ids, boolean isDelete, String cacheKey) {
        boolean idsChanged;
        String toDeleteIdsJson = this.getPageCache().get(cacheKey);
        Set<String> toDeleteIdSet = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)toDeleteIdsJson)) {
            toDeleteIdSet = (Set)SerializationUtils.fromJsonString((String)toDeleteIdsJson, Set.class);
        }
        if (idsChanged = isDelete ? toDeleteIdSet.addAll(ids) : toDeleteIdSet.removeAll(ids)) {
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(toDeleteIdSet));
        }
        return idsChanged;
    }

    private boolean updateAddCache(Set<String> ids, boolean isAdd, String cacheKey) {
        boolean idsChanged;
        String toAddIdsJson = this.getPageCache().get(cacheKey);
        Set<String> toAddIdSet = new LinkedHashSet<String>(16);
        if (StringUtils.isNotEmpty((String)toAddIdsJson)) {
            toAddIdSet = (Set)SerializationUtils.fromJsonString((String)toAddIdsJson, LinkedHashSet.class);
        }
        if (idsChanged = isAdd ? toAddIdSet.addAll(ids) : toAddIdSet.removeAll(ids)) {
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(toAddIdSet));
        }
        return idsChanged;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                this.saveItemClick(true);
                break;
            }
            case "add_user": {
                this.showUserList();
                break;
            }
            case "del_user": {
                this.deleteExtraUser();
            }
        }
    }

    private void saveItemClick(boolean showChangedConfirm) {
        DynamicObject currentAdminGroup = (DynamicObject)this.getModel().getValue("usergroup");
        Long adminGroupId = currentAdminGroup.getLong("id");
        Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)RequestContext.get().getCurrUserId(), (boolean)false, null);
        if (CollectionUtils.isEmpty((Collection)canSavePermAdmGroupIdSet) || !canSavePermAdmGroupIdSet.contains(String.valueOf(adminGroupId))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u8bbf\u95ee\u8be5\u7ba1\u7406\u5458\u7ec4\u5206\u7ec4\u6388\u6743\u4fe1\u606f\u3002", (String)"AdminGroupPermPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        if (showChangedConfirm && this.isConfirmChanged(adminGroupId)) {
            return;
        }
        this.save();
    }

    private boolean isConfirmChanged(Long adminGroupId) {
        IPageCache pageCache = this.getPageCache();
        if (StringUtils.isEmpty((String)pageCache.get("dataChanged"))) {
            return false;
        }
        if (QueryServiceHelper.exists((String)"perm_admingroup", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)adminGroupId)})) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_save", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6388\u6743\u5185\u5bb9\u8c03\u6574\u4f1a\u5f71\u54cd\u4e0b\u7ea7\u7ba1\u7406\u5458\u5206\u7ec4\u7ba1\u8f96\u8303\u56f4\uff0c\u786e\u8ba4\u4fdd\u5b58\u5417\uff1f", (String)"AdminGroupPermPlugin_21", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            return true;
        }
        return false;
    }

    private void deleteExtraUser() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rowIndex = entryGrid.getSelectRows();
        if (rowIndex != null && rowIndex.length > 0) {
            String currentExtraUserIds = this.getPageCache().get("Current_ExtraUser");
            Set curExtraUserIds = (Set)SerializationUtils.fromJsonString((String)currentExtraUserIds, Set.class);
            HashSet<String> delIds = new HashSet<String>(16);
            for (int index : rowIndex) {
                Long userId;
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index);
                if (null == entryRowEntity || null == (userId = (Long)entryRowEntity.get("admin_exception_user.id"))) continue;
                delIds.add(String.valueOf(userId));
            }
            this.getPageCache().put("dataChanged", "true");
            this.getPageCache().put("extraUser_change", "true");
            this.updateAddCache(delIds, false, "user_add_ids");
            this.updateDelCache(delIds, true, "user_del_ids");
            this.getModel().deleteEntryRows("entryentity", rowIndex);
            curExtraUserIds.removeAll(delIds);
            this.getPageCache().put("Current_ExtraUser", SerializationUtils.toJsonString((Object)curExtraUserIds));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdminGroupPermPlugin_26", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void showUserList() {
        String currentExtraUserIds = this.getPageCache().get("Current_ExtraUser");
        Set extraUserIdsStr = (Set)SerializationUtils.fromJsonString((String)currentExtraUserIds, Set.class);
        Set extraUserIds = extraUserIdsStr.stream().map(Long::parseLong).collect(Collectors.toSet());
        ListShowParameter lsp = AdmGrpOrgAddUserService.getUserF7LspMap(null, extraUserIds);
        if (null == lsp) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u5f39\u6846\u5217\u8868\u5931\u8d25\u3002", (String)"AdminGroupTreeListPlugin_21", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addUser"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<String> queryOrgLongNumberByAdminGroupId(Long adminGroupId, final String orgViewType, final boolean isLeftTree) {
        String entryTableName = "";
        String entryKeyField = "forgId";
        String originOrgDataCacheKey = "";
        if (orgViewType.equals("01")) {
            entryTableName = "t_perm_admingrouporg";
            originOrgDataCacheKey = adminGroupId + "_AdminOrgDatas";
        } else if (orgViewType.equals("15")) {
            entryTableName = "t_perm_admingroupbizunit";
            originOrgDataCacheKey = adminGroupId + "_BizDatas";
        }
        StringBuilder sql = new StringBuilder();
        if (adminGroupId == 0L) {
            sql.append(" SELECT os.forgid, os.flongnumber, org.fnumber, org.forgpatternid FROM t_org_org org ").append(" INNER JOIN t_org_structure os ON org.fid = os.forgid ").append(" WHERE org.fenable = '1' AND os.fisfreeze = '0' ").append(" AND EXISTS(SELECT 1 FROM t_org_viewschema ov WHERE ov.fid = os.fviewid AND ov.FID = ").append(Long.parseLong(orgViewType)).append(" AND ov.FISDEFAULT = '1') ");
        } else {
            sql.append(" SELECT os.forgid, os.flongnumber, org.fnumber, org.forgpatternid ").append(" FROM ").append(entryTableName).append(" pa ").append(" INNER JOIN t_org_org org ON org.fid = pa.").append(entryKeyField).append(" INNER JOIN t_org_structure os ON org.fid = os.forgid ").append(" WHERE pa.fusergroupid = ").append(adminGroupId);
            if (isLeftTree) {
                sql.append(" AND org.fenable = '1' ").append(" AND os.fisfreeze = '0' ");
            }
            sql.append(" AND EXISTS (SELECT 1 FROM t_org_viewschema ov WHERE ov.fid = os.fviewid AND ov.FID = ").append(Long.parseLong(orgViewType)).append(" AND ov.FISDEFAULT = '1') ");
        }
        List orgData = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> result = new ArrayList<String>(1000);
                HashMap<String, String> orgNodeMap = new HashMap<String, String>(1000);
                ArrayList<AdminGroupOrgSearchBean> dataSource = new ArrayList<AdminGroupOrgSearchBean>(1000);
                while (rs.next()) {
                    boolean isCorporateOrg = false;
                    String orgPatternId = rs.getString(4);
                    String patternType = (String)AdminGroupPermPlugin.this.orgPatternTypeMap.get(orgPatternId);
                    if ("1".equals(patternType) || "2".equals(patternType)) {
                        isCorporateOrg = true;
                    }
                    String orgId = rs.getString(1);
                    String longNumber = rs.getString(2).replace('!', ' ');
                    String number = rs.getString(3);
                    String orgName = '(' + number + ") " + (String)AdminGroupPermPlugin.this.allOrgNameMap.get(orgId);
                    String orgAndLongNumber = orgId + "_split_" + orgName + "_split_" + longNumber + "_split_" + isCorporateOrg + "_split_" + number;
                    result.add(orgAndLongNumber);
                    orgNodeMap.put(orgId, orgAndLongNumber);
                    dataSource.add(new AdminGroupOrgSearchBean(orgId, orgName, longNumber, isCorporateOrg, orgAndLongNumber, number));
                }
                if (isLeftTree && orgViewType.equals("15")) {
                    AdminGroupPermPlugin.this.bizUnitNodeMap = orgNodeMap;
                    AdminGroupPermPlugin.this.getPageCache().put("bizUnitNodeMap", SerializationUtils.toJsonString((Object)AdminGroupPermPlugin.this.bizUnitNodeMap));
                    AdminGroupPermPlugin.this.getPageCache().put("bizLeftSource", SerializationUtils.toJsonString(dataSource));
                } else if (isLeftTree && orgViewType.equals("01")) {
                    AdminGroupPermPlugin.this.adminOrgNodeMap = orgNodeMap;
                    AdminGroupPermPlugin.this.getPageCache().put("adminOrgNodeMap", SerializationUtils.toJsonString((Object)AdminGroupPermPlugin.this.adminOrgNodeMap));
                    AdminGroupPermPlugin.this.getPageCache().put("adminLeftSource", SerializationUtils.toJsonString(dataSource));
                } else if (!isLeftTree && orgViewType.equals("15")) {
                    AdminGroupPermPlugin.this.getPageCache().put("bizRightSource", SerializationUtils.toJsonString(dataSource));
                } else {
                    AdminGroupPermPlugin.this.getPageCache().put("adminRightSource", SerializationUtils.toJsonString(dataSource));
                }
                return result;
            }
        });
        this.orgDataSort(orgData);
        this.getPageCache().put(originOrgDataCacheKey, SerializationUtils.toJsonString((Object)orgData));
        return orgData;
    }

    private void orgDataSort(List<String> orgData) {
        orgData.sort(new Comparator<String>(){

            @Override
            public int compare(String org1, String org2) {
                String[] orgFromArr = org1.split("_split_");
                String[] orgToArr = org2.split("_split_");
                if (orgFromArr.length < 5 || orgToArr.length < 5) {
                    return 0;
                }
                String longNumber1 = orgFromArr[2];
                String longNumber2 = orgToArr[2];
                return longNumber1.compareTo(longNumber2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> queryAssignableAppRange(String treeView, Long adminGroupId, boolean isTopTree) {
        LinkedHashSet<String> linkedHashSet;
        String langName = RequestContext.get().getLang().name();
        String algoPrefixKey = ((Object)((Object)this)).getClass().getName() + ".queryAssignableAppRange.";
        boolean isShowNum = Boolean.parseBoolean(this.getPageCache().get("appshownum"));
        DataSet cloudAppDS = null;
        DataSet adminAppDS = null;
        DataSet finalDS = null;
        try {
            ArrayList<String> paramList = new ArrayList<String>(10);
            StringBuilder sbCloudAppSql = new StringBuilder();
            sbCloudAppSql.append("SELECT DISTINCT cloud.fid cloud_id, cloudl.fname cloudl_name, ");
            sbCloudAppSql.append(" cloud.fseq cloud_seq, cloud.fnumber cloud_num, a.fid app_id, a.fnumber app_num, ");
            sbCloudAppSql.append(" a.fmasterid app_mastserid, a2.fnumber ori_app_num, b.fname app_name, a.fseq app_seq, a.finheritpath ");
            sbCloudAppSql.append(" FROM t_meta_bizapp a ");
            sbCloudAppSql.append(" INNER JOIN t_meta_bizcloud cloud ON cloud.fid =  a.fbizcloudid ");
            sbCloudAppSql.append(" LEFT JOIN t_meta_bizapp_l b ON (a.fid = b.fid AND b.flocaleid = ?) ");
            paramList.add(langName);
            sbCloudAppSql.append(" LEFT JOIN t_meta_bizcloud_l cloudl ON (cloudl.FID = cloud.fid AND cloudl.flocaleid = ?) ");
            paramList.add(langName);
            sbCloudAppSql.append(" LEFT join t_meta_bizapp a2 ON a2.fid = a.fmasterid ");
            sbCloudAppSql.append(" WHERE a.fdeploystatus = '2' ");
            this.appendCloudFilter(sbCloudAppSql);
            this.appendAppFilter(sbCloudAppSql);
            sbCloudAppSql.append(" order by cloud.fseq, a.fseq, a.finheritpath desc ");
            cloudAppDS = DB.queryDataSet((String)(algoPrefixKey + ".cloudAppDS"), (DBRoute)DBRoute.meta, (String)sbCloudAppSql.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
            finalDS = null;
            if (!isTopTree) {
                String adminAppEntrySql = "SELECT paae.fappid paae_appid FROM t_perm_admingroupapp paae where paae.fusergroupid = ? ";
                adminAppDS = DB.queryDataSet((String)(algoPrefixKey + ".adminAppDS"), (DBRoute)DBRoute.permission, (String)adminAppEntrySql, (Object[])new Object[]{adminGroupId});
                finalDS = cloudAppDS.join(adminAppDS).on("app_id", "paae_appid").select(new String[]{"cloud_id", "cloudl_name", "cloud_seq", "cloud_num", "app_id", "app_name", "app_seq", "app_num", "app_mastserid", "ori_app_num"}, new String[0]).finish().orderBy(new String[]{"cloud_seq", "app_seq"});
            } else {
                finalDS = cloudAppDS;
            }
            LinkedHashSet<String> appRange = new LinkedHashSet<String>(16);
            HashSet<String> appIds = new HashSet<String>(100);
            Map appIdNameMap = AppHelper.getAllAppIdNameMap();
            if ("apptree".equals(treeView)) {
                Map allCloudIdNameMap = CloudHelper.getAllCloudIdNameMap();
                while (finalDS.hasNext()) {
                    Row row = finalDS.next();
                    String appId = row.getString("app_id");
                    String masterAppId = row.getString("app_mastserid");
                    String appNum = row.getString("app_num");
                    String appNameFromDB = row.getString("app_name");
                    if (StringUtils.isNotEmpty((String)masterAppId)) {
                        appId = masterAppId;
                        appNum = row.getString("ori_app_num");
                    }
                    if (appIds.contains(appId)) continue;
                    String appName = "";
                    if (appIdNameMap != null) {
                        appName = (String)appIdNameMap.get(appId);
                    }
                    if (StringUtils.isEmpty((String)appName)) {
                        appName = StringUtils.isNotEmpty((String)appNameFromDB) ? appNameFromDB : appId;
                    }
                    String cloudId = row.getString("cloud_id");
                    String cloudName = (String)allCloudIdNameMap.get(cloudId);
                    if (isShowNum) {
                        appName = appName + "(" + appNum + ")";
                        cloudName = cloudName + "(" + row.getString("cloud_num") + ")";
                    }
                    String info = cloudId + "|" + cloudName + "|" + appId + "|" + appName;
                    appRange.add(info);
                    appIds.add(appId);
                }
            } else {
                while (finalDS.hasNext()) {
                    Row row = finalDS.next();
                    String appId = row.getString("app_id");
                    if (appIds.contains(appId)) continue;
                    String info = row.getString("cloud_id") + "|" + appId;
                    appRange.add(info);
                    appIds.add(appId);
                }
            }
            linkedHashSet = appRange;
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{cloudAppDS, adminAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{cloudAppDS, adminAppDS, finalDS});
        return linkedHashSet;
    }

    /*
     * Exception decompiling
     */
    private Set<String> loadAssignedAppRange(Long adminGroupId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void appendAppFilter(StringBuilder sb) {
        Set disabledAppIds;
        String appStr;
        List<String> appIdsBlackListFromStd;
        StringBuilder app = new StringBuilder();
        String appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist();
        if (StringUtils.isNotEmpty((String)appIdBlackList)) {
            app.append(appIdBlackList);
        }
        if (!CollectionUtils.isEmpty(appIdsBlackListFromStd = PermFormCommonUtil.getAppIdsFromStdBlackList())) {
            for (int i = 0; i < appIdsBlackListFromStd.size(); ++i) {
                appIdsBlackListFromStd.set(i, "'" + appIdsBlackListFromStd.get(i) + "'");
            }
            String appIds = String.join((CharSequence)",", appIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)appIds)) {
                if (StringUtils.isNotEmpty((String)app.toString())) {
                    app.append(',').append(appIds);
                } else {
                    app.append(appIds);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(appStr = app.toString()))) {
            sb.append(" AND a.fid NOT IN (").append(appStr).append(')');
        }
        if (null != (disabledAppIds = ManageServiceHelper.getDisabledAppIds()) && !disabledAppIds.isEmpty()) {
            String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
            sb.append(" AND a.fid NOT IN ('").append(disabledAppIdsStr).append("')");
        }
    }

    private void appendCloudFilter(StringBuilder sb) {
        String cloudStr;
        Set disabledCloudIds;
        List<String> cloudIdsBlackListFromStd;
        StringBuilder cloud = new StringBuilder();
        String cloudIdBlackList = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (StringUtils.isNotEmpty((String)cloudIdBlackList)) {
            cloud.append(cloudIdBlackList);
        }
        if (!CollectionUtils.isEmpty(cloudIdsBlackListFromStd = PermFormCommonUtil.getCloudIdsFromStdBlackList())) {
            for (int i = 0; i < cloudIdsBlackListFromStd.size(); ++i) {
                cloudIdsBlackListFromStd.set(i, "'" + cloudIdsBlackListFromStd.get(i) + "'");
            }
            String cloudIds = String.join((CharSequence)",", cloudIdsBlackListFromStd);
            if (StringUtils.isNotEmpty((String)cloudIds)) {
                if (StringUtils.isNotEmpty((String)cloud.toString())) {
                    cloud.append(',').append(cloudIds);
                } else {
                    cloud.append(cloudIds);
                }
            }
        }
        if (null != (disabledCloudIds = ManageServiceHelper.getDisabledCloudIds()) && !disabledCloudIds.isEmpty()) {
            String disabledCloudIdsStr = String.join((CharSequence)"','", disabledCloudIds);
            disabledCloudIdsStr = "'" + disabledCloudIdsStr + "'";
            if (StringUtils.isNotEmpty((String)cloud.toString())) {
                cloud.append(',').append(disabledCloudIdsStr);
            } else {
                cloud.append(disabledCloudIdsStr);
            }
        }
        if (StringUtils.isNotEmpty((String)(cloudStr = cloud.toString()))) {
            sb.append(" and cloud.fid NOT IN (").append(cloudStr).append(')');
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IDataModel model = this.getModel();
        boolean ifChanged = StringUtils.isNotEmpty((String)this.getPageCache().get("dataChanged"));
        if (ifChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("beforeCloseConfirm", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AdminGroupPermPlugin_27", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AdminGroupPermPlugin_28", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AdminGroupPermPlugin_29", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, model.getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            e.setCancel(true);
        } else {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String adminGroupStr = (String)customParams.get("adminGroupId");
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                MutexHelper.release((String)"perm_admingroup", (String)"modify", (String)adminGroupStr);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        switch (callBackId = event.getCallBackId()) {
            case "beforeCloseConfirm": {
                PermFormCommonUtil.closeClientForm(this.getView());
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                String adminGroupStr = (String)customParams.get("adminGroupId");
                if (!this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) break;
                MutexHelper.release((String)"perm_admingroup", (String)"modify", (String)adminGroupStr);
                break;
            }
            case "btn_save": {
                this.saveItemClick(false);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("addUser".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            this.afterExceptionUserSelected((ListSelectedRowCollection)closedCallBackEvent.getReturnData());
        }
    }

    private void afterExceptionUserSelected(ListSelectedRowCollection selectedRows) {
        this.getModel().deleteEntryData("entryentity");
        this.getPageCache().put("extraUser_change", "true");
        String currentExtraUserIds = this.getPageCache().get("Current_ExtraUser");
        Set extraUserIdsStr = (Set)SerializationUtils.fromJsonString((String)currentExtraUserIds, Set.class);
        Set<Long> extraUserIds = extraUserIdsStr.stream().map(Long::parseLong).collect(Collectors.toSet());
        HashSet<String> addUserIds = new HashSet<String>(16);
        this.getModel().beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("admin_exception_user", new Object[0]);
        for (ListSelectedRow row : selectedRows) {
            Long userId = (Long)row.getPrimaryKeyValue();
            addUserIds.add(String.valueOf(userId));
            extraUserIds.add(userId);
            extraUserIdsStr.add(String.valueOf(userId));
        }
        extraUserIds.forEach(xva$0 -> vs.addRow(new Object[]{xva$0}));
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        if (this.updateAddCache(addUserIds, true, "user_add_ids") || this.updateDelCache(addUserIds, false, "user_del_ids")) {
            this.getPageCache().put("dataChanged", "true");
        }
        this.getPageCache().put("Current_ExtraUser", SerializationUtils.toJsonString((Object)extraUserIdsStr));
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
        TreeView tv = (TreeView)event.getSource();
        String nodeId = (String)event.getNodeId();
        Boolean checked = event.getChecked();
        String treeViewKey = tv.getKey();
        if ("-1".equals(nodeId)) {
            if (checked.booleanValue()) {
                this.checkAtRoot(tv, treeViewKey);
            } else {
                tv.uncheckNodes(tv.getTreeState().getCheckedNodeIds());
                this.treeNodeUncheckAtRoot(treeViewKey);
            }
        } else {
            this.checkTreeNode(tv, treeViewKey, nodeId, checked);
        }
    }

    private void checkTreeNode(TreeView tv, String treeViewKey, String nodeId, boolean checked) {
        String orgInfo;
        IPageCache pageCache = this.getPageCache();
        String longNumber = "";
        String leftNodesCheckedCacheKey = null;
        String orgRootNodeCacheKey = null;
        boolean includeSub = false;
        boolean searchMode = false;
        String treeSource = "";
        if ("orgtree".equals(treeViewKey)) {
            orgInfo = this.bizUnitNodeMap.get(nodeId);
            if (StringUtils.isEmpty((String)orgInfo)) {
                return;
            }
            longNumber = orgInfo.split("_split_")[2];
            leftNodesCheckedCacheKey = "orgTreeLeftNodeIds";
            orgRootNodeCacheKey = "orgTreeLeftRoot";
            includeSub = (Boolean)this.getModel().getValue("bizleftincludesub");
            searchMode = !StringUtils.isEmpty((String)pageCache.get("orgtree_search"));
            treeSource = "bizLeftSource";
        } else if ("adminorgtree".equals(treeViewKey)) {
            longNumber = this.adminOrgNodeMap.get(nodeId).split("_split_")[2];
            leftNodesCheckedCacheKey = "AdminOrgTreeLeftNodeIds";
            orgRootNodeCacheKey = "AdminOrgTreeLeftRoot";
            includeSub = (Boolean)this.getModel().getValue("adminleftincludesub");
            searchMode = !StringUtils.isEmpty((String)pageCache.get("adminorgtree_search"));
            treeSource = "adminLeftSource";
        } else if ("selectedorgtree".equals(treeViewKey)) {
            orgInfo = this.bizUnitNodeMap.get(nodeId);
            longNumber = StringUtils.isEmpty((String)orgInfo) ? this.queryOrgLongNumber(Long.parseLong(nodeId), 15L) : orgInfo.split("_split_")[2];
            leftNodesCheckedCacheKey = "orgTreeRightNodeIds";
            orgRootNodeCacheKey = "orgTreeRightRoot";
            includeSub = (Boolean)this.getModel().getValue("bizrightincludesub");
            searchMode = !StringUtils.isEmpty((String)pageCache.get("selectedorgtree_search"));
            treeSource = "bizRightSource";
        } else if ("selectedadminorgtree".equals(treeViewKey)) {
            orgInfo = this.adminOrgNodeMap.get(nodeId);
            longNumber = StringUtils.isEmpty((String)orgInfo) ? this.queryOrgLongNumber(Long.parseLong(nodeId), 1L) : orgInfo.split("_split_")[2];
            leftNodesCheckedCacheKey = "AdminOrgTreeRightNodeIds";
            orgRootNodeCacheKey = "AdminOrgTreeRightRoot";
            includeSub = (Boolean)this.getModel().getValue("adminrightincludesub");
            searchMode = !StringUtils.isEmpty((String)pageCache.get("selectedadminorgtree_search"));
            treeSource = "adminRightSource";
        }
        String leftTreeNodeIdsJson = pageCache.get(leftNodesCheckedCacheKey);
        HashSet<String> ids = new HashSet<String>(1000);
        if (StringUtils.isNotEmpty((String)leftTreeNodeIdsJson)) {
            ids = (Set)SerializationUtils.fromJsonString((String)leftTreeNodeIdsJson, Set.class);
        }
        if (checked) {
            ids.add(nodeId);
        } else {
            ids.remove(nodeId);
        }
        TreeNode treeRootFromCache = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(orgRootNodeCacheKey), TreeNode.class);
        TreeNode parentTreeNode = treeRootFromCache.getTreeNode(nodeId, 100);
        if (null == parentTreeNode) {
            return;
        }
        parentTreeNode.setCheckable(checked);
        if (includeSub) {
            ArrayList<TreeNode> childrenNodes2Handle = new ArrayList<TreeNode>(10);
            ArrayList<String> childrenNodes2HandleId = new ArrayList<String>(10);
            if (searchMode) {
                this.synchronizeSubOrg(parentTreeNode, ids, childrenNodes2Handle, childrenNodes2HandleId, checked);
            } else {
                List dataSource = SerializationUtils.fromJsonStringToList((String)pageCache.get(treeSource), AdminGroupOrgSearchBean.class);
                longNumber = longNumber + ' ';
                for (AdminGroupOrgSearchBean bean : dataSource) {
                    if (!bean.getLongNumber().startsWith(longNumber)) continue;
                    String currentNodeId = bean.getId();
                    TreeNode treeNode = treeRootFromCache.getTreeNode(currentNodeId, 100);
                    if (treeNode != null) {
                        childrenNodes2Handle.add(treeNode);
                        childrenNodes2HandleId.add(currentNodeId);
                        treeNode.setCheckable(checked);
                    }
                    if (checked) {
                        ids.add(currentNodeId);
                        continue;
                    }
                    ids.remove(currentNodeId);
                }
            }
            if (checked) {
                tv.checkNodes(childrenNodes2Handle);
            } else {
                tv.uncheckNodes(childrenNodes2HandleId);
            }
        }
        pageCache.put(orgRootNodeCacheKey, SerializationUtils.toJsonString((Object)treeRootFromCache));
        pageCache.put(leftNodesCheckedCacheKey, SerializationUtils.toJsonString(ids));
    }

    private String queryOrgLongNumber(long orgId, long viewId) {
        String sql = "SELECT flongnumber FROM t_org_structure WHERE forgid = ? and fviewid = ? ";
        return (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{orgId, viewId}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String longNumber = "";
                if (rs.next()) {
                    longNumber = rs.getString(1);
                }
                if (StringUtils.isNotEmpty((String)longNumber)) {
                    longNumber = longNumber.replace("!", " ");
                }
                return longNumber;
            }
        });
    }

    private void synchronizeSubOrg(TreeNode treeNode, Set<String> ids, List<TreeNode> childrenNodes2Handle, List<String> childrenNodes2HandleId, boolean checked) {
        List children = treeNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            for (TreeNode child : children) {
                String id = child.getId();
                child.setCheckable(checked);
                if (checked) {
                    ids.add(id);
                } else {
                    ids.remove(id);
                    childrenNodes2HandleId.add(id);
                }
                this.synchronizeSubOrg(child, ids, childrenNodes2Handle, childrenNodes2HandleId, checked);
            }
            childrenNodes2Handle.addAll(children);
        }
    }

    public List<Map<String, String>> getOrgChildrenTreeData(long parentId, long adminGroupId, String orgViewType) {
        final ArrayList<Map<String, String>> orgTreeData = new ArrayList<Map<String, String>>(10);
        if (adminGroupId == 0L) {
            return orgTreeData;
        }
        String topTree = "15".equals(orgViewType) ? this.getPageCache().get("15_super") : this.getPageCache().get("01_super");
        String langName = RequestContext.get().getLang().name();
        String entryTableName = "";
        String entryKeyField = "forgid";
        String orgViewTypeValue = "";
        if (orgViewType.equals("01")) {
            entryTableName = "t_perm_admingrouporg";
            orgViewTypeValue = "1";
        } else if (orgViewType.equals("15")) {
            entryTableName = "t_perm_admingroupbizunit";
            orgViewTypeValue = "15";
        }
        DynamicObject parentOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("view.isdefault", "=", (Object)"1"), new QFilter("view", "=", (Object)Long.valueOf(orgViewTypeValue)), new QFilter("org.id", "=", (Object)parentId)});
        if (parentOrg == null) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select DISTINCT os.FORGID org,orgl.fname name,os.fparentid parent,os.fisleaf isleaf, os.FLONGNUMBER longnumber ");
        sqlBuilder.append(" from t_org_structure os ");
        if (StringUtils.isEmpty((String)topTree)) {
            sqlBuilder.append(" left join ").append(entryTableName).append(" pae on pae.").append(entryKeyField).append(" = os.FORGID ");
            sqlBuilder.append(" left join t_perm_admingroup pa on pa.fid = pae.fusergroupid ");
        }
        sqlBuilder.append(" left join t_org_org torg on (torg.fid = os.FORGID and torg.fenable = '1') ");
        sqlBuilder.append(" inner join t_org_org_l orgl on (orgl.fid = torg.fid and orgl.flocaleid = '").append(langName).append("') ");
        sqlBuilder.append(" where os.FVIEWID = ").append(Long.parseLong(orgViewTypeValue)).append(" and os.FLONGNUMBER like  ? ").append(" and os.fisfreeze = '0' ");
        if (StringUtils.isEmpty((String)topTree)) {
            sqlBuilder.append(" and pa.fid = ? ");
        }
        sqlBuilder.append(" order by longnumber ");
        Object[] params = null;
        if (StringUtils.isEmpty((String)topTree)) {
            params = new SqlParameter[2];
            params[1] = new SqlParameter(":pa.fid", -5, (Object)adminGroupId);
        } else {
            params = new SqlParameter[]{new SqlParameter(":os.FLONGNUMBER", 12, (Object)(parentOrg.getString("longnumber") + "!%"))};
        }
        DB.query((DBRoute)DBRoute.basedata, (String)sqlBuilder.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws KDException {
                try {
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        if (rs.getString("org") == null || rs.getString("org") != null && StringUtils.isEmpty((String)rs.getString("org"))) continue;
                        map.put("id", rs.getString("org") == null ? "0" : rs.getString("org"));
                        map.put("name", rs.getString("name") == null ? "" : rs.getString("name"));
                        map.put("parentid", rs.getString("parent") == null ? "0" : rs.getString("parent"));
                        map.put("isleaf", rs.getString("isleaf"));
                        String longNumber = rs.getString("longnumber");
                        if (longNumber != null) {
                            longNumber = longNumber.replace('!', ' ');
                        }
                        map.put("longnumber", longNumber);
                        orgTreeData.add(map);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                }
                return null;
            }
        });
        return orgTreeData;
    }

    private void treeNodeUncheckAtRoot(String treeViewKey) {
        String treeNodeRootCache = null;
        if ("selectedorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "orgTreeRightRoot";
            this.getPageCache().remove("orgTreeRightNodeIds");
        } else if ("orgtree".equals(treeViewKey)) {
            treeNodeRootCache = "orgTreeLeftRoot";
            this.getPageCache().remove("orgTreeLeftNodeIds");
        } else if ("selectedadminorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "AdminOrgTreeRightRoot";
            this.getPageCache().remove("AdminOrgTreeRightNodeIds");
        } else if ("adminorgtree".equals(treeViewKey)) {
            treeNodeRootCache = "AdminOrgTreeLeftRoot";
            this.getPageCache().remove("AdminOrgTreeLeftNodeIds");
        }
        TreeNode treeNodeRoot = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeNodeRootCache), TreeNode.class);
        treeNodeRoot.setCheckable(false);
        List children = treeNodeRoot.getChildren();
        this.uncheckChildNodes(children);
        this.getPageCache().put(treeNodeRootCache, SerializationUtils.toJsonString((Object)treeNodeRoot));
    }

    private void uncheckChildNodes(List<TreeNode> nodes) {
        if (!CollectionUtils.isEmpty(nodes)) {
            nodes.forEach(x -> {
                x.setCheckable(false);
                List children = x.getChildren();
                this.uncheckChildNodes(children);
            });
        }
    }

    public void checkAtRoot(TreeView tv, String treeViewKey) {
        TreeNode rootOrgNode;
        String orgTreeRootCache;
        IPageCache pageCache = this.getPageCache();
        String treeNodeCacheKey = "";
        String treeNodesCheckedCacheKey = "";
        String treeSource = "";
        if ("orgtree".equals(treeViewKey)) {
            treeNodeCacheKey = "orgTreeLeftRoot";
            treeNodesCheckedCacheKey = "orgTreeLeftNodeIds";
            treeSource = StringUtils.isEmpty((String)pageCache.get("orgtree_search")) ? "bizLeftSource" : "bizLeftSource_search";
        } else if ("adminorgtree".equals(treeViewKey)) {
            treeNodeCacheKey = "AdminOrgTreeLeftRoot";
            treeNodesCheckedCacheKey = "AdminOrgTreeLeftNodeIds";
            treeSource = StringUtils.isEmpty((String)pageCache.get("adminorgtree_search")) ? "adminLeftSource" : "adminLeftSource_search";
        } else if ("selectedorgtree".equals(treeViewKey)) {
            treeNodeCacheKey = "orgTreeRightRoot";
            treeNodesCheckedCacheKey = "orgTreeRightNodeIds";
            treeSource = StringUtils.isEmpty((String)pageCache.get("selectedorgtree_search")) ? "bizRightSource" : "bizRightSource_search";
        } else if ("selectedadminorgtree".equals(treeViewKey)) {
            treeNodeCacheKey = "AdminOrgTreeRightRoot";
            treeNodesCheckedCacheKey = "AdminOrgTreeRightNodeIds";
            treeSource = StringUtils.isEmpty((String)pageCache.get("selectedadminorgtree_search")) ? "adminRightSource" : "adminRightSource_search";
        }
        String orgTreeLeftNodeIdsJson = pageCache.get(treeNodesCheckedCacheKey);
        HashSet<String> orgTreeLeftNodeIds = orgTreeLeftNodeIdsJson != null ? (HashSet<String>)SerializationUtils.fromJsonString((String)orgTreeLeftNodeIdsJson, Set.class) : new HashSet<String>(16);
        String treeSourceData = pageCache.get(treeSource);
        if (StringUtils.isNotEmpty((String)treeSourceData)) {
            List dataSource = SerializationUtils.fromJsonStringToList((String)treeSourceData, AdminGroupOrgSearchBean.class);
            for (AdminGroupOrgSearchBean bean : dataSource) {
                orgTreeLeftNodeIds.add(bean.getId());
            }
        }
        if (StringUtils.isNotEmpty((String)(orgTreeRootCache = pageCache.get(treeNodeCacheKey))) && (rootOrgNode = (TreeNode)SerializationUtils.fromJsonString((String)orgTreeRootCache, TreeNode.class)) != null) {
            rootOrgNode.setCheckable(true);
            ArrayList<TreeNode> childNodeNeedChecked = new ArrayList<TreeNode>(1000);
            ArrayList<String> childrenNodes2HandleId = new ArrayList<String>(10);
            this.synchronizeSubOrg(rootOrgNode, orgTreeLeftNodeIds, childNodeNeedChecked, childrenNodes2HandleId, true);
            tv.checkNodes(childNodeNeedChecked);
            this.getPageCache().put(treeNodesCheckedCacheKey, SerializationUtils.toJsonString(orgTreeLeftNodeIds));
            this.getPageCache().put(treeNodeCacheKey, SerializationUtils.toJsonString((Object)rootOrgNode));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String adminGroupIdStr = (String)customParams.get("adminGroupId");
        String adminGroupParentIdStr = (String)customParams.get("adminGroupParentId");
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equalsIgnoreCase(adminGroupParentIdStr)) {
            adminGroupParentIdStr = "0";
        }
        Long adminGroupId = Long.parseLong(adminGroupIdStr);
        TreeView tv = (TreeView)e.getSource();
        String nodeId = (String)e.getNodeId();
        switch (tv.getKey()) {
            case "orgtree": {
                adminGroupId = Long.parseLong(adminGroupParentIdStr);
                String topBizTree = this.getPageCache().get("15_super");
                if (StringUtils.isNotEmpty((String)topBizTree)) {
                    this.commonQueryTreeNodeChildren(tv, nodeId, "15", 0L, "orgTreeLeftRoot", true, "orgTreeLeftNodeIds");
                    break;
                }
                this.commonQueryTreeNodeChildren(tv, nodeId, "15", adminGroupId, "orgTreeLeftRoot", true, "orgTreeLeftNodeIds");
                break;
            }
            case "adminorgtree": {
                adminGroupId = Long.parseLong(adminGroupParentIdStr);
                String topAdminTree = this.getPageCache().get("01_super");
                if (StringUtils.isNotEmpty((String)topAdminTree)) {
                    this.commonQueryTreeNodeChildren(tv, nodeId, "01", 0L, "AdminOrgTreeLeftRoot", true, "AdminOrgTreeLeftNodeIds");
                    break;
                }
                this.commonQueryTreeNodeChildren(tv, nodeId, "01", adminGroupId, "AdminOrgTreeLeftRoot", true, "AdminOrgTreeLeftNodeIds");
                break;
            }
            case "selectedorgtree": {
                this.commonQueryTreeNodeChildren(tv, nodeId, "15", adminGroupId, "orgTreeRightRoot", false, "orgTreeRightNodeIds");
                break;
            }
            case "selectedadminorgtree": {
                this.commonQueryTreeNodeChildren(tv, nodeId, "01", adminGroupId, "AdminOrgTreeRightRoot", false, "AdminOrgTreeRightNodeIds");
            }
        }
    }

    private void commonQueryTreeNodeChildren(TreeView tv, String nodeId, String orgViewType, Long adminGroupId, String treeRootCache, boolean isLeftTree, String treeNodeIdCheckedCache) {
        if ("-1".equals(nodeId)) {
            return;
        }
        String orgDataCacheKey = null;
        String errorMsgNotInView = null;
        String errorMsgNotInView2 = null;
        boolean isBizTree = false;
        if (orgViewType.equals("15")) {
            orgDataCacheKey = adminGroupId + "_current_BizDatas";
            errorMsgNotInView = ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermPlugin_30", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            errorMsgNotInView2 = ResManager.loadKDString((String)"\u90e8\u5206\u4e1a\u52a1\u5355\u5143\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermPlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            isBizTree = true;
        } else if (orgViewType.equals("01")) {
            orgDataCacheKey = adminGroupId + "_current_AdminOrgDatas";
            errorMsgNotInView = ResManager.loadKDString((String)"\u8be5\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermPlugin_31", (String)"bos-permission-formplugin", (Object[])new Object[0]);
            errorMsgNotInView2 = ResManager.loadKDString((String)"\u90e8\u5206\u884c\u653f\u7ec4\u7ec7\u4e0d\u5728\u89c6\u56fe\u4e2d\u3002", (String)"AdminGroupPermPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        }
        String orgDataStr = this.getPageCache().get(orgDataCacheKey);
        List orgData = StringUtils.isNotEmpty((String)orgDataStr) && !"[]".equals(orgDataStr) ? SerializationUtils.fromJsonStringToList((String)orgDataStr, String.class) : this.queryOrgLongNumberByAdminGroupId(adminGroupId, orgViewType, isLeftTree);
        Map checkedNodeLongInfo = OrgServiceHelper.getOrgLongProperty((String)orgViewType, (long)Long.parseLong(nodeId));
        String checkedNodeLongNumber = (String)checkedNodeLongInfo.get("number");
        if (checkedNodeLongNumber == null) {
            StringBuilder mes = new StringBuilder(errorMsgNotInView).append(ResManager.loadKDString((String)"\u8bf7\u4fee\u590d\u7ec4\u7ec7\u6570\u636e[orgId:%s]\u3002", (String)"AdminGroupPermPlugin_32", (String)"bos-permission-formplugin", (Object[])new Object[]{nodeId}));
            this.getView().showTipNotification(mes.toString(), Integer.valueOf(7000));
            return;
        }
        checkedNodeLongNumber = checkedNodeLongNumber.replace('!', ' ');
        TreeNode treeRootNodeCache = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(treeRootCache), TreeNode.class);
        TreeNode parentTreeNode = treeRootNodeCache.getTreeNode(nodeId, 100);
        int size = orgData.size();
        int i = 0;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        String lastLongNumber = "_";
        for (String data : orgData) {
            String[] orgDataArr = data.split("_split_");
            String orgName = orgDataArr[1];
            if (orgDataArr.length < 5) {
                ++i;
                continue;
            }
            String orgLongNumber = orgDataArr[2];
            if (null == orgLongNumber || orgName == null) {
                this.getView().showTipNotification(errorMsgNotInView2, Integer.valueOf(7000));
                ++i;
                continue;
            }
            if (orgLongNumber.equals(checkedNodeLongNumber) || !orgLongNumber.startsWith(checkedNodeLongNumber + " ")) {
                ++i;
                continue;
            }
            if (!orgLongNumber.startsWith(lastLongNumber + " ") && !orgLongNumber.equals(lastLongNumber)) {
                TreeNode node = new TreeNode();
                node.setParentid(nodeId);
                if (i + 1 < size) {
                    String nextOrg = (String)orgData.get(i + 1);
                    String[] orgDataArrNext = nextOrg.split("_split_");
                    if (orgDataArrNext.length < 5) continue;
                    String nextLongNumber = orgDataArrNext[2];
                    if (nextLongNumber.startsWith(orgLongNumber + " ")) {
                        node.setChildren(new ArrayList());
                    }
                }
                node.setId(orgDataArr[0]);
                node.setText(orgDataArr[1]);
                node.setLongNumber(orgDataArr[2]);
                if (isBizTree && Boolean.parseBoolean(orgDataArr[3])) {
                    node.setIcon("kdfont kdfont-faren");
                }
                nodes.add(node);
                lastLongNumber = orgLongNumber;
            }
            ++i;
        }
        tv.addNodes(nodes);
        String treeNodeIdCheckedJson = this.getPageCache().get(treeNodeIdCheckedCache);
        Set ids = new HashSet(1000);
        if (StringUtils.isNotEmpty((String)treeNodeIdCheckedJson)) {
            ids = (Set)SerializationUtils.fromJsonString((String)treeNodeIdCheckedJson, Set.class);
        }
        ArrayList<TreeNode> needCheckChildren = new ArrayList<TreeNode>(10);
        for (TreeNode node : nodes) {
            if (!ids.contains(node.getId())) continue;
            node.setCheckable(true);
            needCheckChildren.add(node);
        }
        tv.checkNodes(needCheckChildren);
        if (!CollectionUtils.isEmpty(nodes)) {
            if (parentTreeNode.getChildren() == null) {
                parentTreeNode.setChildren(new ArrayList(10));
            }
            parentTreeNode.getChildren().addAll(nodes);
            this.getPageCache().put(treeRootCache, SerializationUtils.toJsonString((Object)treeRootNodeCache));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tabpage_sys".equals(tabKey)) {
            return;
        }
        String currentGroupInfo = this.getPageCache().get("current_group_info");
        String[] info = currentGroupInfo.split("_");
        Long adminGroupId = Long.parseLong(info[0]);
        Long adminGroupParentId = Long.parseLong(info[1]);
        Long level = Long.parseLong(info[2]);
        if ("tabpage_bizunit".equals(tabKey)) {
            String treeLoaded = this.getPageCache().get("tree_bizunit_loaded");
            if (StringUtils.isNotEmpty((String)treeLoaded)) {
                return;
            }
            this.initUnitTree("15", adminGroupParentId, level);
            this.buildSelectedOrgTree(adminGroupId, "15", level);
            this.getPageCache().put("tree_bizunit_loaded", "true");
        } else if ("tabpage_adminorg".equals(tabKey)) {
            String treeLoaded = this.getPageCache().get("tree_adminorg_loaded");
            if (StringUtils.isNotEmpty((String)treeLoaded)) {
                return;
            }
            this.initUnitTree("01", adminGroupParentId, level);
            this.buildSelectedOrgTree(adminGroupId, "01", level);
            this.loadExtraUser(adminGroupId);
            this.getPageCache().put("tree_adminorg_loaded", "true");
        } else if ("tabpage_app".equals(tabKey)) {
            String treeLoaded = this.getPageCache().get("tree_app_loaded");
            if (StringUtils.isNotEmpty((String)treeLoaded)) {
                return;
            }
            this.initAppTree(adminGroupParentId, level);
            this.buildSelectedAppTree(adminGroupId, level);
            this.getPageCache().put("tree_app_loaded", "true");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("shownum".equals(propName)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d...", (String)"AdminGroupPermPlugin_33", (String)"bos-permission-formplugin", (Object[])new Object[0])));
            IPageCache pageCache = this.getPageCache();
            pageCache.put("shownum", newValue + "");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String adminGroupStr = (String)customParams.get("adminGroupId");
            String levelStr = (String)customParams.get("level");
            long adminGroupId = Long.parseLong(adminGroupStr);
            long level = Long.parseLong(levelStr);
            if ("false".equals(newValue.toString())) {
                pageCache.remove("sysTreeLeftRoot");
            }
            this.initSysLeftTree(adminGroupId, level);
            if ("false".equals(newValue.toString())) {
                pageCache.remove("sysTreeRightRoot");
            }
            this.initSysRightTree(adminGroupId, level);
            this.getView().hideLoading();
        } else if ("appshownum".equals(propName)) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put("appshownum", newValue + "");
            String currentGroupInfo = this.getPageCache().get("current_group_info");
            String[] info = currentGroupInfo.split("_");
            Long adminGroupId = Long.parseLong(info[0]);
            Long adminGroupParentId = Long.parseLong(info[1]);
            Long level = Long.parseLong(info[2]);
            this.initAppTree(adminGroupParentId, level);
            this.buildSelectedAppTree(adminGroupId, level);
        }
    }

    private void save() {
        try {
            OperationResult executeOperate;
            String extraUser_change;
            String app_change;
            String admin_change;
            String biz_change;
            DynamicObject currentAdminGroup = (DynamicObject)this.getModel().getValue("usergroup");
            Long adminGroupId = currentAdminGroup.getLong("id");
            long level = currentAdminGroup.getLong("level");
            String curAdmGrpNumber = currentAdminGroup.getString("number");
            OperateOption option = OperateOption.create();
            option.setVariableValue("PERM_ENABLE_ENTITY_OPERSERVICE", "1");
            option.setVariableValue("permlog_busitype", "admingroupperm_save");
            option.setVariableValue("permlog_op", "save");
            option.setVariableValue("permlog_opbtn", ConstantsHelper.getSave());
            option.setVariableValue("permlog_interfacemethod", "AdminGroupPermPlugin.save");
            String formNum = this.getModel().getDataEntityType().getName();
            option.setVariableValue("permlog_formnum", formNum);
            option.setVariableValue("currbizappid", AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId()));
            HashMap<String, Set<AdmGrpFunperm>> willDelFunpermMap = new HashMap<String, Set<AdmGrpFunperm>>(8);
            HashMap<String, Set<AdmGrpFunperm>> willAddFunpermMap = new HashMap<String, Set<AdmGrpFunperm>>(8);
            HashMap<String, Set<AdmGrpBizUnit>> willDelBizUnitMap = new HashMap<String, Set<AdmGrpBizUnit>>(8);
            HashMap<String, Set<AdmGrpBizUnit>> willAddBizUnitMap = new HashMap<String, Set<AdmGrpBizUnit>>(8);
            HashMap<String, Set<AdmGrpOrg>> willDelOrgMap = new HashMap<String, Set<AdmGrpOrg>>(8);
            HashMap<String, Set<AdmGrpOrg>> willAddOrgMap = new HashMap<String, Set<AdmGrpOrg>>(8);
            HashMap<String, Set<AdmGrpApp>> willDelAppMap = new HashMap<String, Set<AdmGrpApp>>(8);
            HashMap<String, Set<AdmGrpApp>> willAddAppMap = new HashMap<String, Set<AdmGrpApp>>(8);
            HashMap<String, Set<AdmGrpOrgAddUser>> willDelOrgAddUserMap = new HashMap<String, Set<AdmGrpOrgAddUser>>(8);
            HashMap<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap = new HashMap<String, Set<AdmGrpOrgAddUser>>(8);
            IPageCache pageCache = this.getPageCache();
            String sys_change = pageCache.get("sys_change");
            if (StringUtils.isNotEmpty((String)sys_change)) {
                this.getChangeFunpermMap(curAdmGrpNumber, willDelFunpermMap, willAddFunpermMap, pageCache);
                option.setVariableValue("willDelFunpermMap", SerializationUtils.toJsonString(willDelFunpermMap));
                option.setVariableValue("willAddFunpermMap", SerializationUtils.toJsonString(willAddFunpermMap));
            }
            if (StringUtils.isNotEmpty((String)(biz_change = pageCache.get("biz_change")))) {
                this.getChangeBizUnitMap(adminGroupId, curAdmGrpNumber, willDelBizUnitMap, willAddBizUnitMap, pageCache);
                option.setVariableValue("willDelBizUnitMap", SerializationUtils.toJsonString(willDelBizUnitMap));
                option.setVariableValue("willAddBizUnitMap", SerializationUtils.toJsonString(willAddBizUnitMap));
            }
            if (StringUtils.isNotEmpty((String)(admin_change = pageCache.get("admin_change")))) {
                this.getChangeOrgMap(adminGroupId, curAdmGrpNumber, willDelOrgMap, willAddOrgMap, pageCache);
                option.setVariableValue("willDelOrgMap", SerializationUtils.toJsonString(willDelOrgMap));
                option.setVariableValue("willAddOrgMap", SerializationUtils.toJsonString(willAddOrgMap));
            }
            if (StringUtils.isNotEmpty((String)(app_change = pageCache.get("app_change")))) {
                this.getChangeAppMap(curAdmGrpNumber, willDelAppMap, willAddAppMap, pageCache);
                option.setVariableValue("willDelAppMap", SerializationUtils.toJsonString(willDelAppMap));
                option.setVariableValue("willAddAppMap", SerializationUtils.toJsonString(willAddAppMap));
            }
            if (StringUtils.isNotEmpty((String)(extraUser_change = pageCache.get("extraUser_change")))) {
                this.getChangeOrgAddUserMap(curAdmGrpNumber, willDelOrgAddUserMap, willAddOrgAddUserMap, pageCache);
                option.setVariableValue("willDelOrgAddUserMap", SerializationUtils.toJsonString(willDelOrgAddUserMap));
                option.setVariableValue("willAddOrgAddUserMap", SerializationUtils.toJsonString(willAddOrgAddUserMap));
            }
            if (!(executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_admingroup", (DynamicObject[])new DynamicObject[]{currentAdminGroup}, (OperateOption)option)).isSuccess()) {
                List allErrorOrValidateInfo = executeOperate.getAllErrorOrValidateInfo();
                if (null != allErrorOrValidateInfo && !allErrorOrValidateInfo.isEmpty()) {
                    List collect = allErrorOrValidateInfo.stream().map(x -> x.getMessage()).collect(Collectors.toList());
                    this.getView().showErrorNotification(String.join((CharSequence)"\r\n", collect));
                    return;
                }
                String message = executeOperate.getMessage();
                if (StringUtils.isNotEmpty((String)message)) {
                    this.getView().showErrorNotification(message);
                    return;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AdminGroupPermPlugin_35", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isNotEmpty((String)sys_change)) {
                Set currentPerm = (Set)SerializationUtils.fromJsonString((String)pageCache.get("Current_SysData"), Set.class);
                pageCache.put("Origin_SysData", SerializationUtils.toJsonString((Object)currentPerm));
                pageCache.remove("sysTreeRightRoot");
                this.initSysRightTree(adminGroupId, level);
            }
            if (StringUtils.isNotEmpty((String)biz_change)) {
                pageCache.remove("orgTreeRightRoot");
                pageCache.remove(adminGroupId + "_current_BizDatas");
                this.buildSelectedOrgTree(adminGroupId, "15", level);
            }
            if (StringUtils.isNotEmpty((String)admin_change)) {
                pageCache.remove("AdminOrgTreeRightRoot");
                pageCache.remove(adminGroupId + "_current_AdminOrgDatas");
                this.buildSelectedOrgTree(adminGroupId, "01", level);
            }
            if (StringUtils.isNotEmpty((String)app_change)) {
                pageCache.remove("Current_AppData");
                this.buildSelectedAppTree(adminGroupId, level);
            }
            if (StringUtils.isNotEmpty((String)extraUser_change)) {
                this.loadExtraUser(adminGroupId);
            }
            this.removeCache();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AdminGroupPermPlugin_34", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
        catch (Exception e) {
            logger.warn("\u7ba1\u7406\u5458\u6743\u9650\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25\uff0c{}", (Object)e.getMessage(), (Object)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AdminGroupPermPlugin_35", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    private void getChangeOrgAddUserMap(String curAdmGrpNumber, Map<String, Set<AdmGrpOrgAddUser>> willDelOrgAddUserMap, Map<String, Set<AdmGrpOrgAddUser>> willAddOrgAddUserMap, IPageCache pageCache) {
        String user_add_set = pageCache.get("user_add_ids");
        String user_del_set = pageCache.get("user_del_ids");
        Set originUser = (Set)SerializationUtils.fromJsonString((String)pageCache.get("Origin_ExtraUser"), Set.class);
        if (StringUtils.isNotEmpty((String)user_del_set)) {
            Set delUsersStr = (Set)SerializationUtils.fromJsonString((String)user_del_set, Set.class);
            HashSet delUsers = new HashSet(originUser);
            delUsers.retainAll(delUsersStr);
            Set delUserIds = delUsers.stream().map(Long::parseLong).collect(Collectors.toSet());
            if (delUserIds.size() > 0) {
                for (Long delUserId : delUserIds) {
                    willDelOrgAddUserMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpOrgAddUser::new).with(AdmGrpOrgAddUser::setUserId, (Object)delUserId).build());
                }
            }
        }
        if (StringUtils.isNotEmpty((String)user_add_set)) {
            Set addUsers = (Set)SerializationUtils.fromJsonString((String)user_add_set, Set.class);
            addUsers.removeAll(originUser);
            for (String userId : addUsers) {
                willAddOrgAddUserMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpOrgAddUser::new).with(AdmGrpOrgAddUser::setUserId, (Object)Long.parseLong(userId)).build());
            }
        }
    }

    private void getChangeAppMap(String curAdmGrpNumber, Map<String, Set<AdmGrpApp>> willDelAppMap, Map<String, Set<AdmGrpApp>> willAddAppMap, IPageCache pageCache) {
        String[] info;
        String app_add_set = pageCache.get("app_add_ids");
        String app_del_set = pageCache.get("app_del_ids");
        Set originApp = (Set)SerializationUtils.fromJsonString((String)pageCache.get("Origin_AppData"), Set.class);
        if (StringUtils.isNotEmpty((String)app_del_set)) {
            Set delApps = (Set)SerializationUtils.fromJsonString((String)app_del_set, Set.class);
            for (String app : delApps) {
                info = app.split("\\|");
                if (null == info) continue;
                willDelAppMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpApp::new).with(AdmGrpApp::setAppId, (Object)info[1]).build());
            }
        }
        if (StringUtils.isNotEmpty((String)app_add_set)) {
            Set addApps = (Set)SerializationUtils.fromJsonString((String)app_add_set, Set.class);
            addApps.removeAll(originApp);
            for (String app : addApps) {
                info = app.split("\\|");
                if (null == info) continue;
                willAddAppMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpApp::new).with(AdmGrpApp::setAppId, (Object)info[1]).build());
            }
        }
    }

    private void getChangeOrgMap(Long adminGroupId, String curAdmGrpNumber, Map<String, Set<AdmGrpOrg>> willDelOrgMap, Map<String, Set<AdmGrpOrg>> willAddOrgMMap, IPageCache pageCache) {
        String add_set = pageCache.get("admin_add_ids");
        String del_set = pageCache.get("admin_del_ids");
        Set originData = (Set)SerializationUtils.fromJsonString((String)pageCache.get(adminGroupId + "_AdminOrgDatas"), Set.class);
        Set originOrg = originData.stream().map(x -> x.split("_split_")[0]).collect(Collectors.toSet());
        if (StringUtils.isNotEmpty((String)del_set)) {
            Set delOrgs = (Set)SerializationUtils.fromJsonString((String)del_set, Set.class);
            for (String orgId : delOrgs) {
                willDelOrgMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpOrg::new).with(AdmGrpOrg::setOrgId, (Object)Long.parseLong(orgId)).build());
            }
        }
        if (StringUtils.isNotEmpty((String)add_set)) {
            Set addOrgs = (Set)SerializationUtils.fromJsonString((String)add_set, Set.class);
            addOrgs.removeAll(originOrg);
            for (String orgId : addOrgs) {
                willAddOrgMMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpOrg::new).with(AdmGrpOrg::setOrgId, (Object)Long.parseLong(orgId)).build());
            }
        }
    }

    private void getChangeBizUnitMap(Long adminGroupId, String curAdmGrpNumber, Map<String, Set<AdmGrpBizUnit>> willDelBizUnitMap, Map<String, Set<AdmGrpBizUnit>> willAddBizUnitMap, IPageCache pageCache) {
        String add_set = pageCache.get("biz_add_ids");
        String del_set = pageCache.get("biz_del_ids");
        Set originData = (Set)SerializationUtils.fromJsonString((String)pageCache.get(adminGroupId + "_BizDatas"), Set.class);
        Set originOrg = originData.stream().map(x -> x.split("_split_")[0]).collect(Collectors.toSet());
        if (StringUtils.isNotEmpty((String)del_set)) {
            Set delOrgs = (Set)SerializationUtils.fromJsonString((String)del_set, Set.class);
            for (String orgId : delOrgs) {
                willDelBizUnitMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpBizUnit::new).with(AdmGrpBizUnit::setOrgId, (Object)Long.parseLong(orgId)).build());
            }
        }
        if (StringUtils.isNotEmpty((String)add_set)) {
            Set addOrgs = (Set)SerializationUtils.fromJsonString((String)add_set, Set.class);
            addOrgs.removeAll(originOrg);
            for (String orgId : addOrgs) {
                willAddBizUnitMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpBizUnit::new).with(AdmGrpBizUnit::setOrgId, (Object)Long.parseLong(orgId)).build());
            }
        }
    }

    private void getChangeFunpermMap(String curAdmGrpNumber, Map<String, Set<AdmGrpFunperm>> willDelFunpermMap, Map<String, Set<AdmGrpFunperm>> willAddFunpermMap, IPageCache pageCache) {
        String[] info;
        String sys_add_set = pageCache.get("sys_add_ids");
        String sys_del_set = pageCache.get("sys_del_ids");
        Set originPerm = (Set)SerializationUtils.fromJsonString((String)pageCache.get("Origin_SysData"), Set.class);
        if (StringUtils.isNotEmpty((String)sys_del_set)) {
            Set delPerms = (Set)SerializationUtils.fromJsonString((String)sys_del_set, Set.class);
            for (String delPerm : delPerms) {
                info = delPerm.split("\\|");
                if (null == info) continue;
                willDelFunpermMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpFunperm::new).with(AdmGrpFunperm::setAppId, (Object)info[0]).with(AdmGrpFunperm::setEntNum, (Object)info[1]).with(AdmGrpFunperm::setPermItemId, (Object)info[2]).build());
            }
        }
        if (StringUtils.isNotEmpty((String)sys_add_set)) {
            Set addPerms = (Set)SerializationUtils.fromJsonString((String)sys_add_set, Set.class);
            addPerms.removeAll(originPerm);
            for (String addPerm : addPerms) {
                info = addPerm.split("\\|");
                if (null == info) continue;
                willAddFunpermMap.computeIfAbsent(curAdmGrpNumber, k -> new HashSet(8)).add(PermBuilder.of(AdmGrpFunperm::new).with(AdmGrpFunperm::setAppId, (Object)info[0]).with(AdmGrpFunperm::setEntNum, (Object)info[1]).with(AdmGrpFunperm::setPermItemId, (Object)info[2]).build());
            }
        }
    }

    private void removeCache() {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.remove("dataChanged");
        pageCache.remove("sys_change");
        pageCache.remove("sys_add_ids");
        pageCache.remove("sys_del_ids");
        pageCache.remove("biz_change");
        pageCache.remove("biz_add_ids");
        pageCache.remove("biz_del_ids");
        pageCache.remove("admin_change");
        pageCache.remove("admin_add_ids");
        pageCache.remove("admin_del_ids");
        pageCache.remove("app_change");
        pageCache.remove("app_add_ids");
        pageCache.remove("app_del_ids");
        pageCache.remove("extraUser_change");
        pageCache.remove("user_add_ids");
        pageCache.remove("user_del_ids");
        CacheMrg.clearAllCache();
        CacheMrg.clearHasEnableOldAdmin();
    }
}

