/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.admingroup.UserAdmGrp;
import kd.bos.permission.model.perm.req.CheckPermissionReq;
import kd.bos.permission.model.perm.req.PermOperationReq;
import kd.bos.permission.model.perm.req.admin.get.GetUserAdmGrpReq;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.permission.service.CommonService;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.permission.service.admingroup.UserAdmGrpService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class AdminGroupTreeListPlugin
extends AbstractTreeListPlugin {
    private static final Log logger = LogFactory.getLog(AdminGroupTreeListPlugin.class);
    public static final String BOS_USERTREELISTF7 = "bos_usertreelistf7";
    private static final String TREE_ADMIN_GROUP = "treeview";
    private static final String BAR_ADD = "bar_add";
    private static final String BAR_DEL = "bar_del";
    private static final String BAR_CLEANCACHE = "bar_cleancache";
    private static final String BAR_ASSGINPERM = "bar_assginperm";
    private static final String BAR_REFRESH = "bar_refresh";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String BTN_SETTING = "btnsetting";
    private static final String BTN_SEARCH = "searchap";
    private static final String CONFIRM_CALLBACK_DELETE_ADMIN_GROUP = "confirm_callBack_delete_admin_group";
    private static final String CONFIRM_CALLBACK_DELETE_ADMIN_GROUP_USER = "confirm_callBack_delete_admin_group_user";
    private int adminLevelLimit = 5;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        long userId = RequestContext.get().getCurrUserId();
        boolean isAdmin = new PermissionServiceImpl().isAdminUser(userId);
        if (!isAdmin) {
            e.setCancel(true);
            e.setCancelMessage(ConstantsHelper.getAdminCannotUseDesc());
        }
    }

    public void initialize() {
        this.adminLevelLimit = PermCommonUtil.getAdminLevelLimit();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_NEW, BTN_EDIT, BTN_DEL, BTN_SETTING});
        Search search = (Search)this.getControl(BTN_SEARCH);
        if (null != search) {
            search.addEnterListener(new SearchEnterListener(){

                public void search(SearchEnterEvent see) {
                    IPageCache pageCache = AdminGroupTreeListPlugin.this.getView().getPageCache();
                    TreeView tv = (TreeView)AdminGroupTreeListPlugin.this.getView().getControl(AdminGroupTreeListPlugin.TREE_ADMIN_GROUP);
                    String searchText = see.getText();
                    if (StringUtils.isNotEmpty((String)searchText)) {
                        String lastSearchText = pageCache.get("lastSearchText");
                        if (searchText.equals(lastSearchText)) {
                            String searchResultStr = pageCache.get("searchResult");
                            if (StringUtils.isNotEmpty((String)searchResultStr)) {
                                List searchResult = SerializationUtils.fromJsonStringToList((String)searchResultStr, String[].class);
                                int searchIndex = Integer.parseInt(pageCache.get("searchIndex"));
                                if (searchIndex == searchResult.size()) {
                                    searchIndex = 0;
                                }
                                String[] searchInfo = (String[])searchResult.get(searchIndex);
                                TreeNode treeNode = new TreeNode();
                                treeNode.setId(searchInfo[1]);
                                treeNode.setParentid(searchInfo[2]);
                                pageCache.put("searchIndex", searchIndex + 1 + "");
                                tv.focusNode(treeNode);
                                tv.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                            } else {
                                AdminGroupTreeListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u67e5\u8be2\u7ed3\u679c\u3002", (String)"AdminGroupTreeListPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                            }
                        } else {
                            List treeNodeInfos = SerializationUtils.fromJsonStringToList((String)pageCache.get("treeNodeInfos"), String[].class);
                            ArrayList<String[]> searchResult = new ArrayList<String[]>(treeNodeInfos.size());
                            for (String[] treeNodeInfo : treeNodeInfos) {
                                if (!treeNodeInfo[0].contains(searchText)) continue;
                                searchResult.add(treeNodeInfo);
                            }
                            if (CollectionUtils.isEmpty(searchResult)) {
                                AdminGroupTreeListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u67e5\u8be2\u7ed3\u679c\u3002", (String)"AdminGroupTreeListPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                            } else {
                                pageCache.put("searchResult", SerializationUtils.toJsonString(searchResult));
                                pageCache.put("lastSearchText", searchText);
                                String[] searchInfo = (String[])searchResult.get(0);
                                TreeNode treeNode = new TreeNode();
                                treeNode.setId(searchInfo[1]);
                                treeNode.setParentid(searchInfo[2]);
                                pageCache.put("searchIndex", "1");
                                tv.focusNode(treeNode);
                                tv.treeNodeClick(treeNode.getParentid(), treeNode.getId());
                            }
                        }
                    }
                }
            });
        }
    }

    public void initializeTree(EventObject e) {
        TreeNode root = null;
        try {
            root = AdminGroupService.initAdminGroupTree((TreeView)((TreeView)this.getControl(TREE_ADMIN_GROUP)), (IPageCache)this.getView().getPageCache());
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            return;
        }
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().setVisible(Boolean.FALSE, new String[]{"cardview"});
    }

    public void initTreeToolbar(EventObject e) {
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof FormOperate && "donothing_delete".equals(opKey = ((FormOperate)e.getSource()).getOperateKey())) {
            List superiorGroupId;
            String entNum = "perm_useradmingroup";
            String permItemId = "4715e1f1000000ac";
            PermResult permResult = PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(RequestContext.get().getCurrUserId()), null, "0XWTKVOQW+ML", entNum, permItemId));
            if (!permResult.isOk()) {
                String curEntityName = FormMetadataCache.getFormConfig((String)entNum).getCaption().toString();
                String permItemName = PermItemHelper.getPermItemNameById((String)permItemId);
                String finalMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrlCheckPermPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), curEntityName, permItemName);
                this.getView().showErrorNotification(finalMsg);
                e.setCancel(true);
                return;
            }
            IPageCache pageCache = this.getPageCache();
            TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            String adminGroupId = focusNodeId.split("_")[0];
            if (!"8609760E-EF83-4775-A9FF-CCDEC7C0B689".equalsIgnoreCase(adminGroupId) && (superiorGroupId = (List)SerializationUtils.fromJsonString((String)pageCache.get("superiorGroupIds"), List.class)).contains(Long.valueOf(adminGroupId))) {
                this.getView().showTipNotification(this.getOnlyModifySubGroupText(), Integer.valueOf(2000));
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        if (e.getSource() instanceof FormOperate && "donothing_delete".equals(opKey = ((FormOperate)e.getSource()).getOperateKey()) && e.getOperationResult().isSuccess()) {
            List successPkIds = e.getOperationResult().getSuccessPkIds();
            this.getPageCache().put("deleteUserIds", SerializationUtils.toJsonString((Object)successPkIds));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u8bb0\u5f55\u5417\uff1f", (String)"AdminGroupTreeListPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_DELETE_ADMIN_GROUP_USER));
        }
    }

    private void deleteAdmin() {
        List allErrorOrValidateInfo;
        String deleteUserIds = this.getPageCache().get("deleteUserIds");
        if (StringUtils.isEmpty((String)deleteUserIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7ba1\u7406\u5458\u3002", (String)"AdminGroupTreeListPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        List delUserIds = (List)SerializationUtils.fromJsonString((String)deleteUserIds, List.class);
        OperateOption operateOption = OperateOption.create();
        DynamicObject[] userAdminGroups = BusinessDataServiceHelper.load((String)"perm_useradmingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)delUserIds)});
        operateOption.setVariableValue("PERM_ENABLE_ENTITY_OPERSERVICE", "1");
        operateOption.setVariableValue("permlog_op", "donothing_delete");
        operateOption.setVariableValue("permlog_opbtn", ConstantsHelper.getDel());
        operateOption.setVariableValue("permlog_interfacemethod", "kd.bos.permission.formplugin.plugin.AdminGroupTreeListPlugin.deleteAdmin");
        String formNum = "perm_useradmingroup";
        operateOption.setVariableValue("permlog_formnum", formNum);
        operateOption.setVariableValue("currbizappid", AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId()));
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_useradmingroup", (DynamicObject[])userAdminGroups, (OperateOption)operateOption);
        List list = allErrorOrValidateInfo = null == executeOperate.getAllErrorOrValidateInfo() ? new ArrayList(0) : executeOperate.getAllErrorOrValidateInfo();
        if (!allErrorOrValidateInfo.isEmpty()) {
            StringBuilder notDelData = new StringBuilder();
            Set collect = allErrorOrValidateInfo.stream().map(x -> String.valueOf(x.getPkValue())).collect(Collectors.toSet());
            Map dataMap = UserAdmGrpService.getUserAdmGrpMap((GetUserAdmGrpReq)new GetUserAdmGrpReq(collect, null, null, null, null, null));
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                Object pkValue = iOperateInfo.getPkValue();
                UserAdmGrp userAdmGrp = (UserAdmGrp)dataMap.get(pkValue);
                if (null == userAdmGrp) continue;
                notDelData.append('[').append(userAdmGrp.getAdminGroupName()).append(" - ").append(userAdmGrp.getTrueName()).append("]\r\n");
            }
            StringBuilder sb = new StringBuilder();
            List successPkIds = null == executeOperate.getSuccessPkIds() ? new ArrayList(0) : executeOperate.getSuccessPkIds();
            sb.append(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\uff0c\u63a7\u5236\u8303\u56f4\u5916\u6570\u636e\u65e0\u6cd5\u5220\u9664\uff1a", (String)"AdminGroupTreeListPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[]{successPkIds.size()}));
            sb.append("\r\n").append((CharSequence)notDelData);
            this.getView().showMessage(sb.toString());
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AdminGroupTreeListPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().remove("deleteUserIds");
        this.clearCache();
        this.refresh();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_add": {
                String entNum = "perm_useradmingroup";
                String permItemId = "47156aff000000ac";
                PermResult permResult = PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(RequestContext.get().getCurrUserId()), null, "0XWTKVOQW+ML", entNum, permItemId));
                if (!permResult.isOk()) {
                    String curEntityName = FormMetadataCache.getFormConfig((String)entNum).getCaption().toString();
                    String permItemName = PermItemHelper.getPermItemNameById((String)permItemId);
                    String finalMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrlCheckPermPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), curEntityName, permItemName);
                    this.getView().showErrorNotification(finalMsg);
                    return;
                }
                this.showUserF7TreeList();
                break;
            }
            case "bar_assginperm": {
                this.showAdminGroupDetail();
                break;
            }
            case "bar_cleancache": {
                this.clearCache();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6743\u9650\u7f13\u5b58\u5df2\u6e05\u7406\u3002", (String)"AdminGroupTreeListPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_refresh": {
                this.refresh();
            }
        }
    }

    private void refresh() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
        TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
        if (tv != null && tv.getTreeState().getFocusNode() != null) {
            DynamicObject adminGroup;
            Map focusNode = tv.getTreeState().getFocusNode();
            String id = focusNode.get("id").toString();
            String[] idInfo = id.split("_");
            TreeNode root = null;
            try {
                root = AdminGroupService.initAdminGroupTree((TreeView)((TreeView)this.getControl(TREE_ADMIN_GROUP)), (IPageCache)this.getView().getPageCache());
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
                return;
            }
            this.getTreeModel().setRoot(root);
            if (!"8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(id) && (adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(idInfo[0]), (String)"perm_admingroup", (String)"id")) != null) {
                tv.focusNode(new TreeNode(String.valueOf(focusNode.get("parentid")), String.valueOf(focusNode.get("id")), String.valueOf(focusNode.get("text"))));
                tv.treeNodeClick(focusNode.get("parentid").toString(), id);
            }
        }
    }

    private void clearCache() {
        try {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            CacheMrg.clearAllLocalCache();
            CacheMrg.clearType4EditingPermUserId();
        }
        catch (Exception e) {
            logger.warn("AdminGroupTreeListPlugin.clearCache error", (Throwable)e);
        }
    }

    private void showAdminGroupDetail() {
        String entNum = "perm_admingroup";
        String permItemId = "475JVY657J0/";
        PermResult permResult = PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(RequestContext.get().getCurrUserId()), null, "0XWTKVOQW+ML", entNum, permItemId));
        if (!permResult.isOk()) {
            String curEntityName = FormMetadataCache.getFormConfig((String)entNum).getCaption().toString();
            String permItemName = PermItemHelper.getPermItemNameById((String)permItemId);
            String finalMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrlCheckPermPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), curEntityName, permItemName);
            this.getView().showErrorNotification(finalMsg);
            return;
        }
        TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
        IPageCache pageCache = this.getPageCache();
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)focusNodeId)) {
            focusNodeId = pageCache.get("focusNodeId");
        }
        String parentNodeId = pageCache.get("focusNodeParentId");
        String focusNodeLongNumber = pageCache.get("focusNodeLongNumber");
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equalsIgnoreCase(focusNodeId)) {
            this.getView().showTipNotification(this.getNotRootNodeText(), Integer.valueOf(2000));
            return;
        }
        if (!"8609760E-EF83-4775-A9FF-CCDEC7C0B689".equalsIgnoreCase(parentNodeId)) {
            parentNodeId = parentNodeId.split("_")[0];
        }
        FormShowParameter lsp = new FormShowParameter();
        String[] nodeInfo = focusNodeId.split("_");
        String adminGroupId = nodeInfo[0];
        DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(adminGroupId), (String)"perm_admingroup", (String)"id");
        if (adminGroup == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AdminGroupTreeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        String newPageId = adminGroupId + "|" + this.getView().getPageId();
        lsp.setPageId(newPageId);
        lsp.setFormId("perm_admin_group_detail");
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.getCustomParams().put("adminScheme", pageCache.get("adminScheme"));
        lsp.getCustomParams().put("adminType", pageCache.get("adminType"));
        lsp.getCustomParams().put("oriPageId", this.getView().getPageId());
        List superiorGroupId = (List)SerializationUtils.fromJsonString((String)pageCache.get("superiorGroupIds"), List.class);
        if (superiorGroupId.contains(Long.valueOf(adminGroupId)) || OperationStatus.VIEW.equals((Object)lsp.getStatus())) {
            lsp.setStatus(OperationStatus.VIEW);
        } else {
            lsp.setStatus(OperationStatus.EDIT);
        }
        IFormView fv = this.getView().getView(newPageId);
        if (fv == null && OperationStatus.EDIT.equals((Object)lsp.getStatus())) {
            StringBuilder sbErrorInfo = new StringBuilder();
            boolean require = MutexHelper.require((String)"perm_admingroup", (Object)adminGroupId, (String)"modify", (StringBuilder)sbErrorInfo);
            if (!require) {
                this.getView().showMessage(sbErrorInfo.toString());
                lsp.setStatus(OperationStatus.VIEW);
            } else {
                lsp.setStatus(OperationStatus.EDIT);
            }
        }
        lsp.getCustomParams().put("adminGroupId", adminGroupId);
        lsp.getCustomParams().put("adminGroupParentId", parentNodeId);
        lsp.getCustomParams().put("level", nodeInfo[1]);
        lsp.getCustomParams().put("adminGroupLongNumber", focusNodeLongNumber);
        this.getView().showForm(lsp);
    }

    private void showUserF7TreeList() {
        String adminGroupId;
        IPageCache pageCache = this.getPageCache();
        TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)focusNodeId)) {
            focusNodeId = pageCache.get("focusNodeId");
        }
        if (!this.verifyAdmin(pageCache, adminGroupId = focusNodeId.split("_")[0])) {
            return;
        }
        Long admGrpIdL = Long.valueOf(adminGroupId);
        Map admGrpAddUserF7LspMap = UserAdmGrpService.getAdmGrpAddUserF7LspMap((Set)Sets.newHashSet((Object[])new Long[]{admGrpIdL}), null);
        if (null == admGrpAddUserF7LspMap || null == admGrpAddUserF7LspMap.get(admGrpIdL)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u5f39\u6846\u5217\u8868\u5931\u8d25\u3002", (String)"AdminGroupTreeListPlugin_21", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = (ListShowParameter)admGrpAddUserF7LspMap.get(admGrpIdL);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BOS_USERTREELISTF7));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private boolean verifyAdminGroup(IPageCache pageCache, String adminGroupId) {
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equalsIgnoreCase(adminGroupId)) {
            this.getView().showTipNotification(this.getNotRootNodeText(), Integer.valueOf(2000));
            return false;
        }
        Set canSavePermAdmGroupIdSet = AdminGroupService.getCanOperAdmGroupIdSet((Long)RequestContext.get().getCurrUserId(), (boolean)true, (String)"1");
        if (canSavePermAdmGroupIdSet.contains(adminGroupId)) {
            return true;
        }
        this.getView().showTipNotification(this.getOnlyModifySubGroupText(), Integer.valueOf(2000));
        return false;
    }

    private boolean verifyAdmin(IPageCache pageCache, String adminGroupId) {
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equalsIgnoreCase(adminGroupId)) {
            this.getView().showTipNotification(this.getNotRootNodeText(), Integer.valueOf(2000));
            return false;
        }
        List superiorGroupId = (List)SerializationUtils.fromJsonString((String)pageCache.get("superiorGroupIds"), List.class);
        if (superiorGroupId.contains(Long.valueOf(adminGroupId))) {
            this.getView().showTipNotification(this.getOnlyModifySubGroupText(), Integer.valueOf(2000));
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
        if (BTN_NEW.equals(ctrlKey)) {
            String[] arr;
            String adminGroupId;
            String entNum = "perm_admingroup";
            String permItemId = "47156aff000000ac";
            PermResult permResult = PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(RequestContext.get().getCurrUserId()), null, "0XWTKVOQW+ML", entNum, permItemId));
            if (!permResult.isOk()) {
                String curEntityName = FormMetadataCache.getFormConfig((String)entNum).getCaption().toString();
                String permItemName = PermItemHelper.getPermItemNameById((String)permItemId);
                String finalMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrlCheckPermPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), curEntityName, permItemName);
                this.getView().showErrorNotification(finalMsg);
                return;
            }
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            IPageCache pageCache = this.getPageCache();
            if (StringUtils.isEmpty((String)focusNodeId)) {
                focusNodeId = pageCache.get("focusNodeId");
            }
            if (!this.verifyAdminGroup(pageCache, adminGroupId = (arr = focusNodeId.split("_"))[0])) {
                return;
            }
            DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(adminGroupId), (String)"perm_admingroup", (String)"id");
            if (adminGroup == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AdminGroupTreeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            int level = Integer.parseInt(arr[1]);
            if (level >= this.adminLevelLimit) {
                this.getView().showTipNotification(this.getLevelLimitText());
                return;
            }
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("perm_admingroup");
            bsp.setStatus(OperationStatus.ADDNEW);
            bsp.getOpenStyle().setShowType(ShowType.Modal);
            bsp.setCustomParam("focusNodeToBeParent", (Object)adminGroupId);
            bsp.setCustomParam("adminScheme", (Object)pageCache.get("adminScheme"));
            bsp.setCustomParam("adminType", (Object)pageCache.get("adminType"));
            this.getView().showForm((FormShowParameter)bsp);
        } else if (BTN_EDIT.equals(ctrlKey)) {
            String entNum = "perm_admingroup";
            String permItemId = "4715a0df000000ac";
            PermResult permResult = PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(RequestContext.get().getCurrUserId()), null, "0XWTKVOQW+ML", entNum, permItemId));
            if (!permResult.isOk()) {
                String curEntityName = FormMetadataCache.getFormConfig((String)entNum).getCaption().toString();
                String permItemName = PermItemHelper.getPermItemNameById((String)permItemId);
                String finalMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrlCheckPermPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), curEntityName, permItemName);
                this.getView().showErrorNotification(finalMsg);
                return;
            }
            IPageCache pageCache = this.getPageCache();
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (StringUtils.isEmpty((String)focusNodeId)) {
                focusNodeId = pageCache.get("focusNodeId");
            }
            if (focusNodeId == null || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(focusNodeId)) {
                this.getView().showTipNotification(this.getNotRootNodeText());
                return;
            }
            String adminGroupIdStr = focusNodeId.split("_")[0];
            Long adminGroupId = Long.parseLong(adminGroupIdStr);
            DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id");
            if (adminGroup == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AdminGroupTreeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("perm_admingroup");
            bsp.setPkId((Object)adminGroupId);
            String newPageId = adminGroupId + "|" + this.getView().getPageId();
            bsp.setPageId(newPageId);
            if (!this.verifyAdminGroup(pageCache, adminGroupIdStr)) {
                return;
            }
            StringBuilder sbErrorInfo = new StringBuilder();
            boolean require = MutexHelper.require((String)"perm_admingroup", (Object)adminGroupId, (String)"modify", (StringBuilder)sbErrorInfo);
            if (!require) {
                this.getView().showTipNotification(sbErrorInfo.toString());
                bsp.setStatus(OperationStatus.VIEW);
            } else {
                bsp.setStatus(OperationStatus.EDIT);
                bsp.setEnableUserReentrant(true);
            }
            bsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)bsp);
        } else if (BTN_DEL.equals(ctrlKey)) {
            String entNum = "perm_admingroup";
            String permItemId = "4715e1f1000000ac";
            PermResult permResult = PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(RequestContext.get().getCurrUserId()), null, "0XWTKVOQW+ML", entNum, permItemId));
            if (!permResult.isOk()) {
                String curEntityName = FormMetadataCache.getFormConfig((String)entNum).getCaption().toString();
                String permItemName = PermItemHelper.getPermItemNameById((String)permItemId);
                String finalMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrlCheckPermPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), curEntityName, permItemName);
                this.getView().showErrorNotification(finalMsg);
                return;
            }
            Map focusNode = tv.getTreeState().getFocusNode();
            String focusNodeId = (String)focusNode.get("id");
            if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(focusNodeId)) {
                this.getView().showTipNotification(this.getNotRootNodeText());
                return;
            }
            String adminGroupIdStr = ((String)focusNode.get("id")).split("_")[0];
            Long adminGroupId = Long.parseLong(adminGroupIdStr);
            DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id");
            if (adminGroup == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AdminGroupTreeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            String name = (String)focusNode.get("text");
            StringBuilder sbErrorInfo = new StringBuilder();
            boolean require = MutexHelper.require((String)"perm_admingroup", (Object)adminGroupId, (String)"modify", (StringBuilder)sbErrorInfo);
            if (!require) {
                this.getView().showTipNotification(sbErrorInfo.toString());
                return;
            }
            String settingPageId = adminGroupId + "|" + this.getView().getPageId();
            IFormView settingView = this.getView().getViewNoPlugin(settingPageId);
            if (settingView != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u5206\u7ec4\uff1a\u201c%s\u201d\u5df2\u5728\u5176\u4ed6\u9875\u7b7e\u4e2d\u6253\u5f00\u3002\u5982\u9700\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u5173\u95ed\u9875\u7b7e\u540e\u91cd\u8bd5\u3002", (String)"AdminGroupTreeListPlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[]{name}));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u7ba1\u7406\u5458\u5206\u7ec4\u201c%1$s\u201d\u5417\uff1f", (String)"AdminGroupTreeListPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[]{name}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_DELETE_ADMIN_GROUP));
        } else if (BTN_SETTING.equals(ctrlKey)) {
            this.showAdminGroupDetail();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
        switch (callBackId) {
            case "confirm_callBack_delete_admin_group": {
                String focusNodeId = this.getView().getPageCache().get("focusNodeId");
                if (StringUtils.isEmpty((String)focusNodeId)) {
                    focusNodeId = tv.getTreeState().getFocusNodeId();
                }
                String[] arr = focusNodeId.split("_");
                String adminGroupId = arr[0];
                if (event.getResult() == MessageBoxResult.Yes) {
                    this.deleteAdminGroup(adminGroupId, tv);
                    break;
                }
                if (event.getResult() != MessageBoxResult.Cancel) break;
                MutexHelper.release((String)"perm_admingroup", (String)"modify", (String)adminGroupId);
                break;
            }
            case "confirm_callBack_delete_admin_group_user": {
                if (event.getResult() == MessageBoxResult.Yes) {
                    this.deleteAdmin();
                    break;
                }
                this.getPageCache().remove("deleteUserIds");
            }
        }
    }

    private void deleteAdminGroup(String adminGroupId, TreeView tv) {
        boolean refreshTree = true;
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(adminGroupId), (String)"perm_admingroup");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dynamicObject == null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AdminGroupTreeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            MutexHelper.release((String)"perm_admingroup", (String)"modify", (String)adminGroupId);
        } else {
            StringBuilder sbErrorInfo = new StringBuilder();
            boolean require = MutexHelper.require((String)"perm_admingroup", (Object)adminGroupId, (String)"modify", (StringBuilder)sbErrorInfo);
            if (!require) {
                this.getView().showTipNotification(sbErrorInfo.toString());
                return;
            }
            MutexHelper.release((String)"perm_admingroup", (String)"modify", (String)adminGroupId);
            String curFormNum = "perm_useradmingroup";
            String curAppNum = AppHelper.getCurAppId((String)curFormNum, (String)this.getView().getFormShowParameter().getAppId());
            PermResult permResult = CommonService.genOperateOptionAndExec((PermOperationReq)((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)curAppNum).with(PermOperationReq::setCurFormNum, (Object)"perm_useradmingroup").with(PermOperationReq::setOperEntnum, (Object)"perm_admingroup").with(PermOperationReq::setOperationKey, (Object)"delete").with(PermOperationReq::setDataEntities, (Object)new DynamicObject[]{dynamicObject}).with(PermOperationReq::setEntSavePermlog, (Object)Boolean.TRUE).with(PermOperationReq::setNeedClearAllCache, (Object)"1").with(PermOperationReq::setPermLogBusiType, (Object)"admingroup_del").with(PermOperationReq::setPermLogOp, (Object)"delete").with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getDel()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)"AdminGroupTreeListPlugin.confirmCallBack").with(PermOperationReq::setAlreadyCheckBusiParam, (Object)"1").build()));
            if (!permResult.isOk()) {
                this.getView().showErrorNotification(permResult.getMsg());
                refreshTree = false;
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AdminGroupTreeListPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
        }
        if (refreshTree) {
            try {
                AdminGroupService.initAdminGroupTree((TreeView)tv, (IPageCache)this.getView().getPageCache());
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                logger.warn("[AdminGroupTreeListPlugin]\u91cd\u65b0\u52a0\u8f7d\u7ba1\u7406\u5458\u7ec4\u6811\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        ListSelectedRowCollection userIds = (ListSelectedRowCollection)e.getReturnData();
        if (BOS_USERTREELISTF7.equals(actionId) && !CollectionUtils.isEmpty((Collection)userIds)) {
            if (!CollectionUtils.isEmpty((Collection)userIds)) {
                Set<Long> userIdSet = userIds.stream().map(userId -> (Long)userId.getPrimaryKeyValue()).collect(Collectors.toSet());
                String focusNodeId = this.getView().getPageCache().get("focusNodeId");
                String adminGroupId = focusNodeId.split("_")[0];
                ArrayList saveList = new ArrayList(10);
                Long admGrpIdL = Long.valueOf(adminGroupId);
                userIdSet.forEach(primaryKeyValue -> {
                    DynamicObject userAdminGroup = BusinessDataServiceHelper.newDynamicObject((String)"perm_useradmingroup");
                    userAdminGroup.set("user", (Object)BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bos_user", (String)"id, number, name"));
                    userAdminGroup.set("usergroup", (Object)BusinessDataServiceHelper.loadSingle((Object)admGrpIdL, (String)"perm_admingroup", (String)"id, number, name"));
                    saveList.add(userAdminGroup);
                });
                String formNum = "perm_useradmingroup";
                PermResult permResult = CommonService.genOperateOptionAndExec((PermOperationReq)((PermOperationReq)PermBuilder.of(PermOperationReq::new).with(PermOperationReq::setCurAppNum, (Object)AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId())).with(PermOperationReq::setCurFormNum, (Object)formNum).with(PermOperationReq::setOperEntnum, (Object)"perm_useradmingroup").with(PermOperationReq::setOperationKey, (Object)"save").with(PermOperationReq::setDataEntities, (Object)saveList.toArray(new DynamicObject[saveList.size()])).with(PermOperationReq::setEntSavePermlog, (Object)Boolean.TRUE).with(PermOperationReq::setNeedClearAllCache, (Object)"1").with(PermOperationReq::setPermLogBusiType, (Object)"admin_add").with(PermOperationReq::setPermLogOp, (Object)BAR_ADD).with(PermOperationReq::setPermLogOpbtn, (Object)ConstantsHelper.getAdd()).with(PermOperationReq::setPermLogInterfaceMethod, (Object)"AdminGroupTreeListPlugin.closedCallBack").build()));
                if (permResult.isOk()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u6210\u529f\u3002", (String)"AdminGroupTreeListPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showSuccessNotification(permResult.getMsg());
                }
            }
            TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
            Map focusNode = tv.getTreeState().getFocusNode();
            tv.treeNodeClick((String)focusNode.get("parentid"), (String)focusNode.get("id"));
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        String nodeId = (String)e.getNodeId();
        String parentNodeId = (String)e.getParentNodeId();
        String longNumber = "";
        String adgNumber = "";
        String adgName = "";
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(nodeId)) {
            adgNumber = "";
            adgName = "";
            longNumber = "";
        } else {
            Long adminGroupId = Long.parseLong(nodeId.split("_")[0]);
            DynamicObject adg = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"number, name, longnumber");
            if (adg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AdminGroupTreeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                return;
            }
            adgNumber = adg.getString("number");
            adgName = adg.getString("name");
            longNumber = adg.getString("longnumber");
        }
        this.getPageCache().put("focusNodeId", nodeId);
        this.getPageCache().put("focusNodeParentId", parentNodeId);
        this.getPageCache().put("focusAdgNumber", adgNumber);
        this.getPageCache().put("focusAdgName", adgName);
        this.getPageCache().put("focusNodeLongNumber", longNumber);
    }

    protected QFilter nodeClickFilter() {
        QFilter filter;
        String focusNodeId = this.getView().getPageCache().get("focusNodeId");
        if (StringUtils.isEmpty((String)focusNodeId)) {
            TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
            focusNodeId = tv.getTreeState().getFocusNodeId();
        }
        if (StringUtils.isNotEmpty((String)focusNodeId) && !"8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(focusNodeId)) {
            String adminGroupId = focusNodeId.split("_")[0];
            filter = new QFilter("usergroup", "=", (Object)Long.parseLong(adminGroupId));
        } else {
            filter = new QFilter("id", "=", (Object)0L);
        }
        return filter;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"perm_useradmingroup", (String)"usergroup");
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"AdminGroupTreeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject adminGroup = dynamicObject.getDynamicObject("usergroup");
        long level = adminGroup.getLong("level");
        long adminGroupId = adminGroup.getLong("id");
        long parentAdminGroupId = adminGroup.getLong("parent.id");
        TreeView tv = (TreeView)this.getControl(TREE_ADMIN_GROUP);
        String focusNodeId = tv.getTreeState().getFocusNodeId();
        String nodeId = adminGroupId + "_" + level;
        if (nodeId.equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b9a\u4f4d\u5728\u5f53\u524d\u5206\u7ec4\uff0c\u65e0\u9700\u8df3\u8f6c\u3002", (String)"AdminGroupTreeListPlugin_17", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        } else {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(nodeId);
            if (level > 1L) {
                treeNode.setParentid(parentAdminGroupId + "_" + (level - 1L));
            } else {
                treeNode.setParentid("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
            }
            tv.focusNode(treeNode);
            tv.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        }
        args.setCancel(true);
    }

    public void setFilter(SetFilterEvent e) {
        List adminGroupIdCanSee;
        String adminGroupCanSee = this.getPageCache().get("adminGroupCanSee");
        if (StringUtils.isNotEmpty((String)adminGroupCanSee) && !CollectionUtils.isEmpty((Collection)(adminGroupIdCanSee = (List)SerializationUtils.fromJsonString((String)adminGroupCanSee, List.class)))) {
            QFilter adminGroupCanSeeFilter = new QFilter("usergroup.id", "in", (Object)adminGroupIdCanSee);
            e.getCustomQFilters().add(adminGroupCanSeeFilter);
        }
    }

    private String getNotRootNodeText() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u975e\u6839\u8282\u70b9\u3002", (String)"AdminGroupTreeListPlugin_18", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getOnlyModifySubGroupText() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u4e0d\u5728\u60a8\u7684\u63a7\u5236\u8303\u56f4\u5185\uff0c\u60a8\u65e0\u6743\u8fdb\u884c\u65b0\u589e\u5220\u9664\u7b49\u64cd\u4f5c\u3002", (String)"AdminGroupTreeListPlugin_19", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String getLevelLimitText() {
        return ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u521b\u5efa%s\u7ea7\u7ba1\u7406\u5458\u3002", (String)"AdminGroupTreeListPlugin_20", (String)"bos-permission-formplugin", (Object[])new Object[]{this.adminLevelLimit});
    }

    public void chat(ChatEvent e) {
        e.setCancel(true);
    }
}

