/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class CommonRoleAssignUser
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTN_ADDUSER = "button_adduser";
    private static final String BTN_ADD = "button_add";
    private static final String BTN_DEL = "button_del";
    private static final String BTN_SAVE = "button_save";
    private static final String COMMONROLEID = "commonroleid";
    private static final String USERF7 = "userf7";
    private static final String ORGF7 = "orgf7";
    private static final String USERENTRY = "userentry";
    private static final String ORGENTRY = "orgentry";
    private static final String USER = "user";
    private static final String DIM_OBJ_TYPE = "dim_obj_type";
    private static final String DIM_OBJ_NUMBER = "dim_obj_number";
    private static final String DIM_OBJ_NAME = "dim_obj_name";
    private static final String ORG = "org";
    private static final String ORGNAME = "orgname";
    private static final String INCLUDESUBORG = "includesuborg";
    private static final String DIM_TYPE = "dim_type";
    private static final String DIM_ORG = "bos_org";
    private static final String CALLBACK_SWITCHDIMENSION = "switchDimension";
    private static final String BOS_ORG = "bos_org";
    private static final Log logger = LogFactory.getLog(CommonRoleAssignUser.class);
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private String dimType = null;
    private String curCtrlTypeEntityNum = null;
    private String curCtrlTypeName = null;

    private void setDimType(String dimType) {
        this.dimType = dimType;
    }

    private void setCurCtrlTypeEntityNum(String entityNum) {
        this.curCtrlTypeEntityNum = entityNum;
    }

    private void setCurCtrlTypeName(String ctrlTypeName) {
        this.curCtrlTypeName = ctrlTypeName;
    }

    public void initialize() {
        super.initialize();
        this.initialPermDimType();
    }

    private void initialPermDimType() {
        String permDimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension");
        if (permDimType != null) {
            this.setDimType(permDimType);
            this.setCurCtrlTypeEntityNum(this.curCtrlTypeEntityNum);
            this.setCurCtrlTypeName(this.getCtrlTypeName());
        } else {
            this.setDimType("bos_org");
            this.setCurCtrlTypeEntityNum("bos_org");
            this.setCurCtrlTypeName(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"CommonRoleAssignUser_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDimTypeEdit();
        this.setVisible();
        this.getView().setEnable(Boolean.valueOf(this.dimType.equals("bos_org")), new String[]{INCLUDESUBORG});
        String commonRoleId = (String)this.getView().getFormShowParameter().getCustomParam(COMMONROLEID);
        this.getModel().setValue(COMMONROLEID, (Object)commonRoleId);
    }

    private void setVisible() {
        if (this.dimType.equals("bos_org")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{DIM_OBJ_NUMBER, DIM_OBJ_NAME});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ORG, ORGNAME});
        }
    }

    private void setDimTypeEdit() {
        if (this.dimType == null) {
            this.initialPermDimType();
        }
        ComboEdit dimTypeComboEdit = (ComboEdit)this.getControl(DIM_TYPE);
        String[] suitableDimType = PermCommonUtil.getSuitableDimType((String)this.dimType);
        if (suitableDimType == null || suitableDimType.length != 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9694\u79bb\u7ef4\u5ea6\u67e5\u8be2\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonRoleAssignUser_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.warn(this.dimType + "\u9694\u79bb\u7ef4\u5ea6\u67e5\u8be2\u6709\u8bef");
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        if (suitableDimType[1].equals("bos_org")) {
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"CommonRoleAssignUser_0", (String)SYSTEM_TYPE, (Object[])new Object[0])), "bos_org"));
        } else {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)suitableDimType[1]);
            ComboItem comboItem = new ComboItem(entityType.getDisplayName(), suitableDimType[1]);
            comboItems.add(comboItem);
        }
        comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7a7a", (String)"CommonRoleAssignUser_2", (String)SYSTEM_TYPE, (Object[])new Object[0])), "DIM_NULL"));
        dimTypeComboEdit.setComboItems(comboItems);
    }

    private String getCtrlTypeName() {
        IPageCache pageCache = this.getPageCache();
        String ctrlTypeName = pageCache.get("FormShowParam_CtrlType_Name");
        if (StringUtils.isNotEmpty((String)ctrlTypeName)) {
            return ctrlTypeName;
        }
        ctrlTypeName = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_CtrlType_Name");
        if (StringUtils.isNotEmpty((String)ctrlTypeName)) {
            pageCache.put("FormShowParam_CtrlType_Name", ctrlTypeName);
            return ctrlTypeName;
        }
        DynamicObject curCtryTypeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_ctrltype", (String)"name", (QFilter[])new QFilter[]{new QFilter("bizobjectid", "=", (Object)this.curCtrlTypeEntityNum)});
        ctrlTypeName = curCtryTypeObj.getLocaleString("name").getLocaleValue();
        pageCache.put("FormShowParam_CtrlType_Name", ctrlTypeName);
        return ctrlTypeName;
    }

    public void registerListener(EventObject e) {
        BasedataEdit userF7;
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADDUSER, BTN_ADD, BTN_SAVE});
        BasedataEdit orgF7 = (BasedataEdit)this.getControl(ORGF7);
        if (orgF7 != null) {
            orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((userF7 = (BasedataEdit)this.getControl(USERF7)) != null) {
            userF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        Button button = (Button)evt.getSource();
        switch (clickKey = button.getKey()) {
            case "button_adduser": {
                Set<Long> userIdSet = PermFormCommonUtil.getAllLongIdSet(this.getModel(), USERENTRY, USER);
                this.getModel().beginInit();
                this.getModel().setValue(USERF7, (Object)userIdSet.toArray());
                this.getModel().endInit();
                BasedataEdit userF7 = (BasedataEdit)this.getControl(USERF7);
                if (userF7 == null) break;
                userF7.click();
                break;
            }
            case "button_add": {
                if (this.dimType.equals("bos_org")) {
                    Set<Long> orgIdSet = PermFormCommonUtil.getAllLongIdSet(this.getModel(), ORGENTRY, ORG);
                    this.getModel().beginInit();
                    this.getModel().setValue(ORGF7, (Object)orgIdSet.toArray());
                    this.getModel().endInit();
                    BasedataEdit orgF7 = (BasedataEdit)this.getControl(ORGF7);
                    if (orgF7 == null) break;
                    orgF7.click();
                    break;
                }
                Set<Long> idSet = PermFormCommonUtil.getAllLongIdSet(this.getModel(), ORGENTRY, DIM_OBJ_NUMBER);
                ListShowParameter lsp = ShowFormHelper.createShowListForm((String)this.curCtrlTypeEntityNum, (boolean)true);
                lsp.setSelectedRows(idSet.toArray());
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.curCtrlTypeEntityNum));
                lsp.setCaption(this.curCtrlTypeName);
                lsp.setHasRight(true);
                this.getView().showForm((FormShowParameter)lsp);
                break;
            }
            case "button_save": {
                this.save();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (this.curCtrlTypeEntityNum.equals(actionId) && e.getReturnData() instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
            if (col == null || col.isEmpty()) {
                return;
            }
            HashMap<Long, String> dimObjIds = new HashMap<Long, String>(col.size());
            for (ListSelectedRow row : col) {
                Long dimObjId = null;
                Object primaryKeyValue = row.getPrimaryKeyValue();
                dimObjId = primaryKeyValue instanceof Long ? (Long)row.getPrimaryKeyValue() : Long.valueOf(Long.parseLong(primaryKeyValue.toString()));
                String name = row.getName();
                dimObjIds.put(dimObjId, name);
                this.fillDimObjEntry(dimObjIds);
            }
        }
    }

    private void fillDimObjEntry(Map<Long, String> dimObjIds) {
        this.getModel().deleteEntryData(ORGENTRY);
        this.getModel().batchCreateNewEntryRow(ORGENTRY, dimObjIds.size());
        int index = 0;
        for (Map.Entry<Long, String> entry : dimObjIds.entrySet()) {
            this.getModel().setValue(DIM_OBJ_TYPE, (Object)this.curCtrlTypeEntityNum, index);
            this.getModel().setValue(DIM_OBJ_NUMBER, (Object)entry.getKey(), index);
            this.getModel().setValue(DIM_OBJ_NAME, (Object)entry.getValue(), index);
            ++index;
        }
    }

    private void save() {
        int i;
        if (!this.validate()) {
            return;
        }
        String roleId = (String)this.getModel().getValue(COMMONROLEID);
        if (StringUtils.isEmpty((String)roleId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89d2\u8272\u627e\u4e0d\u5230\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"CommonRoleAssignUser_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.warn("roleId\u4e3a" + roleId);
        }
        Set<Long> userIdSet = PermFormCommonUtil.getAllLongIdSet(this.getModel(), USERENTRY, USER);
        int orgEntryCount = this.getModel().getEntryRowCount(ORGENTRY);
        HashMap<Long, Boolean> dimObjInfo = new HashMap<Long, Boolean>(orgEntryCount);
        HashMap<Long, ArrayList<Long>> assignInfo = new HashMap<Long, ArrayList<Long>>(orgEntryCount);
        if (this.dimType.equals("bos_org")) {
            for (i = 0; i < orgEntryCount; ++i) {
                Long orgId = (Long)((DynamicObject)this.getModel().getValue(ORG, i)).getPkValue();
                assignInfo.put(orgId, new ArrayList<Long>(userIdSet));
                Boolean inCludeSubOrg = (Boolean)this.getModel().getValue(INCLUDESUBORG, i);
                dimObjInfo.put(orgId, inCludeSubOrg);
            }
        } else {
            for (i = 0; i < orgEntryCount; ++i) {
                Long orgId = (Long)((DynamicObject)this.getModel().getValue(DIM_OBJ_NUMBER, i)).getPkValue();
                assignInfo.put(orgId, new ArrayList<Long>(userIdSet));
                dimObjInfo.put(orgId, Boolean.FALSE);
            }
        }
        try {
            boolean result = PermissionServiceHelper.roleAssignOrgUser((String)roleId, (String)this.dimType, assignInfo, dimObjInfo, (boolean)true, (String)"2", null);
            if (result) {
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CommonRoleAssignUser_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.warn("\u4fdd\u5b58\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean validate() {
        if (this.getModel().getEntryRowCount(USERENTRY) <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237", (String)"CommonRoleAssignUser_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getEntryRowCount(ORGENTRY) <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u7ef4\u5ea6\u4fe1\u606f", (String)"CommonRoleAssignUser_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (CALLBACK_SWITCHDIMENSION.equals(callBackId)) {
            if (result.equals((Object)MessageBoxResult.Yes)) {
                this.getModel().deleteEntryData(ORGENTRY);
                String dimtype = (String)this.getModel().getValue(DIM_TYPE);
                Boolean isEnable = dimtype.equals("bos_org");
                this.getView().setEnable(isEnable, new String[]{BTN_ADD, BTN_DEL, ORGENTRY});
            } else {
                String oldValue = this.getPageCache().get("oldValue");
                this.getModel().beginInit();
                this.getModel().setValue(DIM_TYPE, (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView(DIM_TYPE);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "userf7": {
                if (!(newValue instanceof DynamicObjectCollection)) break;
                this.fillEntry((DynamicObjectCollection)newValue, USERENTRY, USER);
                break;
            }
            case "orgf7": {
                if (!(newValue instanceof DynamicObjectCollection)) break;
                this.fillEntry((DynamicObjectCollection)newValue, ORGENTRY, ORG);
                break;
            }
            case "dim_type": {
                int rowCount = this.getModel().getEntryRowCount(ORGENTRY);
                if (rowCount > 0) {
                    String oldValue = (String)e.getChangeSet()[0].getOldValue();
                    this.getPageCache().put("oldValue", oldValue);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9694\u79bb\u7ef4\u5ea6\u5c06\u6e05\u7a7a\u5df2\u6dfb\u52a0\u7684\u6570\u636e", (String)"CommonRoleAssignUser_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACK_SWITCHDIMENSION));
                    break;
                }
                Boolean isEnable = newValue.equals("bos_org");
                this.getView().setEnable(isEnable, new String[]{BTN_ADD, BTN_DEL, ORGENTRY});
                break;
            }
        }
    }

    private void fillEntry(DynamicObjectCollection newValue, String entryKey, String fieldKey) {
        if (newValue == null || newValue.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryData(entryKey);
        this.getModel().batchCreateNewEntryRow(entryKey, newValue.size());
        int index = 0;
        for (DynamicObject obj : newValue) {
            Long baseDataId = obj.getLong("fbasedataid_id");
            this.getModel().setValue(fieldKey, (Object)baseDataId, index++);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        FormShowParameter fsp = beforeF7SelectEvent.getFormShowParameter();
        switch (propertyName) {
            case "userf7": {
                fsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                break;
            }
            case "orgf7": {
                fsp.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                fsp.setCustomParam("isAddChargeOrgFilter", (Object)Boolean.TRUE);
                fsp.setCustomParam("showAdminOrgViewType", (Object)Boolean.TRUE);
                break;
            }
        }
    }
}

