/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.FilterGridF7CloseCallBackEvent;
import kd.bos.form.control.events.FilterGridF7CloseCallBackListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.DrLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.util.PermFilterConditionUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class DataRuleEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
FilterGridF7CloseCallBackListener {
    private static final Log logger = LogFactory.getLog(DataRuleEditPlugin.class);
    private static final String FILTERGRID_KEY = "filtergridap";
    private static final String PROP_ENTITY = "entity";
    private static final String PROP_RULE = "rule";
    private static final String BAR_SAVE = "bar_save";
    private PermLogBusiType permLogBusiType = null;
    private String preData = "";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit entBdEdit = (BasedataEdit)this.getControl(PROP_ENTITY);
        entBdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRID_KEY);
        filterGrid.addFilterGridF7CloseCallBackListeners((FilterGridF7CloseCallBackListener)this);
    }

    public void filterGridF7CloseCallBack(FilterGridF7CloseCallBackEvent filterGridF7CloseCallBackEvent) {
        this.initFilterGridData();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        PermFormCommonUtil.entF7ChangeF7Caption(PROP_ENTITY, ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"DataRuleEditPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), evt);
    }

    public void initialize() {
        super.initialize();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{PROP_ENTITY});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.VIEW)) {
            PermFormCommonUtil.setFilterGridAddBtnVisible(this.getView(), FILTERGRID_KEY, false);
        } else if (status.equals((Object)OperationStatus.EDIT)) {
            PermFormCommonUtil.setFilterGridAddBtnVisible(this.getView(), FILTERGRID_KEY, true);
            this.getPageCache().put("preRuleStrPgCache", String.valueOf(this.getModel().getValue(PROP_RULE)));
        } else if (status.equals((Object)OperationStatus.ADDNEW)) {
            PermFormCommonUtil.setFilterGridAddBtnVisible(this.getView(), FILTERGRID_KEY, true);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFilterGridData();
    }

    private void initFilterGridData() {
        MainEntityType entityType;
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue(PROP_ENTITY);
        if (entityObj == null) {
            return;
        }
        String entityNum = (String)((DynamicObject)this.getModel().getValue(PROP_ENTITY)).getPkValue();
        try {
            entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
            String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355(%s)\u5143\u6570\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u53ef\u80fd\u5df2\u88ab\u4e0d\u5f53\u5220\u9664\uff0c\u65e0\u6cd5\u52a0\u8f7d\u3002", (String)"DataRuleEditPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[]{entityNum});
            this.getView().showErrorNotification(errorInfo);
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, FILTERGRID_KEY});
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID_KEY);
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
        getFilterFieldsParameter.setNeedMulBasedataField(true);
        HashMap filterGridObjectMap = new HashMap(8);
        DrHelper.addCustomCompareType(filterGridObjectMap, (GetFilterFieldsParameter)getFilterFieldsParameter);
        List filterColumns = EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
        PermCommonUtil.removeExtraColumn((List)filterColumns, (MainEntityType)entityType);
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityNum);
        for (Map.Entry filterGridObject : filterGridObjectMap.entrySet()) {
            filterGrid.addCustomCompareTypes((String)filterGridObject.getKey(), new ArrayList((Collection)filterGridObject.getValue()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.refreshFilterGrid();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String prevFocusEntNum = (String)this.getView().getFormShowParameter().getCustomParam("formShowCustomParam_entityNum");
        String prevFocusEntAppId = (String)this.getView().getFormShowParameter().getCustomParam("formShowCustomParam_appId");
        if (StringUtils.isNotEmpty((String)prevFocusEntNum)) {
            this.getModel().setValue(PROP_ENTITY, (Object)prevFocusEntNum);
            this.getModel().setValue("bizapp", (Object)prevFocusEntAppId);
            this.getView().setEnable(Boolean.FALSE, new String[]{PROP_ENTITY});
        } else {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String entityNum = String.valueOf(customParams.get("DataRule_entityNum"));
            String treeSelected = String.valueOf(customParams.get("DataRule_treeSelected"));
            if (entityNum != null && !entityNum.equals("null")) {
                this.getModel().setValue(PROP_ENTITY, (Object)entityNum);
                this.getView().setEnable(Boolean.FALSE, new String[]{PROP_ENTITY});
            } else if (treeSelected != null && !treeSelected.equals("null")) {
                this.getModel().setValue(PROP_ENTITY, (Object)treeSelected);
                this.getView().setEnable(Boolean.FALSE, new String[]{PROP_ENTITY});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{PROP_ENTITY});
                PermFormCommonUtil.setFilterGridAddBtnVisible(this.getView(), FILTERGRID_KEY, false);
            }
        }
    }

    protected void clearDataPermFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID_KEY);
        FilterCondition filterCondition = new FilterCondition();
        filterGrid.SetValue(filterCondition);
        filterCondition = null;
        filterGrid.SetValue(filterCondition);
        this.getView().updateView(FILTERGRID_KEY);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        String propName = e.getProperty().getName();
        if (PROP_ENTITY.equals(propName)) {
            this.clearDataPermFilterGrid();
            this.initFilterGridData();
            this.refreshFilterGrid();
            if (newValue != null) {
                PermFormCommonUtil.setFilterGridAddBtnVisible(this.getView(), FILTERGRID_KEY, true);
            } else {
                PermFormCommonUtil.setFilterGridAddBtnVisible(this.getView(), FILTERGRID_KEY, false);
            }
        }
    }

    private void refreshFilterGrid() {
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue(PROP_ENTITY);
        if (entityObj == null) {
            return;
        }
        String entityNum = (String)((DynamicObject)this.getModel().getValue(PROP_ENTITY)).getPkValue();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID_KEY);
        filterGrid.setEntityNumber(entityNum);
        String ruleStr = (String)this.getModel().getValue(PROP_RULE);
        if (StringUtils.isNotEmpty((String)ruleStr)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)ruleStr, FilterCondition.class);
            filterGrid.SetValue(fc);
        }
        this.getView().updateView(FILTERGRID_KEY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        if (!(e.getSource() instanceof AbstractOperate)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            MainEntityType entityType;
            String ruleStr;
            String entityNum = (String)((DynamicObject)this.getModel().getValue(PROP_ENTITY)).getPkValue();
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID_KEY);
            FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
            boolean canSave = false;
            if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow()) && StringUtils.isNotEmpty((String)(ruleStr = SerializationUtils.toJsonString((Object)fc)))) {
                this.getModel().setValue(PROP_RULE, (Object)ruleStr);
                canSave = true;
            }
            if (!canSave) {
                e.setCancel(true);
                String errorInfo = ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u89c4\u5219\u3002", (String)"DataRuleEditPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                e.setCancelMessage(errorInfo);
                this.getView().showTipNotification(errorInfo);
            }
            try {
                entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            }
            catch (Exception ex) {
                logger.warn((Throwable)ex);
                String errorInfo = ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355(%s)\u5143\u6570\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u53ef\u80fd\u5df2\u88ab\u4e0d\u5f53\u5220\u9664\uff0c\u65e0\u6cd5\u52a0\u8f7d\u3002", (String)"DataRuleEditPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[]{entityNum});
                e.setCancel(true);
                e.setCancelMessage(errorInfo);
                this.getView().showErrorNotification(errorInfo);
                return;
            }
            PermCommonUtil.validateFilterCondition((MainEntityType)entityType, (FilterCondition)fc);
            if (PermCommonUtil.isEnablePermLog()) {
                Long dataRuleId = (Long)this.getModel().getDataEntity().getPkValue();
                String langStr = RequestContext.get().getLang().name();
                this.permLogBusiType = null == dataRuleId || 0L == dataRuleId ? PermLogService.getPermLogBusiType((String)"dr_add_save") : PermLogService.getPermLogBusiType((String)"dr_modify_save");
                this.preData = DrLogHelper.drEventImage((Long)dataRuleId, (String)langStr, (boolean)false, (String)entityNum);
            }
        } else if ("disable".equals(operateKey) || "enable".equals(operateKey)) {
            String preRuleStrPgCache = this.getPageCache().get("preRuleStrPgCache");
            String curRuleStr = String.valueOf(this.getModel().getValue(PROP_RULE));
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID_KEY);
            FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
            if (fc != null && !CollectionUtils.isEmpty((Collection)fc.getFilterRow())) {
                curRuleStr = SerializationUtils.toJsonString((Object)fc);
            }
            boolean dataChanged = this.getModel().getDataChanged();
            if (!PermFilterConditionUtil.compareFilterCondition((String)preRuleStrPgCache, (String)curRuleStr) || dataChanged) {
                String please_save_first = ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"DataRuleEditPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.setCancelMessage(please_save_first);
                this.getView().showTipNotification(please_save_first);
                return;
            }
            if (PermCommonUtil.isEnablePermLog()) {
                Long dataRuleId = (Long)this.getModel().getDataEntity().getPkValue();
                String langStr = RequestContext.get().getLang().name();
                this.permLogBusiType = "disable".equals(operateKey) ? PermLogService.getPermLogBusiType((String)"dr_disable") : PermLogService.getPermLogBusiType((String)"dr_enable");
                String entityNum = (String)((DynamicObject)this.getModel().getValue(PROP_ENTITY)).getPkValue();
                this.preData = DrLogHelper.drEventImage((Long)dataRuleId, (String)langStr, (boolean)false, (String)entityNum);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (!(e.getSource() instanceof AbstractOperate)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)e.getSource();
        String operateKey = op.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (null != operationResult && operationResult.isSuccess()) {
            if ("save".equals(operateKey)) {
                DynamicObject entityObj;
                long dataRuleId = (Long)operationResult.getSuccessPkIds().get(0);
                this.getView().setEnable(Boolean.FALSE, new String[]{PROP_ENTITY});
                PermissionServiceHelper.clearAllCache();
                if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                    try {
                        List<Long> influencedUser = this.getInfluencedUser(dataRuleId, true);
                        FormConfigFactory.cancelShowFormDataRights(influencedUser);
                    }
                    catch (Exception exception) {
                        logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)exception);
                    }
                }
                if ((entityObj = (DynamicObject)this.getModel().getValue(PROP_ENTITY)) == null) {
                    return;
                }
                String opbtn = ConstantsHelper.getSave();
                this.ready2PermLog(operateKey, dataRuleId, opbtn);
                this.getPageCache().put("preRuleStrPgCache", String.valueOf(this.getModel().getValue(PROP_RULE)));
            } else if ("disable".equals(operateKey) || "enable".equals(operateKey)) {
                DataRuleCache.removeAllCache();
                long dataRuleId = (Long)operationResult.getSuccessPkIds().get(0);
                if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                    try {
                        List<Long> influencedUser = this.getInfluencedUser(dataRuleId, false);
                        FormConfigFactory.cancelShowFormDataRights(influencedUser);
                    }
                    catch (Exception exception) {
                        logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)exception);
                    }
                }
                String opbtn = "disable".equals(operateKey) ? ConstantsHelper.getDisable() : ConstantsHelper.getEnable();
                this.ready2PermLog(operateKey, dataRuleId, opbtn);
            }
        }
    }

    private void ready2PermLog(String operateKey, long dataRuleId, String opbtn) {
        if (PermCommonUtil.isEnablePermLog()) {
            String drNumber = this.getModel().getValue("number").toString();
            String drName = ((ILocaleString)this.getModel().getValue("name")).getLocaleValue();
            String langStr = RequestContext.get().getLang().name();
            String entityNum = (String)((DynamicObject)this.getModel().getValue(PROP_ENTITY)).getPkValue();
            String afterData = DrLogHelper.drEventImage((Long)dataRuleId, (String)langStr, (boolean)true, (String)entityNum);
            this.drEvent2PermLog(operateKey, opbtn, String.valueOf(dataRuleId), drNumber, drName, this.preData, afterData, this.permLogBusiType);
        }
    }

    private void drEvent2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String preData, String afterData, PermLogBusiType permLogBusiType) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.plugin.DataRuleEditPlugin.drEvent2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("DataRuleEditPlugin.drEvent2PermLog error, opItemId:{}, opItemName:{}", new Object[]{opItemId, opItemName, e});
        }
    }

    private List<Long> getInfluencedUser(Long dataRuleId, boolean userEnableProperty) {
        List<String> roleIds = this.getInfluencedRoles(dataRuleId, userEnableProperty);
        ArrayList<Long> userIds = CollectionUtils.isEmpty(roleIds) ? new ArrayList<Long>(10) : PermCommonUtil.getInfluencedUserByRole(roleIds);
        return userIds;
    }

    private List<String> getInfluencedRoles(Long dataRuleId, boolean userEnableProperty) {
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        StringBuilder sql = null;
        if (hasEnableRoleDataRuleNewModel) {
            sql = new StringBuilder();
            sql.append("(");
            sql.append(" select distinct a.froleid from t_perm_roledatarule rdr ").append(" inner join t_perm_datarule dr on rdr.fdataruleid = dr.fid ").append(" where rdr.fdataruleid = ? ");
            if (userEnableProperty) {
                sql.append(" and dr.fenable = '1' ");
            }
            sql.append(") union (");
            sql.append(" select distinct a.froleid from t_perm_roledatarule_prop rdrp ").append(" inner join t_perm_datarule dr on rdrp.fdataruleid = dr.fid ").append(" where rdrp.fdataruleid = ? ");
            if (userEnableProperty) {
                sql.append(" and d.fenable = '1' ");
            }
            sql.append(" ) ");
        } else {
            sql = this.getRoleDataRulesSql(userEnableProperty);
        }
        List roleIds = (List)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{dataRuleId, dataRuleId}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> result = new ArrayList<String>(10);
                while (rs.next()) {
                    String roleId = rs.getString(1);
                    result.add(roleId);
                }
                return result;
            }
        });
        return roleIds;
    }

    @Deprecated
    private StringBuilder getRoleDataRulesSql(boolean userEnableProperty) {
        StringBuilder sql = new StringBuilder();
        sql.append("(select distinct a.froleid from t_perm_roledatarules a ").append("inner join t_perm_datarules_entry b on a.fdatarulesid = b.fid ").append("inner join t_perm_datarule_entry c on b.fdataruleid = c.fid ").append("inner join t_perm_datarule d on c.fdataruleid = d.fid ").append("where d.fid = ? ");
        if (userEnableProperty) {
            sql.append("and d.fenable = '1') union ");
        } else {
            sql.append(") union ");
        }
        sql.append("(select distinct a.froleid from t_perm_roledatarules a ").append("inner join t_perm_datarules_entry b on a.fdatarulesid = b.fid ").append("inner join t_perm_datarule_prop c on b.fdataruleid = c.fid ").append("inner join t_perm_datarule d on c.fdataruleid = d.fid ").append("where d.fid = ? ");
        if (userEnableProperty) {
            sql.append("and d.fenable = '1')");
        } else {
            sql.append(") ");
        }
        return sql;
    }
}

