/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.log.helper.DrLogHelper;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.StringUtils;

public class DataRuleTreeListPlugin
extends AbstractTreeListPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener {
    private static final String ID_SPLIT = "_split_";
    private static final Log logger = LogFactory.getLog(DataRuleTreeListPlugin.class);
    private static final String TREEVIEW_LEFTTREE = "treeview";
    public static final String FSP_CUSTPARAM_ENTITYNUM = "formShowCustomParam_entityNum";
    public static final String FSP_CUSTPARAM_APPID = "formShowCustomParam_appId";
    public static final String PGCACHE_LEFTTREE_QLIFTER_JSON = "pageCache_LeftTree_QFilter_Json";
    public static final String PGCACHE_CURRENTSEARCHTEXT = "pageCache_CurrentSearchText";
    public static final String PGCACHE_HASQUERYCHILDREN = "pageCache_LeftTree_hasQueryChildren";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_ENTITY = "entity";
    private static final String PROP_SHOWNUM = "shownum";
    private static final String CTRL_SEARCH = "searchap";
    PermLogBusiType permLogBusiType = null;
    private List<Long> dataRuleIdList = null;
    private List<String> dataRuleNumberList = null;
    private List<String> dataRuleNameList = null;
    private List<String> dataRuleEntityNumList = null;
    private List<String> preDataList = null;

    public void registerListener(EventObject e) {
        Search search;
        TreeView tv = (TreeView)this.getControl(TREEVIEW_LEFTTREE);
        if (tv != null) {
            tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
            tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        if ((search = (Search)this.getControl(CTRL_SEARCH)) != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (PROP_SHOWNUM.equals(propName)) {
            this.initTree();
            Search search = (Search)this.getControl(CTRL_SEARCH);
            search.setSearchKey("");
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        this.initTree();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        String showFormSpecial = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        Object source = e.getSource();
        if (source instanceof ListShowParameter && !((ListShowParameter)source).isLookUp()) {
            PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
        }
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_LEFTTREE);
        if (tree != null) {
            tree.deleteAllNodes();
            this.getPageCache().remove(PGCACHE_HASQUERYCHILDREN);
            this.getPageCache().remove(PGCACHE_CURRENTSEARCHTEXT);
            List<Map<String, String>> bizCloudNodeList = this.getBizCloud();
            this.loadTreeRootData(bizCloudNodeList);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        TreeView tv = (TreeView)this.getControl(TREEVIEW_LEFTTREE);
        Map map = tv.getTreeState().getFocusNode();
        BillShowParameter bsp = e.getParameter();
        if (bsp.getStatus() == OperationStatus.ADDNEW && map != null && map.get("id") != null && "3".equals(String.valueOf(map.get("id")).split(ID_SPLIT)[0])) {
            String entityId = String.valueOf(map.get("id")).split(ID_SPLIT)[1];
            String appId = String.valueOf(map.get("parentid")).split(ID_SPLIT)[1];
            if (bsp.getCustomParams() == null) {
                bsp.setCustomParams(new HashMap());
            }
            Map<String, String> entityInfoMap = this.getBizObjectById(entityId);
            bsp.setCustomParam(FSP_CUSTPARAM_APPID, (Object)appId);
            bsp.setCustomParam(FSP_CUSTPARAM_ENTITYNUM, (Object)entityInfoMap.get(PROP_NUMBER));
        }
    }

    private List<Map<String, String>> getBizCloud() {
        List adminChargeApps;
        List allUserAppIds;
        Set disabledAppIds;
        Set disabledCloudIds;
        String localeid = RequestContext.get().getLang().name();
        boolean isChineseLocale = "zh_CN".equals(localeid);
        String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
        String appIdFromBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, ");
        if (isChineseLocale) {
            sql.append("al.fname, ");
        } else {
            sql.append("case when al.fname is null or al.fname='' or al.fname=' ' ").append("then al2.fname ").append("else al.fname ").append("end cloudname, ");
        }
        sql.append("e.fnumber entnum, a.fnumber ").append(" from t_meta_bizcloud a ").append(" left join t_meta_bizcloud_l al on (a.fid = al.fid and al.flocaleid = '").append(localeid).append("') ");
        if (!isChineseLocale) {
            sql.append(" left join t_meta_bizcloud_l al2 on (a.fid = al2.fid and al2.flocaleid = 'zh_CN') ");
        }
        sql.append(" inner join t_meta_bizapp c on (c.fbizcloudid = a.fid) ").append(" inner join t_meta_bizunitrelform b on (b.fbizappid = c.fid) ").append(" inner join t_meta_entitydesign e on(e.fid = b.fformid) ").append(" where a.fvisible = '1' ").append("AND a.fid <> '2HGKCE94QELW' ");
        if (StringUtils.isNotEmpty((String)cloudBlacklist)) {
            sql.append(" and a.fid not in (").append(cloudBlacklist).append(") ");
        }
        if (null != (disabledCloudIds = ManageServiceHelper.getDisabledCloudIds()) && !disabledCloudIds.isEmpty()) {
            String disabledCloudIdsStr = String.join((CharSequence)"','", disabledCloudIds);
            sql.append(" and a.fid not in ('").append(disabledCloudIdsStr).append("') ");
        }
        sql.append(" and e.fmodeltype IN ('BillFormModel', 'BaseFormModel','LogBillFormModel') ").append(" and e.fistemplate = '0'  ").append(" and c.fdeploystatus = '2' ");
        if (StringUtils.isNotEmpty((String)appIdFromBlacklist)) {
            sql.append(" and  c.fid not in(").append(appIdFromBlacklist).append(") ");
        }
        if (null != (disabledAppIds = ManageServiceHelper.getDisabledAppIds()) && !disabledAppIds.isEmpty()) {
            String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
            sql.append(" and  c.fid not in('").append(disabledAppIdsStr).append("') ");
        }
        if (null != (allUserAppIds = PermCommonUtil.getAllUserAppIds()) && !allUserAppIds.isEmpty()) {
            String allUserAppIdsStr = String.join((CharSequence)"','", allUserAppIds);
            sql.append(" and  c.fid not in('").append(allUserAppIdsStr).append("') ");
        }
        if (null != (adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)RequestContext.get().getCurrUserId())) && !adminChargeApps.isEmpty()) {
            String admiChargeAppIdStr = String.join((CharSequence)"','", adminChargeApps);
            sql.append(" and  c.fid in('").append(admiChargeAppIdStr).append("') ");
        }
        sql.append(" order by a.fseq asc");
        final Map permControlType = PermCommonUtil.getPermControlType();
        final boolean isShowNum = (Boolean)this.getModel().getValue(PROP_SHOWNUM);
        final HashSet<String> cloudIds = new HashSet<String>(8);
        List bizCloudList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<List<Map<String, String>>>(){

            public List<Map<String, String>> handle(ResultSet rs) throws SQLException {
                ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(50);
                while (rs.next()) {
                    String id;
                    String entityNum = rs.getString(3);
                    PermissionControlType permissionControlType = (PermissionControlType)permControlType.get(entityNum);
                    if (permissionControlType != null && permissionControlType.isForbidDataPerm() || !cloudIds.add(id = "1_split_" + rs.getString(1))) continue;
                    HashMap<String, String> bizCloudMap = new HashMap<String, String>();
                    bizCloudMap.put("id", id);
                    String cloudName = rs.getString(2);
                    String cloudNum = rs.getString(4);
                    if (StringUtils.isEmpty((String)cloudName)) {
                        cloudName = cloudNum;
                    } else if (isShowNum) {
                        cloudName = cloudName + "(" + cloudNum + ")";
                    }
                    bizCloudMap.put("name", cloudName);
                    result.add(bizCloudMap);
                }
                return result;
            }
        });
        DataSet finishDS = this.getPubAppEntDS(cloudBlacklist, appIdFromBlacklist, disabledCloudIds, disabledAppIds, allUserAppIds, adminChargeApps, null, null);
        while (finishDS.hasNext()) {
            String id;
            Row row = finishDS.next();
            String entNum = row.getString("entnum");
            String cloudId = row.getString("cloudid");
            String cloudNum = row.getString("cloudnum");
            String cloudName = row.getString("cloudname");
            PermissionControlType permissionControlType = (PermissionControlType)permControlType.get(entNum);
            if (permissionControlType != null && permissionControlType.isForbidDataPerm() || !cloudIds.add(id = "1_split_" + cloudId)) continue;
            HashMap<String, String> bizCloudMap = new HashMap<String, String>();
            bizCloudMap.put("id", id);
            if (StringUtils.isEmpty((String)cloudName)) {
                cloudName = cloudNum;
            } else if (isShowNum) {
                cloudName = cloudName + "(" + cloudNum + ")";
            }
            bizCloudMap.put("name", cloudName);
            bizCloudList.add(bizCloudMap);
        }
        return bizCloudList;
    }

    private DataSet getPubAppEntDS(String cloudBlacklist, String appIdFromBlacklist, Set<String> disabledCloudIds, Set<String> disabledAppIds, List<String> allUserAppIds, List<String> adminChargeApps, List<String> filterCloudIds, List<String> filterAppIds) {
        String localeid = RequestContext.get().getLang().name();
        StringBuilder appCloudSql = new StringBuilder("select a.fid appid, a.fmasterid appmasterid, ").append(" a.fbizcloudid cloudid, c.fnumber cloudnum, cl.fname cloudname ").append(" from t_meta_bizapp a ").append(" inner join t_meta_bizcloud c on (a.fbizcloudid = c.fid) ").append(" left join t_meta_bizcloud_l cl on (c.fid = cl.fid and cl.flocaleid = ? ) ").append(" where a.fdeploystatus = '2' ");
        if (null != filterCloudIds && !filterCloudIds.isEmpty()) {
            String filterCloudIdsStr = String.join((CharSequence)"','", filterCloudIds);
            appCloudSql.append(" and c.fid in ('").append(filterCloudIdsStr).append("')");
        }
        if (null != filterAppIds && !filterAppIds.isEmpty()) {
            String filterAppIdsStr = String.join((CharSequence)"','", filterAppIds);
            appCloudSql.append(" and a.fid in ('").append(filterAppIdsStr).append("')");
        }
        if (StringUtils.isNotEmpty((String)cloudBlacklist)) {
            appCloudSql.append(" and c.fid not in (").append(cloudBlacklist).append(") ");
        }
        if (null != disabledCloudIds && !disabledCloudIds.isEmpty()) {
            String disabledCloudIdsStr = String.join((CharSequence)"','", disabledCloudIds);
            appCloudSql.append(" and c.fid not in ('").append(disabledCloudIdsStr).append("') ");
        }
        if (null != disabledAppIds && !disabledAppIds.isEmpty()) {
            String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
            appCloudSql.append(" and a.fid not in('").append(disabledAppIdsStr).append("') ");
        }
        if (StringUtils.isNotEmpty((String)appIdFromBlacklist)) {
            appCloudSql.append(" and a.fid not in(").append(appIdFromBlacklist).append(") ");
        }
        if (null != allUserAppIds && !allUserAppIds.isEmpty()) {
            String allUserAppIdsStr = String.join((CharSequence)"','", allUserAppIds);
            appCloudSql.append(" and  a.fid not in('").append(allUserAppIdsStr).append("') ");
        }
        if (null != adminChargeApps && !adminChargeApps.isEmpty()) {
            String admiChargeAppIdStr = String.join((CharSequence)"','", adminChargeApps);
            appCloudSql.append(" and  a.fid in('").append(admiChargeAppIdStr).append("') ");
        }
        String algoKeyPrefix = "DataRuleTreeListPlugin_";
        DataSet appDS = DB.queryDataSet((String)(algoKeyPrefix + "appDS"), (DBRoute)DBRoute.meta, (String)appCloudSql.toString(), (Object[])new Object[]{localeid});
        DataSet entDS = DB.queryDataSet((String)(algoKeyPrefix + "entDS"), (DBRoute)DBRoute.meta, (String)("select  e.fnumber entnum " + " from t_meta_entitydesign e " + " where e.fmodeltype in ('BillFormModel', 'BaseFormModel','LogBillFormModel') " + " and e.fistemplate = '0' "));
        DataSet entNumPublishAppIdDS = DB.queryDataSet((String)(algoKeyPrefix + "entNumPublishAppIdDS"), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
        DataSet finishDS = entNumPublishAppIdDS.join(appDS).on("entapp_appid", "appid").select(new String[]{"entapp_entnum"}, new String[]{"cloudid", "cloudnum", "cloudname"}).finish().join(entDS).on("entapp_entnum", "entnum").select(new String[]{"cloudid", "cloudnum", "cloudname"}, new String[]{"entnum"}).finish();
        return finishDS;
    }

    private void loadTreeRootData(List<Map<String, String>> treeData) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_LEFTTREE);
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"DataRuleTreeListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        root.setId("0");
        root.setIsOpened(true);
        for (Map<String, String> subData : treeData) {
            TreeNode newNode = new TreeNode();
            String id = subData.get("id");
            String name = subData.get("name");
            newNode.setParentid("");
            newNode.setId(id);
            newNode.setText(name);
            newNode.addChildren(new ArrayList());
            newNode.setData((Object)1);
            root.addChild(newNode);
        }
        tree.addNode(root);
        tree.focusNode(root);
    }

    /*
     * WARNING - void declaration
     */
    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        TreeNode childrenDataTree;
        Object adminChargeApps;
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(PGCACHE_CURRENTSEARCHTEXT))) {
            return;
        }
        TreeView treeView = (TreeView)treeNodeEvent.getSource();
        String parentId = String.valueOf(treeNodeEvent.getNodeId());
        if (this.ifLeftTreeNodeHasLoadChildren(parentId)) {
            return;
        }
        this.recordLeftTreeNodeHasLoad(parentId);
        int level = Integer.parseInt(parentId.split(ID_SPLIT)[0]);
        String parentTrueId = parentId.split(ID_SPLIT)[1];
        QFilter[] qfArr = null;
        DynamicObject[] load = null;
        HashMap<String, String> entityIdAndNumMap = new HashMap<String, String>();
        HashSet<String> entityIdSet = new HashSet<String>(8);
        if (level == 1) {
            qfArr = new QFilter[3];
            List<String> ids = this.findBizappExistsEntity(parentTrueId);
            qfArr[0] = new QFilter("id", "in", ids);
            HashSet<String> disabledAppIds = ManageServiceHelper.getDisabledAppIds();
            if (disabledAppIds == null) {
                disabledAppIds = new HashSet<String>(10);
            }
            disabledAppIds.add("2HGKTA7HH43C");
            qfArr[1] = new QFilter("id", "not in", disabledAppIds);
            adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)RequestContext.get().getCurrUserId());
            if (null != adminChargeApps && !adminChargeApps.isEmpty()) {
                qfArr[2] = new QFilter("id", "in", adminChargeApps);
            }
            qfArr = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])qfArr, (String)"id");
            load = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])qfArr, (String)"sequence");
        } else if (level == 2) {
            void var14_24;
            qfArr = new QFilter[2];
            List<String> allExtAppId = DataRuleTreeListPlugin.getAllExtAppId(parentTrueId);
            allExtAppId.add(parentTrueId);
            qfArr[0] = new QFilter("bizapp", "in", allExtAppId);
            qfArr = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])qfArr, (String)"form");
            load = BusinessDataServiceHelper.load((String)"bos_devportal_unitrelform", (String)"form", (QFilter[])qfArr);
            int loadSize = load.length;
            adminChargeApps = load;
            int n = ((DynamicObject[])adminChargeApps).length;
            boolean bl = false;
            while (var14_24 < n) {
                Object dynamicObject = adminChargeApps[var14_24];
                entityIdSet.add(dynamicObject.getString("form"));
                ++var14_24;
            }
            DataSet entNumPublishAppIdDS = DB.queryDataSet((String)"entNumPublishAppIdDS", (DBRoute)DBRoute.permission, (String)("SELECT fbizobjid entapp_entnum, fbizappid entapp_appid FROM t_perm_bizobjapp" + " where fbizappid in(" + ListUtil.getSqlList(allExtAppId) + ")"));
            DataSet allEntInfoDS = DB.queryDataSet((String)"entNumPublishAppIdDS", (DBRoute)DBRoute.meta, (String)"SELECT fid entnum, fdentityid entityId FROM t_meta_mainentityinfo");
            DataSet dataSet = entNumPublishAppIdDS.join(allEntInfoDS).on("entapp_entnum", "entnum").select(new String[]{"entapp_entnum", "entityId", "entapp_appid"}).finish();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String entityId = row.getString("entityId");
                if (StringUtils.isEmpty((String)entityId)) continue;
                entityIdSet.add(entityId);
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("dentityid", "in", entityIdSet)};
            DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"bos_entityinfo", (String)"id,modeltype,dentityid", (QFilter[])qFilters);
            entityIdSet = new HashSet();
            Map runModeBlackList_AppEntMap = PermCommonUtil.getRunModeBlackList_AppEntMap();
            Set runModeBlackList_EntityNums = null;
            if (runModeBlackList_AppEntMap != null) {
                runModeBlackList_EntityNums = (Set)runModeBlackList_AppEntMap.get(parentTrueId);
            }
            Map permControlType = PermCommonUtil.getPermControlType();
            for (DynamicObject dynamicObject : entitys) {
                PermissionControlType permissionControlType;
                String entNum = dynamicObject.getString("id");
                String entId = dynamicObject.getString("dentityid");
                if (runModeBlackList_EntityNums != null && runModeBlackList_EntityNums.contains(entNum) || (permissionControlType = (PermissionControlType)permControlType.get(entNum)) != null && permissionControlType.isForbidDataPerm()) continue;
                entityIdAndNumMap.put(entId, entNum);
                entityIdSet.add(dynamicObject.getString("dentityid"));
            }
        }
        boolean isShowNum = (Boolean)this.getModel().getValue(PROP_SHOWNUM);
        if (level == 1) {
            for (void var14_27 : load) {
                childrenDataTree = new TreeNode();
                childrenDataTree.setParentid(String.valueOf(parentId));
                childrenDataTree.addChildren(new ArrayList());
                String id = (String)var14_27.get("id");
                childrenDataTree.setId("2_split_" + id);
                LocaleString lsName = AppHelper.getMetaAppInfo((String)id).getName();
                String appName = (String)lsName.get((Object)RequestContext.get().getLang().name());
                if (StringUtils.isEmpty((String)appName)) {
                    appName = (String)lsName.get((Object)"zh_CN");
                }
                String appNum = var14_27.getString(PROP_NUMBER);
                if (StringUtils.isEmpty((String)appName)) {
                    appName = appNum;
                } else if (isShowNum) {
                    appName = appName + "(" + appNum + ")";
                }
                childrenDataTree.setText(appName);
                if (childrenDataTree == null) continue;
                treeView.addNode(childrenDataTree);
            }
        }
        if (level == 2) {
            Map<String, String> map = this.getBizObjectById(null);
            for (String entityId : entityIdSet) {
                String string = (String)entityIdAndNumMap.get(entityId);
                childrenDataTree = new TreeNode();
                childrenDataTree.setParentid(String.valueOf(parentId));
                if (map.containsKey(string)) {
                    childrenDataTree.setId("3_split_" + entityId + ID_SPLIT + parentId);
                    String entityName = map.get(string);
                    if (StringUtils.isEmpty((String)entityName)) {
                        entityName = string;
                    } else if (isShowNum) {
                        entityName = entityName + "(" + string + ")";
                    }
                    childrenDataTree.setText(entityName);
                } else {
                    childrenDataTree = null;
                }
                if (childrenDataTree == null) continue;
                treeView.addNode(childrenDataTree);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchByText(String searchText) {
        Map cloudIdAndNum;
        Map allCloudName;
        Map allAppIdNumberMap;
        Map extAppIdAndOrgnlAppIdMap;
        Map allAppName;
        Map allEntityName;
        ArrayList<String> formNums;
        String entityIdsFromBlacklist;
        boolean isShowNum;
        TreeNode root;
        TreeView tree;
        DataSet finalDS;
        DataSet appRelDS;
        DataSet unitRelFormDS;
        DataSet entityInfoDS;
        block22: {
            block21: {
                entityInfoDS = null;
                unitRelFormDS = null;
                appRelDS = null;
                finalDS = null;
                String langStr = RequestContext.get().getLang().name();
                tree = (TreeView)this.getView().getControl(TREEVIEW_LEFTTREE);
                tree.deleteAllNodes();
                root = new TreeNode();
                root.setParentid("");
                root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"DataRuleTreeListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                root.setId("0");
                root.setIsOpened(true);
                isShowNum = (Boolean)this.getModel().getValue(PROP_SHOWNUM);
                entityIdsFromBlacklist = RunModeServiceHelper.getEntityIdFromBlacklist();
                String sql = null;
                StringBuilder sbSql = new StringBuilder("SELECT FID, FNAME FROM T_META_MAINENTITYINFO_L ").append(" WHERE (FNAME LIKE '%").append(searchText).append("%' ");
                if (isShowNum) {
                    sbSql.append(" OR FID LIKE '%").append(searchText).append("%' ");
                }
                sql = sbSql.append(") ").append(" AND FLOCALEID = '").append(langStr).append("' ").toString();
                entityInfoDS = DB.queryDataSet((String)"searchByText_entityInfo", (DBRoute)DBRoute.meta, (String)sql, null);
                formNums = new ArrayList<String>(8);
                if (entityInfoDS != null && entityInfoDS.hasNext()) break block21;
                PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{unitRelFormDS, appRelDS, finalDS, entityInfoDS});
                return;
            }
            while (entityInfoDS.hasNext()) {
                Row row = entityInfoDS.next();
                formNums.add(row.getString("fid"));
            }
            entityInfoDS.close();
            allEntityName = FormHelper.getAllEntNumAndNameRuntimeMap();
            allAppName = AppHelper.getAllAppIdNameMap();
            extAppIdAndOrgnlAppIdMap = AppHelper.getExtAppAndOrgnlAppRel();
            allAppIdNumberMap = AppHelper.getAllAppIdNumberMap();
            allCloudName = CloudHelper.getAllCloudIdNameMap();
            cloudIdAndNum = CloudHelper.getCloudIdAndNum();
            if (!CollectionUtils.isEmpty((Map)allEntityName) && !CollectionUtils.isEmpty((Map)allAppName) && !CollectionUtils.isEmpty((Map)allCloudName)) break block22;
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{unitRelFormDS, appRelDS, finalDS, entityInfoDS});
            return;
        }
        try {
            Set disabledCloudIds;
            List adminChargeAppIds;
            AdminAppResult adminApps;
            String appIdFromBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
            String cloudIdsFromBlackList = RunModeServiceHelper.getCloudIdsFromBlackList();
            StringBuilder queryEntityDesignSql = new StringBuilder();
            queryEntityDesignSql.append("SELECT e.fid entityId,e.fnumber entityNum,f.fbizappid appId ").append(" FROM T_META_ENTITYDESIGN E ").append(" LEFT JOIN T_META_BIZUNITRELFORM B ON E.FID = B.FFORMID ").append(" LEFT JOIN t_meta_mainentityinfo f on f.fdentityid = b.fformid ").append(" WHERE E.FMODELTYPE IN ('BillFormModel', 'BaseFormModel','LogBillFormModel') ").append(" AND e.FISTEMPLATE = '0' ").append(" AND E.fnumber in (").append(ListUtil.getSqlList(formNums)).append(')').append(" and e.fid not in (").append(entityIdsFromBlacklist).append(')');
            entityInfoDS = DB.queryDataSet((String)"searchByText_entityInfo_formNums", (DBRoute)DBRoute.meta, (String)queryEntityDesignSql.toString());
            unitRelFormDS = DB.queryDataSet((String)"searchByText_unitRelForm", (DBRoute)DBRoute.meta, (String)"select fbizappid appId,fformid formId from T_meta_bizunitrelform");
            entityInfoDS = entityInfoDS.join(unitRelFormDS).on("entityId", "formId").select(new String[]{"entityNum", "entityId", "appId"}, new String[0]).finish();
            DataSet entNumPublishAppIdDS = DB.queryDataSet((String)"entNumPublishAppIdDS", (DBRoute)DBRoute.permission, (String)("SELECT fbizobjid entapp_entnum, fbizappid entapp_appid FROM t_perm_bizobjapp" + " where fbizobjid in(" + ListUtil.getSqlList(formNums) + ")"));
            DataSet allEntInfoDS = DB.queryDataSet((String)"entNumPublishAppIdDS", (DBRoute)DBRoute.meta, (String)"SELECT fid entnum, fdentityid entityId FROM t_meta_mainentityinfo");
            DataSet pubDS = entNumPublishAppIdDS.join(allEntInfoDS).on("entapp_entnum", "entnum").select(new String[]{"entapp_entnum", "entityId", "entapp_appid"}).finish();
            DataSet finalEntityDS = entityInfoDS.union(pubDS);
            finalEntityDS = finalEntityDS.distinct();
            StringBuilder queryBizAppSql = new StringBuilder();
            queryBizAppSql.append("select fbizcloudid cloudId,fid appId from t_meta_bizapp where fid not in ( ");
            queryBizAppSql.append(appIdFromBlacklist == null ? "''" : appIdFromBlacklist);
            queryBizAppSql.append(')');
            HashSet<String> disabledAppIds = ManageServiceHelper.getDisabledAppIds();
            if (disabledAppIds == null) {
                disabledAppIds = new HashSet<String>(10);
            }
            disabledAppIds.add("2HGKTA7HH43C");
            String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
            queryBizAppSql.append(" and fid not in ('").append(disabledAppIdsStr).append("') ");
            List allUserAppIds = PermCommonUtil.getAllUserAppIds();
            if (null != allUserAppIds && !allUserAppIds.isEmpty()) {
                String allUserAppIdsStr = String.join((CharSequence)"','", allUserAppIds);
                queryBizAppSql.append(" and fid not in('").append(allUserAppIdsStr).append("') ");
            }
            if ((adminApps = new PermissionServiceImpl().getAdminApps(Long.valueOf(RequestContext.get().getCurrUserId()), true)) != null && adminApps.needAdminAppRange() && (adminChargeAppIds = adminApps.getAppIds()) != null && !adminChargeAppIds.isEmpty()) {
                String adminChargeAppIdsStr = String.join((CharSequence)"','", adminChargeAppIds);
                queryBizAppSql.append(" and fid in ('").append(adminChargeAppIdsStr).append("') ");
            }
            if (StringUtils.isNotEmpty((String)cloudIdsFromBlackList) && !"''".equals(cloudIdsFromBlackList)) {
                queryBizAppSql.append(" and fbizcloudid not in (").append(cloudIdsFromBlackList).append(')');
            }
            if (null != (disabledCloudIds = ManageServiceHelper.getDisabledCloudIds()) && !disabledCloudIds.isEmpty()) {
                String disabledCloudIdsStr = String.join((CharSequence)"','", disabledCloudIds);
                queryBizAppSql.append("AND fbizcloudid not in ('").append(disabledCloudIdsStr).append("') ");
            }
            queryBizAppSql.append(" and fvisible = '1' and fdeploystatus = '2'");
            appRelDS = DB.queryDataSet((String)"searchByText_appRel", (DBRoute)DBRoute.meta, (String)queryBizAppSql.toString());
            finalDS = finalEntityDS.join(appRelDS).on("appId", "appId").select(new String[]{"entityNum", "appId", "entityId"}, new String[]{"cloudId"}).finish();
            finalDS = finalDS.orderBy(new String[]{"cloudId", "appId", "entityId"});
            String lastCloudId = null;
            String lastAppId = null;
            TreeNode treeNodeCloud = null;
            TreeNode treeNodeApp = null;
            if (finalDS != null) {
                Map permControlTypeMap = PermCommonUtil.getPermControlType();
                HashMap<String, TreeNode> appNodeMap = new HashMap<String, TreeNode>();
                Map runModeBlackList_AppEntMap = PermCommonUtil.getRunModeBlackList_AppEntMap();
                while (finalDS.hasNext()) {
                    Set runModeEntityNumsblackList;
                    Row row = finalDS.next();
                    String cloudId = row.getString("cloudId");
                    String appId = row.getString("appId");
                    String entityNum = row.getString("entityNum");
                    PermissionControlType permissionControlType = (PermissionControlType)permControlTypeMap.get(entityNum);
                    if (permissionControlType != null && permissionControlType.isForbidDataPerm()) continue;
                    String entityId = row.getString("entityId");
                    String entityName = (String)allEntityName.get(entityNum);
                    if (StringUtils.isEmpty((String)(appId = (String)extAppIdAndOrgnlAppIdMap.get(appId))) || runModeBlackList_AppEntMap != null && (runModeEntityNumsblackList = (Set)runModeBlackList_AppEntMap.get(appId)) != null && runModeEntityNumsblackList.contains(entityNum)) continue;
                    String cloudNodeId = "1_split_" + cloudId;
                    if (!cloudId.equals(lastCloudId)) {
                        String cloudName = (String)allCloudName.get(cloudId);
                        lastCloudId = cloudId;
                        treeNodeCloud = new TreeNode();
                        treeNodeCloud.setParentid("0");
                        treeNodeCloud.setId(cloudNodeId);
                        if (isShowNum) {
                            cloudName = cloudName + "(" + (String)cloudIdAndNum.get(cloudId) + ")";
                        }
                        treeNodeCloud.setText(cloudName);
                        treeNodeCloud.setIsOpened(true);
                        root.addChild(treeNodeCloud);
                    }
                    String appNodeId = "2_split_" + appId;
                    if (!appId.equals(lastAppId)) {
                        String appName = (String)allAppName.get(appId);
                        lastAppId = appId;
                        treeNodeApp = (TreeNode)appNodeMap.get(appNodeId);
                        if (treeNodeApp == null) {
                            treeNodeApp = new TreeNode();
                            treeNodeApp.setParentid(cloudNodeId);
                            treeNodeApp.setId(appNodeId);
                            if (isShowNum) {
                                appName = appName + "(" + (String)allAppIdNumberMap.get(appId) + ")";
                            }
                            treeNodeApp.setText(appName);
                            treeNodeApp.addChildren(new ArrayList());
                            treeNodeApp.setIsOpened(true);
                            appNodeMap.put(appNodeId, treeNodeApp);
                            treeNodeCloud.addChild(treeNodeApp);
                        }
                    }
                    TreeNode treeNodeEntity = new TreeNode();
                    treeNodeEntity.setParentid(appNodeId);
                    treeNodeEntity.setId("3_split_" + entityId + ID_SPLIT + appId);
                    if (isShowNum) {
                        entityName = entityName + "(" + entityNum + ")";
                    }
                    treeNodeEntity.setText(entityName);
                    treeNodeApp.addChild(treeNodeEntity);
                }
            }
            tree.addNode(root);
        }
        catch (Exception e) {
            try {
                logger.warn((Throwable)e);
            }
            catch (Throwable throwable) {
                PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{unitRelFormDS, appRelDS, finalDS, entityInfoDS});
                throw throwable;
            }
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{unitRelFormDS, appRelDS, finalDS, entityInfoDS});
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{unitRelFormDS, appRelDS, finalDS, entityInfoDS});
    }

    private List<String> findBizappExistsEntity(String bizCloudId) {
        final List allUserAppIds = PermCommonUtil.getAllUserAppIds();
        final boolean allUserAppIdsNotEmpty = allUserAppIds != null && !allUserAppIds.isEmpty();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT A.FID, A.FMASTERID, E.FNUMBER entnum ").append(" FROM T_META_BIZAPP A").append(" INNER JOIN T_META_BIZUNITRELFORM B ON (B.FBIZAPPID = A.FID)  ").append(" INNER JOIN T_META_ENTITYDESIGN E ON (E.FID = B.FFORMID) ").append(" WHERE A.FBIZCLOUDID = ?").append(" AND A.fdeploystatus = '2' ").append(" AND E.FMODELTYPE IN ('BillFormModel', 'BaseFormModel','LogBillFormModel') ").append(" AND E.FISTEMPLATE = '0' ");
        final Map permControlType = PermCommonUtil.getPermControlType();
        Object[] filters = new String[]{bizCloudId};
        Set idSet = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> ids = new HashSet<String>();
                while (rs.next()) {
                    String id = rs.getString(1);
                    if (allUserAppIdsNotEmpty && allUserAppIds.contains(id)) continue;
                    String masterid = rs.getString(2);
                    String entNum = rs.getString(3);
                    PermissionControlType permissionControlType = (PermissionControlType)permControlType.get(entNum);
                    if (permissionControlType != null && permissionControlType.isForbidDataPerm()) continue;
                    if (StringUtils.isNotEmpty((String)masterid)) {
                        ids.add(masterid);
                        continue;
                    }
                    ids.add(id);
                }
                return ids;
            }
        });
        String algoKeyPrefix = "DataRuleTreeListPlugin_";
        DataSet appDS = DB.queryDataSet((String)(algoKeyPrefix + "appDS"), (DBRoute)DBRoute.meta, (String)("select a.fid appid, a.fmasterid appmasterid from t_meta_bizapp a " + " where a.fbizcloudid = ? " + " and a.fdeploystatus = '2' "), (Object[])new Object[]{bizCloudId});
        DataSet entDS = DB.queryDataSet((String)(algoKeyPrefix + "entDS"), (DBRoute)DBRoute.meta, (String)("select  e.fnumber entnum " + " from t_meta_entitydesign e " + " where e.fmodeltype in ('BillFormModel', 'BaseFormModel','LogBillFormModel') " + " and e.fistemplate = '0' "));
        DataSet entNumPublishAppIdDS = DB.queryDataSet((String)(algoKeyPrefix + "entNumPublishAppIdDS"), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid entapp_entnum FROM t_perm_bizobjapp");
        DataSet finishDS = entNumPublishAppIdDS.join(appDS).on("entapp_appid", "appid").select(new String[]{"entapp_entnum"}, new String[]{"appid", "appmasterid"}).finish().join(entDS).on("entapp_entnum", "entnum").select(new String[]{"appid", "appmasterid"}, new String[]{"entnum"}).finish();
        while (finishDS.hasNext()) {
            PermissionControlType permissionControlType;
            Row row = finishDS.next();
            String appId = row.getString("appid");
            String appMasterId = row.getString("appmasterid");
            String entNum = row.getString("entnum");
            if (allUserAppIdsNotEmpty && allUserAppIds.contains(appId) || (permissionControlType = (PermissionControlType)permControlType.get(entNum)) != null && permissionControlType.isForbidDataPerm()) continue;
            if (StringUtils.isNotEmpty((String)appMasterId)) {
                idSet.add(appMasterId);
                continue;
            }
            idSet.add(appId);
        }
        finishDS.close();
        return new ArrayList<String>(idSet);
    }

    private static List<String> getAllExtAppId(String originalAppId) {
        StringBuilder sb = new StringBuilder("select fid from t_meta_bizapp where fmasterid = ? ").append(" and fid <> ? ");
        final ArrayList<String> result = new ArrayList<String>();
        Object[] params = new Object[]{originalAppId, originalAppId};
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    result.add(rs.getString("fid"));
                }
                return null;
            }
        });
        return result;
    }

    private Map<String, String> getBizObjectById(final String id) {
        Map map = null;
        StringBuilder sql = new StringBuilder();
        Object[] filters = null;
        sql.append(" SELECT a.fid, b.fname from t_meta_mainentityinfo a ");
        sql.append(" LEFT JOIN t_meta_mainentityinfo_l b on (a.fid = b.fid and b.flocaleid = ?) ");
        sql.append(" where ");
        if (StringUtils.isNotEmpty((String)id)) {
            sql.append(" a.fdentityid = ? and ");
            filters = new String[]{RequestContext.get().getLang().name(), id};
        } else {
            filters = new String[]{RequestContext.get().getLang().name()};
        }
        sql.append(" a.fistemplate = '0'  ");
        sql.append(" and a.fmodeltype in ('BaseFormModel', 'BillFormModel','LogBillFormModel') ");
        map = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> result = new HashMap<String, String>(10000);
                while (rs.next()) {
                    if (StringUtils.isNotEmpty((String)id)) {
                        result.put(DataRuleTreeListPlugin.PROP_NUMBER, rs.getString("fid"));
                        result.put("name", rs.getString("fname"));
                        continue;
                    }
                    result.put(rs.getString("fid"), rs.getString("fname"));
                }
                return result;
            }
        });
        return map;
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        QFilter q = null;
        String nodeId = (String)treeNodeEvent.getNodeId();
        String parentNodeId = (String)treeNodeEvent.getParentNodeId();
        TreeView leftTree = (TreeView)treeNodeEvent.getSource();
        String id = String.valueOf(nodeId);
        if ("0".equals(id) || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(id)) {
            this.getPageCache().remove(PGCACHE_LEFTTREE_QLIFTER_JSON);
            return;
        }
        int level = Integer.parseInt(id.split(ID_SPLIT)[0]);
        String trueId = id.split(ID_SPLIT)[1];
        if (level == 1) {
            Set disabledAppIds;
            List allUserAppIds;
            List adminChargeApps;
            StringBuilder sbSql = new StringBuilder("select a.fnumber from t_meta_entitydesign a ").append(" left join t_meta_bizunitrelform b on a.fid = b.fformid  ").append(" left join t_meta_bizapp c on b.fbizappid = c.fid ").append(" where c.fbizcloudid = ? and c.fvisible = '1' and a.fistemplate = '0' ").append(" and c.fdeploystatus = '2' ");
            String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
            if (StringUtils.isNotEmpty((String)appBlacklist)) {
                sbSql.append(" and c.fid not in (").append(appBlacklist).append(")");
            }
            if (null != (adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)RequestContext.get().getCurrUserId())) && !adminChargeApps.isEmpty()) {
                String admiChargeAppIdStr = String.join((CharSequence)"','", adminChargeApps);
                sbSql.append(" and c.fid in('").append(admiChargeAppIdStr).append("') ");
            }
            if (null != (allUserAppIds = PermCommonUtil.getAllUserAppIds()) && !allUserAppIds.isEmpty()) {
                String allUserAppIdsStr = String.join((CharSequence)"','", allUserAppIds);
                sbSql.append(" and c.fid not in('").append(allUserAppIdsStr).append("') ");
            }
            if (null != (disabledAppIds = ManageServiceHelper.getDisabledAppIds()) && !disabledAppIds.isEmpty()) {
                String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
                sbSql.append(" and c.fid not in('").append(disabledAppIdsStr).append("') ");
            }
            Object[] filters = new String[]{trueId};
            List entityNumList = (List)DB.query((DBRoute)DBRoute.meta, (String)sbSql.toString(), (Object[])filters, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws SQLException {
                    ArrayList<String> result = new ArrayList<String>(8000);
                    while (rs.next()) {
                        result.add(rs.getString("fnumber"));
                    }
                    return result;
                }
            });
            String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
            Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            ArrayList<String> filterCloudIds = new ArrayList<String>();
            filterCloudIds.add(trueId);
            DataSet finishDS = this.getPubAppEntDS(cloudBlacklist, appBlacklist, disabledCloudIds, disabledAppIds, allUserAppIds, adminChargeApps, filterCloudIds, null);
            while (finishDS.hasNext()) {
                Row row = finishDS.next();
                String entNum = row.getString("entnum");
                entityNumList.add(entNum);
            }
            q = new QFilter(PROP_ENTITY, "in", (Object)entityNumList);
            this.getPageCache().put(PGCACHE_LEFTTREE_QLIFTER_JSON, q.toSerializedString());
            leftTree.queryTreeNodeChildren(parentNodeId, nodeId);
        } else if (level == 2) {
            Set disabledAppIds;
            List allUserAppIds;
            List adminChargeApps;
            String appBlacklist;
            StringBuilder sql = new StringBuilder("select a.fnumber from t_meta_entitydesign a ").append(" left join t_meta_bizunitrelform b on a.fid = b.fformid ").append(" where a.fistemplate = '0' and b.fbizappid in (? ");
            List<String> allExtAppId = DataRuleTreeListPlugin.getAllExtAppId(trueId);
            Object[] filters = new String[allExtAppId.size() + 1];
            for (int i = 0; i < allExtAppId.size() + 1; ++i) {
                if (i == 0) {
                    filters[0] = trueId;
                    continue;
                }
                sql.append(" ,? ");
                filters[i] = allExtAppId.get(i - 1);
            }
            sql.append(" ) ");
            String appNumber = AppMetadataCache.getAppNumberById((String)trueId);
            String entityNumBlacklist = RunModeServiceHelper.getEntityNumFromBlacklist((String)appNumber);
            if (StringUtils.isNotEmpty((String)entityNumBlacklist)) {
                sql.append(" and a.fnumber not in (").append(entityNumBlacklist).append(')');
            }
            if (StringUtils.isNotEmpty((String)(appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist()))) {
                sql.append(" and b.fbizappid not in (").append(appBlacklist).append(")");
            }
            if (null != (adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)RequestContext.get().getCurrUserId())) && !adminChargeApps.isEmpty()) {
                String admiChargeAppIdStr = String.join((CharSequence)"','", adminChargeApps);
                sql.append(" and b.fbizappid in('").append(admiChargeAppIdStr).append("') ");
            }
            if (null != (allUserAppIds = PermCommonUtil.getAllUserAppIds()) && !allUserAppIds.isEmpty()) {
                String allUserAppIdsStr = String.join((CharSequence)"','", allUserAppIds);
                sql.append(" and b.fbizappid not in('").append(allUserAppIdsStr).append("') ");
            }
            if (null != (disabledAppIds = ManageServiceHelper.getDisabledAppIds()) && !disabledAppIds.isEmpty()) {
                String disabledAppIdsStr = String.join((CharSequence)"','", disabledAppIds);
                sql.append(" and b.fbizappid not in('").append(disabledAppIdsStr).append("') ");
            }
            List entNumList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws SQLException {
                    ArrayList<String> result = new ArrayList<String>(200);
                    while (rs.next()) {
                        result.add(rs.getString("fnumber"));
                    }
                    return result;
                }
            });
            String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
            Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            ArrayList<String> filterAppIds = new ArrayList<String>();
            filterAppIds.add(trueId);
            DataSet finishDS = this.getPubAppEntDS(cloudBlacklist, appBlacklist, disabledCloudIds, disabledAppIds, allUserAppIds, adminChargeApps, null, filterAppIds);
            while (finishDS.hasNext()) {
                Row row = finishDS.next();
                String entNum = row.getString("entnum");
                entNumList.add(entNum);
            }
            q = new QFilter(PROP_ENTITY, "in", (Object)entNumList);
            this.getPageCache().put(PGCACHE_LEFTTREE_QLIFTER_JSON, q.toSerializedString());
            leftTree.queryTreeNodeChildren(parentNodeId, nodeId);
        } else if (level == 3) {
            Map<String, String> map = this.getBizObjectById(trueId);
            q = new QFilter(PROP_ENTITY, "=", (Object)map.get(PROP_NUMBER));
            this.getPageCache().put(PGCACHE_LEFTTREE_QLIFTER_JSON, q.toSerializedString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if (("disable".equals(operateKey) || "enable".equals(operateKey) || "delete".equals(operateKey)) && PermCommonUtil.isEnablePermLog()) {
            String langStr = RequestContext.get().getLang().name();
            this.permLogBusiType = "disable".equals(operateKey) ? PermLogService.getPermLogBusiType((String)"dr_disable") : ("enable".equals(operateKey) ? PermLogService.getPermLogBusiType((String)"dr_enable") : PermLogService.getPermLogBusiType((String)"dr_del"));
            Object[] dataRuleIdArr = e.getListSelectedData().getPrimaryKeyValues();
            if (null == dataRuleIdArr || 0 == dataRuleIdArr.length) {
                return;
            }
            int size = dataRuleIdArr.length;
            this.dataRuleIdList = new ArrayList<Long>(size);
            this.dataRuleNumberList = new ArrayList<String>(size);
            this.dataRuleNameList = new ArrayList<String>(size);
            this.dataRuleEntityNumList = new ArrayList<String>(size);
            this.preDataList = new ArrayList<String>(size);
            List drIdList = Stream.of(dataRuleIdArr).map(x -> (Long)x).collect(Collectors.toList());
            Map dataRuleMap = DrHelper.getDataRuleMap(drIdList);
            for (Map.Entry map : dataRuleMap.entrySet()) {
                Long key = (Long)map.getKey();
                Map value = (Map)map.getValue();
                this.dataRuleIdList.add(key);
                this.dataRuleNumberList.add((String)value.get("fnumber"));
                this.dataRuleNameList.add((String)value.get("fname"));
                String fentitynum = (String)value.get("fentitynum");
                this.dataRuleEntityNumList.add(fentitynum);
                this.preDataList.add(DrLogHelper.drEventImage((Long)key, (String)langStr, (boolean)false, (String)fentitynum));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if ("refresh".equals(opKey)) {
            TreeView tv = (TreeView)this.getControl(TREEVIEW_LEFTTREE);
            Map focusNode = tv.getTreeState().getFocusNode();
            String nodeId = (String)focusNode.get("id");
            String parentId = (String)focusNode.get("parentid");
            tv.treeNodeClick(parentId, nodeId);
        } else if ("disable".equals(opKey) || "enable".equals(opKey) || "delete".equals(opKey)) {
            List successPkIds;
            DataRuleCache.removeAllCache();
            OperationResult operationResult = e.getOperationResult();
            if (null != operationResult && null != (successPkIds = operationResult.getSuccessPkIds()) && !successPkIds.isEmpty() && PermCommonUtil.isEnablePermLog()) {
                String langStr = RequestContext.get().getLang().name();
                int size = this.dataRuleIdList.size();
                ArrayList<String> afterDataList = new ArrayList<String>(size);
                for (int i = 0; i < size; ++i) {
                    afterDataList.add(DrLogHelper.drEventImage((Long)this.dataRuleIdList.get(i), (String)langStr, (boolean)true, (String)this.dataRuleEntityNumList.get(i)));
                }
                String opbtn = "disable".equals(opKey) ? ConstantsHelper.getDisable() : ("enable".equals(opKey) ? ConstantsHelper.getEnable() : ConstantsHelper.getDel());
                this.drEvent2PermLogList(opKey, opbtn, this.dataRuleIdList, this.dataRuleNumberList, this.dataRuleNameList, this.preDataList, afterDataList, this.permLogBusiType);
            }
        }
    }

    private void drEvent2PermLogList(String op, String opbtn, List<Long> opItemIdList, List<String> opItemNumberList, List<String> opItemNameList, List<String> preDataList, List<String> afterDataList, PermLogBusiType permLogBusiType) {
        try {
            String formNum = "perm_datarule";
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            int size = opItemIdList.size();
            ArrayList list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                String opItemId = String.valueOf(opItemIdList.get(i));
                String opItemNumber = opItemNumberList.get(i);
                String opItemName = opItemNameList.get(i);
                String preData = preDataList.get(i);
                String afterData = afterDataList.get(i);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(PROP_NUMBER, PermLogUtil.getPermLogFnumber());
                map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
                map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
                map.put("cloud_id", cloudId);
                map.put("app_id", appId);
                map.put("form_identity", formNum);
                map.put("op", op);
                map.put("opbtn", opbtn);
                map.put("interface_method", "kd.bos.permission.formplugin.plugin.DataRuleTreeListPlugin.drEvent2PermLogList");
                map.put("op_item_id", opItemId);
                map.put("op_item_number", opItemNumber);
                map.put("op_item_name", opItemName);
                map.put("pre_data", preData);
                map.put("after_data", afterData);
                list.add(map);
            }
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("DataRuleTreeListPlugin.drEvent2PermLogList error, opItemIdList:{}, opItemNameList:{}", new Object[]{opItemIdList, opItemNameList, e});
        }
    }

    private void recordLeftTreeNodeHasLoad(String parentNodeId) {
        Set hasOpenNodeIdsSet = null;
        String hasOpenNodeIdsStr = this.getPageCache().get(PGCACHE_HASQUERYCHILDREN);
        hasOpenNodeIdsSet = StringUtils.isEmpty((String)hasOpenNodeIdsStr) ? new HashSet(8) : (Set)SerializationUtils.fromJsonString((String)hasOpenNodeIdsStr, Set.class);
        hasOpenNodeIdsSet.add(parentNodeId);
        this.getPageCache().put(PGCACHE_HASQUERYCHILDREN, SerializationUtils.toJsonString(hasOpenNodeIdsSet));
    }

    private boolean ifLeftTreeNodeHasLoadChildren(String parentNodeId) {
        Set hasOpenNodeIdsSet = null;
        String hasOpenNodeIdsStr = this.getPageCache().get(PGCACHE_HASQUERYCHILDREN);
        if (StringUtils.isEmpty((String)hasOpenNodeIdsStr)) {
            return false;
        }
        hasOpenNodeIdsSet = (Set)SerializationUtils.fromJsonString((String)hasOpenNodeIdsStr, Set.class);
        return hasOpenNodeIdsSet.contains(parentNodeId);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qList = e.getQFilters();
        qList.add(new QFilter("isdetail", "=", (Object)"1"));
        qList.add(new QFilter("id", "!=", (Object)-1L));
        FormShowParameter fsp = this.getView().getFormShowParameter();
        ListShowParameter lsp = (ListShowParameter)fsp;
        if (!lsp.isLookUp()) {
            String entityNum;
            String leftTreeQFilterJson = this.getPageCache().get(PGCACHE_LEFTTREE_QLIFTER_JSON);
            if (StringUtils.isNotEmpty((String)leftTreeQFilterJson)) {
                qList.add(QFilter.fromSerializedString((String)leftTreeQFilterJson));
                return;
            }
            long userId = RequestContext.get().getCurrUserId();
            boolean isTopAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
            if (isTopAdmin) {
                return;
            }
            List adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)userId);
            if (adminChargeApps == null || adminChargeApps.isEmpty()) {
                return;
            }
            Map extAppAndOrgnlAppRel = AppHelper.getExtAppAndOrgnlAppRel();
            DataSet entNumOrgnlAppIdDS = DB.queryDataSet((String)"entNumOrgnlAppIdDS", (DBRoute)DBRoute.meta, (String)"select fbizappid appid, fformid formid from t_meta_bizunitrelform ");
            DataSet allEntInfoDS = DB.queryDataSet((String)"allEntInfoDS", (DBRoute)DBRoute.meta, (String)"SELECT fid entnum, fdentityid entityId FROM t_meta_mainentityinfo");
            DataSet allEntInfoDS2 = allEntInfoDS.copy();
            DataSet orgnlAppEntDS = entNumOrgnlAppIdDS.join(allEntInfoDS).on("formid", "entityId").select(new String[]{"appid"}, new String[]{"entnum"}).finish();
            DataSet entNumPubAppIdDS = DB.queryDataSet((String)"entNumPubAppIdDS", (DBRoute)DBRoute.permission, (String)"SELECT fbizobjid pubapp_entnum, fbizappid pubapp_appid FROM t_perm_bizobjapp");
            DataSet pubDS = entNumPubAppIdDS.join(allEntInfoDS2).on("pubapp_entnum", "entnum").select(new String[]{"pubapp_appid", "pubapp_entnum"}).finish();
            DataSet finalDS = orgnlAppEntDS.union(pubDS);
            HashSet<String> entityNumSet = new HashSet<String>(8);
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String appId = row.getString("appid");
                String orgnlAppId = (String)extAppAndOrgnlAppRel.get(appId);
                if (StringUtils.isNotEmpty((String)orgnlAppId) && !adminChargeApps.contains(orgnlAppId) || StringUtils.isEmpty((String)(entityNum = row.getString("entnum")))) continue;
                entityNumSet.add(entityNum);
            }
            finalDS.close();
            DataSet hasSetDataRuleEntDS = DB.queryDataSet((String)"hasSetDataRuleEntDS", (DBRoute)DBRoute.permission, (String)("select distinct fentitynum entNum from t_perm_datarule " + " where fisdetail = '1' and fid <> -1 "));
            HashSet<String> hasSetDataRuleEntNumSet = new HashSet<String>(8);
            while (hasSetDataRuleEntDS.hasNext()) {
                Row row = hasSetDataRuleEntDS.next();
                entityNum = row.getString("entNum");
                hasSetDataRuleEntNumSet.add(entityNum);
            }
            hasSetDataRuleEntNumSet.retainAll(entityNumSet);
            hasSetDataRuleEntDS.close();
            QFilter q = new QFilter(PROP_ENTITY, "in", hasSetDataRuleEntNumSet);
            qList.add(q);
        }
    }

    public void search(SearchEnterEvent evt) {
        super.search(evt);
        String searchText = evt.getText();
        String currentSearchText = this.getPageCache().get(PGCACHE_CURRENTSEARCHTEXT);
        boolean isBlank = "".equals(searchText);
        if (!isBlank && searchText.equals(currentSearchText)) {
            return;
        }
        if (!SqlUtil.checkSearchText((String)searchText)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u4e2d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff08%\uff0c'\uff09\u6216\u5168\u90e8\u4e3a_\u3002", (String)"DataRuleTreeListPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(PGCACHE_CURRENTSEARCHTEXT, searchText);
        this.getPageCache().remove(PGCACHE_HASQUERYCHILDREN);
        if (isBlank) {
            this.initTree();
            TreeView tv = (TreeView)this.getControl(TREEVIEW_LEFTTREE);
            Map focusNode = tv.getTreeState().getFocusNode();
            String nodeId = (String)focusNode.get("id");
            String parentId = (String)focusNode.get("parentid");
            tv.treeNodeClick(parentId, nodeId);
        } else {
            this.searchByText(searchText);
        }
    }
}

