/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.enums.MultiLangEnumBridge;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.StringUtils;

public class MenuPermInfoPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener {
    private TreeView menuTreeView = null;
    private static final String MENUTREE = "menutree";
    private static final String ROOTID = "0";
    private static final String CLOUD_SUFFIX = "#cloud";
    private static final String APP_SUFFIX = "#app";
    private static final String MENU1_SUFFIX = "#menu1";
    private static final String MENU2_SUFFIX = "#menu2";
    private static final String FORM_SUFFIX = "#form";
    private static final String LANGSTR = RequestContext.get().getLang().name();
    private static final String PGCACHE_IDLONGNUMMAP = "pgCache_idLongNumMap";

    private String notInBlackList() {
        return ResManager.loadKDString((String)"\u4e0d\u5728\u9ed1\u540d\u5355\u4e2d", (String)"MenuPermInfoPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String isInBlackList() {
        return ResManager.loadKDString((String)"\u5728\u9ed1\u540d\u5355\u4e2d", (String)"MenuPermInfoPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String yes() {
        return ResManager.loadKDString((String)"\u662f", (String)"MenuPermInfoPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String no() {
        return ResManager.loadKDString((String)"\u5426", (String)"MenuPermInfoPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String appIdIsNull() {
        return ResManager.loadKDString((String)"\u4f20\u5165\u5e94\u7528id\u6216\u6700\u7ec8\u6269\u5c55\u5e94\u7528id\u4e3a\u7a7a", (String)"MenuPermInfoPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    private String formNumIsNull() {
        return ResManager.loadKDString((String)"\u4f20\u5165\u8868\u5355id\u6216\u6700\u7ec8\u6269\u5c55\u8868\u5355id\u4e3a\u7a7a", (String)"MenuPermInfoPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        this.menuTreeView = (TreeView)this.getView().getControl(MENUTREE);
        this.menuTreeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initMenuTree();
    }

    public void initMenuTree() {
        this.getView().getPageCache().remove(PGCACHE_IDLONGNUMMAP);
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(ROOTID);
        root.setIsOpened(true);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"MenuPermInfoPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct bc.fid as id,bc.fseq,bcl.fname as name from t_meta_bizcloud bc ").append("join t_meta_bizcloud_l bcl on bc.fid=bcl.fid ").append("where bcl.flocaleid=? ").append(" and exists (select 1 from t_meta_bizapp app where bc.fid=app.fbizcloudid )").append(" order by bc.fseq");
        Object[] params = new Object[]{RequestContext.get().getLang().name()};
        DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, rs -> {
            while (rs.next()) {
                String cloudId = rs.getString("id");
                String cloudName = rs.getString("name");
                TreeNode cloudNode = new TreeNode(ROOTID, cloudId + CLOUD_SUFFIX, cloudName, true);
                if (MenuPermInfoPlugin.isCloudInBlackList(cloudId)) {
                    cloudNode.setIcon("kdfont kdfont-yincang");
                }
                root.addChild(cloudNode);
            }
            return true;
        });
        TreeView tv = (TreeView)this.getControl(MENUTREE);
        tv.deleteAllNodes();
        tv.addNode(root);
        tv.expand(root.getId());
    }

    private void addAppNode(String cloudId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct app.fnumber as appnum,app.fid as id, app.fseq from t_meta_bizapp app ").append("join t_meta_menuruntime mr on app.fnumber=mr.fappid ").append("where app.fbizcloudid = ? ").append(" order by app.fseq");
        Object[] params = new Object[]{cloudId};
        DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, rs -> {
            while (rs.next()) {
                String appNum = rs.getString("appnum");
                String appId = rs.getString("id");
                String appName = AppHelper.getMetaAppInfo((String)appNum).getName().getLocaleValue();
                TreeNode appNode = new TreeNode(cloudId + CLOUD_SUFFIX, appId + APP_SUFFIX, appName, true);
                this.menuTreeView.addNode(appNode);
            }
            return true;
        });
    }

    private Object[] addFirstLevelMenuNode(String appId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct mr.fid as menu,mrl.fname as name,mr.fseq,mr.fformid as form from t_meta_menuruntime mr ").append("join t_meta_menuruntime_l mrl on mr.fid=mrl.fid where mrl.flocaleid = ? and mr.fparentid= ? order by mr.fseq");
        Object[] params = new Object[]{LANGSTR, appId};
        Map<String, String> idLongNumMap = this.getIdAndLongNumMap();
        return (Object[])DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, resultSet -> {
            ArrayList<TreeNode> menu1List = new ArrayList<TreeNode>(8);
            ArrayList<TreeNode> formList = new ArrayList<TreeNode>(8);
            while (resultSet.next()) {
                String longNum;
                TreeNode menuNode;
                String menuId = resultSet.getString("menu");
                String menuName = resultSet.getString("name");
                String formId = resultSet.getString("form");
                if (StringUtils.isEmpty((String)formId)) {
                    menuNode = new TreeNode(appId + APP_SUFFIX, menuId + MENU1_SUFFIX, menuName, true);
                    longNum = appId + APP_SUFFIX + "!" + menuId + MENU1_SUFFIX;
                    idLongNumMap.put(menuId, longNum);
                    menu1List.add(menuNode);
                } else {
                    menuNode = new TreeNode(appId + APP_SUFFIX, menuId + FORM_SUFFIX, menuName, false);
                    longNum = appId + APP_SUFFIX + "!" + menuId + FORM_SUFFIX;
                    idLongNumMap.put(menuId, longNum);
                    formList.add(menuNode);
                }
                this.menuTreeView.addNode(menuNode);
            }
            this.getView().getPageCache().put(PGCACHE_IDLONGNUMMAP, JSONObject.toJSONString((Object)idLongNumMap));
            return new Object[]{menu1List, formList};
        });
    }

    private Object[] addSecondLevelMenuNode(List<TreeNode> firstLevelMenu) {
        String idStr = this.shiftToStr(firstLevelMenu);
        StringBuilder sql = new StringBuilder();
        sql.append("select mr.fid as id,mr.fformid as form,mrl.fname as name,mr.fparentid as parentid from t_meta_menuruntime mr ").append("join t_meta_menuruntime_l mrl on mr.fid=mrl.fid ").append("where mrl.flocaleid = ? and mr.fparentid in ").append(idStr).append(" order by mr.fseq");
        Object[] params = new Object[]{LANGSTR};
        Map<String, String> idLongNumMap = this.getIdAndLongNumMap();
        return (Object[])DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, resultSet -> {
            ArrayList<TreeNode> menu2List = new ArrayList<TreeNode>(8);
            ArrayList<TreeNode> formList = new ArrayList<TreeNode>(8);
            while (resultSet.next()) {
                String longNum;
                TreeNode secondLevelMenuNode;
                String formId = resultSet.getString("form");
                String menuId = resultSet.getString("id");
                String menuName = resultSet.getString("name");
                String parentId = resultSet.getString("parentid");
                if (StringUtils.isEmpty((String)formId)) {
                    secondLevelMenuNode = new TreeNode(parentId + MENU1_SUFFIX, menuId + MENU2_SUFFIX, menuName, true);
                    longNum = (String)idLongNumMap.get(parentId) + "!" + menuId + MENU2_SUFFIX;
                    idLongNumMap.put(menuId, longNum);
                    menu2List.add(secondLevelMenuNode);
                } else {
                    secondLevelMenuNode = new TreeNode(parentId + MENU1_SUFFIX, menuId + FORM_SUFFIX, menuName, false);
                    longNum = (String)idLongNumMap.get(parentId) + "!" + menuId + FORM_SUFFIX;
                    idLongNumMap.put(menuId, longNum);
                    formList.add(secondLevelMenuNode);
                }
                this.menuTreeView.addNode(secondLevelMenuNode);
            }
            this.getView().getPageCache().put(PGCACHE_IDLONGNUMMAP, JSONObject.toJSONString((Object)idLongNumMap));
            return new Object[]{menu2List, formList};
        });
    }

    private void addFormNode(List<TreeNode> secondLevelMenu) {
        String idStr = this.shiftToStr(secondLevelMenu);
        StringBuilder sql = new StringBuilder();
        sql.append("select mrl.fname as name,mr.fparentid as parentid, mr.fid as id from t_meta_menuruntime mr ").append("join t_meta_menuruntime_l mrl on mr.fid=mrl.fid ").append("where mrl.flocaleid = ? and mr.fparentid in ").append(idStr).append(" order by mr.fseq");
        Object[] params = new Object[]{LANGSTR};
        Map<String, String> idLongNumMap = this.getIdAndLongNumMap();
        DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, resultSet -> {
            ArrayList<TreeNode> formList = new ArrayList<TreeNode>(8);
            while (resultSet.next()) {
                String menuId = resultSet.getString("id");
                String formName = resultSet.getString("name");
                String parentId = resultSet.getString("parentid");
                TreeNode formNode = new TreeNode(parentId + MENU2_SUFFIX, menuId + FORM_SUFFIX, formName, false);
                String longNum = (String)idLongNumMap.get(parentId) + "!" + menuId + FORM_SUFFIX;
                idLongNumMap.put(menuId, longNum);
                this.menuTreeView.addNode(formNode);
                formList.add(formNode);
            }
            this.getView().getPageCache().put(PGCACHE_IDLONGNUMMAP, JSONObject.toJSONString((Object)idLongNumMap));
            return formList;
        });
    }

    private String shiftToStr(List<TreeNode> list) {
        StringBuilder str = new StringBuilder("(");
        for (TreeNode treeNode : list) {
            String id = treeNode.getId().split("#")[0];
            str.append("'").append(id).append("',");
        }
        str.deleteCharAt(str.length() - 1).append(")");
        return str.toString();
    }

    private void searchMenuTreeByText(String text) {
        String cloudName;
        String cloudId;
        String algoKey = "MenuPermInfoPlugin";
        this.menuTreeView.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(ROOTID);
        root.setIsOpened(true);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"MenuPermInfoPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        this.menuTreeView.addNode(root);
        Object[] params = new Object[]{LANGSTR, LANGSTR};
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("select distinct bc.fid as cloudid,bc.fseq,bcl.fname as cloudname,app.fid as app,app.fnumber as appnum,mr.fid as menuid,mrl.fname as menuname ").append("from t_meta_bizcloud bc ").append("join t_meta_bizcloud_l bcl on bc.fid=bcl.fid ").append("join t_meta_bizapp app on bc.fid=app.fbizcloudid ").append("join t_meta_menuruntime mr on app.fnumber=mr.fappid ").append("join t_meta_menuruntime_l mrl on mr.fid=mrl.fid ").append("where mrl.flocaleid = ? and bcl.flocaleid=? ").append(" AND mrl.fname like '%").append(text).append("%' ").append("order by bc.fseq");
        HashMap<String, Set> cloudAppMap = new HashMap<String, Set>(8);
        HashMap<String, List> appNodeMap = new HashMap<String, List>(8);
        ArrayList<String> appExpandList = new ArrayList<String>(8);
        DataSet searchSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.meta, (String)sbSql.toString(), (Object[])params);
        Object object = null;
        try {
            for (Row row : searchSet) {
                cloudId = row.getString("cloudid");
                cloudName = row.getString("cloudname");
                String appNum = row.getString("appnum");
                String appId = row.getString("app");
                String nodeId = row.getString("menuid");
                String nodeName = row.getString("menuname");
                String appName = AppHelper.getMetaAppInfo((String)appNum).getName().getLocaleValue();
                appNodeMap.computeIfAbsent(appId + "-" + appName, k -> new ArrayList(8)).add(nodeId + "-" + nodeName);
                cloudAppMap.computeIfAbsent(cloudId + "-" + cloudName, k -> new HashSet(8)).add(appId + "-" + appName);
                appExpandList.add(appId + APP_SUFFIX);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (searchSet != null) {
                if (object != null) {
                    try {
                        searchSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    searchSet.close();
                }
            }
        }
        Map<String, String> idLongNumMap = this.getIdAndLongNumMap();
        for (Map.Entry entry : cloudAppMap.entrySet()) {
            String cloudInfo = (String)entry.getKey();
            cloudId = cloudInfo.split("-")[0];
            cloudName = cloudInfo.split("-")[1];
            TreeNode cloudNode = new TreeNode(ROOTID, cloudId + CLOUD_SUFFIX, cloudName, true);
            Set appInfoList = (Set)entry.getValue();
            for (String appInfo : appInfoList) {
                String appId = appInfo.split("-")[0];
                String appName = appInfo.split("-")[1];
                TreeNode appNode = new TreeNode(cloudId + CLOUD_SUFFIX, appId + APP_SUFFIX, appName, true);
                cloudNode.addChild(appNode);
                List nodeInfoList = (List)appNodeMap.get(appInfo);
                for (String nodeInfo : nodeInfoList) {
                    String nodeId = nodeInfo.split("-")[0];
                    String nodeName = nodeInfo.split("-")[1];
                    TreeNode node = new TreeNode(appId + APP_SUFFIX, nodeId + FORM_SUFFIX, nodeName);
                    idLongNumMap.put(nodeId, appId + APP_SUFFIX + "!" + nodeId + FORM_SUFFIX);
                    appNode.addChild(node);
                }
            }
            this.menuTreeView.addNode(cloudNode);
            this.menuTreeView.expand(cloudId + CLOUD_SUFFIX);
            this.getView().getPageCache().put(PGCACHE_IDLONGNUMMAP, JSONObject.toJSONString(idLongNumMap));
            for (String id : appExpandList) {
                this.menuTreeView.expand(id);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.menuTreeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.menuTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search4MenuTree = (Search)this.getControl("searchap");
        search4MenuTree.addEnterListener(see -> {
            String searchText = see.getText();
            if (StringUtils.isEmpty((String)searchText)) {
                this.menuTreeView.deleteAllNodes();
                this.initMenuTree();
                return;
            }
            this.searchMenuTreeByText(searchText);
        });
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        TreeView source = (TreeView)e.getSource();
        Object nodeId = e.getNodeId();
        if (nodeId == null || ROOTID.equals(nodeId)) {
            return;
        }
        String nodeStrId = e.getNodeId().toString();
        String parentId = nodeStrId.substring(0, nodeStrId.indexOf(35));
        if (nodeStrId.contains(CLOUD_SUFFIX)) {
            this.addAppNode(parentId);
            source.expand(nodeStrId);
        } else if (nodeStrId.contains(APP_SUFFIX)) {
            Object[] secondLevelMenuNode;
            String appId = nodeStrId.substring(0, nodeStrId.indexOf(35));
            Object[] firstLevelMenuNode = this.addFirstLevelMenuNode(appId);
            List menu1List = (List)firstLevelMenuNode[0];
            List<TreeNode> menu2List = new ArrayList(8);
            if (!menu1List.isEmpty() && !(menu2List = (List)(secondLevelMenuNode = this.addSecondLevelMenuNode(menu1List))[0]).isEmpty()) {
                this.addFormNode(menu2List);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.freshTheInfo();
        String nodeId = (String)evt.getNodeId();
        if (StringUtils.isEmpty((String)nodeId)) {
            nodeId = this.menuTreeView.getTreeState().getFocusNodeId();
        }
        if (nodeId.contains(CLOUD_SUFFIX)) {
            Map focusNode = this.menuTreeView.getTreeState().getFocusNode();
            String cloudName = (String)focusNode.get("text");
            if (MenuPermInfoPlugin.isCloudInBlackList(nodeId.split(CLOUD_SUFFIX)[0])) {
                this.getView().showErrorNotification("\u201c" + cloudName + "\u201d" + this.isInBlackList());
            } else {
                this.getView().showSuccessNotification("\u201c" + cloudName + "\u201d" + this.notInBlackList());
            }
        } else if (nodeId.contains(APP_SUFFIX)) {
            this.showAppInfo(nodeId.split(APP_SUFFIX)[0]);
        } else if (nodeId.contains(FORM_SUFFIX)) {
            String formId;
            String menuId = nodeId.split(FORM_SUFFIX)[0];
            Map<String, String> idLongNumMap = this.getIdAndLongNumMap();
            String longNum = idLongNumMap.get(menuId);
            if (StringUtils.isNotEmpty((String)longNum)) {
                this.showAppInfo(longNum.split(APP_SUFFIX)[0]);
            }
            if (StringUtils.isNotEmpty((String)(formId = this.showMenuInfo(menuId)))) {
                this.showFormInfo(formId);
            }
        }
    }

    private void showAppInfo(String appId) {
        String finalExtAppId;
        DynamicObject originApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)appId)});
        if (originApp != null) {
            String originAppNum = originApp.getString("number");
            this.getModel().setValue("originappnum", (Object)originAppNum);
        }
        if (StringUtils.isEmpty((String)(finalExtAppId = MenuPermInfoPlugin.findFinalExtAppId(appId, 10)))) {
            this.getView().showErrorNotification(this.appIdIsNull());
        }
        DynamicObject app = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"number,name,visible,deploystatus,alluserapp,usertype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finalExtAppId)});
        String appNum = app.getString("number");
        String appName = app.getString("name");
        boolean visible = app.getBoolean("visible");
        String deployStatus = app.getString("deploystatus");
        boolean allUserApp = app.getBoolean("alluserapp");
        String userType = app.getString("usertype");
        String[] split = userType.split(",");
        ArrayList<Long> userTypeList = new ArrayList<Long>(split.length);
        for (String s : split) {
            if (!StringUtils.isNotEmpty((String)s)) continue;
            userTypeList.add(Long.parseLong(s));
        }
        this.getModel().setValue("appnum", (Object)appNum);
        this.getModel().setValue("appname", (Object)appName);
        if (visible) {
            this.getModel().setValue("appvisible", (Object)this.yes());
        } else {
            this.getModel().setValue("appvisible", (Object)this.no());
        }
        if ("1".equals(deployStatus)) {
            this.getModel().setValue("appdeploystatus", (Object)this.no());
        } else if ("2".equals(deployStatus)) {
            this.getModel().setValue("appdeploystatus", (Object)this.yes());
        }
        if (allUserApp) {
            this.getModel().setValue("alluserapp", (Object)this.yes());
        } else {
            this.getModel().setValue("alluserapp", (Object)this.no());
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_usertype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", userTypeList)});
        StringBuilder userTypeName = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String name = dynamicObject.getString("name");
            userTypeName.append(name).append(",");
        }
        userTypeName.deleteCharAt(userTypeName.length() - 1);
        this.getModel().setValue("usertype", (Object)userTypeName.toString());
        if (MenuPermInfoPlugin.isAppInBlackList(finalExtAppId)) {
            this.getModel().setValue("appinblacklist", (Object)this.yes());
        } else {
            this.getModel().setValue("appinblacklist", (Object)this.no());
        }
    }

    private String showMenuInfo(String menuId) {
        StringBuilder sql = new StringBuilder("select mrt.fformid as formid,mrt.fparamtype as type,mrt.fparams as params,mrt.fpermission as perm,mrtl.fname as name ");
        sql.append("from t_meta_menuruntime mrt ").append("join t_meta_menuruntime_l mrtl on mrt.fid=mrtl.fid ").append("where mrt.fid = ? ").append(" and mrtl.flocaleid = ?");
        Object[] sqlParams = new Object[]{menuId, LANGSTR};
        Map result = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])sqlParams, r -> {
            HashMap<String, String> map = new HashMap<String, String>(8);
            if (r.next()) {
                map.put("type", r.getString("type"));
                map.put("formId", r.getString("formid"));
                map.put("params", r.getString("params"));
                map.put("perm", r.getString("perm"));
                map.put("name", r.getString("name"));
            }
            return map;
        });
        if (result.isEmpty()) {
            return null;
        }
        this.getModel().setValue("menuname", result.get("name"));
        String permItemId = (String)result.get("perm");
        if (StringUtils.isNotEmpty((String)permItemId)) {
            DynamicObject permItemObj = QueryServiceHelper.queryOne((String)"perm_permitem", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)permItemId)});
            this.getModel().setValue("menupermitem", (Object)permItemObj.getString("name"));
        }
        this.getModel().setValue("menuparamtype", (Object)MenuParamTypeEnum.findNameByNumber((String)result.get("type")));
        Map params = (Map)JSONObject.parseObject((String)((String)result.get("params")), Map.class);
        if (params != null && !params.isEmpty()) {
            StringBuilder paramsBuilder = new StringBuilder();
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                if ("caption".equals(key)) continue;
                String value = String.valueOf(entry.getValue());
                paramsBuilder.append(" ").append(key).append(" = ").append(value).append(",");
            }
            if (paramsBuilder.length() != 0) {
                paramsBuilder.deleteCharAt(paramsBuilder.length() - 1);
                this.getModel().setValue("menuparams", (Object)paramsBuilder.toString());
            }
        }
        return (String)result.get("formId");
    }

    private void showFormInfo(String formNum) {
        Set permissionItems;
        String finalExtNum = MenuPermInfoPlugin.findFinalExtFormNum(formNum, 10);
        if (StringUtils.isEmpty((String)finalExtNum)) {
            this.getView().showErrorNotification(this.formNumIsNull());
        }
        this.getModel().setValue("originentnum", (Object)formNum);
        this.getModel().setValue("originentfrom", (Object)FormMetadataCache.getFormAppId((String)formNum));
        this.getModel().setValue("formnum", (Object)finalExtNum);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_entity_blacklist", (String)"entityid", (QFilter[])new QFilter[]{new QFilter("entityid", "=", (Object)formNum)});
        if (dynamicObject != null) {
            this.getModel().setValue("entityinblacklist", (Object)this.yes());
        } else {
            this.getModel().setValue("entityinblacklist", (Object)this.no());
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formNum);
        this.getModel().setValue("formname", (Object)dataEntityType.getDisplayName());
        String mainOrgKey = dataEntityType.getMainOrg();
        if (StringUtils.isNotEmpty((String)mainOrgKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mainorgnum", "mainorgfunc", "mainorgviewscheme"});
            DynamicProperty mainOrg = dataEntityType.getProperty(mainOrgKey);
            this.getModel().setValue("mainorgfield", (Object)mainOrg.getDisplayName());
            this.getModel().setValue("mainorgnum", (Object)mainOrg.getName());
            if (mainOrg instanceof MainOrgProp) {
                String orgFunc = ((MainOrgProp)mainOrg).getOrgFunc();
                if (StringUtils.isEmpty((String)orgFunc)) {
                    orgFunc = "15";
                }
                DynamicObject orgFuncObj = QueryServiceHelper.queryOne((String)"bos_org_biz", (String)"fname", (QFilter[])new QFilter[]{new QFilter("fnumber", "=", (Object)orgFunc)});
                this.getModel().setValue("mainorgfunc", (Object)orgFuncObj.getString("fname"));
                OrgViewSchemeProp orgViewScheme = ((MainOrgProp)mainOrg).getOrgViewScheme();
                if (orgViewScheme != null) {
                    this.getModel().setValue("mainorgviewscheme", (Object)orgViewScheme.getName());
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"mainorgfunc", "mainorgviewscheme"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mainorgnum", "mainorgfunc", "mainorgviewscheme"});
        }
        PermissionControlType permissionControlType = FormHelper.getPermissionControlType((String)formNum);
        String dimension = permissionControlType.getDimension();
        DynamicObject ctrlTypeObj = QueryServiceHelper.queryOne((String)"perm_ctrltype", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dimension)});
        this.getModel().setValue("dimenson", (Object)ctrlTypeObj.getString("name"));
        if (permissionControlType.isControlFunction()) {
            this.getModel().setValue("controlperm", (Object)this.yes());
        } else {
            this.getModel().setValue("controlperm", (Object)this.no());
        }
        List publishApps = permissionControlType.getPublishApps();
        if (!CollectionUtils.isEmpty((Collection)publishApps)) {
            StringBuilder appNames = new StringBuilder();
            for (String publishAppId : publishApps) {
                String finalExtAppId = MenuPermInfoPlugin.findFinalExtAppId(publishAppId, 10);
                DynamicObject app = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finalExtAppId)});
                String appName = app.getString("name");
                appNames.append(appName).append("\uff0c");
            }
            appNames.deleteCharAt(appNames.length() - 1);
            this.getModel().setValue("publishapps", (Object)appNames.toString());
        }
        if (!CollectionUtils.isEmpty((Collection)(permissionItems = EntityMetadataCache.getPermissionItems((String)formNum)))) {
            DynamicObjectCollection permItemsCollection = QueryServiceHelper.query((String)"perm_permitem", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)permissionItems)});
            StringBuilder permItemNames = new StringBuilder();
            for (DynamicObject permItem : permItemsCollection) {
                String name = permItem.getString("name");
                String number = permItem.getString("number");
                permItemNames.append(name).append("(").append(number).append("),");
            }
            permItemNames.deleteCharAt(permItemNames.length() - 1);
            this.getModel().setValue("permitems", (Object)permItemNames.toString());
        }
        if (permissionControlType.isAnonymousUserControl()) {
            this.getModel().setValue("anonymoususercontrol", (Object)this.yes());
        } else {
            this.getModel().setValue("anonymoususercontrol", (Object)this.no());
        }
        String dataDimField = permissionControlType.getDataDimensionField();
        if (StringUtils.isNotEmpty((String)dataDimField)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"datadimfieldnum", "datadimfieldorgfunc", "datadimfieldorgviewscheme"});
            DynamicProperty dataDimProperty = dataEntityType.getProperty(dataDimField);
            if (dataDimProperty != null) {
                this.getModel().setValue("datadimfield", (Object)dataDimProperty.getDisplayName());
                this.getModel().setValue("datadimfieldnum", (Object)dataDimProperty.getName());
            }
            if (dataDimProperty instanceof OrgProp) {
                String orgFunc = ((OrgProp)dataDimProperty).getOrgFunc();
                if (StringUtils.isEmpty((String)orgFunc)) {
                    orgFunc = "15";
                }
                DynamicObject orgFuncObj = QueryServiceHelper.queryOne((String)"bos_org_biz", (String)"fname", (QFilter[])new QFilter[]{new QFilter("fnumber", "=", (Object)orgFunc)});
                this.getModel().setValue("datadimfieldorgfunc", (Object)orgFuncObj.getString("fname"));
                OrgViewSchemeProp orgViewScheme = ((OrgProp)dataDimProperty).getOrgViewScheme();
                if (orgViewScheme != null) {
                    this.getModel().setValue("datadimfieldorgviewscheme", (Object)orgViewScheme.getName());
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"datadimfieldorgfunc", "datadimfieldorgviewscheme"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"datadimfieldnum", "datadimfieldorgfunc", "datadimfieldorgviewscheme"});
        }
        String dataAssistDimField = permissionControlType.getDataAssistDimensionField();
        if (StringUtils.isNotEmpty((String)dataAssistDimField)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"dataassistdimfieldnum", "dataassistdimfieldorgfunc", "dataassistdimfieldorgvs"});
            DynamicProperty dataAssistDimProperty = dataEntityType.getProperty(dataAssistDimField);
            if (dataAssistDimProperty != null) {
                this.getModel().setValue("dataassistdimfield", (Object)dataAssistDimProperty.getDisplayName());
                this.getModel().setValue("dataassistdimfieldnum", (Object)dataAssistDimProperty.getName());
            }
            if (dataAssistDimProperty instanceof OrgProp) {
                String orgFunc = ((OrgProp)dataAssistDimProperty).getOrgFunc();
                if (StringUtils.isEmpty((String)orgFunc)) {
                    orgFunc = "15";
                }
                DynamicObject orgFuncObj = QueryServiceHelper.queryOne((String)"bos_org_biz", (String)"fname", (QFilter[])new QFilter[]{new QFilter("fnumber", "=", (Object)orgFunc)});
                this.getModel().setValue("dataassistdimfieldorgfunc", (Object)orgFuncObj.getString("fname"));
                OrgViewSchemeProp orgViewScheme = ((OrgProp)dataAssistDimProperty).getOrgViewScheme();
                if (orgViewScheme != null) {
                    this.getModel().setValue("dataassistdimfieldorgvs", (Object)orgViewScheme.getName());
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"dataassistdimfieldorgfunc", "dataassistdimfieldorgvs"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataassistdimfieldnum", "dataassistdimfieldorgfunc", "dataassistdimfieldorgvs"});
        }
    }

    public static boolean isCloudInBlackList(String cloudId) {
        String cloudIdsBlackList = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (!StringUtils.isEmpty((String)cloudIdsBlackList) && cloudIdsBlackList.contains(cloudId)) {
            return true;
        }
        List<String> cloudIdsFromStdBlackList = PermFormCommonUtil.getCloudIdsFromStdBlackList();
        return cloudIdsFromStdBlackList != null && cloudIdsFromStdBlackList.contains(cloudId);
    }

    public static boolean isAppInBlackList(String appId) {
        String appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist();
        if (!StringUtils.isEmpty((String)appIdBlackList) && appIdBlackList.contains(appId)) {
            return true;
        }
        List<String> appIdsFromStdBlackList = PermFormCommonUtil.getAppIdsFromStdBlackList();
        return appIdsFromStdBlackList != null && appIdsFromStdBlackList.contains(appId);
    }

    private static String findFinalExtAppId(String appId, int recursiveCount) {
        if (recursiveCount == 0) {
            return "";
        }
        DynamicObject extApp = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)appId)});
        if (extApp == null) {
            return appId;
        }
        appId = extApp.getString("id");
        return MenuPermInfoPlugin.findFinalExtAppId(appId, --recursiveCount);
    }

    private static String findFinalExtFormNum(String formNum, int recursiveCount) {
        if (recursiveCount == 0) {
            return "";
        }
        DynamicObject extEnt = QueryServiceHelper.queryOne((String)"bos_entitymeta", (String)"number", (QFilter[])new QFilter[]{new QFilter("parentid.number", "=", (Object)formNum).and(new QFilter("enabled", "=", (Object)Boolean.TRUE))});
        if (extEnt == null) {
            return formNum;
        }
        formNum = extEnt.getString("number");
        return MenuPermInfoPlugin.findFinalExtFormNum(formNum, --recursiveCount);
    }

    public void freshTheInfo() {
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        Map allFields = dataEntityType.getAllFields();
        for (String key : allFields.keySet()) {
            this.getModel().setValue(key, null);
        }
    }

    private Map<String, String> getIdAndLongNumMap() {
        IPageCache pageCache = this.getView().getPageCache();
        String cache = pageCache.get(PGCACHE_IDLONGNUMMAP);
        Map idLongNumMap = StringUtils.isEmpty((String)cache) ? new HashMap(8) : (Map)JSONObject.parseObject((String)cache, Map.class);
        return idLongNumMap;
    }

    private static enum MenuParamTypeEnum {
        FORMSHOWPARAMETER("FormShowParameter", new MultiLangEnumBridge("\u52a8\u6001\u8868\u5355", "MenuPermInfoPlugin_7", "bos-permission-formplugin").loadKDString()),
        BILLSHOWPARAMETER("BillShowParameter", new MultiLangEnumBridge("\u5355\u636e", "MenuPermInfoPlugin_8", "bos-permission-formplugin").loadKDString()),
        BASESHOWPARAMETER("BaseShowParameter", new MultiLangEnumBridge("\u57fa\u7840\u8d44\u6599", "MenuPermInfoPlugin_9", "bos-permission-formplugin").loadKDString()),
        LISTSHOWPARAMETER("ListShowParameter", new MultiLangEnumBridge("\u5217\u8868", "MenuPermInfoPlugin_10", "bos-permission-formplugin").loadKDString()),
        REPORTSHOWPARAMETER("ReportShowParameter", new MultiLangEnumBridge("\u62a5\u8868", "MenuPermInfoPlugin_11", "bos-permission-formplugin").loadKDString()),
        PARAMETERSHOWPARAMETER("ParameterShowParameter", new MultiLangEnumBridge("\u53c2\u6570", "MenuPermInfoPlugin_12", "bos-permission-formplugin").loadKDString());

        private final String number;
        private final String name;

        private MenuParamTypeEnum(String number, String name) {
            this.number = number;
            this.name = name;
        }

        public static String findNameByNumber(String number) {
            if (StringUtils.isEmpty((String)number)) {
                return null;
            }
            for (MenuParamTypeEnum value : MenuParamTypeEnum.values()) {
                if (!number.equals(value.number)) continue;
                return value.name;
            }
            return null;
        }
    }
}

