/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class MultiAdminCtrlScopePlugin
extends AbstractFormPlugin {
    Log logger = LogFactory.getLog(MultiAdminCtrlScopePlugin.class);
    private static final String FORMSHOWPARAMETER_ADMINSCHEMEID = "formShowParameter_adminSchemeId";
    private static final String MAIN_ENTITY = "perm_multiadmin";
    private static final String ADMINSCHEMEID = "adminschemeid";
    private static final String ADMINTYPE = "admintype";
    private static final String UNLOCKSCOPE = "unlockscope";
    private static final String RESETPSWSCOPE = "resetpswscope";
    private static final String ENABLEPSWSTRATEGY = "enablepswstrategy";
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTN_OK = "btnok";

    public void afterCreateNewData(EventObject e) {
        Long adminSchemeId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_ADMINSCHEMEID));
        if (adminSchemeId == 0L) {
            return;
        }
        DynamicObject adminScheme = BusinessDataServiceHelper.loadSingle((Object)adminSchemeId, (String)"perm_adminscheme");
        DynamicObjectCollection adminTypeEntry = adminScheme.getDynamicObjectCollection(ENTRYENTITY);
        if (adminTypeEntry == null) {
            return;
        }
        for (DynamicObject entryRow : adminTypeEntry) {
            DynamicObject dynamicObject;
            DynamicObjectCollection dynamicCollection;
            DynamicObject multiAdminCtrlScope;
            int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            DynamicObject adminType = entryRow.getDynamicObject(ADMINTYPE);
            Long adminTypeId = (Long)adminType.get("id");
            this.getModel().setValue(ADMINTYPE, (Object)adminTypeId, newEntryRow);
            Object onlyOneAdmin = this.getView().getFormShowParameter().getCustomParam("formShowParameter_onlyOneAdmin");
            if (!ObjectUtils.isEmpty((Object)onlyOneAdmin)) {
                MulBasedataEdit unlockScope = (MulBasedataEdit)this.getControl(UNLOCKSCOPE);
                unlockScope.setEnable(null, false, newEntryRow);
                MulBasedataEdit resetPswScope = (MulBasedataEdit)this.getControl(RESETPSWSCOPE);
                resetPswScope.setEnable(null, false, newEntryRow);
            }
            if ((multiAdminCtrlScope = QueryServiceHelper.queryOne((String)MAIN_ENTITY, (String)String.join((CharSequence)",", UNLOCKSCOPE, RESETPSWSCOPE, ENABLEPSWSTRATEGY), (QFilter[])new QFilter[]{new QFilter(ADMINSCHEMEID, "=", (Object)adminSchemeId).and(ADMINTYPE, "=", (Object)adminTypeId)})) == null) continue;
            String unlockScope = multiAdminCtrlScope.getString(UNLOCKSCOPE);
            String resetPswScope = multiAdminCtrlScope.getString(RESETPSWSCOPE);
            boolean enablePswStrategy = multiAdminCtrlScope.getBoolean(ENABLEPSWSTRATEGY);
            if (StringUtils.isNotEmpty((String)unlockScope)) {
                String[] unlockScopeIdArray;
                dynamicCollection = new DynamicObjectCollection();
                for (String unlockScopeId : unlockScopeIdArray = unlockScope.split(",")) {
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)unlockScopeId, (String)"perm_admintype");
                    dynamicCollection.add((Object)dynamicObject);
                }
                this.getModel().setValue(UNLOCKSCOPE, (Object)dynamicCollection, newEntryRow);
            }
            if (StringUtils.isNotEmpty((String)resetPswScope)) {
                String[] resetPswScopeIdArray;
                dynamicCollection = new DynamicObjectCollection();
                for (String resetPswScopeId : resetPswScopeIdArray = resetPswScope.split(",")) {
                    dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resetPswScopeId, (String)"perm_admintype");
                    dynamicCollection.add((Object)dynamicObject);
                }
                this.getModel().setValue(RESETPSWSCOPE, (Object)dynamicCollection, newEntryRow);
            }
            this.getModel().setValue(ENABLEPSWSTRATEGY, (Object)enablePswStrategy, newEntryRow);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        this.addBeforeF7SelectListener((MulBasedataEdit)this.getControl(UNLOCKSCOPE));
        this.addBeforeF7SelectListener((MulBasedataEdit)this.getControl(RESETPSWSCOPE));
    }

    private void addBeforeF7SelectListener(MulBasedataEdit mulBasedataEdit) {
        mulBasedataEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int row = beforeF7SelectEvent.getRow();
            EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
            DynamicObject dataEntity = eg.getEntryData().getDataEntitys()[row];
            DynamicObject adminType = (DynamicObject)dataEntity.get(ADMINTYPE);
            Long adminSchemeId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_ADMINSCHEMEID));
            if (adminSchemeId == 0L) {
                return;
            }
            DynamicObject adminScheme = BusinessDataServiceHelper.loadSingle((Object)adminSchemeId, (String)"perm_adminscheme");
            DynamicObjectCollection adminTypeEntry = adminScheme.getDynamicObjectCollection(ENTRYENTITY);
            if (adminTypeEntry == null) {
                return;
            }
            ArrayList<Long> adminTypeIds = new ArrayList<Long>(8);
            for (DynamicObject entryRow : adminTypeEntry) {
                DynamicObject adminTypeObj = entryRow.getDynamicObject(ADMINTYPE);
                Long adminTypeId = (Long)adminTypeObj.get("id");
                if (adminTypeId.equals(adminType.getPkValue())) continue;
                adminTypeIds.add(adminTypeId);
            }
            if (!adminTypeIds.isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", adminTypeIds);
                beforeF7SelectEvent.addCustomQFilter(qFilter);
            }
        });
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && (key = (btn = (Button)source).getKey()).equals(BTN_OK)) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (!dataChanged) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MultiAdminCtrlScopePlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    this.getView().sendFormAction(this.getView().getParentView());
                }
                this.getView().close();
                return;
            }
            Long adminSchemeId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_ADMINSCHEMEID));
            if (adminSchemeId == 0L) {
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
            if (!dynamicObjectCollection.isEmpty()) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        IFormView parentView;
                        ArrayList<Object[]> forUpdateList = new ArrayList<Object[]>(3);
                        ArrayList<Object[]> forInsertList = new ArrayList<Object[]>(3);
                        for (DynamicObject dynamicObject : dynamicObjectCollection) {
                            DynamicObject adminType = dynamicObject.getDynamicObject(ADMINTYPE);
                            long adminTypeId = adminType.getLong("id");
                            if (adminTypeId == 0L) continue;
                            String enablePswStrategy = dynamicObject.getBoolean(ENABLEPSWSTRATEGY) ? "1" : "0";
                            String unlockScope = this.dynamicObjColToIdStr(dynamicObject.get(UNLOCKSCOPE));
                            String resetPswScope = this.dynamicObjColToIdStr(dynamicObject.get(RESETPSWSCOPE));
                            DynamicObject oldDataObj = BusinessDataServiceHelper.loadSingle((String)MAIN_ENTITY, (String)"id", (QFilter[])new QFilter[]{new QFilter(ADMINSCHEMEID, "=", (Object)adminSchemeId).and(ADMINTYPE, "=", (Object)adminTypeId)});
                            if (oldDataObj != null) {
                                long id = oldDataObj.getLong("id");
                                forUpdateList.add(new Object[]{enablePswStrategy, unlockScope, resetPswScope, id});
                                continue;
                            }
                            long genLongId = DB.genLongId((String)"t_perm_multiadmin");
                            forInsertList.add(new Object[]{genLongId, adminSchemeId, enablePswStrategy, unlockScope, resetPswScope, adminTypeId});
                        }
                        if (!forUpdateList.isEmpty()) {
                            String updateSql = "update t_perm_multiadmin set fenablepswstrategy = ?,funlockscopeid = ?,fresetpswscopeid = ? where fid = ?";
                            DB.executeBatch((DBRoute)DBRoute.permission, (String)updateSql, forUpdateList);
                            this.logger.debug("MultiAdminCtrlScopePlugin_updateParam:" + ((Object)forUpdateList).toString());
                        }
                        if (!forInsertList.isEmpty()) {
                            String insertSql = "insert into t_perm_multiadmin (fid,fadminschemeid,fenablepswstrategy,funlockscopeid,fresetpswscopeid,fadmintypeid)  values (?,?,?,?,?,?) ";
                            DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, forInsertList);
                            this.logger.debug("MultiAdminCtrlScopePlugin_insertParam:" + ((Object)forInsertList).toString());
                        }
                        if ((parentView = this.getView().getParentView()) != null) {
                            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MultiAdminCtrlScopePlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                            this.getView().sendFormAction(this.getView().getParentView());
                        }
                        this.getView().close();
                    }
                    catch (Exception e) {
                        h.markRollback();
                        this.getView().showErrorNotification(ResManager.loadKDString((String)("\u4fdd\u5b58\u5931\u8d25\u3002" + e.getMessage()), (String)"MultiAdminCtrlScopePlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                        this.logger.error((Throwable)e);
                    }
                }
                CacheMrg.clearDataEntityCache((String)MAIN_ENTITY);
            }
        }
    }

    private String dynamicObjColToIdStr(Object dynamicObjCol) {
        if (dynamicObjCol instanceof DynamicObjectCollection) {
            StringBuilder idStr = new StringBuilder();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)dynamicObjCol) {
                idStr.append(dynamicObject.get("fbasedataid_id")).append(",");
            }
            if (idStr.length() != 0) {
                idStr.deleteCharAt(idStr.length() - 1);
            }
            return idStr.toString();
        }
        return "";
    }
}

