/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.UpgradeAdminUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class OldAdminEnablePlugin
extends AbstractBasePlugIn {
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    public static final String OLDADMIN_ENABLE_ENTTYPE = "perm_oldadminenable";
    private static final String PROP_ENABLE_ADMIN = "enable_admin";
    private static final String BTN_UPDATE = "btn_update";
    private static final String USE_OLD = "user_old";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_UPDATE});
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (BTN_UPDATE.equals(callBackId) && result.equals((Object)MessageBoxResult.Yes)) {
            StringBuilder processInfo = new StringBuilder();
            boolean upgrade = false;
            try {
                upgrade = UpgradeAdminUtil.upgrade((int)0, (StringBuilder)processInfo, (Integer)2);
                this.showUpdateResult(upgrade, processInfo);
            }
            catch (Exception e) {
                this.showUpdateResult(upgrade, processInfo.append(e.getMessage()));
            }
        } else if (USE_OLD.equals(callBackId) && result.equals((Object)MessageBoxResult.Yes)) {
            this.updateEnableDbStatus(Boolean.TRUE);
            this.clearCache();
            String oldOpDescription = ResManager.loadKDString((String)"\u542f\u7528\u201c\u65e7\u7248\u7ba1\u7406\u5458\u201d\u3002", (String)"OldAdminEnablePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showSuccessNotification(oldOpDescription, Integer.valueOf(20000));
            String curLogAppId = AppHelper.getCurAppId((String)OLDADMIN_ENABLE_ENTTYPE, (String)this.getView().getFormShowParameter().getAppId());
            MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "OldAdminEnablePlugin_1", SYSTEM_TYPE);
            MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u542f\u7528\u201c\u65e7\u7248\u7ba1\u7406\u5458\u201d\u3002", "OldAdminEnablePlugin_0", SYSTEM_TYPE);
            String[] opDescParam = null;
            PermCommonUtil.addLog(null, null, (String)OLDADMIN_ENABLE_ENTTYPE, null, (String)"1", (String)USE_OLD, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
        } else if (USE_OLD.equals(callBackId) && result.equals((Object)MessageBoxResult.Cancel)) {
            this.getModel().beginInit();
            this.getModel().setValue(PROP_ENABLE_ADMIN, (Object)Boolean.FALSE);
            this.getModel().endInit();
            this.getView().updateView(PROP_ENABLE_ADMIN);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_UPDATE.equals(key)) {
            Boolean enableOldAdmin = (Boolean)this.getView().getModel().getValue(PROP_ENABLE_ADMIN);
            if (!enableOldAdmin.booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u542f\u7528\u65b0\u7ba1\u7406\u5458\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5347\u7ea7\u3002\u5982\u9700\u5347\u7ea7\uff0c\u8bf7\u5148\u5207\u6362\u81f3\u65e7\u7ba1\u7406\u5458\u3002", (String)"OldAdminEnablePlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5373\u5c06\u628a\u201c\u65e7\u7ba1\u7406\u5458\u201d\u8f6c\u5316\u4e3a\u65b0\u201c\u7ba1\u7406\u5458\u5206\u7ec4\u201d\uff0c\u60a8\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"OldAdminEnablePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_UPDATE));
        }
    }

    private void showUpdateResult(boolean upgrade, StringBuilder processInfo) {
        String processInfoStr = processInfo.toString();
        if (upgrade) {
            if (StringUtils.isNotEmpty((String)processInfoStr)) {
                processInfoStr = " : " + processInfoStr;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"OldAdminEnablePlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]) + processInfoStr, Integer.valueOf(20000));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25\u3002", (String)"OldAdminEnablePlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]) + processInfoStr);
        }
        this.updateChkBox_enableAdmin(upgrade);
    }

    private void updateChkBox_enableAdmin(boolean upgradeStatus) {
        if (upgradeStatus) {
            this.getModel().beginInit();
            this.getModel().setValue(PROP_ENABLE_ADMIN, (Object)(!upgradeStatus ? 1 : 0));
            this.getModel().endInit();
            this.getView().updateView(PROP_ENABLE_ADMIN);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
        String skip = this.getPageCache().get("skip");
        if (StringUtils.isNotEmpty((String)skip)) {
            this.getPageCache().remove("skip");
            return;
        }
        String saveOpName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OldAdminEnablePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        if (newValue.booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u542f\u7528\u65e7\u7ba1\u7406\u5458\uff0c\u5728\u65b0\u7248\u7ba1\u7406\u5458\u6a21\u5f0f\u4e2d\u6570\u636e\u7684\u53d8\u52a8\u65e0\u6cd5\u540c\u6b65\u5230\u65e7\u7248\u7ba1\u7406\u5458\u6a21\u5f0f\u4e2d\uff0c\u60a8\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"OldAdminEnablePlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(USE_OLD));
        } else {
            String sql = " SELECT count(*) num  FROM t_perm_admingroup ";
            boolean canUserNewAdmin = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                public Boolean handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        long num = rs.getLong("num");
                        if (num <= 0L) continue;
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
            if (canUserNewAdmin) {
                this.updateEnableDbStatus(newValue);
                this.clearCache();
                String oldOpDescription = ResManager.loadKDString((String)"\u7981\u7528\u201c\u65e7\u7248\u7ba1\u7406\u5458\u201d\uff0c\u542f\u7528\u201c\u65b0\u7248\u7ba1\u7406\u5458\u201d\uff0c\u6210\u529f\u3002", (String)"OldAdminEnablePlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showSuccessNotification(oldOpDescription, Integer.valueOf(20000));
                String curLogAppId = AppHelper.getCurAppId((String)OLDADMIN_ENABLE_ENTTYPE, (String)this.getView().getFormShowParameter().getAppId());
                MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "OldAdminEnablePlugin_1", SYSTEM_TYPE);
                MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u7981\u7528\u201c\u65e7\u7248\u7ba1\u7406\u5458\u201d\uff0c\u542f\u7528\u201c\u65b0\u7248\u7ba1\u7406\u5458\u201d\uff0c\u6210\u529f\u3002", "OldAdminEnablePlugin_7", SYSTEM_TYPE);
                String[] opDescParam = null;
                PermCommonUtil.addLog(null, null, (String)OLDADMIN_ENABLE_ENTTYPE, null, (String)"1", (String)"enablenewadmin", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u201c\u65b0\u7248\u7ba1\u7406\u5458\u201d\u5c1a\u672a\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"OldAdminEnablePlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.getPageCache().put("skip", "true");
                this.getModel().beginInit();
                this.getModel().setValue(PROP_ENABLE_ADMIN, (Object)Boolean.TRUE);
                this.getModel().endInit();
                this.getView().updateView(PROP_ENABLE_ADMIN);
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void updateEnableDbStatus(Boolean newValue) {
        Map enableMap = UpgradeAdminUtil.loadFromDB();
        StringBuilder sql = new StringBuilder("update t_perm_oldadminenable set fmodifytime = now(), ");
        sql.append("fmodifierid=").append(Long.valueOf(RequestContext.get().getUserId())).append(", ");
        sql.append("fenable = ").append(newValue != false ? "'1'" : "'0'");
        sql.append(" where fid= ").append(enableMap.get("fid"));
        DB.execute((DBRoute)DBRoute.basedata, (String)sql.toString());
    }

    private void clearCache() {
        CacheMrg.clearAllCache();
        CacheMrg.clearHasEnableOldAdmin();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map enableMap = UpgradeAdminUtil.loadFromDB();
        String fenable = (String)enableMap.get("fenable");
        boolean enableOldDataRule = !StringUtils.isEmpty((String)fenable) && !"0".equals(fenable);
        this.getModel().beginInit();
        this.getModel().setValue(PROP_ENABLE_ADMIN, (Object)enableOldDataRule);
        this.getModel().endInit();
        this.getView().updateView();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String showFormSpecial = (String)e.getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)e.getFormShowParameter().getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5168\u529f\u80fd\u7528\u6237\uff0c\u4e5f\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd", (String)"OldAdminEnablePlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
    }
}

