/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.util.StringUtils;

public class PermCtrltypeListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(PermCtrltypeListPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate;
        String operationKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && Objects.equals("delete", operationKey = (formOperate = (FormOperate)args.getSource()).getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Object[] selectedIdArr = listSelectedData.getPrimaryKeyValues();
            if (null == selectedIdArr || 0 == selectedIdArr.length) {
                args.setCancel(true);
                return;
            }
            Set selectedIdSet = Stream.of(selectedIdArr).map(x -> (String)x).collect(Collectors.toSet());
            PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq();
            permCtrlTypeReq.setIdSet(selectedIdSet);
            Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((PermCtrlTypeReq)permCtrlTypeReq);
            if (null == permCtrlTypeMap || permCtrlTypeMap.isEmpty()) {
                args.setCancel(true);
                return;
            }
            HashSet<String> systemIdSet = new HashSet<String>(8);
            HashSet<String> systemNumberSet = new HashSet<String>(8);
            HashMap<String, String> notSystemIdObjectMap = new HashMap<String, String>(8);
            for (Map.Entry entry : permCtrlTypeMap.entrySet()) {
                String string = (String)entry.getKey();
                PermCtrlType value = (PermCtrlType)entry.getValue();
                if (null == value) continue;
                String system = value.getSystem();
                if (StringUtils.isNotEmpty((String)system) && Objects.equals("1", system)) {
                    systemIdSet.add(string);
                    systemNumberSet.add(value.getNumber());
                    continue;
                }
                notSystemIdObjectMap.put(string, value.getBizobjectid());
            }
            if (null != systemIdSet && !systemIdSet.isEmpty()) {
                StringBuilder numberSetStr = StrUtil.wrapNumericTips(systemNumberSet, (int)3);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u7684\u6743\u9650\u63a7\u5236\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u7f16\u7801\uff1a%s\u3002", (String)"PermCtrltypeListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[]{numberSetStr}));
                listSelectedData.removeIf(x -> systemIdSet.contains(x.getPrimaryKeyValue()));
            }
            HashSet allNumberSet = new HashSet(8);
            for (Map.Entry entry : notSystemIdObjectMap.entrySet()) {
                String id = (String)entry.getKey();
                String entNum = (String)entry.getValue();
                String compareTypeStr = "perm_myhasright_" + entNum;
                Set numberSet = DrHelper.getUsedDrNumFirst4SetByCompareType((String)compareTypeStr);
                if (null == numberSet || numberSet.isEmpty()) continue;
                allNumberSet.addAll(numberSet);
                listSelectedData.removeIf(x -> Objects.equals(id, x.getPrimaryKeyValue()));
            }
            if (null != allNumberSet && !allNumberSet.isEmpty()) {
                StringBuilder stringBuilder = StrUtil.wrapNumericTips(allNumberSet, (int)3);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d\u88ab\u201c\u6570\u636e\u89c4\u5219\u65b9\u6848\u201d\u6240\u5f15\u7528\u3002\u6570\u636e\u89c4\u5219\u65b9\u6848\u7684\u7f16\u7801\uff1a%s\u3002", (String)"PermCtrltypeListPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[]{stringBuilder}));
            }
            if (null == listSelectedData || listSelectedData.isEmpty()) {
                args.setCancel(true);
                return;
            }
        }
    }
}

