/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.DrHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class PermCtrltypePlugin
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(PermCtrltypePlugin.class);
    private static final String PROP_MYHASRIGHTDR = "myhasrightdr";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"system"});
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (null != pkValue) {
            PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq();
            permCtrlTypeReq.setIdSet((Set)Sets.newHashSet((Object[])new String[]{String.valueOf(pkValue)}));
            Map permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap((PermCtrlTypeReq)permCtrlTypeReq);
            if (null == permCtrlTypeMap || permCtrlTypeMap.isEmpty()) {
                return;
            }
            PermCtrlType permCtrlType = (PermCtrlType)permCtrlTypeMap.get(String.valueOf(pkValue));
            if (null == permCtrlType) {
                return;
            }
            String system = permCtrlType.getSystem();
            if (StringUtils.isNotEmpty((String)system) && Objects.equals("1", system)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", "status", "enable", "masterid", "bizobjectid", "systreefilter", PROP_MYHASRIGHTDR, "creator", "createtime", "modifier", "modifytime"});
            } else {
                String compareTypeStr = "perm_myhasright_" + permCtrlType.getBizobjectid();
                Set numberSet = DrHelper.getUsedDrNumFirst4SetByCompareType((String)compareTypeStr);
                if (null != numberSet && !numberSet.isEmpty()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"bizobjectid", "creator", "createtime", "modifier", "modifytime"});
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (Objects.equals(PROP_MYHASRIGHTDR, propName)) {
            boolean addNew;
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            boolean bl = addNew = !dataEntity.getDataEntityState().getFromDatabase();
            if (!addNew) {
                Object oldValue;
                ChangeData changeData = e.getChangeSet()[0];
                Object newValue = changeData.getNewValue();
                if (Objects.equals(newValue, oldValue = changeData.getOldValue())) {
                    return;
                }
                if (Objects.equals(newValue, false)) {
                    Object id = this.getModel().getValue("id");
                    DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"perm_ctrltype", (String)"bizobjectid_id");
                    String bizobjectid_id = object.getString("bizobjectid_id");
                    String compareTypeStr = "perm_myhasright_" + bizobjectid_id;
                    Set numberSet = DrHelper.getUsedDrNumFirst4SetByCompareType((String)compareTypeStr);
                    if (null == numberSet || numberSet.isEmpty()) {
                        return;
                    }
                    StringBuilder numberSetStr = StrUtil.wrapNumericTips((Set)numberSet, (int)3);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u6743\u9650\u63a7\u5236\u7c7b\u578b\u201d\u88ab\u201c\u6570\u636e\u89c4\u5219\u65b9\u6848\u201d\u6240\u5f15\u7528\u3002\u6570\u636e\u89c4\u5219\u65b9\u6848\u7684\u7f16\u7801\uff1a%s\u3002", (String)"PermCtrltypePlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[]{numberSetStr}));
                    this.getModel().beginInit();
                    this.getModel().setValue(PROP_MYHASRIGHTDR, (Object)Boolean.TRUE);
                    this.getModel().endInit();
                    this.getView().updateView(PROP_MYHASRIGHTDR);
                    return;
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizObject = (BasedataEdit)this.getControl("bizobjectid");
        bizObject.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.getCustomQFilters().add(new QFilter("modeltype", "=", (Object)"BaseFormModel")));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean addNew;
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        PermResult permResult = IsoDimHelper.checkPropRepeat((DynamicObject)dataEntity);
        if (Objects.equals(-1, permResult.getCode())) {
            this.getView().showTipNotification(permResult.getMsg());
            args.setCancel(true);
            return;
        }
        boolean bl = addNew = !dataEntity.getDataEntityState().getFromDatabase();
        if (addNew) {
            Integer maxSeq = IsoDimHelper.getMaxSeq();
            this.getModel().setValue("seqnum", (Object)(maxSeq + 1));
        }
    }
}

