/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SysAuthorityUpgradeUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.util.StringUtils;

public class PermSysParamFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(PermSysParamFormPlugin.class);
    private static final String PROP_ENABLE_PERMLOG = "enablepermlog";
    private static final String PROP_SYS_AUTHORITY = "sysauthority";
    private static final String PROP_ALLUSERAPP_CHECKPERMTIGHT = "alluserappcheckpermtight";
    private static final String OPKEY_SAVE = "donothing";
    private static final String PGCACHEKEY_NEEDCLEAR = "needClearNormalSysAuthority";
    private static final String CLEAR_NORMAL_SYS_AUTHORITY = "clear_normal_sys_authority";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.ifV6OldTenantAndNoSysAuthConfig()) {
            this.getModel().setValue(PROP_SYS_AUTHORITY, (Object)Boolean.TRUE);
        }
    }

    private boolean ifV6OldTenantAndNoSysAuthConfig() {
        boolean initVersion6 = InitailVersionServiceHelper.isInitailVersion((int)6);
        if (initVersion6) {
            return false;
        }
        String querySql = "select fdata from t_bas_sysparameter  where fparamid in(select fid from t_bas_sysparaconsole tbs where fformid = 'bos_base_parameter' and fappid = '83bfebc8000037ac') and forgid = ? ";
        long rootOrgId = ParameterOrgUtils.getParamRootOrgId();
        String qryResult = (String)DB.query((DBRoute)DBRoute.base, (String)querySql, (Object[])new Object[]{rootOrgId}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String dataJson = "";
                if (rs.next()) {
                    dataJson = rs.getString("fdata");
                }
                return dataJson;
            }
        });
        if (StringUtils.isEmpty((String)qryResult)) {
            return true;
        }
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)qryResult, Map.class);
        Object sysAuthObj = dataMap.get(PROP_SYS_AUTHORITY);
        return sysAuthObj == null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private String getMsg_NoRightToOperate() {
        return ResManager.loadKDString((String)"\u60a8\u65e0\u6743\u64cd\u4f5c\u8be5\u53c2\u6570\u3002", (String)"PermSysParamFormPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean adminUser;
        String propName = e.getProperty().getName();
        if (propName.equals(PROP_ENABLE_PERMLOG)) {
            boolean adminUser2 = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId(), (String)"10");
            if (!adminUser2) {
                this.getModel().beginInit();
                this.getModel().setValue(PROP_ENABLE_PERMLOG, (Object)PermCommonUtil.isEnablePermLog());
                this.getModel().endInit();
                this.getView().updateView(PROP_ENABLE_PERMLOG);
                this.getView().showMessage(this.getMsg_NoRightToOperate());
            }
        } else if (propName.equals(PROP_SYS_AUTHORITY)) {
            boolean adminUser3 = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId(), (String)"10");
            if (!adminUser3) {
                this.getModel().beginInit();
                this.getModel().setValue(PROP_SYS_AUTHORITY, (Object)PermCommonUtil.isEnableSysAuthority());
                this.getModel().endInit();
                this.getView().updateView(PROP_SYS_AUTHORITY);
                this.getView().showMessage(this.getMsg_NoRightToOperate());
                return;
            }
            boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            if (!newValue) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLEAR_NORMAL_SYS_AUTHORITY, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PermSysParamFormPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"PermSysParamFormPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u5173\u95ed\u6b64\u53c2\u6570\uff0c\u5c06\u4f1a\u6536\u56de\u7528\u6237\u901a\u8fc7\u975e\u7ba1\u7406\u5458\u65b9\u5f0f\u6388\u4e88\u7684\u201c\u7cfb\u7edf\u670d\u52a1\u4e91\u201d\u548c\u201c\u57fa\u7840\u670d\u52a1\u4e91\u201d\u7684\u6743\u9650\uff0c\u5e76\u4e14\u4e4b\u540e\u666e\u901a\u7528\u6237\u4e0d\u53ef\u518d\u88ab\u6388\u4e88\u201c\u7cfb\u7edf\u670d\u52a1\u4e91\u201d\u548c\u201c\u57fa\u7840\u670d\u52a1\u4e91\u201d\u6743\u9650\u3002", (String)"PermSysParamFormPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            }
        } else if (propName.equals(PROP_ALLUSERAPP_CHECKPERMTIGHT) && !(adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId(), (String)"10"))) {
            this.getModel().beginInit();
            this.getModel().setValue(PROP_ALLUSERAPP_CHECKPERMTIGHT, (Object)PermCommonUtil.isEnableAllUserAppCheckPermTight());
            this.getModel().endInit();
            this.getView().updateView(PROP_ALLUSERAPP_CHECKPERMTIGHT);
            this.getView().showMessage(this.getMsg_NoRightToOperate());
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (CLEAR_NORMAL_SYS_AUTHORITY.equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put(PGCACHEKEY_NEEDCLEAR, "true");
            } else {
                this.getModel().beginInit();
                this.getModel().setValue(PROP_SYS_AUTHORITY, (Object)PermCommonUtil.isEnableSysAuthority());
                this.getModel().endInit();
                this.getView().updateView(PROP_SYS_AUTHORITY);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (!(e.getSource() instanceof FormOperate)) {
            return;
        }
        String opKey = ((FormOperate)e.getSource()).getOperateKey();
        if (OPKEY_SAVE.equals(opKey)) {
            this.getPageCache().put(PROP_SYS_AUTHORITY, String.valueOf(PermCommonUtil.isEnableSysAuthority()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String opKey = e.getOperateKey();
        if (OPKEY_SAVE.equals(opKey)) {
            CacheMrg.clearAllCache();
            String sysAuthOldValue = this.getPageCache().get(PROP_SYS_AUTHORITY);
            String sysAuthNewValue = String.valueOf(this.getModel().getValue(PROP_SYS_AUTHORITY));
            boolean success = e.getOperationResult().isSuccess();
            String needClearFlag = this.getPageCache().get(PGCACHEKEY_NEEDCLEAR);
            if (success && "true".equals(needClearFlag)) {
                try {
                    SysAuthorityUpgradeUtil.notAllowSysAuthority((StringBuilder)new StringBuilder());
                }
                catch (Exception exp) {
                    logger.warn("PermSysParamFormPlugin clear sysauthority error", (Throwable)exp);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u76f8\u5173\u201c\u7cfb\u7edf\u670d\u52a1\u4e91\u548c\u57fa\u7840\u670d\u52a1\u4e91\u201d\u6388\u6743\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"PermSysParamFormPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue(PROP_SYS_AUTHORITY, (Object)PermCommonUtil.isEnableSysAuthority());
                    this.getModel().endInit();
                    this.getView().updateView(PROP_SYS_AUTHORITY);
                }
            }
            this.getPageCache().remove(PGCACHEKEY_NEEDCLEAR);
            if ("true".equals(sysAuthOldValue) && "false".equals(sysAuthNewValue)) {
                MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u5173\u95ed\u53c2\u6570", "PermSysParamFormPlugin_5", "bos-permission-formplugin");
                MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5173\u95ed\u53c2\u6570\uff1a\u53ef\u5bf9\u201c\u7cfb\u7edf\u670d\u52a1\u4e91\u201d\u548c\u201c\u57fa\u7840\u670d\u52a1\u4e91\u201d\u6388\u6743\uff0c\u5e76\u6e05\u7406\u4e86\u975e\u7ba1\u7406\u5458\u6388\u6743\u4e2d\u7684\u7cfb\u7edf\u5e94\u7528\u6743\u9650\uff08\u7cfb\u7edf\u670d\u52a1\u4e91\u5168\u90e8\u6743\u9650\u548c\u57fa\u7840\u670d\u52a1\u4e91\u7684\u90e8\u5206\u6743\u9650\uff09", "PermSysParamFormPlugin_6", "bos-permission-formplugin");
                String[] opDescParam = null;
                String oldOpDescription = ResManager.loadKDString((String)"\u5173\u95ed\u53c2\u6570\uff1a\u53ef\u5bf9\u201c\u7cfb\u7edf\u670d\u52a1\u4e91\u201d\u548c\u201c\u57fa\u7840\u670d\u52a1\u4e91\u201d\u6388\u6743\uff0c\u5e76\u6e05\u7406\u4e86\u975e\u7ba1\u7406\u5458\u6388\u6743\u4e2d\u7684\u7cfb\u7edf\u5e94\u7528\u6743\u9650\uff08\u7cfb\u7edf\u670d\u52a1\u4e91\u5168\u90e8\u6743\u9650\u548c\u57fa\u7840\u670d\u52a1\u4e91\u7684\u90e8\u5206\u6743\u9650\uff09", (String)"PermSysParamFormPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                PermCommonUtil.addLog(null, null, (String)"bos_base_parameter", null, (String)"1", (String)OPKEY_SAVE, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, opDescParam, (String)oldOpDescription, null, null, null);
            } else if ("false".equals(sysAuthOldValue) && "true".equals(sysAuthNewValue)) {
                MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u5f00\u542f\u53c2\u6570", "PermSysParamFormPlugin_7", "bos-permission-formplugin");
                MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5f00\u542f\u53c2\u6570\uff1a\u53ef\u5bf9\u201c\u7cfb\u7edf\u670d\u52a1\u4e91\u201d\u548c\u201c\u57fa\u7840\u670d\u52a1\u4e91\u201d\u6388\u6743", "PermSysParamFormPlugin_8", "bos-permission-formplugin");
                String[] opDescParam = null;
                String oldOpDescription = ResManager.loadKDString((String)"\u5f00\u542f\u53c2\u6570\uff1a\u53ef\u5bf9\u201c\u7cfb\u7edf\u670d\u52a1\u4e91\u201d\u548c\u201c\u57fa\u7840\u670d\u52a1\u4e91\u201d\u6388\u6743", (String)"PermSysParamFormPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                PermCommonUtil.addLog(null, null, (String)"bos_base_parameter", null, (String)"1", (String)OPKEY_SAVE, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, opDescParam, (String)oldOpDescription, null, null, null);
            }
        }
    }
}

