/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.StringUtils;

public class PermitemListPlugin
extends AbstractListPlugin {
    private static final String BTN_GENSQL = "baritem_generatesql";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BTN_GENSQL.equals(itemKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            Object[] pkids = selectedRows.getPrimaryKeyValues();
            Map objs = BusinessDataServiceHelper.loadFromCache((Object[])pkids, (String)"perm_permitem");
            StringBuilder sb = new StringBuilder();
            sb.append("/*\r\n");
            sb.append("*********************************************************************************************************** \r\n");
            sb.append(ResManager.loadKDString((String)"\u8bf7\u5c06\u811a\u672c\u653e\u5230\u76f8\u5e94\u6a21\u5757\u7684\u9884\u63d2\u6570\u636e\u76ee\u5f55\u4e2d,\u975e\u201c\u901a\u7528\u64cd\u4f5c\u201d\u7c7b\u578b\u7684\u6743\u9650\u9879\uff0c\u7f16\u7801\u8bf7\u4e0d\u8981\u4ee5QXX\u5f00\u5934\u3002\u6ce8\u610f\u811a\u672cdbkey\u8981\u6b63\u786e\u3002\r\n", (String)"PermitemListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            sb.append("*********************************************************************************************************** \r\n");
            sb.append("*/ \r\n");
            for (DynamicObject obj : objs.values()) {
                String itemSql = this.generateSql(obj);
                if (!StringUtils.isNotEmpty((String)itemSql)) continue;
                sb.append(itemSql);
            }
            this.exportSql(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void exportSql(byte[] sql) {
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("kd_X.X.X_bos_permitem.sql", sql, 5000);
        this.getView().openUrl(url);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff0c\u9ed8\u8ba4\u5bfc\u51fa\u8def\u5f84\u4e3aC:\\Users\\\u7528\u6237\u540d\\Downloads\u3002", (String)"PermitemListPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
    }

    private String generateSql(DynamicObject obj) {
        String name = obj.getString("name");
        name = StringUtils.isEmpty((String)name) ? " " : name;
        String description = obj.getString("description2");
        description = StringUtils.isEmpty((String)description) ? " " : description;
        String bizAppId = obj.getString("bizapp_id");
        bizAppId = StringUtils.isEmpty((String)bizAppId) ? " " : bizAppId;
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM T_PERM_PERMITEM WHERE FID = '").append(obj.getPkValue()).append("';\r\n");
        sql.append("INSERT INTO T_PERM_PERMITEM (FID, FNUMBER, FINHERITMODE, FGROUP, FPREPERMITEMID, FDESCRIPTION, FBIZAPPID, FNAME) VALUES ('");
        sql.append(obj.getPkValue()).append("', '");
        sql.append(obj.getString("number")).append("', '");
        sql.append(obj.getString("inheritmode")).append("', '");
        sql.append(obj.getString("group")).append("', '");
        sql.append(obj.getString("prepermitem_id")).append("', '");
        sql.append(description).append("', '");
        sql.append(bizAppId).append("', '");
        sql.append(name).append("');\r\n");
        sql.append("DELETE FROM T_PERM_PERMITEM_L WHERE FID = '").append(obj.getPkValue()).append("';\r\n");
        sql.append("INSERT INTO T_PERM_PERMITEM_L (FPKID, FID, FLOCALEID, FNAME, FDESCRIPTION) VALUES ('");
        sql.append(DBServiceHelper.genStringId()).append("', '");
        sql.append(obj.getPkValue()).append("', '");
        sql.append("zh_CN', '");
        sql.append(name).append("', '");
        sql.append(description);
        sql.append("');");
        sql.append("\r\n\r\n");
        return sql.toString();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (Objects.equals("tbldel", itemKey)) {
            evt.getSource();
            BillList billList = (BillList)this.getView().getControl("billlistap");
            Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
            boolean permItemUsed = PermItemHelper.checkPermItemUsed(Arrays.stream(primaryKeyValues).collect(Collectors.toSet()));
            if (permItemUsed) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u88ab\u5f15\u7528\u7684\u6743\u9650\u9879\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u64cd\u4f5c\u3002", (String)"PermitemListPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

