/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.model.perm.App;
import kd.bos.permission.model.perm.ComRoleAdminGrp;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.permission.service.AdminGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class RoleListPlugin
extends AbstractListPlugin
implements RowClickEventListener,
TreeNodeClickListener {
    public static final String FORM_ROLE_ORG2USER = "perm_roleorguser";
    public static final String FORM_ROLE_DIM2USER = "perm_roleassignuser_multi";
    public static final String FORM_ROLE_DIM2USRGRP = "perm_roleassignusrgrp_mul";
    public static final String FORM_ROLE_USER2ORG = "perm_roleuserorg";
    public static final String FORM_ROLE_ORG2USRGRP = "perm_roleorgusrgrp";
    public static final String FORM_ROLE_BATCHASSIGNPERM = "perm_rolebatchassignperm";
    public static final String FORM_ROLE_EDIT = "perm_role_edit";
    public static final String FSP_ROLE_EDIT_FORMNUM = "formShowParm_RoleEditFormNum";
    public static final String CUSTOMPARAM_SELROLEGROUP = "selRoleGroup";
    public static final String TREEVIEW_ROLEGROUP = "treeview";
    public static final String BILLLIST = "billlistap";
    public static final String BARITEM_NEW = "tblnew";
    public static final String BARITEM_IMPROLEFUNPERM = "improlefunperm";
    public static final String BARITEM_ORG2USER = "bar_org_user";
    public static final String BAR_ASSIGN_USER = "bar_assign_user";
    public static final String BAR_ASSIGN_USRGRP = "bar_assign_usrgrp";
    public static final String BARITEM_ORG2USRGRP = "bar_org_usrgrp";
    public static final String BARITEM_USER2ORG = "bar_user_org";
    public static final String CLSCALLBCK_CLOSEEDITFORM = "closeEditForm";
    public static final String PGCACHE_SELROW_INDEX = "pgCacheKey_selRowIndex";
    public static final String FIELD_ISSYS = "issystem";
    public static final String ALTER_ROLE_PERM = "tb_altroleperm";
    public static final String FORM_ALTPERM_TEMPLATE = "altperm_template";
    private static final Log logger = LogFactory.getLog(RoleListPlugin.class);
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String OPER_KEY_DONOTHING_ROLEASSIGNORGUSER = "donothing_roleassignorguser";
    private static final String OPER_KEY_DONOTHING_ROLEASSIGNUSER = "donothing_roleassignuser";
    private static final String OPER_KEY_DONOTHING_ROLEASSIGNUSERLIST = "donothing_roleassignuserlist";
    private static final String OPER_KEY_DONOTHING_ROLEASSIGNUSRGRP = "donothing_roleassignusrgrp";
    private static final String OPER_KEY_DONOTHING_ROLEASSIGNUSRGRPLIST = "donothing_roleassignusrgrplist";
    private static final String OPER_KEY_DONOTHING_ROLEASSIGNUSERORG = "donothing_roleassignuserorg";
    private static final String OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP = "donothing_roleassignorgusrgrp";
    private static final String OPER_KEY_DONOTHING_BATCHASSIGNPERM = "donothing_batchassignperm";
    protected String ctrlTypeName = null;
    private static final String ROLE_MUTEXT_TYPE = "ROLE_MUTEXT_TYPE";

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datas = e.getQueryValues();
        if (null == datas || Objects.equals(0, datas.length)) {
            return;
        }
        Set roleIdSet = Arrays.stream(datas).map(x -> x.getString("id")).collect(Collectors.toSet());
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return;
        }
        Map rolePermSetMap = PermRoleHelper.getRolePermSetMap(roleIdSet, (String)"id");
        HashSet<String> appIdSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        HashSet<String> permItemIdSet = new HashSet<String>(8);
        for (Map.Entry rolePermSet : rolePermSetMap.entrySet()) {
            Set value = (Set)rolePermSet.getValue();
            if (null == value || value.isEmpty()) continue;
            for (ComRoleFuncPerm funcPerm : value) {
                appIdSet.add(funcPerm.getAppId());
                entNumSet.add(funcPerm.getEntityNumber());
                permItemIdSet.add(funcPerm.getPermItemId());
            }
        }
        Map cloudDynMap = AppHelper.getCloudMap(new ArrayList(appIdSet));
        Map appDynMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", appIdSet)});
        Map entDynMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", entNumSet)});
        Map permitemDynMap = BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", permItemIdSet)});
        HashSet<String> adminGroupIdSet = new HashSet<String>(8);
        Map admGrpSetMap = PermRoleHelper.getAdmGrpSetMap(roleIdSet, (String)"id");
        for (Map.Entry admGrpSet : admGrpSetMap.entrySet()) {
            Set value = (Set)admGrpSet.getValue();
            if (null == value || value.isEmpty()) continue;
            for (ComRoleAdminGrp one : value) {
                adminGroupIdSet.add(one.getAdminGroupId());
            }
        }
        Map adminGrpDynMap = BusinessDataServiceHelper.loadFromCache((Object[])adminGroupIdSet.stream().map(x -> Long.valueOf(x)).toArray(), (String)"perm_admingroup");
        for (DynamicObject data : datas) {
            Set comRoleAdminGrpSet;
            Set roleFuncPerms;
            String roleId = data.getString("id");
            if (StringUtils.isEmpty((String)roleId)) continue;
            if (data.containsProperty("roletype")) {
                String roletype = data.getString("roletype");
                String userTypeNameStr = PermCommonUtil.getUserTypeNameStrByIdStr((String)roletype);
                data.set("roletype", (Object)userTypeNameStr);
            }
            if (null != (roleFuncPerms = (Set)rolePermSetMap.get(roleId)) && !CollectionUtils.isEmpty((Collection)roleFuncPerms) && data.containsProperty("import_entry_funcperm")) {
                DynamicObjectCollection import_entry_funcperm = data.getDynamicObjectCollection("import_entry_funcperm");
                DynamicObjectType dt = import_entry_funcperm.getDynamicObjectType();
                import_entry_funcperm.clear();
                List roleFuncPermList = roleFuncPerms.stream().sorted(Comparator.comparing(App::getAppId).thenComparing(Entity::getEntityNumber).thenComparing(PermItem::getPermItemId)).collect(Collectors.toList());
                for (ComRoleFuncPerm comRoleFuncPerm : roleFuncPermList) {
                    DynamicObject dyn = new DynamicObject(dt);
                    if (dyn.containsProperty("funcperm_entryid")) {
                        dyn.set("funcperm_entryid", (Object)comRoleFuncPerm.getEntryId());
                    }
                    String appId = comRoleFuncPerm.getAppId();
                    DynamicObject cloud = (DynamicObject)cloudDynMap.get(appId);
                    if (dyn.containsProperty("import_cloud") && null != cloud) {
                        dyn.set("import_cloud", (Object)cloud.getDynamicObject("bizcloud"));
                    } else if (dyn.containsProperty("import_cloud") && null == cloud) continue;
                    DynamicObject app = (DynamicObject)appDynMap.get(appId);
                    if (dyn.containsProperty("import_app") && null != app) {
                        dyn.set("import_app", (Object)app);
                    } else if (dyn.containsProperty("import_app") && null == app) continue;
                    DynamicObject ent = (DynamicObject)entDynMap.get(comRoleFuncPerm.getEntityNumber());
                    if (dyn.containsProperty("import_ent") && null != ent) {
                        dyn.set("import_ent", (Object)ent);
                    } else if (dyn.containsProperty("import_ent") && null == ent) continue;
                    DynamicObject permItem = (DynamicObject)permitemDynMap.get(comRoleFuncPerm.getPermItemId());
                    if (dyn.containsProperty("import_permitem") && null != permItem) {
                        dyn.set("import_permitem", (Object)permItem);
                    } else if (dyn.containsProperty("import_permitem") && null == permItem) continue;
                    import_entry_funcperm.add((Object)dyn);
                }
            }
            if (null == (comRoleAdminGrpSet = (Set)admGrpSetMap.get(roleId)) || CollectionUtils.isEmpty((Collection)comRoleAdminGrpSet) || !data.containsProperty("entry_assign_admingrp")) continue;
            DynamicObjectCollection entry_assign_admingrp = data.getDynamicObjectCollection("entry_assign_admingrp");
            DynamicObjectType dt = entry_assign_admingrp.getDynamicObjectType();
            entry_assign_admingrp.clear();
            List comRoleAdminGrpList = comRoleAdminGrpSet.stream().sorted(Comparator.comparing(ComRoleAdminGrp::getAdminGroupNumber)).collect(Collectors.toList());
            for (ComRoleAdminGrp comRoleAdminGrp : comRoleAdminGrpList) {
                String adminGroupId;
                DynamicObject dyn = new DynamicObject(dt);
                if (dyn.containsProperty("admgrp_entryid")) {
                    dyn.set("admgrp_entryid", (Object)comRoleAdminGrp.getEntryId());
                }
                if (StringUtils.isNotEmpty((String)(adminGroupId = comRoleAdminGrp.getAdminGroupId())) && null != adminGrpDynMap.get(Long.valueOf(adminGroupId))) {
                    dyn.set("admingrp", adminGrpDynMap.get(Long.valueOf(adminGroupId)));
                }
                dyn.set("rolemodifiable", (Object)comRoleAdminGrp.isModifiable());
                entry_assign_admingrp.add((Object)dyn);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BARITEM_IMPROLEFUNPERM});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals(BARITEM_IMPROLEFUNPERM)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_importstart");
            IFormView view = this.getView();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
            showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
            showParameter.setCustomParam("BillFormId", (Object)"perm_roleperm");
            showParameter.setCustomParam("ListName", (Object)ResManager.loadKDString((String)"\u89d2\u8272\u529f\u80fd\u6743\u9650", (String)"RoleListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection pageData = e.getPageData();
        if (null == pageData || pageData.isEmpty()) {
            return;
        }
        Set collect = pageData.stream().map(x -> x.getString("bizdomain_id")).collect(Collectors.toSet());
        Set appIds = AppHelper.getAppId((Set)Sets.newHashSet(collect));
        Map appIdNameMap = AppHelper.getAllAppIdNameMap((Set)appIds);
        for (DynamicObject dd : pageData) {
            Object appObj = dd.get("bizdomain");
            if (null == appObj) continue;
            DynamicObject app = (DynamicObject)appObj;
            String preName = app.getString("name");
            String appName = (String)appIdNameMap.get(app.getString("id"));
            if (!StringUtils.isNotEmpty((String)appName) || Objects.equals(preName, appName)) continue;
            app.set("name", (Object)new LocaleString(appName).getLocaleValue());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean isSingleOrg = PermFormCommonUtil.isSingleOrg();
        String fsp_dim2user = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_itemName_dim2user");
        String fsp_user2dim = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_itemName_user2dim");
        String fsp_dim2usrgrp = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_itemName_dim2usrgrp");
        if (isSingleOrg) {
            if (StringUtils.isEmpty((String)fsp_dim2user)) {
                fsp_dim2user = ResManager.loadKDString((String)"\u5206\u914d\u7528\u6237", (String)"RoleListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            if (StringUtils.isEmpty((String)fsp_dim2usrgrp)) {
                fsp_dim2usrgrp = ResManager.loadKDString((String)"\u5206\u914d\u7528\u6237\u7ec4", (String)"RoleListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            HashMap<String, LocaleString> captionInfo1 = new HashMap<String, LocaleString>();
            captionInfo1.put("text", new LocaleString(fsp_dim2user));
            captionInfo1.put("w", new LocaleString("85px"));
            this.getView().updateControlMetadata(BARITEM_ORG2USER, captionInfo1);
            captionInfo1 = new HashMap();
            captionInfo1.put("title", new LocaleString(fsp_dim2usrgrp));
            captionInfo1.put("w", new LocaleString("85px"));
            this.getView().updateControlMetadata(BARITEM_ORG2USRGRP, captionInfo1);
            this.getView().updateView(BARITEM_ORG2USRGRP);
            this.getView().updateView("toolbarap");
            this.getView().setVisible(Boolean.FALSE, new String[]{BARITEM_USER2ORG});
        } else {
            if (StringUtils.isNotEmpty((String)fsp_dim2user)) {
                HashMap<String, LocaleString> captionInfo1 = new HashMap<String, LocaleString>();
                captionInfo1.put("text", new LocaleString(fsp_dim2user));
                this.getView().updateControlMetadata(BARITEM_ORG2USER, captionInfo1);
            }
            if (StringUtils.isNotEmpty((String)fsp_user2dim)) {
                HashMap<String, LocaleString> captionInfo2 = new HashMap<String, LocaleString>();
                captionInfo2.put("text", new LocaleString(fsp_user2dim));
                this.getView().updateControlMetadata(BARITEM_USER2ORG, captionInfo2);
            }
            if (StringUtils.isNotEmpty((String)fsp_dim2usrgrp)) {
                HashMap<String, LocaleString> captionInfo3 = new HashMap<String, LocaleString>();
                captionInfo3.put("text", new LocaleString(fsp_dim2usrgrp));
                this.getView().updateControlMetadata(BARITEM_ORG2USRGRP, captionInfo3);
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter fsp = e.getFormShowParameter();
        String showFormSpecial = (String)fsp.getCustomParam("FormShowParam_ShowForSpecialUser");
        if ("true".equals(showFormSpecial)) {
            return;
        }
        String unableShowInfo = (String)fsp.getCustomParam("formShowParm_show_unableInfo");
        if (StringUtils.isNotEmpty((String)unableShowInfo)) {
            e.setCancel(true);
            e.setCancelMessage(unableShowInfo);
            return;
        }
        ListShowParameter lsp = (ListShowParameter)fsp;
        if (!lsp.isLookUp()) {
            PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
        }
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"iscontainnow", "iscontainlower"});
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        boolean lookUp = lsp.isLookUp();
        if (!lookUp) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        }
        TreeView tv = (TreeView)this.getControl(TREEVIEW_ROLEGROUP);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.ctrlTypeName = ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"RoleListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String dimType = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_dimension");
        if (StringUtils.isNotEmpty((String)dimType)) {
            this.ctrlTypeName = PermCommonUtil.getDimTypeName((String)dimType);
            if (StringUtils.isEmpty((String)this.ctrlTypeName) || "null".equals(this.ctrlTypeName)) {
                this.ctrlTypeName = ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"RoleListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
        }
        if (IsoDimHelper.checkAuthInSysTree((String)dimType)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BAR_ASSIGN_USER});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BARITEM_ORG2USER});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BAR_ASSIGN_USER});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BARITEM_ORG2USER});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String childPageSetJson = this.getPageCache().get("childPageSet");
        if (StringUtils.isNotEmpty((String)childPageSetJson)) {
            Set childPageSet = (Set)JSON.parseObject((String)childPageSetJson, Set.class);
            for (String childPageId : childPageSet) {
                IFormView view = this.getView().getView(childPageId);
                if (view == null) continue;
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u672a\u5173\u95ed\u7684\u201c\u901a\u7528\u89d2\u8272\u201d\u7f16\u8f91\u72b6\u6001\u9875\u7b7e\uff0c\u8bf7\u5148\u5173\u95ed\u540e\u518d\u9000\u51fa\uff0c\u7f16\u8f91\u72b6\u6001\u7684\u9875\u7b7e\u53ef\u80fd\u6709\uff1a\u201c\u5206\u914d\u7528\u6237\u201d\u3001\u201c\u5206\u914d\u7528\u6237\u7ec4\u201d\u3001\u201c\u5206\u914d%1$s\u7528\u6237\u201d\u3001\u201c\u5206\u914d\u7528\u6237%2$s\u201d\u3001\u201c\u5206\u914d%3$s\u7528\u6237\u7ec4\u201d\u6216\u201c\u6279\u91cf\u8ffd\u52a0\u6388\u6743\u201d\u7b49\u3002", (String)"RoleListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.ctrlTypeName, this.ctrlTypeName, this.ctrlTypeName));
                e.setCancel(true);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String customRoleEditFormNum;
        super.beforeItemClick(evt);
        if (evt.getItemKey().equals(BARITEM_NEW) && StringUtils.isNotEmpty((String)(customRoleEditFormNum = this.getRoleEditFormNum()))) {
            evt.setCancel(true);
            Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.putAll(originalCustParams);
            customParam.put("FormShowParam_CtrlType_Name", this.ctrlTypeName);
            TreeView tv = (TreeView)this.getControl(TREEVIEW_ROLEGROUP);
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (StringUtils.isNotEmpty((String)focusNodeId)) {
                customParam.put(CUSTOMPARAM_SELROLEGROUP, focusNodeId);
            }
            this.showForm(customRoleEditFormNum, customParam, new CloseCallBack((IFormPlugin)this, CLSCALLBCK_CLOSEEDITFORM), ShowType.MainNewTabPage, OperationStatus.ADDNEW);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        TreeView tv;
        String focusNodeId;
        super.beforeShowBill(e);
        Map customParams = e.getParameter().getCustomParams();
        Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.putAll(originalCustParams);
        customParams.put("FormShowParam_CtrlType_Name", this.ctrlTypeName);
        String customRoleEditFormNum = this.getRoleEditFormNum();
        if (StringUtils.isNotEmpty((String)customRoleEditFormNum)) {
            e.getParameter().setFormId(customRoleEditFormNum);
        }
        if (StringUtils.isNotEmpty((String)(focusNodeId = (tv = (TreeView)this.getControl(TREEVIEW_ROLEGROUP)).getTreeState().getFocusNodeId()))) {
            customParams.put(CUSTOMPARAM_SELROLEGROUP, focusNodeId);
        }
        String roleId = String.valueOf(e.getParameter().getPkId());
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String pageId = this.getView().getPageId() + "_" + billFormId + "_" + roleId;
        IFormView iFormView = this.getView().getView(pageId);
        if (iFormView == null) {
            this.recordOpenedChildPage(pageId);
        }
        if (StringUtils.isNotEmpty((String)roleId) && !"null".equals(roleId) && !BillOperationStatus.ADDNEW.equals((Object)e.getParameter().getBillStatus())) {
            OperationStatus status = e.getParameter().getStatus();
            if (Objects.equals(OperationStatus.VIEW, status)) {
                return;
            }
            boolean canModifyRole = AdminGroupService.canModifyRole((Long)RequestContext.get().getCurrUserId(), (String)roleId);
            if (canModifyRole) {
                e.getParameter().setStatus(OperationStatus.EDIT);
            } else {
                e.getParameter().setStatus(OperationStatus.VIEW);
            }
        }
    }

    private void recordOpenedChildPage(String childPageId) {
        String childPageSetJson = this.getPageCache().get("childPageSet");
        HashSet<String> childPageSet = StringUtils.isNotEmpty((String)childPageSetJson) ? (HashSet<String>)JSON.parseObject((String)childPageSetJson, HashSet.class) : new HashSet<String>(8);
        childPageSet.add(childPageId);
        this.getPageCache().put("childPageSet", JSON.toJSONString(childPageSet));
    }

    private String getRoleEditFormNum() {
        String roleEditFormNum = (String)this.getView().getFormShowParameter().getCustomParam(FSP_ROLE_EDIT_FORMNUM);
        if (StringUtils.isNotEmpty((String)roleEditFormNum)) {
            return roleEditFormNum;
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (PermCommonUtil.isSingleOrg()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BARITEM_USER2ORG});
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        IPageCache pageCache = this.getPageCache();
        String type = "ROLE_MUTEXT_TYPE|" + pageCache.getPageId();
        Map roleMutexTypeMap = CacheMrg.getCache((String)type);
        if (CollectionUtils.isEmpty((Map)roleMutexTypeMap)) {
            CacheMrg.clearCache((String)type);
            return;
        }
        for (Map.Entry entry : roleMutexTypeMap.entrySet()) {
            String mutex_oper_key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String[] split = value.split("\\|");
            String mutex_entity_key = split[0];
            String mutex_obj_id = split[1];
            MutexHelper.release((String)mutex_entity_key, (String)mutex_oper_key, (String)mutex_obj_id);
        }
        CacheMrg.clearCache((String)type);
    }

    private void showRoleRelatedForm(String formName, Map<String, Object> customParam, String opKey, AfterDoOperationEventArgs e) {
        IFormView formView = this.getView();
        if (!(formView instanceof IListView)) {
            return;
        }
        IListView listView = (IListView)formView;
        ListSelectedRowCollection roleList = listView.getSelectedRows();
        String selRowIndexs = this.getPageCache().get(PGCACHE_SELROW_INDEX);
        if (roleList == null || roleList.isEmpty()) {
            if (selRowIndexs == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RoleListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
        } else if (roleList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"RoleListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (selRowIndexs != null && selRowIndexs.contains(",")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"RoleListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        String userId = RequestContext.get().getUserId();
        Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
        String isShowForSpecial = originalCustParams.get("FormShowParam_ShowForSpecialUser") == null ? null : (String)originalCustParams.get("FormShowParam_ShowForSpecialUser");
        String roleId = null;
        String roleNumber = null;
        if (roleList != null && roleList.size() == 1) {
            ListSelectedRow row = roleList.get(0);
            roleId = (String)row.getPrimaryKeyValue();
            roleNumber = row.getNumber();
        } else {
            roleId = selRowIndexs;
        }
        if (OPER_KEY_DONOTHING_BATCHASSIGNPERM.equals(opKey)) {
            Map roleMap = PermRoleHelper.getRoleMap(Collections.singletonList(roleId), (String)RequestContext.get().getLang().name());
            Map map = (Map)roleMap.get(roleId);
            Boolean fissystem = (Boolean)map.get("fissystem");
            if (Boolean.TRUE.equals(fissystem)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u89d2\u8272\u4e0d\u53ef\u4fee\u6539\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u8ffd\u52a0\u6388\u6743\u3002", (String)"RoleListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            Map canModifyMap = AdminGroupService.canModifyRole((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(roleId));
            for (Map.Entry entry : canModifyMap.entrySet()) {
                Boolean canModify = (Boolean)entry.getValue();
                if (Boolean.TRUE.equals(canModify)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u4fee\u6539\u8be5\u901a\u7528\u89d2\u8272\u3002", (String)"RoleListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(5000));
                return;
            }
        }
        FormShowParameter param = new FormShowParameter();
        IFormView fv = null;
        if (PermCommonUtil.isSingleOrg()) {
            String isSingleOrgCaption = "";
            if (OPER_KEY_DONOTHING_ROLEASSIGNORGUSER.equals(opKey) || Objects.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSER, opKey)) {
                isSingleOrgCaption = ResManager.loadKDString((String)"\u5206\u914d\u7528\u6237", (String)"RoleListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            } else if (OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP.equals(opKey) || Objects.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSRGRP, opKey)) {
                isSingleOrgCaption = ResManager.loadKDString((String)"\u5206\u914d\u7528\u6237\u7ec4", (String)"RoleListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            param.setCaption(isSingleOrgCaption);
        }
        String newPageId = opKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNORGUSER) ? roleId + "-assignOrgUser-" + this.getView().getPageId() : (OPER_KEY_DONOTHING_ROLEASSIGNUSER.equals(opKey) ? roleId + "-assignDimUser-" + this.getView().getPageId() : (OPER_KEY_DONOTHING_ROLEASSIGNUSERORG.equals(opKey) ? roleId + "-assignUserOrg-" + this.getView().getPageId() : (OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP.equals(opKey) ? roleId + "-assignUsrGrpOrg-" + this.getView().getPageId() : (OPER_KEY_DONOTHING_ROLEASSIGNUSRGRP.equals(opKey) ? roleId + "-assignDimUsrGrp-" + this.getView().getPageId() : roleId + "-batchAssignPerm-" + this.getView().getPageId()))));
        param.setPageId(newPageId);
        fv = this.getView().getView(newPageId);
        if (fv == null) {
            MutexLockInfo lockInfo;
            BillList billlistap = (BillList)this.getControl(BILLLIST);
            Object focusRowPkId = billlistap.getFocusRowPkId();
            String notFoundErrorInfo = ResManager.loadKDString((String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u884c\u6570\u636e\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u9009\u62e9\uff0c\u6216\u9000\u51fa\u7136\u540e\u91cd\u65b0\u8fdb\u5165\u5f53\u524d\u754c\u9762\u3002", (String)"RoleListPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            if (focusRowPkId == null) {
                this.getView().showTipNotification(notFoundErrorInfo, Integer.valueOf(10000));
                return;
            }
            String focusRoleId = focusRowPkId.toString();
            if (StringUtils.isEmpty((String)focusRoleId)) {
                this.getView().showTipNotification(notFoundErrorInfo, Integer.valueOf(10000));
                return;
            }
            StringBuilder sbErrorInfo = new StringBuilder();
            boolean require = false;
            String operKey = OPER_KEY_DONOTHING_ROLEASSIGNORGUSER;
            StringBuilder failInfo = new StringBuilder();
            if (OPER_KEY_DONOTHING_BATCHASSIGNPERM.equals(opKey)) {
                operKey = "modify";
                lockInfo = new MutexLockInfo(roleId, roleNumber, (String)null, "perm_role", operKey, true, "default");
                require = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)failInfo);
                if (!require) {
                    this.getView().showTipNotification(failInfo.toString(), Integer.valueOf(3000));
                    return;
                }
            } else if (OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP.equals(opKey) || OPER_KEY_DONOTHING_ROLEASSIGNUSRGRP.equals(opKey)) {
                operKey = OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP;
                lockInfo = new MutexLockInfo(roleId, roleNumber, "1", "perm_role", operKey, true, "default");
                require = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)failInfo);
                if (!require) {
                    this.getView().showTipNotification(failInfo.toString(), Integer.valueOf(3000));
                    return;
                }
            } else {
                lockInfo = new MutexLockInfo(roleId, roleNumber, "2", "perm_role", operKey, true, "default");
                require = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)failInfo);
            }
            IPageCache pageCache = this.getPageCache();
            String type = "ROLE_MUTEXT_TYPE|" + pageCache.getPageId();
            HashMap<String, String> roleMutexTypeMap = CacheMrg.getCache((String)type);
            if (CollectionUtils.isEmpty((Map)roleMutexTypeMap)) {
                roleMutexTypeMap = new HashMap<String, String>(8);
            }
            roleMutexTypeMap.put(operKey, "perm_role|" + focusRoleId);
            CacheMrg.putCache((String)type, roleMutexTypeMap);
            OperationResult operationResult = e.getOperationResult();
            if (!operationResult.isSuccess() && !require) {
                operationResult.setSuccess(true);
                List allErrorInfos = operationResult.getAllErrorInfo();
                if (!CollectionUtils.isEmpty((Collection)allErrorInfos)) {
                    allErrorInfos.removeIf(allErrorInfo -> "datamutex".equals(allErrorInfo.getErrorCode()));
                }
            }
            if (!require) {
                this.getView().showMessage(failInfo.toString());
                param.setStatus(OperationStatus.VIEW);
            } else {
                param.setStatus(OperationStatus.EDIT);
            }
        }
        param.setCustomParam("roleId", (Object)roleId);
        param.setCustomParam("FromList", (Object)"true");
        String dimType = (String)originalCustParams.get("FormShowParam_dimension");
        if (StringUtils.isNotEmpty((String)dimType)) {
            param.setCustomParam("FormShowParam_dimension", (Object)dimType);
        } else {
            param.setCustomParam("FormShowParam_dimension", (Object)"bos_org");
        }
        param.getCustomParams().putAll(customParam);
        param.setFormId(formName);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "newformcallback");
        param.setCloseCallBack(callBack);
        this.getView().showForm(param);
        this.recordOpenedChildPage(newPageId);
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType, OperationStatus opStatus) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        if (opStatus != null) {
            param.setStatus(opStatus);
        }
        this.getView().showForm(param);
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection lsrc = evt.getListSelectedRowCollection();
        if (lsrc == null || lsrc.size() == 0) {
            this.getPageCache().remove(PGCACHE_SELROW_INDEX);
            return;
        }
        StringBuilder sb = new StringBuilder();
        int rowSize = lsrc.size();
        for (int i = 0; i < rowSize; ++i) {
            sb.append(lsrc.get(i).getPrimaryKeyValue());
            if (i == rowSize - 1) continue;
            sb.append(',');
        }
        this.getPageCache().put(PGCACHE_SELROW_INDEX, sb.toString());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getActionId().equals(CLSCALLBCK_CLOSEEDITFORM)) {
            BillList billList = (BillList)this.getControl(BILLLIST);
            billList.refresh();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate formOperate = (FormOperate)args.getSource();
            String operationKey = formOperate.getOperateKey();
            if (operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSERLIST)) {
                String newPageId = "-assignUserList-" + this.getView().getPageId();
                IFormView fv = this.getView().getView(newPageId);
                if (fv != null) {
                    PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                    args.setCancel(true);
                }
                return;
            }
            if (operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSRGRPLIST)) {
                String newPageId = "-assignUsrGrpList-" + this.getView().getPageId();
                IFormView fv = this.getView().getView(newPageId);
                if (fv != null) {
                    PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                    args.setCancel(true);
                }
                return;
            }
            if ("copy".equalsIgnoreCase(operationKey)) {
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                this.getView().getFormShowParameter().setCustomParam("copy_role_id", listSelectedData.get(0).getPrimaryKeyValue());
            } else if ("disable".equals(operationKey) || "enable".equals(operationKey) || "delete".equals(operationKey)) {
                String opbtn;
                String string = "disable".equals(operationKey) ? ConstantsHelper.getDisable() : (opbtn = "enable".equals(operationKey) ? ConstantsHelper.getEnable() : ConstantsHelper.getDel());
                String permlogBusiType = "disable".equals(operationKey) ? "common_role_disable" : ("enable".equals(operationKey) ? "common_role_enable" : "common_role_del");
                OperateOption option = formOperate.getOption();
                if (PermCommonUtil.isEnablePermLog()) {
                    option.setVariableValue("ENTSAVE_PERMLOG", "1");
                }
                option.setVariableValue("permlog_op", operationKey);
                option.setVariableValue("permlog_opbtn", opbtn);
                option.setVariableValue("permlog_interfacemethod", "kd.bos.permission.formplugin.plugin.RoleListPlugin.beforeDoOperation");
                option.setVariableValue("permlog_busitype", permlogBusiType);
                option.setVariableValue("permlog_formnum", "perm_role");
            } else if (operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNORGUSER) || operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSER) || operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSRGRP) || operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSERORG) || operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP)) {
                IFormView fv = null;
                String newPageId = null;
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                if (null == listSelectedData || listSelectedData.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RoleListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (listSelectedData.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u3002", (String)"RoleListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String roleId = (String)listSelectedData.get(0).getPrimaryKeyValue();
                if (operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNORGUSER)) {
                    newPageId = roleId + "-assignOrgUser-" + this.getView().getPageId();
                    fv = this.getView().getView(newPageId);
                } else if (operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSER)) {
                    newPageId = roleId + "-assignDimUser-" + this.getView().getPageId();
                    fv = this.getView().getView(newPageId);
                } else if (operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSERORG)) {
                    newPageId = roleId + "-assignUserOrg-" + this.getView().getPageId();
                    fv = this.getView().getView(newPageId);
                } else if (operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP)) {
                    newPageId = roleId + "-assignOrgUsrGrp-" + this.getView().getPageId();
                    fv = this.getView().getView(newPageId);
                } else if (operationKey.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSRGRP)) {
                    newPageId = roleId + "-assignDimUsrGrp-" + this.getView().getPageId();
                    fv = this.getView().getView(newPageId);
                }
                if (fv != null) {
                    PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String objectId = e.getOperateKey();
        if (Objects.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSERLIST, objectId)) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId("perm_roleuser_layout");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.setPageId("-assignUserList-" + this.getView().getPageId());
            Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
            Map customParams = lsp.getCustomParams();
            customParams.putAll(originalCustParams);
            String dimType = (String)customParams.get("FormShowParam_dimension");
            String appNumStr = (String)customParams.get("FormShowParam_appNum");
            this.getPageCache().put("PERM_PAGECHE_KEY_PREFIX_FormShowParam_dimension", dimType);
            this.getPageCache().put("PERM_PAGECHE_KEY_PREFIX_FormShowParam_appNum", appNumStr);
            this.getView().showForm((FormShowParameter)lsp);
            return;
        }
        if (Objects.equals(OPER_KEY_DONOTHING_ROLEASSIGNUSRGRPLIST, objectId)) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId("perm_roleusrgrp_layout");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.setPageId("-assignUsrGrpList-" + this.getView().getPageId());
            Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
            Map customParams = lsp.getCustomParams();
            customParams.putAll(originalCustParams);
            String dimType = (String)customParams.get("FormShowParam_dimension");
            String appNumStr = (String)customParams.get("FormShowParam_appNum");
            this.getPageCache().put("PERM_PAGECHE_KEY_PREFIX_FormShowParam_dimension", dimType);
            this.getPageCache().put("PERM_PAGECHE_KEY_PREFIX_FormShowParam_appNum", appNumStr);
            this.getView().showForm((FormShowParameter)lsp);
            return;
        }
        if ("delete".equals(objectId)) {
            return;
        }
        if ("disable".equals(objectId)) {
            return;
        }
        if ("enable".equals(objectId)) {
            return;
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Map originalCustParams = this.getView().getFormShowParameter().getCustomParams();
        customParam.putAll(originalCustParams);
        customParam.put("FormShowParam_CtrlType_Name", this.ctrlTypeName);
        if (OPER_KEY_DONOTHING_ROLEASSIGNORGUSER.equals(objectId)) {
            String formName = FORM_ROLE_ORG2USER;
            String dimInLeftFormName = (String)this.getView().getFormShowParameter().getCustomParam("formShowParm_RoleAssignFormName_left");
            if (StringUtils.isNotEmpty((String)dimInLeftFormName)) {
                formName = dimInLeftFormName;
            }
            this.showRoleRelatedForm(formName, customParam, OPER_KEY_DONOTHING_ROLEASSIGNORGUSER, e);
        } else if (OPER_KEY_DONOTHING_ROLEASSIGNUSER.equals(objectId)) {
            String formName = FORM_ROLE_DIM2USER;
            this.showRoleRelatedForm(formName, customParam, OPER_KEY_DONOTHING_ROLEASSIGNUSER, e);
        } else if (OPER_KEY_DONOTHING_ROLEASSIGNUSERORG.equals(objectId)) {
            String formName = FORM_ROLE_USER2ORG;
            String dimInRightFormName = (String)this.getView().getFormShowParameter().getCustomParam("formShowParm_RoleAssignFormName_right");
            if (StringUtils.isNotEmpty((String)dimInRightFormName)) {
                formName = dimInRightFormName;
            }
            this.showRoleRelatedForm(formName, customParam, OPER_KEY_DONOTHING_ROLEASSIGNUSERORG, e);
        } else if (OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP.equals(objectId)) {
            this.showRoleRelatedForm(FORM_ROLE_ORG2USRGRP, customParam, OPER_KEY_DONOTHING_ROLEASSIGNORGUSRGRP, e);
        } else if (OPER_KEY_DONOTHING_BATCHASSIGNPERM.equals(objectId)) {
            this.showRoleRelatedForm(FORM_ROLE_BATCHASSIGNPERM, customParam, OPER_KEY_DONOTHING_BATCHASSIGNPERM, e);
        } else if (OPER_KEY_DONOTHING_ROLEASSIGNUSRGRP.equals(objectId)) {
            this.showRoleRelatedForm(FORM_ROLE_DIM2USRGRP, customParam, OPER_KEY_DONOTHING_ROLEASSIGNUSRGRP, e);
        }
    }
}

