/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.util.StringUtils;

public class RoleRightOverviewPlugin
extends AbstractListPlugin
implements TabSelectListener {
    private static Log logger = LogFactory.getLog(RoleRightOverviewPlugin.class);
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String ROLERIGHTOVERVIEW_BILLLIST = "roleRightOverviewBilllist";
    private static final String TABAP = "tabap";
    private static final String BILLLISTAP = "billlistap";
    private static final String cloudname = "cloudname";
    private static final String appnum = "appnum";
    private static final String appname = "appname";
    private static final String entnum = "entnum";
    private static final String entname = "entname";
    private static final String[][] listColumns = new String[][]{{ResManager.loadKDString((String)"\u4e91", (String)"RoleRightOverviewPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), "cloudname", "true"}, {ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801", (String)"RoleRightOverviewPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]), "appnum", "false"}, {ResManager.loadKDString((String)"\u5e94\u7528", (String)"RoleRightOverviewPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]), "appname", "true"}, {ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801", (String)"RoleRightOverviewPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), "entnum", "false"}, {ResManager.loadKDString((String)"\u8868\u5355", (String)"RoleRightOverviewPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]), "entname", "true"}};

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        for (String[] listColumn : listColumns) {
            columns.add(this.createListColumn(listColumn));
        }
    }

    private ListColumn createListColumn(String[] arr) {
        ListColumn listColumn = new ListColumn();
        String flag = arr[1];
        LocaleString caption = new LocaleString(arr[0]);
        listColumn.setCaption(caption);
        listColumn.setFieldName(flag);
        listColumn.setKey(flag);
        listColumn.setListFieldKey(flag);
        listColumn.setColumnFilter(true);
        listColumn.setBlankFieldCanOrderAndFilter(true);
        listColumn.setColumnOrder(true);
        listColumn.setVisible(Objects.equals("true", arr[2]) ? 11 : 0);
        return listColumn;
    }

    public void afterCreateNewData(EventObject e) {
        List roleDimTypeList = (List)this.getView().getFormShowParameter().getCustomParam("roleDimTypeList");
        this.initDimTab(new HashSet<String>(roleDimTypeList));
    }

    private void initDimTab(Set<String> dimTypes) {
        Tab tab = (Tab)this.getControl(TABAP);
        if (dimTypes == null || dimTypes.isEmpty()) {
            return;
        }
        ArrayList<String> allTabKeys = new ArrayList<String>(10);
        ArrayList<Map> items = new ArrayList<Map>(10);
        PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq(null, null, null, null, null);
        List permCtrlTypeList = IsoDimHelper.getPermCtrlTypeList((PermCtrlTypeReq)permCtrlTypeReq);
        String permFormDesc = ConstantsHelper.getPermFormDesc();
        String weiDesc = ConstantsHelper.getWeiDesc();
        if (dimTypes.remove("bos_org")) {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey("bos_org");
            tabPageAp.setName(new LocaleString(IsoDimHelper.getCtrlTypeName((String)"bos_org") + permFormDesc));
            items.add(tabPageAp.createControl());
            allTabKeys.add("bos_org");
        }
        for (PermCtrlType permCtrlType : permCtrlTypeList) {
            String number = permCtrlType.getBizobjectid();
            if (!dimTypes.contains(number)) continue;
            String name = permCtrlType.getName();
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(number);
            if (Objects.equals("bos_objecttype", number)) {
                tabPageAp.setName(new LocaleString(weiDesc + name + permFormDesc));
            } else {
                tabPageAp.setName(new LocaleString(name + permFormDesc));
            }
            items.add(tabPageAp.createControl());
            allTabKeys.add(number);
        }
        tab.addControls(items);
        int size = allTabKeys.size();
        if (size > 0) {
            String firstTabKey = (String)allTabKeys.get(0);
            tab.selectTab(firstTabKey);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab dimTab = (Tab)this.getControl(TABAP);
        dimTab.addTabSelectListener((TabSelectListener)this);
    }

    public void initialize() {
        super.initialize();
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        billlistap.addCreateListColumnsListener(this::beforeCreateListColumns);
        billlistap.addCreateListDataProviderListener(this::beforeCreateListDataProvider);
        billlistap.addSetFilterListener(this::setFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new RoleRightOverviewProvider(this.getPageCache()));
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ArrayList allFilter = new ArrayList(10);
        List qFilters = e.getQFilters();
        allFilter.addAll(qFilters);
        List customQFilters = e.getCustomQFilters();
        allFilter.addAll(customQFilters);
        e.setCustomQFilters(allFilter);
        e.setQFilters(new ArrayList(1));
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        BillList billlistap = (BillList)this.getControl(BILLLISTAP);
        billlistap.refresh();
    }

    private List<Entity> sortAndSub(Set<Entity> entities, int start, int limit, String orderByExpr) {
        if (StringUtils.isEmpty((String)orderByExpr)) {
            return entities.stream().sorted(Comparator.comparing(x -> x.getCloudId() + x.getAppId() + x.getEntityId())).skip(start).limit(limit).collect(Collectors.toList());
        }
        String[] split = orderByExpr.split(",");
        return entities.stream().sorted((o1, o2) -> {
            String o2EntityName;
            String orderStr = split[0];
            String[] split_ = orderStr.split(" ");
            String orderField = split_[0];
            String orderType = split_[1];
            String o1Id = o1.getCloudId() + "|" + o1.getAppId() + "|" + o1.getEntityId();
            String o2Id = o2.getCloudId() + "|" + o2.getAppId() + "|" + o2.getEntityId();
            String o1CloudName = StringUtils.isEmpty((String)o1.getCloudName()) ? "" : o1.getCloudName();
            String o2CloudName = StringUtils.isEmpty((String)o2.getCloudName()) ? "" : o2.getCloudName();
            String o1AppNumber = StringUtils.isEmpty((String)o1.getAppNumber()) ? "" : o1.getAppNumber();
            String o2AppNumber = StringUtils.isEmpty((String)o2.getAppNumber()) ? "" : o2.getAppNumber();
            String o1AppName = StringUtils.isEmpty((String)o1.getAppName()) ? "" : o1.getAppName();
            String o2AppName = StringUtils.isEmpty((String)o2.getAppName()) ? "" : o2.getAppName();
            String o1EntityNumber = StringUtils.isEmpty((String)o1.getEntityNumber()) ? "" : o1.getEntityNumber();
            String o2EntityNumber = StringUtils.isEmpty((String)o2.getEntityNumber()) ? "" : o2.getEntityNumber();
            String o1EntityName = StringUtils.isEmpty((String)o1.getEntityName()) ? "" : o1.getEntityName();
            String string = o2EntityName = StringUtils.isEmpty((String)o2.getEntityName()) ? "" : o2.getEntityName();
            if ("desc".equals(orderType)) {
                if (cloudname.equals(orderField)) {
                    return o1CloudName.compareTo(o2CloudName);
                }
                if (appnum.equals(orderField)) {
                    return o1AppNumber.compareTo(o2AppNumber);
                }
                if (appname.equals(orderField)) {
                    return o1AppName.compareTo(o2AppName);
                }
                if (entnum.equals(orderField)) {
                    return o1EntityNumber.compareTo(o2EntityNumber);
                }
                if (entname.equals(orderField)) {
                    return o1EntityName.compareTo(o2EntityName);
                }
                return o1Id.compareTo(o2Id);
            }
            if (cloudname.equals(orderField)) {
                return o2CloudName.compareTo(o1CloudName);
            }
            if (appnum.equals(orderField)) {
                return o2AppNumber.compareTo(o1AppNumber);
            }
            if (appname.equals(orderField)) {
                return o2AppName.compareTo(o1AppName);
            }
            if (entnum.equals(orderField)) {
                return o2EntityNumber.compareTo(o1EntityNumber);
            }
            if (entname.equals(orderField)) {
                return o2EntityName.compareTo(o1EntityName);
            }
            return o1Id.compareTo(o2Id);
        }).skip(start).limit(limit).collect(Collectors.toList());
    }

    private Set<Entity> filterData(Set<Entity> entities, QFilter[] qFilters) {
        if (null == qFilters || 0 == qFilters.length) {
            return entities;
        }
        entities = entities.stream().filter(x -> {
            boolean finalMatch = true;
            boolean oneMatch = true;
            for (QFilter filter : qFilters) {
                String property = filter.getProperty();
                String cp = filter.getCP();
                Object value = filter.getValue();
                if (cloudname.equals(property)) {
                    oneMatch = StrUtil.matchV((String)x.getCloudName(), (String)cp, (Object)value);
                }
                if (appnum.equals(property)) {
                    oneMatch = StrUtil.matchV((String)x.getAppNumber(), (String)cp, (Object)value);
                }
                if (appname.equals(property)) {
                    oneMatch = StrUtil.matchV((String)x.getAppName(), (String)cp, (Object)value);
                }
                if (entnum.equals(property)) {
                    oneMatch = StrUtil.matchV((String)x.getEntityNumber(), (String)cp, (Object)value);
                }
                if (entname.equals(property)) {
                    oneMatch = StrUtil.matchV((String)x.getEntityName(), (String)cp, (Object)value);
                }
                if (finalMatch && oneMatch) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
        return entities;
    }

    private String getCurDimTabCtrlType() {
        Tab tab = (Tab)this.getControl(TABAP);
        String currentTab = tab.getCurrentTab();
        return currentTab;
    }

    private class RoleRightOverviewProvider
    extends ListDataProvider {
        private IPageCache pageCache;

        public RoleRightOverviewProvider(IPageCache pageCache) {
            this.pageCache = pageCache;
        }

        public int getMaxCount() {
            String maxCount = this.pageCache.get("PERM_MAXCOUNT");
            return StringUtils.isEmpty((String)maxCount) ? 0 : Integer.parseInt(maxCount);
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String curDimTabCtrlType = RoleRightOverviewPlugin.this.getCurDimTabCtrlType();
            String rId = (String)RoleRightOverviewPlugin.this.getView().getFormShowParameter().getCustomParam("rId");
            String roleType = (String)RoleRightOverviewPlugin.this.getView().getFormShowParameter().getCustomParam("roleType");
            Map roleDimTypeEntityMap = null;
            if (Objects.equals("comrole", roleType)) {
                roleDimTypeEntityMap = PermRoleHelper.getRoleDimTypeEntityMap((Set)Sets.newHashSet((Object[])new String[]{rId}), (Set)Sets.newHashSet((Object[])new String[]{curDimTabCtrlType}));
            } else if (Objects.equals("busirole", roleType)) {
                roleDimTypeEntityMap = PermBusiRoleHelper.getRoleDimTypeEntityMap((Set)Sets.newHashSet((Object[])new String[]{rId}), (Set)Sets.newHashSet((Object[])new String[]{curDimTabCtrlType}));
            }
            if (null == roleDimTypeEntityMap || roleDimTypeEntityMap.isEmpty()) {
                this.getQueryResult().setDataCount(0);
                this.getQueryResult().setCollection(null);
                return new DynamicObjectCollection(new DynamicObjectType(), null);
            }
            Map roleDimTypeEntity = (Map)roleDimTypeEntityMap.get(rId);
            if (null == roleDimTypeEntity || roleDimTypeEntity.isEmpty()) {
                this.getQueryResult().setDataCount(0);
                this.getQueryResult().setCollection(null);
                return new DynamicObjectCollection(new DynamicObjectType(), null);
            }
            Set entities = (Set)roleDimTypeEntity.get(curDimTabCtrlType);
            if (null == entities || entities.isEmpty()) {
                this.getQueryResult().setDataCount(0);
                this.getQueryResult().setCollection(null);
                return new DynamicObjectCollection(new DynamicObjectType(), null);
            }
            QFilter[] filters = this.getQueryBuilder().getFilters();
            Set afterFilterSet = RoleRightOverviewPlugin.this.filterData(entities, filters);
            String orderByExpr = this.getOrderByExpr();
            List afterSortAndSub = RoleRightOverviewPlugin.this.sortAndSub(afterFilterSet, start, limit, orderByExpr);
            MainEntityType itemType = EntityMetadataCache.getDataEntityType((String)"perm_cloudappentform");
            DynamicObjectCollection resultDoc = new DynamicObjectCollection((DynamicObjectType)itemType, null);
            DynamicObject dyn = null;
            for (Entity entity : afterSortAndSub) {
                dyn = new DynamicObject((DynamicObjectType)itemType);
                dyn.set(RoleRightOverviewPlugin.cloudname, (Object)entity.getCloudName());
                dyn.set(RoleRightOverviewPlugin.appnum, (Object)entity.getAppNumber());
                dyn.set(RoleRightOverviewPlugin.appname, (Object)entity.getAppName());
                dyn.set(RoleRightOverviewPlugin.entnum, (Object)entity.getEntityNumber());
                dyn.set(RoleRightOverviewPlugin.entname, (Object)entity.getEntityName());
                resultDoc.add((Object)dyn);
            }
            QueryResult queryResult = this.getQueryResult();
            int dataCount = afterFilterSet.size();
            queryResult.setDataCount(dataCount);
            queryResult.setCollection(resultDoc);
            this.pageCache.put("PERM_MAXCOUNT", String.valueOf(dataCount));
            return resultDoc;
        }
    }
}

