/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.PublicKey;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.encrypt.impl.RSAEncrypterUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.HttpClientOpenUtils;
import kd.bos.openapi.base.util.ShaSignUtils;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.permission.cache.model.EncryptionScheme;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.plugin.SchemeListPlugin;
import kd.bos.permission.service.scheme.EncryptSchemeService;
import kd.bos.permission.util.SchemeUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public class SchemeDataKeyRepairFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_SCHEME = "scheme";
    private static final String OP_REPAIR = "repair";
    private static final String OPEN_TIPS = "open_tips";
    private static final String CLOSE_TIPS = "close_tips";
    private static final String TIPS_CONTENT = "tips_content";
    private static final Log LOG = LogFactory.getLog(SchemeListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OPEN_TIPS, CLOSE_TIPS});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.openTips();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("id");
        this.getModel().setValue(KEY_SCHEME, schemeId);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (key = ctrl.getKey()) {
            case "open_tips": {
                this.openTips();
                break;
            }
            case "close_tips": {
                this.closeTips();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObject scheme;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)OP_REPAIR) && (scheme = (DynamicObject)this.getModel().getValue(KEY_SCHEME)) == null) {
            e.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u52a0\u5bc6\u65b9\u6848\u4fe1\u606f\u5f02\u5e38\u3002", (String)"SchemeDataKeyRepairFormPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.addLog("null", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)OP_REPAIR)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject scheme = dataEntity.getDynamicObject(KEY_SCHEME);
            String schemeNumber = scheme.getString("number");
            OperationResult result = e.getOperationResult();
            if (!result.isSuccess()) {
                this.addLog(schemeNumber, false);
                return;
            }
            boolean isSuccess = true;
            try {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u4fee\u590d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"SchemeDataKeyRepairFormPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0])));
                boolean repairResult = this.repair(dataEntity);
                if (!repairResult) {
                    isSuccess = false;
                    return;
                }
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            }
            catch (Exception ex) {
                isSuccess = false;
                LOG.error("repair scheme error", (Throwable)ex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u94a5\u8fc1\u79fb\u6570\u636e\u4fee\u590d\u5931\u8d25,\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SchemeDataKeyRepairFormPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
            finally {
                this.getView().hideLoading();
                this.addLog(schemeNumber, isSuccess);
            }
        }
    }

    private boolean repair(DynamicObject dataEntity) throws Exception {
        String state;
        String appSecret;
        String openApiSign;
        String content;
        String url;
        JSONObject result;
        String serverUrl = dataEntity.getString("mc_server_url");
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        if ((result = this.getKmsResult(url = serverUrl + "/kapi/v2/mc/webClient/getKmsDataKey", content = this.getContent(dataEntity), openApiSign = dataEntity.getString("secret_key"), appSecret = dataEntity.getString("key"))).containsKey((Object)"status")) {
            boolean status = result.getBoolean("status");
            if (!status) {
                String message = result.getString("message");
                this.getView().showErrorNotification(this.formatMsgSuffix(message));
                return false;
            }
        } else if (result.containsKey((Object)"state") && StringUtils.equalsIgnoreCase((CharSequence)(state = result.getString("state")), (CharSequence)"error")) {
            String message = result.getString("errorMsg");
            this.getView().showErrorNotification(this.formatMsgSuffix(message));
            return false;
        }
        DynamicObject scheme = dataEntity.getDynamicObject(KEY_SCHEME);
        String dataKey = Encrypters.decode((String)result.getString("data"));
        this.repair(scheme, dataKey);
        return true;
    }

    private void repair(DynamicObject scheme, String dataKey) throws Exception {
        EncryptionScheme es = new EncryptionScheme();
        long schemeId = scheme.getLong("id");
        es.setPkId(schemeId);
        es.setNumber(scheme.getString("number"));
        es.setName(scheme.getString("name"));
        es.setAlgorithm(scheme.getString("algorithm"));
        es.setLength(Integer.parseInt(scheme.getString("length")));
        try {
            EncryptSchemeService service = (EncryptSchemeService)ServiceFactory.getService((String)"EncryptSchemeService");
            String publicKey = service.getPublicKey();
            es.setTrustDataKey(RSAEncrypterUtil.encrypt((String)dataKey, (PublicKey)RSAEncrypterUtil.getPublicKey((String)publicKey)));
            es.setSource("2");
            String schemeKey = service.getSchemeKey(es);
            if (StringUtils.isBlank((CharSequence)schemeKey)) {
                ErrorCode errorCode = new ErrorCode("ERROR_KMS_SK", ResManager.loadKDString((String)"\u5bc6\u94a5\u8fc1\u79fb\u4fee\u590d\u5931\u8d25, schemeKey\u4e3a\u7a7a\u3002", (String)"SchemeDataKeyRepairFormPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                throw new KDException(errorCode, new Object[0]);
            }
            this.repair(schemeId, schemeKey);
        }
        catch (Exception ex) {
            LOG.error("trust DataKey error", (Throwable)ex);
            throw ex;
        }
    }

    private void repair(long schemeId, String schemeKey) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"perm_encryptionscheme");
                scheme.set("scheme_key", (Object)schemeKey);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
                String schemeNumber = scheme.getString("number");
                SchemeUtil.updateSchemeCache((String)String.valueOf(schemeId), (String)schemeNumber, (String)schemeKey);
            }
            catch (Exception ex) {
                handle.markRollback();
                throw ex;
            }
        }
    }

    private void openTips() {
        this.getView().setVisible(Boolean.TRUE, new String[]{TIPS_CONTENT, CLOSE_TIPS});
        this.getView().setVisible(Boolean.FALSE, new String[]{OPEN_TIPS});
    }

    private void closeTips() {
        this.getView().setVisible(Boolean.FALSE, new String[]{TIPS_CONTENT, CLOSE_TIPS});
        this.getView().setVisible(Boolean.TRUE, new String[]{OPEN_TIPS});
    }

    private void addLog(String number, boolean isSuccess) {
        String result = isSuccess ? ResManager.loadKDString((String)"\u6210\u529f", (String)"SchemeDataKeyRepairFormPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"SchemeDataKeyRepairFormPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        String status = isSuccess ? "1" : "0";
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u5bc6\u94a5\u8fc1\u79fb\u6570\u636e\u4fee\u590d", "SchemeDataKeyRepairFormPlugin_6", "bos-permission-formplugin");
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u52a0\u5bc6\u65b9\u6848\uff1a%1$s\uff0c\u5bc6\u94a5\u4fee\u590d%2$s", "SchemeDataKeyRepairFormPlugin_7", "bos-permission-formplugin");
        String[] opDescParam = new String[]{number, result};
        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\uff1a%1$s\uff0c\u5bc6\u94a5\u4fee\u590d%2$s", (String)"SchemeDataKeyRepairFormPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]), number, result);
        String opNameZh_CN = new MultiLangEnumBridge("\u4fee\u590d", "SchemeDataKeyRepairFormPlugin_8", "bos-permission-formplugin").getDescription();
        PermCommonUtil.addLog((String)OP_REPAIR, (String)opNameZh_CN, (String)"perm_scheme_repair", (String)number, (String)status, (String)OP_REPAIR, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, null);
    }

    private String formatMsgSuffix(String message) {
        String localeName = RequestContext.get().getLang().name();
        if (message != null && !message.endsWith("\u3002") && "zh_CN".equals(localeName)) {
            message = message + "\u3002";
        }
        return message;
    }

    private JSONObject getKmsResult(String url, String content, String openApiSign, String appSecret) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("OpenApiAuth", "2");
        String timestamp = DateUtil.convertToStr((String)ShaSignUtils.SIGNATUR_TIME_FORMAT, (Date)new Date());
        headers.put("timestamp", timestamp);
        String uuid = UUID.randomUUID().toString();
        headers.put("signatureNonce", uuid);
        headers.put("openApiSign", openApiSign);
        headers.put("usertype", "Mobile");
        StringBuilder builder = this.getSignatureString(timestamp, uuid, content);
        String encyptString = ShaSignUtils.HMACSHA256StrByKey((String)builder.toString(), (String)appSecret);
        headers.put("signature", encyptString);
        StringEntity entity = new StringEntity(content, "UTF-8");
        entity.setContentType("application/json");
        String result = HttpClientOpenUtils.post((String)url, headers, (HttpEntity)entity);
        return JSON.parseObject((String)result);
    }

    private String getContent(DynamicObject dataEntity) {
        String tenantId = dataEntity.getString("tenant");
        String dcId = dataEntity.getString("datacenter");
        DynamicObject scheme = dataEntity.getDynamicObject(KEY_SCHEME);
        String schemeId = String.valueOf(scheme.getLong("id"));
        JSONObject content = new JSONObject();
        content.put("tenantId", (Object)tenantId);
        content.put("dcId", (Object)dcId);
        content.put("schemeId", (Object)schemeId);
        return JSON.toJSONString((Object)content);
    }

    private StringBuilder getSignatureString(String datetimeString, String signatureNonce, String body) {
        StringBuilder sb = new StringBuilder();
        sb.append(body);
        sb.append(datetimeString);
        sb.append(signatureNonce);
        return sb;
    }
}

