/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.util.SchemeUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SchemeEditPlugin
extends AbstractBasePlugIn {
    private static final String ACTION_TRUST_KEY = "ActionTrustKey";
    private static final String PERM_TRUST_KEY = "perm_trust_key";
    private static final String OP_SUBMIT = "submit";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private Set<String> transformations;
    private Map<String, List<Integer>> lenSupport;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdminUser) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u529f\u80fd\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u64cd\u4f5c\u3002", (String)"SchemeEditPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void initialize() {
        super.initialize();
        this.lenSupport = SchemeUtil.getSupportAlgorithms();
        this.transformations = this.lenSupport.keySet();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit trustKeyEdit = (TextEdit)this.getControl("trust_key");
        trustKeyEdit.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String source = String.valueOf(this.getModel().getValue("source"));
        this.setTrustDataKeyStyle(source);
        ComboEdit algorithmEdit = (ComboEdit)this.getView().getControl("algorithm");
        List<ComboItem> comboItems = this.createAlgorithmComboItems(this.transformations);
        algorithmEdit.setComboItems(comboItems);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        switch (fieldKey = e.getProperty().getName()) {
            case "algorithm": {
                String algorithm = String.valueOf(changeSet[0].getNewValue());
                ComboEdit lengthEdit = (ComboEdit)this.getView().getControl("length");
                List<Integer> lengths = this.lenSupport.get(algorithm);
                List<ComboItem> comboItems = this.createLengthComboItems(lengths);
                if (comboItems.isEmpty()) break;
                lengthEdit.setComboItems(comboItems);
                this.getModel().setValue("length", (Object)lengths.get(0).toString());
                break;
            }
            case "source": {
                String source = String.valueOf(changeSet[0].getNewValue());
                this.setTrustDataKeyStyle(source);
                this.cleatTrustDataKeyValue();
                break;
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)"trust_key")) {
            String algorithm = (String)this.getModel().getValue("algorithm");
            String length = (String)this.getModel().getValue("length");
            if (StringUtils.isBlank((CharSequence)algorithm) || StringUtils.isBlank((CharSequence)length)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u52a0\u5bc6\u7b97\u6cd5\u53ca\u957f\u5ea6\u3002", (String)"SchemeEditPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            this.cleatTrustDataKeyValue();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(PERM_TRUST_KEY);
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("algorithm", (Object)algorithm);
            parameter.setCustomParam("length", (Object)length);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_TRUST_KEY));
            this.getView().showForm(parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)op.getOperateKey(), (CharSequence)OP_SUBMIT)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String source = dataEntity.getString("source");
            String trustDataKey = dataEntity.getString("trust_data_key_tag");
            if (StringUtils.equals((CharSequence)source, (CharSequence)"1") && StringUtils.isBlank((CharSequence)trustDataKey)) {
                String msg = ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u542f\u7528\u4e86\u6258\u7ba1\u6a21\u5f0f\uff0c\u8bf7\u586b\u5199\u6258\u7ba1\u5bc6\u94a5\u3002", (String)"SchemeEditPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                return;
            }
            String number = dataEntity.getString("number");
            dataEntity.set("number", (Object)number.trim());
            this.getView().updateView("number");
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_TRUST_KEY) && (returnData = e.getReturnData()) instanceof String && StringUtils.isNotBlank((CharSequence)((String)returnData))) {
            this.getModel().setValue("trust_key", (Object)"********");
            this.getModel().setValue("trust_data_key", (Object)this.subString((String)returnData));
            this.getModel().setValue("trust_data_key_tag", returnData);
        }
    }

    private void cleatTrustDataKeyValue() {
        this.getModel().setValue("trust_key", null);
        this.getModel().setValue("trust_data_key", null);
        this.getModel().setValue("trust_data_key_tag", null);
    }

    private void setTrustDataKeyStyle(String source) {
        boolean isTrust = StringUtils.equals((CharSequence)source, (CharSequence)"1");
        TextEdit edit = (TextEdit)this.getControl("trust_key");
        edit.setMustInput(isTrust);
        this.getView().setVisible(Boolean.valueOf(isTrust), new String[]{"trust_key"});
    }

    private List<ComboItem> createAlgorithmComboItems(Set<String> algorithms) {
        if (CollectionUtils.isEmpty(algorithms)) {
            return new ArrayList<ComboItem>(0);
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(algorithms.size());
        for (String algorithm : algorithms) {
            ComboItem item = new ComboItem();
            item.setId(algorithm);
            item.setValue(algorithm);
            item.setCaption(new LocaleString(algorithm));
            items.add(item);
        }
        return items;
    }

    private List<ComboItem> createLengthComboItems(List<Integer> lengths) {
        if (CollectionUtils.isEmpty(lengths)) {
            return new ArrayList<ComboItem>(0);
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(lengths.size());
        for (int length : lengths) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(length));
            item.setValue(String.valueOf(length));
            item.setCaption(new LocaleString(String.valueOf(length)));
            items.add(item);
        }
        return items;
    }

    private String subString(String value) {
        int length = value.length();
        if (length > 255) {
            return value.substring(0, 255);
        }
        return value;
    }
}

