/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.encrypt.Encrypters;
import kd.bos.encrypt.impl.RSAEncrypterUtil;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.model.EncryptionScheme;
import kd.bos.permission.cache.model.ExportSchemeInfo;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.service.scheme.EncryptSchemeService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import org.apache.commons.codec.binary.Base64;

public class SchemeImportFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOG = LogFactory.getLog(SchemeImportFormPlugin.class);
    private static final int LOCK_TIMEOUT = 30000;
    private static final String HEADER = "KmsScheme:";
    private static final String TENANT = "tenantId";
    private static final String ACCOUNT = "accountId";
    private static final String CONTENT = "content";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        panel.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent e) {
        Map attachment = (Map)e.getUrls()[0];
        attachment.put("visible", "0001");
        String url = (String)attachment.get("url");
        boolean result = this.importScheme(url);
        this.getView().hideLoading();
        if (result) {
            this.getView().returnDataToParent((Object)"reload");
            this.getView().close();
        } else {
            attachment.put("status", "error");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean importScheme(String url) {
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5e38\u5bfc\u5165\u52a0\u5bc6\u65b9\u6848\u4fe1\u606f\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SchemeImportFormPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0])));
            if (StringUtils.isBlank((CharSequence)url)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"SchemeImportFormPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                this.addImportLog(false);
                return false;
            }
            RequestContext context = RequestContext.get();
            try (DLock lock = DLock.create((String)String.format("importScheme_%s_%s", context.getTenantId(), context.getAccountId()));){
                boolean result;
                if (!lock.tryLock(30000L)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6709\u4eba\u6b63\u5728\u5bfc\u5165\u52a0\u5bc6\u65b9\u6848\uff0c\u8bf7\u7b4930s\u540e\u518d\u5c1d\u8bd5\u3002", (String)"SchemeImportFormPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    this.addImportLog(false);
                    boolean bl2 = false;
                    return bl2;
                }
                TempFileCache service = CacheFactory.getCommonCacheFactory().getTempFileCache();
                try (InputStream stream = service.getInputStream(url);){
                    result = this.importScheme(stream);
                }
                boolean bl = result;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("import encryptionScheme failed", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u4fe1\u606f\u5bfc\u5165\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SchemeImportFormPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.addImportLog(false);
            return false;
        }
    }

    private boolean importScheme(InputStream stream) throws IOException {
        String data = CharStreams.toString((Readable)new InputStreamReader(stream, StandardCharsets.UTF_8));
        if (StringUtils.isBlank((CharSequence)data)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"SchemeImportFormPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.addImportLog(false);
            return false;
        }
        String decryptData = this.decryptData(data);
        if (StringUtils.isBlank((CharSequence)decryptData) || !decryptData.startsWith(HEADER)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u7684\u5185\u5bb9\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"SchemeImportFormPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.addImportLog(false);
            return false;
        }
        JSONObject info = JSON.parseObject((String)decryptData.replace(HEADER, ""));
        String tenantId = info.getString(TENANT);
        String accountId = info.getString(ACCOUNT);
        String content = info.getString(CONTENT);
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)accountId) || StringUtils.isBlank((CharSequence)content)) {
            this.showContentError();
            return false;
        }
        String detail = Encrypters.decode((String)content);
        List schemes = JSON.parseArray((String)detail, ExportSchemeInfo.class);
        if (schemes == null || schemes.isEmpty()) {
            this.showContentError();
            return false;
        }
        RequestContext context = RequestContext.get();
        String curTenantId = context.getTenantId();
        String curAccountId = context.getAccountId();
        if (StringUtils.equals((CharSequence)curTenantId, (CharSequence)tenantId) && StringUtils.equals((CharSequence)curAccountId, (CharSequence)accountId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\u53d8\u66f4\u3002", (String)"SchemeImportFormPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.addImportLog(false);
            return false;
        }
        List<String> numbers = schemes.stream().map(ExportSchemeInfo::getNumber).collect(Collectors.toList());
        List<String> message = this.checkSchemeNumber(numbers);
        if (!message.isEmpty()) {
            if (message.size() == 1) {
                this.getView().showErrorNotification(message.get(0));
            } else {
                OperationResult result = new OperationResult();
                ArrayList errorInfo = new ArrayList(message.size());
                message.forEach(msg -> {
                    OperateErrorInfo errorItem = new OperateErrorInfo("ErrorCode_002", ErrorLevel.Error, null);
                    errorItem.setMessage(msg);
                    errorInfo.add(errorItem);
                });
                result.setBillCount(schemes.size());
                result.setAllErrorInfo(errorInfo);
                result.setSuccessPkIds(new ArrayList());
                result.setSuccess(false);
                this.getView().showOperationResult(result);
            }
            this.addImportLog(false);
            return false;
        }
        return this.importScheme(schemes);
    }

    private boolean importScheme(List<ExportSchemeInfo> schemes) {
        RequestContext context = RequestContext.get();
        String sql = "insert into t_perm_encryptionscheme (fid, falgorithm, flength, fnumber, fname, fenable, fcreatorid, fcreatetime, fissystem, fsource, fschemekey) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String langSql = "insert into t_perm_encryptionscheme_l (fpkid,fid,flocaleid,fname) values (?, ?, ?, ?)";
        int size = schemes.size();
        long[] schemeIds = DB.genLongIds((String)"T_PERM_ENCRYPTIONSCHEME", (int)size);
        String[] schemePkIds = DB.genStringIds((String)"T_PERM_ENCRYPTIONSCHEME_L", (int)size);
        int i = 0;
        ArrayList<Object[]> params = new ArrayList<Object[]>(size);
        ArrayList<Object[]> langParams = new ArrayList<Object[]>(size);
        long userId = context.getCurrUserId();
        String lang = context.getLang().name();
        EncryptSchemeService service = (EncryptSchemeService)ServiceFactory.getService((String)"EncryptSchemeService");
        boolean isSuccess = true;
        for (ExportSchemeInfo scheme : schemes) {
            Object[] param = new Object[11];
            long schemeId = schemeIds[i];
            param[0] = schemeId;
            param[1] = scheme.getAlgorithm();
            param[2] = scheme.getLength();
            param[3] = scheme.getNumber();
            param[4] = scheme.getName();
            param[5] = "1";
            param[6] = userId;
            param[7] = TimeServiceHelper.now();
            param[8] = "0";
            param[9] = "2";
            try {
                EncryptionScheme encryptionScheme = this.getEncryptionScheme(service, schemeId, scheme);
                String schemeKey = encryptionScheme.getSchemeKey();
                param[10] = schemeKey;
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fc1\u79fb\u5bc6\u94a5\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SchemeImportFormPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                this.addImportLog(false);
                isSuccess = false;
                break;
            }
            params.add(param);
            Object[] langParam = new Object[]{schemePkIds[i], schemeId, lang, scheme.getName()};
            langParams.add(langParam);
            ++i;
        }
        if (!isSuccess) {
            return false;
        }
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.base, (String)sql, params);
            DB.executeBatch((DBRoute)DBRoute.base, (String)langSql, langParams);
            this.addImportLog(true);
            boolean param = true;
            return param;
        }
        catch (Exception ex) {
            handle.markRollback();
            LOG.error("save Import Scheme error", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SchemeImportFormPlugin_8", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.addImportLog(false);
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void showContentError() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u7684\u5185\u5bb9\u4e0d\u6b63\u786e\u3002", (String)"SchemeImportFormPlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        this.addImportLog(false);
    }

    private void addImportLog(boolean isSuccess) {
        String result = isSuccess ? ResManager.loadKDString((String)"\u6210\u529f", (String)"SchemeImportFormPlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"SchemeImportFormPlugin_11", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        String status = isSuccess ? "1" : "0";
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u5bfc\u5165", "SchemeImportFormPlugin_15", "bos-permission-formplugin");
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5bfc\u5165%s", "SchemeImportFormPlugin_12", "bos-permission-formplugin");
        String[] opDescParam = new String[]{result};
        String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5bfc\u5165%s", (String)"SchemeImportFormPlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[0]), result);
        PermCommonUtil.addLog(null, null, (String)"perm_encryptionscheme", null, (String)status, (String)"import", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)"secm");
    }

    private List<String> checkSchemeNumber(List<String> numbers) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber from t_perm_encryptionscheme where ", new Object[0]);
        sql.appendIn("fnumber ", numbers.toArray());
        try (DataSet data = DB.queryDataSet((String)"checkSchemeNumber", (DBRoute)DBRoute.base, (SqlBuilder)sql);){
            if (data == null || data.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>(0);
                return arrayList;
            }
            ArrayList<String> exits = new ArrayList<String>();
            for (Row datum : data) {
                String message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u65b9\u6848\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728, \u5bfc\u5165\u5931\u8d25\u3002", (String)"SchemeImportFormPlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]), datum.getString("fnumber"));
                exits.add(message);
            }
            ArrayList<String> arrayList = exits;
            return arrayList;
        }
    }

    private EncryptionScheme getEncryptionScheme(EncryptSchemeService service, long schemeId, ExportSchemeInfo info) throws Exception {
        EncryptionScheme scheme = new EncryptionScheme();
        scheme.setPkId(schemeId);
        scheme.setNumber(info.getNumber());
        scheme.setName(info.getName());
        scheme.setAlgorithm(info.getAlgorithm());
        scheme.setLength(info.getLength());
        String dataKey = info.getDataKey();
        if (StringUtils.isNotBlank((CharSequence)dataKey)) {
            try {
                String publicKey = service.getPublicKey();
                scheme.setTrustDataKey(RSAEncrypterUtil.encrypt((String)dataKey, (PublicKey)RSAEncrypterUtil.getPublicKey((String)publicKey)));
                scheme.setSource("2");
                String schemeKey = service.getSchemeKey(scheme);
                if (StringUtils.isBlank((CharSequence)schemeKey)) {
                    ErrorCode errorCode = new ErrorCode("params_error", ResManager.loadKDString((String)"\u5bc6\u94a5\u8fc1\u79fb\u5931\u8d25, schemeKey\u4e3a\u7a7a\u3002", (String)"SchemeImportFormPlugin_14", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    throw new KDException(errorCode, new Object[0]);
                }
                scheme.setSchemeKey(schemeKey);
            }
            catch (Exception ex) {
                LOG.error("trust DataKey error", (Throwable)ex);
                throw ex;
            }
        } else {
            scheme.setSchemeKey("");
        }
        return scheme;
    }

    private String decryptData(String data) {
        try {
            byte[] bytes = Base64.decodeBase64((String)data);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            LOG.error("decrypt ImportSchemeData Failed", (Throwable)ex);
            return "";
        }
    }
}

