/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dlock.DLock;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.model.ExportSchemeInfo;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.util.SchemeUtil;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class SchemeListPlugin
extends AbstractListPlugin
implements UploadListener {
    private static final String OP_REFRESH = "refresh";
    private static final String OP_EXPORT = "export";
    private static final String OP_REPAIR = "repair";
    private static final String OP_IMPORT = "import";
    private static final String CONFIRM_CALLBACK_ID_EXPORT = "confirmCallbackIdExport";
    private static final String CONFIRM_CALLBACK_ID_REPAIR = "confirmCallbackIdRepair";
    private static final String CONFIRM_CALLBACK_ID_IMPORT = "confirmCallbackIdImport";
    private static final String CLOSE_CALLBACK_ID_IMPORT = "closeCallbackIdImport";
    private static final String HEADER = "KmsScheme:";
    private static final String TENANT = "tenantId";
    private static final String ACCOUNT = "accountId";
    private static final String CONTENT = "content";
    private static final String ACTION_REPAIR_KEY = "RepairKeyAction";
    private static final Log LOG = LogFactory.getLog(SchemeListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (!isAdminUser) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u529f\u80fd\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u64cd\u4f5c\u3002", (String)"SchemeListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        this.getView().setVisible(Boolean.valueOf(isAdminUser), new String[]{OP_REPAIR});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opKey;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        switch (opKey = op.getOperateKey()) {
            case "import": {
                this.beforeImport(e);
                break;
            }
            case "export": {
                this.beforeExport(e);
                break;
            }
            case "repair": {
                this.beforeRepair(e);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        MessageBoxResult result = e.getResult();
        if (result.equals((Object)MessageBoxResult.Cancel)) {
            return;
        }
        switch (callBackId = e.getCallBackId()) {
            case "confirmCallbackIdRepair": {
                this.repairScheme();
                break;
            }
            case "confirmCallbackIdImport": {
                this.importScheme();
                break;
            }
            case "confirmCallbackIdExport": {
                this.exportScheme();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "RepairKeyAction": {
                if (returnData == null || !StringUtils.equals((CharSequence)String.valueOf(returnData), (CharSequence)"success")) break;
                this.getView().invokeOperation(OP_REFRESH);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f\u3002", (String)"SchemeListPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                break;
            }
            case "closeCallbackIdImport": {
                if (returnData == null || !StringUtils.equals((CharSequence)String.valueOf(returnData), (CharSequence)"reload")) break;
                this.getView().invokeOperation(OP_REFRESH);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"SchemeListPlugin_16", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void beforeImport(BeforeDoOperationEventArgs e) {
        e.setCancel(true);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5bc6\u94a5\u5bfc\u5165\u8fc7\u7a0b\u5b58\u5728\u4e00\u5b9a\u7684\u98ce\u9669\u6027\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5bfc\u5165\uff1f", (String)"SchemeListPlugin_32", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_ID_IMPORT, (IFormPlugin)this));
    }

    private void beforeExport(BeforeDoOperationEventArgs e) {
        e.setCancel(true);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5bc6\u94a5\u5bfc\u51fa\u8fc7\u7a0b\u5b58\u5728\u4e00\u5b9a\u7684\u98ce\u9669\u6027\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5bfc\u51fa\uff1f", (String)"SchemeListPlugin_31", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_ID_EXPORT, (IFormPlugin)this));
    }

    private void beforeRepair(BeforeDoOperationEventArgs e) {
        SchemeUtil.resetPublicKeyIntoDb();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u52a0\u5bc6\u65b9\u6848\u3002", (String)"SchemeListPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u52a0\u5bc6\u65b9\u6848\u3002", (String)"SchemeListPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        e.setCancel(true);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5bc6\u94a5\u8fc1\u79fb\u8fc7\u7a0b\u5b58\u5728\u4e00\u5b9a\u7684\u98ce\u9669\u6027\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"SchemeListPlugin_30", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_CALLBACK_ID_REPAIR, (IFormPlugin)this));
    }

    private void repairScheme() {
        ListSelectedRow row = ((IListView)this.getView()).getCurrentSelectedRowInfo();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("perm_scheme_repair");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", row.getPrimaryKeyValue());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_REPAIR_KEY));
        this.getView().showForm(parameter);
    }

    private void importScheme() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("perm_scheme_import");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_ID_IMPORT));
        this.getView().showForm(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportScheme() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        try {
            String publicKey;
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5e38\u5bfc\u51fa\u52a0\u5bc6\u65b9\u6848\u4fe1\u606f\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"SchemeListPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0])));
            if (rows == null || rows.isEmpty()) {
                return;
            }
            Object[] schemeIds = rows.getPrimaryKeyValues();
            List<ExportSchemeInfo> schemes = this.getEncryptionSchemes(schemeIds, publicKey = SchemeUtil.getPublicKey());
            if (schemes.isEmpty()) {
                return;
            }
            this.exportScheme(schemes);
        }
        catch (Exception ex) {
            LOG.error("export encryptionScheme failed", (Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u4fe1\u606f\u5bfc\u51fa\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SchemeListPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            this.addExportErrorLog();
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void exportScheme(List<ExportSchemeInfo> info) throws Exception {
        RequestContext context = RequestContext.get();
        String tenantId = context.getTenantId();
        String accountId = context.getAccountId();
        String data = this.getExportSchemeData(info, tenantId, accountId);
        String exportDate = DateFormatUtils.format((Date)TimeServiceHelper.now(), (String)"yyyyMMddHHmmsssss");
        String fileName = String.format("%s_%s_%s_scheme.txt", tenantId, accountId, exportDate);
        try (DLock lock = DLock.create((String)fileName);){
            lock.tryLock();
            String filePath = "EncryptionScheme" + File.separator + tenantId + File.separator + accountId + File.separator;
            File file = new File(filePath, FilenameUtils.getName((String)fileName));
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6\u4e34\u65f6\u76ee\u5f55\u751f\u6210\u5931\u8d25\u3002", (String)"SchemeListPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                this.addExportErrorLog();
                return;
            }
            String encryptData = this.encryptData(data);
            List<String> numbers = this.getSchemeNumbers(info);
            this.exportScheme(file, fileName, encryptData, numbers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportScheme(File file, String fileName, String data, List<String> numbers) throws Exception {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(data.getBytes(StandardCharsets.UTF_8));
            try (FileInputStream in = new FileInputStream(file);){
                String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 7200);
                this.getView().download(url);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"SchemeListPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                this.addExportSuccessLog(numbers);
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                Files.deleteIfExists(file.toPath());
            }
            catch (Exception ex) {
                LOG.error("end exportScheme failed", (Throwable)ex);
            }
        }
    }

    private void addExportErrorLog() {
        MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u5bfc\u51fa", "SchemeListPlugin_19", "bos-permission-formplugin");
        MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5bfc\u51fa\u5931\u8d25", "SchemeListPlugin_20", "bos-permission-formplugin");
        String oldOpDescription = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25", (String)"SchemeListPlugin_20", (String)"bos-permission-formplugin", (Object[])new Object[0]);
        PermCommonUtil.addLog((String)OP_EXPORT, null, (String)"perm_encryptionscheme", null, (String)"0", (String)OP_EXPORT, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, null, (String)oldOpDescription, null, null, (String)"secm");
    }

    private void addExportSuccessLog(List<String> numbers) {
        if (null == numbers || numbers.isEmpty()) {
            return;
        }
        for (String number : numbers) {
            MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u5bfc\u51fa", "SchemeListPlugin_19", "bos-permission-formplugin");
            MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u52a0\u5bc6\u65b9\u6848\uff1a%s\uff0c\u5bfc\u51fa\u6210\u529f", "SchemeListPlugin_29", "bos-permission-formplugin");
            String[] opDescParam = new String[]{number};
            String oldOpDescription = String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\uff1a%s\uff0c\u5bfc\u51fa\u6210\u529f", (String)"SchemeListPlugin_29", (String)"bos-permission-formplugin", (Object[])new Object[0]), number);
            String opNameZh_CN = new MultiLangEnumBridge("\u5bfc\u51fa", "SchemeListPlugin_33", "bos-permission-formplugin").getDescription();
            PermCommonUtil.addLog((String)OP_EXPORT, (String)opNameZh_CN, (String)"perm_encryptionscheme", (String)number, (String)"1", (String)OP_EXPORT, (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)"secm");
        }
    }

    private List<String> getSchemeNumbers(List<ExportSchemeInfo> rows) {
        ArrayList<String> numbers = new ArrayList<String>(rows.size());
        rows.forEach(row -> numbers.add(row.getNumber()));
        return numbers;
    }

    private List<ExportSchemeInfo> getEncryptionSchemes(Object[] schemeIds, String publicKey) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t1.fid, t1.fnumber, case when (t2.fname = '' or t2.fname is null) then t1.fname else t2.fname end as fname, ", new Object[0]);
        sql.append("t1.falgorithm, t1.flength, t1.fschemekey from t_perm_encryptionscheme t1 ", new Object[0]);
        sql.append("left join t_perm_encryptionscheme_l t2 on t2.fid = t1.fid and t2.flocaleid = ? ", new Object[]{RequestContext.get().getLang().name()});
        sql.appendIn("where t1.fid ", schemeIds);
        try (DataSet data = DB.queryDataSet((String)"getEncryptionSchemesById", (DBRoute)DBRoute.base, (SqlBuilder)sql);){
            if (data == null || data.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u52a0\u5bc6\u65b9\u6848\u4fe1\u606f\u5f02\u5e38\uff0c\u5bfc\u51fa\u5931\u8d25\u3002", (String)"SchemeListPlugin_26", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                this.addExportErrorLog();
                ArrayList<ExportSchemeInfo> arrayList = new ArrayList<ExportSchemeInfo>(0);
                return arrayList;
            }
            ArrayList<ExportSchemeInfo> schemes = new ArrayList<ExportSchemeInfo>();
            HashMap<Long, String> errorScheme = new HashMap<Long, String>();
            for (Object datum : data) {
                long l = datum.getLong("fid");
                String number = datum.getString("fnumber");
                String schemeKey = datum.getString("fschemekey");
                String dataKey = "";
                if (StringUtils.isNotBlank((CharSequence)schemeKey) && StringUtils.isBlank((CharSequence)(dataKey = SchemeUtil.getWorkKey((long)l, (String)publicKey, (String)schemeKey)))) {
                    errorScheme.put(l, number);
                    continue;
                }
                ExportSchemeInfo scheme = new ExportSchemeInfo();
                scheme.setNumber(number);
                String name = datum.getString("fname");
                if (StringUtils.isBlank((CharSequence)name)) {
                    name = number;
                }
                scheme.setName(name);
                scheme.setAlgorithm(datum.getString("falgorithm"));
                scheme.setLength(Integer.parseInt(datum.getString("flength")));
                scheme.setDataKey(dataKey);
                schemes.add(scheme);
            }
            if (errorScheme.isEmpty()) {
                ArrayList<ExportSchemeInfo> arrayList = schemes;
                return arrayList;
            }
            ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(errorScheme.size());
            for (Map.Entry entry : errorScheme.entrySet()) {
                OperateErrorInfo errorItem = new OperateErrorInfo("ErrorCode_001", ErrorLevel.Error, entry.getKey());
                String message = String.format(ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u201c%s\u201d\u83b7\u53d6MC\u7684\u5de5\u4f5c\u5bc6\u94a5\u5931\u8d25\uff0c\u5bfc\u51fa\u5931\u8d25\u3002", (String)"SchemeListPlugin_27", (String)"bos-permission-formplugin", (Object[])new Object[0]), entry.getValue());
                errorItem.setMessage(message);
                errorInfo.add(errorItem);
            }
            if (errorInfo.size() == 1) {
                this.getView().showErrorNotification(((OperateErrorInfo)errorInfo.get(0)).getMessage());
            } else {
                OperationResult result = new OperationResult();
                result.setAllErrorInfo(errorInfo);
                result.setSuccessPkIds(new ArrayList());
                result.setSuccess(false);
            }
            this.addExportErrorLog();
            ArrayList<ExportSchemeInfo> arrayList = new ArrayList<ExportSchemeInfo>(0);
            return arrayList;
        }
    }

    private String getExportSchemeData(List<ExportSchemeInfo> info, String tenantId, String accountId) {
        JSONObject data = new JSONObject();
        data.put(TENANT, (Object)tenantId);
        data.put(ACCOUNT, (Object)accountId);
        data.put(CONTENT, (Object)Encrypters.encode((String)JSON.toJSONString(info)));
        return HEADER + JSON.toJSONString((Object)data);
    }

    private String encryptData(String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        return Base64.encodeBase64String((byte[])bytes);
    }
}

