/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.alibaba.fastjson.JSONObject;
import java.security.PublicKey;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.impl.RSAEncrypterUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.service.scheme.EncryptSchemeService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.ExceptionUtils;

public class SchemeTrustKeyFormPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(SchemeTrustKeyFormPlugin.class);
    private static final String BTN_CONFIRM = "confirm";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)BTN_CONFIRM)) {
            int length;
            String dataKey = (String)this.getModel().getValue("trust_data_key_tag");
            if (StringUtils.isBlank((CharSequence)dataKey)) {
                String msg = ResManager.loadKDString((String)"\u52a0\u5bc6\u65b9\u6848\u542f\u7528\u6258\u7ba1\u6a21\u5f0f\uff0c\u6258\u7ba1\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeTrustKeyFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            EncryptSchemeService service = (EncryptSchemeService)ServiceFactory.getService((String)"EncryptSchemeService");
            String publicKey = service.getPublicKey();
            if (StringUtils.isBlank((CharSequence)publicKey)) {
                String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"SchemeTrustKeyFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                return;
            }
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String algorithm = (String)parameter.getCustomParam("algorithm");
            JSONObject supportResult = service.encrypt(dataKey, algorithm, length = Integer.parseInt((String)parameter.getCustomParam("length")), ResManager.loadKDString((String)"\u5bc6\u94a5\u6d4b\u8bd5", (String)"SchemeTrustKeyFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            boolean isSupport = supportResult.getBoolean("success");
            if (!isSupport) {
                String msg = ResManager.loadKDString((String)"\u5f85\u6258\u7ba1\u5bc6\u94a5\u548c\u6240\u9009\u7684\u52a0\u5bc6\u7b97\u6cd5\u53ca\u957f\u5ea6\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SchemeTrustKeyFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            try {
                this.getView().returnDataToParent((Object)RSAEncrypterUtil.encrypt((String)dataKey, (PublicKey)RSAEncrypterUtil.getPublicKey((String)publicKey)));
                this.getView().close();
            }
            catch (Exception ex) {
                String msg = ResManager.loadKDString((String)"\u6258\u7ba1\u5bc6\u94a5\u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002", (String)"SchemeTrustKeyFormPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                LOG.error(String.format(ResManager.loadKDString((String)"\u6258\u7ba1\u5bc6\u94a5\u52a0\u5bc6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"SchemeTrustKeyFormPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)));
            }
        }
    }
}

