/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SwitchBizRolePlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(SwitchBizRolePlugin.class);
    private static final String BUTTON_KEY = "buttonKey";
    private static final String BUTTON_SET_DEFAULT = "btnsetdefault";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", BUTTON_SET_DEFAULT, "view"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button btn = (Button)source;
            String btnKey = btn.getKey();
            if ("btnclose".equals(btnKey)) {
                this.getPageCache().remove(BUTTON_KEY);
            } else if ("view".equals(btnKey)) {
                String selectRowId = this.getSelectRowId();
                BaseShowParameter param = new BaseShowParameter();
                param.setFormId("perm_busirole");
                param.setPkId((Object)Long.parseLong(selectRowId));
                StyleCss formConfig = new StyleCss();
                formConfig.setWidth("1200px");
                formConfig.setHeight("680px");
                param.getOpenStyle().setInlineStyleCss(formConfig);
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setStatus(OperationStatus.VIEW);
                param.setCustomParam("fromSwitchBizRole", (Object)Boolean.TRUE);
                param.setHasRight(true);
                this.getView().showForm((FormShowParameter)param);
            } else {
                this.getPageCache().put(BUTTON_KEY, btnKey);
            }
        }
    }

    private String getSelectRowId() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        int row = billList.getEntryState().getFocusRow();
        logger.debug("getSelectRowData -- row:" + row);
        if (row > -1) {
            return String.valueOf(billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        }
        return "";
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String btnKey = this.getPageCache().get(BUTTON_KEY);
        if (btnKey != null) {
            PermissionServiceHelper.clearAllCache();
            String bizRoleStr = this.getSelectRowId();
            if (bizRoleStr.equals("")) {
                return;
            }
            Long bizRoleId = Long.valueOf(bizRoleStr);
            boolean setDefault = BUTTON_SET_DEFAULT.equals(btnKey);
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            UserBizRoleCache.setSelBizRole((Long)userId, (Long)bizRoleId);
            if (setDefault) {
                UserBizRoleCache.setUserDefBizRole((Long)userId, (Long)bizRoleId);
            }
            HashMap<String, Long> dataMap = new HashMap<String, Long>();
            dataMap.put("bizRoleId", bizRoleId);
            this.getView().returnDataToParent(dataMap);
        }
    }
}

