/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.MultiLangEnumBridge;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class UrlCheckPermPlugin
extends AbstractFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        UrlCheckPermEnum urlCheckPermEnum;
        List<String> noPermList;
        String formId;
        List<String> onlyCosmicHasPermList;
        super.preOpenForm(e);
        long currUserId = RequestContext.get().getCurrUserId();
        Object source = e.getSource();
        if (source instanceof ListShowParameter) {
            String billFormId;
            onlyCosmicHasPermList = UrlCheckPermPlugin.getOnlyCosmicHasPermList();
            if (onlyCosmicHasPermList.contains(billFormId = ((ListShowParameter)source).getBillFormId())) {
                if (currUserId == 10L) {
                    return;
                }
                e.setCancel(true);
                e.setCancelMessage(UrlCheckPermEnum.ONLYCOSMICHASPERM.noPermMes);
                return;
            }
            List<String> superUserOrSuperAdminHasPermList = UrlCheckPermPlugin.getSuperUserOrSuperAdminHasPermList();
            if (superUserOrSuperAdminHasPermList.contains(billFormId)) {
                boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
                boolean superAdminUser = PermissionServiceHelper.isAdminUser((long)currUserId, (String)"10");
                if (superUser || superAdminUser) {
                    return;
                }
                e.setCancel(true);
                e.setCancelMessage(UrlCheckPermEnum.SUPERUSERORSUPERADMINHASPERM.noPermMes);
                return;
            }
        }
        if (source instanceof BaseShowParameter) {
            BaseShowParameter baseShowParameter;
            onlyCosmicHasPermList = UrlCheckPermPlugin.getOnlyCosmicHasPermList();
            if (onlyCosmicHasPermList.contains(formId = (baseShowParameter = (BaseShowParameter)source).getFormId())) {
                if (currUserId == 10L) {
                    return;
                }
                e.setCancel(true);
                e.setCancelMessage(UrlCheckPermEnum.ONLYCOSMICHASPERM.noPermMes);
                return;
            }
            List<String> superUserOrSuperAdminHasPermList = UrlCheckPermPlugin.getSuperUserOrSuperAdminHasPermList();
            if (superUserOrSuperAdminHasPermList.contains(formId)) {
                boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
                boolean superAdminUser = PermissionServiceHelper.isAdminUser((long)currUserId, (String)"10");
                if (superUser || superAdminUser) {
                    return;
                }
                e.setCancel(true);
                e.setCancelMessage(UrlCheckPermEnum.SUPERUSERORSUPERADMINHASPERM.noPermMes);
                return;
            }
        }
        if (PermCommonUtil.isSuperUser((long)currUserId)) {
            return;
        }
        if (source instanceof ListShowParameter) {
            String billFormId;
            ListShowParameter listShowParameter = (ListShowParameter)source;
            if (listShowParameter.isLookUp()) {
                return;
            }
            noPermList = UrlCheckPermPlugin.getNoPermList();
            if (noPermList.contains(billFormId = ((ListShowParameter)source).getBillFormId())) {
                e.setCancel(true);
                e.setCancelMessage(UrlCheckPermEnum.NOPERM.noPermMes);
                return;
            }
        }
        if (source instanceof BaseShowParameter) {
            BaseShowParameter baseShowParameter = (BaseShowParameter)source;
            noPermList = UrlCheckPermPlugin.getNoPermList();
            if (noPermList.contains(formId = baseShowParameter.getFormId())) {
                e.setCancel(true);
                e.setCancelMessage(UrlCheckPermEnum.NOPERM.noPermMes);
                return;
            }
        }
        if (source instanceof FormShowParameter) {
            FormShowParameter formShowParameter = (FormShowParameter)source;
            noPermList = UrlCheckPermPlugin.getNoPermList();
            if (noPermList.contains(formId = formShowParameter.getFormId())) {
                e.setCancel(true);
                e.setCancelMessage(UrlCheckPermEnum.NOPERM.noPermMes);
                return;
            }
        }
        if (!(urlCheckPermEnum = UrlCheckPermEnum.returnEnumType(e.getSource())).hasPerm) {
            e.setCancel(true);
            e.setCancelMessage(urlCheckPermEnum.noPermMes);
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long currUserId = RequestContext.get().getCurrUserId();
        if (PermCommonUtil.isSuperUser((long)currUserId)) {
            return;
        }
        UrlCheckPermEnum urlCheckPermEnum = UrlCheckPermEnum.returnEnumType(this.getView().getFormShowParameter());
        if (!urlCheckPermEnum.hasPerm) {
            args.setCancel(true);
            this.getView().showErrorNotification(urlCheckPermEnum.noPermMes);
        }
    }

    private static List<String> getOnlyCosmicHasPermList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("perm_useradmintags");
        return list;
    }

    private static List<String> getSuperUserOrSuperAdminHasPermList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("permlog_busitype");
        list.add("perm_admingroupfunperm");
        list.add("perm_admingroupbizunit");
        list.add("perm_admingrouporg");
        list.add("perm_admingroupadduser");
        list.add("perm_admingroupapp");
        list.add("perm_rolefuncperm");
        return list;
    }

    private static List<String> getNoPermList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("bos_usergrouptype");
        list.add("perm_admin");
        list.add("perm_bizobjapp");
        list.add("perm_disfunperm");
        list.add("perm_disfunperm_multype");
        list.add("perm_userfieldperm");
        list.add("perm_rolegroup");
        list.add("perm_fieldperm");
        return list;
    }

    private static enum UrlCheckPermEnum {
        HASPERM(true, ""),
        NOPERM(false, new MultiLangEnumBridge("\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5168\u529f\u80fd\u7528\u6237\uff0c\u65e0\u6743\u8bbf\u95ee\u3002", "UrlCheckPermPlugin_0", "bos-permission-formplugin").loadKDString()),
        ONLYCOSMICHASPERM(false, new MultiLangEnumBridge("\u5f53\u524d\u7528\u6237\u4e0d\u662fcosmic\uff0c\u65e0\u6743\u8bbf\u95ee\u3002", "UrlCheckPermPlugin_1", "bos-permission-formplugin").loadKDString()),
        SUPERUSERORSUPERADMINHASPERM(false, new MultiLangEnumBridge("\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5168\u529f\u80fd\u7528\u6237\u6216\u8d85\u7ea7\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u8bbf\u95ee\u3002", "UrlCheckPermPlugin_2", "bos-permission-formplugin").loadKDString()),
        PERM_USERROLE(PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0XWTKVOQW+ML", (String)"perm_role", (String)"80513208000000ac"), UrlCheckPermEnum.getNoPermMes("perm_role", "80513208000000ac")),
        PERM_USERROLE_MULTYPE(PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0XWTKVOQW+ML", (String)"perm_role", (String)"80513208000000ac"), UrlCheckPermEnum.getNoPermMes("perm_role", "80513208000000ac")),
        PERM_ROLEPERM(PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0XWTKVOQW+ML", (String)"perm_role", (String)"4715a0df000000ac"), UrlCheckPermEnum.getNoPermMes("perm_role", "4715a0df000000ac")),
        PERM_ROLEDATAPERM(PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0XWTKVOQW+ML", (String)"perm_role", (String)"4715a0df000000ac"), UrlCheckPermEnum.getNoPermMes("perm_role", "4715a0df000000ac")),
        PERM_ROLEFIELDPERM(PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0XWTKVOQW+ML", (String)"perm_role", (String)"4715a0df000000ac"), UrlCheckPermEnum.getNoPermMes("perm_role", "4715a0df000000ac")),
        BOS_USERGROUP(PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0XWTKVOQW+ML", (String)"bos_usrgrp", (String)"47150e89000000ac"), UrlCheckPermEnum.getNoPermMes("bos_usrgrp", "47150e89000000ac")),
        PERM_USERBIZROLE(PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0XWTKVOQW+ML", (String)"perm_busirole", (String)"47150e89000000ac"), UrlCheckPermEnum.getNoPermMes("perm_busirole", "47150e89000000ac"));

        private final boolean hasPerm;
        private final String noPermMes;

        private UrlCheckPermEnum(boolean hasPerm, String noPermMes) {
            this.hasPerm = hasPerm;
            this.noPermMes = noPermMes;
        }

        static UrlCheckPermEnum returnEnumType(Object source) {
            try {
                if (source instanceof ListShowParameter) {
                    ListShowParameter listShowParameter = (ListShowParameter)source;
                    String billFormId = listShowParameter.getBillFormId();
                    return UrlCheckPermEnum.valueOf(StringUtils.isEmpty((String)billFormId) ? billFormId : billFormId.toUpperCase());
                }
                return HASPERM;
            }
            catch (Exception e) {
                return HASPERM;
            }
        }

        static String getNoPermMes(String entNum, String permItemId) {
            DynamicObject permItem;
            String entName = "";
            String permItemName = "";
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entNum);
            if (dataEntityType != null) {
                entName = dataEntityType.getDisplayName().getLocaleValue();
            }
            if ((permItem = BusinessDataServiceHelper.loadSingle((Object)permItemId, (String)"perm_permitem")) != null) {
                permItemName = permItem.getString("name");
            }
            String mes = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrlCheckPermPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]), entName, permItemName);
            return mes;
        }
    }
}

