/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.BDLogHelper;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.BizRoleService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.formplugin.preOpenPermFormCheck;
import kd.bos.permission.formplugin.util.PermFormCommonUtil;
import kd.bos.permission.log.helper.PermBusiRoleLogHelper;
import kd.bos.permission.log.helper.PermDirectLogHelper;
import kd.bos.permission.log.helper.PermRoleLogHelper;
import kd.bos.permission.log.model.LogBusiRole;
import kd.bos.permission.log.model.LogCommonRole;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.log.util.PermLogUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;

public class UserAssignBizRolePlugin
extends AbstractFormPlugin
implements preOpenPermFormCheck {
    private static final String ASSIGN_BIZROLE = "assignbizrole";
    private static final String CLASS_NAME = "UserAssignBizRolePlugin";
    private static Log logger = LogFactory.getLog(UserAssignBizRolePlugin.class);
    public static final String ENTITYNAME = "perm_userbizrole";
    public static final String TOOLBARMAIN = "maintoolbar";
    public static final String BARITEM_SAVE = "baritem_save";
    public static final String SELECTED_USER = "user";
    public static final String BIZROLETOOLBAR = "bizroletoolbar";
    public static final String BIZROLE_ENTRY = "bizrole_entry";
    public static final String ADD_BIZROLE = "add_bizrole";
    public static final String BIZROLE = "bizrole";
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";
    public static final String CALLBACKID_UPDATE_CHECK = "continue_close";
    private static final String CLSCALLBCKID_ADDBIZROLE = "CloseCallBackId_addBizRole";
    private static final String PROPERTY_CHANGED_ERROR = "propertyChangedError";
    private List<LogBusiRole> preBizRole = null;

    public void initialize() {
        super.initialize();
        if (!PermCommonUtil.isEnableValidateTime()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{STARTTIME, ENDTIME});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        final IFormView currentView = this.getView();
        this.addItemClickListeners(new String[]{TOOLBARMAIN});
        Toolbar bizroletoolbar = (Toolbar)this.getControl(BIZROLETOOLBAR);
        bizroletoolbar.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if (UserAssignBizRolePlugin.ADD_BIZROLE.equals(itemKey)) {
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"perm_busirole", (boolean)true);
                    lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)UserAssignBizRolePlugin.this, UserAssignBizRolePlugin.CLSCALLBCKID_ADDBIZROLE));
                    UserAssignBizRolePlugin.this.remainBizRoleId(lsp);
                    currentView.showForm((FormShowParameter)lsp);
                }
            }
        });
        BasedataEdit bde = (BasedataEdit)this.getControl(BIZROLE);
        bde.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                ListShowParameter lsp = (ListShowParameter)e.getFormShowParameter();
                UserAssignBizRolePlugin.this.remainBizRoleId(lsp);
            }
        });
        BasedataEdit user = (BasedataEdit)this.getControl(SELECTED_USER);
        user.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent e) {
                ListShowParameter lsp = (ListShowParameter)e.getFormShowParameter();
                List robotIds = PermCommonUtil.getRobotIds();
                e.getCustomQFilters().add(new QFilter("id", "not in", (Object)robotIds));
                UserAssignBizRolePlugin.this.remainBizRoleId(lsp);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        String propName = e.getProperty().getName();
        if (propName.equals(SELECTED_USER)) {
            if (newValue == null) {
                if (oldValue != null) {
                    this.getModel().setValue(e.getProperty().getName(), oldValue);
                    this.getModel().setDataChanged(false);
                }
            } else {
                boolean canSwitchToAnotherUser = false;
                Long newUserId = ((DynamicObject)newValue).getLong("id");
                if (newUserId.equals(1L)) {
                    Long oldUserId;
                    if (oldValue != null && (oldUserId = Long.valueOf(((DynamicObject)oldValue).getLong("id"))).equals(1L)) {
                        return;
                    }
                    this.getModel().setValue(SELECTED_USER, oldValue);
                } else {
                    canSwitchToAnotherUser = true;
                }
                if (canSwitchToAnotherUser) {
                    FormShowParameter param = this.getView().getFormShowParameter();
                    String pageId = this.getView().getPageId();
                    CharSequence[] pageIdSplit = pageId.split("\\|");
                    String oldUserId = pageIdSplit[2];
                    pageIdSplit[2] = String.valueOf(newUserId);
                    String newPageId = String.join((CharSequence)"|", pageIdSplit);
                    IFormView newFv = this.getView().getView(newPageId);
                    if (newFv != null) {
                        this.getModel().setValue(SELECTED_USER, (Object)oldUserId);
                        this.getModel().setDataChanged(false);
                        this.getView().close();
                        newFv.activate();
                        this.getView().sendFormAction(newFv);
                    } else {
                        param.getOpenStyle().setShowType(ShowType.InCurrentForm);
                        param.setPageId(newPageId);
                        StringBuilder sbErrorInfo = new StringBuilder();
                        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                            MutexHelper.release((String)"bos_usergroup_user", (String)ASSIGN_BIZROLE, (String)oldUserId);
                        }
                        if (MutexHelper.require((String)"bos_usergroup_user", (Object)newUserId, (String)ASSIGN_BIZROLE, (boolean)true, (StringBuilder)sbErrorInfo)) {
                            this.getView().setStatus(OperationStatus.EDIT);
                        } else {
                            this.getView().setStatus(OperationStatus.VIEW);
                        }
                        param.setCustomParam("paramUserId", (Object)String.valueOf(newUserId));
                        this.getView().showForm(param);
                        this.getModel().setDataChanged(false);
                    }
                }
            }
        } else if (STARTTIME.equals(propName) || ENDTIME.equals(propName)) {
            if (this.getPageCache().get("pgCache_skipSetDate") != null) {
                this.getPageCache().remove("pgCache_skipSetDate");
                return;
            }
            this.getPageCache().remove(PROPERTY_CHANGED_ERROR);
            if (!this.dateValidate(rowIndex, propName, newValue)) {
                this.getPageCache().put(PROPERTY_CHANGED_ERROR, Boolean.TRUE.toString());
                this.getPageCache().put("pgCache_skipSetDate", "true");
                this.getModel().setValue(propName, oldValue, rowIndex);
            }
        }
    }

    private boolean dateValidate(int rowIndex, String property, Object newValue) {
        if (STARTTIME.equals(property)) {
            Date newStartTime = (Date)newValue;
            Date endTime = (Date)this.getModel().getValue(ENDTIME, rowIndex);
            if (null == newStartTime || endTime == null) {
                return true;
            }
            if (newStartTime.compareTo(endTime) >= 0) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c\u751f\u6548\u65f6\u95f4\u201d\u9700\u5c0f\u4e8e\u201c\u5931\u6548\u65f6\u95f4\u201d\u3002", (String)"BizRoleAssignUserPlugin_19", (String)"bos-permission-formplugin", (Object[])new Object[0]), rowIndex + 1);
                this.getView().showErrorNotification(error);
                return false;
            }
        } else {
            Date newEndTime = (Date)newValue;
            if (null == newEndTime) {
                return true;
            }
            if (newEndTime.before(new Date())) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c\u5931\u6548\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"BizRoleAssignUserPlugin_18", (String)"bos-permission-formplugin", (Object[])new Object[0]), rowIndex + 1);
                this.getView().showErrorNotification(error);
                return false;
            }
            Date startTime = (Date)this.getModel().getValue(STARTTIME, rowIndex);
            if (startTime == null) {
                return true;
            }
            if (newEndTime.compareTo(startTime) <= 0) {
                String error = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u201c\u5931\u6548\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u751f\u6548\u65f6\u95f4\u201d\u3002", (String)"BizRoleAssignUserPlugin_20", (String)"bos-permission-formplugin", (Object[])new Object[0]), rowIndex + 1);
                this.getView().showErrorNotification(error);
                return false;
            }
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLSCALLBCKID_ADDBIZROLE.equals(actionId) && e.getReturnData() instanceof ListSelectedRowCollection) {
            ArrayList<Object[]> selectedRowIds = new ArrayList<Object[]>(10);
            ListSelectedRowCollection selectRows = (ListSelectedRowCollection)e.getReturnData();
            for (ListSelectedRow row : selectRows) {
                Long bizRoleID = (Long)row.getPrimaryKeyValue();
                selectedRowIds.add(new Object[]{bizRoleID});
            }
            this.fillBizRoleList(selectedRowIds);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String userID = (String)this.getView().getFormShowParameter().getCustomParam("paramUserId");
        this.getModel().setValue(SELECTED_USER, (Object)userID);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        OperationStatus status = fsp.getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            UserHelper.addEditingPermUserId((List)Lists.newArrayList((Object[])new String[]{userID}));
        }
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        ArrayList<Object[]> bizRoleList = new ArrayList<Object[]>(100);
        String selectFields = "bizrole.id";
        if (enableValidateTime) {
            selectFields = selectFields + ",starttime,endtime";
        }
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"UserAssignBizRolePlugin.afterCreateNewData", (String)ENTITYNAME, (String)selectFields, (QFilter[])new QFilter[]{new QFilter(SELECTED_USER, "=", (Object)Long.valueOf(userID))}, (String)"bizrole.id desc");){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                Long roleID = row.getLong("bizrole.id");
                if (enableValidateTime) {
                    Date startTime = row.getDate(STARTTIME);
                    Date endTime = row.getDate(ENDTIME);
                    bizRoleList.add(new Object[]{roleID, startTime, endTime});
                    continue;
                }
                bizRoleList.add(new Object[]{roleID});
            }
        }
        this.fillBizRoleList(bizRoleList);
    }

    private void fillBizRoleList(List<Object[]> bizRoleList) {
        if (bizRoleList == null || bizRoleList.isEmpty()) {
            return;
        }
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        this.getModel().beginInit();
        for (int i = 0; i < bizRoleList.size(); ++i) {
            int newEntryRow = this.getModel().createNewEntryRow(BIZROLE_ENTRY);
            this.getModel().setEntryCurrentRowIndex(BIZROLE_ENTRY, newEntryRow);
            this.getModel().setValue(BIZROLE, bizRoleList.get(i)[0], newEntryRow);
            if (!enableValidateTime) continue;
            if (bizRoleList.get(i).length > 1 && bizRoleList.get(i)[1] != null) {
                this.getModel().setValue(STARTTIME, bizRoleList.get(i)[1], newEntryRow);
            }
            if (bizRoleList.get(i).length <= 2 || bizRoleList.get(i)[2] == null) continue;
            this.getModel().setValue(ENDTIME, bizRoleList.get(i)[2], newEntryRow);
        }
        this.getModel().endInit();
        this.getView().updateView(BIZROLE_ENTRY);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BARITEM_SAVE.equals(itemKey)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("name", BARITEM_SAVE);
            param.put("duration", 0);
            param.put("async", Boolean.TRUE);
            proxy.addAction("addClientCallBack", param);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (BARITEM_SAVE.equals(e.getName())) {
            if (this.getPageCache().get(PROPERTY_CHANGED_ERROR) == null) {
                this.saveInfo();
            } else {
                this.getPageCache().remove(PROPERTY_CHANGED_ERROR);
            }
        }
    }

    private void saveInfo() {
        IDataModel dataModel = this.getModel();
        DynamicObject userObj = (DynamicObject)dataModel.getValue(SELECTED_USER);
        Long userID = userObj.getLong("id");
        if (null != userID && !Objects.equals(0L, userID)) {
            PermCommonUtil.checkUserEnable((Long)userID, (String)ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4f7f\u7528\u72b6\u6001\u5df2\u88ab\u7981\u7528\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"UserGroupTreeListPlugin_47", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
        String userName = userObj.getString("name");
        String userNumber = userObj.getString("number");
        String formNum = dataModel.getDataEntityType().getName();
        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
        HashMap<Long, Object[]> assignInfo = new HashMap<Long, Object[]>();
        DynamicObjectCollection bizroleCol = dataModel.getEntryEntity(BIZROLE_ENTRY);
        List robotIds = PermCommonUtil.getRobotIds();
        if (robotIds.contains(userID) && bizroleCol.size() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u673a\u5668\u4eba\u7528\u6237\u201d\u4e0d\u53ef\u901a\u8fc7\u201c\u4e1a\u52a1\u89d2\u8272\u201d\u8fdb\u884c\u6388\u6743\u3002", (String)"UserAssignBizRolePlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
        this.modifyDate(bizroleCol, bizRoleIds, assignInfo);
        String langStr = RequestContext.get().getLang().name();
        this.preBizRole = PermDirectLogHelper.getBusiRoleList((Long)userID, (String)langStr);
        try (TXHandle h1 = TX.required();){
            try {
                boolean saveResult;
                String preData = "";
                if (PermCommonUtil.isEnablePermLog()) {
                    preData = PermDirectLogHelper.userAssignBusiRoleSaveImage((Long)userID, (String)langStr, (boolean)false);
                }
                boolean clearResult = BizRoleService.clearBizRoleUserBundingByUserId((Long)userID, (StringBuilder)new StringBuilder());
                String errorInfo = ResManager.loadKDString((String)"\u7528\u6237\u5206\u914d\u4e1a\u52a1\u89d2\u8272\u5931\u8d25", (String)"UserAssignBizRolePlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]);
                if (!clearResult) {
                    throw new KDException(new ErrorCode(CLASS_NAME, errorInfo), new Object[]{errorInfo});
                }
                if (!assignInfo.isEmpty() && !(saveResult = BizRoleService.userBundleBizRole((Long)userID, assignInfo, (StringBuilder)new StringBuilder()))) {
                    throw new KDException(new ErrorCode(CLASS_NAME, errorInfo), new Object[]{errorInfo});
                }
                if (PermCommonUtil.isEnablePermLog()) {
                    String afterData = PermDirectLogHelper.userAssignBusiRoleSaveImage((Long)userID, (String)langStr, (boolean)true);
                    String opbtn = ConstantsHelper.getSave();
                    this.userAssignBusiRoleSave2PermLog(BARITEM_SAVE, opbtn, String.valueOf(userID), userNumber, userName, preData, afterData);
                }
                String curLogAppId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
                MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u7528\u6237\u5206\u914d\u4e1a\u52a1\u89d2\u8272", "UserAssignBizRolePlugin_4", "bos-permission-formplugin");
                MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5bf9\u7528\u6237\uff1a%1$s (id = %2$s) \u5206\u914d\u4e1a\u52a1\u89d2\u8272\uff0c\u64cd\u4f5c\u6210\u529f\u3002", "UserAssignBizRolePlugin_13", "bos-permission-formplugin");
                String[] opDescParam = new String[]{userName, String.valueOf(userID)};
                String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5bf9\u7528\u6237\uff1a%1$s (id = %2$s) \u5206\u914d\u4e1a\u52a1\u89d2\u8272\uff0c\u64cd\u4f5c\u6210\u529f\u3002", (String)"UserAssignBizRolePlugin_13", (String)"bos-permission-formplugin", (Object[])new Object[0]), userName, String.valueOf(userID));
                PermCommonUtil.addLog(null, null, (String)formNum, (String)userNumber, (String)"1", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserAssignBizRolePlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                this.getModel().setDataChanged(false);
                UserHasPermOrgCache.clearUserLoginOrgs((Long)userID);
                UserHasPermDimObjCache.removeCache((Long)userID);
                ThreadPools.executeOnceIncludeRequestContext((String)CLASS_NAME, () -> UserAssignBizRolePlugin.asyncLicGroupByBizAppAndBizObj(userID, bizRoleIds));
                CacheMrg.clearAllCache();
                if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                    this.cancelShowFormRights(userID, langStr);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                String curLogAppId = AppHelper.getCurAppId((String)ENTITYNAME, (String)this.getView().getFormShowParameter().getAppId());
                MultiLangEnumBridge opNameLangEnumBridge = new MultiLangEnumBridge("\u7528\u6237\u5206\u914d\u4e1a\u52a1\u89d2\u8272", "UserAssignBizRolePlugin_4", "bos-permission-formplugin");
                MultiLangEnumBridge opDescLangEnumBridge = new MultiLangEnumBridge("\u5bf9\u7528\u6237\uff1a%1$s (id = %2$s) \u5206\u914d\u4e1a\u52a1\u89d2\u8272\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", "UserAssignBizRolePlugin_14", "bos-permission-formplugin");
                String[] opDescParam = new String[]{userName, String.valueOf(userID)};
                String oldOpDescription = String.format(ResManager.loadKDString((String)"\u5bf9\u7528\u6237\uff1a%1$s (id = %2$s) \u5206\u914d\u4e1a\u52a1\u89d2\u8272\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"UserAssignBizRolePlugin_14", (String)"bos-permission-formplugin", (Object[])new Object[0]), userName, String.valueOf(userID));
                PermCommonUtil.addLog(null, null, (String)ENTITYNAME, (String)userNumber, (String)"0", (String)"save", (MultiLangEnumBridge)opNameLangEnumBridge, (MultiLangEnumBridge)opDescLangEnumBridge, (String[])opDescParam, (String)oldOpDescription, null, null, (String)curLogAppId);
                h1.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"UserAssignBizRolePlugin_9", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void modifyDate(DynamicObjectCollection bizroleCol, Set<Long> bizRoleIds, Map<Long, Object[]> assignInfo) {
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        for (DynamicObject object : bizroleCol) {
            DynamicObject dynamicObject = object.getDynamicObject(BIZROLE);
            if (dynamicObject == null) continue;
            Long objId = dynamicObject.getLong("id");
            bizRoleIds.add(objId);
            if (enableValidateTime) {
                Date startTime = object.getDate(STARTTIME);
                Date endTime = object.getDate(ENDTIME);
                assignInfo.put(objId, new Object[]{startTime, endTime});
                continue;
            }
            assignInfo.put(objId, new Object[0]);
        }
    }

    private void cancelShowFormRights(Long userID, String langStr) {
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        userIds.add(userID);
        FormConfigFactory.cancelShowFormRights(userIds);
        List afterBizRole = PermDirectLogHelper.getBusiRoleList((Long)userID, (String)langStr);
        List diffBizRole = LogBusiRole.logCompare(this.preBizRole, (List)afterBizRole);
        if (!CollectionUtils.isEmpty((Collection)diffBizRole)) {
            HashSet appEntityAllSet = new HashSet(16);
            HashSet commonRoles = new HashSet(16);
            HashSet<String> roleIds = new HashSet<String>(16);
            for (LogBusiRole bizRole : diffBizRole) {
                List commonRoleList = PermBusiRoleLogHelper.getCommonRoleList((Long)Long.parseLong(bizRole.getBizRoleId()), (String)langStr);
                Set collect = commonRoleList.stream().filter(x -> "1".equals(x.getEnable())).collect(Collectors.toSet());
                commonRoles.addAll(collect);
            }
            for (LogCommonRole commonRole : commonRoles) {
                roleIds.add(commonRole.getRoleId());
            }
            for (String roleId : roleIds) {
                appEntityAllSet.addAll(PermRoleLogHelper.getNewDataRule((String)roleId, (String)langStr).getNewDRAppEntitySet());
            }
            if (!CollectionUtils.isEmpty(appEntityAllSet)) {
                List appEntityAllList = appEntityAllSet.stream().map(x -> {
                    String[] split = x.split("\\|", 2);
                    HashMap<String, String> map = new HashMap<String, String>(2);
                    map.put(split[0], split[1]);
                    return map;
                }).collect(Collectors.toList());
                FormConfigFactory.cancelShowFormDataRights(userIds, appEntityAllList);
            }
        }
    }

    private void userAssignBusiRoleSave2PermLog(String op, String opbtn, String opItemId, String opItemNumber, String opItemName, String preData, String afterData) {
        try {
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", PermLogUtil.getPermLogFnumber());
            PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"userassignbusirole_save");
            map.put("busi_from", null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
            map.put("busi_type", null == permLogBusiType ? "" : permLogBusiType.getBusiType());
            map.put("cloud_id", cloudId);
            map.put("app_id", appId);
            map.put("form_identity", formNum);
            map.put("op", op);
            map.put("opbtn", opbtn);
            map.put("interface_method", "kd.bos.permission.formplugin.plugin.UserAssignBizRolePlugin.userAssignBusiRoleSave2PermLog");
            map.put("op_item_id", opItemId);
            map.put("op_item_number", opItemNumber);
            map.put("op_item_name", opItemName);
            map.put("pre_data", preData);
            map.put("after_data", afterData);
            ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
            list.add(map);
            BDLogInfo info = new BDLogInfo(EnumBDLogType.PERM.getType(), list, true);
            BDLogHelper.addBDLog((BDLogInfo)info);
        }
        catch (Exception e) {
            logger.warn("UserAssignBizRolePlugin.userAssignBusiRoleSave2PermLog error, opItemNumber:{}", (Object)opItemNumber, (Object)e);
        }
    }

    private static void asyncLicGroupByBizAppAndBizObj(Long userid, Set<Long> bizRoleIds) {
        if (bizRoleIds == null || bizRoleIds.isEmpty()) {
            return;
        }
        HashSet commonRoleIds = new HashSet(16);
        HashMap allowAppEntityMap = new HashMap(16);
        for (Long bizRoleId : bizRoleIds) {
            DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole");
            DynamicObjectCollection bizRoleCommRoleDoc = bizRoleObj.getDynamicObjectCollection("bizrolecomrole");
            bizRoleCommRoleDoc.stream().forEach(bizRoleCommRole -> commonRoleIds.add(bizRoleCommRole.getDynamicObject("role").getString("id")));
            List bizRolePermList = BizRoleService.getBizRolePermByBizRoleId((Long)bizRoleId);
            bizRolePermList.stream().forEach(bizRolePerm -> {
                List entityTypeIdlist = allowAppEntityMap.computeIfAbsent(bizRolePerm.getBizappid(), k -> new ArrayList(16));
                if (!entityTypeIdlist.contains(bizRolePerm.getEntitytypeid())) {
                    entityTypeIdlist.add(bizRolePerm.getEntitytypeid());
                }
            });
        }
        ArrayList commonRoleIdList = new ArrayList();
        commonRoleIdList.addAll(commonRoleIds);
        if (!commonRoleIdList.isEmpty()) {
            StringBuilder roleFunSB = new StringBuilder("select distinct rpd.fbizappid,rpd.fentitytypeid ");
            roleFunSB.append(" from t_perm_rolepermdetial rpd ");
            String commonRoleIdStr = "'" + String.join((CharSequence)"','", commonRoleIdList) + "'";
            roleFunSB.append(" where rpd.froleid in(").append(commonRoleIdStr).append(")");
            DB.query((DBRoute)DBRoute.permission, (String)roleFunSB.toString(), rs -> {
                while (rs.next()) {
                    String appid = rs.getString("fbizappid");
                    String entityTypeID = rs.getString("fentitytypeid");
                    List entityTypeIdlist = allowAppEntityMap.computeIfAbsent(appid, k -> new ArrayList(16));
                    if (entityTypeIdlist.contains(entityTypeID)) continue;
                    entityTypeIdlist.add(entityTypeID);
                }
                return null;
            });
        }
        if (!allowAppEntityMap.isEmpty()) {
            LicenseServiceHelper.addUserLicGroupByBizAppAndBizObj((Long)userid, allowAppEntityMap);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject user;
        boolean ifChanged;
        super.beforeClosed(e);
        IDataModel model = this.getModel();
        boolean bl = ifChanged = e.isCheckDataChange() && model.getDataChanged();
        if (ifChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALLBACKID_UPDATE_CHECK, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"UserAssignBizRolePlugin_10", (String)"bos-permission-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            e.setCancel(true);
        }
        if (null != (user = (DynamicObject)this.getModel().getValue(SELECTED_USER))) {
            Long userId = user.getLong("id");
            if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
                MutexHelper.release((String)"bos_usergroup_user", (String)ASSIGN_BIZROLE, (String)String.valueOf(userId));
                UserHelper.delEditingPermUserId((List)Lists.newArrayList((Object[])new String[]{userId + ""}));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if (callBackId.equals(CALLBACKID_UPDATE_CHECK) && e.getResult() == MessageBoxResult.Yes) {
            PermFormCommonUtil.closeClientForm(this.getView());
        }
    }

    private String getChangeInfo(Map<Object, DynamicObject> map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (DynamicObject obj : map.values()) {
            sb.append(obj.getString("number"));
            if (i < map.size() - 1) {
                sb.append(',');
            }
            ++i;
        }
        return sb.toString();
    }

    private void remainBizRoleId(ListShowParameter lsp) {
        ArrayList<Long> bizRoleList = new ArrayList<Long>(50);
        int rowCount = this.getModel().getEntryRowCount(BIZROLE_ENTRY);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject bizRoleObj = (DynamicObject)this.getModel().getValue(BIZROLE, i);
            if (bizRoleObj == null) continue;
            Long bizRoleId = bizRoleObj.getLong("id");
            bizRoleList.add(bizRoleId);
        }
        QFilter bizrolef7QFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        lsp.getListFilterParameter().getQFilters().add(bizrolef7QFilter);
        lsp.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", bizRoleList));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.preOpenPermForm(e);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.isAdminUser((long)userId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5168\u529f\u80fd\u7528\u6237\uff0c\u4e5f\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u6b64\u529f\u80fd", (String)"UserAssignBizRolePlugin_12", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            return;
        }
    }
}

