/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboEdit;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.model.log.UsrGrpUser;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.AssignModEnum;
import kd.bos.permission.enums.GrpUsrFromTypeEnum;
import kd.bos.permission.formplugin.plugin.UserGroupTemplateTreePlugin;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.model.perm.req.PermLogReq;
import kd.bos.permission.model.perm.req.UserAssignUserGroupReq;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;

public class UserAssignUsrGrpPlugin
extends AbstractListPlugin {
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static Log logger = LogFactory.getLog(UserAssignUsrGrpPlugin.class);
    private static final String USERGROUP_TREE = "usergrouptree";
    private static final String ROOTNODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String BTN_SEARCH = "searchap";

    public void initialize() {
        this.addClickListeners(new String[]{"btnsave", "btnadd"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search userGroupTreeSearch = (Search)this.getControl(BTN_SEARCH);
        if (userGroupTreeSearch != null) {
            TreeView tree = (TreeView)this.getControl(USERGROUP_TREE);
            Long usrGrpStd = null;
            try {
                Object usrgrpstd = this.getModel().getValue("usrgrpstd");
                usrGrpStd = null == usrgrpstd ? PermHelperConst.NOTCLASSIFY_STDID : Long.valueOf((String)usrgrpstd);
            }
            catch (Exception ex) {
                usrGrpStd = PermHelperConst.NOTCLASSIFY_STDID;
            }
            Long finalUsrGrpStd = usrGrpStd;
            userGroupTreeSearch.addEnterListener(k -> UserGroupTemplateTreePlugin.setSearchEvent(k, tree, finalUsrGrpStd));
        }
    }

    public void afterCreateNewData(EventObject e) {
        UserGroupService.initTree((TreeView)((TreeView)this.getView().getControl(USERGROUP_TREE)), (String)ROOTNODE_ID);
        String isFromPermPage = (String)this.getView().getFormShowParameter().getCustomParam("isFromPermPage");
        ComboEdit comboEdit = (ComboEdit)this.getControl("usrgrpstd");
        comboEdit.setMustInput(true);
        if (StringUtils.isNotEmpty((String)isFromPermPage) && "true".equals(isFromPermPage)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"usrgrpstd"});
        } else {
            comboEdit.setComboItems(UserGroupService.getAllUsrGrpStd());
        }
        this.getModel().setValue("usrgrpstd", (Object)"1404221671421785088");
        String usersId = (String)this.getView().getFormShowParameter().getCustomParam("userIds");
        if (usersId == null) {
            return;
        }
        String[] userIds = usersId.split(",");
        if (userIds.length > 1) {
            return;
        }
        QFilter[] qfArr = new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(userIds[0]))};
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"bos_usergroupstaff", (String)"id, usergroup", (QFilter[])qfArr);
        if (col.length != 0) {
            for (int i = 0; i < col.length; ++i) {
                int row = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("usergroupnum", col[i].get("usergroup"), row);
            }
            this.getView().updateView("entryentity");
            this.getModel().setDataChanged(false);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btnsave": {
                this.save();
                break;
            }
            case "btnadd": {
                TreeView tree = (TreeView)this.getControl(USERGROUP_TREE);
                List selectedNodeIdList = tree.getTreeState().getSelectedNodeId();
                if (selectedNodeIdList.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6811\u8282\u70b9\u3002", (String)"UserAssignUsrGrpPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                tree.uncheckNodes(selectedNodeIdList);
                selectedNodeIdList.remove(ROOTNODE_ID);
                HashSet<String> selectNodeIdSet = new HashSet<String>(8);
                for (String nodeId : selectedNodeIdList) {
                    selectNodeIdSet.add(nodeId.split("-")[0]);
                }
                EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
                DynamicObject[] dataEntitys = entryEntity.getEntryData().getDataEntitys();
                for (DynamicObject dynamicObject : dataEntitys) {
                    selectNodeIdSet.remove(dynamicObject.getString("usergroupnum_id"));
                }
                for (String nodeId : selectNodeIdSet) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)"bos_usrgrp");
                    int row = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("usergroupnum", (Object)dynamicObject, row);
                }
                break;
            }
        }
    }

    private void save() {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String[] userIds = ((String)formShowParameter.getCustomParam("userIds")).split(",");
        String[] userNames = ((String)formShowParameter.getCustomParam("userNames")).split(",");
        String[] userNumbers = ((String)formShowParameter.getCustomParam("userNumbers")).split(",");
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        DynamicObject[] dataEntitys = entryEntity.getEntryData().getDataEntitys();
        try {
            Set userIdSet = Arrays.stream(userIds).map(x -> Long.valueOf(x)).collect(Collectors.toSet());
            Set userGrouIdSet = Arrays.stream(dataEntitys).map(x -> x.getLong("usergroupnum_id")).collect(Collectors.toSet());
            Set usrGrpUserList = UserGroupHelper.getUsrGrpUserList(null, userIdSet);
            Map<Long, List<UsrGrpUser>> userGroupMap = usrGrpUserList.stream().collect(Collectors.groupingBy(UsrGrpUser::getUserId));
            int length = userIds.length;
            HashMap cancelUAndGMap = new HashMap(length);
            HashMap increUAndGMap = new HashMap(length);
            for (int i = 0; i < length; ++i) {
                List addUGList;
                List removeUGList;
                String userId = userIds[i];
                Long userIdLong = Long.valueOf(userId);
                List<UsrGrpUser> oriUgUList = userGroupMap.get(userIdLong);
                HashSet preUgIdSet = CollectionUtils.isEmpty(oriUgUList) ? new HashSet(1) : oriUgUList.stream().map(x -> x.getUsrGrpId()).collect(Collectors.toSet());
                HashSet tempSet = new HashSet(userGrouIdSet);
                if (length > 1) {
                    tempSet.addAll(preUgIdSet);
                }
                if (!CollectionUtils.isEmpty((Collection)(removeUGList = ListUtil.removeAll(new LinkedList(preUgIdSet), new LinkedList(tempSet))))) {
                    cancelUAndGMap.put(userIdLong, new HashSet(removeUGList));
                }
                if (CollectionUtils.isEmpty((Collection)(addUGList = ListUtil.removeAll(new LinkedList(tempSet), new LinkedList(preUgIdSet))))) continue;
                increUAndGMap.put(userIdLong, new HashSet(addUGList));
            }
            if (!CollectionUtils.isEmpty(cancelUAndGMap) || !CollectionUtils.isEmpty(increUAndGMap)) {
                GrpUsrFromTypeEnum grpUsrFromTypeEnum = GrpUsrFromTypeEnum.HAND_ADD;
                String reason = "UserAssignUsrGrpPlugin.save, " + grpUsrFromTypeEnum.getDesc();
                PermLogReq permLogReq = this.getPermLogReq(1 == length ? userIds[0] : " ", 1 == length ? userNumbers[0] : " ", 1 == length ? userNames[0] : " ");
                ArrayList<UserAssignUserGroupReq> reqList = new ArrayList<UserAssignUserGroupReq>(2);
                reqList.add(new UserAssignUserGroupReq(cancelUAndGMap, AssignModEnum.ASSIGNMODE_CANCEL, grpUsrFromTypeEnum, reason));
                reqList.add(new UserAssignUserGroupReq(increUAndGMap, AssignModEnum.ASSIGNMODE_INCREMENT, grpUsrFromTypeEnum, reason));
                UserGroupService.userAssignUserGroupWithPermLog(reqList, (PermLogReq)permLogReq);
            }
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"UserAssignUsrGrpPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            view.sendFormAction(parentView);
            view.close();
        }
        catch (Exception e) {
            logger.warn("kd.bos.permission.formplugin.plugin.UserAssignUsrGrpPlugin.save error", (Throwable)e);
            view.showErrMessage(e.getMessage(), ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"UserAssignUsrGrpPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private PermLogReq getPermLogReq(String opItemId, String opItemNumber, String opItemName) {
        PermLogReq permLogReq = new PermLogReq();
        boolean enablePermLog = PermCommonUtil.isEnablePermLog();
        if (!enablePermLog) {
            permLogReq.setSignPermLog(Boolean.FALSE);
            return permLogReq;
        }
        permLogReq.setSignPermLog(Boolean.TRUE);
        PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"user_assign_ug");
        permLogReq.setBusiFrom(null == permLogBusiType ? "" : permLogBusiType.getBusiTypeDesc());
        permLogReq.setBusiType(null == permLogBusiType ? "" : permLogBusiType.getBusiType());
        String formNum = "bos_userassignusrgrp";
        String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
        permLogReq.setAppId(appId);
        permLogReq.setFormIdentity(formNum);
        permLogReq.setOp("btnsave");
        permLogReq.setOpbtn(ConstantsHelper.getSureDesc());
        permLogReq.setInterfaceMethod("kd.bos.permission.formplugin.plugin.UserAssignUsrGrpPlugin.save");
        permLogReq.setOpItemId(opItemId);
        permLogReq.setOpItemNumber(opItemNumber);
        permLogReq.setOpItemName(opItemName);
        permLogReq.setOperTime(TimeServiceHelper.now());
        permLogReq.setClientType(RequestContext.get().getClient());
        permLogReq.setClientIp(RequestContext.get().getLoginIP());
        return permLogReq;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        if ("usrgrpstd".equals(proName) && StringUtils.isNotEmpty((String)(newValue = (String)e.getChangeSet()[0].getNewValue()))) {
            TreeView treeView = (TreeView)this.getControl(USERGROUP_TREE);
            UserGroupService.initTree((TreeView)treeView, (String)ROOTNODE_ID, (Long)Long.parseLong(newValue));
            this.getView().getPageCache().put("focusNodeParentId", "");
            treeView.treeNodeClick("", ROOTNODE_ID);
        }
    }
}

