/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;

public class UserCopyPermPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(UserCopyPermPlugin.class);
    private static final String PROP_TARGETUSER = "targetuser";
    private static final String PROP_COPYROLE = "copyrole";
    private static final String PROP_COPYBIZROLE = "copybizrole";
    private static final String PROP_COPYDISFUNPERM = "copydisfunperm";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String CONFIRMCALLBACK_SAVE = "confirmcallback_save";

    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
        this.addListener();
    }

    private void addListener() {
        BasedataEdit bde = (BasedataEdit)this.getControl(PROP_TARGETUSER);
        String strUserId = (String)this.getView().getFormShowParameter().getCustomParam("paramUserId");
        ArrayList<Long> userList = new ArrayList<Long>(2);
        userList.add(Long.valueOf(strUserId));
        userList.add(RequestContext.get().getCurrUserId());
        QFilter qFilter = new QFilter("id", "not in", userList);
        qFilter.and(new QFilter("usertype", "!=", (Object)"6"));
        bde.setQFilter(qFilter);
        String showForSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if (!"true".equals(showForSpecial)) {
            bde.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent e) {
                    e.getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        String strUserId = (String)this.getView().getFormShowParameter().getCustomParam("paramUserId");
        this.getModel().setValue("originuser", (Object)Long.parseLong(strUserId));
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "btnsave": {
                IDataModel model = this.getModel();
                Object targetUserObjs = model.getValue(PROP_TARGETUSER);
                if (targetUserObjs == null || targetUserObjs instanceof DynamicObjectCollection && ((DynamicObjectCollection)targetUserObjs).size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u76ee\u6807\u7528\u6237\u201d\u3002", (String)"UserCopyPermPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                boolean isCopyRole = (Boolean)model.getValue(PROP_COPYROLE);
                boolean isCopyBizRole = (Boolean)model.getValue(PROP_COPYBIZROLE);
                boolean isCopyDisfunperm = (Boolean)model.getValue(PROP_COPYDISFUNPERM);
                boolean isCopyUserperm = (Boolean)model.getValue("copyuserperm");
                if (!(isCopyRole || isCopyDisfunperm || isCopyUserperm || isCopyBizRole)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u590d\u5236\u7684\u6743\u9650\u3002", (String)"UserCopyPermPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return;
                }
                DynamicObject sourceUser = (DynamicObject)model.getValue("originuser");
                String sourceUserName = sourceUser.getString("name");
                StringBuilder copyPermType = new StringBuilder();
                if (isCopyRole) {
                    copyPermType.append(ResManager.loadKDString((String)"\u201c\u5df2\u5206\u914d\u901a\u7528\u89d2\u8272\u201d", (String)"UserCopyPermPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0])).append("\u3001");
                }
                if (isCopyBizRole) {
                    copyPermType.append(ResManager.loadKDString((String)"\u201c\u5df2\u5206\u914d\u4e1a\u52a1\u89d2\u8272\u201d", (String)"UserCopyPermPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0])).append("\u3001");
                }
                if (isCopyUserperm) {
                    copyPermType.append(ResManager.loadKDString((String)"\u201c\u76f4\u63a5\u6388\u6743\u6743\u9650\u201d", (String)"UserCopyPermPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0])).append("\u3001");
                }
                if (isCopyDisfunperm) {
                    copyPermType.append(ResManager.loadKDString((String)"\u201c\u76f4\u63a5\u7981\u7528\u6743\u9650\u201d", (String)"UserCopyPermPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0])).append("\u3001");
                }
                copyPermType.deleteCharAt(copyPermType.length() - 1);
                String strCopyPermType = copyPermType.toString();
                StringBuilder message = new StringBuilder();
                message.append(String.format(ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u5c06\u7528\u6237\u201c%1$s\u201d\u7684%2$s\u590d\u5236\u7ed9", (String)"UserCopyPermPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), sourceUserName, strCopyPermType));
                DynamicObjectCollection targetUserCollection = (DynamicObjectCollection)model.getValue(PROP_TARGETUSER);
                int count = targetUserCollection.size();
                boolean isOmit = false;
                if (count > 5) {
                    count = 5;
                    isOmit = true;
                }
                if (!isOmit) {
                    message.append(ResManager.loadKDString((String)"\u7528\u6237", (String)"UserCopyPermPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                message.append("\\r\\n");
                HashSet<Long> userIdSet = new HashSet<Long>(8);
                for (int i = 0; i < count; ++i) {
                    DynamicObject user = ((DynamicObject)targetUserCollection.get(i)).getDynamicObject("fbasedataid");
                    String targetUserName = user.getString("name");
                    message.append('\u201c').append(targetUserName).append("\u201d\uff0c");
                    userIdSet.add(user.getLong("id"));
                }
                message.deleteCharAt(message.length() - 1);
                if (isOmit) {
                    message.append(ResManager.loadKDString((String)"\u7b49", (String)"UserCopyPermPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0])).append(targetUserCollection.size()).append(ResManager.loadKDString((String)"\u4e2a\u7528\u6237\u5417\uff1f", (String)"UserCopyPermPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                } else {
                    message.append(ResManager.loadKDString((String)"\u5417\uff1f", (String)"UserCopyPermPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                if (!this.checkUserRange(userIdSet)) {
                    return;
                }
                this.getView().showConfirm(message.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRMCALLBACK_SAVE, (IFormPlugin)this));
                break;
            }
        }
    }

    private boolean checkUserRange(Set<Long> userIdSet) {
        Set f7Users;
        Set rangeUserIdSet;
        List noPermUserIds;
        String strUserId = (String)this.getView().getFormShowParameter().getCustomParam("paramUserId");
        HashSet<Long> excludeUserIdSet = new HashSet<Long>(2);
        if (kd.bos.util.StringUtils.isNotEmpty((String)strUserId)) {
            excludeUserIdSet.add(Long.valueOf(strUserId));
        }
        excludeUserIdSet.add(RequestContext.get().getCurrUserId());
        HashSet<String> userTypeNotInSet = new HashSet<String>(8);
        userTypeNotInSet.add("6");
        Boolean isOrgBaseAdmin = null;
        String showForSpecial = (String)this.getView().getFormShowParameter().getCustomParam("FormShowParam_ShowForSpecialUser");
        if (!"true".equals(showForSpecial)) {
            isOrgBaseAdmin = Boolean.TRUE;
        }
        if (null != (noPermUserIds = ListUtil.removeAll(new ArrayList<Long>(userIdSet), new ArrayList(rangeUserIdSet = (f7Users = UserHelper.getF7Users((boolean)true, (Boolean)isOrgBaseAdmin, null, excludeUserIdSet, (boolean)true, null, null, userTypeNotInSet)).stream().map(PermUser::getUserId).collect(Collectors.toSet())))) && !noPermUserIds.isEmpty()) {
            Map userInfoMapByIds = UserHelper.getUserInfoMapByIds(new HashSet(noPermUserIds), (String)RequestContext.get().getLang().name());
            StringBuilder sb = new StringBuilder();
            sb.append('\uff1a');
            Long firstUserId = (Long)noPermUserIds.get(0);
            User firstUsr = (User)userInfoMapByIds.get(firstUserId);
            if (null != firstUsr) {
                sb.append(firstUsr.getFtruename());
            }
            for (int i = 1; i < noPermUserIds.size(); ++i) {
                Long uId = (Long)noPermUserIds.get(i);
                User uu = (User)userInfoMapByIds.get(uId);
                if (null == uu) continue;
                sb.append('\uff0c').append(uu.getFtruename());
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7528\u6237\u4e0d\u5728\u60a8\u7684\u7ba1\u8f96\u8303\u56f4\u5185%1$s\u3002", (String)"UserCopyPermPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), sb.toString()), Integer.valueOf(5000));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        IFormView view;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(CONFIRMCALLBACK_SAVE) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes) && (view = this.getView()) != null) {
            IDataModel model = view.getModel();
            boolean isCopyRole = (Boolean)model.getValue(PROP_COPYROLE);
            boolean isCopyBizRole = (Boolean)model.getValue(PROP_COPYBIZROLE);
            boolean isCopyDisfunperm = (Boolean)model.getValue(PROP_COPYDISFUNPERM);
            boolean isCopyUserperm = (Boolean)model.getValue("copyuserperm");
            this.copyPerm(isCopyRole, isCopyBizRole, isCopyDisfunperm, isCopyUserperm);
        }
    }

    private void copyPerm(boolean isCopyRole, boolean isCopyBizRole, boolean isCopyDisfunperm, boolean isCopyUserperm) {
        try {
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("bos");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setNumber("perm-usercopypermtaskjob" + System.currentTimeMillis());
            LocaleString captionLocalString = ResManager.getLocaleString((String)"\u7528\u6237\u590d\u5236\u6743\u9650\u5f02\u6b65\u4efb\u52a1\u7684\u6267\u884c", (String)"UserCopyPermPlugin_13", (String)SYSTEM_TYPE);
            jobInfo.setlName(captionLocalString);
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            logger.info("UserCopyPermPlugin.copyPerm JobId:{}", (Object)jobId);
            jobInfo.setTaskClassname("kd.bos.permission.formplugin.task.UserCopyPermTask");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("isCopyRole", isCopyRole);
            params.put("isCopyBizRole", isCopyBizRole);
            params.put("isCopyDisfunperm", isCopyDisfunperm);
            params.put("isCopyUserperm", isCopyUserperm);
            IDataModel dataModel = this.getModel();
            DynamicObject sourceUser = (DynamicObject)dataModel.getValue("originuser");
            String sourceUserId = sourceUser.getString("id");
            String userName = sourceUser.getString("name");
            String userNumber = sourceUser.getString("number");
            DynamicObjectCollection targetUserCollection = (DynamicObjectCollection)dataModel.getValue(PROP_TARGETUSER);
            HashSet<String> targetUserIdSet = new HashSet<String>(8);
            for (DynamicObject targetUser : targetUserCollection) {
                DynamicObject user = targetUser.getDynamicObject("fbasedataid");
                String targetUserId = user.getString("id");
                targetUserIdSet.add(targetUserId);
            }
            params.put("sourceUserId", sourceUserId);
            params.put("userName", userName);
            params.put("userNumber", userNumber);
            params.put("targetUserIdSet", targetUserIdSet);
            String formNum = this.getModel().getDataEntityType().getName();
            String appId = AppHelper.getCurAppId((String)formNum, (String)this.getView().getFormShowParameter().getAppId());
            String cloudId = AppHelper.getMetaAppInfo((String)appId).getCloudId();
            params.put("formNum", formNum);
            params.put("appIdByFormNum", appId);
            params.put("cloudId", cloudId);
            params.put("oper_id", RequestContext.get().getCurrUserId());
            params.put("oper_org_id", RequestContext.get().getOrgId());
            params.put("client_type", RequestContext.get().getClient());
            params.put("client_ip", RequestContext.get().getLoginIP());
            params.put("client_name", RequestContext.get().getClient());
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(captionLocalString.getLocaleValue());
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanStop(false);
            jobFormInfo.setClickClassName("kd.bos.permission.formplugin.task.PermTaskClick");
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
            this.getView().sendFormAction(this.getView());
        }
        catch (Exception e) {
            logger.warn("UserCopyPermPlugin.copyPerm error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"taskcloseback")) {
            this.taskCallBack(e.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map) {
            TaskInfo taskInfo;
            Map result = (Map)returnData;
            Object taskInfoObj = result.get("taskinfo");
            if (null == taskInfoObj) {
                return;
            }
            String taskInfoStr = (String)taskInfoObj;
            if (StringUtils.isNotBlank((CharSequence)taskInfoStr) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String msgType;
                String data = taskInfo.getData();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                IFormView view = this.getView();
                String msg = String.valueOf(dataMap.get("msg"));
                switch (msgType = String.valueOf(dataMap.get("msgType"))) {
                    case "errorNotice": {
                        view.showErrorNotification(msg);
                        break;
                    }
                    case "successNotice": {
                        this.getModel().setDataChanged(false);
                        this.getPageCache().remove("pgCache_custom_dataChanged");
                        Integer showTime = (Integer)dataMap.get("showTime");
                        view.getParentView().showSuccessNotification(msg, showTime);
                        view.sendFormAction(this.getView().getParentView());
                        view.close();
                        break;
                    }
                }
            }
        }
    }
}

