/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.enums.AssignModEnum;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

public class UserGroupEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(UserGroupEditPlugin.class);
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String FIELD_LONGNUMBER = "longnumber";
    public static final String ENTITY_USERGROUP = "bos_usrgrp";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (isSuperUser) {
            return;
        }
        boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (isAdminUser) {
            return;
        }
        String formId = e.getFormShowParameter().getParentFormId();
        if (formId == null || !formId.equals("bos_usergroup_treelist") && !formId.equals("ide_formdesigner")) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u8bbf\u95ee\u5f53\u524d\u9875\u9762\u3002", (String)"UserGroupEditPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Long userGroupId = (Long)this.getModel().getDataEntity().getPkValue();
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.EDIT)) {
            MutexHelper.release((String)ENTITY_USERGROUP, (String)"modifyusrgrp", (String)String.valueOf(userGroupId));
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (fsp.getStatus() == OperationStatus.ADDNEW) {
            Long parentId;
            String usrGrpStdId = (String)fsp.getCustomParam("FormShowParameter_usrGrpStd");
            if (StringUtils.isNotEmpty((String)usrGrpStdId)) {
                this.getModel().setValue("usrgrpstd", (Object)usrGrpStdId);
            }
            if ((parentId = (Long)fsp.getCustomParam("FormShowParameter_parentGroup")) == null) {
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)ENTITY_USERGROUP);
            if (dynamicObject == null) {
                return;
            }
            int mainRowIndex = this.getModel().createNewEntryRow("parententity");
            this.getModel().setValue("parentnum", (Object)parentId, mainRowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject[] objects;
        Long userGroupId = (Long)this.getModel().getDataEntity().getPkValue();
        if (userGroupId == null || userGroupId == 0L) {
            return;
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object mutexMes = fsp.getCustomParam("mutexMes");
        if (mutexMes != null) {
            this.getView().showMessage(mutexMes.toString());
        }
        QFilter qFilter = new QFilter("parent", "=", (Object)userGroupId).or(new QFilter("children", "=", (Object)userGroupId));
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"perm_usrgrp_inh", (String)"parent,children", (QFilter[])new QFilter[]{qFilter})) {
            int mainRowIndex;
            DynamicObject parent = object.getDynamicObject("parent");
            DynamicObject children = object.getDynamicObject("children");
            if (parent == null || children == null) continue;
            Long parentId = parent.getLong("id");
            if (userGroupId.equals(parentId)) {
                mainRowIndex = this.getModel().createNewEntryRow("childrenentity");
                this.getModel().setValue("childnum", (Object)children, mainRowIndex);
                continue;
            }
            mainRowIndex = this.getModel().createNewEntryRow("parententity");
            this.getModel().setValue("parentnum", (Object)parent, mainRowIndex);
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar parentTb = (Toolbar)this.getControl("parenttoolbar");
        this.addItemClickListener(parentTb, "parentadd");
        Toolbar childTb = (Toolbar)this.getControl("childtoolbar");
        this.addItemClickListener(childTb, "childadd");
        this.addClickListeners(new String[]{"btnsave"});
    }

    private void addItemClickListener(Toolbar tb, final String key) {
        tb.addItemClickListener(new ItemClickListener(){

            public void itemClick(ItemClickEvent evt) {
                String itemKey = evt.getItemKey();
                if (key.equals(itemKey)) {
                    DynamicObject usrGrpStd;
                    int childrenRowCount;
                    ArrayList<Long> objList = new ArrayList<Long>(8);
                    ArrayList<Long> parentList = new ArrayList<Long>(8);
                    ArrayList<Long> childrenList = new ArrayList<Long>(8);
                    objList.add((Long)UserGroupEditPlugin.this.getModel().getDataEntity().getPkValue());
                    int parentRowCount = UserGroupEditPlugin.this.getModel().getEntryRowCount("parententity");
                    if (parentRowCount != 0) {
                        for (int i = 0; i < parentRowCount; ++i) {
                            DynamicObject obj = (DynamicObject)UserGroupEditPlugin.this.getModel().getValue("parentnum", i);
                            Long objId = obj.getLong("id");
                            parentList.add(objId);
                        }
                    }
                    if ((childrenRowCount = UserGroupEditPlugin.this.getModel().getEntryRowCount("childrenentity")) != 0) {
                        for (int i = 0; i < childrenRowCount; ++i) {
                            DynamicObject obj = (DynamicObject)UserGroupEditPlugin.this.getModel().getValue("childnum", i);
                            Long objId = obj.getLong("id");
                            childrenList.add(objId);
                        }
                    }
                    Long usrGrpStdId = (usrGrpStd = (DynamicObject)UserGroupEditPlugin.this.getModel().getValue("usrgrpstd")) == null ? PermHelperConst.NOTCLASSIFY_STDID.longValue() : usrGrpStd.getLong("id");
                    if (key.equals("parentadd")) {
                        objList.addAll(UserGroupService.getAllRelativeGroup(parentList, childrenList, (int)0));
                    } else {
                        objList.addAll(UserGroupService.getAllRelativeGroup(parentList, childrenList, (int)1));
                    }
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)UserGroupEditPlugin.ENTITY_USERGROUP, (boolean)true);
                    lsp.setCaption(ResManager.loadKDString((String)"\u7528\u6237\u7ec4", (String)"UserGroupEditPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    if (!objList.isEmpty()) {
                        QFilter f7QFilter = new QFilter("id", "not in", objList).and("usergrouptypeid", "=", (Object)PermHelperConst.NORMAL_USERGROUPTYPE_ID).and("usrgrpstd", "=", (Object)usrGrpStdId);
                        lsp.getListFilterParameter().getQFilters().add(f7QFilter);
                    }
                    lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)UserGroupEditPlugin.this, key));
                    UserGroupEditPlugin.this.getView().showForm((FormShowParameter)lsp);
                }
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.isEmpty((String)actionId)) {
            return;
        }
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (returnData != null) {
            String entryName = actionId.equals("parentadd") ? "parententity" : "childrenentity";
            String numName = actionId.equals("parentadd") ? "parentnum" : "childnum";
            for (ListSelectedRow row : returnData) {
                Long usrGrpId = (Long)row.getPrimaryKeyValue();
                int mainRowIndex = this.getModel().createNewEntryRow(entryName);
                this.getModel().setValue(numName, (Object)usrGrpId, mainRowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate;
        String operationKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && "save".equals(operationKey = (formOperate = (FormOperate)args.getSource()).getOperateKey())) {
            Long usrGrpId = (Long)this.getModel().getDataEntity().getPkValue();
            String number = (String)this.getModel().getValue("number");
            String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
            if (StringUtils.isEmpty((String)number)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserGroupEditPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((String)name)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UserGroupEditPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_USERGROUP, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number).and("id", "!=", (Object)usrGrpId)});
            if (dynamicObject != null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"UserGroupEditPlugin_4", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_USERGROUP, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name).and("id", "!=", (Object)usrGrpId)});
            if (dynamicObject != null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\u3002", (String)"UserGroupEditPlugin_5", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (StringUtils.isEmpty((String)parentPageId)) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        if ("save".equals(operateKey)) {
            if (parentView != null) {
                String message = this.save();
                if (message == null) {
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u201c\u7528\u6237\u7ec4\u201d\u4fdd\u5b58\u6210\u529f\u3002", (String)"UserGroupEditPlugin_6", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                    DynamicObject usrGrpStd = (DynamicObject)this.getModel().getValue("usrgrpstd");
                    Long usrGrpStdId = usrGrpStd == null ? PermHelperConst.NOTCLASSIFY_STDID.longValue() : usrGrpStd.getLong("id");
                    TreeView tree = (TreeView)parentView.getControl("treeview");
                    if (tree != null) {
                        UserGroupService.initTree((TreeView)tree, (String)ID_ROOTNODE, (Long)usrGrpStdId);
                    }
                } else {
                    if ("notExist".equals(message)) {
                        return;
                    }
                    parentView.showErrorNotification(ResManager.loadKDString((String)"\u201c\u7528\u6237\u7ec4\u201d\u4fdd\u5b58\u5931\u8d25:", (String)"UserGroupEditPlugin_7", (String)"bos-permission-formplugin", (Object[])new Object[0]) + message + "\u3002");
                }
                this.getView().sendFormAction(parentView);
            }
            this.getModel().setDataChanged(false);
        }
    }

    private String save() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Long usrGrpId = (Long)this.getModel().getDataEntity().getPkValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)usrGrpId, (String)ENTITY_USERGROUP);
        if (dynamicObject == null) {
            return "notExist";
        }
        EntryGrid parentEntity = (EntryGrid)this.getControl("parententity");
        DynamicObject[] parents = parentEntity.getEntryData().getDataEntitys();
        EntryGrid childrenEntity = (EntryGrid)this.getControl("childrenentity");
        DynamicObject[] children = childrenEntity.getEntryData().getDataEntitys();
        ArrayList<Long> childUserGroupIds = new ArrayList<Long>(8);
        ArrayList<Long> parentUserGroupIds = new ArrayList<Long>(8);
        for (DynamicObject parent : parents) {
            parentUserGroupIds.add((Long)((DynamicObject)parent.get("parentnum")).getPkValue());
        }
        for (Object child : children) {
            childUserGroupIds.add((Long)((DynamicObject)child.get("childnum")).getPkValue());
        }
        StringBuilder wrongMessage = new StringBuilder();
        try (TXHandle h = TX.required();){
            int childrenCount;
            if (!(!status.equals((Object)OperationStatus.EDIT) || UserGroupService.userGroupBeInherited((Long)usrGrpId, null, (AssignModEnum)AssignModEnum.ASSIGNMODE_CANCEL, (StringBuilder)wrongMessage) && UserGroupService.userGroupInherit((Long)usrGrpId, null, (AssignModEnum)AssignModEnum.ASSIGNMODE_CANCEL, (StringBuilder)wrongMessage))) {
                Object child;
                logger.warn(wrongMessage.toString());
                child = wrongMessage.toString();
                return child;
            }
            int parentCount = this.getModel().getEntryRowCount("parententity");
            if ((parentCount != 0 && !UserGroupService.userGroupInherit((Long)usrGrpId, parentUserGroupIds, (AssignModEnum)AssignModEnum.ASSIGNMODE_REPLACE, (StringBuilder)wrongMessage)) | ((childrenCount = this.getModel().getEntryRowCount("childrenentity")) != 0 && !UserGroupService.userGroupBeInherited((Long)usrGrpId, childUserGroupIds, (AssignModEnum)AssignModEnum.ASSIGNMODE_REPLACE, (StringBuilder)wrongMessage))) {
                logger.warn(wrongMessage.toString());
                String string = wrongMessage.toString();
                return string;
            }
            try {
                if (childrenCount != 0) {
                    UserGroupService.userGroupsResetParentGroup(childUserGroupIds, (Long)usrGrpId);
                }
            }
            catch (Exception e) {
                logger.warn(wrongMessage.toString(), (Throwable)e);
                h.markRollback();
                String string = wrongMessage.toString();
                return string;
            }
        }
        return null;
    }
}

