/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.log.model.PermLogBusiType;
import kd.bos.permission.log.service.PermLogService;
import kd.bos.permission.service.UserGroupService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class UserGroupListPlugin
extends AbstractTreeListPlugin {
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String TREE_USERGROUP = "treeview";
    private static final String CONFIRMCALLBACK_DELUSERGROUP = "confirmCallBack_deleteUserGroup";
    private static final String SYSTEM_TYPE = "bos-permission-formplugin";
    private static final String USERGROUP_INH_MAIN_ENTITY_TYPE = "perm_usrgrp_inh";
    private static final String USERGROUP_INH_PROP_PARENT = "parent";
    private static final String USERGROUP_INH_PROP_CHILDREN = "children";
    private static final String BTN_NEW = "tblnew";
    private static final String BTN_DEL = "tbldel";
    private static final String BTN_ASSIGNUSER = "tblassignuser";
    private static final String SHOWUSER = "showuser";
    private static final String FORMSHOWPARAMETER_NOTPERMPAGE = "FormShowParameter_notPermPage";
    private static final String BTN_ASSIGNBIZROLE = "tblassignbizrole";
    private static final String BTN_REFRESH = "tblrefresh";
    private static final String BTN_SYNCUSERRULE = "tblsyncuserrule";
    public static final String CLOSECALLBACK_REFRESH = "closecallback_refresh";
    private static final Log logger = LogFactory.getLog(UserGroupListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (CONFIRMCALLBACK_DELUSERGROUP.equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Long usrGrpId = (Long)rows.get(0).getPrimaryKeyValue();
            try (TXHandle h = TX.required();){
                try {
                    UserGroupService.deleteUsrGrpRelatedData((Long)usrGrpId);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"UserGroupListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    this.refresh();
                }
                catch (Exception e) {
                    logger.warn("\u5220\u9664\u7528\u6237\u7ec4\u5931\u8d25", (Throwable)e);
                    h.markRollback();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"UserGroupListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
        }
    }

    protected QFilter nodeClickFilter() {
        TreeView userGroupTree;
        QFilter resultFilter = null;
        String focusNodeId = this.getView().getPageCache().get("focusNodeId");
        if (StringUtils.isEmpty((String)focusNodeId) && StringUtils.isEmpty((String)(focusNodeId = (userGroupTree = (TreeView)this.getControl(TREE_USERGROUP)).getTreeState().getFocusNodeId()))) {
            return null;
        }
        HashSet<Long> userGroupIds = new HashSet<Long>();
        Long usrGrpStdId = Long.valueOf((String)this.getModel().getValue("usrgrpstd"));
        if (!ID_ROOTNODE.equals(focusNodeId)) {
            focusNodeId = focusNodeId.split("-")[0];
            userGroupIds.add(Long.valueOf(focusNodeId));
            if (this.isIncludeNextLevel()) {
                DynamicObject[] objects = BusinessDataServiceHelper.load((String)USERGROUP_INH_MAIN_ENTITY_TYPE, (String)"parent,children", null);
                Set allChildrenGroup = UserGroupService.getAllParentOrChildrenGroup((DynamicObject[])objects, (Long)Long.valueOf(focusNodeId), (int)1);
                userGroupIds.addAll(allChildrenGroup);
            }
        } else {
            DynamicObject[] objects;
            for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"bos_usrgrp", (String)"id", (QFilter[])new QFilter[]{new QFilter("usrgrpstd", "=", (Object)usrGrpStdId)})) {
                userGroupIds.add(object.getLong("id"));
            }
        }
        resultFilter = new QFilter("id", "in", userGroupIds);
        return resultFilter;
    }

    private boolean isIncludeNextLevel() {
        boolean isIncludeNextLevel = true;
        Object includeChild = this.getModel().getValue("chkincludechild");
        if (includeChild != null) {
            isIncludeNextLevel = Boolean.parseBoolean(includeChild.toString());
        }
        return isIncludeNextLevel;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        String itemKey = evt.getItemKey();
        String mustChooseTips = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c\u7528\u6237\u7ec4\u201d\u8282\u70b9\u3002", (String)"UserGroupListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String mostOneTips = ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u201c\u7528\u6237\u7ec4\u201d\u6570\u636e\u3002", (String)"UserGroupListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        switch (itemKey) {
            case "tblnew": {
                if (rows.size() > 1) {
                    this.getView().showTipNotification(mostOneTips);
                    return;
                }
                BaseShowParameter bsp = new BaseShowParameter();
                bsp.setFormId("bos_usrgrp");
                bsp.setStatus(OperationStatus.ADDNEW);
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                if (rows.isEmpty()) {
                    bsp.setCustomParam("FormShowParameter_usrGrpStd", this.getModel().getValue("usrgrpstd"));
                } else {
                    Long usrGrpId = (Long)rows.get(0).getPrimaryKeyValue();
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)usrGrpId, (String)"bos_usrgrp");
                    DynamicObject usrGrpStd = dynamicObject.getDynamicObject("usrgrpstd");
                    if (usrGrpStd != null) {
                        bsp.setCustomParam("FormShowParameter_usrGrpStd", (Object)String.valueOf(usrGrpStd.getPkValue()));
                    }
                }
                if (rows.size() == 1) {
                    bsp.setCustomParam("FormShowParameter_parentGroup", rows.get(0).getPrimaryKeyValue());
                }
                bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_REFRESH));
                bsp.setStatus(OperationStatus.ADDNEW);
                this.getView().showForm((FormShowParameter)bsp);
                break;
            }
            case "tbldel": {
                if (rows.isEmpty()) {
                    this.getView().showTipNotification(mustChooseTips);
                    return;
                }
                if (rows.size() > 1) {
                    this.getView().showTipNotification(mostOneTips);
                    return;
                }
                Long usrGrpId = (Long)rows.get(0).getPrimaryKeyValue();
                String usrGrpName = rows.get(0).getName();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_usergroupstaff", (String)"id", (QFilter[])new QFilter[]{new QFilter("usergroup", "=", (Object)usrGrpId).and(new QFilter("user.enable", "=", (Object)Boolean.TRUE))});
                if (dynamicObject != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6237\u7ec4\u201c%s\u201d\u5220\u9664\u4e0d\u6210\u529f\uff0c\u56e0\u4e3a\u8be5\u7528\u6237\u7ec4\u4e0b\u8fd8\u5b58\u5728\u7528\u6237\u3002", (String)"UserGroupListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[]{usrGrpName}));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u7528\u6237\u5206\u7ec4 \u201c%s\u201d\uff1f\r\n\u5220\u9664\u7528\u6237\u7ec4\u4ee3\u8868\u5220\u9664\u8be5\u7528\u6237\u7ec4\u5bf9\u5e94\u7684\u7ec4\u4e0e\u7ec4\u7ee7\u627f\u5173\u7cfb\u3001\u7ec4\u548c\u4eba\u5458\u7684\u5173\u7cfb\u3002", (String)"UserGroupListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[]{usrGrpName}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMCALLBACK_DELUSERGROUP));
                break;
            }
            case "tblassignuser": {
                if (rows.isEmpty()) {
                    this.getView().showTipNotification(mustChooseTips);
                    return;
                }
                if (rows.size() > 1) {
                    this.getView().showTipNotification(mostOneTips);
                    return;
                }
                FormShowParameter fsp = new FormShowParameter();
                String usrGrp = String.valueOf(rows.get(0).getPrimaryKeyValue());
                fsp.setCustomParam("usrgrpid", (Object)usrGrp);
                fsp.setCustomParam("formIdentity", (Object)"bos_usrgrp");
                boolean enablePermLog = PermCommonUtil.isEnablePermLog();
                if (enablePermLog) {
                    PermLogBusiType permLogBusiType = PermLogService.getPermLogBusiType((String)"usergroup_manageuser");
                    fsp.setCustomParam("permLogBusiType", (Object)(null == permLogBusiType ? "" : permLogBusiType.getBusiType()));
                } else {
                    fsp.setCustomParam("permLogBusiType", (Object)"");
                }
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setFormId("perm_usrgrpassignuser");
                this.getView().showForm(fsp);
                break;
            }
            case "showuser": {
                String parentPageId = this.getView().getPageId();
                String prePageId = parentPageId + "_showForm_" + "bos_usergroup_user";
                IFormView iformView = this.getView().getView(prePageId);
                if (iformView != null) {
                    PermCommonUtil.redirectToExistedPage((String)prePageId, (IFormView)this.getView());
                    return;
                }
                ListShowParameter lsp = new ListShowParameter();
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                lsp.setBillFormId("bos_usergroup_user");
                lsp.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u7528\u6237", (String)"UserGroupListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                lsp.setCustomParam(FORMSHOWPARAMETER_NOTPERMPAGE, (Object)"true");
                lsp.setHasRight(true);
                lsp.setPageId(prePageId);
                this.getView().showForm((FormShowParameter)lsp);
                break;
            }
            case "tblsyncuserrule": {
                if (rows.isEmpty()) {
                    this.getView().showTipNotification(mustChooseTips);
                    return;
                }
                if (rows.size() > 1) {
                    this.getView().showTipNotification(mostOneTips);
                    return;
                }
                FormShowParameter fsp_syncuserrule = new FormShowParameter();
                Long ugId = (Long)rows.get(0).getPrimaryKeyValue();
                String pageId = ugId + this.getView().getPageId() + "_syncuserrule";
                IFormView newFv = this.getView().getView(pageId);
                if (newFv != null) {
                    PermCommonUtil.redirectToExistedPage((String)pageId, (IFormView)this.getView());
                    return;
                }
                fsp_syncuserrule.setPageId(pageId);
                fsp_syncuserrule.setCustomParam("usrgrpid", (Object)ugId);
                fsp_syncuserrule.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsp_syncuserrule.setFormId("perm_usrgrpsyncrule_new");
                fsp_syncuserrule.setStatus(OperationStatus.EDIT);
                this.getView().showForm(fsp_syncuserrule);
                break;
            }
            case "tblassignbizrole": {
                if (rows.isEmpty()) {
                    this.getView().showTipNotification(mustChooseTips);
                    return;
                }
                if (rows.size() > 1) {
                    this.getView().showTipNotification(mostOneTips);
                    return;
                }
                FormShowParameter fsp2 = new FormShowParameter();
                Long usrGrp2 = (Long)rows.get(0).getPrimaryKeyValue();
                String newPageId = usrGrp2 + this.getView().getPageId() + "_assignbizrole";
                IFormView newFv2 = this.getView().getView(newPageId);
                if (newFv2 != null) {
                    PermCommonUtil.redirectToExistedPage((String)newPageId, (IFormView)this.getView());
                    return;
                }
                fsp2.setPageId(newPageId);
                fsp2.setCustomParam("usrgrpid", (Object)usrGrp2);
                fsp2.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsp2.setFormId("perm_usrgrpassignbizrole");
                this.getView().showForm(fsp2);
                break;
            }
            case "tblrefresh": {
                this.refresh();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getActionId().equals(CLOSECALLBACK_REFRESH)) {
            this.refresh();
        }
    }

    private void refresh() {
        String curUsrGrpStd = (String)this.getModel().getValue("usrgrpstd");
        String focusNodeId = this.getView().getPageCache().get("focusNodeId");
        String parentId = this.getView().getPageCache().get("focusNodeParentId");
        ComboEdit comboEdit = (ComboEdit)this.getControl("usrgrpstd");
        comboEdit.setMustInput(true);
        List usrGrpStds = UserGroupService.getAllUsrGrpStd();
        comboEdit.setComboItems(usrGrpStds);
        TreeView tree = (TreeView)this.getControl(TREE_USERGROUP);
        boolean curUsrGrpStdStillExists = false;
        for (ComboItem item : usrGrpStds) {
            if (!curUsrGrpStd.equals(item.getValue())) continue;
            curUsrGrpStdStillExists = true;
            break;
        }
        if (curUsrGrpStdStillExists) {
            this.getModel().setValue("usrgrpstd", (Object)curUsrGrpStd);
            UserGroupService.initTree((TreeView)tree, (String)ID_ROOTNODE, (Long)Long.valueOf(curUsrGrpStd));
        } else {
            this.getModel().setValue("usrgrpstd", (Object)"1404221671421785088");
            UserGroupService.initTree((TreeView)tree, (String)ID_ROOTNODE);
        }
        if (StringUtils.isNotEmpty((String)focusNodeId) && StringUtils.isNotEmpty((String)parentId)) {
            tree.treeNodeClick(parentId, focusNodeId);
        } else {
            tree.treeNodeClick("", ID_ROOTNODE);
        }
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        boolean notPermPage = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam(FORMSHOWPARAMETER_NOTPERMPAGE));
        if (notPermPage) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
        }
    }
}

