/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.formplugin.plugin;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class UserGroupSettingPlugin
extends AbstractFormPlugin {
    private static final String BTN_PWDSETTING = "btn_pwdsetting";
    private static final String PROP_USERGROUP = "usergroup";
    private static final String PSW_SETTING = "psw_setting";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_PWDSETTING});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        long userId = RequestContext.get().getCurrUserId();
        String appId = e.getFormShowParameter().getAppId();
        String formId = e.getFormShowParameter().getFormId();
        if (!PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)formId, (String)"47150e89000000ac")) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u65e0\u6743\u8bbf\u95ee\u5f53\u524d\u9875\u9762\u3002", (String)"UserGroupSettingPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        QFilter[] qfArr;
        ORM orm;
        DynamicObjectCollection col;
        String parameter_notPermPage;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && Boolean.parseBoolean(parameter_notPermPage = parentView.getPageCache().get("FormShowParameter_notPermPage"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"parameter_notPermPage", "pswstrategy", "flexpanelap3", "btnsave"});
        }
        if ((col = (orm = ORM.create()).query("bos_usergroupstaff", "id, usergroup", qfArr = new QFilter[]{new QFilter("user", "=", this.getModel().getDataEntity().getPkValue())})).size() > 0) {
            Object[] objects = new Object[col.size()];
            for (int i = 0; i < col.size(); ++i) {
                objects[i] = ((DynamicObject)col.get(i)).get(PROP_USERGROUP);
            }
            this.getModel().setValue(PROP_USERGROUP, (Object)objects);
            this.getModel().setDataChanged(false);
        }
        String curMmScheme = this.getCurMmScheme();
        this.getPageCache().put("MMSCHEME", curMmScheme);
        String userId = this.getModel().getValue("id").toString();
        if (Objects.equals(userId, String.valueOf(RequestContext.get().getCurrUserId()))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnsave"});
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            String key;
            Button button = (Button)source;
            switch (key = button.getKey()) {
                case "btn_pwdsetting": {
                    String cachedMmScheme;
                    String userId = this.getModel().getValue("id").toString();
                    if (Objects.equals(userId, String.valueOf(RequestContext.get().getCurrUserId()))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bf9\u81ea\u5df1\u91cd\u7f6e\u5bc6\u7801\uff0c\u8bf7\u901a\u8fc7\u3010\u4e2a\u4eba\u8bbe\u7f6e-\u4fee\u6539\u5bc6\u7801\u3011\u5904\u7406\u3002", (String)"UserGroupSettingPlugin_1", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String curMmScheme = this.getCurMmScheme();
                    if (!Objects.equals(curMmScheme, cachedMmScheme = this.getPageCache().get("MMSCHEME"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u7b56\u7565\u91cd\u65b0\u9009\u62e9\u540e\uff0c\u8bf7\u5148\u4fdd\u5b58\u624d\u53ef\u4ee5\u8bbe\u7f6e\u5bc6\u7801\u3002", (String)"UserGroupSettingPlugin_2", (String)"bos-permission-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.showPwdSettingForm(userId);
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            HashSet propNameSet = Sets.newHashSet((Object[])new String[]{"useenddate", "pswstrategy_id"});
            Iterable bizChangedProperties = this.getModel().getDataEntity().getDataEntityState().getBizChangedProperties();
            for (IDataEntityProperty bizChangedProperty : bizChangedProperties) {
                String name = bizChangedProperty.getName();
                if (propNameSet.contains(name)) continue;
                args.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u975e\u6cd5\u5c5e\u6027\u53d8\u52a8\u3002", (String)"UserGroupSettingPlugin_3", (String)"bos-permission-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "save": {
                OperationResult operationResult = e.getOperationResult();
                if (null == operationResult || !operationResult.isSuccess()) break;
                String curMmScheme = this.getCurMmScheme();
                this.getPageCache().put("MMSCHEME", curMmScheme);
                break;
            }
        }
    }

    private String getCurMmScheme() {
        Object MMSCHEME = this.getModel().getValue("pswstrategy");
        String curMmScheme = null == MMSCHEME ? "0" : ((DynamicObject)MMSCHEME).getString("id");
        return curMmScheme;
    }

    private void showPwdSettingForm(String userId) {
        FormShowParameter params = new FormShowParameter();
        params.setFormId("bos_passwordsetting");
        params.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> customMap = new HashMap<String, String>();
        customMap.put("userId", userId);
        params.setCustomParams(customMap);
        params.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PSW_SETTING));
        this.getView().showForm(params);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnDataObj;
        String actionId = e.getActionId();
        if (PSW_SETTING.equals(actionId) && (returnDataObj = e.getReturnData()) != null) {
            this.getView().showSuccessNotification(returnDataObj.toString());
        }
    }
}

